/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.SimpleFormat;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.raw.RawObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCatalog
implements Catalog {
    private static final Map<String, Class> keywordToPrimitive = new HashMap<String, Class>(8);
    private static final Map<Class, Class> primitiveTypeToWrapper;
    private static final SimpleCatalog instance;
    private List<SimpleFormat> formatList;
    private Map<String, SimpleFormat> formatMap;

    static SimpleCatalog getInstance() {
        return instance;
    }

    static boolean isSimpleType(Class clazz) {
        return SimpleCatalog.instance.formatMap.containsKey(clazz.getName());
    }

    static Class primitiveToWrapper(Class clazz) {
        Class clazz2 = primitiveTypeToWrapper.get(clazz);
        if (clazz2 == null) {
            throw new IllegalStateException(clazz.getName());
        }
        return clazz2;
    }

    public static Class keyClassForName(String string) {
        Class clazz = keywordToPrimitive.get(string);
        if (clazz != null) {
            clazz = primitiveTypeToWrapper.get(clazz);
        } else {
            try {
                clazz = EntityModel.classForName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException("Key class not found: " + string);
            }
        }
        return clazz;
    }

    public static String keyClassName(String string) {
        Class clazz = keywordToPrimitive.get(string);
        if (clazz != null) {
            clazz = primitiveTypeToWrapper.get(clazz);
            return clazz.getName();
        }
        return string;
    }

    public static Class classForName(String string) throws ClassNotFoundException {
        Class clazz = keywordToPrimitive.get(string);
        if (clazz == null) {
            clazz = EntityModel.classForName(string);
        }
        return clazz;
    }

    static SimpleFormat getSimpleFormat(Class clazz) {
        return SimpleCatalog.instance.formatMap.get(clazz.getName());
    }

    static List<Format> copyFormatList() {
        return new ArrayList<Format>(SimpleCatalog.instance.formatList);
    }

    static boolean copyMissingFormats(List<Format> list) {
        boolean bl = false;
        for (int i = 0; i <= 30; ++i) {
            Format format = SimpleCatalog.instance.formatList.get(i);
            Format format2 = list.get(i);
            if (format == null || format2 != null) continue;
            list.set(i, format);
            bl = true;
        }
        return bl;
    }

    private SimpleCatalog() {
        int n = 60;
        this.formatList = new ArrayList<SimpleFormat>(n);
        this.formatMap = new HashMap<String, SimpleFormat>(n);
        for (int i = 0; i <= 30; ++i) {
            this.formatList.add(null);
        }
        this.setFormat(2, new SimpleFormat.FBool(true));
        this.setFormat(3, new SimpleFormat.FBool(false));
        this.setFormat(4, new SimpleFormat.FByte(true));
        this.setFormat(5, new SimpleFormat.FByte(false));
        this.setFormat(6, new SimpleFormat.FShort(true));
        this.setFormat(7, new SimpleFormat.FShort(false));
        this.setFormat(8, new SimpleFormat.FInt(true));
        this.setFormat(9, new SimpleFormat.FInt(false));
        this.setFormat(10, new SimpleFormat.FLong(true));
        this.setFormat(11, new SimpleFormat.FLong(false));
        this.setFormat(12, new SimpleFormat.FFloat(true));
        this.setFormat(13, new SimpleFormat.FFloat(false));
        this.setFormat(14, new SimpleFormat.FDouble(true));
        this.setFormat(15, new SimpleFormat.FDouble(false));
        this.setFormat(16, new SimpleFormat.FChar(true));
        this.setFormat(17, new SimpleFormat.FChar(false));
        this.setFormat(18, new SimpleFormat.FString());
        this.setFormat(19, new SimpleFormat.FBigInt());
        this.setFormat(21, new SimpleFormat.FDate());
        this.setWrapper(2, 3);
        this.setWrapper(4, 5);
        this.setWrapper(6, 7);
        this.setWrapper(8, 9);
        this.setWrapper(10, 11);
        this.setWrapper(12, 13);
        this.setWrapper(14, 15);
        this.setWrapper(16, 17);
    }

    private void setFormat(int n, SimpleFormat simpleFormat) {
        simpleFormat.setId(n);
        simpleFormat.initializeIfNeeded(this, null);
        this.formatList.set(n, simpleFormat);
        this.formatMap.put(simpleFormat.getClassName(), simpleFormat);
    }

    private void setWrapper(int n, int n2) {
        SimpleFormat simpleFormat = this.formatList.get(n);
        SimpleFormat simpleFormat2 = this.formatList.get(n2);
        simpleFormat.setWrapperFormat(simpleFormat2);
    }

    @Override
    public int getInitVersion(Format format, boolean bl) {
        return 1;
    }

    @Override
    public Format getFormat(int n) {
        try {
            Format format = this.formatList.get(n);
            if (format == null) {
                throw new IllegalStateException("Not a simple type: " + n);
            }
            return format;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalStateException("Not a simple type: " + n);
        }
    }

    @Override
    public Format getFormat(Class clazz, boolean bl) {
        Format format = this.formatMap.get(clazz.getName());
        if (format == null) {
            throw new IllegalArgumentException("Not a simple type: " + clazz.getName());
        }
        return format;
    }

    @Override
    public Format getFormat(String string) {
        return this.formatMap.get(string);
    }

    @Override
    public Format createFormat(String string, Map<String, Format> map) {
        throw new IllegalStateException();
    }

    @Override
    public Format createFormat(Class clazz, Map<String, Format> map) {
        throw new IllegalStateException();
    }

    @Override
    public boolean isRawAccess() {
        return false;
    }

    @Override
    public Object convertRawObject(RawObject rawObject, IdentityHashMap identityHashMap) {
        throw new IllegalStateException();
    }

    static {
        keywordToPrimitive.put("boolean", Boolean.TYPE);
        keywordToPrimitive.put("char", Character.TYPE);
        keywordToPrimitive.put("byte", Byte.TYPE);
        keywordToPrimitive.put("short", Short.TYPE);
        keywordToPrimitive.put("int", Integer.TYPE);
        keywordToPrimitive.put("long", Long.TYPE);
        keywordToPrimitive.put("float", Float.TYPE);
        keywordToPrimitive.put("double", Double.TYPE);
        primitiveTypeToWrapper = new HashMap<Class, Class>(8);
        primitiveTypeToWrapper.put(Boolean.TYPE, Boolean.class);
        primitiveTypeToWrapper.put(Character.TYPE, Character.class);
        primitiveTypeToWrapper.put(Byte.TYPE, Byte.class);
        primitiveTypeToWrapper.put(Short.TYPE, Short.class);
        primitiveTypeToWrapper.put(Integer.TYPE, Integer.class);
        primitiveTypeToWrapper.put(Long.TYPE, Long.class);
        primitiveTypeToWrapper.put(Float.TYPE, Float.class);
        primitiveTypeToWrapper.put(Double.TYPE, Double.class);
        instance = new SimpleCatalog();
    }
}

