/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.raw.RawObject;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReadOnlyCatalog
implements Catalog {
    private List<Format> formatList;
    private Map<String, Format> formatMap;

    ReadOnlyCatalog(List<Format> list, Map<String, Format> map) {
        this.formatList = list;
        this.formatMap = map;
    }

    @Override
    public int getInitVersion(Format format, boolean bl) {
        return 1;
    }

    @Override
    public Format getFormat(int n) {
        try {
            Format format = this.formatList.get(n);
            if (format == null) {
                throw new IllegalStateException("Format does not exist: " + n);
            }
            return format;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalStateException("Format does not exist: " + n);
        }
    }

    @Override
    public Format getFormat(Class clazz, boolean bl) {
        Format format = this.formatMap.get(clazz.getName());
        if (format == null) {
            throw new IllegalArgumentException("Class is not persistent: " + clazz.getName());
        }
        return format;
    }

    @Override
    public Format getFormat(String string) {
        return this.formatMap.get(string);
    }

    @Override
    public Format createFormat(String string, Map<String, Format> map) {
        throw new IllegalStateException();
    }

    @Override
    public Format createFormat(Class clazz, Map<String, Format> map) {
        throw new IllegalStateException();
    }

    @Override
    public boolean isRawAccess() {
        return false;
    }

    @Override
    public Object convertRawObject(RawObject rawObject, IdentityHashMap identityHashMap) {
        throw new IllegalStateException();
    }
}

