/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist;

import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.Environment;
import com.sleepycat.db.SecondaryConfig;
import com.sleepycat.db.Sequence;
import com.sleepycat.db.SequenceConfig;
import com.sleepycat.db.Transaction;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.SecondaryIndex;
import com.sleepycat.persist.StoreConfig;
import com.sleepycat.persist.StoreExistsException;
import com.sleepycat.persist.StoreNotFoundException;
import com.sleepycat.persist.evolve.EvolveConfig;
import com.sleepycat.persist.evolve.EvolveStats;
import com.sleepycat.persist.evolve.IncompatibleClassException;
import com.sleepycat.persist.evolve.Mutations;
import com.sleepycat.persist.impl.Store;
import com.sleepycat.persist.model.EntityModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityStore {
    private Store store;

    public EntityStore(Environment environment, String string, StoreConfig storeConfig) throws StoreExistsException, StoreNotFoundException, IncompatibleClassException, DatabaseException {
        this.store = new Store(environment, string, storeConfig, false);
    }

    public Environment getEnvironment() {
        return this.store.getEnvironment();
    }

    public StoreConfig getConfig() {
        return this.store.getConfig();
    }

    public String getStoreName() {
        return this.store.getStoreName();
    }

    public EntityModel getModel() {
        return this.store.getModel();
    }

    public Mutations getMutations() {
        return this.store.getMutations();
    }

    public <PK, E> PrimaryIndex<PK, E> getPrimaryIndex(Class<PK> clazz, Class<E> clazz2) throws DatabaseException {
        return this.store.getPrimaryIndex(clazz, clazz.getName(), clazz2, clazz2.getName());
    }

    public <SK, PK, E> SecondaryIndex<SK, PK, E> getSecondaryIndex(PrimaryIndex<PK, E> primaryIndex, Class<SK> clazz, String string) throws DatabaseException {
        return this.store.getSecondaryIndex(primaryIndex, primaryIndex.getEntityClass(), primaryIndex.getEntityClass().getName(), clazz, clazz.getName(), string);
    }

    public <SK, PK, E1, E2 extends E1> SecondaryIndex<SK, PK, E2> getSubclassIndex(PrimaryIndex<PK, E1> primaryIndex, Class<E2> clazz, Class<SK> clazz2, String string) throws DatabaseException {
        this.getModel().getClassMetadata(clazz.getName());
        return this.store.getSecondaryIndex(primaryIndex, clazz, primaryIndex.getEntityClass().getName(), clazz2, clazz2.getName(), string);
    }

    public EvolveStats evolve(EvolveConfig evolveConfig) throws DatabaseException {
        return this.store.evolve(evolveConfig);
    }

    public void truncateClass(Class clazz) throws DatabaseException {
        this.store.truncateClass(null, clazz);
    }

    public void truncateClass(Transaction transaction, Class clazz) throws DatabaseException {
        this.store.truncateClass(transaction, clazz);
    }

    public void closeClass(Class clazz) throws DatabaseException {
        this.store.closeClass(clazz);
    }

    public void close() throws DatabaseException {
        this.store.close();
    }

    public Sequence getSequence(String string) throws DatabaseException {
        return this.store.getSequence(string);
    }

    public SequenceConfig getSequenceConfig(String string) {
        return this.store.getSequenceConfig(string);
    }

    public void setSequenceConfig(String string, SequenceConfig sequenceConfig) {
        this.store.setSequenceConfig(string, sequenceConfig);
    }

    public DatabaseConfig getPrimaryConfig(Class clazz) {
        return this.store.getPrimaryConfig(clazz);
    }

    public void setPrimaryConfig(Class clazz, DatabaseConfig databaseConfig) {
        this.store.setPrimaryConfig(clazz, databaseConfig);
    }

    public SecondaryConfig getSecondaryConfig(Class clazz, String string) {
        return this.store.getSecondaryConfig(clazz, string);
    }

    public void setSecondaryConfig(Class clazz, String string, SecondaryConfig secondaryConfig) {
        this.store.setSecondaryConfig(clazz, string, secondaryConfig);
    }
}

