/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredValueSet;
import com.sleepycat.db.Database;
import java.util.Comparator;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredSortedValueSet<E>
extends StoredValueSet<E>
implements SortedSet<E> {
    public StoredSortedValueSet(Database database, EntityBinding<E> entityBinding, boolean bl) {
        super(new DataView(database, null, null, entityBinding, bl, null));
        this.checkKeyDerivation();
    }

    StoredSortedValueSet(DataView dataView) {
        super(dataView);
        this.checkKeyDerivation();
    }

    private void checkKeyDerivation() {
        if (!this.view.canDeriveKeyFromValue()) {
            throw new IllegalArgumentException("Cannot derive key from value");
        }
    }

    @Override
    public Comparator<? super E> comparator() {
        return null;
    }

    @Override
    public E first() {
        return this.getFirstOrLast(true);
    }

    @Override
    public E last() {
        return this.getFirstOrLast(false);
    }

    @Override
    public SortedSet<E> headSet(E e) {
        return this.subSet(null, false, e, false);
    }

    public SortedSet<E> headSet(E e, boolean bl) {
        return this.subSet(null, false, e, bl);
    }

    @Override
    public SortedSet<E> tailSet(E e) {
        return this.subSet(e, true, null, false);
    }

    public SortedSet<E> tailSet(E e, boolean bl) {
        return this.subSet(e, bl, null, false);
    }

    @Override
    public SortedSet<E> subSet(E e, E e2) {
        return this.subSet(e, true, e2, false);
    }

    public SortedSet<E> subSet(E e, boolean bl, E e2, boolean bl2) {
        try {
            return new StoredSortedValueSet<E>(this.view.subView(e, bl, e2, bl2, null));
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }
}

