/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.util.UtfOps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringBinding
extends TupleBinding<String> {
    @Override
    public String entryToObject(TupleInput tupleInput) {
        return tupleInput.readString();
    }

    @Override
    public void objectToEntry(String string, TupleOutput tupleOutput) {
        tupleOutput.writeString(string);
    }

    @Override
    protected TupleOutput getTupleOutput(String string) {
        return StringBinding.sizedOutput(string);
    }

    public static String entryToString(DatabaseEntry databaseEntry) {
        return StringBinding.entryToInput(databaseEntry).readString();
    }

    public static void stringToEntry(String string, DatabaseEntry databaseEntry) {
        StringBinding.outputToEntry(StringBinding.sizedOutput(string).writeString(string), databaseEntry);
    }

    private static TupleOutput sizedOutput(String string) {
        int n = string == null ? 1 : UtfOps.getByteLength(string.toCharArray());
        return new TupleOutput(new byte[++n]);
    }
}

