/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.db.DatabaseEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortBinding
extends TupleBinding<Short> {
    private static final int SHORT_SIZE = 2;

    @Override
    public Short entryToObject(TupleInput tupleInput) {
        return tupleInput.readShort();
    }

    @Override
    public void objectToEntry(Short s, TupleOutput tupleOutput) {
        tupleOutput.writeShort(s.shortValue());
    }

    @Override
    protected TupleOutput getTupleOutput(Short s) {
        return ShortBinding.sizedOutput();
    }

    public static short entryToShort(DatabaseEntry databaseEntry) {
        return ShortBinding.entryToInput(databaseEntry).readShort();
    }

    public static void shortToEntry(short s, DatabaseEntry databaseEntry) {
        ShortBinding.outputToEntry(ShortBinding.sizedOutput().writeShort(s), databaseEntry);
    }

    private static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[2]);
    }
}

