/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.model;

import com.sleepycat.persist.model.ClassMetadata;
import com.sleepycat.persist.model.DeleteAction;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.model.FieldMetadata;
import com.sleepycat.persist.model.KeyField;
import com.sleepycat.persist.model.Persistent;
import com.sleepycat.persist.model.PrimaryKey;
import com.sleepycat.persist.model.PrimaryKeyMetadata;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKey;
import com.sleepycat.persist.model.SecondaryKeyMetadata;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnnotationModel
extends EntityModel {
    private Map<String, ClassMetadata> classMap = new HashMap<String, ClassMetadata>();
    private Map<String, EntityInfo> entityMap = new HashMap<String, EntityInfo>();

    @Override
    public synchronized Set<String> getKnownClasses() {
        return Collections.unmodifiableSet(new HashSet<String>(this.classMap.keySet()));
    }

    @Override
    public synchronized EntityMetadata getEntityMetadata(String string) {
        this.getClassMetadata(string);
        EntityInfo entityInfo = this.entityMap.get(string);
        if (entityInfo != null) {
            return new EntityMetadata(string, entityInfo.priKey, Collections.unmodifiableMap(entityInfo.secKeys));
        }
        return null;
    }

    @Override
    public synchronized ClassMetadata getClassMetadata(String string) {
        ClassMetadata classMetadata = this.classMap.get(string);
        if (classMetadata == null) {
            Serializable serializable;
            String string2;
            int n;
            boolean bl;
            Class clazz;
            try {
                clazz = EntityModel.classForName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            Entity entity = clazz.getAnnotation(Entity.class);
            Persistent persistent = clazz.getAnnotation(Persistent.class);
            if (entity == null && persistent == null) {
                return null;
            }
            if (entity != null && persistent != null) {
                throw new IllegalArgumentException("Both @Entity and @Persistent are not allowed: " + clazz.getName());
            }
            if (entity != null) {
                bl = true;
                n = entity.version();
                string2 = null;
            } else {
                bl = false;
                n = persistent.version();
                serializable = persistent.proxyFor();
                string2 = serializable != Void.TYPE ? ((Class)serializable).getName() : null;
            }
            serializable = new ArrayList();
            for (Field field : clazz.getDeclaredFields()) {
                int n2 = field.getModifiers();
                if (Modifier.isTransient(n2) || Modifier.isStatic(n2)) continue;
                serializable.add(field);
            }
            classMetadata = new ClassMetadata(string, n, string2, bl, this.getPrimaryKey(clazz, (List<Field>)((Object)serializable)), this.getSecondaryKeys(clazz, (List<Field>)((Object)serializable)), this.getCompositeKeyFields(clazz, (List<Field>)((Object)serializable)));
            this.classMap.put(string, classMetadata);
            this.updateEntityInfo(classMetadata);
        }
        return classMetadata;
    }

    private PrimaryKeyMetadata getPrimaryKey(Class<?> clazz, List<Field> list) {
        Field field = null;
        String string = null;
        for (Field field2 : list) {
            PrimaryKey primaryKey = field2.getAnnotation(PrimaryKey.class);
            if (primaryKey == null) continue;
            if (field != null) {
                throw new IllegalArgumentException("Only one @PrimaryKey allowed: " + clazz.getName());
            }
            field = field2;
            string = primaryKey.sequence();
            if (string.length() != 0) continue;
            string = null;
        }
        if (field != null) {
            return new PrimaryKeyMetadata(field.getName(), field.getType().getName(), clazz.getName(), string);
        }
        return null;
    }

    private Map<String, SecondaryKeyMetadata> getSecondaryKeys(Class<?> clazz, List<Field> list) {
        Map<String, SecondaryKeyMetadata> map = null;
        for (Field field : list) {
            Class clazz2;
            String string;
            SecondaryKey secondaryKey = field.getAnnotation(SecondaryKey.class);
            if (secondaryKey == null) continue;
            Relationship relationship = secondaryKey.relate();
            String string2 = null;
            if (relationship == Relationship.ONE_TO_MANY || relationship == Relationship.MANY_TO_MANY) {
                string2 = this.getElementClass(field);
            }
            if ((string = secondaryKey.name()).length() == 0) {
                string = field.getName();
            }
            String string3 = (clazz2 = secondaryKey.relatedEntity()) != Void.TYPE ? clazz2.getName() : null;
            DeleteAction deleteAction = string3 != null ? secondaryKey.onRelatedEntityDelete() : null;
            SecondaryKeyMetadata secondaryKeyMetadata = new SecondaryKeyMetadata(field.getName(), field.getType().getName(), clazz.getName(), string2, string, relationship, string3, deleteAction);
            if (map == null) {
                map = new HashMap();
            }
            if (map.put(string, secondaryKeyMetadata) == null) continue;
            throw new IllegalArgumentException("Only one @SecondaryKey with the same name allowed: " + clazz.getName() + '.' + string);
        }
        if (map != null) {
            map = Collections.unmodifiableMap(map);
        }
        return map;
    }

    private String getElementClass(Field field) {
        Class<?> clazz = field.getType();
        if (clazz.isArray()) {
            return clazz.getComponentType().getName();
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Type[] typeArray = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
            if (typeArray == null || typeArray.length != 1 || !(typeArray[0] instanceof Class)) {
                throw new IllegalArgumentException("Collection typed secondary key field must have a single generic type argument: " + field.getDeclaringClass().getName() + '.' + field.getName());
            }
            return ((Class)typeArray[0]).getName();
        }
        throw new IllegalArgumentException("ONE_TO_MANY or MANY_TO_MANY secondary key field must have an array or Collection type: " + field.getDeclaringClass().getName() + '.' + field.getName());
    }

    private List<FieldMetadata> getCompositeKeyFields(Class<?> clazz, List<Field> list) {
        List list2 = null;
        for (Field field : list) {
            KeyField keyField = field.getAnnotation(KeyField.class);
            if (keyField == null) continue;
            int n = keyField.value();
            if (n < 1 || n > list.size()) {
                throw new IllegalArgumentException("Unreasonable @KeyField index value " + n + ": " + clazz.getName());
            }
            if (list2 == null) {
                list2 = new ArrayList(list.size());
            }
            if (n <= list2.size() && list2.get(n - 1) != null) {
                throw new IllegalArgumentException("@KeyField index value " + n + " is used more than once: " + clazz.getName());
            }
            while (n > list2.size()) {
                list2.add(null);
            }
            FieldMetadata fieldMetadata = new FieldMetadata(field.getName(), field.getType().getName(), clazz.getName());
            list2.set(n - 1, fieldMetadata);
        }
        if (list2 != null) {
            if (list2.size() < list.size()) {
                throw new IllegalArgumentException("@KeyField is missing on one or more instance fields: " + clazz.getName());
            }
            for (int i = 0; i < list2.size(); ++i) {
                if (list2.get(i) != null) continue;
                throw new IllegalArgumentException("@KeyField is missing for index value " + (i + 1) + ": " + clazz.getName());
            }
        }
        if (list2 != null) {
            list2 = Collections.unmodifiableList(list2);
        }
        return list2;
    }

    private void updateEntityInfo(ClassMetadata classMetadata) {
        String string = null;
        PrimaryKeyMetadata primaryKeyMetadata = null;
        HashMap<String, SecondaryKeyMetadata> hashMap = new HashMap<String, SecondaryKeyMetadata>();
        Object object = classMetadata;
        while (object != null) {
            Class clazz;
            Map<String, SecondaryKeyMetadata> map;
            if (((ClassMetadata)object).isEntityClass()) {
                if (string != null) {
                    throw new IllegalArgumentException("An entity class may not derived from another entity class: " + string + ' ' + ((ClassMetadata)object).getClassName());
                }
                string = ((ClassMetadata)object).getClassName();
            }
            if (primaryKeyMetadata == null) {
                primaryKeyMetadata = ((ClassMetadata)object).getPrimaryKey();
            }
            if ((map = ((ClassMetadata)object).getSecondaryKeys()) != null) {
                for (SecondaryKeyMetadata secondaryKeyMetadata : map.values()) {
                    hashMap.put(secondaryKeyMetadata.getKeyName(), secondaryKeyMetadata);
                }
            }
            try {
                clazz = EntityModel.classForName(((ClassMetadata)object).getClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalStateException(classNotFoundException);
            }
            clazz = clazz.getSuperclass();
            if (clazz != Object.class) {
                object = this.getClassMetadata(clazz.getName());
                if (object != null) continue;
                throw new IllegalArgumentException("Persistent class has non-persistent superclass: " + clazz.getName());
            }
            object = null;
        }
        if (string != null) {
            object = this.entityMap.get(string);
            if (object == null) {
                object = new EntityInfo();
                this.entityMap.put(string, (EntityInfo)object);
            }
            if (primaryKeyMetadata == null) {
                throw new IllegalArgumentException("Entity class has no primary key: " + string);
            }
            ((EntityInfo)object).priKey = primaryKeyMetadata;
            ((EntityInfo)object).secKeys.putAll(hashMap);
        }
    }

    private static class EntityInfo {
        PrimaryKeyMetadata priKey;
        Map<String, SecondaryKeyMetadata> secKeys = new HashMap<String, SecondaryKeyMetadata>();

        private EntityInfo() {
        }
    }
}

