/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Evolver;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RecordOutput;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public abstract class SimpleFormat
extends Format {
    private static final long serialVersionUID = 4595245575868697702L;
    private boolean primitive;
    private SimpleFormat wrapperFormat;

    SimpleFormat(Class clazz, boolean bl) {
        super(clazz);
        this.primitive = bl;
    }

    void setWrapperFormat(SimpleFormat simpleFormat) {
        this.wrapperFormat = simpleFormat;
    }

    @Override
    Format getWrapperFormat() {
        return this.wrapperFormat;
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public boolean isPrimitive() {
        return this.primitive;
    }

    @Override
    void collectRelatedFormats(Catalog catalog, Map<String, Format> map) {
    }

    @Override
    void initialize(Catalog catalog, int n) {
    }

    @Override
    public Object readObject(Object object, EntityInput entityInput, boolean bl) {
        return object;
    }

    @Override
    boolean evolve(Format format, Evolver evolver) {
        evolver.useOldFormat(this, format);
        return true;
    }

    Object newPrimitiveArray(int n, EntityInput entityInput) {
        throw new UnsupportedOperationException();
    }

    void writePrimitiveArray(Object object, EntityOutput entityOutput) {
        throw new UnsupportedOperationException();
    }

    int getPrimitiveLength() {
        throw new UnsupportedOperationException();
    }

    void readPrimitiveField(Object object, EntityInput entityInput, Field field) throws IllegalAccessException {
        throw new UnsupportedOperationException();
    }

    void writePrimitiveField(Object object, EntityOutput entityOutput, Field field) throws IllegalAccessException {
        throw new UnsupportedOperationException();
    }

    void skipPrimitiveArray(int n, RecordInput recordInput) {
        recordInput.skipFast(n * this.getPrimitiveLength());
    }

    void copySecMultiKeyPrimitiveArray(int n, RecordInput recordInput, Set set) {
        int n2 = this.getPrimitiveLength();
        for (int i = 0; i < n; ++i) {
            DatabaseEntry databaseEntry = new DatabaseEntry(recordInput.getBufferBytes(), recordInput.getBufferOffset(), n2);
            set.add(databaseEntry);
            recordInput.skipFast(n2);
        }
    }

    public static class FDate
    extends SimpleFormat {
        private static final long serialVersionUID = -5665773229869034145L;

        FDate() {
            super(Date.class, false);
        }

        @Override
        Object newArray(int n) {
            return new Date[n];
        }

        @Override
        public Object newInstance(EntityInput entityInput, boolean bl) {
            return new Date(entityInput.readLong());
        }

        @Override
        void writeObject(Object object, EntityOutput entityOutput, boolean bl) {
            entityOutput.writeLong(((Date)object).getTime());
        }

        @Override
        void skipContents(RecordInput recordInput) {
            recordInput.skipFast(8);
        }

        @Override
        void copySecKey(RecordInput recordInput, RecordOutput recordOutput) {
            recordOutput.writeFast(recordInput.getBufferBytes(), recordInput.getBufferOffset(), 8);
            recordInput.skipFast(8);
        }
    }

    public static class FBigInt
    extends SimpleFormat {
        private static final long serialVersionUID = -5027098112507644563L;

        FBigInt() {
            super(BigInteger.class, false);
        }

        @Override
        Object newArray(int n) {
            return new BigInteger[n];
        }

        @Override
        public Object newInstance(EntityInput entityInput, boolean bl) {
            return entityInput.readBigInteger();
        }

        @Override
        void writeObject(Object object, EntityOutput entityOutput, boolean bl) {
            entityOutput.writeBigInteger((BigInteger)object);
        }

        @Override
        void skipContents(RecordInput recordInput) {
            recordInput.skipFast(recordInput.getBigIntegerByteLength());
        }

        @Override
        void copySecKey(RecordInput recordInput, RecordOutput recordOutput) {
            int n = recordInput.getBigIntegerByteLength();
            recordOutput.writeFast(recordInput.getBufferBytes(), recordInput.getBufferOffset(), n);
            recordInput.skipFast(n);
        }
    }

    public static class FString
    extends SimpleFormat {
        private static final long serialVersionUID = 5710392786480064612L;

        FString() {
            super(String.class, false);
        }

        @Override
        Object newArray(int n) {
            return new String[n];
        }

        @Override
        public Object newInstance(EntityInput entityInput, boolean bl) {
            return entityInput.readString();
        }

        @Override
        void writeObject(Object object, EntityOutput entityOutput, boolean bl) {
            entityOutput.writeString((String)object);
        }

        @Override
        void skipContents(RecordInput recordInput) {
            recordInput.skipFast(recordInput.getStringByteLength());
        }

        @Override
        void copySecKey(RecordInput recordInput, RecordOutput recordOutput) {
            int n = recordInput.getStringByteLength();
            recordOutput.writeFast(recordInput.getBufferBytes(), recordInput.getBufferOffset(), n);
            recordInput.skipFast(n);
        }
    }

    public static class FChar
    extends SimpleFormat {
        private static final long serialVersionUID = -7609118195770005374L;

        FChar(boolean bl) {
            super(bl ? Character.TYPE : Character.class, bl);
        }

        @Override
        Object newArray(int n) {
            return new Character[n];
        }

        @Override
        public Object newInstance(EntityInput entityInput, boolean bl) {
            return Character.valueOf(entityInput.readChar());
        }

        @Override
        void writeObject(Object object, EntityOutput entityOutput, boolean bl) {
            entityOutput.writeChar(((Character)object).charValue());
        }

        @Override
        void skipContents(RecordInput recordInput) {
            recordInput.skipFast(2);
        }

        @Override
        void copySecKey(RecordInput recordInput, RecordOutput recordOutput) {
            recordOutput.writeFast(recordInput.readFast());
            recordOutput.writeFast(recordInput.readFast());
        }

        @Override
        Object newPrimitiveArray(int n, EntityInput entityInput) {
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = entityInput.readChar();
            }
            return cArray;
        }

        @Override
        void writePrimitiveArray(Object object, EntityOutput entityOutput) {
            char[] cArray = (char[])object;
            int n = cArray.length;
            entityOutput.writeArrayLength(n);
            for (int i = 0; i < n; ++i) {
                entityOutput.writeChar(cArray[i]);
            }
        }

        @Override
        int getPrimitiveLength() {
            return 2;
        }

        @Override
        void readPrimitiveField(Object object, EntityInput entityInput, Field field) throws IllegalAccessException {
            field.setChar(object, entityInput.readChar());
        }

        @Override
        void writePrimitiveField(Object object, EntityOutput entityOutput, Field field) throws IllegalAccessException {
            entityOutput.writeChar(field.getChar(object));
        }
    }

    public static class FDouble
    extends SimpleFormat {
        private static final long serialVersionUID = 646904456811041423L;

        FDouble(boolean bl) {
            super(bl ? Double.TYPE : Double.class, bl);
        }

        @Override
        Object newArray(int n) {
            return new Double[n];
        }

        @Override
        public Object newInstance(EntityInput entityInput, boolean bl) {
            return entityInput.readSortedDouble();
        }

        @Override
        void writeObject(Object object, EntityOutput entityOutput, boolean bl) {
            entityOutput.writeSortedDouble(((Number)object).doubleValue());
        }

        @Override
        void skipContents(RecordInput recordInput) {
            recordInput.skipFast(8);
        }

        @Override
        void copySecKey(RecordInput recordInput, RecordOutput recordOutput) {
            recordOutput.writeFast(recordInput.getBufferBytes(), recordInput.getBufferOffset(), 8);
            recordInput.skipFast(8);
        }

        @Override
        Object newPrimitiveArray(int n, EntityInput entityInput) {
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = entityInput.readSortedDouble();
            }
            return dArray;
        }

        @Override
        void writePrimitiveArray(Object object, EntityOutput entityOutput) {
            double[] dArray = (double[])object;
            int n = dArray.length;
            entityOutput.writeArrayLength(n);
            for (int i = 0; i < n; ++i) {
                entityOutput.writeSortedDouble(dArray[i]);
            }
        }

        @Override
        int getPrimitiveLength() {
            return 8;
        }

        @Override
        void readPrimitiveField(Object object, EntityInput entityInput, Field field) throws IllegalAccessException {
            field.setDouble(object, entityInput.readSortedDouble());
        }

        @Override
        void writePrimitiveField(Object object, EntityOutput entityOutput, Field field) throws IllegalAccessException {
            entityOutput.writeSortedDouble(field.getDouble(object));
        }
    }

    public static class FFloat
    extends SimpleFormat {
        private static final long serialVersionUID = 1033413049495053602L;

        FFloat(boolean bl) {
            super(bl ? Float.TYPE : Float.class, bl);
        }

        @Override
        Object newArray(int n) {
            return new Float[n];
        }

        @Override
        public Object newInstance(EntityInput entityInput, boolean bl) {
            return Float.valueOf(entityInput.readSortedFloat());
        }

        @Override
        void writeObject(Object object, EntityOutput entityOutput, boolean bl) {
            entityOutput.writeSortedFloat(((Number)object).floatValue());
        }

        @Override
        void skipContents(RecordInput recordInput) {
            recordInput.skipFast(4);
        }

        @Override
        void copySecKey(RecordInput recordInput, RecordOutput recordOutput) {
            recordOutput.writeFast(recordInput.readFast());
            recordOutput.writeFast(recordInput.readFast());
            recordOutput.writeFast(recordInput.readFast());
            recordOutput.writeFast(recordInput.readFast());
        }

        @Override
        Object newPrimitiveArray(int n, EntityInput entityInput) {
            float[] fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                fArray[i] = entityInput.readSortedFloat();
            }
            return fArray;
        }

        @Override
        void writePrimitiveArray(Object object, EntityOutput entityOutput) {
            float[] fArray = (float[])object;
            int n = fArray.length;
            entityOutput.writeArrayLength(n);
            for (int i = 0; i < n; ++i) {
                entityOutput.writeSortedFloat(fArray[i]);
            }
        }

        @Override
        int getPrimitiveLength() {
            return 4;
        }

        @Override
        void readPrimitiveField(Object object, EntityInput entityInput, Field field) throws IllegalAccessException {
            field.setFloat(object, entityInput.readSortedFloat());
        }

        @Override
        void writePrimitiveField(Object object, EntityOutput entityOutput, Field field) throws IllegalAccessException {
            entityOutput.writeSortedFloat(field.getFloat(object));
        }
    }

    public static class FLong
    extends SimpleFormat {
        private static final long serialVersionUID = 1872661106534776520L;

        FLong(boolean bl) {
            super(bl ? Long.TYPE : Long.class, bl);
        }

        @Override
        Object newArray(int n) {
            return new Long[n];
        }

        @Override
        public Object newInstance(EntityInput entityInput, boolean bl) {
            return entityInput.readLong();
        }

        @Override
        void writeObject(Object object, EntityOutput entityOutput, boolean bl) {
            entityOutput.writeLong(((Number)object).longValue());
        }

        @Override
        void skipContents(RecordInput recordInput) {
            recordInput.skipFast(8);
        }

        @Override
        void copySecKey(RecordInput recordInput, RecordOutput recordOutput) {
            recordOutput.writeFast(recordInput.getBufferBytes(), recordInput.getBufferOffset(), 8);
            recordInput.skipFast(8);
        }

        @Override
        Object newPrimitiveArray(int n, EntityInput entityInput) {
            long[] lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = entityInput.readLong();
            }
            return lArray;
        }

        @Override
        void writePrimitiveArray(Object object, EntityOutput entityOutput) {
            long[] lArray = (long[])object;
            int n = lArray.length;
            entityOutput.writeArrayLength(n);
            for (int i = 0; i < n; ++i) {
                entityOutput.writeLong(lArray[i]);
            }
        }

        @Override
        int getPrimitiveLength() {
            return 8;
        }

        @Override
        void readPrimitiveField(Object object, EntityInput entityInput, Field field) throws IllegalAccessException {
            field.setLong(object, entityInput.readLong());
        }

        @Override
        void writePrimitiveField(Object object, EntityOutput entityOutput, Field field) throws IllegalAccessException {
            entityOutput.writeLong(field.getLong(object));
        }

        @Override
        Format getSequenceKeyFormat() {
            return this;
        }
    }

    public static class FInt
    extends SimpleFormat {
        private static final long serialVersionUID = 2695910006049980013L;

        FInt(boolean bl) {
            super(bl ? Integer.TYPE : Integer.class, bl);
        }

        @Override
        Object newArray(int n) {
            return new Integer[n];
        }

        @Override
        public Object newInstance(EntityInput entityInput, boolean bl) {
            return entityInput.readInt();
        }

        @Override
        void writeObject(Object object, EntityOutput entityOutput, boolean bl) {
            entityOutput.writeInt(((Number)object).intValue());
        }

        @Override
        void skipContents(RecordInput recordInput) {
            recordInput.skipFast(4);
        }

        @Override
        void copySecKey(RecordInput recordInput, RecordOutput recordOutput) {
            recordOutput.writeFast(recordInput.readFast());
            recordOutput.writeFast(recordInput.readFast());
            recordOutput.writeFast(recordInput.readFast());
            recordOutput.writeFast(recordInput.readFast());
        }

        @Override
        Object newPrimitiveArray(int n, EntityInput entityInput) {
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = entityInput.readInt();
            }
            return nArray;
        }

        @Override
        void writePrimitiveArray(Object object, EntityOutput entityOutput) {
            int[] nArray = (int[])object;
            int n = nArray.length;
            entityOutput.writeArrayLength(n);
            for (int i = 0; i < n; ++i) {
                entityOutput.writeInt(nArray[i]);
            }
        }

        @Override
        int getPrimitiveLength() {
            return 4;
        }

        @Override
        void readPrimitiveField(Object object, EntityInput entityInput, Field field) throws IllegalAccessException {
            field.setInt(object, entityInput.readInt());
        }

        @Override
        void writePrimitiveField(Object object, EntityOutput entityOutput, Field field) throws IllegalAccessException {
            entityOutput.writeInt(field.getInt(object));
        }

        @Override
        Format getSequenceKeyFormat() {
            return this;
        }
    }

    public static class FShort
    extends SimpleFormat {
        private static final long serialVersionUID = -4909138198491785624L;

        FShort(boolean bl) {
            super(bl ? Short.TYPE : Short.class, bl);
        }

        @Override
        Object newArray(int n) {
            return new Short[n];
        }

        @Override
        public Object newInstance(EntityInput entityInput, boolean bl) {
            return entityInput.readShort();
        }

        @Override
        void writeObject(Object object, EntityOutput entityOutput, boolean bl) {
            entityOutput.writeShort(((Number)object).shortValue());
        }

        @Override
        void skipContents(RecordInput recordInput) {
            recordInput.skipFast(2);
        }

        @Override
        void copySecKey(RecordInput recordInput, RecordOutput recordOutput) {
            recordOutput.writeFast(recordInput.readFast());
            recordOutput.writeFast(recordInput.readFast());
        }

        @Override
        Object newPrimitiveArray(int n, EntityInput entityInput) {
            short[] sArray = new short[n];
            for (int i = 0; i < n; ++i) {
                sArray[i] = entityInput.readShort();
            }
            return sArray;
        }

        @Override
        void writePrimitiveArray(Object object, EntityOutput entityOutput) {
            short[] sArray = (short[])object;
            int n = sArray.length;
            entityOutput.writeArrayLength(n);
            for (int i = 0; i < n; ++i) {
                entityOutput.writeShort(sArray[i]);
            }
        }

        @Override
        int getPrimitiveLength() {
            return 2;
        }

        @Override
        void readPrimitiveField(Object object, EntityInput entityInput, Field field) throws IllegalAccessException {
            field.setShort(object, entityInput.readShort());
        }

        @Override
        void writePrimitiveField(Object object, EntityOutput entityOutput, Field field) throws IllegalAccessException {
            entityOutput.writeShort(field.getShort(object));
        }

        @Override
        Format getSequenceKeyFormat() {
            return this;
        }
    }

    public static class FByte
    extends SimpleFormat {
        private static final long serialVersionUID = 3651752958101447257L;

        FByte(boolean bl) {
            super(bl ? Byte.TYPE : Byte.class, bl);
        }

        @Override
        Object newArray(int n) {
            return new Byte[n];
        }

        @Override
        public Object newInstance(EntityInput entityInput, boolean bl) {
            return entityInput.readByte();
        }

        @Override
        void writeObject(Object object, EntityOutput entityOutput, boolean bl) {
            entityOutput.writeByte(((Number)object).byteValue());
        }

        @Override
        void skipContents(RecordInput recordInput) {
            recordInput.skipFast(1);
        }

        @Override
        void copySecKey(RecordInput recordInput, RecordOutput recordOutput) {
            recordOutput.writeFast(recordInput.readFast());
        }

        @Override
        Object newPrimitiveArray(int n, EntityInput entityInput) {
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = entityInput.readByte();
            }
            return byArray;
        }

        @Override
        void writePrimitiveArray(Object object, EntityOutput entityOutput) {
            byte[] byArray = (byte[])object;
            int n = byArray.length;
            entityOutput.writeArrayLength(n);
            for (int i = 0; i < n; ++i) {
                entityOutput.writeByte(byArray[i]);
            }
        }

        @Override
        int getPrimitiveLength() {
            return 1;
        }

        @Override
        void readPrimitiveField(Object object, EntityInput entityInput, Field field) throws IllegalAccessException {
            field.setByte(object, entityInput.readByte());
        }

        @Override
        void writePrimitiveField(Object object, EntityOutput entityOutput, Field field) throws IllegalAccessException {
            entityOutput.writeByte(field.getByte(object));
        }

        @Override
        Format getSequenceKeyFormat() {
            return this;
        }
    }

    public static class FBool
    extends SimpleFormat {
        private static final long serialVersionUID = -7724949525068533451L;

        FBool(boolean bl) {
            super(bl ? Boolean.TYPE : Boolean.class, bl);
        }

        @Override
        Object newArray(int n) {
            return new Boolean[n];
        }

        @Override
        public Object newInstance(EntityInput entityInput, boolean bl) {
            return entityInput.readBoolean();
        }

        @Override
        void writeObject(Object object, EntityOutput entityOutput, boolean bl) {
            entityOutput.writeBoolean((Boolean)object);
        }

        @Override
        void skipContents(RecordInput recordInput) {
            recordInput.skipFast(1);
        }

        @Override
        void copySecKey(RecordInput recordInput, RecordOutput recordOutput) {
            recordOutput.writeFast(recordInput.readFast());
        }

        @Override
        Object newPrimitiveArray(int n, EntityInput entityInput) {
            boolean[] blArray = new boolean[n];
            for (int i = 0; i < n; ++i) {
                blArray[i] = entityInput.readBoolean();
            }
            return blArray;
        }

        @Override
        void writePrimitiveArray(Object object, EntityOutput entityOutput) {
            boolean[] blArray = (boolean[])object;
            int n = blArray.length;
            entityOutput.writeArrayLength(n);
            for (int i = 0; i < n; ++i) {
                entityOutput.writeBoolean(blArray[i]);
            }
        }

        @Override
        int getPrimitiveLength() {
            return 1;
        }

        @Override
        void readPrimitiveField(Object object, EntityInput entityInput, Field field) throws IllegalAccessException {
            field.setBoolean(object, entityInput.readBoolean());
        }

        @Override
        void writePrimitiveField(Object object, EntityOutput entityOutput, Field field) throws IllegalAccessException {
            entityOutput.writeBoolean(field.getBoolean(object));
        }
    }
}

