/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.RawAbstractInput;
import com.sleepycat.persist.impl.VisitedObjects;
import com.sleepycat.persist.raw.RawObject;

class RecordOutput
extends TupleOutput
implements EntityOutput {
    private Catalog catalog;
    private boolean rawAccess;
    private VisitedObjects visited;

    RecordOutput(Catalog catalog, boolean bl) {
        this.catalog = catalog;
        this.rawAccess = bl;
    }

    @Override
    public void writeObject(Object object, Format format) {
        Format format2;
        if (object == null) {
            this.writePackedInt(0);
            return;
        }
        if (this.visited != null) {
            int n = this.visited.getOffset(object);
            if (n == 0x7FFFFFFD) {
                throw new IllegalArgumentException("Cannot embed a reference to a proxied object in the proxy; for example, a collection may not be an element of the collection because collections are proxied");
            }
            if (n > 0) {
                this.writePackedInt(-(n + 1));
                return;
            }
        }
        if ((format2 = this.rawAccess ? RawAbstractInput.checkRawType(this.catalog, object, format) : this.catalog.getFormat(object.getClass())).getProxiedFormat() != null) {
            throw new IllegalArgumentException("May not store proxy classes directly: " + format2.getClassName());
        }
        if (format2.isEntity()) {
            throw new IllegalArgumentException("References to entities are not allowed: " + object.getClass().getName());
        }
        if (this.visited == null) {
            this.visited = new VisitedObjects();
        }
        boolean bl = format2.areNestedRefsProhibited();
        int n = this.size();
        int n2 = this.visited.add(object, bl ? 0x7FFFFFFD : n);
        this.writePackedInt(format2.getId());
        format2.writeObject(object, this, this.rawAccess);
        if (bl) {
            this.visited.setOffset(n2, n);
        }
    }

    @Override
    public void writeKeyObject(Object object, Format format) {
        Format format2;
        if (object == null) {
            throw new IllegalArgumentException("Key field object may not be null");
        }
        if (this.rawAccess) {
            if (object instanceof RawObject) {
                format2 = (Format)((RawObject)object).getType();
            } else {
                format2 = this.catalog.getFormat(object.getClass());
                if (format.isPrimitive()) {
                    format = format.getWrapperFormat();
                }
            }
        } else {
            format2 = this.catalog.getFormat(object.getClass());
        }
        if (format != format2) {
            throw new IllegalArgumentException("The key field object class (" + object.getClass().getName() + ") must be the field's declared class: " + format.getClassName());
        }
        format.writeObject(object, this, this.rawAccess);
    }

    @Override
    public void registerPriKeyObject(Object object) {
        if (this.visited == null) {
            this.visited = new VisitedObjects();
        }
        this.visited.add(object, 0x7FFFFFFE);
    }

    @Override
    public void writeArrayLength(int n) {
        this.writePackedInt(n);
    }

    @Override
    public void writeEnumConstant(String[] stringArray, int n) {
        this.writePackedInt(n);
    }
}

