/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.KeyLocation;
import com.sleepycat.persist.impl.Reader;
import com.sleepycat.persist.impl.VisitedObjects;

class RecordInput
extends TupleInput
implements EntityInput {
    private Catalog catalog;
    private boolean rawAccess;
    private VisitedObjects visited;
    private DatabaseEntry priKeyEntry;
    private int priKeyFormatId;

    RecordInput(Catalog catalog, boolean bl, DatabaseEntry databaseEntry, int n, byte[] byArray, int n2, int n3) {
        super(byArray, n2, n3);
        this.catalog = catalog;
        this.rawAccess = bl;
        this.priKeyEntry = databaseEntry;
        this.priKeyFormatId = n;
    }

    private RecordInput(RecordInput recordInput, int n) {
        this(recordInput.catalog, recordInput.rawAccess, recordInput.priKeyEntry, recordInput.priKeyFormatId, recordInput.buf, n, recordInput.len);
        this.visited = recordInput.visited;
    }

    private RecordInput(RecordInput recordInput, DatabaseEntry databaseEntry) {
        this(recordInput.catalog, recordInput.rawAccess, recordInput.priKeyEntry, recordInput.priKeyFormatId, databaseEntry.getData(), databaseEntry.getOffset(), databaseEntry.getSize());
        this.visited = recordInput.visited;
    }

    @Override
    public Catalog getCatalog() {
        return this.catalog;
    }

    @Override
    public boolean isRawAccess() {
        return this.rawAccess;
    }

    @Override
    public boolean setRawAccess(boolean bl) {
        boolean bl2 = this.rawAccess;
        this.rawAccess = bl;
        return bl2;
    }

    @Override
    public Object readObject() {
        int n;
        int n2 = this.off;
        RecordInput recordInput = this;
        int n3 = this.readPackedInt();
        Object object = null;
        if (n3 == 0) {
            return null;
        }
        if (n3 < 0) {
            n = -(n3 + 1);
            if (this.visited != null) {
                object = this.visited.getObject(n);
            }
            if (object == VisitedObjects.PROHIBIT_REF_OBJECT) {
                throw new IllegalArgumentException("Cannot embed a reference to a proxied object in the proxy; for example, a collection may not be an element of the collection because collections are proxied");
            }
            if (object != null) {
                return object;
            }
            n2 = n;
            if (n == 0x7FFFFFFE) {
                assert (this.priKeyEntry != null && this.priKeyFormatId > 0);
                recordInput = new RecordInput(this, this.priKeyEntry);
                n3 = this.priKeyFormatId;
            } else {
                recordInput = new RecordInput(this, n);
                n3 = recordInput.readPackedInt();
            }
        }
        if (this.visited == null) {
            this.visited = new VisitedObjects();
        }
        n = this.visited.add(VisitedObjects.PROHIBIT_REF_OBJECT, n2);
        Format format = this.catalog.getFormat(n3);
        Reader reader = format.getReader();
        object = reader.newInstance(recordInput, this.rawAccess);
        this.visited.setObject(n, object);
        Object object2 = reader.readObject(object, recordInput, this.rawAccess);
        if (object != object2) {
            this.visited.replaceObject(object, object2);
        }
        return object2;
    }

    @Override
    public Object readKeyObject(Format format) {
        Reader reader = format.getReader();
        Object object = reader.newInstance(this, this.rawAccess);
        return reader.readObject(object, this, this.rawAccess);
    }

    KeyLocation getKeyLocation(Format format) {
        RecordInput recordInput = this;
        if (!format.isPrimitive()) {
            int n = recordInput.readPackedInt();
            if (n == 0) {
                return null;
            }
            if (n < 0) {
                int n2 = -(n + 1);
                if (n2 == 0x7FFFFFFE) {
                    assert (this.priKeyEntry != null && this.priKeyFormatId > 0);
                    recordInput = new RecordInput(this, this.priKeyEntry);
                    n = this.priKeyFormatId;
                } else {
                    recordInput = new RecordInput(this, n2);
                    n = recordInput.readPackedInt();
                }
            }
            format = this.catalog.getFormat(n);
        }
        return new KeyLocation(recordInput, format);
    }

    @Override
    public void registerPriKeyObject(Object object) {
        if (this.visited == null) {
            this.visited = new VisitedObjects();
        }
        this.visited.add(object, 0x7FFFFFFE);
    }

    @Override
    public void skipField(Format format) {
        if (format != null && format.isPrimitive()) {
            format.skipContents(this);
        } else {
            int n = this.readPackedInt();
            if (n > 0) {
                Format format2 = this.catalog.getFormat(n);
                format2.skipContents(this);
            }
        }
    }

    @Override
    public int readArrayLength() {
        return this.readPackedInt();
    }

    @Override
    public int readEnumConstant(String[] stringArray) {
        return this.readPackedInt();
    }
}

