/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.impl.Accessor;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.FieldInfo;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.raw.RawObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

class RawAccessor
implements Accessor {
    private Format parentFormat;
    private Accessor superAccessor;
    private FieldInfo priKeyField;
    private List<FieldInfo> secKeyFields;
    private List<FieldInfo> nonKeyFields;
    private boolean isCompositeKey;

    RawAccessor(Format format, Accessor accessor, FieldInfo fieldInfo, List<FieldInfo> list, List<FieldInfo> list2) {
        this.parentFormat = format;
        this.superAccessor = accessor;
        this.priKeyField = fieldInfo;
        this.secKeyFields = list;
        this.nonKeyFields = list2;
    }

    RawAccessor(Format format, List<FieldInfo> list) {
        this.parentFormat = format;
        this.nonKeyFields = list;
        this.secKeyFields = Collections.emptyList();
        this.isCompositeKey = true;
    }

    @Override
    public Object newInstance() {
        RawObject rawObject = this.superAccessor != null ? (RawObject)this.superAccessor.newInstance() : null;
        return new RawObject(this.parentFormat, new HashMap<String, Object>(), rawObject);
    }

    @Override
    public Object newArray(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPriKeyFieldNullOrZero(Object object) {
        if (this.priKeyField != null) {
            Object object2 = this.getValue(object, this.priKeyField);
            Format format = this.priKeyField.getType();
            if (format.isPrimitive()) {
                return ((Number)object2).longValue() == 0L;
            }
            return object2 == null;
        }
        if (this.superAccessor != null) {
            return this.superAccessor.isPriKeyFieldNullOrZero(this.getSuper(object));
        }
        throw new IllegalStateException("No primary key field");
    }

    @Override
    public void writePriKeyField(Object object, EntityOutput entityOutput) {
        if (this.priKeyField != null) {
            Object object2 = this.getValue(object, this.priKeyField);
            Format format = this.priKeyField.getType();
            entityOutput.writeKeyObject(object2, format);
        } else if (this.superAccessor != null) {
            this.superAccessor.writePriKeyField(this.getSuper(object), entityOutput);
        } else {
            throw new IllegalStateException("No primary key field");
        }
    }

    @Override
    public void readPriKeyField(Object object, EntityInput entityInput) {
        if (this.priKeyField != null) {
            Format format = this.priKeyField.getType();
            Object object2 = entityInput.readKeyObject(format);
            this.setValue(object, this.priKeyField, object2);
        } else if (this.superAccessor != null) {
            this.superAccessor.readPriKeyField(this.getSuper(object), entityInput);
        } else {
            throw new IllegalStateException("No primary key field");
        }
    }

    @Override
    public void writeSecKeyFields(Object object, EntityOutput entityOutput) {
        if (this.priKeyField != null && !this.priKeyField.getType().isPrimitive()) {
            entityOutput.registerPriKeyObject(this.getValue(object, this.priKeyField));
        }
        if (this.superAccessor != null) {
            this.superAccessor.writeSecKeyFields(this.getSuper(object), entityOutput);
        }
        for (int i = 0; i < this.secKeyFields.size(); ++i) {
            this.writeField(object, this.secKeyFields.get(i), entityOutput);
        }
    }

    @Override
    public void readSecKeyFields(Object object, EntityInput entityInput, int n, int n2, int n3) {
        if (this.priKeyField != null && !this.priKeyField.getType().isPrimitive()) {
            entityInput.registerPriKeyObject(this.getValue(object, this.priKeyField));
        }
        if (n3 != 0 && this.superAccessor != null) {
            this.superAccessor.readSecKeyFields(this.getSuper(object), entityInput, n, n2, n3 - 1);
        } else if (n3 > 0) {
            throw new IllegalStateException("Super class does not exist");
        }
        if (n3 <= 0) {
            for (int i = n; i <= n2 && i < this.secKeyFields.size(); ++i) {
                this.readField(object, this.secKeyFields.get(i), entityInput);
            }
        }
    }

    @Override
    public void writeNonKeyFields(Object object, EntityOutput entityOutput) {
        if (this.superAccessor != null) {
            this.superAccessor.writeNonKeyFields(this.getSuper(object), entityOutput);
        }
        for (int i = 0; i < this.nonKeyFields.size(); ++i) {
            this.writeField(object, this.nonKeyFields.get(i), entityOutput);
        }
    }

    @Override
    public void readNonKeyFields(Object object, EntityInput entityInput, int n, int n2, int n3) {
        if (n3 != 0 && this.superAccessor != null) {
            this.superAccessor.readNonKeyFields(this.getSuper(object), entityInput, n, n2, n3 - 1);
        } else if (n3 > 0) {
            throw new IllegalStateException("Super class does not exist");
        }
        if (n3 <= 0) {
            for (int i = n; i <= n2 && i < this.nonKeyFields.size(); ++i) {
                this.readField(object, this.nonKeyFields.get(i), entityInput);
            }
        }
    }

    @Override
    public Object getField(Object object, int n, int n2, boolean bl) {
        if (n2 > 0) {
            return this.superAccessor.getField(this.getSuper(object), n, n2 - 1, bl);
        }
        FieldInfo fieldInfo = bl ? this.secKeyFields.get(n) : this.nonKeyFields.get(n);
        return this.getValue(object, fieldInfo);
    }

    @Override
    public void setField(Object object, int n, int n2, boolean bl, Object object2) {
        if (n2 > 0) {
            this.superAccessor.setField(this.getSuper(object), n, n2 - 1, bl, object2);
            return;
        }
        FieldInfo fieldInfo = bl ? this.secKeyFields.get(n) : this.nonKeyFields.get(n);
        this.setValue(object, fieldInfo, object2);
    }

    private RawObject getSuper(Object object) {
        return ((RawObject)object).getSuper();
    }

    private Object getValue(Object object, FieldInfo fieldInfo) {
        return ((RawObject)object).getValues().get(fieldInfo.getName());
    }

    private void setValue(Object object, FieldInfo fieldInfo, Object object2) {
        ((RawObject)object).getValues().put(fieldInfo.getName(), object2);
    }

    private void writeField(Object object, FieldInfo fieldInfo, EntityOutput entityOutput) {
        Object object2 = this.getValue(object, fieldInfo);
        Format format = fieldInfo.getType();
        if (this.isCompositeKey || format.isPrimitive()) {
            entityOutput.writeKeyObject(object2, format);
        } else {
            entityOutput.writeObject(object2, format);
        }
    }

    private void readField(Object object, FieldInfo fieldInfo, EntityInput entityInput) {
        Format format = fieldInfo.getType();
        Object object2 = this.isCompositeKey || format.isPrimitive() ? entityInput.readKeyObject(format) : entityInput.readObject();
        this.setValue(object, fieldInfo, object2);
    }
}

