/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Evolver;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.RawArrayInput;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.SimpleFormat;
import com.sleepycat.persist.raw.RawObject;
import com.sleepycat.persist.raw.RawType;
import java.lang.reflect.Array;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class PrimitiveArrayFormat
extends Format {
    private static final long serialVersionUID = 8285299924106073591L;
    private SimpleFormat componentFormat;

    PrimitiveArrayFormat(Class clazz) {
        super(clazz);
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public int getDimensions() {
        return 1;
    }

    @Override
    public Format getComponentType() {
        return this.componentFormat;
    }

    @Override
    void collectRelatedFormats(Catalog catalog, Map<String, Format> map) {
    }

    @Override
    void initialize(Catalog catalog, int n) {
        this.componentFormat = (SimpleFormat)catalog.getFormat(this.getType().getComponentType());
    }

    @Override
    Object newArray(int n) {
        return Array.newInstance(this.getType(), n);
    }

    @Override
    public Object newInstance(EntityInput entityInput, boolean bl) {
        int n = entityInput.readArrayLength();
        if (bl) {
            return new RawObject((RawType)this, new Object[n]);
        }
        return this.componentFormat.newPrimitiveArray(n, entityInput);
    }

    @Override
    public Object readObject(Object object, EntityInput entityInput, boolean bl) {
        if (bl) {
            Object[] objectArray = ((RawObject)object).getElements();
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.componentFormat.newInstance(entityInput, true);
                this.componentFormat.readObject(objectArray[i], entityInput, true);
            }
        }
        return object;
    }

    @Override
    void writeObject(Object object, EntityOutput entityOutput, boolean bl) {
        if (bl) {
            Object[] objectArray = ((RawObject)object).getElements();
            entityOutput.writeArrayLength(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                this.componentFormat.writeObject(objectArray[i], entityOutput, true);
            }
        } else {
            this.componentFormat.writePrimitiveArray(object, entityOutput);
        }
    }

    @Override
    Object convertRawObject(Catalog catalog, boolean bl, RawObject rawObject, IdentityHashMap identityHashMap) {
        RawArrayInput rawArrayInput = new RawArrayInput(catalog, bl, identityHashMap, rawObject, this.componentFormat);
        Object object = this.newInstance(rawArrayInput, bl);
        identityHashMap.put(rawObject, object);
        return this.readObject(object, rawArrayInput, bl);
    }

    @Override
    void skipContents(RecordInput recordInput) {
        int n = recordInput.readPackedInt();
        this.componentFormat.skipPrimitiveArray(n, recordInput);
    }

    @Override
    void copySecMultiKey(RecordInput recordInput, Format format, Set set) {
        int n = recordInput.readPackedInt();
        this.componentFormat.copySecMultiKeyPrimitiveArray(n, recordInput, set);
    }

    @Override
    boolean evolve(Format format, Evolver evolver) {
        evolver.useOldFormat(this, format);
        return true;
    }
}

