/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.tuple.TupleBase;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.CompositeKeyFormat;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RecordOutput;
import com.sleepycat.persist.impl.SimpleCatalog;

public class PersistKeyBinding
implements EntryBinding {
    Catalog catalog;
    Format keyFormat;
    boolean rawAccess;

    public PersistKeyBinding(Catalog catalog, String string, boolean bl) {
        this.catalog = catalog;
        this.keyFormat = catalog.getFormat(string);
        if (this.keyFormat == null) {
            throw new IllegalArgumentException("Class is not persistent: " + string);
        }
        if (!(this.keyFormat.isSimple() || this.keyFormat.getClassMetadata() != null && this.keyFormat.getClassMetadata().getCompositeKeyFields() != null)) {
            throw new IllegalArgumentException("Key class is not a simple type or a composite key class (composite keys must include @KeyField annotations): " + string);
        }
        this.rawAccess = bl;
    }

    PersistKeyBinding(Class clazz, String[] stringArray) {
        this.catalog = SimpleCatalog.getInstance();
        if (stringArray != null) {
            assert (!SimpleCatalog.isSimpleType(clazz));
            this.keyFormat = new CompositeKeyFormat(clazz, null, stringArray);
        } else {
            assert (SimpleCatalog.isSimpleType(clazz));
            this.keyFormat = this.catalog.getFormat(clazz);
        }
        this.keyFormat.initializeIfNeeded(this.catalog);
    }

    Object bytesToObject(byte[] byArray, int n, int n2) {
        return PersistKeyBinding.readKey(this.keyFormat, this.catalog, byArray, n, n2, this.rawAccess);
    }

    static Object readKey(Format format, Catalog catalog, byte[] byArray, int n, int n2, boolean bl) {
        RecordInput recordInput = new RecordInput(catalog, bl, null, 0, byArray, n, n2);
        return recordInput.readKeyObject(format);
    }

    @Override
    public Object entryToObject(DatabaseEntry databaseEntry) {
        return this.bytesToObject(databaseEntry.getData(), databaseEntry.getOffset(), databaseEntry.getSize());
    }

    @Override
    public void objectToEntry(Object object, DatabaseEntry databaseEntry) {
        RecordOutput recordOutput = new RecordOutput(this.catalog, this.rawAccess);
        recordOutput.writeKeyObject(object, this.keyFormat);
        TupleBase.outputToEntry(recordOutput, databaseEntry);
    }
}

