/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.tuple.TupleBase;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.PersistCatalog;
import com.sleepycat.persist.impl.PersistKeyAssigner;
import com.sleepycat.persist.impl.Reader;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RecordOutput;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.raw.RawObject;

public class PersistEntityBinding
implements EntityBinding {
    PersistCatalog catalog;
    Format entityFormat;
    boolean rawAccess;
    PersistKeyAssigner keyAssigner;

    public PersistEntityBinding(PersistCatalog persistCatalog, String string, boolean bl) {
        this.catalog = persistCatalog;
        if (bl) {
            this.entityFormat = persistCatalog.getFormat(string);
            if (this.entityFormat == null || !this.entityFormat.isEntity()) {
                throw new IllegalArgumentException("Not an entity class: " + string);
            }
        } else {
            Class clazz;
            try {
                clazz = EntityModel.classForName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException(classNotFoundException);
            }
            this.entityFormat = persistCatalog.getFormat(clazz);
        }
        this.rawAccess = bl;
    }

    public PersistKeyAssigner getKeyAssigner() {
        return this.keyAssigner;
    }

    @Override
    public Object entryToObject(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) {
        return PersistEntityBinding.readEntity(this.catalog, databaseEntry, databaseEntry2, this.rawAccess);
    }

    static Object readEntity(Catalog catalog, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, boolean bl) {
        RecordInput recordInput = new RecordInput(catalog, bl, null, 0, databaseEntry.getData(), databaseEntry.getOffset(), databaseEntry.getSize());
        RecordInput recordInput2 = new RecordInput(catalog, bl, null, 0, databaseEntry2.getData(), databaseEntry2.getOffset(), databaseEntry2.getSize());
        int n = recordInput2.readPackedInt();
        Format format = catalog.getFormat(n);
        Reader reader = format.getReader();
        Object object = reader.newInstance(recordInput2, bl);
        reader.readPriKey(object, recordInput, bl);
        return reader.readObject(object, recordInput2, bl);
    }

    @Override
    public void objectToData(Object object, DatabaseEntry databaseEntry) {
        Format format = this.getValidFormat(object);
        PersistEntityBinding.writeEntity(format, this.catalog, object, databaseEntry, this.rawAccess);
    }

    static void writeEntity(Format format, Catalog catalog, Object object, DatabaseEntry databaseEntry, boolean bl) {
        RecordOutput recordOutput = new RecordOutput(catalog, bl);
        recordOutput.writePackedInt(format.getId());
        format.writeObject(object, recordOutput, bl);
        TupleBase.outputToEntry(recordOutput, databaseEntry);
    }

    @Override
    public void objectToKey(Object object, DatabaseEntry databaseEntry) {
        Format format = this.getValidFormat(object);
        RecordOutput recordOutput = new RecordOutput(this.catalog, this.rawAccess);
        format.writePriKey(object, recordOutput, this.rawAccess);
        TupleBase.outputToEntry(recordOutput, databaseEntry);
    }

    private Format getValidFormat(Object object) {
        Format format;
        if (object == null) {
            throw new IllegalArgumentException("An entity may not be null");
        }
        if (this.rawAccess) {
            if (!(object instanceof RawObject)) {
                throw new IllegalArgumentException("Entity must be a RawObject");
            }
            format = (Format)((RawObject)object).getType();
        } else {
            format = this.catalog.getFormat(object.getClass());
        }
        if (format.getEntityFormat() != this.entityFormat) {
            throw new IllegalArgumentException("The entity class (" + format.getClassName() + ") must be this entity class or a subclass of it: " + this.entityFormat.getClassName());
        }
        return format;
    }
}

