/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.model.Persistent;
import com.sleepycat.persist.model.PersistentProxy;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

@Persistent
abstract class MapProxy<K, V>
implements PersistentProxy<Map<K, V>> {
    private K[] keys;
    private V[] values;

    protected MapProxy() {
    }

    @Override
    public final void initializeProxy(Map<K, V> map) {
        int n = map.size();
        this.keys = new Object[n];
        this.values = new Object[n];
        int n2 = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.keys[n2] = entry.getKey();
            this.values[n2] = entry.getValue();
            ++n2;
        }
    }

    @Override
    public final Map<K, V> convertProxy() {
        int n = this.values.length;
        Map<K, V> map = this.newInstance(n);
        for (int i = 0; i < n; ++i) {
            map.put(this.keys[i], this.values[i]);
        }
        return map;
    }

    protected abstract Map<K, V> newInstance(int var1);

    @Persistent(proxyFor=TreeMap.class)
    static class TreeMapProxy<K, V>
    extends MapProxy<K, V> {
        protected TreeMapProxy() {
        }

        @Override
        protected Map<K, V> newInstance(int n) {
            return new TreeMap();
        }
    }

    @Persistent(proxyFor=HashMap.class)
    static class HashMapProxy<K, V>
    extends MapProxy<K, V> {
        protected HashMapProxy() {
        }

        @Override
        protected Map<K, V> newInstance(int n) {
            return new HashMap(n);
        }
    }
}

