/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.evolve.Converter;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.Enhanced;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Evolver;
import com.sleepycat.persist.impl.PersistCatalog;
import com.sleepycat.persist.impl.Reader;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RecordOutput;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.model.ClassMetadata;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.raw.RawField;
import com.sleepycat.persist.raw.RawObject;
import com.sleepycat.persist.raw.RawType;
import java.io.Serializable;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Format
implements Reader,
RawType,
Serializable {
    private static final long serialVersionUID = 545633644568489850L;
    static final int ID_NULL = 0;
    static final int ID_OBJECT = 1;
    static final int ID_BOOL = 2;
    static final int ID_BOOL_W = 3;
    static final int ID_BYTE = 4;
    static final int ID_BYTE_W = 5;
    static final int ID_SHORT = 6;
    static final int ID_SHORT_W = 7;
    static final int ID_INT = 8;
    static final int ID_INT_W = 9;
    static final int ID_LONG = 10;
    static final int ID_LONG_W = 11;
    static final int ID_FLOAT = 12;
    static final int ID_FLOAT_W = 13;
    static final int ID_DOUBLE = 14;
    static final int ID_DOUBLE_W = 15;
    static final int ID_CHAR = 16;
    static final int ID_CHAR_W = 17;
    static final int ID_STRING = 18;
    static final int ID_BIGINT = 19;
    static final int ID_BIGDEC = 20;
    static final int ID_DATE = 21;
    static final int ID_NUMBER = 22;
    static final int ID_SIMPLE_MIN = 2;
    static final int ID_SIMPLE_MAX = 21;
    static final int ID_PREDEFINED = 30;
    private int id;
    private String className;
    private Reader reader;
    private Format superFormat;
    private Format latestFormat;
    private Format previousFormat;
    private Set<String> supertypes;
    private boolean deleted;
    private boolean unused;
    private transient Catalog catalog;
    private transient Class type;
    private transient Format proxiedFormat;
    private transient boolean initialized;

    static boolean isPredefined(Format format) {
        return format.getId() <= 30;
    }

    Format(Class clazz) {
        this(clazz.getName());
        this.type = clazz;
        this.addSupertypes();
    }

    Format(String string) {
        this.className = string;
        this.latestFormat = this;
        this.supertypes = new HashSet<String>();
    }

    void migrateFromBeta(Map<String, Format> map) {
        if (this.latestFormat == null) {
            this.latestFormat = this;
        }
    }

    final boolean isNew() {
        return this.id == 0;
    }

    final Catalog getCatalog() {
        return this.catalog;
    }

    final int getId() {
        return this.id;
    }

    final void setId(int n) {
        this.id = n;
    }

    final Class getType() {
        return this.type;
    }

    final Class getExistingType() {
        if (this.type == null) {
            try {
                this.type = SimpleCatalog.classForName(this.className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalStateException(classNotFoundException);
            }
        }
        return this.type;
    }

    final Reader getReader() {
        if (this != this.reader) {
            PersistCatalog.unevolvedFormatsEncountered = true;
        }
        return this.reader;
    }

    final void setReader(Reader reader) {
        this.reader = reader;
    }

    final Format getSuperFormat() {
        return this.superFormat;
    }

    final void setSuperFormat(Format format) {
        this.superFormat = format;
    }

    final Format getProxiedFormat() {
        return this.proxiedFormat;
    }

    final void setProxiedFormat(Format format) {
        this.proxiedFormat = format;
    }

    final Format getLatestVersion() {
        return this.latestFormat;
    }

    public final Format getPreviousVersion() {
        return this.previousFormat;
    }

    final void setLatestVersion(Format format) {
        if (this.latestFormat == this) {
            format.previousFormat = this;
        }
        this.latestFormat = format;
    }

    final boolean isDeleted() {
        return this.deleted;
    }

    final void setDeleted(boolean bl) {
        this.deleted = bl;
    }

    final void setUnused(boolean bl) {
        this.unused = bl;
    }

    void setEvolveNeeded(boolean bl) {
        throw new UnsupportedOperationException();
    }

    boolean getEvolveNeeded() {
        throw new UnsupportedOperationException();
    }

    final boolean isInitialized() {
        return this.initialized;
    }

    final void initializeIfNeeded(Catalog catalog) {
        if (!this.initialized) {
            this.initialized = true;
            this.catalog = catalog;
            if (this.latestFormat == null) {
                this.latestFormat = this;
            }
            if (this.reader == null) {
                this.reader = this;
            }
            if (this.type == null && this.isCurrentVersion() && (this.isSimple() || !catalog.isRawAccess())) {
                this.getExistingType();
            }
            this.initialize(catalog, catalog.getInitVersion(this, false));
            this.reader.initializeReader(catalog, catalog.getInitVersion(this, true), this);
        }
    }

    @Override
    public void initializeReader(Catalog catalog, int n, Format format) {
    }

    private void addSupertypes() {
        this.addInterfaces(this.type);
        for (Class clazz = this.type.getSuperclass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            this.supertypes.add(clazz.getName());
            this.addInterfaces(clazz);
        }
    }

    private void addInterfaces(Class clazz) {
        Class<?>[] classArray;
        for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
            if (clazz2 == Enhanced.class) continue;
            this.supertypes.add(clazz2.getName());
            this.addInterfaces(clazz2);
        }
    }

    boolean areNestedRefsProhibited() {
        return false;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public int getVersion() {
        ClassMetadata classMetadata = this.getClassMetadata();
        if (classMetadata != null) {
            return classMetadata.getVersion();
        }
        return 0;
    }

    @Override
    public Format getSuperType() {
        return this.superFormat;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public List<String> getEnumConstants() {
        return null;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public int getDimensions() {
        return 0;
    }

    @Override
    public Format getComponentType() {
        return null;
    }

    @Override
    public Map<String, RawField> getFields() {
        return null;
    }

    boolean isAssignableTo(Format format) {
        if (this.proxiedFormat != null) {
            return this.proxiedFormat.isAssignableTo(format);
        }
        return format == this || format.id == 1 || this.supertypes.contains(format.className);
    }

    Format getWrapperFormat() {
        return null;
    }

    boolean isEntity() {
        return false;
    }

    boolean isModelClass() {
        return false;
    }

    ClassMetadata getClassMetadata() {
        return null;
    }

    EntityMetadata getEntityMetadata() {
        return null;
    }

    Format getEntityFormat() {
        return null;
    }

    abstract boolean evolve(Format var1, Evolver var2);

    boolean evolveMetadata(Format format, Converter converter, Evolver evolver) {
        return true;
    }

    final boolean isCurrentVersion() {
        return this.latestFormat == this && !this.deleted;
    }

    final boolean isSameClass(Format format) {
        return this.latestFormat == format.latestFormat;
    }

    abstract void initialize(Catalog var1, int var2);

    abstract void collectRelatedFormats(Catalog var1, Map<String, Format> var2);

    abstract Object newArray(int var1);

    @Override
    public abstract Object newInstance(EntityInput var1, boolean var2);

    @Override
    public abstract Object readObject(Object var1, EntityInput var2, boolean var3);

    abstract void writeObject(Object var1, EntityOutput var2, boolean var3);

    abstract void skipContents(RecordInput var1);

    Format skipToSecKey(RecordInput recordInput, String string) {
        throw new UnsupportedOperationException(this.toString());
    }

    void copySecKey(RecordInput recordInput, RecordOutput recordOutput) {
        throw new UnsupportedOperationException(this.toString());
    }

    void copySecMultiKey(RecordInput recordInput, Format format, Set set) {
        throw new UnsupportedOperationException(this.toString());
    }

    boolean nullifySecKey(Catalog catalog, Object object, String string, Object object2) {
        throw new UnsupportedOperationException(this.toString());
    }

    boolean isPriKeyNullOrZero(Object object, boolean bl) {
        throw new UnsupportedOperationException(this.toString());
    }

    void writePriKey(Object object, EntityOutput entityOutput, boolean bl) {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public void readPriKey(Object object, EntityInput entityInput, boolean bl) {
        throw new UnsupportedOperationException(this.toString());
    }

    Format getSequenceKeyFormat() {
        throw new IllegalArgumentException("Type not allowed for sequence: " + this.getClassName());
    }

    Object convertRawObject(Catalog catalog, boolean bl, RawObject rawObject, IdentityHashMap identityHashMap) {
        throw new UnsupportedOperationException(this.toString());
    }

    public String toString() {
        return "[RawType class: " + this.getClassName() + " version: " + this.getVersion() + " internal: " + this.getClass().getName() + (this.reader != null ? " reader: " + this.reader.getClass().getName() : "") + ']';
    }
}

