/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.raw.RawField;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class FieldInfo
implements RawField,
Serializable,
Comparable<FieldInfo> {
    private static final long serialVersionUID = 2062721100372306296L;
    private String name;
    private String className;
    private Format format;
    private transient Class cls;

    static List<FieldInfo> getInstanceFields(Class clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        ArrayList<FieldInfo> arrayList = new ArrayList<FieldInfo>(fieldArray.length);
        for (Field field : fieldArray) {
            int n = field.getModifiers();
            if (Modifier.isTransient(n) || Modifier.isStatic(n)) continue;
            arrayList.add(new FieldInfo(field));
        }
        return arrayList;
    }

    static FieldInfo getField(List<FieldInfo> list, String string) {
        int n = FieldInfo.getFieldIndex(list, string);
        if (n >= 0) {
            return list.get(n);
        }
        return null;
    }

    static int getFieldIndex(List<FieldInfo> list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            FieldInfo fieldInfo = list.get(i);
            if (!string.equals(fieldInfo.getName())) continue;
            return i;
        }
        return -1;
    }

    private FieldInfo(Field field) {
        this.name = field.getName();
        this.cls = field.getType();
        this.className = this.cls.getName();
    }

    void collectRelatedFormats(Catalog catalog, Map<String, Format> map) {
        this.format = catalog.createFormat(this.cls, map);
    }

    void migrateFromBeta(Map<String, Format> map) {
        if (this.format == null) {
            this.format = map.get(this.className);
            if (this.format == null) {
                throw new IllegalStateException(this.className);
            }
        }
    }

    void initialize(Catalog catalog, int n) {
    }

    Class getFieldClass() {
        if (this.cls == null) {
            try {
                this.cls = SimpleCatalog.classForName(this.className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalStateException(classNotFoundException);
            }
        }
        return this.cls;
    }

    String getClassName() {
        return this.className;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Format getType() {
        return this.format;
    }

    @Override
    public int compareTo(FieldInfo fieldInfo) {
        return this.name.compareTo(fieldInfo.name);
    }

    public boolean equals(Object object) {
        if (object instanceof FieldInfo) {
            FieldInfo fieldInfo = (FieldInfo)object;
            return this.name.equals(fieldInfo.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "[Field name: " + this.name + " class: " + this.className + ']';
    }
}

