/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Evolver;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.raw.RawObject;
import com.sleepycat.persist.raw.RawType;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class EnumFormat
extends Format {
    private static final long serialVersionUID = 1069833955604373538L;
    private String[] names;
    private transient Object[] values;

    EnumFormat(Class clazz) {
        super(clazz);
        this.values = clazz.getEnumConstants();
        this.names = new String[this.values.length];
        for (int i = 0; i < this.names.length; ++i) {
            this.names[i] = ((Enum)this.values[i]).name();
        }
    }

    @Override
    public boolean isEnum() {
        return true;
    }

    @Override
    public List<String> getEnumConstants() {
        return Arrays.asList(this.names);
    }

    @Override
    void collectRelatedFormats(Catalog catalog, Map<String, Format> map) {
    }

    @Override
    void initialize(Catalog catalog, int n) {
        Class clazz;
        if (this.values == null && (clazz = this.getType()) != null) {
            this.values = new Object[this.names.length];
            for (int i = 0; i < this.names.length; ++i) {
                this.values[i] = Enum.valueOf(clazz, this.names[i]);
            }
        }
    }

    @Override
    Object newArray(int n) {
        return Array.newInstance(this.getType(), n);
    }

    @Override
    public Object newInstance(EntityInput entityInput, boolean bl) {
        int n = entityInput.readEnumConstant(this.names);
        if (bl) {
            return new RawObject((RawType)this, this.names[n]);
        }
        return this.values[n];
    }

    @Override
    public Object readObject(Object object, EntityInput entityInput, boolean bl) {
        return object;
    }

    @Override
    void writeObject(Object object, EntityOutput entityOutput, boolean bl) {
        if (bl) {
            String string = ((RawObject)object).getEnum();
            for (int i = 0; i < this.names.length; ++i) {
                if (!this.names[i].equals(string)) continue;
                entityOutput.writeEnumConstant(this.names, i);
                return;
            }
        } else {
            for (int i = 0; i < this.values.length; ++i) {
                if (object != this.values[i]) continue;
                entityOutput.writeEnumConstant(this.names, i);
                return;
            }
        }
        throw new IllegalStateException("Bad enum: " + object);
    }

    @Override
    Object convertRawObject(Catalog catalog, boolean bl, RawObject rawObject, IdentityHashMap identityHashMap) {
        String string = rawObject.getEnum();
        for (int i = 0; i < this.names.length; ++i) {
            if (!this.names[i].equals(string)) continue;
            Object object = this.values[i];
            identityHashMap.put(rawObject, object);
            return object;
        }
        throw new IllegalArgumentException("Enum constant is not defined: " + string);
    }

    @Override
    void skipContents(RecordInput recordInput) {
        recordInput.skipFast(recordInput.getPackedIntByteLength());
    }

    @Override
    boolean evolve(Format format, Evolver evolver) {
        if (!(format instanceof EnumFormat)) {
            evolver.addEvolveError(this, format, "Incompatible enum type changed detected", "An enum class may not be changed to a non-enum type");
            return false;
        }
        EnumFormat enumFormat = (EnumFormat)format;
        if (Arrays.equals(this.names, enumFormat.names)) {
            evolver.useOldFormat(this, enumFormat);
            return true;
        }
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(this.names));
        List<String> list = Arrays.asList(enumFormat.names);
        if (list.containsAll(hashSet)) {
            evolver.useEvolvedFormat(this, enumFormat, enumFormat);
            return true;
        }
        hashSet.removeAll(list);
        evolver.addEvolveError(this, enumFormat, "Incompatible enum type changed detected", "Enum values may not be removed: " + hashSet);
        return false;
    }
}

