/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.impl.Accessor;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.ComplexFormat;
import com.sleepycat.persist.impl.Enhanced;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Format;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EnhancedAccessor
implements Accessor {
    private static final Map<String, Enhanced> classRegistry = Collections.synchronizedMap(new HashMap());
    public static final boolean EXPECT_ENHANCED = "true".equals(System.getProperty("expectEnhanced"));
    private Enhanced prototype;
    private Format priKeyFormat;
    private Class type;

    public static void registerClass(String string, Enhanced enhanced) {
        classRegistry.put(string, enhanced);
    }

    static boolean isEnhanced(Class clazz) {
        boolean bl = classRegistry.containsKey(clazz.getName());
        if (!bl && EXPECT_ENHANCED) {
            throw new IllegalStateException("Test was run with expectEnhanced=true but class " + clazz.getName() + " is not enhanced");
        }
        return bl;
    }

    EnhancedAccessor(Class clazz) {
        this.type = clazz;
        this.prototype = classRegistry.get(clazz.getName());
        assert (this.prototype != null || Modifier.isAbstract(clazz.getModifiers()));
    }

    EnhancedAccessor(Catalog catalog, Class clazz, ComplexFormat complexFormat) {
        this(clazz);
        ComplexFormat complexFormat2 = complexFormat;
        while (complexFormat2 != null) {
            Serializable serializable;
            String string = complexFormat2.getPriKeyField();
            if (string != null) {
                Class<?> clazz2;
                serializable = complexFormat2.getType();
                try {
                    clazz2 = ((Class)serializable).getDeclaredField(string).getType();
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new IllegalStateException(noSuchFieldException);
                }
                this.priKeyFormat = catalog.getFormat(clazz2);
                break;
            }
            serializable = complexFormat2.getSuperFormat();
            complexFormat2 = (ComplexFormat)serializable;
        }
    }

    @Override
    public Object newInstance() {
        if (this.prototype == null) {
            throw new IllegalStateException();
        }
        return this.prototype.bdbNewInstance();
    }

    @Override
    public Object newArray(int n) {
        if (this.prototype == null) {
            return Array.newInstance(this.type, n);
        }
        return this.prototype.bdbNewArray(n);
    }

    @Override
    public boolean isPriKeyFieldNullOrZero(Object object) {
        if (this.priKeyFormat == null) {
            throw new IllegalStateException("No primary key: " + object.getClass().getName());
        }
        return ((Enhanced)object).bdbIsPriKeyFieldNullOrZero();
    }

    @Override
    public void writePriKeyField(Object object, EntityOutput entityOutput) {
        if (this.priKeyFormat == null) {
            throw new IllegalStateException("No primary key: " + object.getClass().getName());
        }
        ((Enhanced)object).bdbWritePriKeyField(entityOutput, this.priKeyFormat);
    }

    @Override
    public void readPriKeyField(Object object, EntityInput entityInput) {
        if (this.priKeyFormat == null) {
            throw new IllegalStateException("No primary key: " + object.getClass().getName());
        }
        ((Enhanced)object).bdbReadPriKeyField(entityInput, this.priKeyFormat);
    }

    @Override
    public void writeSecKeyFields(Object object, EntityOutput entityOutput) {
        ((Enhanced)object).bdbWriteSecKeyFields(entityOutput);
    }

    @Override
    public void readSecKeyFields(Object object, EntityInput entityInput, int n, int n2, int n3) {
        ((Enhanced)object).bdbReadSecKeyFields(entityInput, n, n2, n3);
    }

    @Override
    public void writeNonKeyFields(Object object, EntityOutput entityOutput) {
        ((Enhanced)object).bdbWriteNonKeyFields(entityOutput);
    }

    @Override
    public void readNonKeyFields(Object object, EntityInput entityInput, int n, int n2, int n3) {
        ((Enhanced)object).bdbReadNonKeyFields(entityInput, n, n2, n3);
    }

    @Override
    public Object getField(Object object, int n, int n2, boolean bl) {
        return ((Enhanced)object).bdbGetField(object, n, n2, bl);
    }

    @Override
    public void setField(Object object, int n, int n2, boolean bl, Object object2) {
        ((Enhanced)object).bdbSetField(object, n, n2, bl, object2);
    }
}

