/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.evolve.Converter;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.Reader;
import com.sleepycat.persist.raw.RawObject;

public class ConverterReader
implements Reader {
    private static final long serialVersionUID = -305788321064984348L;
    private Converter converter;
    private transient Format oldFormat;

    ConverterReader(Converter converter) {
        this.converter = converter;
    }

    @Override
    public void initializeReader(Catalog catalog, int n, Format format) {
        this.oldFormat = format;
    }

    @Override
    public Object newInstance(EntityInput entityInput, boolean bl) {
        return this.oldFormat.newInstance(entityInput, true);
    }

    @Override
    public void readPriKey(Object object, EntityInput entityInput, boolean bl) {
        this.oldFormat.readPriKey(object, entityInput, true);
    }

    @Override
    public Object readObject(Object object, EntityInput entityInput, boolean bl) {
        Catalog catalog = entityInput.getCatalog();
        object = this.oldFormat.readObject(object, entityInput, true);
        object = this.converter.getConversion().convert(object);
        if (!bl && object instanceof RawObject) {
            object = catalog.convertRawObject((RawObject)object, null);
        }
        return object;
    }
}

