/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.tuple.TupleBase;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RecordOutput;
import com.sleepycat.persist.model.Persistent;
import com.sleepycat.persist.model.PersistentProxy;
import com.sleepycat.persist.raw.RawObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

@Persistent
abstract class CollectionProxy<E>
implements PersistentProxy<Collection<E>> {
    private E[] elements;

    protected CollectionProxy() {
    }

    @Override
    public final void initializeProxy(Collection<E> collection) {
        this.elements = new Object[collection.size()];
        int n = 0;
        for (E e : collection) {
            this.elements[n] = e;
            ++n;
        }
    }

    @Override
    public final Collection<E> convertProxy() {
        Collection<E> collection = this.newInstance(this.elements.length);
        for (E e : this.elements) {
            collection.add(e);
        }
        return collection;
    }

    protected abstract Collection<E> newInstance(int var1);

    static Object[] getElements(RawObject rawObject) {
        Object object;
        Object object2 = null;
        while (object2 == null && rawObject != null) {
            object = rawObject.getValues();
            if (object == null || (object2 = object.get("elements")) != null) continue;
            rawObject = rawObject.getSuper();
        }
        if (object2 == null || !(object2 instanceof RawObject)) {
            throw new IllegalStateException("Collection proxy for a secondary key field must contain a field named 'elements'");
        }
        object = (RawObject)object2;
        Format format = (Format)((RawObject)object).getType();
        if (!format.isArray() || format.getComponentType().getId() != 1) {
            throw new IllegalStateException("Collection proxy 'elements' field must by an Object array");
        }
        return ((RawObject)object).getElements();
    }

    static void setElements(RawObject rawObject, Object[] objectArray) {
        RawObject rawObject2 = null;
        while (rawObject2 == null && rawObject != null) {
            Map<String, Object> map = rawObject.getValues();
            if (map == null) continue;
            rawObject2 = (RawObject)map.get("elements");
            if (rawObject2 != null) {
                map.put("elements", new RawObject(rawObject2.getType(), objectArray));
                continue;
            }
            rawObject = rawObject.getSuper();
        }
        if (rawObject2 == null) {
            throw new IllegalStateException();
        }
    }

    static void copyElements(RecordInput recordInput, Format format, Format format2, Set set) {
        RawObject rawObject = (RawObject)format.newInstance(recordInput, true);
        Object[] objectArray = CollectionProxy.getElements(rawObject = (RawObject)format.readObject(rawObject, recordInput, true));
        if (objectArray != null) {
            for (Object object : objectArray) {
                RecordOutput recordOutput = new RecordOutput(recordInput.getCatalog(), true);
                recordOutput.writeKeyObject(object, format2);
                DatabaseEntry databaseEntry = new DatabaseEntry();
                TupleBase.outputToEntry(recordOutput, databaseEntry);
                set.add(databaseEntry);
            }
        }
    }

    @Persistent(proxyFor=TreeSet.class)
    static class TreeSetProxy<E>
    extends CollectionProxy<E> {
        protected TreeSetProxy() {
        }

        @Override
        protected Collection<E> newInstance(int n) {
            return new TreeSet();
        }
    }

    @Persistent(proxyFor=HashSet.class)
    static class HashSetProxy<E>
    extends CollectionProxy<E> {
        protected HashSetProxy() {
        }

        @Override
        protected Collection<E> newInstance(int n) {
            return new HashSet(n);
        }
    }

    @Persistent(proxyFor=LinkedList.class)
    static class LinkedListProxy<E>
    extends CollectionProxy<E> {
        protected LinkedListProxy() {
        }

        @Override
        protected Collection<E> newInstance(int n) {
            return new LinkedList();
        }
    }

    @Persistent(proxyFor=ArrayList.class)
    static class ArrayListProxy<E>
    extends CollectionProxy<E> {
        protected ArrayListProxy() {
        }

        @Override
        protected Collection<E> newInstance(int n) {
            return new ArrayList(n);
        }
    }
}

