/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.db.Cursor;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.Environment;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.Transaction;
import com.sleepycat.persist.BasicIndex;
import com.sleepycat.persist.EntityValueAdapter;
import com.sleepycat.persist.impl.PersistEntityBinding;
import com.sleepycat.persist.impl.PersistKeyAssigner;
import java.util.Map;
import java.util.SortedMap;

public class PrimaryIndex<PK, E>
extends BasicIndex<PK, E> {
    private Class<E> entityClass;
    private EntityBinding entityBinding;
    private SortedMap<PK, E> map;
    private PersistKeyAssigner keyAssigner;

    public PrimaryIndex(Database database, Class<PK> clazz, EntryBinding entryBinding, Class<E> clazz2, EntityBinding entityBinding) throws DatabaseException {
        super(database, clazz, entryBinding, new EntityValueAdapter<E>(clazz2, entityBinding, false));
        this.entityClass = clazz2;
        this.entityBinding = entityBinding;
        if (entityBinding instanceof PersistEntityBinding) {
            this.keyAssigner = ((PersistEntityBinding)entityBinding).getKeyAssigner();
        }
    }

    public Database getDatabase() {
        return this.db;
    }

    public Class<PK> getKeyClass() {
        return this.keyClass;
    }

    public EntryBinding getKeyBinding() {
        return this.keyBinding;
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    public EntityBinding getEntityBinding() {
        return this.entityBinding;
    }

    public E put(E e) throws DatabaseException {
        return this.put(null, e);
    }

    public E put(Transaction transaction, E e) throws DatabaseException {
        DatabaseEntry databaseEntry = new DatabaseEntry();
        DatabaseEntry databaseEntry2 = new DatabaseEntry();
        this.assignKey(e, databaseEntry);
        boolean bl = false;
        Environment environment = this.db.getEnvironment();
        if (this.transactional && transaction == null && DbCompat.getThreadTransaction(environment) == null) {
            transaction = environment.beginTransaction(null, null);
            bl = true;
        }
        boolean bl2 = true;
        Cursor cursor = this.db.openCursor(transaction, null);
        LockMode lockMode = this.locking ? LockMode.RMW : null;
        try {
            while (true) {
                OperationStatus operationStatus;
                if ((operationStatus = cursor.getSearchKey(databaseEntry, databaseEntry2, lockMode)) == OperationStatus.SUCCESS) {
                    Object object = this.entityBinding.entryToObject(databaseEntry, databaseEntry2);
                    this.entityBinding.objectToData(e, databaseEntry2);
                    cursor.put(databaseEntry, databaseEntry2);
                    bl2 = false;
                    Object object2 = object;
                    return (E)object2;
                }
                this.entityBinding.objectToData(e, databaseEntry2);
                operationStatus = cursor.putNoOverwrite(databaseEntry, databaseEntry2);
                if (operationStatus == OperationStatus.KEYEXIST) continue;
                bl2 = false;
                E e2 = null;
                return e2;
            }
        }
        finally {
            cursor.close();
            if (bl) {
                if (bl2) {
                    transaction.abort();
                } else {
                    transaction.commit();
                }
            }
        }
    }

    public void putNoReturn(E e) throws DatabaseException {
        this.putNoReturn(null, e);
    }

    public void putNoReturn(Transaction transaction, E e) throws DatabaseException {
        DatabaseEntry databaseEntry = new DatabaseEntry();
        DatabaseEntry databaseEntry2 = new DatabaseEntry();
        this.assignKey(e, databaseEntry);
        this.entityBinding.objectToData(e, databaseEntry2);
        this.db.put(transaction, databaseEntry, databaseEntry2);
    }

    public boolean putNoOverwrite(E e) throws DatabaseException {
        return this.putNoOverwrite(null, e);
    }

    public boolean putNoOverwrite(Transaction transaction, E e) throws DatabaseException {
        DatabaseEntry databaseEntry = new DatabaseEntry();
        DatabaseEntry databaseEntry2 = new DatabaseEntry();
        this.assignKey(e, databaseEntry);
        this.entityBinding.objectToData(e, databaseEntry2);
        OperationStatus operationStatus = this.db.putNoOverwrite(transaction, databaseEntry, databaseEntry2);
        return operationStatus == OperationStatus.SUCCESS;
    }

    private void assignKey(E e, DatabaseEntry databaseEntry) throws DatabaseException {
        if (this.keyAssigner != null) {
            if (!this.keyAssigner.assignPrimaryKey(e, databaseEntry)) {
                this.entityBinding.objectToKey(e, databaseEntry);
            }
        } else {
            this.entityBinding.objectToKey(e, databaseEntry);
        }
    }

    @Override
    public E get(PK PK) throws DatabaseException {
        return this.get((Transaction)null, PK, (LockMode)null);
    }

    @Override
    public E get(Transaction transaction, PK PK, LockMode lockMode) throws DatabaseException {
        DatabaseEntry databaseEntry = new DatabaseEntry();
        DatabaseEntry databaseEntry2 = new DatabaseEntry();
        this.keyBinding.objectToEntry(PK, databaseEntry);
        OperationStatus operationStatus = this.db.get(transaction, databaseEntry, databaseEntry2, lockMode);
        if (operationStatus == OperationStatus.SUCCESS) {
            return (E)this.entityBinding.entryToObject(databaseEntry, databaseEntry2);
        }
        return null;
    }

    @Override
    public Map<PK, E> map() {
        return this.sortedMap();
    }

    @Override
    public synchronized SortedMap<PK, E> sortedMap() {
        if (this.map == null) {
            this.map = new StoredSortedMap(this.db, this.keyBinding, this.entityBinding, true);
        }
        return this.map;
    }

    @Override
    boolean isUpdateAllowed() {
        return true;
    }
}

