/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.Transaction;
import com.sleepycat.persist.BasicIndex;
import com.sleepycat.persist.DataValueAdapter;
import java.util.Map;
import java.util.SortedMap;

class KeysIndex<SK, PK>
extends BasicIndex<SK, PK> {
    private EntryBinding pkeyBinding;
    private SortedMap<SK, PK> map;

    KeysIndex(Database database, Class<SK> clazz, EntryBinding entryBinding, Class<PK> clazz2, EntryBinding entryBinding2) throws DatabaseException {
        super(database, clazz, entryBinding, new DataValueAdapter<PK>(clazz2, entryBinding2));
        this.pkeyBinding = entryBinding2;
    }

    @Override
    public PK get(SK SK) throws DatabaseException {
        return this.get((Transaction)null, SK, (LockMode)null);
    }

    @Override
    public PK get(Transaction transaction, SK SK, LockMode lockMode) throws DatabaseException {
        DatabaseEntry databaseEntry = new DatabaseEntry();
        DatabaseEntry databaseEntry2 = new DatabaseEntry();
        this.keyBinding.objectToEntry(SK, databaseEntry);
        OperationStatus operationStatus = this.db.get(transaction, databaseEntry, databaseEntry2, lockMode);
        if (operationStatus == OperationStatus.SUCCESS) {
            return (PK)this.pkeyBinding.entryToObject(databaseEntry2);
        }
        return null;
    }

    @Override
    public Map<SK, PK> map() {
        return this.sortedMap();
    }

    @Override
    public synchronized SortedMap<SK, PK> sortedMap() {
        if (this.map == null) {
            this.map = new StoredSortedMap(this.db, this.keyBinding, this.pkeyBinding, true);
        }
        return this.map;
    }

    @Override
    boolean isUpdateAllowed() {
        return false;
    }
}

