/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db.internal;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.Sequence;
import com.sleepycat.db.SequenceStats;
import com.sleepycat.db.internal.Db;
import com.sleepycat.db.internal.DbTxn;
import com.sleepycat.db.internal.db_javaJNI;

public class DbSequence {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    public Sequence wrapper;

    protected DbSequence(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(DbSequence dbSequence) {
        return dbSequence == null ? 0L : dbSequence.swigCPtr;
    }

    synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            throw new UnsupportedOperationException("C++ destructor does not have public access");
        }
        this.swigCPtr = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(int n) throws DatabaseException {
        try {
            this.close0(n);
        }
        finally {
            this.swigCPtr = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(DbTxn dbTxn, int n) throws DatabaseException {
        try {
            this.remove0(dbTxn, n);
        }
        finally {
            this.swigCPtr = 0L;
        }
    }

    public DbSequence(Db db, int n) throws DatabaseException {
        this(db_javaJNI.new_DbSequence(Db.getCPtr(db), db, n), true);
    }

    void close0(int n) {
        db_javaJNI.DbSequence_close0(this.swigCPtr, this, n);
    }

    public long get(DbTxn dbTxn, int n, int n2) throws DatabaseException {
        return db_javaJNI.DbSequence_get(this.swigCPtr, this, DbTxn.getCPtr(dbTxn), dbTxn, n, n2);
    }

    public int get_cachesize() throws DatabaseException {
        return db_javaJNI.DbSequence_get_cachesize(this.swigCPtr, this);
    }

    public Db get_db() throws DatabaseException {
        long l = db_javaJNI.DbSequence_get_db(this.swigCPtr, this);
        return l == 0L ? null : new Db(l, false);
    }

    public int get_flags() throws DatabaseException {
        return db_javaJNI.DbSequence_get_flags(this.swigCPtr, this);
    }

    public void get_key(DatabaseEntry databaseEntry) throws DatabaseException {
        db_javaJNI.DbSequence_get_key(this.swigCPtr, this, databaseEntry);
    }

    public long get_range_min() throws DatabaseException {
        return db_javaJNI.DbSequence_get_range_min(this.swigCPtr, this);
    }

    public long get_range_max() throws DatabaseException {
        return db_javaJNI.DbSequence_get_range_max(this.swigCPtr, this);
    }

    public void initial_value(long l) throws DatabaseException {
        db_javaJNI.DbSequence_initial_value(this.swigCPtr, this, l);
    }

    public void open(DbTxn dbTxn, DatabaseEntry databaseEntry, int n) throws DatabaseException {
        db_javaJNI.DbSequence_open(this.swigCPtr, this, DbTxn.getCPtr(dbTxn), dbTxn, databaseEntry, n);
    }

    void remove0(DbTxn dbTxn, int n) {
        db_javaJNI.DbSequence_remove0(this.swigCPtr, this, DbTxn.getCPtr(dbTxn), dbTxn, n);
    }

    public void set_cachesize(int n) throws DatabaseException {
        db_javaJNI.DbSequence_set_cachesize(this.swigCPtr, this, n);
    }

    public void set_flags(int n) throws DatabaseException {
        db_javaJNI.DbSequence_set_flags(this.swigCPtr, this, n);
    }

    public void set_range(long l, long l2) throws DatabaseException {
        db_javaJNI.DbSequence_set_range(this.swigCPtr, this, l, l2);
    }

    public SequenceStats stat(int n) throws DatabaseException {
        return db_javaJNI.DbSequence_stat(this.swigCPtr, this, n);
    }
}

