/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.internal.DbEnv;
import com.sleepycat.db.internal.DbTxn;

public class TransactionConfig
implements Cloneable {
    public static final TransactionConfig DEFAULT = new TransactionConfig();
    private boolean readUncommitted = false;
    private boolean readCommitted = false;
    private boolean noSync = false;
    private boolean noWait = false;
    private boolean snapshot = false;
    private boolean sync = false;
    private boolean writeNoSync = false;
    private boolean wait = false;

    static TransactionConfig checkNull(TransactionConfig transactionConfig) {
        return transactionConfig == null ? DEFAULT : transactionConfig;
    }

    public void setReadCommitted(boolean bl) {
        this.readCommitted = bl;
    }

    public boolean getReadCommitted() {
        return this.readCommitted;
    }

    public void setDegree2(boolean bl) {
        this.setReadCommitted(bl);
    }

    public boolean getDegree2() {
        return this.getReadCommitted();
    }

    public void setReadUncommitted(boolean bl) {
        this.readUncommitted = bl;
    }

    public boolean getReadUncommitted() {
        return this.readUncommitted;
    }

    public void setDirtyRead(boolean bl) {
        this.setReadUncommitted(bl);
    }

    public boolean getDirtyRead() {
        return this.getReadUncommitted();
    }

    public void setNoSync(boolean bl) {
        this.noSync = bl;
    }

    public boolean getNoSync() {
        return this.noSync;
    }

    public void setNoWait(boolean bl) {
        this.noWait = bl;
    }

    public boolean getNoWait() {
        return this.noWait;
    }

    public void setSnapshot(boolean bl) {
        this.snapshot = bl;
    }

    public boolean getSnapshot() {
        return this.snapshot;
    }

    public void setSync(boolean bl) {
        this.sync = bl;
    }

    public boolean getSync() {
        return this.sync;
    }

    public void setWait(boolean bl) {
        this.wait = bl;
    }

    public boolean getWait() {
        return this.wait;
    }

    public void setWriteNoSync(boolean bl) {
        this.writeNoSync = bl;
    }

    public boolean getWriteNoSync() {
        return this.writeNoSync;
    }

    DbTxn beginTransaction(DbEnv dbEnv, DbTxn dbTxn) throws DatabaseException {
        int n = 0;
        n |= this.readCommitted ? 1024 : 0;
        n |= this.readUncommitted ? 512 : 0;
        n |= this.noSync ? 1 : 0;
        n |= this.noWait ? 2 : 0;
        n |= this.snapshot ? 2048 : 0;
        n |= this.sync ? 4 : 0;
        n |= this.wait ? 8 : 0;
        return dbEnv.txn_begin(dbTxn, n |= this.writeNoSync ? 32 : 0);
    }
}

