/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.internal.DbUtil;
import java.nio.ByteBuffer;

public class DatabaseEntry {
    byte[] data;
    ByteBuffer data_nio;
    int dlen = 0;
    int doff = 0;
    int flags = 0;
    int offset = 0;
    int size = 0;
    int ulen = 0;
    static final DatabaseEntry IGNORE = new DatabaseEntry();
    static final DatabaseEntry UNUSED;
    static final int INT32SZ = 4;

    public DatabaseEntry() {
    }

    public DatabaseEntry(byte[] byArray) {
        this.data = byArray;
        if (byArray != null) {
            this.size = byArray.length;
        }
        this.data_nio = null;
    }

    public DatabaseEntry(byte[] byArray, int n, int n2) {
        this.data = byArray;
        this.offset = n;
        this.size = n2;
        this.data_nio = null;
    }

    public DatabaseEntry(ByteBuffer byteBuffer) {
        if (byteBuffer.isDirect()) {
            this.data_nio = byteBuffer;
            if (byteBuffer != null) {
                this.size = this.ulen = byteBuffer.limit();
                this.setUserBuffer(byteBuffer.limit(), true);
            }
        } else if (byteBuffer.hasArray()) {
            this.data = byteBuffer.array();
            if (this.data != null) {
                this.size = this.data.length;
            }
            this.data_nio = null;
        } else {
            throw new IllegalArgumentException("Attempting to use a non-direct ByteBuffer without a backing byte array.");
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public ByteBuffer getDataNIO() {
        return this.data_nio;
    }

    public void setData(byte[] byArray, int n, int n2) {
        this.data = byArray;
        this.offset = n;
        this.size = n2;
        this.data_nio = null;
    }

    public void setData(byte[] byArray) {
        this.setData(byArray, 0, byArray == null ? 0 : byArray.length);
    }

    public void setDataNIO(ByteBuffer byteBuffer, int n, int n2) {
        this.data_nio = byteBuffer;
        this.offset = n;
        this.size = this.ulen = n2;
        this.data = null;
        this.flags = 0;
        this.setUserBuffer(n2, true);
    }

    public void setDataNIO(ByteBuffer byteBuffer) {
        this.setDataNIO(byteBuffer, 0, byteBuffer == null ? 0 : byteBuffer.capacity());
    }

    int getMultiFlag() {
        return 0;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public int getPartialLength() {
        return this.dlen;
    }

    public int getPartialOffset() {
        return this.doff;
    }

    public boolean getPartial() {
        return (this.flags & 0x20) != 0;
    }

    public void setPartialOffset(int n) {
        this.doff = n;
    }

    public void setPartialLength(int n) {
        this.dlen = n;
    }

    public void setPartial(boolean bl) {
        this.flags = bl ? (this.flags |= 0x20) : (this.flags &= 0xFFFFFFDF);
    }

    public void setPartial(int n, int n2, boolean bl) {
        this.setPartialOffset(n);
        this.setPartialLength(n2);
        this.setPartial(bl);
    }

    public int getRecordNumber() {
        return DbUtil.array2int(this.data, this.offset);
    }

    public void setRecordNumber(int n) {
        if (this.data == null || this.data.length < 4) {
            this.data = new byte[4];
            this.size = 4;
            this.ulen = 0;
            this.offset = 0;
        }
        DbUtil.int2array(n, this.data, 0);
    }

    public boolean getReuseBuffer() {
        return 0 == (this.flags & 0x108);
    }

    public void setReuseBuffer(boolean bl) {
        if (this.data_nio != null) {
            throw new IllegalArgumentException("Can only set the reuse flag on DatabaseEntry classes with a underlying byte[] data");
        }
        if (bl) {
            this.flags &= 0xFFFFFEF7;
        } else {
            this.flags &= 0xFFFFFEFF;
            this.flags |= 8;
        }
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public boolean getUserBuffer() {
        return (this.flags & 0x100) != 0;
    }

    public int getUserBufferLength() {
        return this.ulen;
    }

    public void setUserBuffer(int n, boolean bl) {
        this.ulen = n;
        if (bl) {
            this.flags &= 0xFFFFFFF7;
            this.flags |= 0x100;
        } else {
            this.flags &= 0xFFFFFEFF;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof DatabaseEntry)) {
            return false;
        }
        DatabaseEntry databaseEntry = (DatabaseEntry)object;
        if ((this.getPartial() || databaseEntry.getPartial()) && (this.getPartial() != databaseEntry.getPartial() || this.dlen != databaseEntry.dlen || this.doff != databaseEntry.doff)) {
            return false;
        }
        if (this.data == null && databaseEntry.data == null) {
            return true;
        }
        if (this.data == null || databaseEntry.data == null) {
            return false;
        }
        if (this.size != databaseEntry.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[this.offset + i] == databaseEntry.data[databaseEntry.offset + i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        if (this.data != null) {
            for (int i = 0; i < this.size; ++i) {
                n += this.data[this.offset + i];
            }
        }
        return n;
    }

    static {
        IGNORE.setUserBuffer(0, true);
        IGNORE.setPartial(0, 0, true);
        UNUSED = new DatabaseEntry();
    }
}

