/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.BaseIterator;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.StoredCollection;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.util.keyrange.KeyRange;
import java.util.ListIterator;
import java.util.NoSuchElementException;

class BlockIterator
implements BaseIterator {
    private StoredCollection coll;
    private boolean writeAllowed;
    private byte[][] keys;
    private byte[][] priKeys;
    private byte[][] values;
    private int nextIndex;
    private int dataIndex;
    private Object dataObject;

    BlockIterator(StoredCollection storedCollection, boolean bl, int n) {
        this.coll = storedCollection;
        this.writeAllowed = bl;
        this.keys = new byte[n][];
        this.priKeys = storedCollection.isSecondary() ? new byte[n][] : (byte[][])this.keys;
        this.values = new byte[n][];
        this.nextIndex = n;
        this.dataIndex = -1;
        this.dataObject = null;
    }

    private BlockIterator(BlockIterator blockIterator) {
        this.coll = blockIterator.coll;
        this.writeAllowed = blockIterator.writeAllowed;
        this.keys = this.copyArray(blockIterator.keys);
        this.priKeys = this.coll.isSecondary() ? this.copyArray(blockIterator.priKeys) : this.keys;
        this.values = this.copyArray(blockIterator.values);
        this.nextIndex = blockIterator.nextIndex;
        this.dataIndex = blockIterator.dataIndex;
        this.dataObject = blockIterator.dataObject;
    }

    private byte[][] copyArray(byte[][] byArray) {
        byte[][] byArrayArray = new byte[byArray.length][];
        for (int i = 0; i < byArrayArray.length; ++i) {
            if (byArray[i] == null) continue;
            byArrayArray[i] = KeyRange.copyBytes(byArray[i]);
        }
        return byArrayArray;
    }

    private boolean isNextAvailable() {
        return this.nextIndex < this.keys.length && this.keys[this.nextIndex] != null;
    }

    private boolean isPrevAvailable() {
        return this.nextIndex > 0 && this.keys[this.nextIndex - 1] != null;
    }

    private int getRecordNumber(int n) {
        if (this.coll.view.btreeRecNumDb) {
            DataCursor dataCursor;
            block6: {
                dataCursor = null;
                dataCursor = new DataCursor(this.coll.view, false);
                if (!this.moveCursor(n, dataCursor)) break block6;
                int n2 = dataCursor.getCurrentRecordNumber();
                this.closeCursor(dataCursor);
                return n2;
            }
            try {
                try {
                    throw new IllegalStateException();
                }
                catch (DatabaseException databaseException) {
                    throw StoredContainer.convertException(databaseException);
                }
            }
            catch (Throwable throwable) {
                this.closeCursor(dataCursor);
                throw throwable;
            }
        }
        DatabaseEntry databaseEntry = new DatabaseEntry(this.keys[n]);
        return DbCompat.getRecordNumber(databaseEntry);
    }

    private void makeDataObject() {
        int n = this.dataIndex;
        DatabaseEntry databaseEntry = new DatabaseEntry(this.keys[n]);
        DatabaseEntry databaseEntry2 = this.keys != this.priKeys ? new DatabaseEntry(this.priKeys[n]) : databaseEntry;
        DatabaseEntry databaseEntry3 = new DatabaseEntry(this.values[n]);
        this.dataObject = this.coll.makeIteratorData(this, databaseEntry, databaseEntry2, databaseEntry3);
    }

    private void clearSlots() {
        for (int i = 0; i < this.keys.length; ++i) {
            this.keys[i] = null;
            this.priKeys[i] = null;
            this.values[i] = null;
        }
    }

    private void setSlot(int n, DataCursor dataCursor) {
        this.keys[n] = KeyRange.getByteArray(dataCursor.getKeyThang());
        if (this.keys != this.priKeys) {
            this.priKeys[n] = KeyRange.getByteArray(dataCursor.getPrimaryKeyThang());
        }
        this.values[n] = KeyRange.getByteArray(dataCursor.getValueThang());
    }

    private void insertSlot(int n, DataCursor dataCursor) {
        if (n < this.keys.length) {
            for (int i = this.keys.length - 1; i > n; --i) {
                this.keys[i] = this.keys[i - 1];
                this.priKeys[i] = this.priKeys[i - 1];
                this.values[i] = this.values[i - 1];
                if (!this.coll.view.recNumRenumber || this.keys[i] == null) continue;
                this.bumpRecordNumber(i);
            }
            ++this.nextIndex;
        } else {
            if (n != this.keys.length) {
                throw new IllegalStateException();
            }
            --n;
            for (int i = 0; i < n; ++i) {
                this.keys[i] = this.keys[i + 1];
                this.priKeys[i] = this.priKeys[i + 1];
                this.values[i] = this.values[i + 1];
            }
        }
        this.setSlot(n, dataCursor);
        this.dataIndex = -1;
    }

    private void bumpRecordNumber(int n) {
        DatabaseEntry databaseEntry = new DatabaseEntry(this.keys[n]);
        DbCompat.setRecordNumber(databaseEntry, DbCompat.getRecordNumber(databaseEntry) + 1);
        this.keys[n] = databaseEntry.getData();
    }

    private void deleteSlot(int n) {
        int n2;
        for (n2 = n + 1; n2 < this.keys.length; ++n2) {
            this.keys[n2 - 1] = this.keys[n2];
            this.priKeys[n2 - 1] = this.priKeys[n2];
            this.values[n2 - 1] = this.values[n2];
        }
        n2 = this.keys.length - 1;
        this.keys[n2] = null;
        this.priKeys[n2] = null;
        this.values[n2] = null;
        if (this.nextIndex > n) {
            --this.nextIndex;
        }
        this.dataIndex = -1;
    }

    private boolean moveCursor(int n, DataCursor dataCursor) throws DatabaseException {
        return dataCursor.repositionExact(this.keys[n], this.priKeys[n], this.values[n], false);
    }

    private void closeCursor(DataCursor dataCursor) {
        if (dataCursor != null) {
            try {
                dataCursor.close();
            }
            catch (DatabaseException databaseException) {
                throw StoredContainer.convertException(databaseException);
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.isNextAvailable()) {
            return true;
        }
        DataCursor dataCursor = null;
        try {
            dataCursor = new DataCursor(this.coll.view, this.writeAllowed);
            int n = this.nextIndex - 1;
            boolean bl = false;
            if (this.keys[n] == null) {
                OperationStatus operationStatus = dataCursor.getFirst(false);
                if (operationStatus == OperationStatus.SUCCESS) {
                    bl = true;
                    this.nextIndex = 0;
                }
            } else {
                int n2 = dataCursor.repositionRange(this.keys[n], this.priKeys[n], this.values[n], false);
                if (n2 == 0) {
                    bl = true;
                    this.nextIndex = 1;
                    if (this.dataIndex == n) {
                        this.dataIndex = 0;
                    } else {
                        this.dataIndex = -1;
                        this.dataObject = null;
                    }
                } else if (n2 == 1) {
                    bl = true;
                    this.nextIndex = 0;
                    this.dataIndex = -1;
                    this.dataObject = null;
                } else if (n2 != 2) {
                    throw new IllegalStateException();
                }
            }
            if (bl) {
                this.clearSlots();
                int n3 = 0;
                boolean bl2 = false;
                while (!bl2) {
                    this.setSlot(n3, dataCursor);
                    if (++n3 < this.keys.length) {
                        OperationStatus operationStatus = this.coll.iterateDuplicates() ? dataCursor.getNext(false) : dataCursor.getNextNoDup(false);
                        if (operationStatus == OperationStatus.SUCCESS) continue;
                        bl2 = true;
                        continue;
                    }
                    bl2 = true;
                }
            }
            boolean bl3 = this.isNextAvailable();
            this.closeCursor(dataCursor);
            return bl3;
        }
        catch (DatabaseException databaseException) {
            try {
                throw StoredContainer.convertException(databaseException);
            }
            catch (Throwable throwable) {
                this.closeCursor(dataCursor);
                throw throwable;
            }
        }
    }

    @Override
    public boolean hasPrevious() {
        if (this.isPrevAvailable()) {
            return true;
        }
        if (!this.isNextAvailable()) {
            return false;
        }
        DataCursor dataCursor = null;
        try {
            int n;
            dataCursor = new DataCursor(this.coll.view, this.writeAllowed);
            int n2 = this.keys.length - 1;
            int n3 = this.nextIndex;
            boolean bl = false;
            int n4 = dataCursor.repositionRange(this.keys[n3], this.priKeys[n3], this.values[n3], false);
            if (n4 == 0 || n4 == 1) {
                bl = true;
                this.nextIndex = n2;
                if (this.dataIndex == n3 && n4 == 0) {
                    this.dataIndex = n2;
                } else {
                    this.dataIndex = -1;
                    this.dataObject = null;
                }
            } else if (n4 != 2) {
                throw new IllegalStateException();
            }
            if (bl) {
                this.clearSlots();
                n = n2;
                boolean bl2 = false;
                while (!bl2) {
                    this.setSlot(n, dataCursor);
                    if (--n >= 0) {
                        OperationStatus operationStatus = this.coll.iterateDuplicates() ? dataCursor.getPrev(false) : dataCursor.getPrevNoDup(false);
                        if (operationStatus == OperationStatus.SUCCESS) continue;
                        bl2 = true;
                        continue;
                    }
                    bl2 = true;
                }
            }
            n = this.isPrevAvailable();
            this.closeCursor(dataCursor);
            return n != 0;
        }
        catch (DatabaseException databaseException) {
            try {
                throw StoredContainer.convertException(databaseException);
            }
            catch (Throwable throwable) {
                this.closeCursor(dataCursor);
                throw throwable;
            }
        }
    }

    @Override
    public Object next() {
        if (this.hasNext()) {
            this.dataIndex = this.nextIndex++;
            this.makeDataObject();
            return this.dataObject;
        }
        throw new NoSuchElementException();
    }

    public Object previous() {
        if (this.hasPrevious()) {
            --this.nextIndex;
            this.dataIndex = this.nextIndex;
            this.makeDataObject();
            return this.dataObject;
        }
        throw new NoSuchElementException();
    }

    @Override
    public int nextIndex() {
        if (!this.coll.view.recNumAccess) {
            throw new UnsupportedOperationException("Record number access not supported");
        }
        return this.hasNext() ? this.getRecordNumber(this.nextIndex) - this.coll.getIndexOffset() : Integer.MAX_VALUE;
    }

    @Override
    public int previousIndex() {
        if (!this.coll.view.recNumAccess) {
            throw new UnsupportedOperationException("Record number access not supported");
        }
        return this.hasPrevious() ? this.getRecordNumber(this.nextIndex - 1) - this.coll.getIndexOffset() : -1;
    }

    public void set(Object object) {
        if (this.dataObject == null) {
            throw new IllegalStateException();
        }
        if (!this.coll.hasValues()) {
            throw new UnsupportedOperationException();
        }
        DataCursor dataCursor = null;
        boolean bl = this.coll.beginAutoCommit();
        try {
            dataCursor = new DataCursor(this.coll.view, this.writeAllowed);
            if (!this.moveCursor(this.dataIndex, dataCursor)) {
                throw new IllegalStateException();
            }
            dataCursor.putCurrent(object);
            this.setSlot(this.dataIndex, dataCursor);
            this.coll.closeCursor(dataCursor);
            this.coll.commitAutoCommit(bl);
        }
        catch (Exception exception) {
            this.coll.closeCursor(dataCursor);
            throw this.coll.handleException(exception, bl);
        }
    }

    @Override
    public void remove() {
        if (this.dataObject == null) {
            throw new IllegalStateException();
        }
        DataCursor dataCursor = null;
        boolean bl = this.coll.beginAutoCommit();
        try {
            dataCursor = new DataCursor(this.coll.view, this.writeAllowed);
            if (this.moveCursor(this.dataIndex, dataCursor)) {
                dataCursor.delete();
                this.deleteSlot(this.dataIndex);
                this.dataObject = null;
                if (this.nextIndex == 0 && this.keys[0] == null) {
                    OperationStatus operationStatus;
                    int n;
                    for (n = 0; n < this.keys.length; ++n) {
                        OperationStatus operationStatus2 = operationStatus = this.coll.iterateDuplicates() ? dataCursor.getNext(false) : dataCursor.getNextNoDup(false);
                        if (operationStatus != OperationStatus.SUCCESS) break;
                        this.setSlot(n, dataCursor);
                    }
                    if (this.keys[0] == null) {
                        this.nextIndex = this.keys.length;
                        for (n = this.nextIndex - 1; n >= 0; --n) {
                            OperationStatus operationStatus3 = operationStatus = this.coll.iterateDuplicates() ? dataCursor.getPrev(false) : dataCursor.getPrevNoDup(false);
                            if (operationStatus != OperationStatus.SUCCESS) break;
                            this.setSlot(n, dataCursor);
                        }
                    }
                }
            } else {
                throw new IllegalStateException();
            }
            this.coll.closeCursor(dataCursor);
            this.coll.commitAutoCommit(bl);
        }
        catch (Exception exception) {
            this.coll.closeCursor(dataCursor);
            throw this.coll.handleException(exception, bl);
        }
    }

    public void add(Object object) {
        this.coll.checkIterAddAllowed();
        OperationStatus operationStatus = OperationStatus.SUCCESS;
        DataCursor dataCursor = null;
        boolean bl = this.coll.beginAutoCommit();
        try {
            if (this.coll.view.keysRenumbered || !this.coll.areDuplicatesOrdered()) {
                boolean bl2 = this.hasPrevious();
                if (!bl2 && !this.hasNext()) {
                    if (this.coll.view.keysRenumbered) {
                        operationStatus = this.coll.view.append(object, null, null);
                    } else if (this.coll.view.dupsAllowed && this.coll.view.range.isSingleKey()) {
                        dataCursor = new DataCursor(this.coll.view, this.writeAllowed);
                        dataCursor.useRangeKey();
                        operationStatus = dataCursor.putNoDupData(null, object, null, true);
                        this.coll.closeCursor(dataCursor);
                        dataCursor = null;
                    } else {
                        throw new IllegalStateException("Collection is empty, cannot add() duplicate");
                    }
                    if (operationStatus == OperationStatus.SUCCESS) {
                        this.next();
                        this.dataIndex = this.nextIndex - 1;
                    }
                } else {
                    int n;
                    dataCursor = new DataCursor(this.coll.view, this.writeAllowed);
                    int n2 = n = bl2 ? this.nextIndex - 1 : this.nextIndex;
                    if (!this.moveCursor(n, dataCursor)) {
                        throw new IllegalStateException();
                    }
                    OperationStatus operationStatus2 = operationStatus = bl2 ? dataCursor.putAfter(object) : dataCursor.putBefore(object);
                    if (operationStatus == OperationStatus.SUCCESS) {
                        this.insertSlot(this.nextIndex, dataCursor);
                    }
                }
            } else {
                dataCursor = new DataCursor(this.coll.view, this.writeAllowed);
                if (this.coll.view.range.isSingleKey()) {
                    dataCursor.useRangeKey();
                } else if (this.dataIndex < 0 || !this.moveCursor(this.dataIndex, dataCursor)) {
                    throw new IllegalStateException();
                }
                operationStatus = dataCursor.putNoDupData(null, object, null, true);
                if (operationStatus == OperationStatus.SUCCESS) {
                    this.clearSlots();
                    this.setSlot(0, dataCursor);
                    this.dataIndex = 0;
                    this.nextIndex = 1;
                }
            }
            if (operationStatus == OperationStatus.KEYEXIST) {
                throw new IllegalArgumentException("Duplicate value");
            }
            if (operationStatus != OperationStatus.SUCCESS) {
                throw new IllegalArgumentException("Could not insert: " + operationStatus);
            }
            this.dataObject = null;
            this.coll.closeCursor(dataCursor);
            this.coll.commitAutoCommit(bl);
        }
        catch (Exception exception) {
            this.coll.closeCursor(dataCursor);
            throw this.coll.handleException(exception, bl);
        }
    }

    @Override
    public final ListIterator dup() {
        return new BlockIterator(this);
    }

    @Override
    public final boolean isCurrentData(Object object) {
        return this.dataObject == object;
    }

    @Override
    public final boolean moveToIndex(int n) {
        DataCursor dataCursor;
        block5: {
            dataCursor = null;
            dataCursor = new DataCursor(this.coll.view, this.writeAllowed);
            OperationStatus operationStatus = dataCursor.getSearchKey(new Integer(n), null, false);
            if (operationStatus != OperationStatus.SUCCESS) break block5;
            this.clearSlots();
            this.setSlot(0, dataCursor);
            this.nextIndex = 0;
            boolean bl = true;
            this.closeCursor(dataCursor);
            return bl;
        }
        try {
            boolean bl = false;
            this.closeCursor(dataCursor);
            return bl;
        }
        catch (DatabaseException databaseException) {
            try {
                throw StoredContainer.convertException(databaseException);
            }
            catch (Throwable throwable) {
                this.closeCursor(dataCursor);
                throw throwable;
            }
        }
    }
}

