crystal_doc_search_index_callback({"repository_name":"Crystal","body":"# Crystal\n\n[![Linux CI Build Status](https://github.com/crystal-lang/crystal/workflows/Linux%20CI/badge.svg)](https://github.com/crystal-lang/crystal/actions?query=workflow%3A%22Linux+CI%22+event%3Apush+branch%3Amaster)\n[![macOS CI Build Status](https://github.com/crystal-lang/crystal/workflows/macOS%20CI/badge.svg)](https://github.com/crystal-lang/crystal/actions?query=workflow%3A%22macOS+CI%22+event%3Apush+branch%3Amaster)\n[![AArch64 CI Build Status](https://github.com/crystal-lang/crystal/workflows/AArch64%20CI/badge.svg)](https://github.com/crystal-lang/crystal/actions?query=workflow%3A%22AArch64+CI%22+event%3Apush+branch%3Amaster)\n[![Windows CI Build Status](https://github.com/crystal-lang/crystal/workflows/Windows%20CI/badge.svg)](https://github.com/crystal-lang/crystal/actions?query=workflow%3A%22Windows+CI%22+event%3Apush+branch%3Amaster)\n[![CircleCI Build Status](https://circleci.com/gh/crystal-lang/crystal/tree/master.svg?style=shield)](https://circleci.com/gh/crystal-lang/crystal)\n[![Join the chat at https://gitter.im/crystal-lang/crystal](https://badges.gitter.im/crystal-lang/crystal.svg)](https://gitter.im/crystal-lang/crystal)\n[![Code Triagers Badge](https://www.codetriage.com/crystal-lang/crystal/badges/users.svg)](https://www.codetriage.com/crystal-lang/crystal)\n\n---\n\n[![Crystal - Born and raised at Manas](doc/assets/crystal-born-and-raised.svg)](https://manas.tech/)\n\nCrystal is a programming language with the following goals:\n\n- Have a syntax similar to Ruby (but compatibility with it is not a goal)\n- Statically type-checked but without having to specify the type of variables or method arguments.\n- Be able to call C code by writing bindings to it in Crystal.\n- Have compile-time evaluation and generation of code, to avoid boilerplate code.\n- Compile to efficient native code.\n\n## Why?\n\nWe love Ruby's efficiency for writing code.\n\nWe love C's efficiency for running code.\n\nWe want the best of both worlds.\n\nWe want the compiler to understand what we mean without having to specify types everywhere.\n\nWe want full OOP.\n\nOh, and we don't want to write C code to make the code run faster.\n\n## Project Status\n\nWithin a major version, language features won't be removed or changed in any way that could prevent a Crystal program written with that version from compiling and working. The built-in standard library might be enriched, but it will always be done with backwards compatibility in mind.\n\nDevelopment of the Crystal language is possible thanks to the community's effort and the continued support of [84codes](https://www.84codes.com/) and every other [sponsor](https://crystal-lang.org/sponsors).\n\n## Installing\n\n[Follow these installation instructions](https://crystal-lang.org/install)\n\n## Try it online\n\n[play.crystal-lang.org](https://play.crystal-lang.org/)\n\n## Documentation\n\n- [Language Reference](http://crystal-lang.org/reference)\n- [Standard library API](https://crystal-lang.org/api)\n- [Roadmap](https://github.com/crystal-lang/crystal/wiki/Roadmap)\n\n## Community\n\nHave any questions or suggestions? Ask on the [Crystal Forum](https://forum.crystal-lang.org), on our [Gitter channel](https://gitter.im/crystal-lang/crystal) or IRC channel [#crystal-lang](https://web.libera.chat/#crystal-lang) at irc.libera.chat, or on Stack Overflow under the [crystal-lang](http://stackoverflow.com/questions/tagged/crystal-lang) tag. There is also an archived [Google Group](https://groups.google.com/forum/?fromgroups#!forum/crystal-lang).\n\n## Contributing\n\nThe Crystal repository is hosted at [crystal-lang/crystal](https://github.com/crystal-lang/crystal) on GitHub.\n\nRead the general [Contributing guide](https://github.com/crystal-lang/crystal/blob/master/CONTRIBUTING.md), and then:\n\n1. Fork it (<https://github.com/crystal-lang/crystal/fork>)\n2. Create your feature branch (`git checkout -b my-new-feature`)\n3. Commit your changes (`git commit -am 'Add some feature'`)\n4. Push to the branch (`git push origin my-new-feature`)\n5. Create a new Pull Request\n","program":{"html_id":"Crystal/toplevel","path":"toplevel.html","kind":"module","full_name":"Top Level Namespace","name":"Top Level Namespace","abstract":false,"ancestors":[{"html_id":"Crystal/Spec/Methods","kind":"module","full_name":"Spec::Methods","name":"Methods"},{"html_id":"Crystal/Spec/Expectations","kind":"module","full_name":"Spec::Expectations","name":"Expectations"}],"locations":[],"repository_name":"Crystal","program":true,"enum":false,"alias":false,"const":false,"constants":[{"id":"ARGF","name":"ARGF","value":"IO::ARGF.new(ARGV, STDIN)","doc":"An `IO` for reading files from `ARGV`.\n\nUsage example:\n\n`program.cr`:\n```\nputs ARGF.gets_to_end\n```\n\nA file to read from: (`file`)\n```text\n123\n```\n\n```text\n$ crystal build program.cr\n$ ./program file\n123\n$ ./program file file\n123123\n$ # If ARGV is empty, ARGF reads from STDIN instead:\n$ echo \"hello\" | ./program\nhello\n$ ./program unknown\nUnhandled exception: Error opening file with mode 'r': 'unknown': No such file or directory (File::NotFoundError)\n...\n```\n\nAfter a file from `ARGV` has been read, it's removed from `ARGV`.\n\nYou can manipulate `ARGV` yourself to control what `ARGF` operates on.\nIf you remove a file from `ARGV`, it is ignored by `ARGF`; if you add files to `ARGV`, `ARGF` will read from it.\n\n```\nARGV.replace [\"file1\"]\nARGF.gets_to_end # => Content of file1\nARGV             # => []\nARGV << \"file2\"\nARGF.gets_to_end # => Content of file2\n```","summary":"<p>An <code><a href=\"IO.html\">IO</a></code> for reading files from <code><a href=\"toplevel.html#ARGV\">ARGV</a></code>.</p>"},{"id":"ARGV","name":"ARGV","value":"Array.new(ARGC_UNSAFE - 1) do |i| String.new(ARGV_UNSAFE[1 + i]) end","doc":"An array of arguments passed to the program.","summary":"<p>An array of arguments passed to the program.</p>"},{"id":"EOL","name":"EOL","value":"{% if flag?(:windows) %}\n        \"\\r\\n\"\n      {% else %}\n        \"\\n\"\n      {% end %}","doc":"The newline constant","summary":"<p>The newline constant</p>"},{"id":"PROGRAM_NAME","name":"PROGRAM_NAME","value":"String.new(ARGV_UNSAFE.value)","doc":"The name, the program was called with.\n\nThe result may be a relative or absolute path (including symbolic links),\njust the command name or the empty string.\n\nSee `Process.executable_path` for a more convenient alternative that always\nreturns the absolute real path to the executable file (if it exists).","summary":"<p>The name, the program was called with.</p>"},{"id":"STDERR","name":"STDERR","value":"IO::FileDescriptor.from_stdio(2)","doc":"The standard error file descriptor.\n\nTypically used to output error messages and diagnostics.\n\nAt the start of the program STDERR is configured like this:\n- if it's a TTY device (like the console) then `sync` is `true`,\n  meaning that output will be outputted as soon as it is written\n  to STDERR. This is so users can see real time output data.\n- if it's not a TTY device (like a file, or because the output\n  was piped to a file) then `sync` is `false` but `flush_on_newline`\n  is `true`. This is so that if you pipe the output to a file, and,\n  for example, you `tail -f`, you can see data on a line-per-line basis.\n  This is convenient but slower than with `flush_on_newline` set to `false`.\n  If you need a bit more performance and you don't care about near real-time\n  output you can do `STDERR.flush_on_newline = false`.\n\nOn Unix systems, if the file descriptor is a TTY, the runtime duplicates it.\nSo `STDERR.fd` might not be `2`.\nThe reason for this is to enable non-blocking writes for concurrency. Other fibers\ncan run while waiting on IO. The original file descriptor is\ninherited from the parent process. Setting it to non-blocking mode would\nreflect back which can cause problems.\n\nOn Windows, `STDERR` is always blocking.","summary":"<p>The standard error file descriptor.</p>"},{"id":"STDIN","name":"STDIN","value":"IO::FileDescriptor.from_stdio(0)","doc":"The standard input file descriptor. Contains data piped to the program.\n\nOn Unix systems, if the file descriptor is a TTY, the runtime duplicates it.\nSo `STDIN.fd` might not be `0`.\nThe reason for this is to enable non-blocking reads for concurrency. Other fibers\ncan run while waiting on user input. The original file descriptor is\ninherited from the parent process. Setting it to non-blocking mode would\nreflect back, which can cause problems.\n\nOn Windows, `STDIN` is always blocking.","summary":"<p>The standard input file descriptor.</p>"},{"id":"STDOUT","name":"STDOUT","value":"IO::FileDescriptor.from_stdio(1)","doc":"The standard output file descriptor.\n\nTypically used to output data and information.\n\nAt the start of the program STDOUT is configured like this:\n- if it's a TTY device (like the console) then `sync` is `true`,\n  meaning that output will be outputted as soon as it is written\n  to STDOUT. This is so users can see real time output data.\n- if it's not a TTY device (like a file, or because the output\n  was piped to a file) then `sync` is `false` but `flush_on_newline`\n  is `true`. This is so that if you pipe the output to a file, and,\n  for example, you `tail -f`, you can see data on a line-per-line basis.\n  This is convenient but slower than with `flush_on_newline` set to `false`.\n  If you need a bit more performance and you don't care about near real-time\n  output you can do `STDOUT.flush_on_newline = false`.\n\nOn Unix systems, if the file descriptor is a TTY, the runtime duplicates it.\nSo `STDOUT.fd` might not be `1`.\nThe reason for this is to enable non-blocking writes for concurrency. Other fibers\ncan run while waiting on IO. The original file descriptor is\ninherited from the parent process. Setting it to non-blocking mode would\nreflect back which can cause problems.\n\nOn Windows, `STDOUT` is always blocking.","summary":"<p>The standard output file descriptor.</p>"}],"included_modules":[{"html_id":"Crystal/Spec/Expectations","kind":"module","full_name":"Spec::Expectations","name":"Expectations"},{"html_id":"Crystal/Spec/Methods","kind":"module","full_name":"Spec::Methods","name":"Methods"}],"extended_modules":[{"html_id":"Crystal/Spec/Expectations","kind":"module","full_name":"Spec::Expectations","name":"Expectations"},{"html_id":"Crystal/Spec/Methods","kind":"module","full_name":"Spec::Methods","name":"Methods"}],"class_methods":[{"html_id":"`(command:String):String-class-method","name":"`","doc":"Returns the standard output of executing *command* in a subshell.\nStandard input, and error are inherited.\nThe special `$?` variable is set to a `Process::Status` associated with this execution.\n\nIt is impossible to call this method with any regular call syntax. There is an associated literal type which calls the method with the literal content as command:\n\n```\n`echo hi`   # => \"hi\\n\"\n$?.success? # => true\n```\n\nSee [`Command` literals](https://crystal-lang.org/reference/syntax_and_semantics/literals/command.html) in the language reference.","summary":"<p>Returns the standard output of executing <em>command</em> in a subshell.</p>","abstract":false,"args":[{"name":"command","external_name":"command","restriction":"String"}],"args_string":"(command : String) : String","args_html":"(command : <a href=\"String.html\">String</a>) : <a href=\"String.html\">String</a>","location":{"filename":"src/process.cr","line_number":523,"url":null},"def":{"name":"`","args":[{"name":"command","external_name":"command","restriction":"String"}],"return_type":"String","visibility":"Public","body":"process = Process.new(command, shell: true, input: Process::Redirect::Inherit, output: Process::Redirect::Pipe, error: Process::Redirect::Inherit)\noutput = process.output.gets_to_end\nstatus = process.wait\n$? = status\noutput\n"},"external_var":false},{"html_id":"abort(message=nil,status=1):NoReturn-class-method","name":"abort","doc":"Terminates execution immediately, printing *message* to `STDERR` and\nthen calling `exit(status)`.","summary":"<p>Terminates execution immediately, printing <em>message</em> to <code><a href=\"toplevel.html#STDERR\">STDERR</a></code> and then calling <code><a href=\"toplevel.html#exit%28status%3AInt32%7CProcess%3A%3AStatus%3D0%29%3ANoReturn-class-method\">exit(status)</a></code>.</p>","abstract":false,"args":[{"name":"message","default_value":"nil","external_name":"message","restriction":""},{"name":"status","default_value":"1","external_name":"status","restriction":""}],"args_string":"(message = nil, status = 1) : NoReturn","args_html":"(message = <span class=\"n\">nil</span>, status = <span class=\"n\">1</span>) : NoReturn","location":{"filename":"src/kernel.cr","line_number":575,"url":null},"def":{"name":"abort","args":[{"name":"message","default_value":"nil","external_name":"message","restriction":""},{"name":"status","default_value":"1","external_name":"status","restriction":""}],"return_type":"NoReturn","visibility":"Public","body":"if message\n  Crystal.ignore_stdio_errors do STDERR.puts(message) end\nend\nexit(status)\n"},"external_var":false},{"html_id":"alignof(type:Class):Int32-class-method","name":"alignof","doc":"Returns the alignment of the given type as number of bytes.\n\n*type* must be a constant or `typeof()` expression. It cannot be evaluated\nat runtime.\n\n```\nalignof(Int32)        # => 4\nalignof(Float64)      # usually 4 or 8\nalignof(typeof(true)) # => 1\n```\n\nFor `Reference` types, the alignment is the same as the alignment of a pointer:\n\n```\n# On a 64 bits machine\nalignof(Pointer(Int32)) # => 8\nalignof(String)         # => 8\n```\n\nThis is because a `Reference`'s memory is allocated on the heap and a pointer\nto it is passed around. The alignment of a class on the heap can be determined\nusing `#instance_alignof`.\n\n* See [`alignof`](https://crystal-lang.org/reference/syntax_and_semantics/alignof.html) in the language specification.\nNOTE: This is a pseudo-method provided directly by the Crystal compiler.\nIt cannot be redefined nor overridden.","summary":"<p>Returns the alignment of the given type as number of bytes.</p>","abstract":false,"args":[{"name":"type","external_name":"type","restriction":"Class"}],"args_string":"(type : Class) : Int32","args_html":"(type : <a href=\"Class.html\">Class</a>) : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/docs_pseudo_methods.cr","line_number":94,"url":null},"def":{"name":"__crystal_pseudo_alignof","args":[{"name":"type","external_name":"type","restriction":"Class"}],"return_type":"Int32","visibility":"Public","body":""},"external_var":false},{"html_id":"at_exit(&handler:Int32,Exception|Nil->):Nil-class-method","name":"at_exit","doc":"Registers the given `Proc` for execution when the program exits regularly.\n\nA regular exit happens when either\n* the main fiber reaches the end of the program,\n* the main fiber rescues an unhandled exception, or\n* `::exit` is called.\n\n`Process.exit` does *not* trigger `at_exit` handlers, nor does external process\ntermination (see `Process.on_terminate` for handling that).\n\nIf multiple handlers are registered, they are executed in reverse order of registration.\n\n```\ndef do_at_exit(str1)\n  at_exit { print str1 }\nend\n\nat_exit { puts \"cruel world\" }\ndo_at_exit(\"goodbye \")\nexit\n```\n\nProduces:\n\n```text\ngoodbye cruel world\n```\n\nThe exit status code that will be returned by this program is passed to\nthe block as its first argument. In case of any unhandled exception, it is\npassed as the second argument to the block, if the program terminates\nnormally or `exit(status)` is called explicitly, then the second argument\nwill be `nil`.\n\nNOTE: If `at_exit` is called inside an `at_exit` handler, it will be called\nright after the current `at_exit` handler ends, and then other handlers\nwill be invoked.","summary":"<p>Registers the given <code><a href=\"Proc.html\">Proc</a></code> for execution when the program exits regularly.</p>","abstract":false,"location":{"filename":"src/kernel.cr","line_number":558,"url":null},"def":{"name":"at_exit","yields":2,"block_arity":2,"block_arg":{"name":"handler","external_name":"handler","restriction":"(Int32, Exception | ::Nil ->)"},"return_type":"Nil","visibility":"Public","body":"Crystal::AtExitHandlers.add(handler)"},"external_var":false},{"html_id":"caller:Array(String)-class-method","name":"caller","doc":"Returns the current execution stack as an array containing strings\nusually in the form file:line:column or file:line:column in 'method'.","summary":"<p>Returns the current execution stack as an array containing strings usually in the form file:line:column or file:line:column in 'method'.</p>","abstract":false,"location":{"filename":"src/exception/call_stack.cr","line_number":3,"url":null},"def":{"name":"caller","return_type":"Array(String)","visibility":"Public","body":"Exception::CallStack.new.printable_backtrace"},"external_var":false},{"html_id":"exit(status:Int32|Process::Status=0):NoReturn-class-method","name":"exit","doc":"Terminates execution immediately, returning the given status code\nto the invoking environment.\n\nRegistered `at_exit` procs are executed.","summary":"<p>Terminates execution immediately, returning the given status code to the invoking environment.</p>","abstract":false,"args":[{"name":"status","default_value":"0","external_name":"status","restriction":"Int32 | Process::Status"}],"args_string":"(status : Int32 | Process::Status = 0) : NoReturn","args_html":"(status : <a href=\"Int32.html\">Int32</a> | <a href=\"Process/Status.html\">Process::Status</a> = <span class=\"n\">0</span>) : NoReturn","location":{"filename":"src/kernel.cr","line_number":566,"url":null},"def":{"name":"exit","args":[{"name":"status","default_value":"0","external_name":"status","restriction":"Int32 | Process::Status"}],"return_type":"NoReturn","visibility":"Public","body":"status = Crystal::AtExitHandlers.run(status)\nCrystal.ignore_stdio_errors do STDOUT.flush end\nCrystal.ignore_stdio_errors do STDERR.flush end\nProcess.exit(status)\n"},"external_var":false},{"html_id":"gets(*args,**options)-class-method","name":"gets","doc":"Reads a line from `STDIN`.\n\nSee also: `IO#gets`.","summary":"<p>Reads a line from <code><a href=\"toplevel.html#STDIN\">STDIN</a></code>.</p>","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/kernel.cr","line_number":150,"url":null},"def":{"name":"gets","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"visibility":"Public","body":"STDIN.gets(*args, **options)"},"external_var":false},{"html_id":"instance_alignof(type:Class):Int32-class-method","name":"instance_alignof","doc":"Returns the instance alignment of the given class as number of bytes.\n\n*type* must be a constant or `typeof()` expression. It cannot be evaluated at runtime.\n\n```\ninstance_alignof(String)    # => 4\ninstance_alignof(Exception) # => 8\n```\n\nSee `alignof` for determining the size of value types.\n\n* See [`instance_alignof`](https://crystal-lang.org/reference/syntax_and_semantics/instance_alignof.html) in the language specification.\nNOTE: This is a pseudo-method provided directly by the Crystal compiler.\nIt cannot be redefined nor overridden.","summary":"<p>Returns the instance alignment of the given class as number of bytes.</p>","abstract":false,"args":[{"name":"type","external_name":"type","restriction":"Class"}],"args_string":"(type : Class) : Int32","args_html":"(type : <a href=\"Class.html\">Class</a>) : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/docs_pseudo_methods.cr","line_number":109,"url":null},"def":{"name":"__crystal_pseudo_instance_alignof","args":[{"name":"type","external_name":"type","restriction":"Class"}],"return_type":"Int32","visibility":"Public","body":""},"external_var":false},{"html_id":"instance_sizeof(type:Class):Int32-class-method","name":"instance_sizeof","doc":"Returns the instance size of the given class as number of bytes.\n\n*type* must be a constant or `typeof()` expression. It cannot be evaluated at runtime.\n\n```\ninstance_sizeof(String)    # => 16\ninstance_sizeof(Exception) # => 48\n```\n\nSee `sizeof` for determining the size of value types.\n\n* See [`instance_sizeof`](https://crystal-lang.org/reference/syntax_and_semantics/instance_sizeof.html) in the language specification.\nNOTE: This is a pseudo-method provided directly by the Crystal compiler.\nIt cannot be redefined nor overridden.","summary":"<p>Returns the instance size of the given class as number of bytes.</p>","abstract":false,"args":[{"name":"type","external_name":"type","restriction":"Class"}],"args_string":"(type : Class) : Int32","args_html":"(type : <a href=\"Class.html\">Class</a>) : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/docs_pseudo_methods.cr","line_number":67,"url":null},"def":{"name":"__crystal_pseudo_instance_sizeof","args":[{"name":"type","external_name":"type","restriction":"Class"}],"return_type":"Int32","visibility":"Public","body":""},"external_var":false},{"html_id":"loop(&)-class-method","name":"loop","doc":"Repeatedly executes the block.\n\n```\nloop do\n  line = gets\n  break unless line\n  # ...\nend\n```","summary":"<p>Repeatedly executes the block.</p>","abstract":false,"location":{"filename":"src/kernel.cr","line_number":141,"url":null},"def":{"name":"loop","yields":0,"block_arity":0,"visibility":"Public","body":"while true\n  yield\nend"},"external_var":false},{"html_id":"main(argc:Int32,argv:Pointer(Pointer(UInt8))):Int32-class-method","name":"main","doc":"Main function that acts as C's main function.\nInvokes `Crystal.main`.\n\nCan be redefined. See `Crystal.main` for examples.\n\nOn Windows the actual entry point is `wmain`, but there is no need to redefine\nthat. See the file required below for details.","summary":"<p>Main function that acts as C's main function.</p>","abstract":false,"args":[{"name":"argc","external_name":"argc","restriction":""},{"name":"argv","external_name":"argv","restriction":""}],"args_string":"(argc : Int32, argv : Pointer(Pointer(UInt8))) : Int32","args_html":"(argc : <a href=\"Int32.html\">Int32</a>, argv : <a href=\"Pointer.html\">Pointer</a>(<a href=\"Pointer.html\">Pointer</a>(<a href=\"UInt8.html\">UInt8</a>))) : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/crystal/system/unix/main.cr","line_number":8,"url":null},"def":{"name":"main","args":[{"name":"argc","external_name":"argc","restriction":""},{"name":"argv","external_name":"argv","restriction":""}],"return_type":"Int32","visibility":"Public","body":"status = Crystal.main(argc, argv)\nLibC.exit(status)\n"},"external_var":false},{"html_id":"offsetof(type:Class,offset):Int32-class-method","name":"offsetof","doc":"Returns the byte offset of an instance variable in a struct or class type.\n\n*type* must be a constant or `typeof()` expression. It cannot be evaluated at runtime.\n*offset*  must be the name of an instance variable of *type*, prefixed by `@`,\nor the index of an element in a Tuple, starting from 0, if *type* is a `Tuple`.\n```\noffsetof(String, @bytesize)       # => 4\noffsetof(Exception, @message)     # => 8\noffsetof(Time, @location)         # => 16\noffsetof({Int32, Int8, Int32}, 0) # => 0\noffsetof({Int32, Int8, Int32}, 1) # => 4\noffsetof({Int32, Int8, Int32}, 2) # => 8\n```\n\n* See [`offsetof`](https://crystal-lang.org/reference/syntax_and_semantics/offsetof.html) in the language specification.\nNOTE: This is a pseudo-method provided directly by the Crystal compiler.\nIt cannot be redefined nor overridden.","summary":"<p>Returns the byte offset of an instance variable in a struct or class type.</p>","abstract":false,"args":[{"name":"type","external_name":"type","restriction":"Class"},{"name":"offset","external_name":"offset","restriction":""}],"args_string":"(type : Class, offset) : Int32","args_html":"(type : <a href=\"Class.html\">Class</a>, offset) : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/docs_pseudo_methods.cr","line_number":143,"url":null},"def":{"name":"__crystal_pseudo_offsetof","args":[{"name":"type","external_name":"type","restriction":"Class"},{"name":"offset","external_name":"offset","restriction":""}],"return_type":"Int32","visibility":"Public","body":""},"external_var":false},{"html_id":"p(object)-class-method","name":"p","doc":"Inspects *object* to `STDOUT` followed\nby a newline. Returns *object*.\n\nSee also: `Object#inspect(io)`.","summary":"<p>Inspects <em>object</em> to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code> followed by a newline.</p>","abstract":false,"args":[{"name":"object","external_name":"object","restriction":""}],"args_string":"(object)","args_html":"(object)","location":{"filename":"src/kernel.cr","line_number":459,"url":null},"def":{"name":"p","args":[{"name":"object","external_name":"object","restriction":""}],"visibility":"Public","body":"object.inspect(STDOUT)\nputs\nobject\n"},"external_var":false},{"html_id":"p(*objects)-class-method","name":"p","doc":"Inspects each object in *objects* to `STDOUT`, followed\nby a newline. Returns *objects*.\n\nSee also: `Object#inspect(io)`.","summary":"<p>Inspects each object in <em>objects</em> to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code>, followed by a newline.</p>","abstract":false,"args":[{"name":"objects","external_name":"objects","restriction":""}],"args_string":"(*objects)","args_html":"(*objects)","location":{"filename":"src/kernel.cr","line_number":469,"url":null},"def":{"name":"p","args":[{"name":"objects","external_name":"objects","restriction":""}],"splat_index":0,"visibility":"Public","body":"objects.each do |obj|\n  p(obj)\nend\nobjects\n"},"external_var":false},{"html_id":"p(**objects)-class-method","name":"p","doc":"Inspects *objects* to `STDOUT`, followed\nby a newline. Returns *objects*.\n\n```\np foo: 23, bar: 42 # => {foo: 23, bar: 42}\n```\n\nSee `Object#inspect(io)`","summary":"<p>Inspects <em>objects</em> to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code>, followed by a newline.</p>","abstract":false,"location":{"filename":"src/kernel.cr","line_number":484,"url":null},"def":{"name":"p","double_splat":{"name":"objects","external_name":"objects","restriction":""},"visibility":"Public","body":"if objects.empty?\nelse\n  p(objects)\nend"},"external_var":false},{"html_id":"pointerof(variable:T):Pointer(T)forallT-class-method","name":"pointerof","doc":"Returns a `Pointer` to the contents of a variable.\n\n*variable* must be a variable (local, instance, class or library).\n\n```\na = 1\nptr = pointerof(a)\nptr.value = 2\n\na # => 2\n```\n\n* See [`pointerof`](https://crystal-lang.org/reference/syntax_and_semantics/pointerof.html) in the language specification.\nNOTE: This is a pseudo-method provided directly by the Crystal compiler.\nIt cannot be redefined nor overridden.","summary":"<p>Returns a <code><a href=\"Pointer.html\">Pointer</a></code> to the contents of a variable.</p>","abstract":false,"args":[{"name":"variable","external_name":"variable","restriction":"T"}],"args_string":"(variable : T) : Pointer(T) forall T","args_html":"(variable : T) : <a href=\"Pointer.html\">Pointer</a>(T) forall T","location":{"filename":"src/docs_pseudo_methods.cr","line_number":125,"url":null},"def":{"name":"__crystal_pseudo_pointerof","args":[{"name":"variable","external_name":"variable","restriction":"T"}],"return_type":"Pointer(T)","visibility":"Public","body":""},"external_var":false},{"html_id":"pp(object)-class-method","name":"pp","doc":"Pretty prints *object* to `STDOUT` followed\nby a newline. Returns *object*.\n\nSee also: `Object#pretty_print(pp)`.","summary":"<p>Pretty prints <em>object</em> to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code> followed by a newline.</p>","abstract":false,"args":[{"name":"object","external_name":"object","restriction":""}],"args_string":"(object)","args_html":"(object)","location":{"filename":"src/kernel.cr","line_number":492,"url":null},"def":{"name":"pp","args":[{"name":"object","external_name":"object","restriction":""}],"visibility":"Public","body":"PrettyPrint.format(object, STDOUT, 79)\nputs\nobject\n"},"external_var":false},{"html_id":"pp(*objects)-class-method","name":"pp","doc":"Pretty prints each object in *objects* to `STDOUT`, followed\nby a newline. Returns *objects*.\n\nSee also: `Object#pretty_print(pp)`.","summary":"<p>Pretty prints each object in <em>objects</em> to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code>, followed by a newline.</p>","abstract":false,"args":[{"name":"objects","external_name":"objects","restriction":""}],"args_string":"(*objects)","args_html":"(*objects)","location":{"filename":"src/kernel.cr","line_number":502,"url":null},"def":{"name":"pp","args":[{"name":"objects","external_name":"objects","restriction":""}],"splat_index":0,"visibility":"Public","body":"objects.each do |obj|\n  pp(obj)\nend\nobjects\n"},"external_var":false},{"html_id":"pp(**objects)-class-method","name":"pp","doc":"Pretty prints *objects* to `STDOUT`, followed\nby a newline. Returns *objects*.\n\n```\np foo: 23, bar: 42 # => {foo: 23, bar: 42}\n```\n\nSee `Object#pretty_print(pp)`","summary":"<p>Pretty prints <em>objects</em> to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code>, followed by a newline.</p>","abstract":false,"location":{"filename":"src/kernel.cr","line_number":517,"url":null},"def":{"name":"pp","double_splat":{"name":"objects","external_name":"objects","restriction":""},"visibility":"Public","body":"if objects.empty?\nelse\n  pp(objects)\nend"},"external_var":false},{"html_id":"print(*objects:_):Nil-class-method","name":"print","doc":"Prints objects to `STDOUT` and then invokes `STDOUT.flush`.\n\nSee also: `IO#print`.","summary":"<p>Prints objects to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code> and then invokes <code>STDOUT.flush</code>.</p>","abstract":false,"args":[{"name":"objects","external_name":"objects","restriction":"_"}],"args_string":"(*objects : _) : Nil","args_html":"(*objects : _) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/kernel.cr","line_number":164,"url":null},"def":{"name":"print","args":[{"name":"objects","external_name":"objects","restriction":"_"}],"splat_index":0,"return_type":"Nil","visibility":"Public","body":"STDOUT.print(*objects)"},"external_var":false},{"html_id":"printf(format_string,args:Array|Tuple):Nil-class-method","name":"printf","doc":"Prints a formatted string to `STDOUT`.\n\nFor details on the format string, see `sprintf`.","summary":"<p>Prints a formatted string to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code>.</p>","abstract":false,"args":[{"name":"format_string","external_name":"format_string","restriction":""},{"name":"args","external_name":"args","restriction":"Array | Tuple"}],"args_string":"(format_string, args : Array | Tuple) : Nil","args_html":"(format_string, args : <a href=\"Array.html\">Array</a> | <a href=\"Tuple.html\">Tuple</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/kernel.cr","line_number":176,"url":null},"def":{"name":"printf","args":[{"name":"format_string","external_name":"format_string","restriction":""},{"name":"args","external_name":"args","restriction":"Array | Tuple"}],"return_type":"Nil","visibility":"Public","body":"STDOUT.printf(format_string, args)"},"external_var":false},{"html_id":"printf(format_string,*args):Nil-class-method","name":"printf","doc":"Prints a formatted string to `STDOUT`.\n\nFor details on the format string, see `sprintf`.","summary":"<p>Prints a formatted string to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code>.</p>","abstract":false,"args":[{"name":"format_string","external_name":"format_string","restriction":""},{"name":"args","external_name":"args","restriction":""}],"args_string":"(format_string, *args) : Nil","args_html":"(format_string, *args) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/kernel.cr","line_number":171,"url":null},"def":{"name":"printf","args":[{"name":"format_string","external_name":"format_string","restriction":""},{"name":"args","external_name":"args","restriction":""}],"splat_index":1,"return_type":"Nil","visibility":"Public","body":"printf(format_string, args)"},"external_var":false},{"html_id":"puts(*objects):Nil-class-method","name":"puts","doc":"Prints *objects* to `STDOUT`, each followed by a newline character unless\nthe object is a `String` and already ends with a newline.\n\nSee also: `IO#puts`.","summary":"<p>Prints <em>objects</em> to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code>, each followed by a newline character unless the object is a <code><a href=\"String.html\">String</a></code> and already ends with a newline.</p>","abstract":false,"args":[{"name":"objects","external_name":"objects","restriction":""}],"args_string":"(*objects) : Nil","args_html":"(*objects) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/kernel.cr","line_number":451,"url":null},"def":{"name":"puts","args":[{"name":"objects","external_name":"objects","restriction":""}],"splat_index":0,"return_type":"Nil","visibility":"Public","body":"STDOUT.puts(*objects)"},"external_var":false},{"html_id":"raise(exception:Exception):NoReturn-class-method","name":"raise","doc":"Raises the *exception*.\n\nThis will set the exception's callstack if it hasn't been already.\nRe-raising a previously caught exception won't replace the callstack.","summary":"<p>Raises the <em>exception</em>.</p>","abstract":false,"args":[{"name":"exception","external_name":"exception","restriction":"Exception"}],"args_string":"(exception : Exception) : NoReturn","args_html":"(exception : <a href=\"Exception.html\">Exception</a>) : NoReturn","location":{"filename":"src/raise.cr","line_number":242,"url":null},"def":{"name":"raise","args":[{"name":"exception","external_name":"exception","restriction":"Exception"}],"return_type":"NoReturn","visibility":"Public","body":"exception.callstack || (exception.callstack = Exception::CallStack.new)\nraise_without_backtrace(exception)\n"},"external_var":false},{"html_id":"raise(message:String):NoReturn-class-method","name":"raise","doc":"Raises an Exception with the *message*.","summary":"<p>Raises an Exception with the <em>message</em>.</p>","abstract":false,"args":[{"name":"message","external_name":"message","restriction":"String"}],"args_string":"(message : String) : NoReturn","args_html":"(message : <a href=\"String.html\">String</a>) : NoReturn","location":{"filename":"src/raise.cr","line_number":266,"url":null},"def":{"name":"raise","args":[{"name":"message","external_name":"message","restriction":"String"}],"return_type":"NoReturn","visibility":"Public","body":"raise(Exception.new(message))"},"external_var":false},{"html_id":"rand(x)-class-method","name":"rand","doc":"See `Random#rand(x)`.","summary":"<p>See <code>Random#rand(x)</code>.</p>","abstract":false,"args":[{"name":"x","external_name":"x","restriction":""}],"args_string":"(x)","args_html":"(x)","location":{"filename":"src/random.cr","line_number":516,"url":null},"def":{"name":"rand","args":[{"name":"x","external_name":"x","restriction":""}],"visibility":"Public","body":"Random.rand(x)"},"external_var":false},{"html_id":"rand:Float64-class-method","name":"rand","doc":"See `Random#rand`.","summary":"<p>See <code>Random#rand</code>.</p>","abstract":false,"location":{"filename":"src/random.cr","line_number":511,"url":null},"def":{"name":"rand","return_type":"Float64","visibility":"Public","body":"Random.rand"},"external_var":false},{"html_id":"read_line(*args,**options)-class-method","name":"read_line","doc":"Reads a line from `STDIN`.\n\nSee also: `IO#read_line`.","summary":"<p>Reads a line from <code><a href=\"toplevel.html#STDIN\">STDIN</a></code>.</p>","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/kernel.cr","line_number":157,"url":null},"def":{"name":"read_line","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"visibility":"Public","body":"STDIN.read_line(*args, **options)"},"external_var":false},{"html_id":"sizeof(type:Class):Int32-class-method","name":"sizeof","doc":"Returns the size of the given type as number of bytes.\n\n*type* must be a constant or `typeof()` expression. It cannot be evaluated\nat runtime.\n\n```\nsizeof(Int32)        # => 4\nsizeof(Int64)        # => 8\nsizeof(typeof(true)) # => 1\n```\n\nFor `Reference` types, the size is the same as the size of a pointer:\n\n```\n# On a 64 bits machine\nsizeof(Pointer(Int32)) # => 8\nsizeof(String)         # => 8\n```\n\nThis is because a `Reference`'s memory is allocated on the heap and a pointer\nto it is passed around. The size of a class on the heap can be determined\nusing `#instance_sizeof`.\n\n* See [`sizeof`](https://crystal-lang.org/reference/syntax_and_semantics/sizeof.html) in the language specification.\nNOTE: This is a pseudo-method provided directly by the Crystal compiler.\nIt cannot be redefined nor overridden.","summary":"<p>Returns the size of the given type as number of bytes.</p>","abstract":false,"args":[{"name":"type","external_name":"type","restriction":"Class"}],"args_string":"(type : Class) : Int32","args_html":"(type : <a href=\"Class.html\">Class</a>) : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/docs_pseudo_methods.cr","line_number":52,"url":null},"def":{"name":"__crystal_pseudo_sizeof","args":[{"name":"type","external_name":"type","restriction":"Class"}],"return_type":"Int32","visibility":"Public","body":""},"external_var":false},{"html_id":"sleep(seconds:Number):Nil-class-method","name":"sleep","doc":"Blocks the current fiber for the specified number of seconds.\n\nWhile this fiber is waiting this time, other ready-to-execute\nfibers might start their execution.","summary":"<p>Blocks the current fiber for the specified number of seconds.</p>\n<p><span class=\"flag red\">DEPRECATED</span>  Use <code>::sleep(<a href=\"Time/Span.html\">Time::Span</a>)</code> instead</p>","abstract":false,"args":[{"name":"seconds","external_name":"seconds","restriction":"Number"}],"args_string":"(seconds : Number) : Nil","args_html":"(seconds : <a href=\"Number.html\">Number</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/concurrent.cr","line_number":16,"url":null},"def":{"name":"sleep","args":[{"name":"seconds","external_name":"seconds","restriction":"Number"}],"return_type":"Nil","visibility":"Public","body":"if seconds < 0\n  raise(ArgumentError.new(\"Sleep seconds must be positive\"))\nend\nsleep(seconds.seconds)\n"},"external_var":false},{"html_id":"sleep(time:Time::Span):Nil-class-method","name":"sleep","doc":"Blocks the current Fiber for the specified time span.\n\nWhile this fiber is waiting this time, other ready-to-execute\nfibers might start their execution.","summary":"<p>Blocks the current Fiber for the specified time span.</p>","abstract":false,"args":[{"name":"time","external_name":"time","restriction":"Time::Span"}],"args_string":"(time : Time::Span) : Nil","args_html":"(time : <a href=\"Time/Span.html\">Time::Span</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/concurrent.cr","line_number":27,"url":null},"def":{"name":"sleep","args":[{"name":"time","external_name":"time","restriction":"Time::Span"}],"return_type":"Nil","visibility":"Public","body":"Crystal.trace(:sched, \"sleep\", for: time)\nCrystal::EventLoop.current.sleep(time)\n"},"external_var":false},{"html_id":"sleep:Nil-class-method","name":"sleep","doc":"Blocks the current fiber forever.\n\nMeanwhile, other ready-to-execute fibers might start their execution.","summary":"<p>Blocks the current fiber forever.</p>","abstract":false,"location":{"filename":"src/concurrent.cr","line_number":35,"url":null},"def":{"name":"sleep","return_type":"Nil","visibility":"Public","body":"Fiber.suspend"},"external_var":false},{"html_id":"spawn(*,name:String|Nil=nil,same_thread=false,&block)-class-method","name":"spawn","doc":"Spawns a new fiber.\n\nWhen using execution contexts, the fiber spawns into the current execution\ncontext (`Fiber::ExecutionContext.current`).\n\nNOTE: The newly created fiber doesn't run as soon as spawned.\n\nExample:\n```\n# Write \"1\" every 1 second and \"2\" every 2 seconds for 6 seconds.\n\nrequire \"wait_group\"\n\nwg = WaitGroup.new 2\n\nspawn do\n  6.times do\n    sleep 1.second\n    puts 1\n  end\nensure\n  wg.done\nend\n\nspawn do\n  3.times do\n    sleep 2.seconds\n    puts 2\n  end\nensure\n  wg.done\nend\n\nwg.wait\n```","summary":"<p>Spawns a new fiber.</p>","abstract":false,"args":[{"name":"","external_name":"","restriction":""},{"name":"name","default_value":"nil","external_name":"name","restriction":"String | ::Nil"},{"name":"same_thread","default_value":"false","external_name":"same_thread","restriction":""}],"args_string":"(*, name : String | Nil = nil, same_thread = false, &block)","args_html":"(*, name : <a href=\"String.html\">String</a> | <a href=\"Nil.html\">Nil</a> = <span class=\"n\">nil</span>, same_thread = <span class=\"n\">false</span>, &block)","location":{"filename":"src/concurrent.cr","line_number":39,"url":null},"def":{"name":"spawn","args":[{"name":"","external_name":"","restriction":""},{"name":"name","default_value":"nil","external_name":"name","restriction":"String | ::Nil"},{"name":"same_thread","default_value":"false","external_name":"same_thread","restriction":""}],"splat_index":0,"yields":0,"block_arity":0,"block_arg":{"name":"block","external_name":"block","restriction":""},"visibility":"Public","body":"fiber = Fiber.new(name, &block)\nCrystal.trace(:sched, \"spawn\", fiber: fiber)\n\nfiber.enqueue\nfiber\n"},"external_var":false},{"html_id":"sprintf(format_string,args:Array|Tuple):String-class-method","name":"sprintf","doc":"Returns a formatted string.\nThe string is produced according to the *format_string* with format specifiers\nbeing replaced by values from *args* formatted according to the specifier.\n\nWithin the format string, any characters other than format specifiers\n(specifiers beginning with `%`) are copied to the result. The formatter\nsupports the following kinds of format specifiers:\n\n* Sequential (`%.1f`). The first `%` consumes the first argument, the second\n  consumes the second argument, and so on.\n* Positional (`%3$.1f`). The one-based argument index is specified as part of\n  the flags.\n* Named substitution (`%<name>.1f`, `%{name}`). The angle bracket form accepts\n  flags and the curly bracket form doesn't. Exactly one `Hash` or `NamedTuple`\n  must be passed as the argument.\n\nMixing of different kinds of format specifiers is disallowed, except that the\ntwo named forms may be used together.\n\nA simple format specifier consists of a percent sign, followed by optional flags,\nwidth, and precision indicators, then terminated with a field type\ncharacter.\n\n```text\n%[flags][width][.precision]type\n```\n\nA formatted substitution is similar but after the percent sign follows the\nmandatory name of the substitution wrapped in angle brackets.\n\n```text\n%<name>[flags][width][.precision]type\n```\n\nThe percent sign itself is escaped by `%%`. No format modifiers are allowed,\nand no arguments are consumed.\n\nThe field type controls how the corresponding argument value is to be\ninterpreted, while the flags modify that interpretation.\n\nThe field type characters are:\n\n```text\nField | Integer Format\n------+------------------------------------------------------------------\n  b   | Formats argument as a binary number.\n  d   | Formats argument as a decimal number.\n  i   | Same as d.\n  o   | Formats argument as an octal number.\n  x   | Formats argument as a hexadecimal number using lowercase letters.\n  X   | Same as x, but uses uppercase letters.\n\nField | Float Format\n------+---------------------------------------------------------------\n  e   | Formats floating point argument into exponential notation\n      | with one digit before the decimal point as [-]d.dddddde[+-]dd.\n      | The precision specifies the number of digits after the decimal\n      | point (defaulting to six).\n  E   | Equivalent to e, but uses an uppercase E to indicate\n      | the exponent.\n  f   | Formats floating point argument as [-]ddd.dddddd,\n      | where the precision specifies the number of digits after\n      | the decimal point.\n  g   | Formats a floating point number using exponential form\n      | if the exponent is less than -4 or greater than or\n      | equal to the precision, or in dd.dddd form otherwise.\n      | The precision specifies the number of significant digits.\n  G   | Equivalent to g, but use an uppercase E in exponent form.\n  a   | Formats floating point argument as [-]0xh.hhhhp[+-]dd,\n      | which consists of an optional sign, \"0x\", fraction part\n      | as hexadecimal, \"p\", and exponential part as decimal.\n  A   | Equivalent to a, but uses uppercase X and P.\n\nField | Other Format\n------+------------------------------------------------------------\n  c   | Argument is a single character itself.\n  s   | Argument is a string to be substituted. If the format\n      | sequence contains a precision, at most that many characters\n      | will be copied.\n```\n\nFlags modify the behavior of the format specifiers:\n\n```text\nFlag     | Applies to    | Meaning\n---------+---------------+----------------------------------------------------\nspace    | bdiouxX       | Add a leading space character to\n         | aAeEfgG       | non-negative numbers. Has no effect if the plus\n         | (numeric fmt) | flag is also given.\n---------+---------------+----------------------------------------------------\n#        | boxX          | Use an alternative format.\n         | aAeEfgG       | For x, X, b, prefix any non-zero result with\n         |               | 0x, 0X, or 0b respectively.\n         |               | For o, prefix any non-zero result with 0o. Note\n         |               | that this prefix is different from C and Ruby.\n         |               | For a, A, e, E, f, g, G,\n         |               | force a decimal point to be added,\n         |               | even if no digits follow.\n         |               | For g and G, do not remove trailing zeros.\n---------+---------------+----------------------------------------------------\n+        | bdiouxX       | Add a leading plus sign to non-negative\n         | aAeEfgG       | numbers.\n         | (numeric fmt) |\n---------+---------------+----------------------------------------------------\n-        | all           | Left-justify the result of this conversion.\n---------+---------------+----------------------------------------------------\n0 (zero) | bdiouxX       | Pad with zeros, not spaces. Has no effect if the\n         | aAeEfgG       | number is left-justified, or a precision is given\n         | (numeric fmt) | to an integer field type.\n---------+---------------+----------------------------------------------------\n*        | all           | Use the next argument as the field width or\n         |               | precision. If width is negative, set the minus flag\n         |               | and use the argument's absolute value as field\n         |               | width. If precision is negative, it is ignored.\n---------+---------------+----------------------------------------------------\n1$ 2$ 3$ | all           | As a flag, specifies the one-based argument index\n...      |               | for a positional format specifier.\n         |               | Immediately after *, use the argument at the given\n         |               | one-based index as the width or precision, instead\n         |               | of the next argument. The entire format string must\n         |               | also use positional format specifiers throughout.\n```\n\nExamples of flags:\n\nDecimal number conversion:\n```\nsprintf \"%d\", 123  # => \"123\"\nsprintf \"%+d\", 123 # => \"+123\"\nsprintf \"% d\", 123 # => \" 123\"\n```\n\nOctal number conversion:\n```\nsprintf \"%o\", 123   # => \"173\"\nsprintf \"%+o\", 123  # => \"+173\"\nsprintf \"%o\", -123  # => \"-173\"\nsprintf \"%+o\", -123 # => \"-173\"\n```\n\nHexadecimal number conversion:\n```\nsprintf \"%x\", 123   # => \"7b\"\nsprintf \"%+x\", 123  # => \"+7b\"\nsprintf \"%x\", -123  # => \"-7b\"\nsprintf \"%+x\", -123 # => \"-7b\"\nsprintf \"%#x\", 0    # => \"0\"\nsprintf \"% x\", 123  # => \" 7b\"\nsprintf \"% x\", -123 # => \"-7b\"\nsprintf \"%X\", 123   # => \"7B\"\nsprintf \"%#X\", -123 # => \"-0X7B\"\n```\n\nBinary number conversion:\n```\nsprintf \"%b\", 123    # => \"1111011\"\nsprintf \"%+b\", 123   # => \"+1111011\"\nsprintf \"%+b\", -123  # => \"-1111011\"\nsprintf \"%b\", -123   # => \"-1111011\"\nsprintf \"%#b\", 0     # => \"0\"\nsprintf \"% b\", 123   # => \" 1111011\"\nsprintf \"%+ b\", 123  # => \"+1111011\"\nsprintf \"% b\", -123  # => \"-1111011\"\nsprintf \"%+ b\", -123 # => \"-1111011\"\nsprintf \"%#b\", 123   # => \"0b1111011\"\n```\n\nFloating point conversion:\n```\nsprintf \"%a\", 123 # => \"0x1.ecp+6\"\nsprintf \"%A\", 123 # => \"0X1.ECP+6\"\n```\n\nExponential form conversion:\n```\nsprintf \"%g\", 123.4          # => \"123.4\"\nsprintf \"%g\", 123.4567       # => \"123.457\"\nsprintf \"%20.8g\", 1234.56789 # => \"           1234.5679\"\nsprintf \"%20.8g\", 123456789  # => \"       1.2345679e+08\"\nsprintf \"%20.8G\", 123456789  # => \"       1.2345679E+08\"\nsprintf \"%20.8g\", -123456789 # => \"      -1.2345679e+08\"\nsprintf \"%20.8G\", -123456789 # => \"      -1.2345679E+08\"\n```\n\nThe field width is an optional integer, followed optionally by a\nperiod and a precision. The width specifies the minimum number of\ncharacters that will be written to the result for this field.\n\nExamples of width:\n```\nsprintf \"%20d\", 123   # => \"                 123\"\nsprintf \"%+20d\", 123  # => \"                +123\"\nsprintf \"%020d\", 123  # => \"00000000000000000123\"\nsprintf \"%+020d\", 123 # => \"+0000000000000000123\"\nsprintf \"% 020d\", 123 # => \" 0000000000000000123\"\nsprintf \"%-20d\", 123  # => \"123                 \"\nsprintf \"%-+20d\", 123 # => \"+123                \"\nsprintf \"%- 20d\", 123 # => \" 123                \"\nsprintf \"%020x\", -123 # => \"-000000000000000007b\"\nsprintf \"%020X\", -123 # => \"-000000000000000007B\"\n```\n\nFor numeric fields, the precision controls the number of decimal places\ndisplayed.\n\nFor string fields, the precision determines the maximum\nnumber of characters to be copied from the string.\n\nExamples of precisions:\n\nPrecision for `d`, `o`, `x` and `b` is\nminimum number of digits:\n```\nsprintf \"%20.8d\", 123   # => \"            00000123\"\nsprintf \"%020.8d\", 123  # => \"            00000123\"\nsprintf \"%20.8o\", 123   # => \"            00000173\"\nsprintf \"%020.8o\", 123  # => \"            00000173\"\nsprintf \"%20.8x\", 123   # => \"            0000007b\"\nsprintf \"%020.8x\", 123  # => \"            0000007b\"\nsprintf \"%20.8b\", 123   # => \"            01111011\"\nsprintf \"%20.8d\", -123  # => \"           -00000123\"\nsprintf \"%020.8d\", -123 # => \"           -00000123\"\nsprintf \"%20.8o\", -123  # => \"           -00000173\"\nsprintf \"%20.8x\", -123  # => \"           -0000007b\"\nsprintf \"%20.8b\", -11   # => \"           -00001011\"\n```\n\nPrecision for `e` is number of digits after the decimal point:\n```\nsprintf \"%20.8e\", 1234.56789 # => \"      1.23456789e+03\"\n```\n\nPrecision for `f` is number of digits after the decimal point:\n```\nsprintf \"%20.8f\", 1234.56789 # => \"       1234.56789000\"\n```\n\nPrecision for `g` is number of significant digits:\n```\nsprintf \"%20.8g\", 1234.56789 # => \"           1234.5679\"\nsprintf \"%20.8g\", 123456789  # => \"       1.2345679e+08\"\nsprintf \"%-20.8g\", 123456789 # => \"1.2345679e+08       \"\n```\n\nPrecision for `s` is maximum number of characters:\n```\nsprintf \"%20.8s\", \"string test\" # => \"            string t\"\n```\n\nAdditional examples:\n```\nsprintf \"%d %04x\", 123, 123                 # => \"123 007b\"\nsprintf \"%08b '%4s'\", 123, 123              # => \"01111011 ' 123'\"\nsprintf \"%+g:% g:%-g\", 1.23, 1.23, 1.23     # => \"+1.23: 1.23:1.23\"\nsprintf \"%-3$*1$.*2$s\", 10, 5, \"abcdefghij\" # => \"abcde     \"\n```","summary":"<p>Returns a formatted string.</p>","abstract":false,"args":[{"name":"format_string","external_name":"format_string","restriction":""},{"name":"args","external_name":"args","restriction":"Array | Tuple"}],"args_string":"(format_string, args : Array | Tuple) : String","args_html":"(format_string, args : <a href=\"Array.html\">Array</a> | <a href=\"Tuple.html\">Tuple</a>) : <a href=\"String.html\">String</a>","location":{"filename":"src/kernel.cr","line_number":441,"url":null},"def":{"name":"sprintf","args":[{"name":"format_string","external_name":"format_string","restriction":""},{"name":"args","external_name":"args","restriction":"Array | Tuple"}],"return_type":"String","visibility":"Public","body":"String.build(format_string.bytesize) do |str|\n  (String::Formatter(typeof(args)).new(format_string, args, str)).format\nend"},"external_var":false},{"html_id":"sprintf(format_string,*args):String-class-method","name":"sprintf","doc":"Returns a formatted string.\nThe string is produced according to the *format_string* with format specifiers\nbeing replaced by values from *args* formatted according to the specifier.\n\nWithin the format string, any characters other than format specifiers\n(specifiers beginning with `%`) are copied to the result. The formatter\nsupports the following kinds of format specifiers:\n\n* Sequential (`%.1f`). The first `%` consumes the first argument, the second\n  consumes the second argument, and so on.\n* Positional (`%3$.1f`). The one-based argument index is specified as part of\n  the flags.\n* Named substitution (`%<name>.1f`, `%{name}`). The angle bracket form accepts\n  flags and the curly bracket form doesn't. Exactly one `Hash` or `NamedTuple`\n  must be passed as the argument.\n\nMixing of different kinds of format specifiers is disallowed, except that the\ntwo named forms may be used together.\n\nA simple format specifier consists of a percent sign, followed by optional flags,\nwidth, and precision indicators, then terminated with a field type\ncharacter.\n\n```text\n%[flags][width][.precision]type\n```\n\nA formatted substitution is similar but after the percent sign follows the\nmandatory name of the substitution wrapped in angle brackets.\n\n```text\n%<name>[flags][width][.precision]type\n```\n\nThe percent sign itself is escaped by `%%`. No format modifiers are allowed,\nand no arguments are consumed.\n\nThe field type controls how the corresponding argument value is to be\ninterpreted, while the flags modify that interpretation.\n\nThe field type characters are:\n\n```text\nField | Integer Format\n------+------------------------------------------------------------------\n  b   | Formats argument as a binary number.\n  d   | Formats argument as a decimal number.\n  i   | Same as d.\n  o   | Formats argument as an octal number.\n  x   | Formats argument as a hexadecimal number using lowercase letters.\n  X   | Same as x, but uses uppercase letters.\n\nField | Float Format\n------+---------------------------------------------------------------\n  e   | Formats floating point argument into exponential notation\n      | with one digit before the decimal point as [-]d.dddddde[+-]dd.\n      | The precision specifies the number of digits after the decimal\n      | point (defaulting to six).\n  E   | Equivalent to e, but uses an uppercase E to indicate\n      | the exponent.\n  f   | Formats floating point argument as [-]ddd.dddddd,\n      | where the precision specifies the number of digits after\n      | the decimal point.\n  g   | Formats a floating point number using exponential form\n      | if the exponent is less than -4 or greater than or\n      | equal to the precision, or in dd.dddd form otherwise.\n      | The precision specifies the number of significant digits.\n  G   | Equivalent to g, but use an uppercase E in exponent form.\n  a   | Formats floating point argument as [-]0xh.hhhhp[+-]dd,\n      | which consists of an optional sign, \"0x\", fraction part\n      | as hexadecimal, \"p\", and exponential part as decimal.\n  A   | Equivalent to a, but uses uppercase X and P.\n\nField | Other Format\n------+------------------------------------------------------------\n  c   | Argument is a single character itself.\n  s   | Argument is a string to be substituted. If the format\n      | sequence contains a precision, at most that many characters\n      | will be copied.\n```\n\nFlags modify the behavior of the format specifiers:\n\n```text\nFlag     | Applies to    | Meaning\n---------+---------------+----------------------------------------------------\nspace    | bdiouxX       | Add a leading space character to\n         | aAeEfgG       | non-negative numbers. Has no effect if the plus\n         | (numeric fmt) | flag is also given.\n---------+---------------+----------------------------------------------------\n#        | boxX          | Use an alternative format.\n         | aAeEfgG       | For x, X, b, prefix any non-zero result with\n         |               | 0x, 0X, or 0b respectively.\n         |               | For o, prefix any non-zero result with 0o. Note\n         |               | that this prefix is different from C and Ruby.\n         |               | For a, A, e, E, f, g, G,\n         |               | force a decimal point to be added,\n         |               | even if no digits follow.\n         |               | For g and G, do not remove trailing zeros.\n---------+---------------+----------------------------------------------------\n+        | bdiouxX       | Add a leading plus sign to non-negative\n         | aAeEfgG       | numbers.\n         | (numeric fmt) |\n---------+---------------+----------------------------------------------------\n-        | all           | Left-justify the result of this conversion.\n---------+---------------+----------------------------------------------------\n0 (zero) | bdiouxX       | Pad with zeros, not spaces. Has no effect if the\n         | aAeEfgG       | number is left-justified, or a precision is given\n         | (numeric fmt) | to an integer field type.\n---------+---------------+----------------------------------------------------\n*        | all           | Use the next argument as the field width or\n         |               | precision. If width is negative, set the minus flag\n         |               | and use the argument's absolute value as field\n         |               | width. If precision is negative, it is ignored.\n---------+---------------+----------------------------------------------------\n1$ 2$ 3$ | all           | As a flag, specifies the one-based argument index\n...      |               | for a positional format specifier.\n         |               | Immediately after *, use the argument at the given\n         |               | one-based index as the width or precision, instead\n         |               | of the next argument. The entire format string must\n         |               | also use positional format specifiers throughout.\n```\n\nExamples of flags:\n\nDecimal number conversion:\n```\nsprintf \"%d\", 123  # => \"123\"\nsprintf \"%+d\", 123 # => \"+123\"\nsprintf \"% d\", 123 # => \" 123\"\n```\n\nOctal number conversion:\n```\nsprintf \"%o\", 123   # => \"173\"\nsprintf \"%+o\", 123  # => \"+173\"\nsprintf \"%o\", -123  # => \"-173\"\nsprintf \"%+o\", -123 # => \"-173\"\n```\n\nHexadecimal number conversion:\n```\nsprintf \"%x\", 123   # => \"7b\"\nsprintf \"%+x\", 123  # => \"+7b\"\nsprintf \"%x\", -123  # => \"-7b\"\nsprintf \"%+x\", -123 # => \"-7b\"\nsprintf \"%#x\", 0    # => \"0\"\nsprintf \"% x\", 123  # => \" 7b\"\nsprintf \"% x\", -123 # => \"-7b\"\nsprintf \"%X\", 123   # => \"7B\"\nsprintf \"%#X\", -123 # => \"-0X7B\"\n```\n\nBinary number conversion:\n```\nsprintf \"%b\", 123    # => \"1111011\"\nsprintf \"%+b\", 123   # => \"+1111011\"\nsprintf \"%+b\", -123  # => \"-1111011\"\nsprintf \"%b\", -123   # => \"-1111011\"\nsprintf \"%#b\", 0     # => \"0\"\nsprintf \"% b\", 123   # => \" 1111011\"\nsprintf \"%+ b\", 123  # => \"+1111011\"\nsprintf \"% b\", -123  # => \"-1111011\"\nsprintf \"%+ b\", -123 # => \"-1111011\"\nsprintf \"%#b\", 123   # => \"0b1111011\"\n```\n\nFloating point conversion:\n```\nsprintf \"%a\", 123 # => \"0x1.ecp+6\"\nsprintf \"%A\", 123 # => \"0X1.ECP+6\"\n```\n\nExponential form conversion:\n```\nsprintf \"%g\", 123.4          # => \"123.4\"\nsprintf \"%g\", 123.4567       # => \"123.457\"\nsprintf \"%20.8g\", 1234.56789 # => \"           1234.5679\"\nsprintf \"%20.8g\", 123456789  # => \"       1.2345679e+08\"\nsprintf \"%20.8G\", 123456789  # => \"       1.2345679E+08\"\nsprintf \"%20.8g\", -123456789 # => \"      -1.2345679e+08\"\nsprintf \"%20.8G\", -123456789 # => \"      -1.2345679E+08\"\n```\n\nThe field width is an optional integer, followed optionally by a\nperiod and a precision. The width specifies the minimum number of\ncharacters that will be written to the result for this field.\n\nExamples of width:\n```\nsprintf \"%20d\", 123   # => \"                 123\"\nsprintf \"%+20d\", 123  # => \"                +123\"\nsprintf \"%020d\", 123  # => \"00000000000000000123\"\nsprintf \"%+020d\", 123 # => \"+0000000000000000123\"\nsprintf \"% 020d\", 123 # => \" 0000000000000000123\"\nsprintf \"%-20d\", 123  # => \"123                 \"\nsprintf \"%-+20d\", 123 # => \"+123                \"\nsprintf \"%- 20d\", 123 # => \" 123                \"\nsprintf \"%020x\", -123 # => \"-000000000000000007b\"\nsprintf \"%020X\", -123 # => \"-000000000000000007B\"\n```\n\nFor numeric fields, the precision controls the number of decimal places\ndisplayed.\n\nFor string fields, the precision determines the maximum\nnumber of characters to be copied from the string.\n\nExamples of precisions:\n\nPrecision for `d`, `o`, `x` and `b` is\nminimum number of digits:\n```\nsprintf \"%20.8d\", 123   # => \"            00000123\"\nsprintf \"%020.8d\", 123  # => \"            00000123\"\nsprintf \"%20.8o\", 123   # => \"            00000173\"\nsprintf \"%020.8o\", 123  # => \"            00000173\"\nsprintf \"%20.8x\", 123   # => \"            0000007b\"\nsprintf \"%020.8x\", 123  # => \"            0000007b\"\nsprintf \"%20.8b\", 123   # => \"            01111011\"\nsprintf \"%20.8d\", -123  # => \"           -00000123\"\nsprintf \"%020.8d\", -123 # => \"           -00000123\"\nsprintf \"%20.8o\", -123  # => \"           -00000173\"\nsprintf \"%20.8x\", -123  # => \"           -0000007b\"\nsprintf \"%20.8b\", -11   # => \"           -00001011\"\n```\n\nPrecision for `e` is number of digits after the decimal point:\n```\nsprintf \"%20.8e\", 1234.56789 # => \"      1.23456789e+03\"\n```\n\nPrecision for `f` is number of digits after the decimal point:\n```\nsprintf \"%20.8f\", 1234.56789 # => \"       1234.56789000\"\n```\n\nPrecision for `g` is number of significant digits:\n```\nsprintf \"%20.8g\", 1234.56789 # => \"           1234.5679\"\nsprintf \"%20.8g\", 123456789  # => \"       1.2345679e+08\"\nsprintf \"%-20.8g\", 123456789 # => \"1.2345679e+08       \"\n```\n\nPrecision for `s` is maximum number of characters:\n```\nsprintf \"%20.8s\", \"string test\" # => \"            string t\"\n```\n\nAdditional examples:\n```\nsprintf \"%d %04x\", 123, 123                 # => \"123 007b\"\nsprintf \"%08b '%4s'\", 123, 123              # => \"01111011 ' 123'\"\nsprintf \"%+g:% g:%-g\", 1.23, 1.23, 1.23     # => \"+1.23: 1.23:1.23\"\nsprintf \"%-3$*1$.*2$s\", 10, 5, \"abcdefghij\" # => \"abcde     \"\n```","summary":"<p>Returns a formatted string.</p>","abstract":false,"args":[{"name":"format_string","external_name":"format_string","restriction":""},{"name":"args","external_name":"args","restriction":""}],"args_string":"(format_string, *args) : String","args_html":"(format_string, *args) : <a href=\"String.html\">String</a>","location":{"filename":"src/kernel.cr","line_number":436,"url":null},"def":{"name":"sprintf","args":[{"name":"format_string","external_name":"format_string","restriction":""},{"name":"args","external_name":"args","restriction":""}],"splat_index":1,"return_type":"String","visibility":"Public","body":"sprintf(format_string, args)"},"external_var":false},{"html_id":"system(command:String,args:Enumerable(String)|Nil=nil):Bool-class-method","name":"system","doc":"Executes the given command in a subshell.\nStandard input, output and error are inherited.\nReturns `true` if the command gives zero exit code, `false` otherwise.\nThe special `$?` variable is set to a `Process::Status` associated with this execution.\n\nIf *command* contains no spaces and *args* is given, it will become\nits argument list.\n\nIf *command* contains spaces and *args* is given, *command* must include\n`\"${@}\"` (including the quotes) to receive the argument list.\n\nNo shell interpretation is done in *args*.\n\nExample:\n\n```\nsystem(\"echo *\")\n```\n\nProduces:\n\n```text\nLICENSE shard.yml Readme.md spec src\n```","summary":"<p>Executes the given command in a subshell.</p>","abstract":false,"args":[{"name":"command","external_name":"command","restriction":"String"},{"name":"args","default_value":"nil","external_name":"args","restriction":"Enumerable(String) | ::Nil"}],"args_string":"(command : String, args : Enumerable(String) | Nil = nil) : Bool","args_html":"(command : <a href=\"String.html\">String</a>, args : <a href=\"Enumerable.html\">Enumerable</a>(<a href=\"String.html\">String</a>) | <a href=\"Nil.html\">Nil</a> = <span class=\"n\">nil</span>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/process.cr","line_number":505,"url":null},"def":{"name":"system","args":[{"name":"command","external_name":"command","restriction":"String"},{"name":"args","default_value":"nil","external_name":"args","restriction":"Enumerable(String) | ::Nil"}],"return_type":"Bool","visibility":"Public","body":"status = Process.run(command, args, shell: true, input: Process::Redirect::Inherit, output: Process::Redirect::Inherit, error: Process::Redirect::Inherit)\n$? = status\nstatus.success?\n"},"external_var":false},{"html_id":"timeout_select_action(timeout:Time::Span):Channel::TimeoutAction-class-method","name":"timeout_select_action","doc":"Timeout keyword for use in `select`.\n\n```\nselect\nwhen x = ch.receive\n  puts \"got #{x}\"\nwhen timeout(1.seconds)\n  puts \"timeout\"\nend\n```\n\nNOTE: It won't trigger if the `select` has an `else` case (i.e.: a non-blocking select).","summary":"<p>Timeout keyword for use in <code>select</code>.</p>","abstract":false,"args":[{"name":"timeout","external_name":"timeout","restriction":"Time::Span"}],"args_string":"(timeout : Time::Span) : Channel::TimeoutAction","args_html":"(timeout : <a href=\"Time/Span.html\">Time::Span</a>) : Channel::TimeoutAction","location":{"filename":"src/channel/select/timeout_action.cr","line_number":13,"url":null},"def":{"name":"timeout_select_action","args":[{"name":"timeout","external_name":"timeout","restriction":"Time::Span"}],"return_type":"Channel::TimeoutAction","visibility":"Public","body":"Channel::TimeoutAction.new(timeout)"},"external_var":false},{"html_id":"typeof(*expression):Class-class-method","name":"typeof","doc":"Returns the type of an expression.\n\n```\ntypeof(1) # => Int32\n```\n\nIt accepts multiple arguments, and the result is the union of the expression types:\n\n```\ntypeof(1, \"a\", 'a') # => (Int32 | String | Char)\n```\n\nThe expressions passed as arguments to `typeof` do not evaluate. The compiler\nonly analyzes their return type.\n\n* See [`typeof`](https://crystal-lang.org/reference/syntax_and_semantics/typeof.html) in the language specification.\nNOTE: This is a pseudo-method provided directly by the Crystal compiler.\nIt cannot be redefined nor overridden.","summary":"<p>Returns the type of an expression.</p>","abstract":false,"args":[{"name":"expression","external_name":"expression","restriction":""}],"args_string":"(*expression) : Class","args_html":"(*expression) : <a href=\"Class.html\">Class</a>","location":{"filename":"src/docs_pseudo_methods.cr","line_number":25,"url":null},"def":{"name":"__crystal_pseudo_typeof","args":[{"name":"expression","external_name":"expression","restriction":""}],"splat_index":0,"return_type":"Class","visibility":"Public","body":""},"external_var":false}],"macros":[{"html_id":"debugger-macro","name":"debugger","doc":"Invokes an execution trap to catch the attention of a debugger. This has the\nsame effect as placing a breakpoint in debuggers or IDEs supporting them.\n\nExecution is allowed to continue if the debugger instructs so. If no debugger\nis attached, usually the current process terminates with a status that\ncorresponds to `Process::ExitReason::Breakpoint`.\n\nInside an interpreter session, this drops into the REPL's pry mode instead of\na system debugger.","summary":"<p>Invokes an execution trap to catch the attention of a debugger.</p>","abstract":false,"location":{"filename":"src/intrinsics.cr","line_number":385,"url":null},"def":{"name":"debugger","visibility":"Public","body":"  ::Intrinsics.debugtrap\n"}},{"html_id":"p!(*exps)-macro","name":"p!","doc":"Prints a series of expressions together with their inspected values.\nUseful for print style debugging.\n\n```\na = 1\np! a # => \"a # => 1\"\n\np! [1, 2, 3].map(&.to_s) # => \"[1, 2, 3].map(&.to_s) # => [\"1\", \"2\", \"3\"]\"\n```\n\nSee also: `p`, `Object#inspect`.","summary":"<p>Prints a series of expressions together with their inspected values.</p>","abstract":false,"args":[{"name":"exps","external_name":"exps","restriction":""}],"args_string":"(*exps)","args_html":"(*exps)","location":{"filename":"src/macros.cr","line_number":178,"url":null},"def":{"name":"p!","args":[{"name":"exps","external_name":"exps","restriction":""}],"splat_index":0,"visibility":"Public","body":"  \n{% if exps.size == 0 %}\n    # Nothing\n  {% elsif exps.size == 1 %}\n    {% exp = exps.first %}\n    %prefix = \"#{{{ exp.stringify }}} # => \"\n    ::print %prefix\n    ::p({{ exp }})\n  {% else %}\n    %names = { {{ exps.map(&.stringify).splat }} }\n    %max_size = %names.max_of &.size\n    {\n      {% for exp, i in exps %}\n        begin\n          %prefix = \"#{%names[{{ i }}].ljust(%max_size)} # => \"\n          ::print %prefix\n          ::p({{ exp }})\n        end,\n      {% end %}\n    }\n  {% end %}\n\n\n"}},{"html_id":"pp!(*exps)-macro","name":"pp!","doc":"Prints a series of expressions together with their pretty printed values.\nUseful for print style debugging.\n\n```\na = 1\npp! a # => \"a # => 1\"\n\npp! [1, 2, 3].map(&.to_s) # => \"[1, 2, 3].map(&.to_s) # => [\"1\", \"2\", \"3\"]\"\n```\n\nSee also: `pp`, `Object#pretty_inspect`.","summary":"<p>Prints a series of expressions together with their pretty printed values.</p>","abstract":false,"args":[{"name":"exps","external_name":"exps","restriction":""}],"args_string":"(*exps)","args_html":"(*exps)","location":{"filename":"src/macros.cr","line_number":144,"url":null},"def":{"name":"pp!","args":[{"name":"exps","external_name":"exps","restriction":""}],"splat_index":0,"visibility":"Public","body":"  \n{% if exps.size == 0 %}\n    # Nothing\n  {% elsif exps.size == 1 %}\n    {% exp = exps.first %}\n    %prefix = \"#{{{ exp.stringify }}} # => \"\n    ::print %prefix\n    ::pp({{ exp }})\n  {% else %}\n    %names = { {{ exps.map(&.stringify).splat }} }\n    %max_size = %names.max_of &.size\n    {\n      {% for exp, i in exps %}\n        begin\n          %prefix = \"#{%names[{{ i }}].ljust(%max_size)} # => \"\n          ::print %prefix\n          ::pp({{ exp }})\n        end,\n      {% end %}\n    }\n  {% end %}\n\n\n"}},{"html_id":"record(__namename,*properties,**kwargs)-macro","name":"record","doc":"Defines a **`Struct`** type called *name* with the given *properties*.\n\nThe generated struct has a constructor with the given properties\nin the same order as declared. The struct only provides getters,\nnot setters, making it immutable by default.\n\n```\nrecord Point, x : Int32, y : Int32\n\np = Point.new 1, 2 # => #<Point(@x=1, @y=2)>\np.x                # => 1\np.y                # => 2\n```\n\nThe *properties* are a sequence of type declarations (`x : Int32`, `x : Int32 = 0`)\nor assigns (`x = 0`).\nThey declare instance variables and respective getter methods of their name with\noptional type restrictions and default value.\n\nWhen passing a block to this macro its body is inserted inside\nthe struct definition. This allows to define additional methods or include modules\ninto the record type (reopening the type would work as well).\n\n```\nrecord Person, first_name : String, last_name : String do\n  def full_name\n    \"#{first_name} #{last_name}\"\n  end\nend\n\nperson = Person.new \"John\", \"Doe\"\nperson.full_name # => \"John Doe\"\n```\n\nAn example with type declarations and default values:\n\n```\nrecord Point, x : Int32 = 0, y : Int32 = 0\n\nPoint.new      # => #<Point(@x=0, @y=0)>\nPoint.new y: 2 # => #<Point(@x=0, @y=2)>\n```\n\nAn example with assignments (in this case the compiler must be able to\ninfer the types from the default values):\n\n```\nrecord Point, x = 0, y = 0\n\nPoint.new      # => #<Point(@x=0, @y=0)>\nPoint.new y: 2 # => #<Point(@x=0, @y=2)>\n```\n\nThis macro also provides a `#copy_with` method which returns\na copy of the record with the provided properties altered.\n\n```\nrecord Point, x = 0, y = 0\n\np = Point.new y: 2 # => #<Point(@x=0, @y=2)>\np.copy_with x: 3   # => #<Point(@x=3, @y=2)>\np                  # => #<Point(@x=0, @y=2)>\n```","summary":"<p>Defines a <strong><code><a href=\"Struct.html\">Struct</a></code></strong> type called <em>name</em> with the given <em>properties</em>.</p>","abstract":false,"args":[{"name":"name","external_name":"__name","restriction":""},{"name":"properties","external_name":"properties","restriction":""}],"args_string":"(__name name, *properties, **kwargs)","args_html":"(__name name, *properties, **kwargs)","location":{"filename":"src/macros.cr","line_number":64,"url":null},"def":{"name":"record","args":[{"name":"name","external_name":"__name","restriction":""},{"name":"properties","external_name":"properties","restriction":""}],"double_splat":{"name":"kwargs","external_name":"kwargs","restriction":""},"splat_index":1,"visibility":"Public","body":"  \n{% unless kwargs.empty?\n  raise(\"macro `record` does not accept named arguments\\n  Did you mean:\\n\\n  record #{name}, #{((properties + kwargs.map do |name, value| \"#{name} : #{value}\" end).join(\", \")).id}\")\nend\n\n\n\n\n\n%}\n\n\n  struct \n{{ name.id }}\n\n    \n{% for property in properties %}\n      {% if property.is_a?(Assign) %}\n        getter {{ property.target.id }}\n      {% elsif property.is_a?(TypeDeclaration) %}\n        getter {{ property }}\n      {% else %}\n        getter :{{ property.id }}\n      {% end %}\n    {% end %}\n\n\n    def initialize(\n{{ \n  properties.map do |field|\n    \"@#{field.id}\".id\n  end.splat\n }}\n)\n    \nend\n\n    \n{{ yield }}\n\n\n    def copy_with(\n{{ \n  properties.map do |property|\n    if property.is_a?(Assign)\n      \"#{property.target.id} _#{property.target.id} = @#{property.target.id}\".id\n    elsif property.is_a?(TypeDeclaration)\n      \"#{property.var.id} _#{property.var.id} = @#{property.var.id}\".id\n    else\n      \"#{property.id} _#{property.id} = @#{property.id}\".id\n    end\n  end.splat\n }}\n)\n      self.class.new(\n{{ \n  properties.map do |property|\n    if property.is_a?(Assign)\n      \"_#{property.target.id}\".id\n    elsif property.is_a?(TypeDeclaration)\n      \"_#{property.var.id}\".id\n    else\n      \"_#{property.id}\".id\n    end\n  end.splat\n }}\n)\n    \nend\n\n    def clone\n      self.class.new(\n{{ \n  properties.map do |property|\n    if property.is_a?(Assign)\n      \"@#{property.target.id}.clone\".id\n    elsif property.is_a?(TypeDeclaration)\n      \"@#{property.var.id}.clone\".id\n    else\n      \"@#{property.id}.clone\".id\n    end\n  end.splat\n }}\n)\n    \nend\n  \nend\n\n"}},{"html_id":"spawn(call,*,name=nil,same_thread=false,&block)-macro","name":"spawn","doc":"Spawns a fiber by first creating a `Proc`, passing the *call*'s\nexpressions to it, and letting the `Proc` finally invoke the *call*.\n\nWhen using execution contexts, the fiber spawns into the current execution\ncontext (`Fiber::ExecutionContext.current`).\n\nCompare this:\n\n```\ni = 0\nwhile i < 5\n  spawn { print(i) }\n  i += 1\nend\nFiber.yield\n# Output: 55555\n```\n\nTo this:\n\n```\ni = 0\nwhile i < 5\n  spawn print(i)\n  i += 1\nend\nFiber.yield\n# Output: 01234\n```\n\nThis is because in the first case all spawned fibers refer to\nthe same local variable, while in the second example copies of\n*i* are passed to a `Proc` that eventually invokes the call.","summary":"<p>Spawns a fiber by first creating a <code><a href=\"Proc.html\">Proc</a></code>, passing the <em>call</em>'s expressions to it, and letting the <code><a href=\"Proc.html\">Proc</a></code> finally invoke the <em>call</em>.</p>","abstract":false,"args":[{"name":"call","external_name":"call","restriction":""},{"name":"","external_name":"","restriction":""},{"name":"name","default_value":"nil","external_name":"name","restriction":""},{"name":"same_thread","default_value":"false","external_name":"same_thread","restriction":""}],"args_string":"(call, *, name = nil, same_thread = false, &block)","args_html":"(call, *, name = <span class=\"n\">nil</span>, same_thread = <span class=\"n\">false</span>, &block)","location":{"filename":"src/concurrent.cr","line_number":121,"url":null},"def":{"name":"spawn","args":[{"name":"call","external_name":"call","restriction":""},{"name":"","external_name":"","restriction":""},{"name":"name","default_value":"nil","external_name":"name","restriction":""},{"name":"same_thread","default_value":"false","external_name":"same_thread","restriction":""}],"splat_index":1,"block_arg":{"name":"block","external_name":"block","restriction":""},"visibility":"Public","body":"  \n{% if block %}\n    {% raise(\"`spawn(call)` can't be invoked with a block, did you mean `spawn(name: ...) { ... }`?\") %}\n  {% end %}\n\n\n  \n{% if call.is_a?(Call) %}\n    ->(\n      {% for arg, i in call.args %}\n        __arg{{ i }} : typeof({{ arg.is_a?(Splat) ? arg.exp : arg }}),\n      {% end %}\n      {% if call.named_args %}\n        {% for narg, i in call.named_args %}\n          __narg{{ i }} : typeof({{ narg.value }}),\n        {% end %}\n      {% end %}\n      ) {\n      spawn(name: {{ name }}, same_thread: {{ same_thread }}) do\n        {% if call.receiver %}{{ call.receiver }}.{% end %}{{ call.name }}(\n          {% for arg, i in call.args %}\n            {% if arg.is_a?(Splat) %}*{% end %}__arg{{ i }},\n          {% end %}\n          {% if call.named_args %}\n            {% for narg, i in call.named_args %}\n              {{ narg.name }}: __narg{{ i }},\n            {% end %}\n          {% end %}\n        )\n      end\n      }.call(\n        {% for arg in call.args %}\n          {{ arg.is_a?(Splat) ? arg.exp : arg }},\n        {% end %}\n        {% if call.named_args %}\n          {{ call.named_args.map(&.value).splat }}\n        {% end %}\n      )\n  {% else %}\n    spawn do\n      {{ call }}\n    end\n  {% end %}\n\n\n"}}],"types":[{"html_id":"Crystal/ArgumentError","path":"ArgumentError.html","kind":"class","full_name":"ArgumentError","name":"ArgumentError","abstract":false,"superclass":{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},"ancestors":[{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/exception.cr","line_number":89,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"doc":"Raised when the arguments are wrong and there isn't a more specific `Exception` class.\n\n```\n[1, 2, 3].first(-4) # raises ArgumentError (attempt to take negative size)\n```","summary":"<p>Raised when the arguments are wrong and there isn't a more specific <code><a href=\"Exception.html\">Exception</a></code> class.</p>","constructors":[{"html_id":"new(message=\"Argumenterror\")-class-method","name":"new","abstract":false,"args":[{"name":"message","default_value":"\"Argument error\"","external_name":"message","restriction":""}],"args_string":"(message = \"Argument error\")","args_html":"(message = <span class=\"s\">&quot;Argument error&quot;</span>)","location":{"filename":"src/exception.cr","line_number":90,"url":null},"def":{"name":"new","args":[{"name":"message","default_value":"\"Argument error\"","external_name":"message","restriction":""}],"visibility":"Public","body":"_ = allocate\n_.initialize(message)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false}]},{"html_id":"Crystal/Array","path":"Array.html","kind":"class","full_name":"Array(T)","name":"Array","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Indexable/Mutable","kind":"module","full_name":"Indexable::Mutable","name":"Mutable"},{"html_id":"Crystal/Indexable","kind":"module","full_name":"Indexable","name":"Indexable"},{"html_id":"Crystal/Enumerable","kind":"module","full_name":"Enumerable","name":"Enumerable"},{"html_id":"Crystal/Iterable","kind":"module","full_name":"Iterable","name":"Iterable"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/array.cr","line_number":48,"url":null},{"filename":"src/json/any.cr","line_number":375,"url":null},{"filename":"src/json/to_json.cr","line_number":93,"url":null},{"filename":"src/uri/params/to_www_form.cr","line_number":8,"url":null},{"filename":"src/yaml/any.cr","line_number":380,"url":null},{"filename":"src/yaml/to_yaml.cr","line_number":34,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"included_modules":[{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Indexable/Mutable","kind":"module","full_name":"Indexable::Mutable","name":"Mutable"}],"doc":"An `Array` is an ordered, integer-indexed collection of objects of type T.\n\nArray indexing starts at 0. A negative index is assumed to be\nrelative to the end of the array: -1 indicates the last element,\n-2 is the next to last element, and so on.\n\nAn `Array` can be created using the usual `new` method (several are provided), or with an array literal:\n\n```\nArray(Int32).new  # => []\n[1, 2, 3]         # Array(Int32)\n[1, \"hello\", 'x'] # Array(Int32 | String | Char)\n```\n\nSee [`Array` literals](https://crystal-lang.org/reference/syntax_and_semantics/literals/array.html) in the language reference.\n\nAn `Array` can have mixed types, meaning T will be a union of types, but these are determined\nwhen the array is created, either by specifying T or by using an array literal. In the latter\ncase, T will be set to the union of the array literal elements' types.\n\nWhen creating an empty array you must always specify T:\n\n```\n[] of Int32 # same as Array(Int32)\n[]          # syntax error\n```\n\nAn `Array` is implemented using an internal buffer of some capacity\nand is reallocated when elements are pushed to it when more capacity\nis needed. This is normally known as a [dynamic array](http://en.wikipedia.org/wiki/Dynamic_array).\n\nYou can use a special array literal syntax with other types too, as long as they define an argless\n`new` method and a `<<` method. `Set` is one such type:\n\n```\nset = Set{1, 2, 3} # => Set{1, 2, 3}\nset.class          # => Set(Int32)\n```\n\nThe above is the same as this:\n\n```\nset = Set(typeof(1, 2, 3)).new\nset << 1\nset << 2\nset << 3\n```","summary":"<p>An <code><a href=\"Array.html\">Array</a></code> is an ordered, integer-indexed collection of objects of type T.</p>","class_methods":[{"html_id":"each_product(arrays:Array(Array),reuse=false,&)-class-method","name":"each_product","doc":"Yields each ordered combination of the elements taken from each of the\n*arrays* as `Array`s.\nTraversal of elements starts from the last given array.","summary":"<p>Yields each ordered combination of the elements taken from each of the <em>arrays</em> as <code><a href=\"Array.html\">Array</a></code>s.</p>\n<p><span class=\"flag red\">DEPRECATED</span>  Use <code><a href=\"Indexable.html#each_cartesian%28%2Aothers%3AIndexable%2C%26%29-instance-method\">Indexable.each_cartesian(indexables : Indexable(Indexable)</a>, reuse = false, &amp;block)</code> instead</p>","abstract":false,"args":[{"name":"arrays","external_name":"arrays","restriction":"Array(Array)"},{"name":"reuse","default_value":"false","external_name":"reuse","restriction":""}],"args_string":"(arrays : Array(Array), reuse = false, &)","args_html":"(arrays : <a href=\"Array.html\">Array</a>(<a href=\"Array.html\">Array</a>), reuse = <span class=\"n\">false</span>, &)","location":{"filename":"src/array.cr","line_number":1273,"url":null},"def":{"name":"each_product","args":[{"name":"arrays","external_name":"arrays","restriction":"Array(Array)"},{"name":"reuse","default_value":"false","external_name":"reuse","restriction":""}],"yields":1,"block_arity":1,"visibility":"Public","body":"Indexable.each_cartesian(arrays, reuse: reuse) do |r| yield r end"},"external_var":false},{"html_id":"each_product(*arrays:Array,reuse=false,&)-class-method","name":"each_product","doc":"Yields each ordered combination of the elements taken from each of the\n*arrays* as `Array`s.\nTraversal of elements starts from the last given array.","summary":"<p>Yields each ordered combination of the elements taken from each of the <em>arrays</em> as <code><a href=\"Array.html\">Array</a></code>s.</p>\n<p><span class=\"flag red\">DEPRECATED</span>  Use <code><a href=\"Indexable.html#each_cartesian%28%2Aothers%3AIndexable%2C%26%29-instance-method\">Indexable.each_cartesian(indexables : Indexable(Indexable)</a>, reuse = false, &amp;block)</code> instead</p>","abstract":false,"args":[{"name":"arrays","external_name":"arrays","restriction":"Array"},{"name":"reuse","default_value":"false","external_name":"reuse","restriction":""}],"args_string":"(*arrays : Array, reuse = false, &)","args_html":"(*arrays : <a href=\"Array.html\">Array</a>, reuse = <span class=\"n\">false</span>, &)","location":{"filename":"src/array.cr","line_number":1279,"url":null},"def":{"name":"each_product","args":[{"name":"arrays","external_name":"arrays","restriction":"Array"},{"name":"reuse","default_value":"false","external_name":"reuse","restriction":""}],"splat_index":0,"yields":1,"block_arity":1,"visibility":"Public","body":"Indexable.each_cartesian(arrays, reuse: reuse) do |r| yield r end"},"external_var":false},{"html_id":"from_json(string_or_io,&):Nil-class-method","name":"from_json","doc":"Parses a `String` or `IO` denoting a JSON array, yielding\neach of its elements to the given block. This is useful\nfor decoding an array and processing its elements without\ncreating an Array in memory, which might be expensive.\n\n```\nrequire \"json\"\n\nArray(Int32).from_json(\"[1, 2, 3]\") do |element|\n  puts element\nend\n```\n\nOutput:\n\n```text\n1\n2\n3\n```\n\nTo parse and get an `Array`, use the block-less overload.","summary":"<p>Parses a <code><a href=\"String.html\">String</a></code> or <code><a href=\"IO.html\">IO</a></code> denoting a JSON array, yielding each of its elements to the given block.</p>","abstract":false,"args":[{"name":"string_or_io","external_name":"string_or_io","restriction":""}],"args_string":"(string_or_io, &) : Nil","args_html":"(string_or_io, &) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/json/from_json.cr","line_number":53,"url":null},"def":{"name":"from_json","args":[{"name":"string_or_io","external_name":"string_or_io","restriction":""}],"yields":1,"block_arity":1,"return_type":"Nil","visibility":"Public","body":"parser = JSON::PullParser.new(string_or_io)\nnew(parser) do |element|\n  yield element\nend\nnil\n"},"external_var":false},{"html_id":"from_yaml(string_or_io:String|IO,&)-class-method","name":"from_yaml","abstract":false,"args":[{"name":"string_or_io","external_name":"string_or_io","restriction":"String | IO"}],"args_string":"(string_or_io : String | IO, &)","args_html":"(string_or_io : <a href=\"String.html\">String</a> | <a href=\"IO.html\">IO</a>, &)","location":{"filename":"src/yaml/from_yaml.cr","line_number":15,"url":null},"def":{"name":"from_yaml","args":[{"name":"string_or_io","external_name":"string_or_io","restriction":"String | IO"}],"yields":1,"block_arity":1,"visibility":"Public","body":"new(YAML::ParseContext.new, parse_yaml(string_or_io)) do |element|\n  yield element\nend"},"external_var":false},{"html_id":"product(arrays:Array(Array))-class-method","name":"product","doc":"Returns an `Array` of all ordered combinations of elements taken from each\nof the *arrays* as `Array`s.\nTraversal of elements starts from the last given array.","summary":"<p>Returns an <code><a href=\"Array.html\">Array</a></code> of all ordered combinations of elements taken from each of the <em>arrays</em> as <code><a href=\"Array.html\">Array</a></code>s.</p>\n<p><span class=\"flag red\">DEPRECATED</span>  Use <code><a href=\"Indexable.html#cartesian_product%28indexables%3AIndexable%28Indexable%29%29-class-method\">Indexable.cartesian_product(indexables : Indexable(Indexable)</a>)</code> instead</p>","abstract":false,"args":[{"name":"arrays","external_name":"arrays","restriction":"Array(Array)"}],"args_string":"(arrays : Array(Array))","args_html":"(arrays : <a href=\"Array.html\">Array</a>(<a href=\"Array.html\">Array</a>))","location":{"filename":"src/array.cr","line_number":1259,"url":null},"def":{"name":"product","args":[{"name":"arrays","external_name":"arrays","restriction":"Array(Array)"}],"visibility":"Public","body":"Indexable.cartesian_product(arrays)"},"external_var":false},{"html_id":"product(*arrays:Array)-class-method","name":"product","doc":"Returns an `Array` of all ordered combinations of elements taken from each\nof the *arrays* as `Array`s.\nTraversal of elements starts from the last given array.","summary":"<p>Returns an <code><a href=\"Array.html\">Array</a></code> of all ordered combinations of elements taken from each of the <em>arrays</em> as <code><a href=\"Array.html\">Array</a></code>s.</p>\n<p><span class=\"flag red\">DEPRECATED</span>  Use <code><a href=\"Indexable.html#cartesian_product%28indexables%3AIndexable%28Indexable%29%29-class-method\">Indexable.cartesian_product(indexables : Indexable(Indexable)</a>)</code> instead</p>","abstract":false,"args":[{"name":"arrays","external_name":"arrays","restriction":"Array"}],"args_string":"(*arrays : Array)","args_html":"(*arrays : <a href=\"Array.html\">Array</a>)","location":{"filename":"src/array.cr","line_number":1265,"url":null},"def":{"name":"product","args":[{"name":"arrays","external_name":"arrays","restriction":"Array"}],"splat_index":0,"visibility":"Public","body":"Indexable.cartesian_product(arrays)"},"external_var":false}],"constructors":[{"html_id":"additive_identity:self-class-method","name":"additive_identity","doc":"Returns the additive identity of this type.\n\nThis is an empty array.","summary":"<p>Returns the additive identity of this type.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":341,"url":null},"def":{"name":"additive_identity","return_type":"self","visibility":"Public","body":"self.new"},"external_var":false},{"html_id":"build(capacity:Int,&:Pointer(T)->):self-class-method","name":"build","doc":"Creates a new `Array`, allocating an internal buffer with the given *capacity*,\nand yielding that buffer. The given block must return the desired size of the array.\n\nThis method is **unsafe**, but is usually used to initialize the buffer\nby passing it to a C function.\n\n```\nArray.build(3) do |buffer|\n  LibSome.fill_buffer_and_return_number_of_elements_filled(buffer)\nend\n```","summary":"<p>Creates a new <code><a href=\"Array.html\">Array</a></code>, allocating an internal buffer with the given <em>capacity</em>, and yielding that buffer.</p>","abstract":false,"args":[{"name":"capacity","external_name":"capacity","restriction":"Int"}],"args_string":"(capacity : Int, & : Pointer(T) -> ) : self","args_html":"(capacity : <a href=\"Int.html\">Int</a>, & : <a href=\"Pointer.html\">Pointer</a>(T) -> ) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":191,"url":null},"def":{"name":"build","args":[{"name":"capacity","external_name":"capacity","restriction":"Int"}],"yields":1,"block_arity":1,"block_arg":{"name":"","external_name":"","restriction":"(Pointer(T) ->)"},"return_type":"self","visibility":"Public","body":"ary = Array(T).new(capacity)\nary.size = (yield ary.to_unsafe).to_i\nary\n"},"external_var":false},{"html_id":"new(size:Int,value:T)-class-method","name":"new","doc":"Creates a new `Array` of the given *size* filled with the same *value* in each position.\n\n```\nArray.new(3, 'a') # => ['a', 'a', 'a']\n```\n\nWARNING: The initial value is filled into the array as-is. It gets neither\nduplicated nor cloned. For types with reference semantics this means every\nitem will point to the *same* object.\n\n```\nary = Array.new(3, [1])\nary # => [[1], [1], [1]]\nary[0][0] = 2\nary # => [[2], [2], [2]]\n```\n\n* `.new(Int, & : Int32 -> T)` is an alternative that allows using a\n  different initial value for each position.","summary":"<p>Creates a new <code><a href=\"Array.html\">Array</a></code> of the given <em>size</em> filled with the same <em>value</em> in each position.</p>","abstract":false,"args":[{"name":"size","external_name":"size","restriction":"Int"},{"name":"value","external_name":"value","restriction":"T"}],"args_string":"(size : Int, value : T)","args_html":"(size : <a href=\"Int.html\">Int</a>, value : T)","location":{"filename":"src/array.cr","line_number":145,"url":null},"def":{"name":"new","args":[{"name":"size","external_name":"size","restriction":"Int"},{"name":"value","external_name":"value","restriction":"T"}],"visibility":"Public","body":"_ = Array(T).allocate\n_.initialize(size, value)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(ctx:YAML::ParseContext,node:YAML::Nodes::Node)-class-method","name":"new","abstract":false,"args":[{"name":"ctx","external_name":"ctx","restriction":"YAML::ParseContext"},{"name":"node","external_name":"node","restriction":"YAML::Nodes::Node"}],"args_string":"(ctx : YAML::ParseContext, node : YAML::Nodes::Node)","args_html":"(ctx : <a href=\"YAML/ParseContext.html\">YAML::ParseContext</a>, node : <a href=\"YAML/Nodes/Node.html\">YAML::Nodes::Node</a>)","location":{"filename":"src/yaml/from_yaml.cr","line_number":102,"url":null},"def":{"name":"new","args":[{"name":"ctx","external_name":"ctx","restriction":"YAML::ParseContext"},{"name":"node","external_name":"node","restriction":"YAML::Nodes::Node"}],"visibility":"Public","body":"ctx.read_alias(node, self) do |obj|\n  return obj\nend\n\nary = new\n\nctx.record_anchor(node, ary)\n\nnew(ctx, node) do |element|\n  ary << element\nend\nary\n"},"external_var":false},{"html_id":"new(initial_capacity:Int)-class-method","name":"new","doc":"Creates a new empty `Array` backed by a buffer that is initially\n`initial_capacity` big.\n\nThe *initial_capacity* is useful to avoid unnecessary reallocations\nof the internal buffer in case of growth. If you have an estimate\nof the maximum number of elements an array will hold, the array should\nbe initialized with that capacity for improved performance.\n\n```\nary = Array(Int32).new(5)\nary.size # => 0\n```","summary":"<p>Creates a new empty <code><a href=\"Array.html\">Array</a></code> backed by a buffer that is initially <code>initial_capacity</code> big.</p>","abstract":false,"args":[{"name":"initial_capacity","external_name":"initial_capacity","restriction":"Int"}],"args_string":"(initial_capacity : Int)","args_html":"(initial_capacity : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/array.cr","line_number":112,"url":null},"def":{"name":"new","args":[{"name":"initial_capacity","external_name":"initial_capacity","restriction":"Int"}],"visibility":"Public","body":"_ = Array(T).allocate\n_.initialize(initial_capacity)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(pull:JSON::PullParser)-class-method","name":"new","abstract":false,"args":[{"name":"pull","external_name":"pull","restriction":"JSON::PullParser"}],"args_string":"(pull : JSON::PullParser)","args_html":"(pull : <a href=\"JSON/PullParser.html\">JSON::PullParser</a>)","location":{"filename":"src/json/from_json.cr","line_number":206,"url":null},"def":{"name":"new","args":[{"name":"pull","external_name":"pull","restriction":"JSON::PullParser"}],"visibility":"Public","body":"ary = new\nnew(pull) do |element|\n  ary << element\nend\nary\n"},"external_var":false},{"html_id":"new-class-method","name":"new","doc":"Creates a new empty `Array`.","summary":"<p>Creates a new empty <code><a href=\"Array.html\">Array</a></code>.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":94,"url":null},"def":{"name":"new","visibility":"Public","body":"_ = Array(T).allocate\n_.initialize\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(ctx:YAML::ParseContext,node:YAML::Nodes::Node,&)-class-method","name":"new","abstract":false,"args":[{"name":"ctx","external_name":"ctx","restriction":"YAML::ParseContext"},{"name":"node","external_name":"node","restriction":"YAML::Nodes::Node"}],"args_string":"(ctx : YAML::ParseContext, node : YAML::Nodes::Node, &)","args_html":"(ctx : <a href=\"YAML/ParseContext.html\">YAML::ParseContext</a>, node : <a href=\"YAML/Nodes/Node.html\">YAML::Nodes::Node</a>, &)","location":{"filename":"src/yaml/from_yaml.cr","line_number":117,"url":null},"def":{"name":"new","args":[{"name":"ctx","external_name":"ctx","restriction":"YAML::ParseContext"},{"name":"node","external_name":"node","restriction":"YAML::Nodes::Node"}],"yields":1,"block_arity":1,"visibility":"Public","body":"if node.is_a?(YAML::Nodes::Sequence)\nelse\n  node.raise(\"Expected sequence, not #{node.kind}\")\nend\n\nnode.each do |value|\n  yield T.new(ctx, value)\nend\n"},"external_var":false},{"html_id":"new(size:Int,&:Int32->T)-class-method","name":"new","doc":"Creates a new `Array` of the given *size* and invokes the given block once\nfor each index of `self`, assigning the block's value in that index.\n\n```\nArray.new(3) { |i| (i + 1) ** 2 } # => [1, 4, 9]\n\nary = Array.new(3) { [1] }\nary # => [[1], [1], [1]]\nary[0][0] = 2\nary # => [[2], [1], [1]]\n```","summary":"<p>Creates a new <code><a href=\"Array.html\">Array</a></code> of the given <em>size</em> and invokes the given block once for each index of <code>self</code>, assigning the block's value in that index.</p>","abstract":false,"args":[{"name":"size","external_name":"size","restriction":"Int"}],"args_string":"(size : Int, & : Int32 -> T)","args_html":"(size : <a href=\"Int.html\">Int</a>, & : <a href=\"Int32.html\">Int32</a> -> T)","location":{"filename":"src/array.cr","line_number":171,"url":null},"def":{"name":"new","args":[{"name":"size","external_name":"size","restriction":"Int"}],"yields":1,"block_arity":1,"block_arg":{"name":"","external_name":"","restriction":"(Int32 -> T)"},"visibility":"Public","body":"Array(T).build(size) do |buffer|\n  size.to_i.times do |i|\n    buffer[i] = yield i\n  end\n  size\nend"},"external_var":false},{"html_id":"new(pull:JSON::PullParser,&)-class-method","name":"new","abstract":false,"args":[{"name":"pull","external_name":"pull","restriction":"JSON::PullParser"}],"args_string":"(pull : JSON::PullParser, &)","args_html":"(pull : <a href=\"JSON/PullParser.html\">JSON::PullParser</a>, &)","location":{"filename":"src/json/from_json.cr","line_number":214,"url":null},"def":{"name":"new","args":[{"name":"pull","external_name":"pull","restriction":"JSON::PullParser"}],"yields":1,"block_arity":1,"visibility":"Public","body":"pull.read_array do\n  yield T.new(pull)\nend"},"external_var":false}],"instance_methods":[{"html_id":"&(other:Array(U)):Array(T)forallU-instance-method","name":"&","doc":"Set intersection: returns a new `Array` containing elements common to `self`\nand *other*, excluding any duplicates. The order is preserved from `self`.\n\n```\n[1, 1, 3, 5] & [1, 2, 3]               # => [ 1, 3 ]\n['a', 'b', 'b', 'z'] & ['a', 'b', 'c'] # => [ 'a', 'b' ]\n```\n\nSee also: `#uniq`.","summary":"<p>Set intersection: returns a new <code><a href=\"Array.html\">Array</a></code> containing elements common to <code>self</code> and <em>other</em>, excluding any duplicates.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Array(U)"}],"args_string":"(other : Array(U)) : Array(T) forall U","args_html":"(other : <a href=\"Array.html\">Array</a>(U)) : <a href=\"Array.html\">Array</a>(T) forall U","location":{"filename":"src/array.cr","line_number":264,"url":null},"def":{"name":"&","args":[{"name":"other","external_name":"other","restriction":"Array(U)"}],"return_type":"Array(T)","visibility":"Public","body":"if self.empty? || other.empty?\n  return Array(T).new\nend\n\n\n\nif (self.size + other.size) <= (SMALL_ARRAY_SIZE * 2)\n  ary = Array(T).new\n  each do |elem|\n    if !(ary.includes?(elem)) && (other.includes?(elem))\n      ary << elem\n    end\n  end\n  return ary\nend\n\nset = other.to_set\nArray(T).build(Math.min(size, other.size)) do |buffer|\n  appender = buffer.appender\n  each do |obj|\n    if set.delete(obj)\n      appender << obj\n    end\n  end\n  appender.size.to_i\nend\n"},"external_var":false},{"html_id":"*(times:Int):Array(T)-instance-method","name":"*","doc":"Repetition: Returns a new `Array` built by concatenating *times* copies of `self`.\n\n```\n[\"a\", \"b\", \"c\"] * 2 # => [ \"a\", \"b\", \"c\", \"a\", \"b\", \"c\" ]\n```","summary":"<p>Repetition: Returns a new <code><a href=\"Array.html\">Array</a></code> built by concatenating <em>times</em> copies of <code>self</code>.</p>","abstract":false,"args":[{"name":"times","external_name":"times","restriction":"Int"}],"args_string":"(times : Int) : Array(T)","args_html":"(times : <a href=\"Int.html\">Int</a>) : <a href=\"Array.html\">Array</a>(T)","location":{"filename":"src/array.cr","line_number":375,"url":null},"def":{"name":"*","args":[{"name":"times","external_name":"times","restriction":"Int"}],"return_type":"Array(T)","visibility":"Public","body":"if (times == 0) || empty?\n  return Array(T).new\nend\n\nif times == 1\n  return dup\nend\n\nif size == 1\n  return Array(T).new(times, first)\nend\n\nnew_size = size * times\nArray(T).build(new_size) do |buffer|\n  buffer.copy_from(to_unsafe, size)\n  n = size\n\n  while n <= (new_size // 2)\n    (buffer + n).copy_from(buffer, n)\n    n = n * 2\n  end\n\n  (buffer + n).copy_from(buffer, new_size - n)\n  new_size\nend\n"},"external_var":false},{"html_id":"+(other:Array(U)):Array(T|U)forallU-instance-method","name":"+","doc":"Concatenation. Returns a new `Array` built by concatenating `self` and *other*.\nThe type of the new array is the union of the types of both the original arrays.\n\n```\n[1, 2] + [\"a\"]  # => [1,2,\"a\"] of (Int32 | String)\n[1, 2] + [2, 3] # => [1,2,2,3]\n```","summary":"<p>Concatenation.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Array(U)"}],"args_string":"(other : Array(U)) : Array(T | U) forall U","args_html":"(other : <a href=\"Array.html\">Array</a>(U)) : <a href=\"Array.html\">Array</a>(T | U) forall U","location":{"filename":"src/array.cr","line_number":329,"url":null},"def":{"name":"+","args":[{"name":"other","external_name":"other","restriction":"Array(U)"}],"return_type":"Array(T | U)","visibility":"Public","body":"new_size = size + other.size\nArray(T | U).build(new_size) do |buffer|\n  buffer.copy_from(@buffer, size)\n  (buffer + size).copy_from(other.to_unsafe, other.size)\n  new_size\nend\n"},"external_var":false},{"html_id":"-(other:Array(U)):Array(T)forallU-instance-method","name":"-","doc":"Difference. Returns a new `Array` that is a copy of `self`, removing any items\nthat appear in *other*. The order of `self` is preserved.\n\n```\n[1, 2, 3] - [2, 1] # => [3]\n```","summary":"<p>Difference.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Array(U)"}],"args_string":"(other : Array(U)) : Array(T) forall U","args_html":"(other : <a href=\"Array.html\">Array</a>(U)) : <a href=\"Array.html\">Array</a>(T) forall U","location":{"filename":"src/array.cr","line_number":351,"url":null},"def":{"name":"-","args":[{"name":"other","external_name":"other","restriction":"Array(U)"}],"return_type":"Array(T)","visibility":"Public","body":"if size <= SMALL_ARRAY_SIZE || other.size <= SMALL_ARRAY_SIZE\n  ary = Array(T).new\n  each do |elem|\n    if other.includes?(elem)\n    else\n      ary << elem\n    end\n  end\n  return ary\nend\n\nary = Array(T).new(Math.max(size - other.size, 0))\nset = other.to_set\neach do |obj|\n  if set.includes?(obj)\n  else\n    ary << obj\n  end\nend\nary\n"},"external_var":false},{"html_id":"<<(value:T):self-instance-method","name":"<<","doc":"Append. Alias for `push`.\n\n```\na = [1, 2]\na << 3 # => [1,2,3]\n```","summary":"<p>Append.</p>","abstract":false,"args":[{"name":"value","external_name":"value","restriction":"T"}],"args_string":"(value : T) : self","args_html":"(value : T) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":409,"url":null},"def":{"name":"<<","args":[{"name":"value","external_name":"value","restriction":"T"}],"return_type":"self","visibility":"Public","body":"push(value)"},"external_var":false},{"html_id":"<=>(other:Array)-instance-method","name":"<=>","doc":"Combined comparison operator.\n\nReturns `-1`, `0` or `1` depending on whether `self` is less than *other*, equals *other*\nor is greater than *other*.\n\nIt compares the elements of both arrays in the same position using the\n`<=>` operator. As soon as one of such comparisons returns a non-zero\nvalue, that result is the return value of the comparison.\n\nIf all elements are equal, the comparison is based on the size of the arrays.\n\n```\n[8] <=> [1, 2, 3] # => 1\n[2] <=> [4, 2, 3] # => -1\n[1, 2] <=> [1, 2] # => 0\n```","summary":"<p>Combined comparison operator.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Array"}],"args_string":"(other : Array)","args_html":"(other : <a href=\"Array.html\">Array</a>)","location":{"filename":"src/array.cr","line_number":246,"url":null},"def":{"name":"<=>","args":[{"name":"other","external_name":"other","restriction":"Array"}],"visibility":"Public","body":"min_size = Math.min(size, other.size)\n0.upto(min_size - 1) do |i|\n  n = @buffer[i] <=> other.to_unsafe[i]\n  if n != 0\n    return n\n  end\nend\nsize <=> other.size\n"},"external_var":false},{"html_id":"==(other:Array):Bool-instance-method","name":"==","doc":"Equality. Returns `true` if each element in `self` is equal to each\ncorresponding element in *other*.\n\n```\nary = [1, 2, 3]\nary == [1, 2, 3] # => true\nary == [2, 3]    # => false\n```","summary":"<p>Equality.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Array"}],"args_string":"(other : Array) : Bool","args_html":"(other : <a href=\"Array.html\">Array</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/array.cr","line_number":222,"url":null},"def":{"name":"==","args":[{"name":"other","external_name":"other","restriction":"Array"}],"return_type":"Bool","visibility":"Public","body":"equals?(other) do |x, y| x == y end"},"external_var":false},{"html_id":"==(other:JSON::Any)-instance-method","name":"==","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"JSON::Any"}],"args_string":"(other : JSON::Any)","args_html":"(other : <a href=\"JSON/Any.html\">JSON::Any</a>)","location":{"filename":"src/json/any.cr","line_number":376,"url":null},"def":{"name":"==","args":[{"name":"other","external_name":"other","restriction":"JSON::Any"}],"visibility":"Public","body":"self == other.raw"},"external_var":false},{"html_id":"==(other:YAML::Any)-instance-method","name":"==","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"YAML::Any"}],"args_string":"(other : YAML::Any)","args_html":"(other : <a href=\"YAML/Any.html\">YAML::Any</a>)","location":{"filename":"src/yaml/any.cr","line_number":381,"url":null},"def":{"name":"==","args":[{"name":"other","external_name":"other","restriction":"YAML::Any"}],"visibility":"Public","body":"self == other.raw"},"external_var":false},{"html_id":"==(other):Bool-instance-method","name":"==","doc":"Returns `false` (other can only be a `Value` here).","summary":"<p>Returns <code>false</code> (other can only be a <code><a href=\"Value.html\">Value</a></code> here).</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":""}],"args_string":"(other) : Bool","args_html":"(other) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/array.cr","line_number":226,"url":null},"def":{"name":"==","args":[{"name":"other","external_name":"other","restriction":""}],"return_type":"Bool","visibility":"Public","body":"false"},"external_var":false},{"html_id":"[](start:Int,count:Int):Array(T)-instance-method","name":"[]","doc":"Returns count or less (if there aren't enough) elements starting at the\ngiven start index.\n\nNegative *start* is added to `self.size`, thus it's treated as\nindex counting from the end of the array, `-1` designating the last element.\n\nRaises `IndexError` if *start* index is out of bounds.\nRaises `ArgumentError` if *count* is negative.\n\n```\na = [\"a\", \"b\", \"c\", \"d\", \"e\"]\na[-3, 3] # => [\"c\", \"d\", \"e\"]\na[1, 2]  # => [\"b\", \"c\"]\na[5, 1]  # => []\na[6, 1]  # raises IndexError\n```","summary":"<p>Returns count or less (if there aren't enough) elements starting at the given start index.</p>","abstract":false,"args":[{"name":"start","external_name":"start","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"}],"args_string":"(start : Int, count : Int) : Array(T)","args_html":"(start : <a href=\"Int.html\">Int</a>, count : <a href=\"Int.html\">Int</a>) : <a href=\"Array.html\">Array</a>(T)","location":{"filename":"src/array.cr","line_number":648,"url":null},"def":{"name":"[]","args":[{"name":"start","external_name":"start","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"}],"return_type":"Array(T)","visibility":"Public","body":"self[start, count]? || (raise(IndexError.new))"},"external_var":false},{"html_id":"[](range:Range):Array(T)-instance-method","name":"[]","doc":"Returns all elements that are within the given range.\n\nThe first element in the returned array is `self[range.begin]` followed\nby the next elements up to index `range.end` (or `self[range.end - 1]` if\nthe range is exclusive).\nIf there are fewer elements in `self`, the returned array is shorter than\n`range.size`.\n\n```\na = [\"a\", \"b\", \"c\", \"d\", \"e\"]\na[1..3] # => [\"b\", \"c\", \"d\"]\n# range.end > array.size\na[3..7] # => [\"d\", \"e\"]\n```\n\nOpen ended ranges are clamped at the start and end of the array, respectively.\n\n```\n# open ended ranges\na[2..] # => [\"c\", \"d\", \"e\"]\na[..2] # => [\"a\", \"b\", \"c\"]\n```\n\nNegative range values are added to `self.size`, thus they are treated as\nindices counting from the end of the array, `-1` designating the last element.\n\n```\n# negative indices, both ranges are equivalent for `a`\na[1..3]   # => [\"b\", \"c\", \"d\"]\na[-4..-2] # => [\"b\", \"c\", \"d\"]\n# Mixing negative and positive indices, both ranges are equivalent for `a`\na[1..-2] # => [\"b\", \"c\", \"d\"]\na[-4..3] # => [\"b\", \"c\", \"d\"]\n```\n\nRaises `IndexError` if the start index is out of range (`range.begin >\nself.size || range.begin < -self.size`). If `range.begin == self.size` an\nempty array is returned. If `range.begin > range.end`, an empty array is\nreturned.\n\n```\n# range.begin > array.size\na[6..10] # raise IndexError\n# range.begin == array.size\na[5..10] # => []\n# range.begin > range.end\na[3..1]   # => []\na[-2..-4] # => []\na[-2..1]  # => []\na[3..-4]  # => []\n```","summary":"<p>Returns all elements that are within the given range.</p>","abstract":false,"args":[{"name":"range","external_name":"range","restriction":"Range"}],"args_string":"(range : Range) : Array(T)","args_html":"(range : <a href=\"Range.html\">Range</a>) : <a href=\"Array.html\">Array</a>(T)","location":{"filename":"src/array.cr","line_number":617,"url":null},"def":{"name":"[]","args":[{"name":"range","external_name":"range","restriction":"Range"}],"return_type":"Array(T)","visibility":"Public","body":"self[*(Indexable.range_to_index_and_count(range, size)) || (raise(IndexError.new))]"},"external_var":false},{"html_id":"[]=(start:Int,count:Int,values:Array(T))-instance-method","name":"[]=","doc":"Replaces a subrange with the elements of the given array.\n\n```\na = [1, 2, 3, 4, 5]\na[1, 3] = [6, 7, 8]\na # => [1, 6, 7, 8, 5]\n\na = [1, 2, 3, 4, 5]\na[1, 3] = [6, 7]\na # => [1, 6, 7, 5]\n\na = [1, 2, 3, 4, 5]\na[1, 3] = [6, 7, 8, 9, 10]\na # => [1, 6, 7, 8, 9, 10, 5]\n```","summary":"<p>Replaces a subrange with the elements of the given array.</p>","abstract":false,"args":[{"name":"start","external_name":"start","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"},{"name":"values","external_name":"values","restriction":"Array(T)"}],"args_string":"(start : Int, count : Int, values : Array(T))","args_html":"(start : <a href=\"Int.html\">Int</a>, count : <a href=\"Int.html\">Int</a>, values : <a href=\"Array.html\">Array</a>(T))","location":{"filename":"src/array.cr","line_number":512,"url":null},"def":{"name":"[]=","args":[{"name":"start","external_name":"start","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"},{"name":"values","external_name":"values","restriction":"Array(T)"}],"visibility":"Public","body":"start, count = normalize_start_and_count(start, count)\ndiff = values.size - count\n\nif diff == 0\n  (@buffer + start).copy_from(values.to_unsafe, values.size)\nelsif diff < 0\n  diff = -diff\n  (@buffer + start).copy_from(values.to_unsafe, values.size)\n  ((@buffer + start) + values.size).move_from((@buffer + start) + count, (size - start) - count)\n  ((@buffer + @size) - diff).clear(diff)\n  @size = @size - diff\nelse\n  resize_if_cant_insert(diff)\n  ((@buffer + start) + values.size).move_from((@buffer + start) + count, (size - start) - count)\n  (@buffer + start).copy_from(values.to_unsafe, values.size)\n  @size = @size + diff\nend\n\nvalues\n"},"external_var":false},{"html_id":"[]=(start:Int,count:Int,value:T):T-instance-method","name":"[]=","doc":"Replaces a subrange with a single value. All elements in the range\n`start...start+count` are removed and replaced by a single element\n*value*.\n\nIf *count* is zero, *value* is inserted at *start*.\n\nNegative values of *start* count from the end of the array.\n\n```\na = [1, 2, 3, 4, 5]\na[1, 3] = 6\na # => [1, 6, 5]\n\na = [1, 2, 3, 4, 5]\na[1, 0] = 6\na # => [1, 6, 2, 3, 4, 5]\n```","summary":"<p>Replaces a subrange with a single value.</p>","abstract":false,"args":[{"name":"start","external_name":"start","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"},{"name":"value","external_name":"value","restriction":"T"}],"args_string":"(start : Int, count : Int, value : T) : T","args_html":"(start : <a href=\"Int.html\">Int</a>, count : <a href=\"Int.html\">Int</a>, value : T) : T","location":{"filename":"src/array.cr","line_number":430,"url":null},"def":{"name":"[]=","args":[{"name":"start","external_name":"start","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"},{"name":"value","external_name":"value","restriction":"T"}],"return_type":"T","visibility":"Public","body":"start, count = normalize_start_and_count(start, count)\n\ncase count\nwhen 0\n  insert(start, value)\nwhen 1\n  @buffer[start] = value\nelse\n  diff = count - 1\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  if start == 0\n    @buffer.clear(diff)\n    shift_buffer_by(diff)\n    @buffer.value = value\n  else\n    ((@buffer + start) + 1).move_from((@buffer + start) + count, (size - start) - count)\n    ((@buffer + @size) - diff).clear(diff)\n    @buffer[start] = value\n  end\n\n  @size = @size - diff\nend\n\nvalue\n"},"external_var":false},{"html_id":"[]=(range:Range,values:Array(T))-instance-method","name":"[]=","doc":"Replaces a subrange with the elements of the given array.\n\n```\na = [1, 2, 3, 4, 5]\na[1..3] = [6, 7, 8]\na # => [1, 6, 7, 8, 5]\n\na = [1, 2, 3, 4, 5]\na[1..3] = [6, 7]\na # => [1, 6, 7, 5]\n\na = [1, 2, 3, 4, 5]\na[1..3] = [6, 7, 8, 9, 10]\na # => [1, 6, 7, 8, 9, 10, 5]\n\na = [1, 2, 3, 4, 5]\na[2..] = [6, 7, 8, 9, 10]\na # => [1, 2, 6, 7, 8, 9, 10]\n```","summary":"<p>Replaces a subrange with the elements of the given array.</p>","abstract":false,"args":[{"name":"range","external_name":"range","restriction":"Range"},{"name":"values","external_name":"values","restriction":"Array(T)"}],"args_string":"(range : Range, values : Array(T))","args_html":"(range : <a href=\"Range.html\">Range</a>, values : <a href=\"Array.html\">Array</a>(T))","location":{"filename":"src/array.cr","line_number":562,"url":null},"def":{"name":"[]=","args":[{"name":"range","external_name":"range","restriction":"Range"},{"name":"values","external_name":"values","restriction":"Array(T)"}],"visibility":"Public","body":"self[*(Indexable.range_to_index_and_count(range, size)) || (raise(IndexError.new))] = values"},"external_var":false},{"html_id":"[]=(range:Range,value:T)-instance-method","name":"[]=","doc":"Replaces a subrange with a single value.\n\n```\na = [1, 2, 3, 4, 5]\na[1..3] = 6\na # => [1, 6, 5]\n\na = [1, 2, 3, 4, 5]\na[1...1] = 6\na # => [1, 6, 2, 3, 4, 5]\n\na = [1, 2, 3, 4, 5]\na[2...] = 6\na # => [1, 2, 6]\n```","summary":"<p>Replaces a subrange with a single value.</p>","abstract":false,"args":[{"name":"range","external_name":"range","restriction":"Range"},{"name":"value","external_name":"value","restriction":"T"}],"args_string":"(range : Range, value : T)","args_html":"(range : <a href=\"Range.html\">Range</a>, value : T)","location":{"filename":"src/array.cr","line_number":493,"url":null},"def":{"name":"[]=","args":[{"name":"range","external_name":"range","restriction":"Range"},{"name":"value","external_name":"value","restriction":"T"}],"visibility":"Public","body":"self[*(Indexable.range_to_index_and_count(range, size)) || (raise(IndexError.new))] = value"},"external_var":false},{"html_id":"[]=(values:Array(T),*,indexstart:Int,count:Int)-instance-method","name":"[]=","doc":"Replaces a subrange with the elements of the given array.\n\n```\na = [1, 2, 3, 4, 5]\na[1, 3] = [6, 7, 8]\na # => [1, 6, 7, 8, 5]\n\na = [1, 2, 3, 4, 5]\na[1, 3] = [6, 7]\na # => [1, 6, 7, 5]\n\na = [1, 2, 3, 4, 5]\na[1, 3] = [6, 7, 8, 9, 10]\na # => [1, 6, 7, 8, 9, 10, 5]\n```","summary":"<p>Replaces a subrange with the elements of the given array.</p>\n<p><span class=\"flag red\">DEPRECATED</span>  Use <code><a href=\"Array.html#%5B%5D%3D%28start%3AInt%2Ccount%3AInt%2Cvalues%3AArray%28T%29%29-instance-method\">#[]=(start, count, values)</a></code> instead</p>","abstract":false,"args":[{"name":"values","external_name":"values","restriction":"Array(T)"},{"name":"","external_name":"","restriction":""},{"name":"start","external_name":"index","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"}],"args_string":"(values : Array(T), *, index start : Int, count : Int)","args_html":"(values : <a href=\"Array.html\">Array</a>(T), *, index start : <a href=\"Int.html\">Int</a>, count : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/array.cr","line_number":539,"url":null},"def":{"name":"[]=","args":[{"name":"values","external_name":"values","restriction":"Array(T)"},{"name":"","external_name":"","restriction":""},{"name":"start","external_name":"index","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"}],"splat_index":1,"visibility":"Public","body":"self[start, count] = values"},"external_var":false},{"html_id":"[]=(value:T,*,indexstart:Int,count:Int)-instance-method","name":"[]=","doc":"Replaces a subrange with a single value. All elements in the range\n`start...start+count` are removed and replaced by a single element\n*value*.\n\nIf *count* is zero, *value* is inserted at *start*.\n\nNegative values of *start* count from the end of the array.\n\n```\na = [1, 2, 3, 4, 5]\na[1, 3] = 6\na # => [1, 6, 5]\n\na = [1, 2, 3, 4, 5]\na[1, 0] = 6\na # => [1, 6, 2, 3, 4, 5]\n```","summary":"<p>Replaces a subrange with a single value.</p>\n<p><span class=\"flag red\">DEPRECATED</span>  Use <code><a href=\"Array.html#%5B%5D%3D%28start%3AInt%2Ccount%3AInt%2Cvalues%3AArray%28T%29%29-instance-method\">#[]=(start, count, value)</a></code> instead</p>","abstract":false,"args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"","external_name":"","restriction":""},{"name":"start","external_name":"index","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"}],"args_string":"(value : T, *, index start : Int, count : Int)","args_html":"(value : T, *, index start : <a href=\"Int.html\">Int</a>, count : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/array.cr","line_number":474,"url":null},"def":{"name":"[]=","args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"","external_name":"","restriction":""},{"name":"start","external_name":"index","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"}],"splat_index":1,"visibility":"Public","body":"self[start, count] = value"},"external_var":false},{"html_id":"[]?(start:Int,count:Int):Array(T)|Nil-instance-method","name":"[]?","doc":"Like `#[](Int, Int)` but returns `nil` if the *start* index is out of range.","summary":"<p>Like <code><a href=\"Array.html#%5B%5D%28start%3AInt%2Ccount%3AInt%29%3AArray%28T%29-instance-method\">#[](Int, Int)</a></code> but returns <code>nil</code> if the <em>start</em> index is out of range.</p>","abstract":false,"args":[{"name":"start","external_name":"start","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"}],"args_string":"(start : Int, count : Int) : Array(T) | Nil","args_html":"(start : <a href=\"Int.html\">Int</a>, count : <a href=\"Int.html\">Int</a>) : <a href=\"Array.html\">Array</a>(T) | <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/array.cr","line_number":653,"url":null},"def":{"name":"[]?","args":[{"name":"start","external_name":"start","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"}],"return_type":"Array(T) | ::Nil","visibility":"Public","body":"start, count = normalize_start_and_count(start, count) do return nil end\nif count == 0\n  return Array(T).new\nend\n\nArray(T).build(count) do |buffer|\n  buffer.copy_from(@buffer + start, count)\n  count\nend\n"},"external_var":false},{"html_id":"[]?(range:Range):Array(T)|Nil-instance-method","name":"[]?","doc":"Like `#[](Range)`, but returns `nil` if `range.begin` is out of range.\n\n```\na = [\"a\", \"b\", \"c\", \"d\", \"e\"]\na[6..10]? # => nil\na[6..]?   # => nil\n```","summary":"<p>Like <code><a href=\"Array.html#%5B%5D%28range%3ARange%29%3AArray%28T%29-instance-method\">#[](Range)</a></code>, but returns <code>nil</code> if <code>range.begin</code> is out of range.</p>","abstract":false,"args":[{"name":"range","external_name":"range","restriction":"Range"}],"args_string":"(range : Range) : Array(T) | Nil","args_html":"(range : <a href=\"Range.html\">Range</a>) : <a href=\"Array.html\">Array</a>(T) | <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/array.cr","line_number":628,"url":null},"def":{"name":"[]?","args":[{"name":"range","external_name":"range","restriction":"Range"}],"return_type":"Array(T) | ::Nil","visibility":"Public","body":"self[*(Indexable.range_to_index_and_count(range, size)) || (return nil)]?"},"external_var":false},{"html_id":"|(other:Array(U)):Array(T|U)forallU-instance-method","name":"|","doc":"Set union: returns a new `Array` by joining `self` with *other*, excluding\nany duplicates, and preserving the order from `self`.\n\n```\n[\"a\", \"b\", \"c\"] | [\"c\", \"d\", \"a\"] # => [ \"a\", \"b\", \"c\", \"d\" ]\n```\n\nSee also: `#uniq`.","summary":"<p>Set union: returns a new <code><a href=\"Array.html\">Array</a></code> by joining <code>self</code> with <em>other</em>, excluding any duplicates, and preserving the order from <code>self</code>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Array(U)"}],"args_string":"(other : Array(U)) : Array(T | U) forall U","args_html":"(other : <a href=\"Array.html\">Array</a>(U)) : <a href=\"Array.html\">Array</a>(T | U) forall U","location":{"filename":"src/array.cr","line_number":295,"url":null},"def":{"name":"|","args":[{"name":"other","external_name":"other","restriction":"Array(U)"}],"return_type":"Array(T | U)","visibility":"Public","body":"if (size + other.size) <= SMALL_ARRAY_SIZE\n  ary = Array(T | U).new\n  each do |elem|\n    if ary.includes?(elem)\n    else\n      ary << elem\n    end\n  end\n  other.each do |elem|\n    if ary.includes?(elem)\n    else\n      ary << elem\n    end\n  end\n  return ary\nend\n\nArray(T | U).build(size + other.size) do |buffer|\n  set = Set(T | U).new\n  appender = buffer.appender\n  each do |obj|\n    if set.add?(obj)\n      appender << obj\n    end\n  end\n  other.each do |obj|\n    if set.add?(obj)\n      appender << obj\n    end\n  end\n  appender.size.to_i\nend\n"},"external_var":false},{"html_id":"clear:self-instance-method","name":"clear","doc":"Removes all elements from `self`.\n\n```\na = [\"a\", \"b\", \"c\", \"d\", \"e\"]\na.clear # => []\n```","summary":"<p>Removes all elements from <code>self</code>.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":679,"url":null},"def":{"name":"clear","return_type":"self","visibility":"Public","body":"@buffer.clear(@size)\n@size = 0\nself\n"},"external_var":false},{"html_id":"clone:Array(T)-instance-method","name":"clone","doc":"Returns a new `Array` that has `self`'s elements cloned.\nThat is, it returns a deep copy of `self`.\n\nUse `#dup` if you want a shallow copy.\n\n```\nary = [[1, 2], [3, 4]]\nary2 = ary.clone\nary[0][0] = 5\nary  # => [[5, 2], [3, 4]]\nary2 # => [[1, 2], [3, 4]]\n\nary2 << [7, 8]\nary  # => [[5, 2], [3, 4]]\nary2 # => [[1, 2], [3, 4], [7, 8]]\n```","summary":"<p>Returns a new <code><a href=\"Array.html\">Array</a></code> that has <code>self</code>'s elements cloned.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":701,"url":null},"def":{"name":"clone","return_type":"Array(T)","visibility":"Public","body":"{% if ((((T == ::Bool) || (T == ::Char)) || (T == ::String)) || (T == ::Symbol)) || T < ::Number::Primitive %}\n      Array(T).new(size) { |i| @buffer[i].clone.as(T) }\n    {% else %}\n      exec_recursive_clone do |hash|\n        clone = Array(T).new(size)\n        hash[object_id] = clone.object_id\n        each do |element|\n          clone << element.clone.as(T)\n        end\n        clone\n      end\n    {% end %}"},"external_var":false},{"html_id":"compact-instance-method","name":"compact","doc":"Returns a copy of `self` with all `nil` elements removed.\n\n```\n[\"a\", nil, \"b\", nil, \"c\", nil].compact # => [\"a\", \"b\", \"c\"]\n```","summary":"<p>Returns a copy of <code>self</code> with all <code>nil</code> elements removed.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":721,"url":null},"def":{"name":"compact","visibility":"Public","body":"compact_map(&.itself)"},"external_var":false},{"html_id":"compact!:self-instance-method","name":"compact!","doc":"Removes all `nil` elements from `self` and returns `self`.\n\n```\nary = [\"a\", nil, \"b\", nil, \"c\"]\nary.compact!\nary # => [\"a\", \"b\", \"c\"]\n```","summary":"<p>Removes all <code>nil</code> elements from <code>self</code> and returns <code>self</code>.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":732,"url":null},"def":{"name":"compact!","return_type":"self","visibility":"Public","body":"reject! do |__arg1| __arg1.nil? end"},"external_var":false},{"html_id":"concat(other:Indexable):self-instance-method","name":"concat","doc":"Appends the elements of *other* to `self`, and returns `self`.\n\n```\nary = [\"a\", \"b\"]\nary.concat([\"c\", \"d\"])\nary # => [\"a\", \"b\", \"c\", \"d\"]\n```","summary":"<p>Appends the elements of <em>other</em> to <code>self</code>, and returns <code>self</code>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Indexable"}],"args_string":"(other : Indexable) : self","args_html":"(other : <a href=\"Indexable.html\">Indexable</a>) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":743,"url":null},"def":{"name":"concat","args":[{"name":"other","external_name":"other","restriction":"Indexable"}],"return_type":"self","visibility":"Public","body":"other_size = other.size\n\nresize_if_cant_insert(other_size)\n\ninsert_elements_at(other, @size)\n\n@size = @size + other_size\n\nself\n"},"external_var":false},{"html_id":"concat(other:Enumerable):self-instance-method","name":"concat","doc":"Appends the elements of *other* to `self`, and returns `self`.\n\n```\nary = [\"a\", \"b\"]\nary.concat([\"c\", \"d\"])\nary # => [\"a\", \"b\", \"c\", \"d\"]\n```","summary":"<p>Appends the elements of <em>other</em> to <code>self</code>, and returns <code>self</code>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Enumerable"}],"args_string":"(other : Enumerable) : self","args_html":"(other : <a href=\"Enumerable.html\">Enumerable</a>) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":756,"url":null},"def":{"name":"concat","args":[{"name":"other","external_name":"other","restriction":"Enumerable"}],"return_type":"self","visibility":"Public","body":"left_before_resize = remaining_capacity - @size\nlen = @size\nbuf = @buffer + len\nother.each do |elem|\n  if left_before_resize == 0\n    increase_capacity\n    left_before_resize = remaining_capacity - len\n    buf = @buffer + len\n  end\n  buf.value = elem\n  buf = buf + 1\n  len = len + 1\n  left_before_resize = left_before_resize - 1\nend\n\n@size = len\n\nself\n"},"external_var":false},{"html_id":"delete(obj):T|Nil-instance-method","name":"delete","doc":"Removes all items from `self` that are equal to *obj*.\n\nReturns the last found element that was equal to *obj*,\nif any, or `nil` if not found.\n\n```\na = [\"a\", \"b\", \"b\", \"b\", \"c\"]\na.delete(\"b\") # => \"b\"\na             # => [\"a\", \"c\"]\n\na.delete(\"x\") # => nil\na             # => [\"a\", \"c\"]\n```","summary":"<p>Removes all items from <code>self</code> that are equal to <em>obj</em>.</p>","abstract":false,"args":[{"name":"obj","external_name":"obj","restriction":""}],"args_string":"(obj) : T | Nil","args_html":"(obj) : T | <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/array.cr","line_number":790,"url":null},"def":{"name":"delete","args":[{"name":"obj","external_name":"obj","restriction":""}],"return_type":"T | ::Nil","visibility":"Public","body":"internal_delete do |e| e == obj end[1]"},"external_var":false},{"html_id":"delete_at(start:Int,count:Int):self-instance-method","name":"delete_at","doc":"Removes *count* elements from `self` starting at *start*.\nIf the size of `self` is less than *count*, removes values to the end of the array without error.\nReturns an array of the removed elements with the original order of `self` preserved.\nRaises `IndexError` if *start* is out of range.\n\n```\na = [\"ant\", \"bat\", \"cat\", \"dog\"]\na.delete_at(1, 2)  # => [\"bat\", \"cat\"]\na                  # => [\"ant\", \"dog\"]\na.delete_at(99, 1) # raises IndexError\n```","summary":"<p>Removes <em>count</em> elements from <code>self</code> starting at <em>start</em>.</p>","abstract":false,"args":[{"name":"start","external_name":"start","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"}],"args_string":"(start : Int, count : Int) : self","args_html":"(start : <a href=\"Int.html\">Int</a>, count : <a href=\"Int.html\">Int</a>) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":843,"url":null},"def":{"name":"delete_at","args":[{"name":"start","external_name":"start","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"}],"return_type":"self","visibility":"Public","body":"start, count = normalize_start_and_count(start, count)\n\nval = self[start, count]\n(@buffer + start).move_from((@buffer + start) + count, (size - start) - count)\n@size = @size - count\n(@buffer + @size).clear(count)\nval\n"},"external_var":false},{"html_id":"delete_at(index:Int):T-instance-method","name":"delete_at","doc":"Removes the element at *index*, returning that element.\nRaises `IndexError` if *index* is out of range.\n\n```\na = [\"ant\", \"bat\", \"cat\", \"dog\"]\na.delete_at(2)  # => \"cat\"\na               # => [\"ant\", \"bat\", \"dog\"]\na.delete_at(99) # raises IndexError\n```","summary":"<p>Removes the element at <em>index</em>, returning that element.</p>","abstract":false,"args":[{"name":"index","external_name":"index","restriction":"Int"}],"args_string":"(index : Int) : T","args_html":"(index : <a href=\"Int.html\">Int</a>) : T","location":{"filename":"src/array.cr","line_number":803,"url":null},"def":{"name":"delete_at","args":[{"name":"index","external_name":"index","restriction":"Int"}],"return_type":"T","visibility":"Public","body":"index = check_index_out_of_bounds(index)\n\n\nif index == 0\n  return shift_when_not_empty\nend\n\nelem = @buffer[index]\n(@buffer + index).move_from((@buffer + index) + 1, (size - index) - 1)\n@size = @size - 1\n(@buffer + @size).clear\nelem\n"},"external_var":false},{"html_id":"delete_at(range:Range):self-instance-method","name":"delete_at","doc":"Removes all elements within the given *range*.\nReturns an array of the removed elements with the original order of `self` preserved.\nRaises `IndexError` if the index is out of range.\n\n```\na = [\"ant\", \"bat\", \"cat\", \"dog\"]\na.delete_at(1..2)    # => [\"bat\", \"cat\"]\na                    # => [\"ant\", \"dog\"]\na.delete_at(99..100) # raises IndexError\n```","summary":"<p>Removes all elements within the given <em>range</em>.</p>","abstract":false,"args":[{"name":"range","external_name":"range","restriction":"Range"}],"args_string":"(range : Range) : self","args_html":"(range : <a href=\"Range.html\">Range</a>) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":828,"url":null},"def":{"name":"delete_at","args":[{"name":"range","external_name":"range","restriction":"Range"}],"return_type":"self","visibility":"Public","body":"delete_at(*(Indexable.range_to_index_and_count(range, size)) || (raise(IndexError.new)))"},"external_var":false},{"html_id":"delete_at(*,indexstart:Int,count:Int):self-instance-method","name":"delete_at","doc":"Removes *count* elements from `self` starting at *start*.\nIf the size of `self` is less than *count*, removes values to the end of the array without error.\nReturns an array of the removed elements with the original order of `self` preserved.\nRaises `IndexError` if *start* is out of range.\n\n```\na = [\"ant\", \"bat\", \"cat\", \"dog\"]\na.delete_at(1, 2)  # => [\"bat\", \"cat\"]\na                  # => [\"ant\", \"dog\"]\na.delete_at(99, 1) # raises IndexError\n```","summary":"<p>Removes <em>count</em> elements from <code>self</code> starting at <em>start</em>.</p>\n<p><span class=\"flag red\">DEPRECATED</span>  Use <code><a href=\"Array.html#delete_at%28start%3AInt%2Ccount%3AInt%29%3Aself-instance-method\">#delete_at(start, count)</a></code> instead</p>","abstract":false,"args":[{"name":"","external_name":"","restriction":""},{"name":"start","external_name":"index","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"}],"args_string":"(*, index start : Int, count : Int) : self","args_html":"(*, index start : <a href=\"Int.html\">Int</a>, count : <a href=\"Int.html\">Int</a>) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":855,"url":null},"def":{"name":"delete_at","args":[{"name":"","external_name":"","restriction":""},{"name":"start","external_name":"index","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"}],"splat_index":0,"return_type":"self","visibility":"Public","body":"delete_at(start, count)"},"external_var":false},{"html_id":"dup:Array(T)-instance-method","name":"dup","doc":"Returns a new `Array` that has exactly `self`'s elements.\nThat is, it returns a shallow copy of `self`.\n\nUse `#clone` if you want a deep copy.\n\n```\nary = [[1, 2], [3, 4]]\nary2 = ary.dup\nary[0][0] = 5\nary  # => [[5, 2], [3, 4]]\nary2 # => [[5, 2], [3, 4]]\n\nary2 << [7, 8]\nary  # => [[5, 2], [3, 4]]\nary2 # => [[5, 2], [3, 4], [7, 8]]\n```","summary":"<p>Returns a new <code><a href=\"Array.html\">Array</a></code> that has exactly <code>self</code>'s elements.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":875,"url":null},"def":{"name":"dup","return_type":"Array(T)","visibility":"Public","body":"Array(T).build(@size) do |buffer|\n  buffer.copy_from(@buffer, size)\n  size\nend"},"external_var":false},{"html_id":"each_repeated_permutation(size:Int=self.size,reuse=false,&):Nil-instance-method","name":"each_repeated_permutation","abstract":false,"args":[{"name":"size","default_value":"self.size","external_name":"size","restriction":"Int"},{"name":"reuse","default_value":"false","external_name":"reuse","restriction":""}],"args_string":"(size : Int = self.size, reuse = false, &) : Nil","args_html":"(size : <a href=\"Int.html\">Int</a> = <span class=\"k\">self</span>.size, reuse = <span class=\"n\">false</span>, &) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/array.cr","line_number":1291,"url":null},"def":{"name":"each_repeated_permutation","args":[{"name":"size","default_value":"self.size","external_name":"size","restriction":"Int"},{"name":"reuse","default_value":"false","external_name":"reuse","restriction":""}],"yields":1,"block_arity":1,"return_type":"Nil","visibility":"Public","body":"n = self.size\nif (size != 0) && (n == 0)\n  return\nend\nif size < 0\n  raise(ArgumentError.new(\"Size must be positive\"))\nend\n\nif size == 0\n  yield([] of T)\nelse\n  Indexable.each_cartesian(Array.new(size, self), reuse: reuse) do |r| yield r end\nend\n"},"external_var":false},{"html_id":"fill(start:Int,&:Int32->T):self-instance-method","name":"fill","doc":"Yields each index of `self`, starting at *start*, to the given block and then assigns\nthe block's value in that position. Returns `self`.\n\nNegative values of *start* count from the end of the array.\n\nRaises `IndexError` if *start* is outside the array range.\n\n```\na = [1, 2, 3, 4]\na.fill(2) { |i| i * i } # => [1, 2, 4, 9]\n```","summary":"<p>Yields each index of <code>self</code>, starting at <em>start</em>, to the given block and then assigns the block's value in that position.</p>\n<p><span class=\"flag red\">DEPRECATED</span>  Use <code><a href=\"Array.html#fill%28%2A%2Cfromstart%3AInt%2C%26%3AInt32-%3ET%29%3Aself-instance-method\">#fill(start.., &amp;)</a></code> instead</p>","abstract":false,"args":[{"name":"start","external_name":"start","restriction":"Int"}],"args_string":"(start : Int, & : Int32 -> T) : self","args_html":"(start : <a href=\"Int.html\">Int</a>, & : <a href=\"Int32.html\">Int32</a> -> T) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":894,"url":null},"def":{"name":"fill","args":[{"name":"start","external_name":"start","restriction":"Int"}],"yields":1,"block_arity":1,"block_arg":{"name":"","external_name":"","restriction":"(Int32 -> T)"},"return_type":"self","visibility":"Public","body":"fill(start..) do |i| yield i end"},"external_var":false},{"html_id":"fill(*,fromstart:Int,&:Int32->T):self-instance-method","name":"fill","doc":"Yields each index of `self`, starting at *start*, to the given block and then assigns\nthe block's value in that position. Returns `self`.\n\nNegative values of *start* count from the end of the array.\n\nRaises `IndexError` if *start* is outside the array range.\n\n```\na = [1, 2, 3, 4]\na.fill(2) { |i| i * i } # => [1, 2, 4, 9]\n```","summary":"<p>Yields each index of <code>self</code>, starting at <em>start</em>, to the given block and then assigns the block's value in that position.</p>\n<p><span class=\"flag red\">DEPRECATED</span>  Use <code><a href=\"Array.html#fill%28%2A%2Cfromstart%3AInt%2C%26%3AInt32-%3ET%29%3Aself-instance-method\">#fill(start.., &amp;)</a></code> instead</p>","abstract":false,"args":[{"name":"","external_name":"","restriction":""},{"name":"start","external_name":"from","restriction":"Int"}],"args_string":"(*, from start : Int, & : Int32 -> T) : self","args_html":"(*, from start : <a href=\"Int.html\">Int</a>, & : <a href=\"Int32.html\">Int32</a> -> T) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":900,"url":null},"def":{"name":"fill","args":[{"name":"","external_name":"","restriction":""},{"name":"start","external_name":"from","restriction":"Int"}],"splat_index":0,"yields":1,"block_arity":1,"block_arg":{"name":"","external_name":"","restriction":"(Int32 -> T)"},"return_type":"self","visibility":"Public","body":"fill(start..) do |i| yield i end"},"external_var":false},{"html_id":"fill(*,fromstart:Int,count:Int,&:Int32->T):self-instance-method","name":"fill","doc":"Yields each index of `self`, starting at *start* and just *count* times,\nto the given block and then assigns the block's value in that position. Returns `self`.\n\nNegative values of *start* count from the end of the array.\n\nRaises `IndexError` if *start* is outside the array range.\n\nHas no effect if *count* is zero or negative.\n\n```\na = [1, 2, 3, 4, 5, 6]\na.fill(2, 2) { |i| i * i } # => [1, 2, 4, 9, 5, 6]\n```","summary":"<p>Yields each index of <code>self</code>, starting at <em>start</em> and just <em>count</em> times, to the given block and then assigns the block's value in that position.</p>\n<p><span class=\"flag red\">DEPRECATED</span>  Use <code><a href=\"Indexable/Mutable.html#fill%28value%3AT%2Cstart%3AInt%2Ccount%3AInt%29%3Aself-instance-method\">Indexable::Mutable#fill(start, count, &amp;)</a></code> instead</p>","abstract":false,"args":[{"name":"","external_name":"","restriction":""},{"name":"start","external_name":"from","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"}],"args_string":"(*, from start : Int, count : Int, & : Int32 -> T) : self","args_html":"(*, from start : <a href=\"Int.html\">Int</a>, count : <a href=\"Int.html\">Int</a>, & : <a href=\"Int32.html\">Int32</a> -> T) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":918,"url":null},"def":{"name":"fill","args":[{"name":"","external_name":"","restriction":""},{"name":"start","external_name":"from","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"}],"splat_index":0,"yields":1,"block_arity":1,"block_arg":{"name":"","external_name":"","restriction":"(Int32 -> T)"},"return_type":"self","visibility":"Public","body":"fill(start, count) do |i| yield i end"},"external_var":false},{"html_id":"fill(value:T,start:Int,count:Int):self-instance-method","name":"fill","doc":"Replaces *count* or less (if there aren't enough) elements starting at the\ngiven *start* index with *value*. Returns `self`.\n\nNegative values of *start* count from the end of the container.\n\nRaises `IndexError` if the *start* index is out of range.\n\nRaises `ArgumentError` if *count* is negative.\n\n```\narray = [1, 2, 3, 4, 5]\narray.fill(9, 2, 2) # => [1, 2, 9, 9, 5]\narray               # => [1, 2, 9, 9, 5]\n```","summary":"<p>Replaces <em>count</em> or less (if there aren't enough) elements starting at the given <em>start</em> index with <em>value</em>.</p>","abstract":false,"args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"start","external_name":"start","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"}],"args_string":"(value : T, start : Int, count : Int) : self","args_html":"(value : T, start : <a href=\"Int.html\">Int</a>, count : <a href=\"Int.html\">Int</a>) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":962,"url":null},"def":{"name":"fill","args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"start","external_name":"start","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"}],"return_type":"self","visibility":"Public","body":"to_unsafe_slice.fill(value, start, count)\nself\n"},"external_var":false},{"html_id":"fill(value:T,start:Int):self-instance-method","name":"fill","doc":"Replaces every element in `self`, starting at *start*, with the given *value*. Returns `self`.\n\nNegative values of *start* count from the end of the array.\n\n```\na = [1, 2, 3, 4, 5]\na.fill(9, 2) # => [1, 2, 9, 9, 9]\n```","summary":"<p>Replaces every element in <code>self</code>, starting at <em>start</em>, with the given <em>value</em>.</p>\n<p><span class=\"flag red\">DEPRECATED</span>  Use <code><a href=\"Array.html#fill%28%2A%2Cfromstart%3AInt%2C%26%3AInt32-%3ET%29%3Aself-instance-method\">#fill(value, start..)</a></code> instead</p>","abstract":false,"args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"start","external_name":"start","restriction":"Int"}],"args_string":"(value : T, start : Int) : self","args_html":"(value : T, start : <a href=\"Int.html\">Int</a>) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":938,"url":null},"def":{"name":"fill","args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"start","external_name":"start","restriction":"Int"}],"return_type":"self","visibility":"Public","body":"fill(value, start..)"},"external_var":false},{"html_id":"fill(value:T,range:Range):self-instance-method","name":"fill","doc":"Replaces every element in *range* with *value*. Returns `self`.\n\nNegative values of *from* count from the end of the array.\n\n```\na = [1, 2, 3, 4, 5]\na.fill(9, 2..3) # => [1, 2, 9, 9, 5]\n```","summary":"<p>Replaces every element in <em>range</em> with <em>value</em>.</p>","abstract":false,"args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"range","external_name":"range","restriction":"Range"}],"args_string":"(value : T, range : Range) : self","args_html":"(value : T, range : <a href=\"Range.html\">Range</a>) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":981,"url":null},"def":{"name":"fill","args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"range","external_name":"range","restriction":"Range"}],"return_type":"self","visibility":"Public","body":"to_unsafe_slice.fill(value, range)\nself\n"},"external_var":false},{"html_id":"fill(value:T):self-instance-method","name":"fill","doc":"Replaces every element in `self` with the given *value*. Returns `self`.\n\n```\narray = [1, 2, 3, 4]\narray.fill(2) # => [2, 2, 2, 2]\narray         # => [2, 2, 2, 2]\n```","summary":"<p>Replaces every element in <code>self</code> with the given <em>value</em>.</p>","abstract":false,"args":[{"name":"value","external_name":"value","restriction":"T"}],"args_string":"(value : T) : self","args_html":"(value : T) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":923,"url":null},"def":{"name":"fill","args":[{"name":"value","external_name":"value","restriction":"T"}],"return_type":"self","visibility":"Public","body":"to_unsafe_slice.fill(value)\nself\n"},"external_var":false},{"html_id":"fill(value:T,*,fromstart:Int):self-instance-method","name":"fill","doc":"Replaces every element in `self`, starting at *start*, with the given *value*. Returns `self`.\n\nNegative values of *start* count from the end of the array.\n\n```\na = [1, 2, 3, 4, 5]\na.fill(9, 2) # => [1, 2, 9, 9, 9]\n```","summary":"<p>Replaces every element in <code>self</code>, starting at <em>start</em>, with the given <em>value</em>.</p>\n<p><span class=\"flag red\">DEPRECATED</span>  Use <code><a href=\"Array.html#fill%28%2A%2Cfromstart%3AInt%2C%26%3AInt32-%3ET%29%3Aself-instance-method\">#fill(value, start..)</a></code> instead</p>","abstract":false,"args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"","external_name":"","restriction":""},{"name":"start","external_name":"from","restriction":"Int"}],"args_string":"(value : T, *, from start : Int) : self","args_html":"(value : T, *, from start : <a href=\"Int.html\">Int</a>) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":944,"url":null},"def":{"name":"fill","args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"","external_name":"","restriction":""},{"name":"start","external_name":"from","restriction":"Int"}],"splat_index":1,"return_type":"self","visibility":"Public","body":"fill(value, start..)"},"external_var":false},{"html_id":"fill(value:T,*,fromstart:Int,count:Int):self-instance-method","name":"fill","doc":"Replaces *count* or less (if there aren't enough) elements starting at the\ngiven *start* index with *value*. Returns `self`.\n\nNegative values of *start* count from the end of the container.\n\nRaises `IndexError` if the *start* index is out of range.\n\nRaises `ArgumentError` if *count* is negative.\n\n```\narray = [1, 2, 3, 4, 5]\narray.fill(9, 2, 2) # => [1, 2, 9, 9, 5]\narray               # => [1, 2, 9, 9, 5]\n```","summary":"<p>Replaces <em>count</em> or less (if there aren't enough) elements starting at the given <em>start</em> index with <em>value</em>.</p>\n<p><span class=\"flag red\">DEPRECATED</span>  Use <code><a href=\"Array.html#fill%28%2A%2Cfromstart%3AInt%2Ccount%3AInt%2C%26%3AInt32-%3ET%29%3Aself-instance-method\">#fill(value, start, count)</a></code> instead</p>","abstract":false,"args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"","external_name":"","restriction":""},{"name":"start","external_name":"from","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"}],"args_string":"(value : T, *, from start : Int, count : Int) : self","args_html":"(value : T, *, from start : <a href=\"Int.html\">Int</a>, count : <a href=\"Int.html\">Int</a>) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":969,"url":null},"def":{"name":"fill","args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"","external_name":"","restriction":""},{"name":"start","external_name":"from","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"}],"splat_index":1,"return_type":"self","visibility":"Public","body":"fill(value, start, count)"},"external_var":false},{"html_id":"first(n:Int):Array(T)-instance-method","name":"first","doc":"Returns the first *n* elements of the array.\n\n```\n[1, 2, 3].first(2) # => [1, 2]\n[1, 2, 3].first(4) # => [1, 2, 3]\n```","summary":"<p>Returns the first <em>n</em> elements of the array.</p>","abstract":false,"args":[{"name":"n","external_name":"n","restriction":"Int"}],"args_string":"(n : Int) : Array(T)","args_html":"(n : <a href=\"Int.html\">Int</a>) : <a href=\"Array.html\">Array</a>(T)","location":{"filename":"src/array.cr","line_number":992,"url":null},"def":{"name":"first","args":[{"name":"n","external_name":"n","restriction":"Int"}],"return_type":"Array(T)","visibility":"Public","body":"self[0, n]"},"external_var":false},{"html_id":"flatten-instance-method","name":"flatten","doc":"Returns a new `Array` that is a one-dimensional flattening of `self` (recursively).\n\nThat is, for every element that is an array or an iterator, extract its elements into the new array.\n\n```\ns = [1, 2, 3]          # => [1, 2, 3]\nt = [4, 5, 6, [7, 8]]  # => [4, 5, 6, [7, 8]]\nu = [9, [10, 11].each] # => [9, #<Indexable::ItemIterator>]\na = [s, t, u, 12, 13]  # => [[1, 2, 3], [4, 5, 6, [7, 8]], 9, #<Indexable::ItemIterator>, 12, 13]\na.flatten              # => [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13]\n```","summary":"<p>Returns a new <code><a href=\"Array.html\">Array</a></code> that is a one-dimensional flattening of <code>self</code> (recursively).</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1251,"url":null},"def":{"name":"flatten","visibility":"Public","body":"FlattenHelper(typeof(FlattenHelper.element_type(self))).flatten(self)"},"external_var":false},{"html_id":"index(object,offset:Int=0)-instance-method","name":"index","doc":"Returns the index of the first appearance of *object* in `self`\nstarting from the given *offset*, or `nil` if *object* is not in `self`.\n\n```\n[1, 2, 3, 1, 2, 3].index(2, offset: 2) # => 4\n```","summary":"<p>Returns the index of the first appearance of <em>object</em> in <code>self</code> starting from the given <em>offset</em>, or <code>nil</code> if <em>object</em> is not in <code>self</code>.</p>","abstract":false,"args":[{"name":"object","external_name":"object","restriction":""},{"name":"offset","default_value":"0","external_name":"offset","restriction":"Int"}],"args_string":"(object, offset : Int = 0)","args_html":"(object, offset : <a href=\"Int.html\">Int</a> = <span class=\"n\">0</span>)","location":{"filename":"src/array.cr","line_number":2226,"url":null},"def":{"name":"index","args":[{"name":"object","external_name":"object","restriction":""},{"name":"offset","default_value":"0","external_name":"offset","restriction":"Int"}],"visibility":"Public","body":"if T.is_a?(UInt8.class) &&\n(object.is_a?(UInt8) || (object.is_a?(Int) && (0 <= object && object < 256)))\n  return to_unsafe_slice.fast_index(object, offset)\nend\n\nsuper(object, offset)\n"},"external_var":false},{"html_id":"insert(index:Int,object:T):self-instance-method","name":"insert","doc":"Insert *object* before the element at *index* and shifting successive elements, if any.\nReturns `self`.\n\nNegative values of *index* count from the end of the array.\n\n```\na = [\"a\", \"b\", \"c\"]\na.insert(0, \"x\")  # => [\"x\", \"a\", \"b\", \"c\"]\na.insert(2, \"y\")  # => [\"x\", \"a\", \"y\", \"b\", \"c\"]\na.insert(-1, \"z\") # => [\"x\", \"a\", \"y\", \"b\", \"c\", \"z\"]\n```","summary":"<p>Insert <em>object</em> before the element at <em>index</em> and shifting successive elements, if any.</p>","abstract":false,"args":[{"name":"index","external_name":"index","restriction":"Int"},{"name":"object","external_name":"object","restriction":"T"}],"args_string":"(index : Int, object : T) : self","args_html":"(index : <a href=\"Int.html\">Int</a>, object : T) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":1007,"url":null},"def":{"name":"insert","args":[{"name":"index","external_name":"index","restriction":"Int"},{"name":"object","external_name":"object","restriction":"T"}],"return_type":"self","visibility":"Public","body":"if index == 0\n  return unshift(object)\nend\n\nif index < 0\n  index = index + (size + 1)\nend\n\nif 0 <= index && index <= size\nelse\n  raise(IndexError.new)\nend\n\ncheck_needs_resize\n((@buffer + index) + 1).move_from(@buffer + index, size - index)\n@buffer[index] = object\n\n@size = @size + 1\n\nself\n"},"external_var":false},{"html_id":"insert_all(index:Int,other:Indexable):self-instance-method","name":"insert_all","doc":"Inserts all of the elements from *other* before the element at *index*.\n\nThis method shifts the element currently at *index* (if any) and any\nsubsequent elements to the right, increasing their indices. If the value\nof *index* is negative, counting starts from the end of the array.\nFor example, `-1` indicates insertion after the last element, `-2` before\nthe last element.\n\nRaises `IndexError` if the *index* is out of bounds.\n\n```\nfruits = [\"Apple\"]\nnewFruits = [\"Dragonfruit\", \"Elderberry\"]\n\nfruits.insert_all(1, newFruits)             # => [\"Apple\", \"Dragonfruit\", \"Elderberry\"]\nfruits.insert_all(-3, [\"Banana\", \"Cherry\"]) # => [\"Apple\", \"Banana\", \"Cherry\", \"Dragonfruit\", \"Elderberry\"]\n\nfruits.insert_all(6, [\"invalid\"])  # raises IndexError\nfruits.insert_all(-7, [\"indices\"]) # raises IndexError\n```","summary":"<p>Inserts all of the elements from <em>other</em> before the element at <em>index</em>.</p>","abstract":false,"args":[{"name":"index","external_name":"index","restriction":"Int"},{"name":"other","external_name":"other","restriction":"Indexable"}],"args_string":"(index : Int, other : Indexable) : self","args_html":"(index : <a href=\"Int.html\">Int</a>, other : <a href=\"Indexable.html\">Indexable</a>) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":1049,"url":null},"def":{"name":"insert_all","args":[{"name":"index","external_name":"index","restriction":"Int"},{"name":"other","external_name":"other","restriction":"Indexable"}],"return_type":"self","visibility":"Public","body":"other_size = other.size\n\nif other_size == 0\n  return self\nend\n\nif index < 0\n  index = index + (size + 1)\nend\n\nif 0 <= index && index <= size\nelse\n  raise(IndexError.new)\nend\n\nresize_if_cant_insert(other_size)\n(@buffer + index).move_to((@buffer + index) + other_size, @size - index)\n\ninsert_elements_at(other, index)\n\n@size = @size + other_size\n\nself\n"},"external_var":false},{"html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Appends a String representation of this object\nwhich includes its class name, its object address\nand the values of all instance variables.\n\n```\nclass Person\n  def initialize(@name : String, @age : Int32)\n  end\nend\n\nPerson.new(\"John\", 32).inspect # => #<Person:0x10fd31f20 @name=\"John\", @age=32>\n```","summary":"<p>Appends a String representation of this object which includes its class name, its object address and the values of all instance variables.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/array.cr","line_number":1091,"url":null},"def":{"name":"inspect","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"to_s(io)"},"external_var":false},{"html_id":"last(n:Int):Array(T)-instance-method","name":"last","doc":"Returns the last *n* elements of the array.\n\n```\n[1, 2, 3].last(2) # => [2, 3]\n[1, 2, 3].last(4) # => [1, 2, 3]\n```","summary":"<p>Returns the last <em>n</em> elements of the array.</p>","abstract":false,"args":[{"name":"n","external_name":"n","restriction":"Int"}],"args_string":"(n : Int) : Array(T)","args_html":"(n : <a href=\"Int.html\">Int</a>) : <a href=\"Array.html\">Array</a>(T)","location":{"filename":"src/array.cr","line_number":1101,"url":null},"def":{"name":"last","args":[{"name":"n","external_name":"n","restriction":"Int"}],"return_type":"Array(T)","visibility":"Public","body":"if n < @size\n  self[@size - n, n]\nelse\n  dup\nend"},"external_var":false},{"html_id":"map(&:T->U):Array(U)forallU-instance-method","name":"map","doc":"Optimized version of `Enumerable#map`.","summary":"<p>Optimized version of <code><a href=\"Enumerable.html#map%28%26%3AT-%3EU%29%3AArray%28U%29forallU-instance-method\">Enumerable#map</a></code>.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1115,"url":null},"def":{"name":"map","yields":1,"block_arity":1,"block_arg":{"name":"","external_name":"","restriction":"(T -> U)"},"return_type":"Array(U)","visibility":"Public","body":"Array(U).new(size) do |i| yield @buffer[i] end"},"external_var":false},{"html_id":"map_with_index(offset=0,&:T,Int32->_)-instance-method","name":"map_with_index","doc":"Optimized version of `Enumerable#map_with_index`.\n\nAccepts an optional *offset* parameter, which tells it to start counting\nfrom there.\n\n```\ngems = [\"crystal\", \"pearl\", \"diamond\"]\nresults = gems.map_with_index { |gem, i| \"#{i}: #{gem}\" }\nresults # => [\"0: crystal\", \"1: pearl\", \"2: diamond\"]\n```","summary":"<p>Optimized version of <code><a href=\"Enumerable.html#map_with_index%28offset%3D0%2C%26%3AT%2CInt32-%3EU%29%3AArray%28U%29forallU-instance-method\">Enumerable#map_with_index</a></code>.</p>","abstract":false,"args":[{"name":"offset","default_value":"0","external_name":"offset","restriction":""}],"args_string":"(offset = 0, & : T, Int32 -> _)","args_html":"(offset = <span class=\"n\">0</span>, & : T, <a href=\"Int32.html\">Int32</a> -> _)","location":{"filename":"src/array.cr","line_number":1218,"url":null},"def":{"name":"map_with_index","args":[{"name":"offset","default_value":"0","external_name":"offset","restriction":""}],"yields":2,"block_arity":2,"block_arg":{"name":"","external_name":"","restriction":"(T, Int32 -> _)"},"visibility":"Public","body":"Array.new(size) do |i| yield @buffer[i], offset + i end"},"external_var":false},{"html_id":"pop(n:Int):Array(T)-instance-method","name":"pop","doc":"Removes the last *n* values from `self`, at index *size - 1*.\nThis method returns an array of the removed values, with the original order preserved.\n\nIf *n* is greater than the size of `self`, all values will be removed from `self`\nwithout raising an error.\n\n```\na = [\"a\", \"b\", \"c\"]\na.pop(2) # => [\"b\", \"c\"]\na        # => [\"a\"]\n\na = [\"a\", \"b\", \"c\"]\na.pop(4) # => [\"a\", \"b\", \"c\"]\na        # => []\n```\n\nSee also: `#truncate`.","summary":"<p>Removes the last <em>n</em> values from <code>self</code>, at index <em>size - 1</em>.</p>","abstract":false,"args":[{"name":"n","external_name":"n","restriction":"Int"}],"args_string":"(n : Int) : Array(T)","args_html":"(n : <a href=\"Int.html\">Int</a>) : <a href=\"Array.html\">Array</a>(T)","location":{"filename":"src/array.cr","line_number":1363,"url":null},"def":{"name":"pop","args":[{"name":"n","external_name":"n","restriction":"Int"}],"return_type":"Array(T)","visibility":"Public","body":"if n < 0\n  raise(ArgumentError.new(\"Can't pop negative count\"))\nend\n\nn = Math.min(n, @size)\nary = Array(T).new(n) do |i| @buffer[(@size - n) + i] end\n\n@size = @size - n\n(@buffer + @size).clear(n)\n\nary\n"},"external_var":false},{"html_id":"pop:T-instance-method","name":"pop","doc":"Removes the last value from `self`, at index *size - 1*.\nThis method returns the removed value.\nRaises `IndexError` if array is of 0 size.\n\n```\na = [\"a\", \"b\", \"c\"]\na.pop # => \"c\"\na     # => [\"a\", \"b\"]\n```\n\nSee also: `#truncate`.","summary":"<p>Removes the last value from <code>self</code>, at index <em>size - 1</em>.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1314,"url":null},"def":{"name":"pop","return_type":"T","visibility":"Public","body":"pop do raise(IndexError.new) end"},"external_var":false},{"html_id":"pop(&)-instance-method","name":"pop","doc":"Removes the last value from `self`.\nIf the array is empty, the given block is called.\n\n```\na = [1]\na.pop { \"Testing\" } # => 1\na.pop { \"Testing\" } # => \"Testing\"\n```\n\nSee also: `#truncate`.","summary":"<p>Removes the last value from <code>self</code>.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1328,"url":null},"def":{"name":"pop","yields":0,"block_arity":0,"visibility":"Public","body":"if @size == 0\n  yield\nelse\n  @size = @size - 1\n  value = @buffer[@size]\n  (@buffer + @size).clear\n\n\n\n  if empty? && (@offset_to_buffer != 0)\n    reset_buffer_to_root_buffer\n  end\n\n  value\nend"},"external_var":false},{"html_id":"pop?:T|Nil-instance-method","name":"pop?","doc":"Like `pop`, but returns `nil` if `self` is empty.\n\nSee also: `#truncate`.","summary":"<p>Like <code><a href=\"Array.html#pop%3AT-instance-method\">#pop</a></code>, but returns <code>nil</code> if <code>self</code> is empty.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1380,"url":null},"def":{"name":"pop?","return_type":"T | ::Nil","visibility":"Public","body":"pop do nil end"},"external_var":false},{"html_id":"pretty_print(pp):Nil-instance-method","name":"pretty_print","abstract":false,"args":[{"name":"pp","external_name":"pp","restriction":""}],"args_string":"(pp) : Nil","args_html":"(pp) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/array.cr","line_number":1800,"url":null},"def":{"name":"pretty_print","args":[{"name":"pp","external_name":"pp","restriction":""}],"return_type":"Nil","visibility":"Public","body":"executed = exec_recursive(:pretty_print) do\n  pp.list(\"[\", self, \"]\")\nend\nif executed\nelse\n  pp.text(\"[...]\")\nend\n"},"external_var":false},{"html_id":"product(ary:Array(U))forallU-instance-method","name":"product","doc":"Returns an `Array` of all ordered combinations of elements taken from each\nof `self` and *ary* as `Tuple`s.\nTraversal of elements starts from *ary*.","summary":"<p>Returns an <code><a href=\"Array.html\">Array</a></code> of all ordered combinations of elements taken from each of <code>self</code> and <em>ary</em> as <code><a href=\"Tuple.html\">Tuple</a></code>s.</p>\n<p><span class=\"flag red\">DEPRECATED</span>  Use <code><a href=\"Indexable.html#cartesian_product%28%2Aothers%3AIndexable%29-instance-method\">Indexable#cartesian_product(*others : Indexable)</a></code> instead</p>","abstract":false,"args":[{"name":"ary","external_name":"ary","restriction":"Array(U)"}],"args_string":"(ary : Array(U)) forall U","args_html":"(ary : <a href=\"Array.html\">Array</a>(U)) forall U","location":{"filename":"src/array.cr","line_number":1388,"url":null},"def":{"name":"product","args":[{"name":"ary","external_name":"ary","restriction":"Array(U)"}],"visibility":"Public","body":"cartesian_product(ary)"},"external_var":false},{"html_id":"product(enumerable:Enumerable,&)-instance-method","name":"product","doc":"Yields each ordered combination of the elements taken from each of `self`\nand *enumerable* as a `Tuple`.\nTraversal of elements starts from *enumerable*.","summary":"<p>Yields each ordered combination of the elements taken from each of <code>self</code> and <em>enumerable</em> as a <code><a href=\"Tuple.html\">Tuple</a></code>.</p>\n<p><span class=\"flag red\">DEPRECATED</span>  Use <code><a href=\"Indexable.html#each_cartesian%28indexables%3AIndexable%28Indexable%29%2Creuse%3Dfalse%2C%26%29-class-method\">Indexable#each_cartesian(*others : Indexable, &amp;block)</a></code> instead</p>","abstract":false,"args":[{"name":"enumerable","external_name":"enumerable","restriction":"Enumerable"}],"args_string":"(enumerable : Enumerable, &)","args_html":"(enumerable : <a href=\"Enumerable.html\">Enumerable</a>, &)","location":{"filename":"src/array.cr","line_number":1396,"url":null},"def":{"name":"product","args":[{"name":"enumerable","external_name":"enumerable","restriction":"Enumerable"}],"yields":2,"block_arity":2,"visibility":"Public","body":"self.each do |a| enumerable.each do |b| yield a, b end end"},"external_var":false},{"html_id":"push(value:T):self-instance-method","name":"push","doc":"Append. Pushes one value to the end of `self`, given that the type of the value is *T*\n(which might be a single type or a union of types).\nThis method returns `self`, so several calls can be chained.\nSee `pop` for the opposite effect.\n\n```\na = [\"a\", \"b\"]\na.push(\"c\") # => [\"a\", \"b\", \"c\"]\na.push(1)   # Errors, because the array only accepts String.\n\na = [\"a\", \"b\"] of (Int32 | String)\na.push(\"c\") # => [\"a\", \"b\", \"c\"]\na.push(1)   # => [\"a\", \"b\", \"c\", 1]\n```","summary":"<p>Append.</p>","abstract":false,"args":[{"name":"value","external_name":"value","restriction":"T"}],"args_string":"(value : T) : self","args_html":"(value : T) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":1414,"url":null},"def":{"name":"push","args":[{"name":"value","external_name":"value","restriction":"T"}],"return_type":"self","visibility":"Public","body":"check_needs_resize\n@buffer[@size] = value\n@size = @size + 1\nself\n"},"external_var":false},{"html_id":"push(*values:T):self-instance-method","name":"push","doc":"Append multiple values. The same as `push`, but takes an arbitrary number\nof values to push into `self`. Returns `self`.\n\n```\na = [\"a\"]\na.push(\"b\", \"c\") # => [\"a\", \"b\", \"c\"]\n```","summary":"<p>Append multiple values.</p>","abstract":false,"args":[{"name":"values","external_name":"values","restriction":"T"}],"args_string":"(*values : T) : self","args_html":"(*values : T) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":1428,"url":null},"def":{"name":"push","args":[{"name":"values","external_name":"values","restriction":"T"}],"splat_index":0,"return_type":"self","visibility":"Public","body":"resize_if_cant_insert(values.size)\n\nvalues.each_with_index do |value, i|\n  @buffer[@size + i] = value\nend\n@size = @size + values.size\nself\n"},"external_var":false},{"html_id":"reject!(&:T->):self-instance-method","name":"reject!","doc":"Modifies `self`, deleting the elements in the collection for which the\npassed block is truthy. Returns `self`.\n\n```\nary = [1, 6, 2, 4, 8]\nary.reject! { |x| x > 3 }\nary # => [1, 2]\n```\n\nSee also: `Array#reject`.","summary":"<p>Modifies <code>self</code>, deleting the elements in the collection for which the passed block is truthy.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1157,"url":null},"def":{"name":"reject!","yields":1,"block_arity":1,"block_arg":{"name":"","external_name":"","restriction":"(T ->)"},"return_type":"self","visibility":"Public","body":"internal_delete do |e| yield e end\nself\n"},"external_var":false},{"html_id":"reject!(pattern):self-instance-method","name":"reject!","doc":"Modifies `self`, deleting the elements in the collection for which\n`pattern === element`.\n\n```\nary = [1, 6, 2, 4, 8]\nary.reject!(3..7)\nary # => [1, 2, 8]\n```\n\nSee also: `Array#select!`.","summary":"<p>Modifies <code>self</code>, deleting the elements in the collection for which <code>pattern === element</code>.</p>","abstract":false,"args":[{"name":"pattern","external_name":"pattern","restriction":""}],"args_string":"(pattern) : self","args_html":"(pattern) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":1172,"url":null},"def":{"name":"reject!","args":[{"name":"pattern","external_name":"pattern","restriction":""}],"return_type":"self","visibility":"Public","body":"reject! do |elem| pattern === elem end\nself\n"},"external_var":false},{"html_id":"remaining_capacity:Int32-instance-method","name":"remaining_capacity","abstract":false,"location":{"filename":"src/array.cr","line_number":2115,"url":null},"def":{"name":"remaining_capacity","return_type":"Int32","visibility":"Public","body":"@capacity - @offset_to_buffer"},"external_var":false},{"html_id":"repeated_permutations(size:Int=self.size):Array(Array(T))-instance-method","name":"repeated_permutations","abstract":false,"args":[{"name":"size","default_value":"self.size","external_name":"size","restriction":"Int"}],"args_string":"(size : Int = self.size) : Array(Array(T))","args_html":"(size : <a href=\"Int.html\">Int</a> = <span class=\"k\">self</span>.size) : <a href=\"Array.html\">Array</a>(<a href=\"Array.html\">Array</a>(T))","location":{"filename":"src/array.cr","line_number":1283,"url":null},"def":{"name":"repeated_permutations","args":[{"name":"size","default_value":"self.size","external_name":"size","restriction":"Int"}],"return_type":"Array(Array(T))","visibility":"Public","body":"ary = [] of Array(T)\neach_repeated_permutation(size) do |a|\n  ary << a\nend\nary\n"},"external_var":false},{"html_id":"replace(other:Array):self-instance-method","name":"replace","doc":"Replaces the contents of `self` with the contents of *other*.\nThis resizes the Array to a greater capacity but does not free memory if the given array is smaller.\n\n```\na1 = [1, 2, 3]\na1.replace([1])\na1                    # => [1]\na1.remaining_capacity # => 3\na2 = [1]\na2.replace([1, 2, 3])\na2 # => [1, 2, 3]\n```","summary":"<p>Replaces the contents of <code>self</code> with the contents of <em>other</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Array"}],"args_string":"(other : Array) : self","args_html":"(other : <a href=\"Array.html\">Array</a>) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":1450,"url":null},"def":{"name":"replace","args":[{"name":"other","external_name":"other","restriction":"Array"}],"return_type":"self","visibility":"Public","body":"if other.size > @capacity\n  reset_buffer_to_root_buffer\n  resize_to_capacity(calculate_new_capacity(other.size))\nelsif other.size > remaining_capacity\n  shift_buffer_by(remaining_capacity - other.size)\nelsif other.size < @size\n  (@buffer + other.size).clear(@size - other.size)\nend\n\n@buffer.copy_from(other.to_unsafe, other.size)\n@size = other.size\nself\n"},"external_var":false},{"html_id":"reverse:Array(T)-instance-method","name":"reverse","doc":"Returns an array with all the elements in the collection reversed.\n\n```\na = [1, 2, 3]\na.reverse # => [3, 2, 1]\n```","summary":"<p>Returns an array with all the elements in the collection reversed.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1471,"url":null},"def":{"name":"reverse","return_type":"Array(T)","visibility":"Public","body":"Array(T).new(size) do |i| @buffer[(size - i) - 1] end"},"external_var":false},{"html_id":"rotate(n=1):Array(T)-instance-method","name":"rotate","doc":"Returns an array with all the elements shifted to the left `n` times.\n\n```\na = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]\na.rotate    # => [1, 2, 3, 4, 5, 6, 7, 8, 9, 0]\na.rotate(1) # => [1, 2, 3, 4, 5, 6, 7, 8, 9, 0]\na.rotate(3) # => [3, 4, 5, 6, 7, 8, 9, 0, 1, 2]\na           # => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]\n```","summary":"<p>Returns an array with all the elements shifted to the left <code>n</code> times.</p>","abstract":false,"args":[{"name":"n","default_value":"1","external_name":"n","restriction":""}],"args_string":"(n = 1) : Array(T)","args_html":"(n = <span class=\"n\">1</span>) : <a href=\"Array.html\">Array</a>(T)","location":{"filename":"src/array.cr","line_number":1490,"url":null},"def":{"name":"rotate","args":[{"name":"n","default_value":"1","external_name":"n","restriction":""}],"return_type":"Array(T)","visibility":"Public","body":"if size == 0\n  return self\nend\nn = n % size\nif n == 0\n  return self\nend\nres = Array(T).new(size)\nres.to_unsafe.copy_from(@buffer + n, size - n)\n((res.to_unsafe + size) - n).copy_from(@buffer, n)\nres.size = size\nres\n"},"external_var":false},{"html_id":"rotate!(n:Int=1):self-instance-method","name":"rotate!","doc":"Shifts all elements of `self` to the left *n* times. Returns `self`.\n\n```\na1 = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]\na2 = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]\na3 = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]\n\na1.rotate!\na2.rotate!(1)\na3.rotate!(3)\n\na1 # => [1, 2, 3, 4, 5, 6, 7, 8, 9, 0]\na2 # => [1, 2, 3, 4, 5, 6, 7, 8, 9, 0]\na3 # => [3, 4, 5, 6, 7, 8, 9, 0, 1, 2]\n```","summary":"<p>Shifts all elements of <code>self</code> to the left <em>n</em> times.</p>","abstract":false,"args":[{"name":"n","default_value":"1","external_name":"n","restriction":"Int"}],"args_string":"(n : Int = 1) : self","args_html":"(n : <a href=\"Int.html\">Int</a> = <span class=\"n\">1</span>) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":1476,"url":null},"def":{"name":"rotate!","args":[{"name":"n","default_value":"1","external_name":"n","restriction":"Int"}],"return_type":"self","visibility":"Public","body":"to_unsafe_slice.rotate!(n)\nself\n"},"external_var":false},{"html_id":"select!(&:T->):self-instance-method","name":"select!","doc":"Modifies `self`, keeping only the elements in the collection for which the\npassed block is truthy. Returns `self`.\n\n```\nary = [1, 6, 2, 4, 8]\nary.select! { |x| x > 3 }\nary # => [6, 4, 8]\n```\n\nSee also: `Array#select`.","summary":"<p>Modifies <code>self</code>, keeping only the elements in the collection for which the passed block is truthy.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1129,"url":null},"def":{"name":"select!","yields":1,"block_arity":1,"block_arg":{"name":"","external_name":"","restriction":"(T ->)"},"return_type":"self","visibility":"Public","body":"reject! do |elem| !(yield(elem)) end"},"external_var":false},{"html_id":"select!(pattern):self-instance-method","name":"select!","doc":"Modifies `self`, keeping only the elements in the collection for which\n`pattern === element`.\n\n```\nary = [1, 6, 2, 4, 8]\nary.select!(3..7)\nary # => [6, 4]\n```\n\nSee also: `Array#reject!`.","summary":"<p>Modifies <code>self</code>, keeping only the elements in the collection for which <code>pattern === element</code>.</p>","abstract":false,"args":[{"name":"pattern","external_name":"pattern","restriction":""}],"args_string":"(pattern) : self","args_html":"(pattern) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":1143,"url":null},"def":{"name":"select!","args":[{"name":"pattern","external_name":"pattern","restriction":""}],"return_type":"self","visibility":"Public","body":"self.select! do |elem| pattern === elem end"},"external_var":false},{"html_id":"shift(n:Int):Array(T)-instance-method","name":"shift","doc":"Removes the first *n* values of `self`, starting at index 0.\nThis method returns an array of the removed values.\n\nIf *n* is greater than the size of `self`, all values will be removed from `self`\nwithout raising an error.\n\n```\na = [\"a\", \"b\", \"c\"]\na.shift # => \"a\"\na       # => [\"b\", \"c\"]\n\na = [\"a\", \"b\", \"c\"]\na.shift(4) # => [\"a\", \"b\", \"c\"]\na          # => []\n```\n\nSee also: `#truncate`.","summary":"<p>Removes the first <em>n</em> values of <code>self</code>, starting at index 0.</p>","abstract":false,"args":[{"name":"n","external_name":"n","restriction":"Int"}],"args_string":"(n : Int) : Array(T)","args_html":"(n : <a href=\"Int.html\">Int</a>) : <a href=\"Array.html\">Array</a>(T)","location":{"filename":"src/array.cr","line_number":1568,"url":null},"def":{"name":"shift","args":[{"name":"n","external_name":"n","restriction":"Int"}],"return_type":"Array(T)","visibility":"Public","body":"if n < 0\n  raise(ArgumentError.new(\"Can't shift negative count\"))\nend\n\nn = Math.min(n, @size)\nary = Array(T).new(n) do |i| @buffer[i] end\n\n@size = @size - n\n\n@buffer.clear(n)\n\nif empty?\n  reset_buffer_to_root_buffer\nelse\n  shift_buffer_by(n)\nend\n\nary\n"},"external_var":false},{"html_id":"shift:T-instance-method","name":"shift","doc":"Removes the first value of `self`, at index 0. This method returns the removed value.\nIf the array is empty, it raises `IndexError`.\n\n```\na = [\"a\", \"b\", \"c\"]\na.shift # => \"a\"\na       # => [\"b\", \"c\"]\n```\n\nSee also: `#truncate`.","summary":"<p>Removes the first value of <code>self</code>, at index 0.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1511,"url":null},"def":{"name":"shift","return_type":"T","visibility":"Public","body":"shift do raise(IndexError.new) end"},"external_var":false},{"html_id":"shift(&)-instance-method","name":"shift","doc":"Removes the first value of `self`, at index 0, or otherwise invokes the given block.\nThis method returns the removed value.\nIf the array is empty, it invokes the given block and returns its value.\n\n```\na = [\"a\"]\na.shift { \"empty!\" } # => \"a\"\na                    # => []\na.shift { \"empty!\" } # => \"empty!\"\na                    # => []\n```\n\nSee also: `#truncate`.","summary":"<p>Removes the first value of <code>self</code>, at index 0, or otherwise invokes the given block.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1528,"url":null},"def":{"name":"shift","yields":0,"block_arity":0,"visibility":"Public","body":"if @size == 0\n  yield\nelse\n  shift_when_not_empty\nend"},"external_var":false},{"html_id":"shift?:T|Nil-instance-method","name":"shift?","doc":"Removes the first value of `self`, at index 0. This method returns the removed value.\nIf the array is empty, it returns `nil` without raising any error.\n\n```\na = [\"a\", \"b\"]\na.shift? # => \"a\"\na        # => [\"b\"]\na.shift? # => \"b\"\na        # => []\na.shift? # => nil\na        # => []\n```\n\nSee also: `#truncate`.","summary":"<p>Removes the first value of <code>self</code>, at index 0.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1603,"url":null},"def":{"name":"shift?","return_type":"T | ::Nil","visibility":"Public","body":"shift do nil end"},"external_var":false},{"html_id":"shuffle(random:Random|Nil=nil):Array(T)-instance-method","name":"shuffle","doc":"Returns a new instance with all elements in the collection randomized.\n\nSee `Indexable::Mutable#shuffle!` for details.","summary":"<p>Returns a new instance with all elements in the collection randomized.</p>","abstract":false,"args":[{"name":"random","default_value":"nil","external_name":"random","restriction":"Random | ::Nil"}],"args_string":"(random : Random | Nil = nil) : Array(T)","args_html":"(random : <a href=\"Random.html\">Random</a> | <a href=\"Nil.html\">Nil</a> = <span class=\"n\">nil</span>) : <a href=\"Array.html\">Array</a>(T)","location":{"filename":"src/array.cr","line_number":1610,"url":null},"def":{"name":"shuffle","args":[{"name":"random","default_value":"nil","external_name":"random","restriction":"Random | ::Nil"}],"return_type":"Array(T)","visibility":"Public","body":"dup.shuffle!(random)"},"external_var":false},{"html_id":"size:Int32-instance-method","name":"size","doc":"Returns the number of elements in the array.\n\n```\n[:foo, :bar].size # => 2\n```","summary":"<p>Returns the number of elements in the array.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":212,"url":null},"def":{"name":"size","return_type":"Int32","visibility":"Public","body":"@size"},"external_var":false},{"html_id":"skip(count:Int):Array(T)-instance-method","name":"skip","doc":"Returns an `Array` with the first *count* elements removed\nfrom the original array.\n\nIf *count* is bigger than the number of elements in the array, returns an empty array.\n\n```\n[1, 2, 3, 4, 5, 6].skip(3) # => [4, 5, 6]\n```","summary":"<p>Returns an <code><a href=\"Array.html\">Array</a></code> with the first <em>count</em> elements removed from the original array.</p>","abstract":false,"args":[{"name":"count","external_name":"count","restriction":"Int"}],"args_string":"(count : Int) : Array(T)","args_html":"(count : <a href=\"Int.html\">Int</a>) : <a href=\"Array.html\">Array</a>(T)","location":{"filename":"src/array.cr","line_number":1230,"url":null},"def":{"name":"skip","args":[{"name":"count","external_name":"count","restriction":"Int"}],"return_type":"Array(T)","visibility":"Public","body":"if count < 0\n  raise(ArgumentError.new(\"Attempt to skip negative size\"))\nend\n\nnew_size = Math.max(size - count, 0)\nArray(T).build(new_size) do |buffer|\n  buffer.copy_from(to_unsafe + count, new_size)\n  new_size\nend\n"},"external_var":false},{"html_id":"sort:Array(T)-instance-method","name":"sort","doc":"Returns a new instance with all elements sorted based on the return value of\ntheir comparison method `T#<=>` (see `Comparable#<=>`), using a stable sort algorithm.\n\n```\na = [3, 1, 2]\na.sort # => [1, 2, 3]\na      # => [3, 1, 2]\n```\n\nSee `Indexable::Mutable#sort!` for details on the sorting mechanism.\n\nRaises `ArgumentError` if the comparison between any two elements returns `nil`.","summary":"<p>Returns a new instance with all elements sorted based on the return value of their comparison method <code>T#&lt;=&gt;</code> (see <code>Comparable#&lt;=&gt;</code>), using a stable sort algorithm.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1626,"url":null},"def":{"name":"sort","return_type":"Array(T)","visibility":"Public","body":"dup.sort!"},"external_var":false},{"html_id":"sort(&block:T,T->U):Array(T)forallU-instance-method","name":"sort","doc":"Returns a new instance with all elements sorted based on the comparator in the\ngiven block, using a stable sort algorithm.\n\n```\na = [3, 1, 2]\nb = a.sort { |a, b| b <=> a }\n\nb # => [3, 2, 1]\na # => [3, 1, 2]\n```\n\nSee `Indexable::Mutable#sort!(&block : T, T -> U)` for details on the sorting mechanism.\n\nRaises `ArgumentError` if for any two elements the block returns `nil`.","summary":"<p>Returns a new instance with all elements sorted based on the comparator in the given block, using a stable sort algorithm.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1660,"url":null},"def":{"name":"sort","yields":2,"block_arity":2,"block_arg":{"name":"block","external_name":"block","restriction":"(T, T -> U)"},"return_type":"Array(T)","visibility":"Public","body":"{% unless U <= ::Union(Int32, ::Nil) %}\n      {% raise(\"Expected block to return Int32 or Nil, not #{U}.\\nThe block is supposed to be a custom comparison operation, compatible with `Comparable#<=>`.\\nDid you mean to use `#sort_by`?\") %}\n    {% end %}\n\ndup.sort!(&block)\n"},"external_var":false},{"html_id":"sort!:Array(T)-instance-method","name":"sort!","doc":"Sorts all elements in `self` based on the return value of the comparison\nmethod `T#<=>` (see `Comparable#<=>`), using a stable sort algorithm.\n\n```\na = [3, 1, 2]\na.sort!\na # => [1, 2, 3]\n```\n\nThis sort operation modifies `self`. See `#sort` for a non-modifying option\nthat allocates a new instance.\n\nSee `Slice#sort!` for details on the implementation.\n\nRaises `ArgumentError` if the comparison between any two elements returns `nil`.","summary":"<p>Sorts all elements in <code>self</code> based on the return value of the comparison method <code>T#&lt;=&gt;</code> (see <code>Comparable#&lt;=&gt;</code>), using a stable sort algorithm.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1691,"url":null},"def":{"name":"sort!","return_type":"Array(T)","visibility":"Public","body":"to_unsafe_slice.sort!\nself\n"},"external_var":false},{"html_id":"sort!(&block:T,T->U):selfforallU-instance-method","name":"sort!","doc":"Sorts all elements in `self` based on the comparator in the given block, using\na stable sort algorithm.\n\nThe block must implement a comparison between two elements *a* and *b*,\nwhere `a < b` returns `-1`, `a == b` returns `0`, and `a > b` returns `1`.\nThe comparison operator `<=>` can be used for this.\n\n```\na = [3, 1, 2]\n# This is a reverse sort (forward sort would be `a <=> b`)\na.sort! { |a, b| b <=> a }\na # => [3, 2, 1]\n```\n\nThis sort operation modifies `self`. See `#sort(&block : T, T -> U)` for a\nnon-modifying option that allocates a new instance.\n\nSee `Slice#sort!(&block : T, T -> U)` for details on the implementation.\n\nRaises `ArgumentError` if for any two elements the block returns `nil`.","summary":"<p>Sorts all elements in <code>self</code> based on the comparator in the given block, using a stable sort algorithm.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1703,"url":null},"def":{"name":"sort!","yields":2,"block_arity":2,"block_arg":{"name":"block","external_name":"block","restriction":"(T, T -> U)"},"return_type":"self","visibility":"Public","body":"{% unless U <= ::Union(Int32, ::Nil) %}\n      {% raise(\"Expected block to return Int32 or Nil, not #{U}.\\nThe block is supposed to be a custom comparison operation, compatible with `Comparable#<=>`.\\nDid you mean to use `#sort_by!`?\") %}\n    {% end %}\n\nto_unsafe_slice.sort!(&block)\nself\n"},"external_var":false},{"html_id":"sort_by(&block:T->_):Array(T)-instance-method","name":"sort_by","doc":"Returns a new instance with all elements sorted by the output value of the\nblock. The output values are compared via the comparison method `T#<=>`\n(see `Comparable#<=>`), using a stable sort algorithm.\n\n```\na = %w(apple pear fig)\nb = a.sort_by { |word| word.size }\nb # => [\"fig\", \"pear\", \"apple\"]\na # => [\"apple\", \"pear\", \"fig\"]\n```\n\nIf stability is expendable, `#unstable_sort_by(&block : T -> _)` provides a\nperformance advantage over stable sort.\n\nSee `Indexable::Mutable#sort_by!(&block : T -> _)` for details on the sorting mechanism.\n\nRaises `ArgumentError` if the comparison between any two comparison values returns `nil`.","summary":"<p>Returns a new instance with all elements sorted by the output value of the block.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1739,"url":null},"def":{"name":"sort_by","yields":1,"block_arity":1,"block_arg":{"name":"block","external_name":"block","restriction":"(T -> _)"},"return_type":"Array(T)","visibility":"Public","body":"dup.sort_by! do |e| yield(e) end"},"external_var":false},{"html_id":"sort_by!(&block:T->_):Array(T)-instance-method","name":"sort_by!","doc":"Sorts all elements in `self` by the output value of the\nblock. The output values are compared via the comparison method `#<=>`\n(see `Comparable#<=>`), using a stable sort algorithm.\n\n```\na = %w(apple pear fig)\na.sort_by! { |word| word.size }\na # => [\"fig\", \"pear\", \"apple\"]\n```\n\nThis sort operation modifies `self`. See `#sort_by(&block : T -> _)` for a\nnon-modifying option that allocates a new instance.\n\nIf stability is expendable, `#unstable_sort_by!(&block : T -> _)` provides a\nperformance advantage over stable sort.\n\nSee `#sort!(&block : T -> _)` for details on the sorting mechanism.\n\nRaises `ArgumentError` if the comparison between any two comparison values returns `nil`.","summary":"<p>Sorts all elements in <code>self</code> by the output value of the block.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1764,"url":null},"def":{"name":"sort_by!","yields":1,"block_arity":1,"block_arg":{"name":"block","external_name":"block","restriction":"(T -> _)"},"return_type":"Array(T)","visibility":"Public","body":"sorted = map do |e| {e, yield(e)} end.sort! do |x, y| x[1] <=> y[1] end\n@size.times do |i|\n  @buffer[i] = sorted.to_unsafe[i][0]\nend\nself\n"},"external_var":false},{"html_id":"to_a:self-instance-method","name":"to_a","doc":"Returns an `Array` with all the elements in the collection.\n\n```\n(1..5).to_a # => [1, 2, 3, 4, 5]\n```","summary":"<p>Returns an <code><a href=\"Array.html\">Array</a></code> with all the elements in the collection.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1781,"url":null},"def":{"name":"to_a","return_type":"self","visibility":"Public","body":"self"},"external_var":false},{"html_id":"to_json(json:JSON::Builder):Nil-instance-method","name":"to_json","abstract":false,"args":[{"name":"json","external_name":"json","restriction":"JSON::Builder"}],"args_string":"(json : JSON::Builder) : Nil","args_html":"(json : <a href=\"JSON/Builder.html\">JSON::Builder</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/json/to_json.cr","line_number":94,"url":null},"def":{"name":"to_json","args":[{"name":"json","external_name":"json","restriction":"JSON::Builder"}],"return_type":"Nil","visibility":"Public","body":"json.array do\n  each(&.to_json(json))\nend"},"external_var":false},{"html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Prints a nicely readable and concise string representation of this array\nto *io*.\n\nThe result resembles an array literal but it does not necessarily compile.\n\nEach element is presented using its `#inspect(io)` result to avoid ambiguity.","summary":"<p>Prints a nicely readable and concise string representation of this array to <em>io</em>.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/array.cr","line_number":1791,"url":null},"def":{"name":"to_s","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"executed = exec_recursive(:to_s) do\n  io << '['\n  join(io, \", \", &.inspect(io))\n  io << ']'\nend\nif executed\nelse\n  io << \"[...]\"\nend\n"},"external_var":false},{"html_id":"to_unsafe:Pointer(T)-instance-method","name":"to_unsafe","doc":"Returns a pointer to the internal buffer where `self`'s elements are stored.\n\nThis method is **unsafe** because it returns a pointer, and the pointed might eventually\nnot be that of `self` if the array grows and its internal buffer is reallocated.\n\n```\nary = [1, 2, 3]\nary.to_unsafe[0] # => 1\n```","summary":"<p>Returns a pointer to the internal buffer where <code>self</code>'s elements are stored.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1816,"url":null},"def":{"name":"to_unsafe","return_type":"Pointer(T)","visibility":"Public","body":"@buffer"},"external_var":false},{"html_id":"to_yaml(yaml:YAML::Nodes::Builder):Nil-instance-method","name":"to_yaml","abstract":false,"args":[{"name":"yaml","external_name":"yaml","restriction":"YAML::Nodes::Builder"}],"args_string":"(yaml : YAML::Nodes::Builder) : Nil","args_html":"(yaml : <a href=\"YAML/Nodes/Builder.html\">YAML::Nodes::Builder</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/yaml/to_yaml.cr","line_number":35,"url":null},"def":{"name":"to_yaml","args":[{"name":"yaml","external_name":"yaml","restriction":"YAML::Nodes::Builder"}],"return_type":"Nil","visibility":"Public","body":"yaml.sequence(reference: self) do\n  each(&.to_yaml(yaml))\nend"},"external_var":false},{"html_id":"transpose-instance-method","name":"transpose","doc":"Assumes that `self` is an array of arrays and transposes the rows and columns.\n\n```\na = [[:a, :b], [:c, :d], [:e, :f]]\na.transpose # => [[:a, :c, :e], [:b, :d, :f]]\na           # => [[:a, :b], [:c, :d], [:e, :f]]\n```","summary":"<p>Assumes that <code>self</code> is an array of arrays and transposes the rows and columns.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1827,"url":null},"def":{"name":"transpose","visibility":"Public","body":"if empty?\n  return Array(Array(typeof(Enumerable.element_type(Enumerable.element_type(self))))).new\nend\n\nlen = self[0].size\n(1...@size).each do |i|\n  l = self[i].size\n  if len != l\n    raise(IndexError.new)\n  end\nend\n\nArray(Array(typeof(Enumerable.element_type(Enumerable.element_type(self))))).new(len) do |i|\n  Array(typeof(Enumerable.element_type(Enumerable.element_type(self)))).new(@size) do |j|\n    self[j][i]\n  end\nend\n"},"external_var":false},{"html_id":"truncate(start:Int,count:Int):self-instance-method","name":"truncate","doc":"Removes all elements except the *count* or less (if there aren't enough)\nelements starting at the given *start* index. Returns `self`.\n\nNegative values of *start* count from the end of the array.\n\nRaises `IndexError` if the *start* index is out of range.\n\nRaises `ArgumentError` if *count* is negative.\n\n```\na = [0, 1, 4, 9, 16, 25]\na.truncate(2, 3) # => [4, 9, 16]\na                # => [4, 9, 16]\n```\n\nSee also: `#pop`, `#shift`.","summary":"<p>Removes all elements except the <em>count</em> or less (if there aren't enough) elements starting at the given <em>start</em> index.</p>","abstract":false,"args":[{"name":"start","external_name":"start","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"}],"args_string":"(start : Int, count : Int) : self","args_html":"(start : <a href=\"Int.html\">Int</a>, count : <a href=\"Int.html\">Int</a>) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":1859,"url":null},"def":{"name":"truncate","args":[{"name":"start","external_name":"start","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"}],"return_type":"self","visibility":"Public","body":"start, count = normalize_start_and_count(start, count)\n\nif count == 0\n  clear\n  reset_buffer_to_root_buffer\nelse\n  @buffer.clear(start)\n  ((@buffer + start) + count).clear((size - start) - count)\n  @size = count\n  shift_buffer_by(start)\nend\n\nself\n"},"external_var":false},{"html_id":"truncate(range:Range):self-instance-method","name":"truncate","doc":"Removes all elements except those within the given *range*. Returns `self`.\n\n```\na = [0, 1, 4, 9, 16, 25]\na.truncate(1..-3) # => [1, 4, 9]\na                 # => [1, 4, 9]\n```","summary":"<p>Removes all elements except those within the given <em>range</em>.</p>","abstract":false,"args":[{"name":"range","external_name":"range","restriction":"Range"}],"args_string":"(range : Range) : self","args_html":"(range : <a href=\"Range.html\">Range</a>) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":1882,"url":null},"def":{"name":"truncate","args":[{"name":"range","external_name":"range","restriction":"Range"}],"return_type":"self","visibility":"Public","body":"truncate(*(Indexable.range_to_index_and_count(range, size)) || (raise(IndexError.new)))"},"external_var":false},{"html_id":"uniq:Array(T)-instance-method","name":"uniq","doc":"Returns a new `Array` by removing duplicate values in `self`.\n\n```\na = [\"a\", \"a\", \"b\", \"b\", \"c\"]\na.uniq # => [\"a\", \"b\", \"c\"]\na      # => [ \"a\", \"a\", \"b\", \"b\", \"c\" ]\n```","summary":"<p>Returns a new <code><a href=\"Array.html\">Array</a></code> by removing duplicate values in <code>self</code>.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1893,"url":null},"def":{"name":"uniq","return_type":"Array(T)","visibility":"Public","body":"if size <= 1\n  return dup\nend\n\n\n\nif size <= SMALL_ARRAY_SIZE\n  ary = Array(T).new\n  each do |elem|\n    if ary.includes?(elem)\n    else\n      ary << elem\n    end\n  end\n  return ary\nend\n\n\nto_set.to_a\n"},"external_var":false},{"html_id":"uniq(&:T->):Array(T)-instance-method","name":"uniq","doc":"Returns a new `Array` by removing duplicate values in `self`, using the block's\nvalue for comparison.\n\n```\na = [{\"student\", \"sam\"}, {\"student\", \"george\"}, {\"teacher\", \"matz\"}]\na.uniq { |s| s[0] } # => [{\"student\", \"sam\"}, {\"teacher\", \"matz\"}]\na                   # => [{\"student\", \"sam\"}, {\"student\", \"george\"}, {\"teacher\", \"matz\"}]\n```","summary":"<p>Returns a new <code><a href=\"Array.html\">Array</a></code> by removing duplicate values in <code>self</code>, using the block's value for comparison.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1920,"url":null},"def":{"name":"uniq","yields":1,"block_arity":1,"block_arg":{"name":"","external_name":"","restriction":"(T ->)"},"return_type":"Array(T)","visibility":"Public","body":"if size <= 1\n  dup\nelse\n  hash = to_lookup_hash do |elem| yield elem end\n  hash.values\nend"},"external_var":false},{"html_id":"uniq!:self-instance-method","name":"uniq!","doc":"Removes duplicate elements from `self`. Returns `self`.\n\n```\na = [\"a\", \"a\", \"b\", \"b\", \"c\"]\na.uniq! # => [\"a\", \"b\", \"c\"]\na       # => [\"a\", \"b\", \"c\"]\n```","summary":"<p>Removes duplicate elements from <code>self</code>.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1936,"url":null},"def":{"name":"uniq!","return_type":"self","visibility":"Public","body":"if size <= 1\n  return self\nend\n\n\n\nif size <= SMALL_ARRAY_SIZE\n  internal_delete do |elem, index|\n    (0...index).any? do |subindex| elem == to_unsafe[subindex] end\n  end\n  return self\nend\n\nuniq!(&.itself)\n"},"external_var":false},{"html_id":"uniq!(&:T->):self-instance-method","name":"uniq!","doc":"Removes duplicate elements from `self`, using the block's value for comparison. Returns `self`.\n\n```\na = [{\"student\", \"sam\"}, {\"student\", \"george\"}, {\"teacher\", \"matz\"}]\na.uniq! { |s| s[0] } # => [{\"student\", \"sam\"}, {\"teacher\", \"matz\"}]\na                    # => [{\"student\", \"sam\"}, {\"teacher\", \"matz\"}]\n```","summary":"<p>Removes duplicate elements from <code>self</code>, using the block's value for comparison.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1961,"url":null},"def":{"name":"uniq!","yields":1,"block_arity":1,"block_arg":{"name":"","external_name":"","restriction":"(T ->)"},"return_type":"self","visibility":"Public","body":"if size <= 1\n  return self\nend\n\nhash = to_lookup_hash do |elem| yield elem end\nif size == hash.size\n  return self\nend\n\nold_size = @size\n@size = hash.size\nremoved = old_size - @size\nif removed == 0\n  return self\nend\n\nptr = @buffer\nhash.each do |k, v|\n  ptr.value = v\n  ptr = ptr + 1\nend\n\n(@buffer + @size).clear(removed)\n\nself\n"},"external_var":false},{"html_id":"unsafe_fetch(index:Int):T-instance-method","name":"unsafe_fetch","doc":"Returns the element at the given *index*, without doing any bounds check.\n\n`Indexable` makes sure to invoke this method with *index* in `0...size`,\nso converting negative indices to positive ones is not needed here.\n\nClients never invoke this method directly. Instead, they access\nelements with `#[](index)` and `#[]?(index)`.\n\nThis method should only be directly invoked if you are absolutely\nsure the index is in bounds, to avoid a bounds check for a small boost\nof performance.","summary":"<p>Returns the element at the given <em>index</em>, without doing any bounds check.</p>","abstract":false,"args":[{"name":"index","external_name":"index","restriction":"Int"}],"args_string":"(index : Int) : T","args_html":"(index : <a href=\"Int.html\">Int</a>) : T","location":{"filename":"src/array.cr","line_number":664,"url":null},"def":{"name":"unsafe_fetch","args":[{"name":"index","external_name":"index","restriction":"Int"}],"return_type":"T","visibility":"Public","body":"@buffer[index]"},"external_var":false},{"html_id":"unsafe_put(index:Int,value:T)-instance-method","name":"unsafe_put","doc":"Sets the element at the given *index* to *value*, without doing any bounds\ncheck.\n\n`Indexable::Mutable` makes sure to invoke this method with *index* in\n`0...size`, so converting negative indices to positive ones is not needed\nhere.\n\nClients never invoke this method directly. Instead, they modify elements\nwith `#[]=(index, value)`.\n\nThis method should only be directly invoked if you are absolutely\nsure the index is in bounds, to avoid a bounds check for a small boost\nof performance.","summary":"<p>Sets the element at the given <em>index</em> to <em>value</em>, without doing any bounds check.</p>","abstract":false,"args":[{"name":"index","external_name":"index","restriction":"Int"},{"name":"value","external_name":"value","restriction":"T"}],"args_string":"(index : Int, value : T)","args_html":"(index : <a href=\"Int.html\">Int</a>, value : T)","location":{"filename":"src/array.cr","line_number":669,"url":null},"def":{"name":"unsafe_put","args":[{"name":"index","external_name":"index","restriction":"Int"},{"name":"value","external_name":"value","restriction":"T"}],"visibility":"Public","body":"@buffer[index] = value"},"external_var":false},{"html_id":"unshift(object:T):self-instance-method","name":"unshift","doc":"Prepend. Adds *object* to the beginning of `self`, given that the type of the value is *T*\n(which might be a single type or a union of types).\nThis method returns `self`, so several calls can be chained.\nSee `shift` for the opposite effect.\n\n```\na = [\"a\", \"b\"]\na.unshift(\"c\") # => [\"c\", \"a\", \"b\"]\na.unshift(1)   # Errors, because the array only accepts String.\n\na = [\"a\", \"b\"] of (Int32 | String)\na.unshift(\"c\") # => [\"c\", \"a\", \"b\"]\na.unshift(1)   # => [1, \"c\", \"a\", \"b\"]\n```","summary":"<p>Prepend.</p>","abstract":false,"args":[{"name":"object","external_name":"object","restriction":"T"}],"args_string":"(object : T) : self","args_html":"(object : T) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":2001,"url":null},"def":{"name":"unshift","args":[{"name":"object","external_name":"object","restriction":"T"}],"return_type":"self","visibility":"Public","body":"check_needs_resize_for_unshift\nshift_buffer_by(-1)\n@buffer.value = object\n@size = @size + 1\n\nself\n"},"external_var":false},{"html_id":"unshift(*values:T):self-instance-method","name":"unshift","doc":"Prepend multiple values. The same as `unshift`, but takes an arbitrary number\nof values to add to the array. Returns `self`.","summary":"<p>Prepend multiple values.</p>","abstract":false,"args":[{"name":"values","external_name":"values","restriction":"T"}],"args_string":"(*values : T) : self","args_html":"(*values : T) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":2012,"url":null},"def":{"name":"unshift","args":[{"name":"values","external_name":"values","restriction":"T"}],"splat_index":0,"return_type":"self","visibility":"Public","body":"values.reverse_each do |value|\n  unshift(value)\nend\nself\n"},"external_var":false},{"html_id":"unstable_sort:Array(T)-instance-method","name":"unstable_sort","doc":"Returns a new instance with all elements sorted based on the return value of\ntheir comparison method `T#<=>` (see `Comparable#<=>`), using an unstable sort algorithm.\n\n```\na = [3, 1, 2]\na.unstable_sort # => [1, 2, 3]\na               # => [3, 1, 2]\n```\n\nSee `Indexable::Mutable#unstable_sort!` for details on the sorting mechanism.\n\nRaises `ArgumentError` if the comparison between any two elements returns `nil`.","summary":"<p>Returns a new instance with all elements sorted based on the return value of their comparison method <code>T#&lt;=&gt;</code> (see <code>Comparable#&lt;=&gt;</code>), using an unstable sort algorithm.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1642,"url":null},"def":{"name":"unstable_sort","return_type":"Array(T)","visibility":"Public","body":"dup.unstable_sort!"},"external_var":false},{"html_id":"unstable_sort(&block:T,T->U):Array(T)forallU-instance-method","name":"unstable_sort","doc":"Returns a new instance with all elements sorted based on the comparator in the\ngiven block, using an unstable sort algorithm.\n\n```\na = [3, 1, 2]\nb = a.unstable_sort { |a, b| b <=> a }\n\nb # => [3, 2, 1]\na # => [3, 1, 2]\n```\n\nSee `Indexable::Mutable#unstable_sort!(&block : T, T -> U)` for details on the sorting mechanism.\n\nRaises `ArgumentError` if for any two elements the block returns `nil`.","summary":"<p>Returns a new instance with all elements sorted based on the comparator in the given block, using an unstable sort algorithm.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1682,"url":null},"def":{"name":"unstable_sort","yields":2,"block_arity":2,"block_arg":{"name":"block","external_name":"block","restriction":"(T, T -> U)"},"return_type":"Array(T)","visibility":"Public","body":"{% unless U <= ::Union(Int32, ::Nil) %}\n      {% raise(\"Expected block to return Int32 or Nil, not #{U}.\\nThe block is supposed to be a custom comparison operation, compatible with `Comparable#<=>`.\\nDid you mean to use `#unstable_sort_by`?\") %}\n    {% end %}\n\ndup.unstable_sort!(&block)\n"},"external_var":false},{"html_id":"unstable_sort!:self-instance-method","name":"unstable_sort!","doc":"Sorts all elements in `self` based on the return value of the comparison\nmethod `T#<=>` (see `Comparable#<=>`), using an unstable sort algorithm.\n\n```\na = [3, 1, 2]\na.unstable_sort!\na # => [1, 2, 3]\n```\n\nThis sort operation modifies `self`. See `#unstable_sort` for a non-modifying\noption that allocates a new instance.\n\nSee `Slice#unstable_sort!` for details on the implementation.\n\nRaises `ArgumentError` if the comparison between any two elements returns `nil`.","summary":"<p>Sorts all elements in <code>self</code> based on the return value of the comparison method <code>T#&lt;=&gt;</code> (see <code>Comparable#&lt;=&gt;</code>), using an unstable sort algorithm.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1697,"url":null},"def":{"name":"unstable_sort!","return_type":"self","visibility":"Public","body":"to_unsafe_slice.unstable_sort!\nself\n"},"external_var":false},{"html_id":"unstable_sort!(&block:T,T->U):selfforallU-instance-method","name":"unstable_sort!","doc":"Sorts all elements in `self` based on the comparator in the given block,\nusing an unstable sort algorithm.\n\nThe block must implement a comparison between two elements *a* and *b*,\nwhere `a < b` returns `-1`, `a == b` returns `0`, and `a > b` returns `1`.\nThe comparison operator `<=>` can be used for this.\n\n```\na = [3, 1, 2]\n# This is a reverse sort (forward sort would be `a <=> b`)\na.unstable_sort! { |a, b| b <=> a }\na # => [3, 2, 1]\n```\n\nThis sort operation modifies `self`. See `#unstable_sort(&block : T, T -> U)`\nfor a non-modifying option that allocates a new instance.\n\nSee `Slice#unstable_sort!(&block : T, T -> U)` for details on the implementation.\n\nRaises `ArgumentError` if for any two elements the block returns `nil`.","summary":"<p>Sorts all elements in <code>self</code> based on the comparator in the given block, using an unstable sort algorithm.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1713,"url":null},"def":{"name":"unstable_sort!","yields":2,"block_arity":2,"block_arg":{"name":"block","external_name":"block","restriction":"(T, T -> U)"},"return_type":"self","visibility":"Public","body":"{% unless U <= ::Union(Int32, ::Nil) %}\n      {% raise(\"Expected block to return Int32 or Nil, not #{U}.\\nThe block is supposed to be a custom comparison operation, compatible with `Comparable#<=>`.\\nDid you mean to use `#unstable_sort_by!`?\") %}\n    {% end %}\n\nto_unsafe_slice.unstable_sort!(&block)\nself\n"},"external_var":false},{"html_id":"unstable_sort_by(&block:T->_):Array(T)-instance-method","name":"unstable_sort_by","doc":"Returns a new instance with all elements sorted by the output value of the\nblock. The output values are compared via the comparison method `#<=>`\n(see `Comparable#<=>`), using an unstable sort algorithm.\n\n```\na = %w(apple pear fig)\nb = a.unstable_sort_by { |word| word.size }\nb # => [\"fig\", \"pear\", \"apple\"]\na # => [\"apple\", \"pear\", \"fig\"]\n```\n\nIf stability is necessary, use `#sort_by(&block : T -> _)` instead.\n\nSee `Indexable::Mutable#unstable_sort!(&block : T -> _)` for details on the sorting mechanism.\n\nRaises `ArgumentError` if the comparison between any two comparison values returns `nil`.","summary":"<p>Returns a new instance with all elements sorted by the output value of the block.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1759,"url":null},"def":{"name":"unstable_sort_by","yields":1,"block_arity":1,"block_arg":{"name":"block","external_name":"block","restriction":"(T -> _)"},"return_type":"Array(T)","visibility":"Public","body":"dup.unstable_sort_by! do |e| yield(e) end"},"external_var":false},{"html_id":"unstable_sort_by!(&block:T->_):Array(T)-instance-method","name":"unstable_sort_by!","doc":"Sorts all elements in `self` by the output value of the\nblock. The output values are compared via the comparison method `#<=>`\n(see `Comparable#<=>`), using an unstable sort algorithm.\n\n```\na = %w(apple pear fig)\na.unstable_sort_by! { |word| word.size }\na # => [\"fig\", \"pear\", \"apple\"]\n```\n\nThis sort operation modifies `self`. See `#unstable_sort_by(&block : T -> _)`\nfor a non-modifying option that allocates a new instance.\n\nIf stability is necessary, use  `#sort_by!(&block : T -> _)` instead.\n\nSee `#unstable_sort!(&block : T -> _)` for details on the sorting mechanism.\n\nRaises `ArgumentError` if the comparison between any two comparison values returns `nil`.","summary":"<p>Sorts all elements in <code>self</code> by the output value of the block.</p>","abstract":false,"location":{"filename":"src/array.cr","line_number":1773,"url":null},"def":{"name":"unstable_sort_by!","yields":1,"block_arity":1,"block_arg":{"name":"block","external_name":"block","restriction":"(T -> _)"},"return_type":"Array(T)","visibility":"Public","body":"sorted = map do |e| {e, yield(e)} end.unstable_sort! do |x, y| x[1] <=> y[1] end\n@size.times do |i|\n  @buffer[i] = sorted.to_unsafe[i][0]\nend\nself\n"},"external_var":false}]},{"html_id":"Crystal/Atomic","path":"Atomic.html","kind":"struct","full_name":"Atomic(T)","name":"Atomic","abstract":false,"superclass":{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},"ancestors":[{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/atomic.cr","line_number":12,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"doc":"A value that may be updated atomically.\n\n* If `T` is a reference type, or a union type containing only\n  reference types or `Nil`, then only `#compare_and_set`, `#swap`, `#set`,\n  `#lazy_set`, `#get`, and `#lazy_get` are available.\n* If `T` is a pointer type, then the above methods plus `#max` and `#min` are\n  available.\n* If `T` is a non-union primitive integer type or enum type, then all\n  operations are supported.","summary":"<p>A value that may be updated atomically.</p>","constructors":[{"html_id":"new(value:T)-class-method","name":"new","doc":"Creates an Atomic with the given initial value.","summary":"<p>Creates an Atomic with the given initial value.</p>","abstract":false,"args":[{"name":"value","external_name":"value","restriction":"T"}],"args_string":"(value : T)","args_html":"(value : T)","location":{"filename":"src/atomic.cr","line_number":41,"url":null},"def":{"name":"new","args":[{"name":"value","external_name":"value","restriction":"T"}],"visibility":"Public","body":"_ = Atomic(T).allocate\n_.initialize(value)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false}],"instance_methods":[{"html_id":"add(value:T,ordering:Ordering=:sequentially_consistent):T-instance-method","name":"add","doc":"Performs `atomic_value &+= value`. Returns the old value.\n\n`T` cannot contain any pointer or reference types.\n\n```\natomic = Atomic.new(1)\natomic.add(2) # => 1\natomic.get    # => 3\n```","summary":"<p>Performs <code>atomic_value &amp;+= value</code>.</p>","abstract":false,"args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"ordering","default_value":":sequentially_consistent","external_name":"ordering","restriction":"Ordering"}],"args_string":"(value : T, ordering : Ordering = :sequentially_consistent) : T","args_html":"(value : T, ordering : <a href=\"Atomic/Ordering.html\">Ordering</a> = <span class=\"n\">:sequentially_consistent</span>) : T","location":{"filename":"src/atomic.cr","line_number":128,"url":null},"def":{"name":"add","args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"ordering","default_value":":sequentially_consistent","external_name":"ordering","restriction":"Ordering"}],"return_type":"T","visibility":"Public","body":"check_pointer_type\ncheck_reference_type\ncheck_bool_type\natomicrmw(:add, pointerof(@value), value, ordering)\n"},"external_var":false},{"html_id":"and(value:T,ordering:Ordering=:sequentially_consistent):T-instance-method","name":"and","doc":"Performs `atomic_value &= value`. Returns the old value.\n\n`T` cannot contain any pointer or reference types.\n\n```\natomic = Atomic.new(5)\natomic.and(3) # => 5\natomic.get    # => 1\n```","summary":"<p>Performs <code>atomic_value &amp;= value</code>.</p>","abstract":false,"args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"ordering","default_value":":sequentially_consistent","external_name":"ordering","restriction":"Ordering"}],"args_string":"(value : T, ordering : Ordering = :sequentially_consistent) : T","args_html":"(value : T, ordering : <a href=\"Atomic/Ordering.html\">Ordering</a> = <span class=\"n\">:sequentially_consistent</span>) : T","location":{"filename":"src/atomic.cr","line_number":160,"url":null},"def":{"name":"and","args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"ordering","default_value":":sequentially_consistent","external_name":"ordering","restriction":"Ordering"}],"return_type":"T","visibility":"Public","body":"check_pointer_type\ncheck_reference_type\ncheck_bool_type\natomicrmw(:and, pointerof(@value), value, ordering)\n"},"external_var":false},{"html_id":"compare_and_set(cmp:T,new:T,success_ordering:Ordering,failure_ordering:Ordering):Tuple(T,Bool)-instance-method","name":"compare_and_set","doc":"Compares this atomic's value with *cmp* using explicit memory orderings:\n\n* if they are equal, sets the value to *new*, and returns `{old_value, true}`\n* if they are not equal the value remains the same, and returns `{old_value, false}`\n\nReference types are compared by `#same?`, not `#==`.\n\n```\natomic = Atomic.new(0_u32)\n\nvalue = atomic.get(:acquire)\nloop do\n  value, success = atomic.compare_and_set(value, value &+ 1, :acquire_release, :acquire)\n  break if success\nend\n```","summary":"<p>Compares this atomic's value with <em>cmp</em> using explicit memory orderings:</p>","abstract":false,"args":[{"name":"cmp","external_name":"cmp","restriction":"T"},{"name":"new","external_name":"new","restriction":"T"},{"name":"success_ordering","external_name":"success_ordering","restriction":"Ordering"},{"name":"failure_ordering","external_name":"failure_ordering","restriction":"Ordering"}],"args_string":"(cmp : T, new : T, success_ordering : Ordering, failure_ordering : Ordering) : Tuple(T, Bool)","args_html":"(cmp : T, new : T, success_ordering : <a href=\"Atomic/Ordering.html\">Ordering</a>, failure_ordering : <a href=\"Atomic/Ordering.html\">Ordering</a>) : <a href=\"Tuple.html\">Tuple</a>(T, <a href=\"Bool.html\">Bool</a>)","location":{"filename":"src/atomic.cr","line_number":89,"url":null},"def":{"name":"compare_and_set","args":[{"name":"cmp","external_name":"cmp","restriction":"T"},{"name":"new","external_name":"new","restriction":"T"},{"name":"success_ordering","external_name":"success_ordering","restriction":"Ordering"},{"name":"failure_ordering","external_name":"failure_ordering","restriction":"Ordering"}],"return_type":"::Tuple(T, Bool)","visibility":"Public","body":"case {success_ordering, failure_ordering}\nwhen {.relaxed?, .relaxed?}\n  cast_from(Ops.cmpxchg(as_pointer, cast_to(cmp), cast_to(new), :monotonic, :monotonic))\nwhen {.acquire?, .relaxed?}\n  cast_from(Ops.cmpxchg(as_pointer, cast_to(cmp), cast_to(new), :acquire, :monotonic))\nwhen {.acquire?, .acquire?}\n  cast_from(Ops.cmpxchg(as_pointer, cast_to(cmp), cast_to(new), :acquire, :acquire))\nwhen {.release?, .relaxed?}\n  cast_from(Ops.cmpxchg(as_pointer, cast_to(cmp), cast_to(new), :release, :monotonic))\nwhen {.release?, .acquire?}\n  cast_from(Ops.cmpxchg(as_pointer, cast_to(cmp), cast_to(new), :release, :acquire))\nwhen {.acquire_release?, .relaxed?}\n  cast_from(Ops.cmpxchg(as_pointer, cast_to(cmp), cast_to(new), :acquire_release, :monotonic))\nwhen {.acquire_release?, .acquire?}\n  cast_from(Ops.cmpxchg(as_pointer, cast_to(cmp), cast_to(new), :acquire_release, :acquire))\nwhen {.sequentially_consistent?, .relaxed?}\n  cast_from(Ops.cmpxchg(as_pointer, cast_to(cmp), cast_to(new), :sequentially_consistent, :monotonic))\nwhen {.sequentially_consistent?, .acquire?}\n  cast_from(Ops.cmpxchg(as_pointer, cast_to(cmp), cast_to(new), :sequentially_consistent, :acquire))\nwhen {.sequentially_consistent?, .sequentially_consistent?}\n  cast_from(Ops.cmpxchg(as_pointer, cast_to(cmp), cast_to(new), :sequentially_consistent, :sequentially_consistent))\nelse\n  if failure_ordering.release? || failure_ordering.acquire_release?\n    raise(ArgumentError.new(\"Failure ordering cannot include release semantics\"))\n  end\n  raise(ArgumentError.new(\"Failure ordering shall be no stronger than success ordering\"))\nend"},"external_var":false},{"html_id":"compare_and_set(cmp:T,new:T):Tuple(T,Bool)-instance-method","name":"compare_and_set","doc":"Compares this atomic's value with *cmp*:\n\n* if they are equal, sets the value to *new*, and returns `{old_value, true}`\n* if they are not equal the value remains the same, and returns `{old_value, false}`\n\nReference types are compared by `#same?`, not `#==`.\n\n```\natomic = Atomic.new(1)\n\natomic.compare_and_set(2, 3) # => {1, false}\natomic.get                   # => 1\n\natomic.compare_and_set(1, 3) # => {1, true}\natomic.get                   # => 3\n```","summary":"<p>Compares this atomic's value with <em>cmp</em>:</p>","abstract":false,"args":[{"name":"cmp","external_name":"cmp","restriction":"T"},{"name":"new","external_name":"new","restriction":"T"}],"args_string":"(cmp : T, new : T) : Tuple(T, Bool)","args_html":"(cmp : T, new : T) : <a href=\"Tuple.html\">Tuple</a>(T, <a href=\"Bool.html\">Bool</a>)","location":{"filename":"src/atomic.cr","line_number":69,"url":null},"def":{"name":"compare_and_set","args":[{"name":"cmp","external_name":"cmp","restriction":"T"},{"name":"new","external_name":"new","restriction":"T"}],"return_type":"::Tuple(T, Bool)","visibility":"Public","body":"cast_from(Ops.cmpxchg(as_pointer, cast_to(cmp), cast_to(new), :sequentially_consistent, :sequentially_consistent))"},"external_var":false},{"html_id":"get(ordering:Ordering=:sequentially_consistent):T-instance-method","name":"get","doc":"Atomically returns this atomic's value.","summary":"<p>Atomically returns this atomic's value.</p>","abstract":false,"args":[{"name":"ordering","default_value":":sequentially_consistent","external_name":"ordering","restriction":"Ordering"}],"args_string":"(ordering : Ordering = :sequentially_consistent) : T","args_html":"(ordering : <a href=\"Atomic/Ordering.html\">Ordering</a> = <span class=\"n\">:sequentially_consistent</span>) : T","location":{"filename":"src/atomic.cr","line_number":329,"url":null},"def":{"name":"get","args":[{"name":"ordering","default_value":":sequentially_consistent","external_name":"ordering","restriction":"Ordering"}],"return_type":"T","visibility":"Public","body":"case ordering\nin .relaxed?\n  cast_from(Ops.load(as_pointer, :monotonic, true))\nin .acquire?\n  cast_from(Ops.load(as_pointer, :acquire, true))\nin .sequentially_consistent?\n  cast_from(Ops.load(as_pointer, :sequentially_consistent, true))\nin .release?, .acquire_release?\n  raise(ArgumentError.new(\"Atomic load cannot have release semantic\"))\nend"},"external_var":false},{"html_id":"lazy_get-instance-method","name":"lazy_get","doc":"**Non-atomically** returns this atomic's value.\n\nNOTE: use with caution, this may break atomic guarantees.","summary":"<p><strong>Non-atomically</strong> returns this atomic's value.</p>","abstract":false,"location":{"filename":"src/atomic.cr","line_number":345,"url":null},"def":{"name":"lazy_get","visibility":"Public","body":"@value"},"external_var":false},{"html_id":"lazy_set(value:T):T-instance-method","name":"lazy_set","doc":"**Non-atomically** sets this atomic's value to *value*. Returns the **new** value.\n\n```\natomic = Atomic.new(5)\natomic.lazy_set(10) # => 10\natomic.get          # => 10\n```\n\nNOTE: use with caution, this may break atomic guarantees.","summary":"<p><strong>Non-atomically</strong> sets this atomic's value to <em>value</em>.</p>","abstract":false,"args":[{"name":"value","external_name":"value","restriction":"T"}],"args_string":"(value : T) : T","args_html":"(value : T) : T","location":{"filename":"src/atomic.cr","line_number":325,"url":null},"def":{"name":"lazy_set","args":[{"name":"value","external_name":"value","restriction":"T"}],"return_type":"T","visibility":"Public","body":"@value = value"},"external_var":false},{"html_id":"max(value:T,ordering:Ordering=:sequentially_consistent)-instance-method","name":"max","doc":"Performs `atomic_value = {atomic_value, value}.max`. Returns the old value.\n\n`T` cannot contain any reference types.\n\n```\natomic = Atomic.new(5)\n\natomic.max(3) # => 5\natomic.get    # => 5\n\natomic.max(10) # => 5\natomic.get     # => 10\n```","summary":"<p>Performs <code>atomic_value = {atomic_value, value}<a href=\"Atomic.html#max%28value%3AT%2Cordering%3AOrdering%3D%3Asequentially_consistent%29-instance-method\">.max</a></code>.</p>","abstract":false,"args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"ordering","default_value":":sequentially_consistent","external_name":"ordering","restriction":"Ordering"}],"args_string":"(value : T, ordering : Ordering = :sequentially_consistent)","args_html":"(value : T, ordering : <a href=\"Atomic/Ordering.html\">Ordering</a> = <span class=\"n\">:sequentially_consistent</span>)","location":{"filename":"src/atomic.cr","line_number":228,"url":null},"def":{"name":"max","args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"ordering","default_value":":sequentially_consistent","external_name":"ordering","restriction":"Ordering"}],"visibility":"Public","body":"check_reference_type\ncheck_bool_type\n{% if T < Enum %}\n      if @value.value.is_a?(Int::Signed)\n        atomicrmw(:max, pointerof(@value), value, ordering)\n      else\n        atomicrmw(:umax, pointerof(@value), value, ordering)\n      end\n    {% elsif T < Pointer %}\n      T.new(atomicrmw(:umax, pointerof(@value).as(LibC::SizeT*), LibC::SizeT.new!(value.address), ordering))\n    {% elsif T < Int::Signed %}\n      atomicrmw(:max, pointerof(@value), value, ordering)\n    {% else %}\n      atomicrmw(:umax, pointerof(@value), value, ordering)\n    {% end %}\n"},"external_var":false},{"html_id":"min(value:T,ordering:Ordering=:sequentially_consistent)-instance-method","name":"min","doc":"Performs `atomic_value = {atomic_value, value}.min`. Returns the old value.\n\n`T` cannot contain any reference types.\n\n```\natomic = Atomic.new(5)\n\natomic.min(10) # => 5\natomic.get     # => 5\n\natomic.min(3) # => 5\natomic.get    # => 3\n```","summary":"<p>Performs <code>atomic_value = {atomic_value, value}<a href=\"Atomic.html#min%28value%3AT%2Cordering%3AOrdering%3D%3Asequentially_consistent%29-instance-method\">.min</a></code>.</p>","abstract":false,"args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"ordering","default_value":":sequentially_consistent","external_name":"ordering","restriction":"Ordering"}],"args_string":"(value : T, ordering : Ordering = :sequentially_consistent)","args_html":"(value : T, ordering : <a href=\"Atomic/Ordering.html\">Ordering</a> = <span class=\"n\">:sequentially_consistent</span>)","location":{"filename":"src/atomic.cr","line_number":259,"url":null},"def":{"name":"min","args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"ordering","default_value":":sequentially_consistent","external_name":"ordering","restriction":"Ordering"}],"visibility":"Public","body":"check_reference_type\ncheck_bool_type\n{% if T < Enum %}\n      if @value.value.is_a?(Int::Signed)\n        atomicrmw(:min, pointerof(@value), value, ordering)\n      else\n        atomicrmw(:umin, pointerof(@value), value, ordering)\n      end\n    {% elsif T < Pointer %}\n      T.new(atomicrmw(:umin, pointerof(@value).as(LibC::SizeT*), LibC::SizeT.new!(value.address), ordering))\n    {% elsif T < Int::Signed %}\n      atomicrmw(:min, pointerof(@value), value, ordering)\n    {% else %}\n      atomicrmw(:umin, pointerof(@value), value, ordering)\n    {% end %}\n"},"external_var":false},{"html_id":"nand(value:T,ordering:Ordering=:sequentially_consistent):T-instance-method","name":"nand","doc":"Performs `atomic_value = ~(atomic_value & value)`. Returns the old value.\n\n`T` cannot contain any pointer or reference types.\n\n```\natomic = Atomic.new(5)\natomic.nand(3) # => 5\natomic.get     # => -2\n```","summary":"<p>Performs <code>atomic_value = ~(atomic_value &amp; value)</code>.</p>","abstract":false,"args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"ordering","default_value":":sequentially_consistent","external_name":"ordering","restriction":"Ordering"}],"args_string":"(value : T, ordering : Ordering = :sequentially_consistent) : T","args_html":"(value : T, ordering : <a href=\"Atomic/Ordering.html\">Ordering</a> = <span class=\"n\">:sequentially_consistent</span>) : T","location":{"filename":"src/atomic.cr","line_number":176,"url":null},"def":{"name":"nand","args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"ordering","default_value":":sequentially_consistent","external_name":"ordering","restriction":"Ordering"}],"return_type":"T","visibility":"Public","body":"check_pointer_type\ncheck_reference_type\ncheck_bool_type\natomicrmw(:nand, pointerof(@value), value, ordering)\n"},"external_var":false},{"html_id":"or(value:T,ordering:Ordering=:sequentially_consistent):T-instance-method","name":"or","doc":"Performs `atomic_value |= value`. Returns the old value.\n\n`T` cannot contain any pointer or reference types.\n\n```\natomic = Atomic.new(5)\natomic.or(2) # => 5\natomic.get   # => 7\n```","summary":"<p>Performs <code>atomic_value |= value</code>.</p>","abstract":false,"args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"ordering","default_value":":sequentially_consistent","external_name":"ordering","restriction":"Ordering"}],"args_string":"(value : T, ordering : Ordering = :sequentially_consistent) : T","args_html":"(value : T, ordering : <a href=\"Atomic/Ordering.html\">Ordering</a> = <span class=\"n\">:sequentially_consistent</span>) : T","location":{"filename":"src/atomic.cr","line_number":192,"url":null},"def":{"name":"or","args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"ordering","default_value":":sequentially_consistent","external_name":"ordering","restriction":"Ordering"}],"return_type":"T","visibility":"Public","body":"check_pointer_type\ncheck_reference_type\ncheck_bool_type\natomicrmw(:or, pointerof(@value), value, ordering)\n"},"external_var":false},{"html_id":"set(value:T,ordering:Ordering=:sequentially_consistent):T-instance-method","name":"set","doc":"Atomically sets this atomic's value to *value*. Returns the **new** value.\n\n```\natomic = Atomic.new(5)\natomic.set(10) # => 10\natomic.get     # => 10\n```","summary":"<p>Atomically sets this atomic's value to <em>value</em>.</p>","abstract":false,"args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"ordering","default_value":":sequentially_consistent","external_name":"ordering","restriction":"Ordering"}],"args_string":"(value : T, ordering : Ordering = :sequentially_consistent) : T","args_html":"(value : T, ordering : <a href=\"Atomic/Ordering.html\">Ordering</a> = <span class=\"n\">:sequentially_consistent</span>) : T","location":{"filename":"src/atomic.cr","line_number":302,"url":null},"def":{"name":"set","args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"ordering","default_value":":sequentially_consistent","external_name":"ordering","restriction":"Ordering"}],"return_type":"T","visibility":"Public","body":"case ordering\nin .relaxed?\n  Ops.store(as_pointer, cast_to(value), :monotonic, true)\nin .release?\n  Ops.store(as_pointer, cast_to(value), :release, true)\nin .sequentially_consistent?\n  Ops.store(as_pointer, cast_to(value), :sequentially_consistent, true)\nin .acquire?, .acquire_release?\n  raise(ArgumentError.new(\"Atomic store cannot have acquire semantic\"))\nend\nvalue\n"},"external_var":false},{"html_id":"sub(value:T,ordering:Ordering=:sequentially_consistent):T-instance-method","name":"sub","doc":"Performs `atomic_value &-= value`. Returns the old value.\n\n`T` cannot contain any pointer or reference types.\n\n```\natomic = Atomic.new(9)\natomic.sub(2) # => 9\natomic.get    # => 7\n```","summary":"<p>Performs <code>atomic_value &amp;-= value</code>.</p>","abstract":false,"args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"ordering","default_value":":sequentially_consistent","external_name":"ordering","restriction":"Ordering"}],"args_string":"(value : T, ordering : Ordering = :sequentially_consistent) : T","args_html":"(value : T, ordering : <a href=\"Atomic/Ordering.html\">Ordering</a> = <span class=\"n\">:sequentially_consistent</span>) : T","location":{"filename":"src/atomic.cr","line_number":144,"url":null},"def":{"name":"sub","args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"ordering","default_value":":sequentially_consistent","external_name":"ordering","restriction":"Ordering"}],"return_type":"T","visibility":"Public","body":"check_pointer_type\ncheck_reference_type\ncheck_bool_type\natomicrmw(:sub, pointerof(@value), value, ordering)\n"},"external_var":false},{"html_id":"swap(value:T,ordering:Ordering=:sequentially_consistent)-instance-method","name":"swap","doc":"Atomically sets this atomic's value to *value*. Returns the **old** value.\n\n```\natomic = Atomic.new(5)\natomic.swap(10) # => 5\natomic.get      # => 10\n```","summary":"<p>Atomically sets this atomic's value to <em>value</em>.</p>","abstract":false,"args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"ordering","default_value":":sequentially_consistent","external_name":"ordering","restriction":"Ordering"}],"args_string":"(value : T, ordering : Ordering = :sequentially_consistent)","args_html":"(value : T, ordering : <a href=\"Atomic/Ordering.html\">Ordering</a> = <span class=\"n\">:sequentially_consistent</span>)","location":{"filename":"src/atomic.cr","line_number":284,"url":null},"def":{"name":"swap","args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"ordering","default_value":":sequentially_consistent","external_name":"ordering","restriction":"Ordering"}],"visibility":"Public","body":"{% if T < Pointer %}\n      T.new(atomicrmw(:xchg, pointerof(@value).as(LibC::SizeT*), LibC::SizeT.new!(value.address), ordering))\n    {% elsif T.union_types.all? do |t| (t == Nil) || t < Reference end && (T != Nil) %}\n      address = atomicrmw(:xchg, pointerof(@value).as(LibC::SizeT*), LibC::SizeT.new(value.as(Void*).address), ordering)\n      Pointer(T).new(address).as(T)\n    {% else %}\n      cast_from atomicrmw(:xchg, as_pointer, cast_to(value), ordering)\n    {% end %}"},"external_var":false},{"html_id":"xor(value:T,ordering:Ordering=:sequentially_consistent):T-instance-method","name":"xor","doc":"Performs `atomic_value ^= value`. Returns the old value.\n\n`T` cannot contain any pointer or reference types.\n\n```\natomic = Atomic.new(5)\natomic.xor(3) # => 5\natomic.get    # => 6\n```","summary":"<p>Performs <code>atomic_value ^= value</code>.</p>","abstract":false,"args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"ordering","default_value":":sequentially_consistent","external_name":"ordering","restriction":"Ordering"}],"args_string":"(value : T, ordering : Ordering = :sequentially_consistent) : T","args_html":"(value : T, ordering : <a href=\"Atomic/Ordering.html\">Ordering</a> = <span class=\"n\">:sequentially_consistent</span>) : T","location":{"filename":"src/atomic.cr","line_number":208,"url":null},"def":{"name":"xor","args":[{"name":"value","external_name":"value","restriction":"T"},{"name":"ordering","default_value":":sequentially_consistent","external_name":"ordering","restriction":"Ordering"}],"return_type":"T","visibility":"Public","body":"check_pointer_type\ncheck_reference_type\ncheck_bool_type\natomicrmw(:xor, pointerof(@value), value, ordering)\n"},"external_var":false}],"macros":[{"html_id":"fence(ordering=:sequentially_consistent)-macro","name":"fence","doc":"Adds an explicit memory barrier with the specified memory order guarantee.","summary":"<p>Adds an explicit memory barrier with the specified memory order guarantee.</p>","abstract":false,"args":[{"name":"ordering","default_value":":sequentially_consistent","external_name":"ordering","restriction":""}],"args_string":"(ordering = :sequentially_consistent)","args_html":"(ordering = <span class=\"n\">:sequentially_consistent</span>)","location":{"filename":"src/atomic.cr","line_number":36,"url":null},"def":{"name":"fence","args":[{"name":"ordering","default_value":":sequentially_consistent","external_name":"ordering","restriction":""}],"visibility":"Public","body":"    ::Atomic::Ops.fence(\n{{ ordering }}\n, false)\n  \n"}}],"types":[{"html_id":"Crystal/Atomic/Flag","path":"Atomic/Flag.html","kind":"struct","full_name":"Atomic::Flag","name":"Flag","abstract":false,"superclass":{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},"ancestors":[{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/atomic.cr","line_number":462,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"namespace":{"html_id":"Crystal/Atomic","kind":"struct","full_name":"Atomic(T)","name":"Atomic"},"doc":"An atomic flag, that can be set or not.\n\nConcurrency safe. If many fibers try to set the atomic in parallel, only one\nwill succeed.\n\nExample:\n```\nflag = Atomic::Flag.new\nflag.test_and_set # => true\nflag.test_and_set # => false\nflag.clear\nflag.test_and_set # => true\n```","summary":"<p>An atomic flag, that can be set or not.</p>\n<p><span class=\"flag red\">DEPRECATED</span>  Use Atomic(Bool) instead.</p>","constructors":[{"html_id":"new-class-method","name":"new","abstract":false,"location":{"filename":"src/atomic.cr","line_number":463,"url":null},"def":{"name":"new","visibility":"Public","body":"_ = allocate\n_.initialize\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false}],"instance_methods":[{"html_id":"clear:Nil-instance-method","name":"clear","doc":"Atomically clears the flag.","summary":"<p>Atomically clears the flag.</p>","abstract":false,"location":{"filename":"src/atomic.cr","line_number":474,"url":null},"def":{"name":"clear","return_type":"Nil","visibility":"Public","body":"@value.set(false, :sequentially_consistent)"},"external_var":false},{"html_id":"test_and_set:Bool-instance-method","name":"test_and_set","doc":"Atomically tries to set the flag. Only succeeds and returns `true` if the\nflag wasn't previously set; returns `false` otherwise.","summary":"<p>Atomically tries to set the flag.</p>","abstract":false,"location":{"filename":"src/atomic.cr","line_number":469,"url":null},"def":{"name":"test_and_set","return_type":"Bool","visibility":"Public","body":"(@value.swap(true, :sequentially_consistent)) == false"},"external_var":false}]},{"html_id":"Crystal/Atomic/Ordering","path":"Atomic/Ordering.html","kind":"enum","full_name":"Atomic::Ordering","name":"Ordering","abstract":false,"ancestors":[{"html_id":"Crystal/Enum","kind":"struct","full_name":"Enum","name":"Enum"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/atomic.cr","line_number":27,"url":null}],"repository_name":"Crystal","program":false,"enum":true,"alias":false,"const":false,"constants":[{"id":"Relaxed","name":"Relaxed","value":"2"},{"id":"Acquire","name":"Acquire","value":"4"},{"id":"Release","name":"Release","value":"5"},{"id":"AcquireRelease","name":"AcquireRelease","value":"6"},{"id":"SequentiallyConsistent","name":"SequentiallyConsistent","value":"7"}],"namespace":{"html_id":"Crystal/Atomic","kind":"struct","full_name":"Atomic(T)","name":"Atomic"},"doc":"Specifies how memory accesses, including non atomic, are to be reordered\naround atomics. Follows the C/C++ semantics:\n<https://en.cppreference.com/w/c/atomic/memory_order>.\n\nBy default atomics use the sequentially consistent ordering, which has the\nstrongest guarantees. If all you need is to increment a counter, a relaxed\nordering may be enough. If you need to synchronize access to other memory\n(e.g. locks) you may try the acquire/release semantics that may be faster on\nsome architectures (e.g. X86) but remember that an acquire must be paired\nwith a release for the ordering to be guaranteed.\n\nThe code generation always enforces the selected memory order, even on\nweak CPU architectures (e.g. ARM32), with the exception of the Relaxed\nmemory order where only the operation itself is atomic.","summary":"<p>Specifies how memory accesses, including non atomic, are to be reordered around atomics.</p>","instance_methods":[{"html_id":"acquire?-instance-method","name":"acquire?","doc":"Returns `true` if this enum value equals `Acquire`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../Atomic/Ordering.html#Acquire\">Acquire</a></code></p>","abstract":false,"location":{"filename":"src/atomic.cr","line_number":29,"url":null},"def":{"name":"acquire?","visibility":"Public","body":"self == Acquire"},"external_var":false},{"html_id":"acquire_release?-instance-method","name":"acquire_release?","doc":"Returns `true` if this enum value equals `AcquireRelease`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../Atomic/Ordering.html#AcquireRelease\">AcquireRelease</a></code></p>","abstract":false,"location":{"filename":"src/atomic.cr","line_number":31,"url":null},"def":{"name":"acquire_release?","visibility":"Public","body":"self == AcquireRelease"},"external_var":false},{"html_id":"relaxed?-instance-method","name":"relaxed?","doc":"Returns `true` if this enum value equals `Relaxed`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../Atomic/Ordering.html#Relaxed\">Relaxed</a></code></p>","abstract":false,"location":{"filename":"src/atomic.cr","line_number":28,"url":null},"def":{"name":"relaxed?","visibility":"Public","body":"self == Relaxed"},"external_var":false},{"html_id":"release?-instance-method","name":"release?","doc":"Returns `true` if this enum value equals `Release`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../Atomic/Ordering.html#Release\">Release</a></code></p>","abstract":false,"location":{"filename":"src/atomic.cr","line_number":30,"url":null},"def":{"name":"release?","visibility":"Public","body":"self == Release"},"external_var":false},{"html_id":"sequentially_consistent?-instance-method","name":"sequentially_consistent?","doc":"Returns `true` if this enum value equals `SequentiallyConsistent`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../Atomic/Ordering.html#SequentiallyConsistent\">SequentiallyConsistent</a></code></p>","abstract":false,"location":{"filename":"src/atomic.cr","line_number":32,"url":null},"def":{"name":"sequentially_consistent?","visibility":"Public","body":"self == SequentiallyConsistent"},"external_var":false}]}]},{"html_id":"Crystal/Base64","path":"Base64.html","kind":"module","full_name":"Base64","name":"Base64","abstract":false,"locations":[{"filename":"src/base64.cr","line_number":18,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"extended_modules":[{"html_id":"Crystal/Base64","kind":"module","full_name":"Base64","name":"Base64"}],"doc":"The `Base64` module provides for the encoding (`encode`, `strict_encode`,\n`urlsafe_encode`) and decoding (`decode`)\nof binary data using a base64 representation.\n\n### Example\n\nA simple encoding and decoding.\n\n```\nrequire \"base64\"\n\nenc = Base64.encode(\"Send reinforcements\") # => \"U2VuZCByZWluZm9yY2VtZW50cw==\\n\"\nplain = Base64.decode_string(enc)          # => \"Send reinforcements\"\n```\n\nThe purpose of using base64 to encode data is that it translates any binary\ndata into purely printable characters.","summary":"<p>The <code><a href=\"Base64.html\">Base64</a></code> module provides for the encoding (<code><a href=\"Base64.html#encode%28data%2Cio%3AIO%29-instance-method\">#encode</a></code>, <code><a href=\"Base64.html#strict_encode%28data%2Cio%3AIO%29-instance-method\">#strict_encode</a></code>, <code><a href=\"Base64.html#urlsafe_encode%28data%2Cio%3AIO%29-instance-method\">#urlsafe_encode</a></code>) and decoding (<code><a href=\"Base64.html#decode%28data%2Cio%3AIO%29-instance-method\">#decode</a></code>) of binary data using a base64 representation.</p>","instance_methods":[{"html_id":"decode(data,io:IO)-instance-method","name":"decode","doc":"Writes the base64-decoded version of *data* to *io*.\nThis will decode either the normal or urlsafe alphabets.","summary":"<p>Writes the base64-decoded version of <em>data</em> to <em>io</em>.</p>","abstract":false,"args":[{"name":"data","external_name":"data","restriction":""},{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(data, io : IO)","args_html":"(data, io : <a href=\"IO.html\">IO</a>)","location":{"filename":"src/base64.cr","line_number":171,"url":null},"def":{"name":"decode","args":[{"name":"data","external_name":"data","restriction":""},{"name":"io","external_name":"io","restriction":"IO"}],"visibility":"Public","body":"count = 0\nfrom_base64(data.to_slice) do |byte|\n  io.write_byte(byte)\n  count = count + 1\nend\nio.flush\ncount\n"},"external_var":false},{"html_id":"decode(data):Bytes-instance-method","name":"decode","doc":"Returns the base64-decoded version of *data* as a `Bytes`.\nThis will decode either the normal or urlsafe alphabets.","summary":"<p>Returns the base64-decoded version of <em>data</em> as a <code><a href=\"Bytes.html\">Bytes</a></code>.</p>","abstract":false,"args":[{"name":"data","external_name":"data","restriction":""}],"args_string":"(data) : Bytes","args_html":"(data) : <a href=\"Bytes.html\">Bytes</a>","location":{"filename":"src/base64.cr","line_number":161,"url":null},"def":{"name":"decode","args":[{"name":"data","external_name":"data","restriction":""}],"return_type":"Bytes","visibility":"Public","body":"slice = data.to_slice\nbuf = Pointer(UInt8).malloc(decode_size(slice.size))\nappender = buf.appender\nfrom_base64(slice) do |byte| appender << byte end\nappender.to_slice\n"},"external_var":false},{"html_id":"decode_string(data):String-instance-method","name":"decode_string","doc":"Returns the base64-decoded version of *data* as a string.\nThis will decode either the normal or urlsafe alphabets.","summary":"<p>Returns the base64-decoded version of <em>data</em> as a string.</p>","abstract":false,"args":[{"name":"data","external_name":"data","restriction":""}],"args_string":"(data) : String","args_html":"(data) : <a href=\"String.html\">String</a>","location":{"filename":"src/base64.cr","line_number":183,"url":null},"def":{"name":"decode_string","args":[{"name":"data","external_name":"data","restriction":""}],"return_type":"String","visibility":"Public","body":"slice = data.to_slice\nString.new(decode_size(slice.size)) do |buf|\n  appender = buf.appender\n  from_base64(slice) do |byte| appender << byte end\n  {appender.size, 0}\nend\n"},"external_var":false},{"html_id":"encode(data,io:IO)-instance-method","name":"encode","doc":"Writes the base64-encoded version of *data* to *io*.\nThis method complies with [RFC 2045](https://tools.ietf.org/html/rfc2045).\nLine feeds are added to every 60 encoded characters.\n\n```\nBase64.encode(\"Now is the time for all good coders\\nto learn Crystal\", STDOUT)\n```","summary":"<p>Writes the base64-encoded version of <em>data</em> to <em>io</em>.</p>","abstract":false,"args":[{"name":"data","external_name":"data","restriction":""},{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(data, io : IO)","args_html":"(data, io : <a href=\"IO.html\">IO</a>)","location":{"filename":"src/base64.cr","line_number":61,"url":null},"def":{"name":"encode","args":[{"name":"data","external_name":"data","restriction":""},{"name":"io","external_name":"io","restriction":"IO"}],"visibility":"Public","body":"count = 0\nencode_with_new_lines(data.to_slice) do |byte|\n  io << byte.unsafe_chr\n  count = count + 1\nend\nio.flush\ncount\n"},"external_var":false},{"html_id":"encode(data):String-instance-method","name":"encode","doc":"Returns the base64-encoded version of *data*.\nThis method complies with [RFC 2045](https://tools.ietf.org/html/rfc2045).\nLine feeds are added to every 60 encoded characters.\n\n```\nputs Base64.encode(\"Now is the time for all good coders\\nto learn Crystal\")\n```\n\nGenerates:\n\n```text\nTm93IGlzIHRoZSB0aW1lIGZvciBhbGwgZ29vZCBjb2RlcnMKdG8gbGVhcm4g\nQ3J5c3RhbA==\n```","summary":"<p>Returns the base64-encoded version of <em>data</em>.</p>","abstract":false,"args":[{"name":"data","external_name":"data","restriction":""}],"args_string":"(data) : String","args_html":"(data) : <a href=\"String.html\">String</a>","location":{"filename":"src/base64.cr","line_number":44,"url":null},"def":{"name":"encode","args":[{"name":"data","external_name":"data","restriction":""}],"return_type":"String","visibility":"Public","body":"slice = data.to_slice\nString.new(encode_size(slice.size, new_lines: true)) do |buf|\n  appender = buf.appender\n  encode_with_new_lines(slice) do |byte| appender << byte end\n  size = appender.size\n  {size, size}\nend\n"},"external_var":false},{"html_id":"strict_encode(data,io:IO)-instance-method","name":"strict_encode","doc":"Writes the base64-encoded version of *data* with no newlines to *io*.\nThis method complies with [RFC 4648](https://tools.ietf.org/html/rfc4648).\n\n```\nBase64.strict_encode(\"Now is the time for all good coders\\nto learn Crystal\", STDOUT)\n```","summary":"<p>Writes the base64-encoded version of <em>data</em> with no newlines to <em>io</em>.</p>","abstract":false,"args":[{"name":"data","external_name":"data","restriction":""},{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(data, io : IO)","args_html":"(data, io : <a href=\"IO.html\">IO</a>)","location":{"filename":"src/base64.cr","line_number":118,"url":null},"def":{"name":"strict_encode","args":[{"name":"data","external_name":"data","restriction":""},{"name":"io","external_name":"io","restriction":"IO"}],"visibility":"Public","body":"strict_encode_to_io_internal(data, io, CHARS_STD, pad: true)"},"external_var":false},{"html_id":"strict_encode(data):String-instance-method","name":"strict_encode","doc":"Returns the base64-encoded version of *data* with no newlines.\nThis method complies with [RFC 4648](https://tools.ietf.org/html/rfc4648).\n\n```\nputs Base64.strict_encode(\"Now is the time for all good coders\\nto learn Crystal\")\n```\n\nGenerates:\n\n```text\nTm93IGlzIHRoZSB0aW1lIGZvciBhbGwgZ29vZCBjb2RlcnMKdG8gbGVhcm4gQ3J5c3RhbA==\n```","summary":"<p>Returns the base64-encoded version of <em>data</em> with no newlines.</p>","abstract":false,"args":[{"name":"data","external_name":"data","restriction":""}],"args_string":"(data) : String","args_html":"(data) : <a href=\"String.html\">String</a>","location":{"filename":"src/base64.cr","line_number":98,"url":null},"def":{"name":"strict_encode","args":[{"name":"data","external_name":"data","restriction":""}],"return_type":"String","visibility":"Public","body":"strict_encode(data, CHARS_STD, pad: true)"},"external_var":false},{"html_id":"urlsafe_encode(data,io:IO)-instance-method","name":"urlsafe_encode","doc":"Writes the base64-encoded version of *data* using a urlsafe alphabet to *io*.\nThis method complies with \"Base 64 Encoding with URL and Filename Safe\nAlphabet\" in [RFC 4648](https://tools.ietf.org/html/rfc4648).\n\nThe alphabet uses `'-'` instead of `'+'` and `'_'` instead of `'/'`.","summary":"<p>Writes the base64-encoded version of <em>data</em> using a urlsafe alphabet to <em>io</em>.</p>","abstract":false,"args":[{"name":"data","external_name":"data","restriction":""},{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(data, io : IO)","args_html":"(data, io : <a href=\"IO.html\">IO</a>)","location":{"filename":"src/base64.cr","line_number":155,"url":null},"def":{"name":"urlsafe_encode","args":[{"name":"data","external_name":"data","restriction":""},{"name":"io","external_name":"io","restriction":"IO"}],"visibility":"Public","body":"strict_encode_to_io_internal(data, io, CHARS_SAFE, pad: true)"},"external_var":false},{"html_id":"urlsafe_encode(data,padding=true):String-instance-method","name":"urlsafe_encode","doc":"Returns the base64-encoded version of *data* using a urlsafe alphabet.\nThis method complies with \"Base 64 Encoding with URL and Filename Safe\nAlphabet\" in [RFC 4648](https://tools.ietf.org/html/rfc4648).\n\nThe alphabet uses `'-'` instead of `'+'` and `'_'` instead of `'/'`.\n\nThe *padding* parameter defaults to `true`. When `false`, enough `=` characters\nare not added to make the output divisible by 4.","summary":"<p>Returns the base64-encoded version of <em>data</em> using a urlsafe alphabet.</p>","abstract":false,"args":[{"name":"data","external_name":"data","restriction":""},{"name":"padding","default_value":"true","external_name":"padding","restriction":""}],"args_string":"(data, padding = true) : String","args_html":"(data, padding = <span class=\"n\">true</span>) : <a href=\"String.html\">String</a>","location":{"filename":"src/base64.cr","line_number":140,"url":null},"def":{"name":"urlsafe_encode","args":[{"name":"data","external_name":"data","restriction":""},{"name":"padding","default_value":"true","external_name":"padding","restriction":""}],"return_type":"String","visibility":"Public","body":"slice = data.to_slice\nString.new(encode_size(slice.size)) do |buf|\n  appender = buf.appender\n  to_base64(slice, CHARS_SAFE, pad: padding) do |byte| appender << byte end\n  size = appender.size\n  {size, size}\nend\n"},"external_var":false}],"types":[{"html_id":"Crystal/Base64/Error","path":"Base64/Error.html","kind":"class","full_name":"Base64::Error","name":"Error","abstract":false,"superclass":{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},"ancestors":[{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/base64.cr","line_number":21,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"namespace":{"html_id":"Crystal/Base64","kind":"module","full_name":"Base64","name":"Base64"}}]},{"html_id":"Crystal/Benchmark","path":"Benchmark.html","kind":"module","full_name":"Benchmark","name":"Benchmark","abstract":false,"locations":[{"filename":"src/benchmark.cr","line_number":85,"url":null},{"filename":"src/benchmark/bm.cr","line_number":1,"url":null},{"filename":"src/benchmark/ips.cr","line_number":1,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"extended_modules":[{"html_id":"Crystal/Benchmark","kind":"module","full_name":"Benchmark","name":"Benchmark"}],"doc":"The Benchmark module provides methods for benchmarking Crystal code, giving\ndetailed reports on the time and memory taken for each task.\n\nNOTE: To use `Benchmark`, you must explicitly import it with `require \"benchmark\"`\n\n### Measure the number of iterations per second of each task\n\n```\nrequire \"benchmark\"\n\nBenchmark.ips do |x|\n  x.report(\"short sleep\") { sleep 10.milliseconds }\n  x.report(\"shorter sleep\") { sleep 1.millisecond }\nend\n```\n\nThis generates the following output showing the mean iterations per second,\nthe mean times per iteration, the standard deviation relative to the mean, and a comparison:\n\n```text\n  short sleep   88.7  ( 11.27ms) (± 3.33%)  8.90× slower\nshorter sleep  789.7  (  1.27ms) (± 3.02%)       fastest\n```\n\n`Benchmark::IPS` defaults to 2 seconds of warmup time and 5 seconds of\ncalculation time. This can be configured:\n\n```\nrequire \"benchmark\"\n\nBenchmark.ips(warmup: 4, calculation: 10) do |x|\n  x.report(\"sleep\") { sleep 10.milliseconds }\nend\n```\n\n### Measure the time to construct the string given by the expression: `\"a\"*1_000_000_000`\n\n```\nrequire \"benchmark\"\n\nputs Benchmark.measure { \"a\"*1_000_000_000 }\n```\n\nThis generates the following output:\n\n```text\n 0.190000   0.220000   0.410000 (  0.420185)\n```\n\nThis report shows the user CPU time, system CPU time, the sum of\nthe user and system CPU times, and the elapsed real time. The unit\nof time is seconds.\n\n### Do some experiments sequentially using the `#bm` method:\n\n```\nrequire \"benchmark\"\n\nn = 5000000\nBenchmark.bm do |x|\n  x.report(\"times:\") do\n    n.times do\n      a = \"1\"\n    end\n  end\n  x.report(\"upto:\") do\n    1.upto(n) do\n      a = \"1\"\n    end\n  end\nend\n```\n\nThe result:\n\n```text\n           user     system      total        real\ntimes:   0.010000   0.000000   0.010000 (  0.008976)\nupto:    0.010000   0.000000   0.010000 (  0.010466)\n```\n\nNOTE: Make sure to always benchmark code by compiling with the `--release` flag.","summary":"<p>The Benchmark module provides methods for benchmarking Crystal code, giving detailed reports on the time and memory taken for each task.</p>","instance_methods":[{"html_id":"bm(&)-instance-method","name":"bm","doc":"Main interface of the `Benchmark` module. Yields a `Job` to which\none can report the benchmarks. See the module's description.","summary":"<p>Main interface of the <code><a href=\"Benchmark.html\">Benchmark</a></code> module.</p>","abstract":false,"location":{"filename":"src/benchmark.cr","line_number":90,"url":null},"def":{"name":"bm","yields":1,"block_arity":1,"visibility":"Public","body":"{% if !(flag?(:release)) %}\n      puts \"Warning: benchmarking without the `--release` flag won't yield useful results\"\n    {% end %}\n\nreport = BM::Job.new\nyield report\nreport.execute\nreport\n"},"external_var":false},{"html_id":"ips(calculation:Time::Span=5.seconds,warmup:Time::Span=2.seconds,interactive:Bool=STDOUT.tty?,&)-instance-method","name":"ips","doc":"Instruction per second interface of the `Benchmark` module. Yields a `Job`\nto which one can report the benchmarks. See the module's description.\n\nThe optional parameters *calculation* and *warmup* set the duration of\nthose stages. For more detail on these stages see\n`Benchmark::IPS`. When the *interactive* parameter is `true`, results are\ndisplayed and updated as they are calculated, otherwise all at once after they finished.","summary":"<p>Instruction per second interface of the <code><a href=\"Benchmark.html\">Benchmark</a></code> module.</p>","abstract":false,"args":[{"name":"calculation","default_value":"5.seconds","external_name":"calculation","restriction":"Time::Span"},{"name":"warmup","default_value":"2.seconds","external_name":"warmup","restriction":"Time::Span"},{"name":"interactive","default_value":"STDOUT.tty?","external_name":"interactive","restriction":"Bool"}],"args_string":"(calculation : Time::Span = 5.seconds, warmup : Time::Span = 2.seconds, interactive : Bool = STDOUT.tty?, &)","args_html":"(calculation : <a href=\"Time/Span.html\">Time::Span</a> = <span class=\"n\">5</span>.seconds, warmup : <a href=\"Time/Span.html\">Time::Span</a> = <span class=\"n\">2</span>.seconds, interactive : <a href=\"Bool.html\">Bool</a> = <span class=\"t\">STDOUT</span>.tty?, &)","location":{"filename":"src/benchmark.cr","line_number":108,"url":null},"def":{"name":"ips","args":[{"name":"calculation","default_value":"5.seconds","external_name":"calculation","restriction":"Time::Span"},{"name":"warmup","default_value":"2.seconds","external_name":"warmup","restriction":"Time::Span"},{"name":"interactive","default_value":"STDOUT.tty?","external_name":"interactive","restriction":"Bool"}],"yields":1,"block_arity":1,"visibility":"Public","body":"{% if !(flag?(:release)) %}\n      puts \"Warning: benchmarking without the `--release` flag won't yield useful results\"\n    {% end %}\n\njob = IPS::Job.new(calculation, warmup, interactive)\nyield job\njob.execute\njob.report\njob\n"},"external_var":false},{"html_id":"ips(calculation=5,warmup=2,interactive=STDOUT.tty?,&)-instance-method","name":"ips","doc":"Instruction per second interface of the `Benchmark` module. Yields a `Job`\nto which one can report the benchmarks. See the module's description.\n\nThe optional parameters *calculation* and *warmup* set the duration of\nthose stages in seconds. For more detail on these stages see\n`Benchmark::IPS`. When the *interactive* parameter is `true`, results are\ndisplayed and updated as they are calculated, otherwise all at once after they finished.","summary":"<p>Instruction per second interface of the <code><a href=\"Benchmark.html\">Benchmark</a></code> module.</p>\n<p><span class=\"flag red\">DEPRECATED</span>  Use <code>#ips(Time::Span, Time::Span, Bool, &amp;)</code> instead.</p>","abstract":false,"args":[{"name":"calculation","default_value":"5","external_name":"calculation","restriction":""},{"name":"warmup","default_value":"2","external_name":"warmup","restriction":""},{"name":"interactive","default_value":"STDOUT.tty?","external_name":"interactive","restriction":""}],"args_string":"(calculation = 5, warmup = 2, interactive = STDOUT.tty?, &)","args_html":"(calculation = <span class=\"n\">5</span>, warmup = <span class=\"n\">2</span>, interactive = <span class=\"t\">STDOUT</span>.tty?, &)","location":{"filename":"src/benchmark.cr","line_number":128,"url":null},"def":{"name":"ips","args":[{"name":"calculation","default_value":"5","external_name":"calculation","restriction":""},{"name":"warmup","default_value":"2","external_name":"warmup","restriction":""},{"name":"interactive","default_value":"STDOUT.tty?","external_name":"interactive","restriction":""}],"yields":1,"block_arity":1,"visibility":"Public","body":"ips(calculation.seconds, warmup.seconds, !(!interactive)) do |job| yield job end"},"external_var":false},{"html_id":"measure(label=\"\",&):BM::Tms-instance-method","name":"measure","doc":"Returns the time used to execute the given block.","summary":"<p>Returns the time used to execute the given block.</p>","abstract":false,"args":[{"name":"label","default_value":"\"\"","external_name":"label","restriction":""}],"args_string":"(label = \"\", &) : BM::Tms","args_html":"(label = <span class=\"s\">&quot;&quot;</span>, &) : <a href=\"Benchmark/BM/Tms.html\">BM::Tms</a>","location":{"filename":"src/benchmark.cr","line_number":133,"url":null},"def":{"name":"measure","args":[{"name":"label","default_value":"\"\"","external_name":"label","restriction":""}],"yields":0,"block_arity":0,"return_type":"BM::Tms","visibility":"Public","body":"t0, r0 = Process.times, Time.instant\nyield\nt1, r1 = Process.times, Time.instant\nBM::Tms.new(t1.utime - t0.utime, t1.stime - t0.stime, t1.cutime - t0.cutime, t1.cstime - t0.cstime, (r1 - r0).total_seconds, label)\n"},"external_var":false},{"html_id":"memory(&)-instance-method","name":"memory","doc":"Returns the memory in bytes that the given block consumes.\n\n```\nBenchmark.memory { Array(Int32).new } # => 32\n```","summary":"<p>Returns the memory in bytes that the given block consumes.</p>","abstract":false,"location":{"filename":"src/benchmark.cr","line_number":159,"url":null},"def":{"name":"memory","yields":0,"block_arity":0,"visibility":"Public","body":"bytes_before_measure = GC.stats.total_bytes\nyield\n(GC.stats.total_bytes - bytes_before_measure).to_i64\n"},"external_var":false},{"html_id":"realtime(&):Time::Span-instance-method","name":"realtime","doc":"Returns the elapsed real time used to execute the given block.\n\n```\nBenchmark.realtime { \"a\" * 100_000 } # => 00:00:00.0005840\n```","summary":"<p>Returns the elapsed real time used to execute the given block.</p>","abstract":false,"location":{"filename":"src/benchmark.cr","line_number":150,"url":null},"def":{"name":"realtime","yields":0,"block_arity":0,"return_type":"Time::Span","visibility":"Public","body":"Time.measure do yield end"},"external_var":false}],"types":[{"html_id":"Crystal/Benchmark/BM","path":"Benchmark/BM.html","kind":"module","full_name":"Benchmark::BM","name":"BM","abstract":false,"locations":[{"filename":"src/benchmark/bm.cr","line_number":2,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"namespace":{"html_id":"Crystal/Benchmark","kind":"module","full_name":"Benchmark","name":"Benchmark"},"types":[{"html_id":"Crystal/Benchmark/BM/Job","path":"Benchmark/BM/Job.html","kind":"class","full_name":"Benchmark::BM::Job","name":"Job","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/benchmark/bm.cr","line_number":39,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"namespace":{"html_id":"Crystal/Benchmark/BM","kind":"module","full_name":"Benchmark::BM","name":"BM"},"doc":"Yielded by `Benchmark#bm`, use `#report` to report benchmarks.","summary":"<p>Yielded by <code><a href=\"../../Benchmark.html#bm%28%26%29-instance-method\">Benchmark#bm</a></code>, use <code><a href=\"../../Benchmark/BM/Job.html#report%28label%3AString%3D%22%22%2C%26block%3A-%3E%29%3ANil-instance-method\">#report</a></code> to report benchmarks.</p>","instance_methods":[{"html_id":"report(label:String=\"\",&block:->):Nil-instance-method","name":"report","doc":"Reports a single benchmark unit.","summary":"<p>Reports a single benchmark unit.</p>","abstract":false,"args":[{"name":"label","default_value":"\" \"","external_name":"label","restriction":"String"}],"args_string":"(label : String = \" \", &block :  -> ) : Nil","args_html":"(label : <a href=\"../../String.html\">String</a> = <span class=\"s\">&quot; &quot;</span>, &block :  -> ) : <a href=\"../../Nil.html\">Nil</a>","location":{"filename":"src/benchmark/bm.cr","line_number":47,"url":null},"def":{"name":"report","args":[{"name":"label","default_value":"\" \"","external_name":"label","restriction":"String"}],"yields":0,"block_arity":0,"block_arg":{"name":"block","external_name":"block","restriction":"(->)"},"return_type":"Nil","visibility":"Public","body":"if label.size > @label_width\n  @label_width = label.size\nend\n@reports << {label, block}\n"},"external_var":false}]},{"html_id":"Crystal/Benchmark/BM/Tms","path":"Benchmark/BM/Tms.html","kind":"class","full_name":"Benchmark::BM::Tms","name":"Tms","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/benchmark/bm.cr","line_number":4,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"namespace":{"html_id":"Crystal/Benchmark/BM","kind":"module","full_name":"Benchmark::BM","name":"BM"},"doc":"A data object, representing the times associated with a benchmark measurement.","summary":"<p>A data object, representing the times associated with a benchmark measurement.</p>","instance_methods":[{"html_id":"cstime:Float64-instance-method","name":"cstime","doc":"System CPU time of children","summary":"<p>System CPU time of children</p>","abstract":false,"location":{"filename":"src/benchmark/bm.cr","line_number":15,"url":null},"def":{"name":"cstime","return_type":"Float64","visibility":"Public","body":"@cstime"},"external_var":false},{"html_id":"cutime:Float64-instance-method","name":"cutime","doc":"User CPU time of children","summary":"<p>User CPU time of children</p>","abstract":false,"location":{"filename":"src/benchmark/bm.cr","line_number":12,"url":null},"def":{"name":"cutime","return_type":"Float64","visibility":"Public","body":"@cutime"},"external_var":false},{"html_id":"label:String-instance-method","name":"label","doc":"The label associated with this measure","summary":"<p>The label associated with this measure</p>","abstract":false,"location":{"filename":"src/benchmark/bm.cr","line_number":21,"url":null},"def":{"name":"label","return_type":"String","visibility":"Public","body":"@label"},"external_var":false},{"html_id":"real:Float64-instance-method","name":"real","doc":"Elapsed real time","summary":"<p>Elapsed real time</p>","abstract":false,"location":{"filename":"src/benchmark/bm.cr","line_number":18,"url":null},"def":{"name":"real","return_type":"Float64","visibility":"Public","body":"@real"},"external_var":false},{"html_id":"stime:Float64-instance-method","name":"stime","doc":"System CPU time","summary":"<p>System CPU time</p>","abstract":false,"location":{"filename":"src/benchmark/bm.cr","line_number":9,"url":null},"def":{"name":"stime","return_type":"Float64","visibility":"Public","body":"@stime"},"external_var":false},{"html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Prints `utime`, `stime`, `total` and `real` to *io*.","summary":"<p>Prints <code><a href=\"../../Benchmark/BM/Tms.html#utime%3AFloat64-instance-method\">#utime</a></code>, <code><a href=\"../../Benchmark/BM/Tms.html#stime%3AFloat64-instance-method\">#stime</a></code>, <code><a href=\"../../Benchmark/BM/Tms.html#total%3AFloat64-instance-method\">#total</a></code> and <code><a href=\"../../Benchmark/BM/Tms.html#real%3AFloat64-instance-method\">#real</a></code> to <em>io</em>.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"../../IO.html\">IO</a>) : <a href=\"../../Nil.html\">Nil</a>","location":{"filename":"src/benchmark/bm.cr","line_number":33,"url":null},"def":{"name":"to_s","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"io.printf(\"  %.6f   %.6f   %.6f (  %.6f)\", utime, stime, total, real)"},"external_var":false},{"html_id":"total:Float64-instance-method","name":"total","doc":"Total time, that is `utime` + `stime` + `cutime` + `cstime`","summary":"<p>Total time, that is <code><a href=\"../../Benchmark/BM/Tms.html#utime%3AFloat64-instance-method\">#utime</a></code> + <code><a href=\"../../Benchmark/BM/Tms.html#stime%3AFloat64-instance-method\">#stime</a></code> + <code><a href=\"../../Benchmark/BM/Tms.html#cutime%3AFloat64-instance-method\">#cutime</a></code> + <code><a href=\"../../Benchmark/BM/Tms.html#cstime%3AFloat64-instance-method\">#cstime</a></code></p>","abstract":false,"location":{"filename":"src/benchmark/bm.cr","line_number":28,"url":null},"def":{"name":"total","return_type":"Float64","visibility":"Public","body":"((utime + stime) + cutime) + cstime"},"external_var":false},{"html_id":"utime:Float64-instance-method","name":"utime","doc":"User CPU time","summary":"<p>User CPU time</p>","abstract":false,"location":{"filename":"src/benchmark/bm.cr","line_number":6,"url":null},"def":{"name":"utime","return_type":"Float64","visibility":"Public","body":"@utime"},"external_var":false}]}]},{"html_id":"Crystal/Benchmark/IPS","path":"Benchmark/IPS.html","kind":"module","full_name":"Benchmark::IPS","name":"IPS","abstract":false,"locations":[{"filename":"src/benchmark/ips.cr","line_number":14,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"namespace":{"html_id":"Crystal/Benchmark","kind":"module","full_name":"Benchmark","name":"Benchmark"},"doc":"Benchmark IPS calculates the number of iterations per second for a given\nblock of code. The strategy is to use two stages: a warmup stage and a\ncalculation stage.\n\nThe warmup phase defaults to 2 seconds. During this stage we figure out how\nmany cycles are needed to run the block for roughly 100ms, and record it.\n\nThe calculation defaults to 5 seconds. During this stage we run the block\nin sets of the size calculated in the warmup stage. The measurements for\nthose sets are then used to calculate the mean and standard deviation,\nwhich are then reported. Additionally we compare the means to that of the\nfastest.","summary":"<p>Benchmark IPS calculates the number of iterations per second for a given block of code.</p>","types":[{"html_id":"Crystal/Benchmark/IPS/Entry","path":"Benchmark/IPS/Entry.html","kind":"class","full_name":"Benchmark::IPS::Entry","name":"Entry","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/benchmark/ips.cr","line_number":128,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"namespace":{"html_id":"Crystal/Benchmark/IPS","kind":"module","full_name":"Benchmark::IPS","name":"IPS"},"constructors":[{"html_id":"new(label:String,action:->)-class-method","name":"new","abstract":false,"args":[{"name":"label","external_name":"label","restriction":"String"},{"name":"action","external_name":"action","restriction":"(->)"}],"args_string":"(label : String, action :  -> )","args_html":"(label : <a href=\"../../String.html\">String</a>, action :  -> )","location":{"filename":"src/benchmark/ips.cr","line_number":163,"url":null},"def":{"name":"new","args":[{"name":"label","external_name":"label","restriction":"String"},{"name":"action","external_name":"action","restriction":"(->)"}],"visibility":"Public","body":"_ = allocate\n_.initialize(label, action)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false}],"instance_methods":[{"html_id":"action:->-instance-method","name":"action","doc":"Code to be benchmarked","summary":"<p>Code to be benchmarked</p>","abstract":false,"location":{"filename":"src/benchmark/ips.cr","line_number":133,"url":null},"def":{"name":"action","return_type":"(->)","visibility":"Public","body":"@action"},"external_var":false},{"html_id":"action=(action:->)-instance-method","name":"action=","doc":"Code to be benchmarked","summary":"<p>Code to be benchmarked</p>","abstract":false,"args":[{"name":"action","external_name":"action","restriction":"(->)"}],"args_string":"(action :  -> )","args_html":"(action :  -> )","location":{"filename":"src/benchmark/ips.cr","line_number":133,"url":null},"def":{"name":"action=","args":[{"name":"action","external_name":"action","restriction":"(->)"}],"visibility":"Public","body":"@action = action"},"external_var":false},{"html_id":"bytes_per_op:UInt64-instance-method","name":"bytes_per_op","doc":"Number of bytes allocated per operation","summary":"<p>Number of bytes allocated per operation</p>","abstract":false,"location":{"filename":"src/benchmark/ips.cr","line_number":158,"url":null},"def":{"name":"bytes_per_op","return_type":"UInt64","visibility":"Public","body":"if (__temp_104 = @bytes_per_op).nil?\n  ::raise(::NilAssertionError.new(\"Benchmark::IPS::Entry#bytes_per_op cannot be nil\"))\nelse\n  __temp_104\nend"},"external_var":false},{"html_id":"bytes_per_op=(bytes_per_op:UInt64)-instance-method","name":"bytes_per_op=","doc":"Number of bytes allocated per operation","summary":"<p>Number of bytes allocated per operation</p>","abstract":false,"args":[{"name":"bytes_per_op","external_name":"bytes_per_op","restriction":"UInt64"}],"args_string":"(bytes_per_op : UInt64)","args_html":"(bytes_per_op : <a href=\"../../UInt64.html\">UInt64</a>)","location":{"filename":"src/benchmark/ips.cr","line_number":158,"url":null},"def":{"name":"bytes_per_op=","args":[{"name":"bytes_per_op","external_name":"bytes_per_op","restriction":"UInt64"}],"visibility":"Public","body":"@bytes_per_op = bytes_per_op"},"external_var":false},{"html_id":"bytes_per_op?:UInt64|Nil-instance-method","name":"bytes_per_op?","doc":"Number of bytes allocated per operation","summary":"<p>Number of bytes allocated per operation</p>","abstract":false,"location":{"filename":"src/benchmark/ips.cr","line_number":158,"url":null},"def":{"name":"bytes_per_op?","return_type":"UInt64 | ::Nil","visibility":"Public","body":"@bytes_per_op"},"external_var":false},{"html_id":"calculate_stats(samples):Nil-instance-method","name":"calculate_stats","abstract":false,"args":[{"name":"samples","external_name":"samples","restriction":""}],"args_string":"(samples) : Nil","args_html":"(samples) : <a href=\"../../Nil.html\">Nil</a>","location":{"filename":"src/benchmark/ips.cr","line_number":183,"url":null},"def":{"name":"calculate_stats","args":[{"name":"samples","external_name":"samples","restriction":""}],"return_type":"Nil","visibility":"Public","body":"@ran = true\n@size = samples.size\n@mean = samples.sum.to_f / size.to_f\n@variance = (samples.reduce(0) do |acc, i| acc + ((i - mean) ** 2) end).to_f / size.to_f\n@stddev = Math.sqrt(variance)\n@relative_stddev = 100.0 * (stddev / mean)\n"},"external_var":false},{"html_id":"call:Nil-instance-method","name":"call","abstract":false,"location":{"filename":"src/benchmark/ips.cr","line_number":170,"url":null},"def":{"name":"call","return_type":"Nil","visibility":"Public","body":"action.call"},"external_var":false},{"html_id":"call_for_100ms:Nil-instance-method","name":"call_for_100ms","abstract":false,"location":{"filename":"src/benchmark/ips.cr","line_number":174,"url":null},"def":{"name":"call_for_100ms","return_type":"Nil","visibility":"Public","body":"cycles.times do action.call end"},"external_var":false},{"html_id":"cycles:Int32-instance-method","name":"cycles","doc":"Number of cycles needed to run `action` for approximately 100ms.\nCalculated during the warmup stage","summary":"<p>Number of cycles needed to run <code><a href=\"../../Benchmark/IPS/Entry.html#action%3A-%3E-instance-method\">#action</a></code> for approximately 100ms.</p>","abstract":false,"location":{"filename":"src/benchmark/ips.cr","line_number":137,"url":null},"def":{"name":"cycles","return_type":"Int32","visibility":"Public","body":"if (__temp_97 = @cycles).nil?\n  ::raise(::NilAssertionError.new(\"Benchmark::IPS::Entry#cycles cannot be nil\"))\nelse\n  __temp_97\nend"},"external_var":false},{"html_id":"cycles=(cycles:Int32)-instance-method","name":"cycles=","doc":"Number of cycles needed to run `action` for approximately 100ms.\nCalculated during the warmup stage","summary":"<p>Number of cycles needed to run <code><a href=\"../../Benchmark/IPS/Entry.html#action%3A-%3E-instance-method\">#action</a></code> for approximately 100ms.</p>","abstract":false,"args":[{"name":"cycles","external_name":"cycles","restriction":"Int32"}],"args_string":"(cycles : Int32)","args_html":"(cycles : <a href=\"../../Int32.html\">Int32</a>)","location":{"filename":"src/benchmark/ips.cr","line_number":137,"url":null},"def":{"name":"cycles=","args":[{"name":"cycles","external_name":"cycles","restriction":"Int32"}],"visibility":"Public","body":"@cycles = cycles"},"external_var":false},{"html_id":"cycles?:Int32|Nil-instance-method","name":"cycles?","doc":"Number of cycles needed to run `action` for approximately 100ms.\nCalculated during the warmup stage","summary":"<p>Number of cycles needed to run <code><a href=\"../../Benchmark/IPS/Entry.html#action%3A-%3E-instance-method\">#action</a></code> for approximately 100ms.</p>","abstract":false,"location":{"filename":"src/benchmark/ips.cr","line_number":137,"url":null},"def":{"name":"cycles?","return_type":"Int32 | ::Nil","visibility":"Public","body":"@cycles"},"external_var":false},{"html_id":"human_compare:String-instance-method","name":"human_compare","abstract":false,"location":{"filename":"src/benchmark/ips.cr","line_number":205,"url":null},"def":{"name":"human_compare","return_type":"String","visibility":"Public","body":"if slower == 1.0\n  \"fastest\"\nelse\n  sprintf(\"%5.2f× slower\", slower)\nend"},"external_var":false},{"html_id":"human_iteration_time:String-instance-method","name":"human_iteration_time","abstract":false,"location":{"filename":"src/benchmark/ips.cr","line_number":196,"url":null},"def":{"name":"human_iteration_time","return_type":"String","visibility":"Public","body":"iteration_time = 1.0 / mean\n\niteration_time.humanize(precision: 2, significant: false) do |magnitude, _|\n  magnitude = (Number.prefix_index(magnitude)).clamp(-9..0)\n  {magnitude, magnitude == 0 ? \"s \" : \"#{Number.si_prefix(magnitude)}s\"}\nend.rjust(8)\n"},"external_var":false},{"html_id":"human_mean:String-instance-method","name":"human_mean","abstract":false,"location":{"filename":"src/benchmark/ips.cr","line_number":192,"url":null},"def":{"name":"human_mean","return_type":"String","visibility":"Public","body":"mean.humanize(precision: 2, significant: false, prefixes: Number::SI_PREFIXES_PADDED).rjust(7)"},"external_var":false},{"html_id":"label:String-instance-method","name":"label","doc":"Label of the benchmark","summary":"<p>Label of the benchmark</p>","abstract":false,"location":{"filename":"src/benchmark/ips.cr","line_number":130,"url":null},"def":{"name":"label","return_type":"String","visibility":"Public","body":"@label"},"external_var":false},{"html_id":"label=(label:String)-instance-method","name":"label=","doc":"Label of the benchmark","summary":"<p>Label of the benchmark</p>","abstract":false,"args":[{"name":"label","external_name":"label","restriction":"String"}],"args_string":"(label : String)","args_html":"(label : <a href=\"../../String.html\">String</a>)","location":{"filename":"src/benchmark/ips.cr","line_number":130,"url":null},"def":{"name":"label=","args":[{"name":"label","external_name":"label","restriction":"String"}],"visibility":"Public","body":"@label = label"},"external_var":false},{"html_id":"mean:Float64-instance-method","name":"mean","doc":"Statistical mean from calculation stage","summary":"<p>Statistical mean from calculation stage</p>","abstract":false,"location":{"filename":"src/benchmark/ips.cr","line_number":143,"url":null},"def":{"name":"mean","return_type":"Float64","visibility":"Public","body":"if (__temp_99 = @mean).nil?\n  ::raise(::NilAssertionError.new(\"Benchmark::IPS::Entry#mean cannot be nil\"))\nelse\n  __temp_99\nend"},"external_var":false},{"html_id":"mean=(mean:Float64)-instance-method","name":"mean=","doc":"Statistical mean from calculation stage","summary":"<p>Statistical mean from calculation stage</p>","abstract":false,"args":[{"name":"mean","external_name":"mean","restriction":"Float64"}],"args_string":"(mean : Float64)","args_html":"(mean : <a href=\"../../Float64.html\">Float64</a>)","location":{"filename":"src/benchmark/ips.cr","line_number":143,"url":null},"def":{"name":"mean=","args":[{"name":"mean","external_name":"mean","restriction":"Float64"}],"visibility":"Public","body":"@mean = mean"},"external_var":false},{"html_id":"mean?:Float64|Nil-instance-method","name":"mean?","doc":"Statistical mean from calculation stage","summary":"<p>Statistical mean from calculation stage</p>","abstract":false,"location":{"filename":"src/benchmark/ips.cr","line_number":143,"url":null},"def":{"name":"mean?","return_type":"Float64 | ::Nil","visibility":"Public","body":"@mean"},"external_var":false},{"html_id":"ran?:Bool-instance-method","name":"ran?","abstract":false,"location":{"filename":"src/benchmark/ips.cr","line_number":166,"url":null},"def":{"name":"ran?","return_type":"Bool","visibility":"Public","body":"@ran"},"external_var":false},{"html_id":"relative_stddev:Float64-instance-method","name":"relative_stddev","doc":"Relative standard deviation as a percentage","summary":"<p>Relative standard deviation as a percentage</p>","abstract":false,"location":{"filename":"src/benchmark/ips.cr","line_number":152,"url":null},"def":{"name":"relative_stddev","return_type":"Float64","visibility":"Public","body":"if (__temp_102 = @relative_stddev).nil?\n  ::raise(::NilAssertionError.new(\"Benchmark::IPS::Entry#relative_stddev cannot be nil\"))\nelse\n  __temp_102\nend"},"external_var":false},{"html_id":"relative_stddev=(relative_stddev:Float64)-instance-method","name":"relative_stddev=","doc":"Relative standard deviation as a percentage","summary":"<p>Relative standard deviation as a percentage</p>","abstract":false,"args":[{"name":"relative_stddev","external_name":"relative_stddev","restriction":"Float64"}],"args_string":"(relative_stddev : Float64)","args_html":"(relative_stddev : <a href=\"../../Float64.html\">Float64</a>)","location":{"filename":"src/benchmark/ips.cr","line_number":152,"url":null},"def":{"name":"relative_stddev=","args":[{"name":"relative_stddev","external_name":"relative_stddev","restriction":"Float64"}],"visibility":"Public","body":"@relative_stddev = relative_stddev"},"external_var":false},{"html_id":"relative_stddev?:Float64|Nil-instance-method","name":"relative_stddev?","doc":"Relative standard deviation as a percentage","summary":"<p>Relative standard deviation as a percentage</p>","abstract":false,"location":{"filename":"src/benchmark/ips.cr","line_number":152,"url":null},"def":{"name":"relative_stddev?","return_type":"Float64 | ::Nil","visibility":"Public","body":"@relative_stddev"},"external_var":false},{"html_id":"set_cycles(duration,iterations):Nil-instance-method","name":"set_cycles","abstract":false,"args":[{"name":"duration","external_name":"duration","restriction":""},{"name":"iterations","external_name":"iterations","restriction":""}],"args_string":"(duration, iterations) : Nil","args_html":"(duration, iterations) : <a href=\"../../Nil.html\">Nil</a>","location":{"filename":"src/benchmark/ips.cr","line_number":178,"url":null},"def":{"name":"set_cycles","args":[{"name":"duration","external_name":"duration","restriction":""},{"name":"iterations","external_name":"iterations","restriction":""}],"return_type":"Nil","visibility":"Public","body":"@cycles = ((iterations / duration.total_milliseconds) * 100).to_i\nif cycles <= 0\n  @cycles = 1\nend\n"},"external_var":false},{"html_id":"size:Int32-instance-method","name":"size","doc":"Number of 100ms runs during the calculation stage","summary":"<p>Number of 100ms runs during the calculation stage</p>","abstract":false,"location":{"filename":"src/benchmark/ips.cr","line_number":140,"url":null},"def":{"name":"size","return_type":"Int32","visibility":"Public","body":"if (__temp_98 = @size).nil?\n  ::raise(::NilAssertionError.new(\"Benchmark::IPS::Entry#size cannot be nil\"))\nelse\n  __temp_98\nend"},"external_var":false},{"html_id":"size=(size:Int32)-instance-method","name":"size=","doc":"Number of 100ms runs during the calculation stage","summary":"<p>Number of 100ms runs during the calculation stage</p>","abstract":false,"args":[{"name":"size","external_name":"size","restriction":"Int32"}],"args_string":"(size : Int32)","args_html":"(size : <a href=\"../../Int32.html\">Int32</a>)","location":{"filename":"src/benchmark/ips.cr","line_number":140,"url":null},"def":{"name":"size=","args":[{"name":"size","external_name":"size","restriction":"Int32"}],"visibility":"Public","body":"@size = size"},"external_var":false},{"html_id":"size?:Int32|Nil-instance-method","name":"size?","doc":"Number of 100ms runs during the calculation stage","summary":"<p>Number of 100ms runs during the calculation stage</p>","abstract":false,"location":{"filename":"src/benchmark/ips.cr","line_number":140,"url":null},"def":{"name":"size?","return_type":"Int32 | ::Nil","visibility":"Public","body":"@size"},"external_var":false},{"html_id":"slower:Float64-instance-method","name":"slower","doc":"Multiple slower than the fastest entry","summary":"<p>Multiple slower than the fastest entry</p>","abstract":false,"location":{"filename":"src/benchmark/ips.cr","line_number":155,"url":null},"def":{"name":"slower","return_type":"Float64","visibility":"Public","body":"if (__temp_103 = @slower).nil?\n  ::raise(::NilAssertionError.new(\"Benchmark::IPS::Entry#slower cannot be nil\"))\nelse\n  __temp_103\nend"},"external_var":false},{"html_id":"slower=(slower:Float64)-instance-method","name":"slower=","doc":"Multiple slower than the fastest entry","summary":"<p>Multiple slower than the fastest entry</p>","abstract":false,"args":[{"name":"slower","external_name":"slower","restriction":"Float64"}],"args_string":"(slower : Float64)","args_html":"(slower : <a href=\"../../Float64.html\">Float64</a>)","location":{"filename":"src/benchmark/ips.cr","line_number":155,"url":null},"def":{"name":"slower=","args":[{"name":"slower","external_name":"slower","restriction":"Float64"}],"visibility":"Public","body":"@slower = slower"},"external_var":false},{"html_id":"slower?:Float64|Nil-instance-method","name":"slower?","doc":"Multiple slower than the fastest entry","summary":"<p>Multiple slower than the fastest entry</p>","abstract":false,"location":{"filename":"src/benchmark/ips.cr","line_number":155,"url":null},"def":{"name":"slower?","return_type":"Float64 | ::Nil","visibility":"Public","body":"@slower"},"external_var":false},{"html_id":"stddev:Float64-instance-method","name":"stddev","doc":"Statistical standard deviation from calculation stage","summary":"<p>Statistical standard deviation from calculation stage</p>","abstract":false,"location":{"filename":"src/benchmark/ips.cr","line_number":149,"url":null},"def":{"name":"stddev","return_type":"Float64","visibility":"Public","body":"if (__temp_101 = @stddev).nil?\n  ::raise(::NilAssertionError.new(\"Benchmark::IPS::Entry#stddev cannot be nil\"))\nelse\n  __temp_101\nend"},"external_var":false},{"html_id":"stddev=(stddev:Float64)-instance-method","name":"stddev=","doc":"Statistical standard deviation from calculation stage","summary":"<p>Statistical standard deviation from calculation stage</p>","abstract":false,"args":[{"name":"stddev","external_name":"stddev","restriction":"Float64"}],"args_string":"(stddev : Float64)","args_html":"(stddev : <a href=\"../../Float64.html\">Float64</a>)","location":{"filename":"src/benchmark/ips.cr","line_number":149,"url":null},"def":{"name":"stddev=","args":[{"name":"stddev","external_name":"stddev","restriction":"Float64"}],"visibility":"Public","body":"@stddev = stddev"},"external_var":false},{"html_id":"stddev?:Float64|Nil-instance-method","name":"stddev?","doc":"Statistical standard deviation from calculation stage","summary":"<p>Statistical standard deviation from calculation stage</p>","abstract":false,"location":{"filename":"src/benchmark/ips.cr","line_number":149,"url":null},"def":{"name":"stddev?","return_type":"Float64 | ::Nil","visibility":"Public","body":"@stddev"},"external_var":false},{"html_id":"variance:Float64-instance-method","name":"variance","doc":"Statistical variance from calculation stage","summary":"<p>Statistical variance from calculation stage</p>","abstract":false,"location":{"filename":"src/benchmark/ips.cr","line_number":146,"url":null},"def":{"name":"variance","return_type":"Float64","visibility":"Public","body":"if (__temp_100 = @variance).nil?\n  ::raise(::NilAssertionError.new(\"Benchmark::IPS::Entry#variance cannot be nil\"))\nelse\n  __temp_100\nend"},"external_var":false},{"html_id":"variance=(variance:Float64)-instance-method","name":"variance=","doc":"Statistical variance from calculation stage","summary":"<p>Statistical variance from calculation stage</p>","abstract":false,"args":[{"name":"variance","external_name":"variance","restriction":"Float64"}],"args_string":"(variance : Float64)","args_html":"(variance : <a href=\"../../Float64.html\">Float64</a>)","location":{"filename":"src/benchmark/ips.cr","line_number":146,"url":null},"def":{"name":"variance=","args":[{"name":"variance","external_name":"variance","restriction":"Float64"}],"visibility":"Public","body":"@variance = variance"},"external_var":false},{"html_id":"variance?:Float64|Nil-instance-method","name":"variance?","doc":"Statistical variance from calculation stage","summary":"<p>Statistical variance from calculation stage</p>","abstract":false,"location":{"filename":"src/benchmark/ips.cr","line_number":146,"url":null},"def":{"name":"variance?","return_type":"Float64 | ::Nil","visibility":"Public","body":"@variance"},"external_var":false}]},{"html_id":"Crystal/Benchmark/IPS/Job","path":"Benchmark/IPS/Job.html","kind":"class","full_name":"Benchmark::IPS::Job","name":"Job","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/benchmark/ips.cr","line_number":15,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"namespace":{"html_id":"Crystal/Benchmark/IPS","kind":"module","full_name":"Benchmark::IPS","name":"IPS"},"constructors":[{"html_id":"new(calculationcalculation_time:Time::Span=5.seconds,warmupwarmup_time:Time::Span=2.seconds,interactive:Bool=STDOUT.tty?)-class-method","name":"new","abstract":false,"args":[{"name":"calculation_time","default_value":"5.seconds","external_name":"calculation","restriction":"Time::Span"},{"name":"warmup_time","default_value":"2.seconds","external_name":"warmup","restriction":"Time::Span"},{"name":"interactive","default_value":"STDOUT.tty?","external_name":"interactive","restriction":"Bool"}],"args_string":"(calculation calculation_time : Time::Span = 5.seconds, warmup warmup_time : Time::Span = 2.seconds, interactive : Bool = STDOUT.tty?)","args_html":"(calculation calculation_time : <a href=\"../../Time/Span.html\">Time::Span</a> = <span class=\"n\">5</span>.seconds, warmup warmup_time : <a href=\"../../Time/Span.html\">Time::Span</a> = <span class=\"n\">2</span>.seconds, interactive : <a href=\"../../Bool.html\">Bool</a> = <span class=\"t\">STDOUT</span>.tty?)","location":{"filename":"src/benchmark/ips.cr","line_number":23,"url":null},"def":{"name":"new","args":[{"name":"calculation_time","default_value":"5.seconds","external_name":"calculation","restriction":"Time::Span"},{"name":"warmup_time","default_value":"2.seconds","external_name":"warmup","restriction":"Time::Span"},{"name":"interactive","default_value":"STDOUT.tty?","external_name":"interactive","restriction":"Bool"}],"visibility":"Public","body":"_ = allocate\n_.initialize(calculation_time, warmup_time, interactive)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(calculation=5,warmup=2,interactive=STDOUT.tty?)-class-method","name":"new","summary":"<p><span class=\"flag red\">DEPRECATED</span>  Use <code><a href=\"../../Benchmark/IPS/Job.html#new%28calculationcalculation_time%3ATime%3A%3ASpan%3D5.seconds%2Cwarmupwarmup_time%3ATime%3A%3ASpan%3D2.seconds%2Cinteractive%3ABool%3DSTDOUT.tty%3F%29-class-method\">.new(Time::Span, Time::Span, Bool)</a></code> instead.</p>","abstract":false,"args":[{"name":"calculation","default_value":"5","external_name":"calculation","restriction":""},{"name":"warmup","default_value":"2","external_name":"warmup","restriction":""},{"name":"interactive","default_value":"STDOUT.tty?","external_name":"interactive","restriction":""}],"args_string":"(calculation = 5, warmup = 2, interactive = STDOUT.tty?)","args_html":"(calculation = <span class=\"n\">5</span>, warmup = <span class=\"n\">2</span>, interactive = <span class=\"t\">STDOUT</span>.tty?)","location":{"filename":"src/benchmark/ips.cr","line_number":29,"url":null},"def":{"name":"new","args":[{"name":"calculation","default_value":"5","external_name":"calculation","restriction":""},{"name":"warmup","default_value":"2","external_name":"warmup","restriction":""},{"name":"interactive","default_value":"STDOUT.tty?","external_name":"interactive","restriction":""}],"visibility":"Public","body":"new(calculation.seconds, warmup.seconds, !(!interactive))"},"external_var":false}],"instance_methods":[{"html_id":"execute:Nil-instance-method","name":"execute","abstract":false,"location":{"filename":"src/benchmark/ips.cr","line_number":40,"url":null},"def":{"name":"execute","return_type":"Nil","visibility":"Public","body":"run_warmup\nrun_calculation\nrun_comparison\n"},"external_var":false},{"html_id":"items:Array(Entry)-instance-method","name":"items","doc":"List of all entries in the benchmark.\nAfter `#execute`, these are populated with the resulting statistics.","summary":"<p>List of all entries in the benchmark.</p>","abstract":false,"location":{"filename":"src/benchmark/ips.cr","line_number":18,"url":null},"def":{"name":"items","return_type":"Array(Entry)","visibility":"Public","body":"@items"},"external_var":false},{"html_id":"items=(items:Array(Entry))-instance-method","name":"items=","doc":"List of all entries in the benchmark.\nAfter `#execute`, these are populated with the resulting statistics.","summary":"<p>List of all entries in the benchmark.</p>","abstract":false,"args":[{"name":"items","external_name":"items","restriction":"Array(Entry)"}],"args_string":"(items : Array(Entry))","args_html":"(items : <a href=\"../../Array.html\">Array</a>(<a href=\"../../Benchmark/IPS/Entry.html\">Entry</a>))","location":{"filename":"src/benchmark/ips.cr","line_number":18,"url":null},"def":{"name":"items=","args":[{"name":"items","external_name":"items","restriction":"Array(Entry)"}],"visibility":"Public","body":"@items = items"},"external_var":false},{"html_id":"report(label:String=\"\",&action:->):Benchmark::IPS::Entry-instance-method","name":"report","doc":"Adds code to be benchmarked","summary":"<p>Adds code to be benchmarked</p>","abstract":false,"args":[{"name":"label","default_value":"\"\"","external_name":"label","restriction":"String"}],"args_string":"(label : String = \"\", &action :  -> ) : Benchmark::IPS::Entry","args_html":"(label : <a href=\"../../String.html\">String</a> = <span class=\"s\">&quot;&quot;</span>, &action :  -> ) : <a href=\"../../Benchmark/IPS/Entry.html\">Benchmark::IPS::Entry</a>","location":{"filename":"src/benchmark/ips.cr","line_number":34,"url":null},"def":{"name":"report","args":[{"name":"label","default_value":"\"\"","external_name":"label","restriction":"String"}],"yields":0,"block_arity":0,"block_arg":{"name":"action","external_name":"action","restriction":"(->)"},"return_type":"Benchmark::IPS::Entry","visibility":"Public","body":"item = Entry.new(label, action)\n@items << item\nitem\n"},"external_var":false},{"html_id":"report:Nil-instance-method","name":"report","abstract":false,"location":{"filename":"src/benchmark/ips.cr","line_number":46,"url":null},"def":{"name":"report","return_type":"Nil","visibility":"Public","body":"max_label = ran_items.max_of do |__arg0| __arg0.label.size end\nmax_compare = ran_items.max_of do |__arg1| __arg1.human_compare.size end\nmax_bytes_per_op = ran_items.max_of do |__arg2| __arg2.bytes_per_op.humanize(base: 1024).size end\n\nran_items.each do |item|\n  printf(\"%s %s (%s) (±%5.2f%%)  %sB/op  %s\\n\", item.label.rjust(max_label), item.human_mean, item.human_iteration_time, item.relative_stddev, item.bytes_per_op.humanize(base: 1024).rjust(max_bytes_per_op), item.human_compare.rjust(max_compare))\nend\n"},"external_var":false}]}]}]},{"html_id":"Crystal/BigDecimal","path":"BigDecimal.html","kind":"struct","full_name":"BigDecimal","name":"BigDecimal","abstract":false,"superclass":{"html_id":"Crystal/Number","kind":"struct","full_name":"Number","name":"Number"},"ancestors":[{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Number","kind":"struct","full_name":"Number","name":"Number"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Steppable","kind":"module","full_name":"Steppable","name":"Steppable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/big.cr","line_number":11,"url":null},{"filename":"src/big/big_decimal.cr","line_number":19,"url":null},{"filename":"src/big/json.cr","line_number":67,"url":null},{"filename":"src/big/number.cr","line_number":14,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"constants":[{"id":"DEFAULT_MAX_DIV_ITERATIONS","name":"DEFAULT_MAX_DIV_ITERATIONS","value":"100_u64","summary":"<p><span class=\"flag red\">DEPRECATED</span>  Use <code><a href=\"BigDecimal.html#DEFAULT_PRECISION\">DEFAULT_PRECISION</a></code> instead</p>"},{"id":"DEFAULT_PRECISION","name":"DEFAULT_PRECISION","value":"100_u64"}],"included_modules":[{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"}],"doc":"A `BigDecimal` can represent arbitrarily large precision decimals.\n\nIt is internally represented by a pair of `BigInt` and `UInt64`: value and scale.\nValue contains the actual value, and scale tells the decimal point place.\nE.g. when value is `1234` and scale `2`, the result is `12.34`.\n\nNOTE: To use `BigDecimal`, you must explicitly import it with `require \"big\"`\n\nThe general idea and some of the arithmetic algorithms were adapted from\nthe MIT/APACHE-licensed [bigdecimal-rs](https://github.com/akubera/bigdecimal-rs).","summary":"<p>A <code><a href=\"BigDecimal.html\">BigDecimal</a></code> can represent arbitrarily large precision decimals.</p>","class_methods":[{"html_id":"from_json_object_key?(key:String):BigDecimal|Nil-class-method","name":"from_json_object_key?","abstract":false,"args":[{"name":"key","external_name":"key","restriction":"String"}],"args_string":"(key : String) : BigDecimal | Nil","args_html":"(key : <a href=\"String.html\">String</a>) : <a href=\"BigDecimal.html\">BigDecimal</a> | <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/big/json.cr","line_number":79,"url":null},"def":{"name":"from_json_object_key?","args":[{"name":"key","external_name":"key","restriction":"String"}],"return_type":"BigDecimal | ::Nil","visibility":"Public","body":"begin\n  new(key)\nrescue InvalidBigDecimalException\n  nil\nend"},"external_var":false}],"constructors":[{"html_id":"new(value:BigInt,scale:UInt64)-class-method","name":"new","doc":"Creates a new `BigDecimal` from `BigInt` *value* and `UInt64` *scale*,\nwhich matches the internal representation.","summary":"<p>Creates a new <code><a href=\"BigDecimal.html\">BigDecimal</a></code> from <code><a href=\"BigInt.html\">BigInt</a></code> <em>value</em> and <code><a href=\"UInt64.html\">UInt64</a></code> <em>scale</em>, which matches the internal representation.</p>","abstract":false,"args":[{"name":"value","external_name":"value","restriction":"BigInt"},{"name":"scale","external_name":"scale","restriction":"UInt64"}],"args_string":"(value : BigInt, scale : UInt64)","args_html":"(value : <a href=\"BigInt.html\">BigInt</a>, scale : <a href=\"UInt64.html\">UInt64</a>)","location":{"filename":"src/big/big_decimal.cr","line_number":62,"url":null},"def":{"name":"new","args":[{"name":"value","external_name":"value","restriction":"BigInt"},{"name":"scale","external_name":"scale","restriction":"UInt64"}],"visibility":"Public","body":"_ = allocate\n_.initialize(value, scale)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(ctx:YAML::ParseContext,node:YAML::Nodes::Node):self-class-method","name":"new","abstract":false,"args":[{"name":"ctx","external_name":"ctx","restriction":"YAML::ParseContext"},{"name":"node","external_name":"node","restriction":"YAML::Nodes::Node"}],"args_string":"(ctx : YAML::ParseContext, node : YAML::Nodes::Node) : self","args_html":"(ctx : <a href=\"YAML/ParseContext.html\">YAML::ParseContext</a>, node : <a href=\"YAML/Nodes/Node.html\">YAML::Nodes::Node</a>) : <span class=\"k\">self</span>","location":{"filename":"src/big/yaml.cr","line_number":20,"url":null},"def":{"name":"new","args":[{"name":"ctx","external_name":"ctx","restriction":"YAML::ParseContext"},{"name":"node","external_name":"node","restriction":"YAML::Nodes::Node"}],"return_type":"self","visibility":"Public","body":"if node.is_a?(YAML::Nodes::Scalar)\nelse\n  node.raise(\"Expected scalar, not #{node.class}\")\nend\n\nBigDecimal.new(node.value)\n"},"external_var":false},{"html_id":"new(num:Float):self-class-method","name":"new","doc":"Creates a new `BigDecimal` from `Float`.\n\nNOTE: Floats are fundamentally less precise than BigDecimals,\nwhich makes initialization from them risky.","summary":"<p>Creates a new <code><a href=\"BigDecimal.html\">BigDecimal</a></code> from <code><a href=\"Float.html\">Float</a></code>.</p>","abstract":false,"args":[{"name":"num","external_name":"num","restriction":"Float"}],"args_string":"(num : Float) : self","args_html":"(num : <a href=\"Float.html\">Float</a>) : <span class=\"k\">self</span>","location":{"filename":"src/big/big_decimal.cr","line_number":41,"url":null},"def":{"name":"new","args":[{"name":"num","external_name":"num","restriction":"Float"}],"return_type":"self","visibility":"Public","body":"if num.finite?\nelse\n  raise(ArgumentError.new(\"Can only construct from a finite number\"))\nend\nnew(num.to_s)\n"},"external_var":false},{"html_id":"new(num:BigRational):self-class-method","name":"new","doc":"Creates a new `BigDecimal` from `BigRational`.\n\nNOTE: BigRational are fundamentally more precise than BigDecimals,\nwhich makes initialization from them risky.","summary":"<p>Creates a new <code><a href=\"BigDecimal.html\">BigDecimal</a></code> from <code><a href=\"BigRational.html\">BigRational</a></code>.</p>","abstract":false,"args":[{"name":"num","external_name":"num","restriction":"BigRational"}],"args_string":"(num : BigRational) : self","args_html":"(num : <a href=\"BigRational.html\">BigRational</a>) : <span class=\"k\">self</span>","location":{"filename":"src/big/big_decimal.cr","line_number":50,"url":null},"def":{"name":"new","args":[{"name":"num","external_name":"num","restriction":"BigRational"}],"return_type":"self","visibility":"Public","body":"num.numerator.to_big_d / num.denominator.to_big_d"},"external_var":false},{"html_id":"new(num:BigDecimal):self-class-method","name":"new","doc":"Returns *num*. Useful for generic code that does `T.new(...)` with `T`\nbeing a `Number`.","summary":"<p>Returns <em>num</em>.</p>","abstract":false,"args":[{"name":"num","external_name":"num","restriction":"BigDecimal"}],"args_string":"(num : BigDecimal) : self","args_html":"(num : <a href=\"BigDecimal.html\">BigDecimal</a>) : <span class=\"k\">self</span>","location":{"filename":"src/big/big_decimal.cr","line_number":56,"url":null},"def":{"name":"new","args":[{"name":"num","external_name":"num","restriction":"BigDecimal"}],"return_type":"self","visibility":"Public","body":"num"},"external_var":false},{"html_id":"new(num:Int=0,scale:Int=0)-class-method","name":"new","doc":"Creates a new `BigDecimal` from `Int`.","summary":"<p>Creates a new <code><a href=\"BigDecimal.html\">BigDecimal</a></code> from <code><a href=\"Int.html\">Int</a></code>.</p>","abstract":false,"args":[{"name":"num","default_value":"0","external_name":"num","restriction":"Int"},{"name":"scale","default_value":"0","external_name":"scale","restriction":"Int"}],"args_string":"(num : Int = 0, scale : Int = 0)","args_html":"(num : <a href=\"Int.html\">Int</a> = <span class=\"n\">0</span>, scale : <a href=\"Int.html\">Int</a> = <span class=\"n\">0</span>)","location":{"filename":"src/big/big_decimal.cr","line_number":66,"url":null},"def":{"name":"new","args":[{"name":"num","default_value":"0","external_name":"num","restriction":"Int"},{"name":"scale","default_value":"0","external_name":"scale","restriction":"Int"}],"visibility":"Public","body":"_ = allocate\n_.initialize(num, scale)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(str:String)-class-method","name":"new","doc":"Creates a new `BigDecimal` from a `String`.\n\nAllows only valid number strings with an optional negative sign.","summary":"<p>Creates a new <code><a href=\"BigDecimal.html\">BigDecimal</a></code> from a <code><a href=\"String.html\">String</a></code>.</p>","abstract":false,"args":[{"name":"str","external_name":"str","restriction":"String"}],"args_string":"(str : String)","args_html":"(str : <a href=\"String.html\">String</a>)","location":{"filename":"src/big/big_decimal.cr","line_number":73,"url":null},"def":{"name":"new","args":[{"name":"str","external_name":"str","restriction":"String"}],"visibility":"Public","body":"_ = allocate\n_.initialize(str)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(pull:JSON::PullParser):self-class-method","name":"new","abstract":false,"args":[{"name":"pull","external_name":"pull","restriction":"JSON::PullParser"}],"args_string":"(pull : JSON::PullParser) : self","args_html":"(pull : <a href=\"JSON/PullParser.html\">JSON::PullParser</a>) : <span class=\"k\">self</span>","location":{"filename":"src/big/json.cr","line_number":68,"url":null},"def":{"name":"new","args":[{"name":"pull","external_name":"pull","restriction":"JSON::PullParser"}],"return_type":"self","visibility":"Public","body":"case pull.kind\nwhen .int?, .float?\n  value = pull.raw_value\n  pull.read_next\nelse\n  value = pull.read_string\nend\nnew(value)\n"},"external_var":false}],"instance_methods":[{"html_id":"%(other:BigDecimal):BigDecimal-instance-method","name":"%","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : BigDecimal","args_html":"(other : <a href=\"BigDecimal.html\">BigDecimal</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":204,"url":null},"def":{"name":"%","args":[{"name":"other","external_name":"other","restriction":"BigDecimal"}],"return_type":"BigDecimal","visibility":"Public","body":"if @scale > other.scale\n  scaled = other.scale_to(self)\n  BigDecimal.new(@value % scaled.value, @scale)\nelsif @scale < other.scale\n  scaled = scale_to(other)\n  BigDecimal.new(scaled.value % other.value, other.scale)\nelse\n  BigDecimal.new(@value % other.value, @scale)\nend"},"external_var":false},{"html_id":"%(other:Int)-instance-method","name":"%","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int)","args_html":"(other : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/big/big_decimal.cr","line_number":216,"url":null},"def":{"name":"%","args":[{"name":"other","external_name":"other","restriction":"Int"}],"visibility":"Public","body":"self % (BigDecimal.new(other))"},"external_var":false},{"html_id":"*(other:BigDecimal):BigDecimal-instance-method","name":"*","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : BigDecimal","args_html":"(other : <a href=\"BigDecimal.html\">BigDecimal</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":196,"url":null},"def":{"name":"*","args":[{"name":"other","external_name":"other","restriction":"BigDecimal"}],"return_type":"BigDecimal","visibility":"Public","body":"BigDecimal.new(@value * other.value, @scale + other.scale)"},"external_var":false},{"html_id":"*(other:Number):BigDecimal-instance-method","name":"*","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Number"}],"args_string":"(other : Number) : BigDecimal","args_html":"(other : <a href=\"Number.html\">Number</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":200,"url":null},"def":{"name":"*","args":[{"name":"other","external_name":"other","restriction":"Number"}],"return_type":"BigDecimal","visibility":"Public","body":"self * (BigDecimal.new(other))"},"external_var":false},{"html_id":"**(other:Int):BigDecimal-instance-method","name":"**","doc":"Raises the decimal to the *other*th power\n\n```\nrequire \"big\"\n\nBigDecimal.new(1234, 2) ** 2 # => 152.2756\n```","summary":"<p>Raises the decimal to the <em>other</em>th power</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigDecimal","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":401,"url":null},"def":{"name":"**","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigDecimal","visibility":"Public","body":"if other < 0\n  return (to_big_r ** other).to_big_d\nend\nBigDecimal.new(@value ** other, @scale * other)\n"},"external_var":false},{"html_id":"+(other:BigDecimal):BigDecimal-instance-method","name":"+","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : BigDecimal","args_html":"(other : <a href=\"BigDecimal.html\">BigDecimal</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":164,"url":null},"def":{"name":"+","args":[{"name":"other","external_name":"other","restriction":"BigDecimal"}],"return_type":"BigDecimal","visibility":"Public","body":"if @scale > other.scale\n  scaled = other.scale_to(self)\n  BigDecimal.new(@value + scaled.value, @scale)\nelsif @scale < other.scale\n  scaled = scale_to(other)\n  BigDecimal.new(scaled.value + other.value, other.scale)\nelse\n  BigDecimal.new(@value + other.value, @scale)\nend"},"external_var":false},{"html_id":"+(other:Number):BigDecimal-instance-method","name":"+","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Number"}],"args_string":"(other : Number) : BigDecimal","args_html":"(other : <a href=\"Number.html\">Number</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":176,"url":null},"def":{"name":"+","args":[{"name":"other","external_name":"other","restriction":"Number"}],"return_type":"BigDecimal","visibility":"Public","body":"self + (BigDecimal.new(other))"},"external_var":false},{"html_id":"-(other:BigDecimal):BigDecimal-instance-method","name":"-","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : BigDecimal","args_html":"(other : <a href=\"BigDecimal.html\">BigDecimal</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":180,"url":null},"def":{"name":"-","args":[{"name":"other","external_name":"other","restriction":"BigDecimal"}],"return_type":"BigDecimal","visibility":"Public","body":"if @scale > other.scale\n  scaled = other.scale_to(self)\n  BigDecimal.new(@value - scaled.value, @scale)\nelsif @scale < other.scale\n  scaled = scale_to(other)\n  BigDecimal.new(scaled.value - other.value, other.scale)\nelse\n  BigDecimal.new(@value - other.value, @scale)\nend"},"external_var":false},{"html_id":"-(other:Number):BigDecimal-instance-method","name":"-","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Number"}],"args_string":"(other : Number) : BigDecimal","args_html":"(other : <a href=\"Number.html\">Number</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":192,"url":null},"def":{"name":"-","args":[{"name":"other","external_name":"other","restriction":"Number"}],"return_type":"BigDecimal","visibility":"Public","body":"self - (BigDecimal.new(other))"},"external_var":false},{"html_id":"-:BigDecimal-instance-method","name":"-","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":160,"url":null},"def":{"name":"-","return_type":"BigDecimal","visibility":"Public","body":"BigDecimal.new(-@value, @scale)"},"external_var":false},{"html_id":"/(other:BigDecimal):BigDecimal-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : BigDecimal","args_html":"(other : <a href=\"BigDecimal.html\">BigDecimal</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":220,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"BigDecimal"}],"return_type":"BigDecimal","visibility":"Public","body":"div(other)"},"external_var":false},{"html_id":"/(other:BigInt):BigDecimal-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigDecimal","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":224,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"},"external_var":false},{"html_id":"/(other:BigFloat):BigDecimal-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigFloat"}],"args_string":"(other : BigFloat) : BigDecimal","args_html":"(other : <a href=\"BigFloat.html\">BigFloat</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":224,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"BigFloat"}],"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"},"external_var":false},{"html_id":"/(other:BigRational):BigRational-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational) : BigRational","args_html":"(other : <a href=\"BigRational.html\">BigRational</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_decimal.cr","line_number":225,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"},"external_var":false},{"html_id":"/(other:Int8):BigDecimal-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int8"}],"args_string":"(other : Int8) : BigDecimal","args_html":"(other : <a href=\"Int8.html\">Int8</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/number.cr","line_number":15,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"Int8"}],"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"},"external_var":false},{"html_id":"/(other:UInt8):BigDecimal-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"UInt8"}],"args_string":"(other : UInt8) : BigDecimal","args_html":"(other : <a href=\"UInt8.html\">UInt8</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/number.cr","line_number":15,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"UInt8"}],"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"},"external_var":false},{"html_id":"/(other:Int16):BigDecimal-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int16"}],"args_string":"(other : Int16) : BigDecimal","args_html":"(other : <a href=\"Int16.html\">Int16</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/number.cr","line_number":15,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"Int16"}],"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"},"external_var":false},{"html_id":"/(other:UInt16):BigDecimal-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"UInt16"}],"args_string":"(other : UInt16) : BigDecimal","args_html":"(other : <a href=\"UInt16.html\">UInt16</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/number.cr","line_number":15,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"UInt16"}],"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal\n  .new(self)) / (BigDecimal\n  .new(other))"},"external_var":false},{"html_id":"/(other:Int32):BigDecimal-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int32"}],"args_string":"(other : Int32) : BigDecimal","args_html":"(other : <a href=\"Int32.html\">Int32</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/number.cr","line_number":15,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"Int32"}],"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal\n  .new(self)) / (BigDecimal\n  .new(other))"},"external_var":false},{"html_id":"/(other:UInt32):BigDecimal-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"UInt32"}],"args_string":"(other : UInt32) : BigDecimal","args_html":"(other : <a href=\"UInt32.html\">UInt32</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/number.cr","line_number":15,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"UInt32"}],"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal\n  .new(self)) / (BigDecimal\n  .new(other))"},"external_var":false},{"html_id":"/(other:Int64):BigDecimal-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int64"}],"args_string":"(other : Int64) : BigDecimal","args_html":"(other : <a href=\"Int64.html\">Int64</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/number.cr","line_number":15,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"Int64"}],"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal\n  .new(self)) / (BigDecimal\n  .new(other))"},"external_var":false},{"html_id":"/(other:UInt64):BigDecimal-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"UInt64"}],"args_string":"(other : UInt64) : BigDecimal","args_html":"(other : <a href=\"UInt64.html\">UInt64</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/number.cr","line_number":15,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"UInt64"}],"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal\n  .new(self)) / (BigDecimal\n  .new(other))"},"external_var":false},{"html_id":"/(other:Int128):BigDecimal-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int128"}],"args_string":"(other : Int128) : BigDecimal","args_html":"(other : <a href=\"Int128.html\">Int128</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/number.cr","line_number":15,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"Int128"}],"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal\n  .new(self)) / (BigDecimal\n  .new(other))"},"external_var":false},{"html_id":"/(other:UInt128):BigDecimal-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"UInt128"}],"args_string":"(other : UInt128) : BigDecimal","args_html":"(other : <a href=\"UInt128.html\">UInt128</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/number.cr","line_number":15,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"UInt128"}],"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal\n  .new(self)) / (BigDecimal\n  .new(other))"},"external_var":false},{"html_id":"/(other:Float32):BigDecimal-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Float32"}],"args_string":"(other : Float32) : BigDecimal","args_html":"(other : <a href=\"Float32.html\">Float32</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/number.cr","line_number":16,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"Float32"}],"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"},"external_var":false},{"html_id":"/(other:Float64):BigDecimal-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Float64"}],"args_string":"(other : Float64) : BigDecimal","args_html":"(other : <a href=\"Float64.html\">Float64</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/number.cr","line_number":16,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"Float64"}],"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"},"external_var":false},{"html_id":"<=>(other:BigDecimal):Int32-instance-method","name":"<=>","doc":"The comparison operator. Returns `0` if the two objects are equal,\na negative number if this object is considered less than *other*,\na positive number if this object is considered greater than *other*,\nor `nil` if the two objects are not comparable.\n\nSubclasses define this method to provide class-specific ordering.\n\nThe comparison operator is usually used to sort values:\n\n```\n# Sort in a descending way:\n[3, 1, 2].sort { |x, y| y <=> x } # => [3, 2, 1]\n\n# Sort in an ascending way:\n[3, 1, 2].sort { |x, y| x <=> y } # => [1, 2, 3]\n```","summary":"<p>The comparison operator.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : Int32","args_html":"(other : <a href=\"BigDecimal.html\">BigDecimal</a>) : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/big/big_decimal.cr","line_number":319,"url":null},"def":{"name":"<=>","args":[{"name":"other","external_name":"other","restriction":"BigDecimal"}],"return_type":"Int32","visibility":"Public","body":"if @scale > other.scale\n  @value <=> (other.scale_to(self)).value\nelsif @scale < other.scale\n  (scale_to(other)).value <=> other.value\nelse\n  @value <=> other.value\nend"},"external_var":false},{"html_id":"<=>(other:BigRational):Int32-instance-method","name":"<=>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational) : Int32","args_html":"(other : <a href=\"BigRational.html\">BigRational</a>) : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/big/big_decimal.cr","line_number":329,"url":null},"def":{"name":"<=>","args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"return_type":"Int32","visibility":"Public","body":"if @scale == 0\n  @value <=> other\nelse\n  (@value * other.denominator) <=> ((power_ten_to(@scale)) * other.numerator)\nend"},"external_var":false},{"html_id":"<=>(other:Float::Primitive):Int32|Nil-instance-method","name":"<=>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Float::Primitive"}],"args_string":"(other : Float::Primitive) : Int32 | Nil","args_html":"(other : <a href=\"Float/Primitive.html\">Float::Primitive</a>) : <a href=\"Int32.html\">Int32</a> | <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/big/big_decimal.cr","line_number":338,"url":null},"def":{"name":"<=>","args":[{"name":"other","external_name":"other","restriction":"Float::Primitive"}],"return_type":"Int32 | ::Nil","visibility":"Public","body":"if other.nan?\n  return nil\nend\n\nif sign = other.infinite?\n  return -sign\nend\n\nself <=> other.to_big_r\n"},"external_var":false},{"html_id":"<=>(other:BigFloat):Int32-instance-method","name":"<=>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigFloat"}],"args_string":"(other : BigFloat) : Int32","args_html":"(other : <a href=\"BigFloat.html\">BigFloat</a>) : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/big/big_decimal.cr","line_number":348,"url":null},"def":{"name":"<=>","args":[{"name":"other","external_name":"other","restriction":"BigFloat"}],"return_type":"Int32","visibility":"Public","body":"self <=> other.to_big_r"},"external_var":false},{"html_id":"<=>(other:Int):Int32-instance-method","name":"<=>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : Int32","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/big/big_decimal.cr","line_number":352,"url":null},"def":{"name":"<=>","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"Int32","visibility":"Public","body":"self <=> (BigDecimal.new(other))"},"external_var":false},{"html_id":"==(other:BigDecimal):Bool-instance-method","name":"==","doc":"Compares this object to *other* based on the receiver’s `<=>` method,\nreturning `true` if it returns `0`.\n\nAlso returns `true` if this and *other* are the same object.","summary":"<p>Compares this object to <em>other</em> based on the receiver’s <code>&lt;=&gt;</code> method, returning <code>true</code> if it returns <code>0</code>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : Bool","args_html":"(other : <a href=\"BigDecimal.html\">BigDecimal</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/big/big_decimal.cr","line_number":356,"url":null},"def":{"name":"==","args":[{"name":"other","external_name":"other","restriction":"BigDecimal"}],"return_type":"Bool","visibility":"Public","body":"case @scale\nwhen .>(other.scale)\n  scaled = other.value * (power_ten_to(@scale - other.scale))\n  @value == scaled\nwhen .<(other.scale)\n  scaled = @value * (power_ten_to(other.scale - @scale))\n  scaled == other.value\nelse\n  @value == other.value\nend"},"external_var":false},{"html_id":"ceil:BigDecimal-instance-method","name":"ceil","doc":"Rounds towards positive infinity.","summary":"<p>Rounds towards positive infinity.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":407,"url":null},"def":{"name":"ceil","return_type":"BigDecimal","visibility":"Public","body":"round_impl do |rem| rem > 0 end"},"external_var":false},{"html_id":"clone-instance-method","name":"clone","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":734,"url":null},"def":{"name":"clone","visibility":"Public","body":"self"},"external_var":false},{"html_id":"div(other:BigDecimal,precision:Int=DEFAULT_PRECISION):BigDecimal-instance-method","name":"div","doc":"Divides `self` with another `BigDecimal`, with an optionally configurable\n*precision*.\n\nWhen the division is inexact, the returned value rounds towards negative\ninfinity, and its scale is never greater than\n`scale - other.scale + precision`.\n\n```\nBigDecimal.new(1).div(BigDecimal.new(2))    # => BigDecimal(@value=5, @scale=2)\nBigDecimal.new(1).div(BigDecimal.new(3), 5) # => BigDecimal(@value=33333, @scale=5)\n```","summary":"<p>Divides <code>self</code> with another <code><a href=\"BigDecimal.html\">BigDecimal</a></code>, with an optionally configurable <em>precision</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigDecimal"},{"name":"precision","default_value":"DEFAULT_PRECISION","external_name":"precision","restriction":"Int"}],"args_string":"(other : BigDecimal, precision : Int = DEFAULT_PRECISION) : BigDecimal","args_html":"(other : <a href=\"BigDecimal.html\">BigDecimal</a>, precision : <a href=\"Int.html\">Int</a> = <span class=\"t\">DEFAULT_PRECISION</span>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":238,"url":null},"def":{"name":"div","args":[{"name":"other","external_name":"other","restriction":"BigDecimal"},{"name":"precision","default_value":"DEFAULT_PRECISION","external_name":"precision","restriction":"Int"}],"return_type":"BigDecimal","visibility":"Public","body":"check_division_by_zero(other)\nif @value.zero?\n  return self\nend\nother.factor_powers_of_ten\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nnumerator, denominator = @value, other.@value\nscale = if @scale >= other.scale\n  @scale - other.scale\nelse\n  numerator = numerator * (power_ten_to(other.scale - @scale))\n  0\nend\n\n\nquotient, remainder = numerator.divmod(denominator)\nif remainder.zero?\n  return BigDecimal.new(normalize_quotient(other, quotient), scale)\nend\n\n\ndenominator_reduced, denominator_exp2 = denominator.factor_by(TWO_I)\n\n\n\ncase denominator_reduced\nwhen 1\n  denominator_exp5 = 0_u64\nwhen 5\n  denominator_reduced = denominator_reduced // FIVE_I\n  denominator_exp5 = 1_u64\nwhen 25\n  denominator_reduced = (denominator_reduced // FIVE_I) // FIVE_I\n  denominator_exp5 = 2_u64\nelse\n  denominator_reduced, denominator_exp5 = denominator_reduced.factor_by(FIVE_I)\nend\n\nif denominator_reduced != 1\n  scale_add = precision.to_u64\nelsif denominator_exp2 <= 1 && denominator_exp5 <= 1\n  quotient = (numerator * TEN_I) // denominator\n  return BigDecimal.new(normalize_quotient(other, quotient), scale + 1)\nelse\n  _, numerator_exp10 = remainder.factor_by(TEN_I)\n  scale_add = {denominator_exp2, denominator_exp5}.max - numerator_exp10\n  if scale_add > precision\n    scale_add = precision.to_u64\n  end\nend\n\nquotient = (numerator * (power_ten_to(scale_add))) // denominator\nBigDecimal.new(normalize_quotient(other, quotient), scale + scale_add)\n"},"external_var":false},{"html_id":"div(other:BigDecimal,*,max_div_iterations=DEFAULT_MAX_DIV_ITERATIONS):BigDecimal-instance-method","name":"div","doc":"Divides `self` with another `BigDecimal`, with an optionally configurable\n*precision*.\n\nWhen the division is inexact, the returned value rounds towards negative\ninfinity, and its scale is never greater than\n`scale - other.scale + precision`.\n\n```\nBigDecimal.new(1).div(BigDecimal.new(2))    # => BigDecimal(@value=5, @scale=2)\nBigDecimal.new(1).div(BigDecimal.new(3), 5) # => BigDecimal(@value=33333, @scale=5)\n```","summary":"<p>Divides <code>self</code> with another <code><a href=\"BigDecimal.html\">BigDecimal</a></code>, with an optionally configurable <em>precision</em>.</p>\n<p><span class=\"flag red\">DEPRECATED</span>  Use <code><a href=\"BigDecimal.html#div%28other%3ABigDecimal%2Cprecision%3AInt%3DDEFAULT_PRECISION%29%3ABigDecimal-instance-method\">#div(other : BigDecimal, precision = DEFAULT_PRECISION)</a></code> instead</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigDecimal"},{"name":"","external_name":"","restriction":""},{"name":"max_div_iterations","default_value":"DEFAULT_MAX_DIV_ITERATIONS","external_name":"max_div_iterations","restriction":""}],"args_string":"(other : BigDecimal, *, max_div_iterations = DEFAULT_MAX_DIV_ITERATIONS) : BigDecimal","args_html":"(other : <a href=\"BigDecimal.html\">BigDecimal</a>, *, max_div_iterations = <span class=\"t\">DEFAULT_MAX_DIV_ITERATIONS</span>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":315,"url":null},"def":{"name":"div","args":[{"name":"other","external_name":"other","restriction":"BigDecimal"},{"name":"","external_name":"","restriction":""},{"name":"max_div_iterations","default_value":"DEFAULT_MAX_DIV_ITERATIONS","external_name":"max_div_iterations","restriction":""}],"splat_index":1,"return_type":"BigDecimal","visibility":"Public","body":"div(other, max_div_iterations)"},"external_var":false},{"html_id":"floor:BigDecimal-instance-method","name":"floor","doc":"Rounds towards negative infinity.","summary":"<p>Rounds towards negative infinity.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":412,"url":null},"def":{"name":"floor","return_type":"BigDecimal","visibility":"Public","body":"round_impl do |rem| rem < 0 end"},"external_var":false},{"html_id":"format(io:IO,separator='.',delimiter=',',decimal_places:Int|Nil=nil,*,group:Int=3,only_significant:Bool=false):Nil-instance-method","name":"format","doc":"Prints this number as a `String` using a customizable format.\n\n*separator* is used as decimal separator, *delimiter* as thousands\ndelimiter between batches of *group* digits.\n\nIf *decimal_places* is `nil`, all significant decimal places are printed\n(similar to `#to_s`). If the argument has a numeric value, the number of\nvisible decimal places will be fixed to that amount.\n\nTrailing zeros are omitted if *only_significant* is `true`.\n\n```\n123_456.789.format                                            # => \"123,456.789\"\n123_456.789.format(',', '.')                                  # => \"123.456,789\"\n123_456.789.format(decimal_places: 2)                         # => \"123,456.79\"\n123_456.789.format(decimal_places: 6)                         # => \"123,456.789000\"\n123_456.789.format(decimal_places: 6, only_significant: true) # => \"123,456.789\"\n```","summary":"<p>Prints this number as a <code><a href=\"String.html\">String</a></code> using a customizable format.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"separator","default_value":"'.'","external_name":"separator","restriction":""},{"name":"delimiter","default_value":"','","external_name":"delimiter","restriction":""},{"name":"decimal_places","default_value":"nil","external_name":"decimal_places","restriction":"Int | ::Nil"},{"name":"","external_name":"","restriction":""},{"name":"group","default_value":"3","external_name":"group","restriction":"Int"},{"name":"only_significant","default_value":"false","external_name":"only_significant","restriction":"Bool"}],"args_string":"(io : IO, separator = '.', delimiter = ',', decimal_places : Int | Nil = nil, *, group : Int = 3, only_significant : Bool = false) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>, separator = <span class=\"s\">&#39;.&#39;</span>, delimiter = <span class=\"s\">&#39;,&#39;</span>, decimal_places : <a href=\"Int.html\">Int</a> | <a href=\"Nil.html\">Nil</a> = <span class=\"n\">nil</span>, *, group : <a href=\"Int.html\">Int</a> = <span class=\"n\">3</span>, only_significant : <a href=\"Bool.html\">Bool</a> = <span class=\"n\">false</span>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/big/big_decimal.cr","line_number":526,"url":null},"def":{"name":"format","args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"separator","default_value":"'.'","external_name":"separator","restriction":""},{"name":"delimiter","default_value":"','","external_name":"delimiter","restriction":""},{"name":"decimal_places","default_value":"nil","external_name":"decimal_places","restriction":"Int | ::Nil"},{"name":"","external_name":"","restriction":""},{"name":"group","default_value":"3","external_name":"group","restriction":"Int"},{"name":"only_significant","default_value":"false","external_name":"only_significant","restriction":"Bool"}],"splat_index":4,"return_type":"Nil","visibility":"Public","body":"number = self\nif decimal_places\n  number = number.round(decimal_places)\nend\n\nif decimal_places && decimal_places >= 0\n  string = number.abs.to_s_impl(point_range: ..)\n  integer, _, decimals = string.partition('.')\nelse\n  string = number.to_s_impl(point_range: ..)\n  _, _, decimals = string.partition(\".\")\n  integer = number.trunc.to_big_i.abs.to_s\nend\n\nis_negative = number < 0\n\nformat_impl(io, is_negative, integer, decimals, separator, delimiter, decimal_places, group, only_significant)\n"},"external_var":false},{"html_id":"integer?:Bool-instance-method","name":"integer?","doc":"Returns `true` if `self` is an integer.\n\nNon-integer types may return `true` as long as `self` denotes a finite value\nwithout any fractional parts.\n\n```\n1.integer?       # => true\n1.0.integer?     # => true\n1.2.integer?     # => false\n(1 / 0).integer? # => false\n(0 / 0).integer? # => false\n```","summary":"<p>Returns <code>true</code> if <code>self</code> is an integer.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":463,"url":null},"def":{"name":"integer?","return_type":"Bool","visibility":"Public","body":"factor_powers_of_ten\nscale == 0\n"},"external_var":false},{"html_id":"normalize_quotient(other:BigDecimal,quotient:BigInt):BigInt-instance-method","name":"normalize_quotient","doc":"Returns the *quotient* as absolutely negative if `self` and *other* have\ndifferent signs, otherwise returns the *quotient*.","summary":"<p>Returns the <em>quotient</em> as absolutely negative if <code>self</code> and <em>other</em> have different signs, otherwise returns the <em>quotient</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigDecimal"},{"name":"quotient","external_name":"quotient","restriction":"BigInt"}],"args_string":"(other : BigDecimal, quotient : BigInt) : BigInt","args_html":"(other : <a href=\"BigDecimal.html\">BigDecimal</a>, quotient : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_decimal.cr","line_number":740,"url":null},"def":{"name":"normalize_quotient","args":[{"name":"other","external_name":"other","restriction":"BigDecimal"},{"name":"quotient","external_name":"quotient","restriction":"BigInt"}],"return_type":"BigInt","visibility":"Public","body":"if (@value < 0 && other.value > 0) || (other.value < 0 && @value > 0)\n  -quotient.abs\nelse\n  quotient\nend"},"external_var":false},{"html_id":"round(digits:Number,base=10,*,mode:RoundingMode=:ties_even):BigDecimal-instance-method","name":"round","doc":"Rounds this number to a given precision.\n\nRounds to the specified number of *digits* after the decimal place,\n(or before if negative), in base *base*.\n\nThe rounding *mode* controls the direction of the rounding. The default is\n`RoundingMode::TIES_EVEN` which rounds to the nearest integer, with ties\n(fractional value of `0.5`) being rounded to the even neighbor (Banker's rounding).\n\n```\n-1763.116.round(2) # => -1763.12\n```","summary":"<p>Rounds this number to a given precision.</p>","abstract":false,"args":[{"name":"digits","external_name":"digits","restriction":"Number"},{"name":"base","default_value":"10","external_name":"base","restriction":""},{"name":"","external_name":"","restriction":""},{"name":"mode","default_value":":ties_even","external_name":"mode","restriction":"RoundingMode"}],"args_string":"(digits : Number, base = 10, *, mode : RoundingMode = :ties_even) : BigDecimal","args_html":"(digits : <a href=\"Number.html\">Number</a>, base = <span class=\"n\">10</span>, *, mode : <a href=\"Number/RoundingMode.html\">RoundingMode</a> = <span class=\"n\">:ties_even</span>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":468,"url":null},"def":{"name":"round","args":[{"name":"digits","external_name":"digits","restriction":"Number"},{"name":"base","default_value":"10","external_name":"base","restriction":""},{"name":"","external_name":"","restriction":""},{"name":"mode","default_value":":ties_even","external_name":"mode","restriction":"RoundingMode"}],"splat_index":2,"return_type":"BigDecimal","visibility":"Public","body":"if zero?\n  return self\nend\n\nif base == 10\n  if @scale <= digits\n    return self\n  end\n\n\n  shifted = mul_power_of_ten(digits)\n  rounded = shifted.round(mode)\n  rounded.mul_power_of_ten(-digits)\nelse\n  if digits < 0\n    multiplier = base.to_big_d ** digits.abs\n    shifted = self / multiplier\n  else\n    multiplier = base.to_big_d ** digits\n    shifted = self * multiplier\n  end\n\n  rounded = shifted.round(mode)\n\n  if digits < 0\n    result = rounded * multiplier\n  else\n    result = rounded / multiplier\n  end\n\n  BigDecimal.new(result)\nend\n"},"external_var":false},{"html_id":"round_away:BigDecimal-instance-method","name":"round_away","doc":"Rounds towards the nearest integer. If both neighboring integers are equidistant,\nrounds away from zero.","summary":"<p>Rounds towards the nearest integer.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":440,"url":null},"def":{"name":"round_away","return_type":"BigDecimal","visibility":"Public","body":"round_impl do |rem, rem_range| rem.abs >= (rem_range // 2) end"},"external_var":false},{"html_id":"round_even:BigDecimal-instance-method","name":"round_even","doc":"Rounds towards the nearest integer. If both neighboring integers are equidistant,\nrounds towards the even neighbor (Banker's rounding).","summary":"<p>Rounds towards the nearest integer.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":423,"url":null},"def":{"name":"round_even","return_type":"BigDecimal","visibility":"Public","body":"round_impl do |rem, rem_range, mantissa|\n  case rem.abs <=> (rem_range // 2)\n  when .<(0)\n    false\n  when .>(0)\n    true\n  else\n    mantissa.to_i!.odd?\n  end\nend"},"external_var":false},{"html_id":"scale:UInt64-instance-method","name":"scale","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":35,"url":null},"def":{"name":"scale","return_type":"UInt64","visibility":"Public","body":"@scale"},"external_var":false},{"html_id":"scale_to(new_scale:BigDecimal):BigDecimal-instance-method","name":"scale_to","doc":"Scales a `BigDecimal` to another `BigDecimal`, so they can be\ncomputed easier.","summary":"<p>Scales a <code><a href=\"BigDecimal.html\">BigDecimal</a></code> to another <code><a href=\"BigDecimal.html\">BigDecimal</a></code>, so they can be computed easier.</p>","abstract":false,"args":[{"name":"new_scale","external_name":"new_scale","restriction":"BigDecimal"}],"args_string":"(new_scale : BigDecimal) : BigDecimal","args_html":"(new_scale : <a href=\"BigDecimal.html\">BigDecimal</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":375,"url":null},"def":{"name":"scale_to","args":[{"name":"new_scale","external_name":"new_scale","restriction":"BigDecimal"}],"return_type":"BigDecimal","visibility":"Public","body":"in_scale(new_scale.scale)"},"external_var":false},{"html_id":"to_big_d-instance-method","name":"to_big_d","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":556,"url":null},"def":{"name":"to_big_d","visibility":"Public","body":"self"},"external_var":false},{"html_id":"to_big_f-instance-method","name":"to_big_f","doc":"Converts to `BigFloat`.","summary":"<p>Converts to <code><a href=\"BigFloat.html\">BigFloat</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":552,"url":null},"def":{"name":"to_big_f","visibility":"Public","body":"BigFloat.new(to_s)"},"external_var":false},{"html_id":"to_big_i:BigInt-instance-method","name":"to_big_i","doc":"Converts to `BigInt`. Truncates anything on the right side of the decimal point.","summary":"<p>Converts to <code><a href=\"BigInt.html\">BigInt</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":547,"url":null},"def":{"name":"to_big_i","return_type":"BigInt","visibility":"Public","body":"trunc.value"},"external_var":false},{"html_id":"to_big_r:BigRational-instance-method","name":"to_big_r","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":560,"url":null},"def":{"name":"to_big_r","return_type":"BigRational","visibility":"Public","body":"BigRational.new(@value, power_ten_to(@scale))"},"external_var":false},{"html_id":"to_f:Float64-instance-method","name":"to_f","doc":"Converts to `Float64`.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"Float64.html\">Float64</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":712,"url":null},"def":{"name":"to_f","return_type":"Float64","visibility":"Public","body":"to_f64"},"external_var":false},{"html_id":"to_f!:Float64-instance-method","name":"to_f!","doc":"Converts to `Float64`.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"Float64.html\">Float64</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":730,"url":null},"def":{"name":"to_f!","return_type":"Float64","visibility":"Public","body":"to_f64!"},"external_var":false},{"html_id":"to_f32:Float32-instance-method","name":"to_f32","doc":"Converts to `Float32`.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"Float32.html\">Float32</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":706,"url":null},"def":{"name":"to_f32","return_type":"Float32","visibility":"Public","body":"to_f64.to_f32"},"external_var":false},{"html_id":"to_f32!-instance-method","name":"to_f32!","doc":"Converts to `Float32`.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"Float32.html\">Float32</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":718,"url":null},"def":{"name":"to_f32!","visibility":"Public","body":"to_f64.to_f32!"},"external_var":false},{"html_id":"to_f64:Float64-instance-method","name":"to_f64","doc":"Converts to `Float64`.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"Float64.html\">Float64</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":700,"url":null},"def":{"name":"to_f64","return_type":"Float64","visibility":"Public","body":"to_s.to_f64"},"external_var":false},{"html_id":"to_f64!:Float64-instance-method","name":"to_f64!","doc":"Converts to `Float64`.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"Float64.html\">Float64</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":724,"url":null},"def":{"name":"to_f64!","return_type":"Float64","visibility":"Public","body":"to_f64"},"external_var":false},{"html_id":"to_i:Int32-instance-method","name":"to_i","doc":"Converts to `Int32`. Truncates anything on the right side of the decimal point.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"Int32.html\">Int32</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":590,"url":null},"def":{"name":"to_i","return_type":"Int32","visibility":"Public","body":"to_i32"},"external_var":false},{"html_id":"to_i!:Int32-instance-method","name":"to_i!","doc":"Converts to `Int32`. Truncates anything on the right side of the decimal point.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"Int32.html\">Int32</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":620,"url":null},"def":{"name":"to_i!","return_type":"Int32","visibility":"Public","body":"to_i32!"},"external_var":false},{"html_id":"to_i16:Int16-instance-method","name":"to_i16","doc":"Converts to `Int16`. Truncates anything on the right side of the decimal point.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"Int16.html\">Int16</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":578,"url":null},"def":{"name":"to_i16","return_type":"Int16","visibility":"Public","body":"to_big_i.to_i16"},"external_var":false},{"html_id":"to_i16!-instance-method","name":"to_i16!","doc":"Converts to `Int16`. Truncates anything on the right side of the decimal point.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"Int16.html\">Int16</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":602,"url":null},"def":{"name":"to_i16!","visibility":"Public","body":"to_big_i.to_i16!"},"external_var":false},{"html_id":"to_i32:Int32-instance-method","name":"to_i32","doc":"Converts to `Int32`. Truncates anything on the right side of the decimal point.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"Int32.html\">Int32</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":572,"url":null},"def":{"name":"to_i32","return_type":"Int32","visibility":"Public","body":"to_big_i.to_i32"},"external_var":false},{"html_id":"to_i32!:Int32-instance-method","name":"to_i32!","doc":"Converts to `Int32`. Truncates anything on the right side of the decimal point.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"Int32.html\">Int32</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":608,"url":null},"def":{"name":"to_i32!","return_type":"Int32","visibility":"Public","body":"to_big_i.to_i32!"},"external_var":false},{"html_id":"to_i64:Int64-instance-method","name":"to_i64","doc":"Converts to `Int64`. Truncates anything on the right side of the decimal point.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"Int64.html\">Int64</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":566,"url":null},"def":{"name":"to_i64","return_type":"Int64","visibility":"Public","body":"to_big_i.to_i64"},"external_var":false},{"html_id":"to_i64!-instance-method","name":"to_i64!","doc":"Converts to `Int64`. Truncates anything on the right side of the decimal point.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"Int64.html\">Int64</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":614,"url":null},"def":{"name":"to_i64!","visibility":"Public","body":"to_big_i.to_i64!"},"external_var":false},{"html_id":"to_i8:Int8-instance-method","name":"to_i8","doc":"Converts to `Int8`. Truncates anything on the right side of the decimal point.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"Int8.html\">Int8</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":584,"url":null},"def":{"name":"to_i8","return_type":"Int8","visibility":"Public","body":"to_big_i.to_i8"},"external_var":false},{"html_id":"to_i8!-instance-method","name":"to_i8!","doc":"Converts to `Int8`. Truncates anything on the right side of the decimal point.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"Int8.html\">Int8</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":596,"url":null},"def":{"name":"to_i8!","visibility":"Public","body":"to_big_i.to_i8!"},"external_var":false},{"html_id":"to_json(json:JSON::Builder):Nil-instance-method","name":"to_json","abstract":false,"args":[{"name":"json","external_name":"json","restriction":"JSON::Builder"}],"args_string":"(json : JSON::Builder) : Nil","args_html":"(json : <a href=\"JSON/Builder.html\">JSON::Builder</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/big/json.cr","line_number":89,"url":null},"def":{"name":"to_json","args":[{"name":"json","external_name":"json","restriction":"JSON::Builder"}],"return_type":"Nil","visibility":"Public","body":"json.number(self)"},"external_var":false},{"html_id":"to_json_object_key-instance-method","name":"to_json_object_key","abstract":false,"location":{"filename":"src/big/json.cr","line_number":85,"url":null},"def":{"name":"to_json_object_key","visibility":"Public","body":"to_s"},"external_var":false},{"html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Prints a nicely readable and concise string representation of this object,\ntypically intended for users, to *io*.\n\nThis method is called when an object is interpolated in a string literal:\n```\n\"foo #{bar} baz\" # calls bar.to_io with the builder for this string\n```\n\n`IO#<<` calls this method to append an object to itself:\n```\nio << bar # calls bar.to_s(io)\n```\n\nThus implementations must not interpolate `self` in a string literal or call\n`io << self` which both would lead to an endless loop.\n\nAlso see `#inspect(IO)`.","summary":"<p>Prints a nicely readable and concise string representation of this object, typically intended for users, to <em>io</em>.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/big/big_decimal.cr","line_number":502,"url":null},"def":{"name":"to_s","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"to_s_impl(io, point_range: -3..15)"},"external_var":false},{"html_id":"to_u:UInt32-instance-method","name":"to_u","doc":"Converts to `UInt32`. Truncates anything on the right side of the decimal point.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"UInt32.html\">UInt32</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":659,"url":null},"def":{"name":"to_u","return_type":"UInt32","visibility":"Public","body":"to_u32"},"external_var":false},{"html_id":"to_u!:UInt32-instance-method","name":"to_u!","doc":"Converts to `UInt32`. Truncates anything on the right side of the decimal point,\nconverting negative to positive.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"UInt32.html\">UInt32</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":694,"url":null},"def":{"name":"to_u!","return_type":"UInt32","visibility":"Public","body":"to_u32!"},"external_var":false},{"html_id":"to_u16:UInt16-instance-method","name":"to_u16","doc":"Converts to `UInt16`. Truncates anything on the right side of the decimal point.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"UInt16.html\">UInt16</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":647,"url":null},"def":{"name":"to_u16","return_type":"UInt16","visibility":"Public","body":"to_big_u.to_u16"},"external_var":false},{"html_id":"to_u16!-instance-method","name":"to_u16!","doc":"Converts to `UInt16`. Truncates anything on the right side of the decimal point,\nconverting negative to positive.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"UInt16.html\">UInt16</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":673,"url":null},"def":{"name":"to_u16!","visibility":"Public","body":"to_big_u!.to_u16!"},"external_var":false},{"html_id":"to_u32:UInt32-instance-method","name":"to_u32","doc":"Converts to `UInt32`. Truncates anything on the right side of the decimal point.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"UInt32.html\">UInt32</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":641,"url":null},"def":{"name":"to_u32","return_type":"UInt32","visibility":"Public","body":"to_big_u.to_u32"},"external_var":false},{"html_id":"to_u32!:UInt32-instance-method","name":"to_u32!","doc":"Converts to `UInt32`. Truncates anything on the right side of the decimal point,\nconverting negative to positive.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"UInt32.html\">UInt32</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":680,"url":null},"def":{"name":"to_u32!","return_type":"UInt32","visibility":"Public","body":"to_big_u!.to_u32!"},"external_var":false},{"html_id":"to_u64:UInt64-instance-method","name":"to_u64","doc":"Converts to `UInt64`. Truncates anything on the right side of the decimal point.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"UInt64.html\">UInt64</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":635,"url":null},"def":{"name":"to_u64","return_type":"UInt64","visibility":"Public","body":"to_big_u.to_u64"},"external_var":false},{"html_id":"to_u64!-instance-method","name":"to_u64!","doc":"Converts to `UInt64`. Truncates anything on the right side of the decimal point,\nconverting negative to positive.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"UInt64.html\">UInt64</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":687,"url":null},"def":{"name":"to_u64!","visibility":"Public","body":"to_big_u!.to_u64!"},"external_var":false},{"html_id":"to_u8:UInt8-instance-method","name":"to_u8","doc":"Converts to `UInt8`. Truncates anything on the right side of the decimal point.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"UInt8.html\">UInt8</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":653,"url":null},"def":{"name":"to_u8","return_type":"UInt8","visibility":"Public","body":"to_big_u.to_u8"},"external_var":false},{"html_id":"to_u8!-instance-method","name":"to_u8!","doc":"Converts to `UInt8`. Truncates anything on the right side of the decimal point,\nconverting negative to positive.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"UInt8.html\">UInt8</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":666,"url":null},"def":{"name":"to_u8!","visibility":"Public","body":"to_big_u!.to_u8!"},"external_var":false},{"html_id":"trunc:BigDecimal-instance-method","name":"trunc","doc":"Rounds towards zero.","summary":"<p>Rounds towards zero.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":417,"url":null},"def":{"name":"trunc","return_type":"BigDecimal","visibility":"Public","body":"round_impl do false end"},"external_var":false},{"html_id":"value:BigInt-instance-method","name":"value","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":34,"url":null},"def":{"name":"value","return_type":"BigInt","visibility":"Public","body":"@value"},"external_var":false},{"html_id":"zero?:Bool-instance-method","name":"zero?","doc":"Returns `true` if `self` is equal to zero.\n\n```\n0.zero? # => true\n5.zero? # => false\n```","summary":"<p>Returns <code>true</code> if <code>self</code> is equal to zero.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":369,"url":null},"def":{"name":"zero?","return_type":"Bool","visibility":"Public","body":"@value.zero?"},"external_var":false}]},{"html_id":"Crystal/BigFloat","path":"BigFloat.html","kind":"struct","full_name":"BigFloat","name":"BigFloat","abstract":false,"superclass":{"html_id":"Crystal/Float","kind":"struct","full_name":"Float","name":"Float"},"ancestors":[{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Float","kind":"struct","full_name":"Float","name":"Float"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Number","kind":"struct","full_name":"Number","name":"Number"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Steppable","kind":"module","full_name":"Steppable","name":"Steppable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/big.cr","line_number":5,"url":null},{"filename":"src/big/big_decimal.cr","line_number":831,"url":null},{"filename":"src/big/big_float.cr","line_number":9,"url":null},{"filename":"src/big/big_rational.cr","line_number":449,"url":null},{"filename":"src/big/json.cr","line_number":40,"url":null},{"filename":"src/big/number.cr","line_number":6,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"included_modules":[{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"}],"doc":"A `BigFloat` can represent arbitrarily large floats.\n\nIt is implemented under the hood with [GMP](https://gmplib.org/).\n\nNOTE: To use `BigFloat`, you must explicitly import it with `require \"big\"`","summary":"<p>A <code><a href=\"BigFloat.html\">BigFloat</a></code> can represent arbitrarily large floats.</p>","class_methods":[{"html_id":"default_precision-class-method","name":"default_precision","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":80,"url":null},"def":{"name":"default_precision","visibility":"Public","body":"LibGMP.mpf_get_default_prec"},"external_var":false},{"html_id":"default_precision=(prec:Int):Nil-class-method","name":"default_precision=","abstract":false,"args":[{"name":"prec","external_name":"prec","restriction":"Int"}],"args_string":"(prec : Int) : Nil","args_html":"(prec : <a href=\"Int.html\">Int</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/big/big_float.cr","line_number":84,"url":null},"def":{"name":"default_precision=","args":[{"name":"prec","external_name":"prec","restriction":"Int"}],"return_type":"Nil","visibility":"Public","body":"LibGMP.mpf_set_default_prec(prec.to_u64)"},"external_var":false},{"html_id":"from_json_object_key?(key:String):BigFloat|Nil-class-method","name":"from_json_object_key?","abstract":false,"args":[{"name":"key","external_name":"key","restriction":"String"}],"args_string":"(key : String) : BigFloat | Nil","args_html":"(key : <a href=\"String.html\">String</a>) : <a href=\"BigFloat.html\">BigFloat</a> | <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/big/json.cr","line_number":52,"url":null},"def":{"name":"from_json_object_key?","args":[{"name":"key","external_name":"key","restriction":"String"}],"return_type":"BigFloat | ::Nil","visibility":"Public","body":"begin\n  new(key)\nrescue ArgumentError\n  nil\nend"},"external_var":false}],"constructors":[{"html_id":"new(num:Float,precision:Int)-class-method","name":"new","abstract":false,"args":[{"name":"num","external_name":"num","restriction":"Float"},{"name":"precision","external_name":"precision","restriction":"Int"}],"args_string":"(num : Float, precision : Int)","args_html":"(num : <a href=\"Float.html\">Float</a>, precision : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/big/big_float.cr","line_number":65,"url":null},"def":{"name":"new","args":[{"name":"num","external_name":"num","restriction":"Float"},{"name":"precision","external_name":"precision","restriction":"Int"}],"visibility":"Public","body":"_ = allocate\n_.initialize(num, precision)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(ctx:YAML::ParseContext,node:YAML::Nodes::Node):self-class-method","name":"new","abstract":false,"args":[{"name":"ctx","external_name":"ctx","restriction":"YAML::ParseContext"},{"name":"node","external_name":"node","restriction":"YAML::Nodes::Node"}],"args_string":"(ctx : YAML::ParseContext, node : YAML::Nodes::Node) : self","args_html":"(ctx : <a href=\"YAML/ParseContext.html\">YAML::ParseContext</a>, node : <a href=\"YAML/Nodes/Node.html\">YAML::Nodes::Node</a>) : <span class=\"k\">self</span>","location":{"filename":"src/big/yaml.cr","line_number":12,"url":null},"def":{"name":"new","args":[{"name":"ctx","external_name":"ctx","restriction":"YAML::ParseContext"},{"name":"node","external_name":"node","restriction":"YAML::Nodes::Node"}],"return_type":"self","visibility":"Public","body":"if node.is_a?(YAML::Nodes::Scalar)\nelse\n  node.raise(\"Expected scalar, not #{node.class}\")\nend\n\nBigFloat.new(node.value)\n"},"external_var":false},{"html_id":"new(str:String)-class-method","name":"new","abstract":false,"args":[{"name":"str","external_name":"str","restriction":"String"}],"args_string":"(str : String)","args_html":"(str : <a href=\"String.html\">String</a>)","location":{"filename":"src/big/big_float.cr","line_number":18,"url":null},"def":{"name":"new","args":[{"name":"str","external_name":"str","restriction":"String"}],"visibility":"Public","body":"_ = allocate\n_.initialize(str)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(num:BigInt)-class-method","name":"new","abstract":false,"args":[{"name":"num","external_name":"num","restriction":"BigInt"}],"args_string":"(num : BigInt)","args_html":"(num : <a href=\"BigInt.html\">BigInt</a>)","location":{"filename":"src/big/big_float.cr","line_number":28,"url":null},"def":{"name":"new","args":[{"name":"num","external_name":"num","restriction":"BigInt"}],"visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(num:BigRational)-class-method","name":"new","abstract":false,"args":[{"name":"num","external_name":"num","restriction":"BigRational"}],"args_string":"(num : BigRational)","args_html":"(num : <a href=\"BigRational.html\">BigRational</a>)","location":{"filename":"src/big/big_float.cr","line_number":33,"url":null},"def":{"name":"new","args":[{"name":"num","external_name":"num","restriction":"BigRational"}],"visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(num:BigFloat)-class-method","name":"new","abstract":false,"args":[{"name":"num","external_name":"num","restriction":"BigFloat"}],"args_string":"(num : BigFloat)","args_html":"(num : <a href=\"BigFloat.html\">BigFloat</a>)","location":{"filename":"src/big/big_float.cr","line_number":38,"url":null},"def":{"name":"new","args":[{"name":"num","external_name":"num","restriction":"BigFloat"}],"visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(num:Int)-class-method","name":"new","abstract":false,"args":[{"name":"num","external_name":"num","restriction":"Int"}],"args_string":"(num : Int)","args_html":"(num : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/big/big_float.cr","line_number":43,"url":null},"def":{"name":"new","args":[{"name":"num","external_name":"num","restriction":"Int"}],"visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(num:Float::Primitive)-class-method","name":"new","abstract":false,"args":[{"name":"num","external_name":"num","restriction":"Float::Primitive"}],"args_string":"(num : Float::Primitive)","args_html":"(num : <a href=\"Float/Primitive.html\">Float::Primitive</a>)","location":{"filename":"src/big/big_float.cr","line_number":56,"url":null},"def":{"name":"new","args":[{"name":"num","external_name":"num","restriction":"Float::Primitive"}],"visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(num:Number)-class-method","name":"new","abstract":false,"args":[{"name":"num","external_name":"num","restriction":"Number"}],"args_string":"(num : Number)","args_html":"(num : <a href=\"Number.html\">Number</a>)","location":{"filename":"src/big/big_float.cr","line_number":61,"url":null},"def":{"name":"new","args":[{"name":"num","external_name":"num","restriction":"Number"}],"visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(mpf:LibGMP::MPF)-class-method","name":"new","abstract":false,"args":[{"name":"mpf","external_name":"mpf","restriction":"LibGMP::MPF"}],"args_string":"(mpf : LibGMP::MPF)","args_html":"(mpf : LibGMP::MPF)","location":{"filename":"src/big/big_float.cr","line_number":71,"url":null},"def":{"name":"new","args":[{"name":"mpf","external_name":"mpf","restriction":"LibGMP::MPF"}],"visibility":"Public","body":"_ = allocate\n_.initialize(mpf)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(pull:JSON::PullParser):self-class-method","name":"new","abstract":false,"args":[{"name":"pull","external_name":"pull","restriction":"JSON::PullParser"}],"args_string":"(pull : JSON::PullParser) : self","args_html":"(pull : <a href=\"JSON/PullParser.html\">JSON::PullParser</a>) : <span class=\"k\">self</span>","location":{"filename":"src/big/json.cr","line_number":41,"url":null},"def":{"name":"new","args":[{"name":"pull","external_name":"pull","restriction":"JSON::PullParser"}],"return_type":"self","visibility":"Public","body":"case pull.kind\nwhen .int?, .float?\n  value = pull.raw_value\n  pull.read_next\nelse\n  value = pull.read_string\nend\nnew(value)\n"},"external_var":false},{"html_id":"new-class-method","name":"new","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":14,"url":null},"def":{"name":"new","visibility":"Public","body":"_ = allocate\n_.initialize\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(&)-class-method","name":"new","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":74,"url":null},"def":{"name":"new","yields":1,"block_arity":1,"visibility":"Public","body":"LibGMP.mpf_init(out mpf)\nyield pointerof(mpf)\nnew(mpf)\n"},"external_var":false}],"instance_methods":[{"html_id":"*(other:Int::Primitive):BigFloat-instance-method","name":"*","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int::Primitive"}],"args_string":"(other : Int::Primitive) : BigFloat","args_html":"(other : <a href=\"Int/Primitive.html\">Int::Primitive</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/big_float.cr","line_number":158,"url":null},"def":{"name":"*","args":[{"name":"other","external_name":"other","restriction":"Int::Primitive"}],"return_type":"BigFloat","visibility":"Public","body":"Int.primitive_ui_check(other) do |ui, neg_ui, big_i|\n  {\n    ui: BigFloat.new do |mpf| LibGMP.mpf_mul_ui(mpf, self, {{ ui }}) end,\n    neg_ui: BigFloat.new do |mpf|     LibGMP.mpf_mul_ui(mpf, self, {{ neg_ui }})\n    LibGMP.mpf_neg(mpf, mpf)\n end,\n    big_i: self + ({{ big_i }}),\n  }\nend"},"external_var":false},{"html_id":"*(other:Number):BigFloat-instance-method","name":"*","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Number"}],"args_string":"(other : Number) : BigFloat","args_html":"(other : <a href=\"Number.html\">Number</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/big_float.cr","line_number":168,"url":null},"def":{"name":"*","args":[{"name":"other","external_name":"other","restriction":"Number"}],"return_type":"BigFloat","visibility":"Public","body":"BigFloat.new do |mpf| LibGMP.mpf_mul(mpf, self, other.to_big_f) end"},"external_var":false},{"html_id":"**(other:BigInt):BigFloat-instance-method","name":"**","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigFloat","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/big_float.cr","line_number":194,"url":null},"def":{"name":"**","args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"return_type":"BigFloat","visibility":"Public","body":"is_zero = self.zero?\nif is_zero\n  case other\n  when .>(0)\n    return self\n  when .<(0)\n    raise(ArgumentError.new(\"Cannot raise 0 to a negative power\"))\n  end\nend\n\nBigFloat.new do |result|\n  LibGMP.mpf_init_set_si(result, 1)\n  if is_zero\n    next\n  end\n\n\n  exponent = BigInt.new do |mpz| LibGMP.abs(mpz, other) end\n  k = BigFloat.new do |mpf| LibGMP.mpf_set(mpf, self) end\n\n  while exponent > 0\n    if exponent.to_i!.odd?\n      LibGMP.mpf_mul(result, result, k)\n    end\n    LibGMP.fdiv_q_2exp(exponent, exponent, 1)\n    if exponent > 0\n      LibGMP.mpf_mul(k, k, k)\n    end\n  end\n\n  if other < 0\n    LibGMP.mpf_ui_div(result, 1, result)\n  end\nend\n"},"external_var":false},{"html_id":"**(other:Int):BigFloat-instance-method","name":"**","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigFloat","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/big_float.cr","line_number":224,"url":null},"def":{"name":"**","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigFloat","visibility":"Public","body":"if zero? && other < 0\n  raise(ArgumentError.new(\"Cannot raise 0 to a negative power\"))\nend\n\nInt.primitive_ui_check(other) do |ui, neg_ui, big_i|\n  {\n    ui: BigFloat.new do |mpf| LibGMP.mpf_pow_ui(mpf, self, {{ ui }}) end,\n    neg_ui: BigFloat.new do |mpf|     LibGMP.mpf_pow_ui(mpf, self, {{ neg_ui }})\n    LibGMP.mpf_ui_div(mpf, 1, mpf)\n end,\n    big_i: self ** ({{ big_i }}),\n  }\nend\n"},"external_var":false},{"html_id":"+(other:Int::Primitive):BigFloat-instance-method","name":"+","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int::Primitive"}],"args_string":"(other : Int::Primitive) : BigFloat","args_html":"(other : <a href=\"Int/Primitive.html\">Int::Primitive</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/big_float.cr","line_number":130,"url":null},"def":{"name":"+","args":[{"name":"other","external_name":"other","restriction":"Int::Primitive"}],"return_type":"BigFloat","visibility":"Public","body":"Int.primitive_ui_check(other) do |ui, neg_ui, big_i|\n  {\n    ui: BigFloat.new do |mpf| LibGMP.mpf_add_ui(mpf, self, {{ ui }}) end,\n    neg_ui: BigFloat.new do |mpf| LibGMP.mpf_sub_ui(mpf, self, {{ neg_ui }}) end,\n    big_i: self + ({{ big_i }}),\n  }\nend"},"external_var":false},{"html_id":"+(other:Number):BigFloat-instance-method","name":"+","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Number"}],"args_string":"(other : Number) : BigFloat","args_html":"(other : <a href=\"Number.html\">Number</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/big_float.cr","line_number":140,"url":null},"def":{"name":"+","args":[{"name":"other","external_name":"other","restriction":"Number"}],"return_type":"BigFloat","visibility":"Public","body":"BigFloat.new do |mpf| LibGMP.mpf_add(mpf, self, other.to_big_f) end"},"external_var":false},{"html_id":"-(other:Int::Primitive):BigFloat-instance-method","name":"-","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int::Primitive"}],"args_string":"(other : Int::Primitive) : BigFloat","args_html":"(other : <a href=\"Int/Primitive.html\">Int::Primitive</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/big_float.cr","line_number":144,"url":null},"def":{"name":"-","args":[{"name":"other","external_name":"other","restriction":"Int::Primitive"}],"return_type":"BigFloat","visibility":"Public","body":"Int.primitive_ui_check(other) do |ui, neg_ui, big_i|\n  {\n    ui: BigFloat.new do |mpf| LibGMP.mpf_sub_ui(mpf, self, {{ ui }}) end,\n    neg_ui: BigFloat.new do |mpf| LibGMP.mpf_add_ui(mpf, self, {{ neg_ui }}) end,\n    big_i: self - ({{ big_i }}),\n  }\nend"},"external_var":false},{"html_id":"-(other:Number):BigFloat-instance-method","name":"-","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Number"}],"args_string":"(other : Number) : BigFloat","args_html":"(other : <a href=\"Number.html\">Number</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/big_float.cr","line_number":154,"url":null},"def":{"name":"-","args":[{"name":"other","external_name":"other","restriction":"Number"}],"return_type":"BigFloat","visibility":"Public","body":"BigFloat.new do |mpf| LibGMP.mpf_sub(mpf, self, other.to_big_f) end"},"external_var":false},{"html_id":"-:BigFloat-instance-method","name":"-","doc":"Negates this value's sign.","summary":"<p>Negates this value's sign.</p>","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":126,"url":null},"def":{"name":"-","return_type":"BigFloat","visibility":"Public","body":"BigFloat.new do |mpf| LibGMP.mpf_neg(mpf, self) end"},"external_var":false},{"html_id":"/(other:Int::Primitive):BigFloat-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int::Primitive"}],"args_string":"(other : Int::Primitive) : BigFloat","args_html":"(other : <a href=\"Int/Primitive.html\">Int::Primitive</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/big_float.cr","line_number":172,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"Int::Primitive"}],"return_type":"BigFloat","visibility":"Public","body":"if other == 0\n  raise(DivisionByZeroError.new)\nend\nInt.primitive_ui_check(other) do |ui, neg_ui, _|\n  {\n    ui: BigFloat.new do |mpf| LibGMP.mpf_div_ui(mpf, self, {{ ui }}) end,\n    neg_ui: BigFloat.new do |mpf|     LibGMP.mpf_div_ui(mpf, self, {{ neg_ui }})\n    LibGMP.mpf_neg(mpf, mpf)\n end,\n    big_i: BigFloat.new do |mpf| LibGMP.mpf_div(mpf, self, BigFloat.new(other)) end,\n  }\nend\n"},"external_var":false},{"html_id":"/(other:BigFloat):BigFloat-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigFloat"}],"args_string":"(other : BigFloat) : BigFloat","args_html":"(other : <a href=\"BigFloat.html\">BigFloat</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/big_float.cr","line_number":184,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"BigFloat"}],"return_type":"BigFloat","visibility":"Public","body":"if other == 0\n  raise(DivisionByZeroError.new)\nend\nBigFloat.new do |mpf| LibGMP.mpf_div(mpf, self, other) end\n"},"external_var":false},{"html_id":"/(other:BigInt):BigFloat-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigFloat","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/big_float.cr","line_number":190,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"},"external_var":false},{"html_id":"/(other:BigDecimal):BigDecimal-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : BigDecimal","args_html":"(other : <a href=\"BigDecimal.html\">BigDecimal</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_float.cr","line_number":191,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"BigDecimal"}],"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"},"external_var":false},{"html_id":"/(other:BigRational):BigRational-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational) : BigRational","args_html":"(other : <a href=\"BigRational.html\">BigRational</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_float.cr","line_number":192,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"},"external_var":false},{"html_id":"/(other:Float32):BigFloat-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Float32"}],"args_string":"(other : Float32) : BigFloat","args_html":"(other : <a href=\"Float32.html\">Float32</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":11,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"Float32"}],"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"},"external_var":false},{"html_id":"/(other:Float64):BigFloat-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Float64"}],"args_string":"(other : Float64) : BigFloat","args_html":"(other : <a href=\"Float64.html\">Float64</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":11,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"Float64"}],"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"},"external_var":false},{"html_id":"<=>(other:BigFloat)-instance-method","name":"<=>","doc":"The comparison operator. Returns `0` if the two objects are equal,\na negative number if this object is considered less than *other*,\na positive number if this object is considered greater than *other*,\nor `nil` if the two objects are not comparable.\n\nSubclasses define this method to provide class-specific ordering.\n\nThe comparison operator is usually used to sort values:\n\n```\n# Sort in a descending way:\n[3, 1, 2].sort { |x, y| y <=> x } # => [3, 2, 1]\n\n# Sort in an ascending way:\n[3, 1, 2].sort { |x, y| x <=> y } # => [1, 2, 3]\n```","summary":"<p>The comparison operator.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigFloat"}],"args_string":"(other : BigFloat)","args_html":"(other : <a href=\"BigFloat.html\">BigFloat</a>)","location":{"filename":"src/big/big_float.cr","line_number":100,"url":null},"def":{"name":"<=>","args":[{"name":"other","external_name":"other","restriction":"BigFloat"}],"visibility":"Public","body":"LibGMP.mpf_cmp(self, other)"},"external_var":false},{"html_id":"<=>(other:BigInt)-instance-method","name":"<=>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt)","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>)","location":{"filename":"src/big/big_float.cr","line_number":104,"url":null},"def":{"name":"<=>","args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"visibility":"Public","body":"LibGMP.mpf_cmp_z(self, other)"},"external_var":false},{"html_id":"<=>(other:Float::Primitive):Int32|Nil-instance-method","name":"<=>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Float::Primitive"}],"args_string":"(other : Float::Primitive) : Int32 | Nil","args_html":"(other : <a href=\"Float/Primitive.html\">Float::Primitive</a>) : <a href=\"Int32.html\">Int32</a> | <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/big/big_float.cr","line_number":108,"url":null},"def":{"name":"<=>","args":[{"name":"other","external_name":"other","restriction":"Float::Primitive"}],"return_type":"Int32 | ::Nil","visibility":"Public","body":"if other.nan?\nelse\n  LibGMP.mpf_cmp_d(self, other)\nend"},"external_var":false},{"html_id":"<=>(other:Int):Int32-instance-method","name":"<=>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : Int32","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/big/big_float.cr","line_number":112,"url":null},"def":{"name":"<=>","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"Int32","visibility":"Public","body":"Int.primitive_si_ui_check(other) do |si, ui, big_i|\n  {\n    si: LibGMP.mpf_cmp_si(self, {{ si }}),\n    ui: LibGMP.mpf_cmp_ui(self, {{ ui }}),\n    big_i: self <=> ({{ big_i }}),\n  }\nend"},"external_var":false},{"html_id":"<=>(other:BigRational)-instance-method","name":"<=>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational)","args_html":"(other : <a href=\"BigRational.html\">BigRational</a>)","location":{"filename":"src/big/big_rational.cr","line_number":450,"url":null},"def":{"name":"<=>","args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"visibility":"Public","body":"-(other <=> self)"},"external_var":false},{"html_id":"<=>(other:BigDecimal)-instance-method","name":"<=>","doc":"The comparison operator. Returns `0` if the two objects are equal,\na negative number if this object is considered less than *other*,\na positive number if this object is considered greater than *other*,\nor `nil` if the two objects are not comparable.\n\nSubclasses define this method to provide class-specific ordering.\n\nThe comparison operator is usually used to sort values:\n\n```\n# Sort in a descending way:\n[3, 1, 2].sort { |x, y| y <=> x } # => [3, 2, 1]\n\n# Sort in an ascending way:\n[3, 1, 2].sort { |x, y| x <=> y } # => [1, 2, 3]\n```","summary":"<p>The comparison operator.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal)","args_html":"(other : <a href=\"BigDecimal.html\">BigDecimal</a>)","location":{"filename":"src/big/big_decimal.cr","line_number":832,"url":null},"def":{"name":"<=>","args":[{"name":"other","external_name":"other","restriction":"BigDecimal"}],"visibility":"Public","body":"-(other <=> self)"},"external_var":false},{"html_id":"<=>(other:Number)-instance-method","name":"<=>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Number"}],"args_string":"(other : Number)","args_html":"(other : <a href=\"Number.html\">Number</a>)","location":{"filename":"src/big/big_float.cr","line_number":122,"url":null},"def":{"name":"<=>","args":[{"name":"other","external_name":"other","restriction":"Number"}],"visibility":"Public","body":"LibGMP.mpf_cmp(self, other.to_big_f)"},"external_var":false},{"html_id":"abs:BigFloat-instance-method","name":"abs","doc":"Returns the absolute value of this number.\n\n```\n123.abs  # => 123\n-123.abs # => 123\n```","summary":"<p>Returns the absolute value of this number.</p>","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":239,"url":null},"def":{"name":"abs","return_type":"BigFloat","visibility":"Public","body":"BigFloat.new do |mpf| LibGMP.mpf_abs(mpf, self) end"},"external_var":false},{"html_id":"ceil:BigFloat-instance-method","name":"ceil","doc":"Rounds towards positive infinity.","summary":"<p>Rounds towards positive infinity.</p>","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":244,"url":null},"def":{"name":"ceil","return_type":"BigFloat","visibility":"Public","body":"BigFloat.new do |mpf| LibGMP.mpf_ceil(mpf, self) end"},"external_var":false},{"html_id":"clone:BigFloat-instance-method","name":"clone","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":476,"url":null},"def":{"name":"clone","return_type":"BigFloat","visibility":"Public","body":"self"},"external_var":false},{"html_id":"fdiv(other:Number::Primitive):self-instance-method","name":"fdiv","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Number::Primitive"}],"args_string":"(other : Number::Primitive) : self","args_html":"(other : <a href=\"Number/Primitive.html\">Number::Primitive</a>) : <span class=\"k\">self</span>","location":{"filename":"src/big/number.cr","line_number":7,"url":null},"def":{"name":"fdiv","args":[{"name":"other","external_name":"other","restriction":"Number::Primitive"}],"return_type":"self","visibility":"Public","body":"self.class.new(self / other)"},"external_var":false},{"html_id":"floor:BigFloat-instance-method","name":"floor","doc":"Rounds towards negative infinity.","summary":"<p>Rounds towards negative infinity.</p>","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":249,"url":null},"def":{"name":"floor","return_type":"BigFloat","visibility":"Public","body":"BigFloat.new do |mpf| LibGMP.mpf_floor(mpf, self) end"},"external_var":false},{"html_id":"format(io:IO,separator='.',delimiter=',',decimal_places:Int|Nil=nil,*,group:Int=3,only_significant:Bool=false):Nil-instance-method","name":"format","doc":"Prints this number as a `String` using a customizable format.\n\n*separator* is used as decimal separator, *delimiter* as thousands\ndelimiter between batches of *group* digits.\n\nIf *decimal_places* is `nil`, all significant decimal places are printed\n(similar to `#to_s`). If the argument has a numeric value, the number of\nvisible decimal places will be fixed to that amount.\n\nTrailing zeros are omitted if *only_significant* is `true`.\n\n```\n123_456.789.format                                            # => \"123,456.789\"\n123_456.789.format(',', '.')                                  # => \"123.456,789\"\n123_456.789.format(decimal_places: 2)                         # => \"123,456.79\"\n123_456.789.format(decimal_places: 6)                         # => \"123,456.789000\"\n123_456.789.format(decimal_places: 6, only_significant: true) # => \"123,456.789\"\n```","summary":"<p>Prints this number as a <code><a href=\"String.html\">String</a></code> using a customizable format.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"separator","default_value":"'.'","external_name":"separator","restriction":""},{"name":"delimiter","default_value":"','","external_name":"delimiter","restriction":""},{"name":"decimal_places","default_value":"nil","external_name":"decimal_places","restriction":"Int | ::Nil"},{"name":"","external_name":"","restriction":""},{"name":"group","default_value":"3","external_name":"group","restriction":"Int"},{"name":"only_significant","default_value":"false","external_name":"only_significant","restriction":"Bool"}],"args_string":"(io : IO, separator = '.', delimiter = ',', decimal_places : Int | Nil = nil, *, group : Int = 3, only_significant : Bool = false) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>, separator = <span class=\"s\">&#39;.&#39;</span>, delimiter = <span class=\"s\">&#39;,&#39;</span>, decimal_places : <a href=\"Int.html\">Int</a> | <a href=\"Nil.html\">Nil</a> = <span class=\"n\">nil</span>, *, group : <a href=\"Int.html\">Int</a> = <span class=\"n\">3</span>, only_significant : <a href=\"Bool.html\">Bool</a> = <span class=\"n\">false</span>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/big/big_float.cr","line_number":456,"url":null},"def":{"name":"format","args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"separator","default_value":"'.'","external_name":"separator","restriction":""},{"name":"delimiter","default_value":"','","external_name":"delimiter","restriction":""},{"name":"decimal_places","default_value":"nil","external_name":"decimal_places","restriction":"Int | ::Nil"},{"name":"","external_name":"","restriction":""},{"name":"group","default_value":"3","external_name":"group","restriction":"Int"},{"name":"only_significant","default_value":"false","external_name":"only_significant","restriction":"Bool"}],"splat_index":4,"return_type":"Nil","visibility":"Public","body":"number = self\nif decimal_places\n  number = number.round(decimal_places)\nend\n\nif decimal_places && decimal_places >= 0\n  string = number.abs.to_s_impl(point_range: .., int_trailing_zeros: true)\n  integer, _, decimals = string.partition('.')\nelse\n  string = number.to_s_impl(point_range: .., int_trailing_zeros: true)\n  _, _, decimals = string.partition(\".\")\n  integer = number.trunc.to_big_i.abs.to_s\nend\n\nis_negative = number < 0\n\nformat_impl(io, is_negative, integer, decimals, separator, delimiter, decimal_places, group, only_significant)\n"},"external_var":false},{"html_id":"infinite?:Int32|Nil-instance-method","name":"infinite?","doc":"Checks whether this value is infinite. Returns `1` if this value is positive\ninfinity, `-1` if this value is negative infinity, or `nil` otherwise.","summary":"<p>Checks whether this value is infinite.</p>","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":95,"url":null},"def":{"name":"infinite?","return_type":"Int32 | ::Nil","visibility":"Public","body":"nil"},"external_var":false},{"html_id":"integer?:Bool-instance-method","name":"integer?","doc":"Returns `true` if `self` is an integer.\n\nNon-integer types may return `true` as long as `self` denotes a finite value\nwithout any fractional parts.\n\n```\n1.integer?       # => true\n1.0.integer?     # => true\n1.2.integer?     # => false\n(1 / 0).integer? # => false\n(0 / 0).integer? # => false\n```","summary":"<p>Returns <code>true</code> if <code>self</code> is an integer.</p>","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":514,"url":null},"def":{"name":"integer?","return_type":"Bool","visibility":"Public","body":"!(LibGMP.mpf_integer_p(mpf)).zero?"},"external_var":false},{"html_id":"nan?:Bool-instance-method","name":"nan?","doc":"Returns whether this value is a not-a-number.\n\nThis includes both quiet and signalling NaNs from IEEE 754.","summary":"<p>Returns whether this value is a not-a-number.</p>","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":89,"url":null},"def":{"name":"nan?","return_type":"Bool","visibility":"Public","body":"false"},"external_var":false},{"html_id":"round_away:self-instance-method","name":"round_away","doc":"Rounds towards the nearest integer. If both neighboring integers are equidistant,\nrounds away from zero.","summary":"<p>Rounds towards the nearest integer.</p>","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":505,"url":null},"def":{"name":"round_away","return_type":"self","visibility":"Public","body":"if self >= 0\n  (self + 0.5).floor\nelse\n  (self - 0.5).ceil\nend"},"external_var":false},{"html_id":"round_even:self-instance-method","name":"round_even","doc":"Rounds towards the nearest integer. If both neighboring integers are equidistant,\nrounds towards the even neighbor (Banker's rounding).","summary":"<p>Rounds towards the nearest integer.</p>","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":482,"url":null},"def":{"name":"round_even","return_type":"self","visibility":"Public","body":"if self >= 0\n  halfway = self + 0.5\nelse\n  halfway = self - 0.5\nend\nif halfway.integer?\n  if halfway == ((halfway / 2).trunc * 2)\n    halfway\n  else\n    halfway - sign\n  end\nelsif self >= 0\n  halfway.floor\nelse\n  halfway.ceil\nend\n"},"external_var":false},{"html_id":"to_big_f:BigFloat-instance-method","name":"to_big_f","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":282,"url":null},"def":{"name":"to_big_f","return_type":"BigFloat","visibility":"Public","body":"self"},"external_var":false},{"html_id":"to_big_i:BigInt-instance-method","name":"to_big_i","doc":"Returns a `BigInt` representing this float (rounded using `floor`).\n```\nrequire \"big\"\n\n1212341515125412412412421.0.to_big_i\n```","summary":"<p>Returns a <code><a href=\"BigInt.html\">BigInt</a></code> representing this float (rounded using <code><a href=\"BigFloat.html#floor%3ABigFloat-instance-method\">#floor</a></code>).</p>","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":286,"url":null},"def":{"name":"to_big_i","return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz| LibGMP.set_f(mpz, mpf) end"},"external_var":false},{"html_id":"to_f:Float64-instance-method","name":"to_f","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":266,"url":null},"def":{"name":"to_f","return_type":"Float64","visibility":"Public","body":"to_f64"},"external_var":false},{"html_id":"to_f!:Float64-instance-method","name":"to_f!","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":278,"url":null},"def":{"name":"to_f!","return_type":"Float64","visibility":"Public","body":"to_f64!"},"external_var":false},{"html_id":"to_f32:Float32-instance-method","name":"to_f32","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":262,"url":null},"def":{"name":"to_f32","return_type":"Float32","visibility":"Public","body":"to_f64.to_f32"},"external_var":false},{"html_id":"to_f32!:Float32-instance-method","name":"to_f32!","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":270,"url":null},"def":{"name":"to_f32!","return_type":"Float32","visibility":"Public","body":"to_f64.to_f32!"},"external_var":false},{"html_id":"to_f64:Float64-instance-method","name":"to_f64","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":258,"url":null},"def":{"name":"to_f64","return_type":"Float64","visibility":"Public","body":"LibGMP.mpf_get_d(self)"},"external_var":false},{"html_id":"to_f64!:Float64-instance-method","name":"to_f64!","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":274,"url":null},"def":{"name":"to_f64!","return_type":"Float64","visibility":"Public","body":"to_f64"},"external_var":false},{"html_id":"to_i:Int32-instance-method","name":"to_i","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":307,"url":null},"def":{"name":"to_i","return_type":"Int32","visibility":"Public","body":"to_i32"},"external_var":false},{"html_id":"to_i!:Int32-instance-method","name":"to_i!","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":311,"url":null},"def":{"name":"to_i!","return_type":"Int32","visibility":"Public","body":"to_i32!"},"external_var":false},{"html_id":"to_i16:Int16-instance-method","name":"to_i16","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":299,"url":null},"def":{"name":"to_i16","return_type":"Int16","visibility":"Public","body":"to_i64.to_i16"},"external_var":false},{"html_id":"to_i16!:Int16-instance-method","name":"to_i16!","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":319,"url":null},"def":{"name":"to_i16!","return_type":"Int16","visibility":"Public","body":"(LibGMP.mpf_get_si(self)).to_i16!"},"external_var":false},{"html_id":"to_i32:Int32-instance-method","name":"to_i32","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":295,"url":null},"def":{"name":"to_i32","return_type":"Int32","visibility":"Public","body":"to_i64.to_i32"},"external_var":false},{"html_id":"to_i32!:Int32-instance-method","name":"to_i32!","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":323,"url":null},"def":{"name":"to_i32!","return_type":"Int32","visibility":"Public","body":"(LibGMP.mpf_get_si(self)).to_i32!"},"external_var":false},{"html_id":"to_i64:Int64-instance-method","name":"to_i64","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":290,"url":null},"def":{"name":"to_i64","return_type":"Int64","visibility":"Public","body":"if LibGMP::Long::MIN <= self && self <= LibGMP::Long::MAX\nelse\n  raise(OverflowError.new)\nend\n(LibGMP.mpf_get_si(self)).to_i64!\n"},"external_var":false},{"html_id":"to_i64!:Int64-instance-method","name":"to_i64!","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":327,"url":null},"def":{"name":"to_i64!","return_type":"Int64","visibility":"Public","body":"(LibGMP.mpf_get_si(self)).to_i64!"},"external_var":false},{"html_id":"to_i8:Int8-instance-method","name":"to_i8","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":303,"url":null},"def":{"name":"to_i8","return_type":"Int8","visibility":"Public","body":"to_i64.to_i8"},"external_var":false},{"html_id":"to_i8!:Int8-instance-method","name":"to_i8!","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":315,"url":null},"def":{"name":"to_i8!","return_type":"Int8","visibility":"Public","body":"(LibGMP.mpf_get_si(self)).to_i8!"},"external_var":false},{"html_id":"to_json(json:JSON::Builder):Nil-instance-method","name":"to_json","abstract":false,"args":[{"name":"json","external_name":"json","restriction":"JSON::Builder"}],"args_string":"(json : JSON::Builder) : Nil","args_html":"(json : <a href=\"JSON/Builder.html\">JSON::Builder</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/big/json.cr","line_number":62,"url":null},"def":{"name":"to_json","args":[{"name":"json","external_name":"json","restriction":"JSON::Builder"}],"return_type":"Nil","visibility":"Public","body":"json.number(self)"},"external_var":false},{"html_id":"to_json_object_key-instance-method","name":"to_json_object_key","abstract":false,"location":{"filename":"src/big/json.cr","line_number":58,"url":null},"def":{"name":"to_json_object_key","visibility":"Public","body":"to_s"},"external_var":false},{"html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Prints a nicely readable and concise string representation of this object,\ntypically intended for users, to *io*.\n\nThis method is called when an object is interpolated in a string literal:\n```\n\"foo #{bar} baz\" # calls bar.to_io with the builder for this string\n```\n\n`IO#<<` calls this method to append an object to itself:\n```\nio << bar # calls bar.to_s(io)\n```\n\nThus implementations must not interpolate `self` in a string literal or call\n`io << self` which both would lead to an endless loop.\n\nAlso see `#inspect(IO)`.","summary":"<p>Prints a nicely readable and concise string representation of this object, typically intended for users, to <em>io</em>.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/big/big_float.cr","line_number":376,"url":null},"def":{"name":"to_s","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"to_s_impl(io, point_range: -3..15, int_trailing_zeros: true)"},"external_var":false},{"html_id":"to_u:UInt32-instance-method","name":"to_u","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":348,"url":null},"def":{"name":"to_u","return_type":"UInt32","visibility":"Public","body":"to_u32"},"external_var":false},{"html_id":"to_u!:UInt32-instance-method","name":"to_u!","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":352,"url":null},"def":{"name":"to_u!","return_type":"UInt32","visibility":"Public","body":"to_u32!"},"external_var":false},{"html_id":"to_u16:UInt16-instance-method","name":"to_u16","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":340,"url":null},"def":{"name":"to_u16","return_type":"UInt16","visibility":"Public","body":"to_u64.to_u16"},"external_var":false},{"html_id":"to_u16!:UInt16-instance-method","name":"to_u16!","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":360,"url":null},"def":{"name":"to_u16!","return_type":"UInt16","visibility":"Public","body":"(LibGMP.mpf_get_ui(self)).to_u16!"},"external_var":false},{"html_id":"to_u32:UInt32-instance-method","name":"to_u32","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":336,"url":null},"def":{"name":"to_u32","return_type":"UInt32","visibility":"Public","body":"to_u64.to_u32"},"external_var":false},{"html_id":"to_u32!:UInt32-instance-method","name":"to_u32!","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":364,"url":null},"def":{"name":"to_u32!","return_type":"UInt32","visibility":"Public","body":"(LibGMP.mpf_get_ui(self)).to_u32!"},"external_var":false},{"html_id":"to_u64:UInt64-instance-method","name":"to_u64","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":331,"url":null},"def":{"name":"to_u64","return_type":"UInt64","visibility":"Public","body":"if 0 <= self && self <= LibGMP::ULong::MAX\nelse\n  raise(OverflowError.new)\nend\n(LibGMP.mpf_get_ui(self)).to_u64!\n"},"external_var":false},{"html_id":"to_u64!:UInt64-instance-method","name":"to_u64!","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":368,"url":null},"def":{"name":"to_u64!","return_type":"UInt64","visibility":"Public","body":"(LibGMP.mpf_get_ui(self)).to_u64!"},"external_var":false},{"html_id":"to_u8:UInt8-instance-method","name":"to_u8","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":344,"url":null},"def":{"name":"to_u8","return_type":"UInt8","visibility":"Public","body":"to_u64.to_u8"},"external_var":false},{"html_id":"to_u8!:UInt8-instance-method","name":"to_u8!","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":356,"url":null},"def":{"name":"to_u8!","return_type":"UInt8","visibility":"Public","body":"(LibGMP.mpf_get_ui(self)).to_u8!"},"external_var":false},{"html_id":"to_unsafe:Pointer(LibGMP::MPF)-instance-method","name":"to_unsafe","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":372,"url":null},"def":{"name":"to_unsafe","return_type":"Pointer(LibGMP::MPF)","visibility":"Public","body":"mpf"},"external_var":false},{"html_id":"trunc:BigFloat-instance-method","name":"trunc","doc":"Rounds towards zero.","summary":"<p>Rounds towards zero.</p>","abstract":false,"location":{"filename":"src/big/big_float.cr","line_number":254,"url":null},"def":{"name":"trunc","return_type":"BigFloat","visibility":"Public","body":"BigFloat.new do |mpf| LibGMP.mpf_trunc(mpf, self) end"},"external_var":false}]},{"html_id":"Crystal/BigInt","path":"BigInt.html","kind":"struct","full_name":"BigInt","name":"BigInt","abstract":false,"superclass":{"html_id":"Crystal/Int","kind":"struct","full_name":"Int","name":"Int"},"ancestors":[{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Int","kind":"struct","full_name":"Int","name":"Int"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Number","kind":"struct","full_name":"Number","name":"Number"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Steppable","kind":"module","full_name":"Steppable","name":"Steppable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/big.cr","line_number":2,"url":null},{"filename":"src/big/big_int.cr","line_number":10,"url":null},{"filename":"src/big/json.cr","line_number":13,"url":null},{"filename":"src/big/number.cr","line_number":1,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"included_modules":[{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"}],"doc":"A `BigInt` can represent arbitrarily large integers.\n\nIt is implemented under the hood with [GMP](https://gmplib.org/).\n\nNOTE: To use `BigInt`, you must explicitly import it with `require \"big\"`","summary":"<p>A <code><a href=\"BigInt.html\">BigInt</a></code> can represent arbitrarily large integers.</p>","class_methods":[{"html_id":"from_json_object_key?(key:String):BigInt|Nil-class-method","name":"from_json_object_key?","abstract":false,"args":[{"name":"key","external_name":"key","restriction":"String"}],"args_string":"(key : String) : BigInt | Nil","args_html":"(key : <a href=\"String.html\">String</a>) : <a href=\"BigInt.html\">BigInt</a> | <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/big/json.cr","line_number":25,"url":null},"def":{"name":"from_json_object_key?","args":[{"name":"key","external_name":"key","restriction":"String"}],"return_type":"BigInt | ::Nil","visibility":"Public","body":"begin\n  new(key)\nrescue ArgumentError\n  nil\nend"},"external_var":false}],"constructors":[{"html_id":"from_digits(digits:Enumerable(Int),base:Int=10):self-class-method","name":"from_digits","doc":"Returns a number for given *digits* and *base*. The digits are expected as\nan `Enumerable` with the least significant digit as the first element.\n\n*base* must not be less than 2.\n\nAll digits must be within `0...base`.","summary":"<p>Returns a number for given <em>digits</em> and <em>base</em>.</p>","abstract":false,"args":[{"name":"digits","external_name":"digits","restriction":"Enumerable(Int)"},{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(digits : Enumerable(Int), base : Int = 10) : self","args_html":"(digits : <a href=\"Enumerable.html\">Enumerable</a>(<a href=\"Int.html\">Int</a>), base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>) : <span class=\"k\">self</span>","location":{"filename":"src/big/big_int.cr","line_number":150,"url":null},"def":{"name":"from_digits","args":[{"name":"digits","external_name":"digits","restriction":"Enumerable(Int)"},{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"return_type":"self","visibility":"Public","body":"if base < 2\n  raise(ArgumentError.new(\"Invalid base #{base}\"))\nend\n\nnew do |mpz|\n  multiplier = new(1)\n  first_element = true\n\n  digits.each do |digit|\n    if digit < 0\n      raise(ArgumentError.new(\"Invalid digit #{digit}\"))\n    end\n\n    if digit >= base\n      raise(ArgumentError.new(\"Invalid digit #{digit} for base #{base}\"))\n    end\n\n\n\n    if first_element\n      first_element = false\n\n\n      Int.primitive_ui_check(digit) do |ui, _, big_i|\n        {\n          ui: LibGMP.set_ui(mpz, {{ ui }}),\n          big_i: LibGMP.set(mpz, {{ big_i }}),\n        }\n      end\n    else\n      Int.primitive_ui_check(base) do |ui, _, big_i|\n        {\n          ui: LibGMP.mul_ui(multiplier, multiplier, {{ ui }}),\n          big_i: LibGMP.mul(multiplier, multiplier, {{ big_i }}),\n        }\n      end\n\n\n      Int.primitive_ui_check(digit) do |ui, _, big_i|\n        {\n          ui: LibGMP.addmul_ui(mpz, multiplier, {{ ui }}),\n          big_i: LibGMP.addmul(mpz, multiplier, {{ big_i }}),\n        }\n      end\n    end\n  end\nend\n"},"external_var":false},{"html_id":"new(str:String,base:Int32=10)-class-method","name":"new","doc":"Creates a `BigInt` with the value denoted by *str* in the given *base*.\n\nRaises `ArgumentError` if the string doesn't denote a valid integer.\n\n```\nrequire \"big\"\n\nBigInt.new(\"123456789123456789123456789123456789\") # => 123456789123456789123456789123456789\nBigInt.new(\"123_456_789_123_456_789_123_456_789\")  # => 123456789123456789123456789\nBigInt.new(\"1234567890ABCDEF\", base: 16)           # => 1311768467294899695\n```","summary":"<p>Creates a <code><a href=\"BigInt.html\">BigInt</a></code> with the value denoted by <em>str</em> in the given <em>base</em>.</p>","abstract":false,"args":[{"name":"str","external_name":"str","restriction":"String"},{"name":"base","default_value":"10","external_name":"base","restriction":"Int32"}],"args_string":"(str : String, base : Int32 = 10)","args_html":"(str : <a href=\"String.html\">String</a>, base : <a href=\"Int32.html\">Int32</a> = <span class=\"n\">10</span>)","location":{"filename":"src/big/big_int.cr","line_number":38,"url":null},"def":{"name":"new","args":[{"name":"str","external_name":"str","restriction":"String"},{"name":"base","default_value":"10","external_name":"base","restriction":"Int32"}],"visibility":"Public","body":"_ = allocate\n_.initialize(str, base)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(ctx:YAML::ParseContext,node:YAML::Nodes::Node):self-class-method","name":"new","abstract":false,"args":[{"name":"ctx","external_name":"ctx","restriction":"YAML::ParseContext"},{"name":"node","external_name":"node","restriction":"YAML::Nodes::Node"}],"args_string":"(ctx : YAML::ParseContext, node : YAML::Nodes::Node) : self","args_html":"(ctx : <a href=\"YAML/ParseContext.html\">YAML::ParseContext</a>, node : <a href=\"YAML/Nodes/Node.html\">YAML::Nodes::Node</a>) : <span class=\"k\">self</span>","location":{"filename":"src/big/yaml.cr","line_number":4,"url":null},"def":{"name":"new","args":[{"name":"ctx","external_name":"ctx","restriction":"YAML::ParseContext"},{"name":"node","external_name":"node","restriction":"YAML::Nodes::Node"}],"return_type":"self","visibility":"Public","body":"if node.is_a?(YAML::Nodes::Scalar)\nelse\n  node.raise(\"Expected scalar, not #{node.class}\")\nend\n\nBigInt.new(node.value)\n"},"external_var":false},{"html_id":"new(num:Int::Primitive):self-class-method","name":"new","doc":"Creates a `BigInt` from the given *num*.","summary":"<p>Creates a <code><a href=\"BigInt.html\">BigInt</a></code> from the given <em>num</em>.</p>","abstract":false,"args":[{"name":"num","external_name":"num","restriction":"Int::Primitive"}],"args_string":"(num : Int::Primitive) : self","args_html":"(num : <a href=\"Int/Primitive.html\">Int::Primitive</a>) : <span class=\"k\">self</span>","location":{"filename":"src/big/big_int.cr","line_number":50,"url":null},"def":{"name":"new","args":[{"name":"num","external_name":"num","restriction":"Int::Primitive"}],"return_type":"self","visibility":"Public","body":"Int.primitive_si_ui_check(num) do |si, ui, _|\n  {\n    si: begin\n      LibGMP.init_set_si(out mpz1, {{ si }})\n      new(mpz1)\n    end,\n    ui: begin\n      LibGMP.init_set_ui(out mpz2, {{ ui }})\n      new(mpz2)\n    end,\n    big_i: begin\n      negative = num < 0\n      num = num.abs_unsigned\n      capacity = ((num.bit_length - 1) // ((sizeof(LibGMP::MpLimb)) * 8)) + 1\n\n\n\n      unsafe_build(capacity) do |limbs|\n        appender = limbs.to_unsafe.appender\n        limbs.size.times do\n          appender << (LibGMP::MpLimb.new!(num))\n          num = num.unsafe_shr((sizeof(LibGMP::MpLimb)) * 8)\n        end\n        {capacity, negative}\n      end\n    end,\n  }\nend"},"external_var":false},{"html_id":"new(num:Float::Primitive)-class-method","name":"new","doc":"Returns a read-only `Slice` of the limbs that make up this integer, which\nis effectively `abs.digits(2 ** N)` where `N` is the number of bits in\n`LibGMP::MpLimb`, except that an empty `Slice` is returned for zero.\n\nThis assumes GMP wasn't built with its experimental nails support:\nhttps://gmplib.org/manual/Low_002dlevel-Functions\n\n*num* must be finite.","summary":"<p>Returns a read-only <code><a href=\"Slice.html\">Slice</a></code> of the limbs that make up this integer, which is effectively <code>abs.digits(2 ** N)</code> where <code>N</code> is the number of bits in <code>LibGMP::MpLimb</code>, except that an empty <code><a href=\"Slice.html\">Slice</a></code> is returned for zero.</p>","abstract":false,"args":[{"name":"num","external_name":"num","restriction":"Float::Primitive"}],"args_string":"(num : Float::Primitive)","args_html":"(num : <a href=\"Float/Primitive.html\">Float::Primitive</a>)","location":{"filename":"src/big/big_int.cr","line_number":107,"url":null},"def":{"name":"new","args":[{"name":"num","external_name":"num","restriction":"Float::Primitive"}],"visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(num:BigFloat):self-class-method","name":"new","doc":"Returns a read-only `Slice` of the limbs that make up this integer, which\nis effectively `abs.digits(2 ** N)` where `N` is the number of bits in\n`LibGMP::MpLimb`, except that an empty `Slice` is returned for zero.\n\nThis assumes GMP wasn't built with its experimental nails support:\nhttps://gmplib.org/manual/Low_002dlevel-Functions","summary":"<p>Returns a read-only <code><a href=\"Slice.html\">Slice</a></code> of the limbs that make up this integer, which is effectively <code>abs.digits(2 ** N)</code> where <code>N</code> is the number of bits in <code>LibGMP::MpLimb</code>, except that an empty <code><a href=\"Slice.html\">Slice</a></code> is returned for zero.</p>","abstract":false,"args":[{"name":"num","external_name":"num","restriction":"BigFloat"}],"args_string":"(num : BigFloat) : self","args_html":"(num : <a href=\"BigFloat.html\">BigFloat</a>) : <span class=\"k\">self</span>","location":{"filename":"src/big/big_int.cr","line_number":113,"url":null},"def":{"name":"new","args":[{"name":"num","external_name":"num","restriction":"BigFloat"}],"return_type":"self","visibility":"Public","body":"num.to_big_i"},"external_var":false},{"html_id":"new(num:BigDecimal):self-class-method","name":"new","doc":"Returns a read-only `Slice` of the limbs that make up this integer, which\nis effectively `abs.digits(2 ** N)` where `N` is the number of bits in\n`LibGMP::MpLimb`, except that an empty `Slice` is returned for zero.\n\nThis assumes GMP wasn't built with its experimental nails support:\nhttps://gmplib.org/manual/Low_002dlevel-Functions","summary":"<p>Returns a read-only <code><a href=\"Slice.html\">Slice</a></code> of the limbs that make up this integer, which is effectively <code>abs.digits(2 ** N)</code> where <code>N</code> is the number of bits in <code>LibGMP::MpLimb</code>, except that an empty <code><a href=\"Slice.html\">Slice</a></code> is returned for zero.</p>","abstract":false,"args":[{"name":"num","external_name":"num","restriction":"BigDecimal"}],"args_string":"(num : BigDecimal) : self","args_html":"(num : <a href=\"BigDecimal.html\">BigDecimal</a>) : <span class=\"k\">self</span>","location":{"filename":"src/big/big_int.cr","line_number":118,"url":null},"def":{"name":"new","args":[{"name":"num","external_name":"num","restriction":"BigDecimal"}],"return_type":"self","visibility":"Public","body":"num.to_big_i"},"external_var":false},{"html_id":"new(num:BigRational):self-class-method","name":"new","doc":"Returns a read-only `Slice` of the limbs that make up this integer, which\nis effectively `abs.digits(2 ** N)` where `N` is the number of bits in\n`LibGMP::MpLimb`, except that an empty `Slice` is returned for zero.\n\nThis assumes GMP wasn't built with its experimental nails support:\nhttps://gmplib.org/manual/Low_002dlevel-Functions","summary":"<p>Returns a read-only <code><a href=\"Slice.html\">Slice</a></code> of the limbs that make up this integer, which is effectively <code>abs.digits(2 ** N)</code> where <code>N</code> is the number of bits in <code>LibGMP::MpLimb</code>, except that an empty <code><a href=\"Slice.html\">Slice</a></code> is returned for zero.</p>","abstract":false,"args":[{"name":"num","external_name":"num","restriction":"BigRational"}],"args_string":"(num : BigRational) : self","args_html":"(num : <a href=\"BigRational.html\">BigRational</a>) : <span class=\"k\">self</span>","location":{"filename":"src/big/big_int.cr","line_number":123,"url":null},"def":{"name":"new","args":[{"name":"num","external_name":"num","restriction":"BigRational"}],"return_type":"self","visibility":"Public","body":"num.to_big_i"},"external_var":false},{"html_id":"new(num:BigInt):self-class-method","name":"new","doc":"Returns *num*. Useful for generic code that does `T.new(...)` with `T`\nbeing a `Number`.","summary":"<p>Returns <em>num</em>.</p>","abstract":false,"args":[{"name":"num","external_name":"num","restriction":"BigInt"}],"args_string":"(num : BigInt) : self","args_html":"(num : <a href=\"BigInt.html\">BigInt</a>) : <span class=\"k\">self</span>","location":{"filename":"src/big/big_int.cr","line_number":129,"url":null},"def":{"name":"new","args":[{"name":"num","external_name":"num","restriction":"BigInt"}],"return_type":"self","visibility":"Public","body":"num"},"external_var":false},{"html_id":"new(pull:JSON::PullParser):self-class-method","name":"new","abstract":false,"args":[{"name":"pull","external_name":"pull","restriction":"JSON::PullParser"}],"args_string":"(pull : JSON::PullParser) : self","args_html":"(pull : <a href=\"JSON/PullParser.html\">JSON::PullParser</a>) : <span class=\"k\">self</span>","location":{"filename":"src/big/json.cr","line_number":14,"url":null},"def":{"name":"new","args":[{"name":"pull","external_name":"pull","restriction":"JSON::PullParser"}],"return_type":"self","visibility":"Public","body":"case pull.kind\nwhen .int?\n  value = pull.raw_value\n  pull.read_next\nelse\n  value = pull.read_string\nend\nnew(value)\n"},"external_var":false},{"html_id":"new-class-method","name":"new","doc":"Creates a `BigInt` with the value zero.\n\n```\nrequire \"big\"\n\nBigInt.new # => 0\n```","summary":"<p>Creates a <code><a href=\"BigInt.html\">BigInt</a></code> with the value zero.</p>","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":23,"url":null},"def":{"name":"new","visibility":"Public","body":"_ = allocate\n_.initialize\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false}],"instance_methods":[{"html_id":"%(other:Int):BigInt-instance-method","name":"%","doc":"Returns `self` modulo *other*.\n\nThis uses floored division.\n\nSee `Int#/` for more details.","summary":"<p>Returns <code>self</code> modulo <em>other</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":334,"url":null},"def":{"name":"%","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigInt","visibility":"Public","body":"check_division_by_zero(other)\n\nunsafe_floored_mod(other)\n"},"external_var":false},{"html_id":"&(other:BigInt):BigInt-instance-method","name":"&","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":451,"url":null},"def":{"name":"&","args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz| LibGMP.and(mpz, self, other) end"},"external_var":false},{"html_id":"&(other:Int):BigInt-instance-method","name":"&","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":455,"url":null},"def":{"name":"&","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigInt","visibility":"Public","body":"ret = other.to_big_i\nLibGMP.and(ret, ret, self)\nret\n"},"external_var":false},{"html_id":"&*(other):BigInt-instance-method","name":"&*","abstract":false,"args":[{"name":"other","external_name":"other","restriction":""}],"args_string":"(other) : BigInt","args_html":"(other) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":286,"url":null},"def":{"name":"&*","args":[{"name":"other","external_name":"other","restriction":""}],"return_type":"BigInt","visibility":"Public","body":"self * other"},"external_var":false},{"html_id":"&+(other):BigInt-instance-method","name":"&+","abstract":false,"args":[{"name":"other","external_name":"other","restriction":""}],"args_string":"(other) : BigInt","args_html":"(other) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":233,"url":null},"def":{"name":"&+","args":[{"name":"other","external_name":"other","restriction":""}],"return_type":"BigInt","visibility":"Public","body":"self + other"},"external_var":false},{"html_id":"&-(other):BigInt-instance-method","name":"&-","abstract":false,"args":[{"name":"other","external_name":"other","restriction":""}],"args_string":"(other) : BigInt","args_html":"(other) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":251,"url":null},"def":{"name":"&-","args":[{"name":"other","external_name":"other","restriction":""}],"return_type":"BigInt","visibility":"Public","body":"self - other"},"external_var":false},{"html_id":"*(other:BigInt):BigInt-instance-method","name":"*","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":272,"url":null},"def":{"name":"*","args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz| LibGMP.mul(mpz, self, other) end"},"external_var":false},{"html_id":"*(other:Int):BigInt-instance-method","name":"*","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":276,"url":null},"def":{"name":"*","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigInt","visibility":"Public","body":"Int.primitive_si_ui_check(other) do |si, ui, big_i|\n  {\n    si: BigInt.new do |mpz| LibGMP.mul_si(mpz, self, {{ si }}) end,\n    ui: BigInt.new do |mpz| LibGMP.mul_ui(mpz, self, {{ ui }}) end,\n    big_i: self * ({{ big_i }}),\n  }\nend"},"external_var":false},{"html_id":"**(other:Int):BigInt-instance-method","name":"**","doc":"Returns the value of raising `self` to the power of *exponent*.\n\nRaises `ArgumentError` if *exponent* is negative: if this is needed,\neither use a float base or a float exponent.\n\nRaises `OverflowError` in case of overflow.\n\n```\n2 ** 3  # => 8\n2 ** 0  # => 1\n2 ** -1 # ArgumentError\n```","summary":"<p>Returns the value of raising <code>self</code> to the power of <em>exponent</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":496,"url":null},"def":{"name":"**","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigInt","visibility":"Public","body":"if other < 0\n  raise(ArgumentError.new(\"Negative exponent isn't supported\"))\nelsif other == 1\n  self\nelse\n  BigInt.new do |mpz| LibGMP.pow_ui(mpz, self, other) end\nend"},"external_var":false},{"html_id":"+(other:BigInt):BigInt-instance-method","name":"+","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":219,"url":null},"def":{"name":"+","args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz| LibGMP.add(mpz, self, other) end"},"external_var":false},{"html_id":"+(other:Int):BigInt-instance-method","name":"+","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":223,"url":null},"def":{"name":"+","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigInt","visibility":"Public","body":"Int.primitive_ui_check(other) do |ui, neg_ui, big_i|\n  {\n    ui: BigInt.new do |mpz| LibGMP.add_ui(mpz, self, {{ ui }}) end,\n    neg_ui: BigInt.new do |mpz| LibGMP.sub_ui(mpz, self, {{ neg_ui }}) end,\n    big_i: self + ({{ big_i }}),\n  }\nend"},"external_var":false},{"html_id":"-(other:BigInt):BigInt-instance-method","name":"-","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":237,"url":null},"def":{"name":"-","args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz| LibGMP.sub(mpz, self, other) end"},"external_var":false},{"html_id":"-(other:Int):BigInt-instance-method","name":"-","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":241,"url":null},"def":{"name":"-","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigInt","visibility":"Public","body":"Int.primitive_ui_check(other) do |ui, neg_ui, big_i|\n  {\n    ui: BigInt.new do |mpz| LibGMP.sub_ui(mpz, self, {{ ui }}) end,\n    neg_ui: BigInt.new do |mpz| LibGMP.add_ui(mpz, self, {{ neg_ui }}) end,\n    big_i: self - ({{ big_i }}),\n  }\nend"},"external_var":false},{"html_id":"-:BigInt-instance-method","name":"-","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":255,"url":null},"def":{"name":"-","return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz| LibGMP.neg(mpz, self) end"},"external_var":false},{"html_id":"/(other:BigInt):BigFloat-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigFloat","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/big_int.cr","line_number":290,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"},"external_var":false},{"html_id":"/(other:BigDecimal):BigDecimal-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : BigDecimal","args_html":"(other : <a href=\"BigDecimal.html\">BigDecimal</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_int.cr","line_number":291,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"BigDecimal"}],"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"},"external_var":false},{"html_id":"/(other:BigRational):BigRational-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational) : BigRational","args_html":"(other : <a href=\"BigRational.html\">BigRational</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_int.cr","line_number":292,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"},"external_var":false},{"html_id":"/(other:Int8):BigFloat-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int8"}],"args_string":"(other : Int8) : BigFloat","args_html":"(other : <a href=\"Int8.html\">Int8</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":2,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"Int8"}],"return_type":"BigFloat","visibility":"Public","body":"(BigFloat\n  .new(self)) / (BigFloat\n  .new(other))"},"external_var":false},{"html_id":"/(other:UInt8):BigFloat-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"UInt8"}],"args_string":"(other : UInt8) : BigFloat","args_html":"(other : <a href=\"UInt8.html\">UInt8</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":2,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"UInt8"}],"return_type":"BigFloat","visibility":"Public","body":"(BigFloat\n  .new(self)) / (BigFloat\n  .new(other))"},"external_var":false},{"html_id":"/(other:Int16):BigFloat-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int16"}],"args_string":"(other : Int16) : BigFloat","args_html":"(other : <a href=\"Int16.html\">Int16</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":2,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"Int16"}],"return_type":"BigFloat","visibility":"Public","body":"(BigFloat\n  .new(self)) / (BigFloat\n  .new(other))"},"external_var":false},{"html_id":"/(other:UInt16):BigFloat-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"UInt16"}],"args_string":"(other : UInt16) : BigFloat","args_html":"(other : <a href=\"UInt16.html\">UInt16</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":2,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"UInt16"}],"return_type":"BigFloat","visibility":"Public","body":"(BigFloat\n  .new(self)) / (BigFloat\n  .new(other))"},"external_var":false},{"html_id":"/(other:Int32):BigFloat-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int32"}],"args_string":"(other : Int32) : BigFloat","args_html":"(other : <a href=\"Int32.html\">Int32</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":2,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"Int32"}],"return_type":"BigFloat","visibility":"Public","body":"(BigFloat\n  .new(self)) / (BigFloat\n  .new(other))"},"external_var":false},{"html_id":"/(other:UInt32):BigFloat-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"UInt32"}],"args_string":"(other : UInt32) : BigFloat","args_html":"(other : <a href=\"UInt32.html\">UInt32</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":2,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"UInt32"}],"return_type":"BigFloat","visibility":"Public","body":"(BigFloat\n  .new(self)) / (BigFloat\n  .new(other))"},"external_var":false},{"html_id":"/(other:Int64):BigFloat-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int64"}],"args_string":"(other : Int64) : BigFloat","args_html":"(other : <a href=\"Int64.html\">Int64</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":2,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"Int64"}],"return_type":"BigFloat","visibility":"Public","body":"(BigFloat\n  .new(self)) / (BigFloat\n  .new(other))"},"external_var":false},{"html_id":"/(other:UInt64):BigFloat-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"UInt64"}],"args_string":"(other : UInt64) : BigFloat","args_html":"(other : <a href=\"UInt64.html\">UInt64</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":2,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"UInt64"}],"return_type":"BigFloat","visibility":"Public","body":"(BigFloat\n  .new(self)) / (BigFloat\n  .new(other))"},"external_var":false},{"html_id":"/(other:Int128):BigFloat-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int128"}],"args_string":"(other : Int128) : BigFloat","args_html":"(other : <a href=\"Int128.html\">Int128</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":2,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"Int128"}],"return_type":"BigFloat","visibility":"Public","body":"(BigFloat\n  .new(self)) / (BigFloat\n  .new(other))"},"external_var":false},{"html_id":"/(other:UInt128):BigFloat-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"UInt128"}],"args_string":"(other : UInt128) : BigFloat","args_html":"(other : <a href=\"UInt128.html\">UInt128</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":2,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"UInt128"}],"return_type":"BigFloat","visibility":"Public","body":"(BigFloat\n  .new(self)) / (BigFloat\n  .new(other))"},"external_var":false},{"html_id":"/(other:Float32):BigFloat-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Float32"}],"args_string":"(other : Float32) : BigFloat","args_html":"(other : <a href=\"Float32.html\">Float32</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":3,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"Float32"}],"return_type":"BigFloat","visibility":"Public","body":"(BigFloat\n  .new(self)) / (BigFloat\n  .new(other))"},"external_var":false},{"html_id":"/(other:Float64):BigFloat-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Float64"}],"args_string":"(other : Float64) : BigFloat","args_html":"(other : <a href=\"Float64.html\">Float64</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":3,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"Float64"}],"return_type":"BigFloat","visibility":"Public","body":"(BigFloat\n  .new(self)) / (BigFloat\n  .new(other))"},"external_var":false},{"html_id":"//(other:Int):BigInt-instance-method","name":"//","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":294,"url":null},"def":{"name":"//","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigInt","visibility":"Public","body":"check_division_by_zero(other)\n\nunsafe_floored_div(other)\n"},"external_var":false},{"html_id":"<<(other:Int):BigInt-instance-method","name":"<<","doc":"Returns the result of shifting this number's bits *count* positions to the left.\n\n* If *count* is greater than the number of bits of this integer, returns 0\n* If *count* is negative, a right shift is performed\n\n```\n8000 << 1  # => 16000\n8000 << 2  # => 32000\n8000 << 32 # => 0\n8000 << -1 # => 4000\n```","summary":"<p>Returns the result of shifting this number's bits <em>count</em> positions to the left.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":492,"url":null},"def":{"name":"<<","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz| LibGMP.mul_2exp(mpz, self, other) end"},"external_var":false},{"html_id":"<=>(other:BigInt)-instance-method","name":"<=>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt)","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>)","location":{"filename":"src/big/big_int.cr","line_number":201,"url":null},"def":{"name":"<=>","args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"visibility":"Public","body":"LibGMP.cmp(mpz, other)"},"external_var":false},{"html_id":"<=>(other:Int)-instance-method","name":"<=>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int)","args_html":"(other : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/big/big_int.cr","line_number":205,"url":null},"def":{"name":"<=>","args":[{"name":"other","external_name":"other","restriction":"Int"}],"visibility":"Public","body":"Int.primitive_si_ui_check(other) do |si, ui, big_i|\n  {\n    si: LibGMP.cmp_si(self, {{ si }}),\n    ui: LibGMP.cmp_ui(self, {{ ui }}),\n    big_i: self <=> ({{ big_i }}),\n  }\nend"},"external_var":false},{"html_id":"<=>(other:Float::Primitive):Int32|Nil-instance-method","name":"<=>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Float::Primitive"}],"args_string":"(other : Float::Primitive) : Int32 | Nil","args_html":"(other : <a href=\"Float/Primitive.html\">Float::Primitive</a>) : <a href=\"Int32.html\">Int32</a> | <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/big/big_int.cr","line_number":215,"url":null},"def":{"name":"<=>","args":[{"name":"other","external_name":"other","restriction":"Float::Primitive"}],"return_type":"Int32 | ::Nil","visibility":"Public","body":"if other.nan?\nelse\n  LibGMP.cmp_d(mpz, other)\nend"},"external_var":false},{"html_id":">>(other:Int):BigInt-instance-method","name":">>","doc":"Returns the result of shifting this number's bits *count* positions to the right.\nAlso known as arithmetic right shift.\n\n* If *count* is greater than the number of bits of this integer, returns 0\n* If *count* is negative, a left shift is performed\n\n```\n8000 >> 1  # => 4000\n8000 >> 2  # => 2000\n8000 >> 32 # => 0\n8000 >> -1 # => 16000\n\n-8000 >> 1 # => -4000\n```","summary":"<p>Returns the result of shifting this number's bits <em>count</em> positions to the right.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":481,"url":null},"def":{"name":">>","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz| LibGMP.fdiv_q_2exp(mpz, self, other) end"},"external_var":false},{"html_id":"^(other:BigInt):BigInt-instance-method","name":"^","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":471,"url":null},"def":{"name":"^","args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz| LibGMP.xor(mpz, self, other) end"},"external_var":false},{"html_id":"^(other:Int):BigInt-instance-method","name":"^","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":475,"url":null},"def":{"name":"^","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigInt","visibility":"Public","body":"ret = other.to_big_i\nLibGMP.xor(ret, ret, self)\nret\n"},"external_var":false},{"html_id":"|(other:BigInt):BigInt-instance-method","name":"|","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":461,"url":null},"def":{"name":"|","args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz| LibGMP.ior(mpz, self, other) end"},"external_var":false},{"html_id":"|(other:Int):BigInt-instance-method","name":"|","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":465,"url":null},"def":{"name":"|","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigInt","visibility":"Public","body":"ret = other.to_big_i\nLibGMP.ior(ret, ret, self)\nret\n"},"external_var":false},{"html_id":"~:BigInt-instance-method","name":"~","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":441,"url":null},"def":{"name":"~","return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz| LibGMP.com(mpz, self) end"},"external_var":false},{"html_id":"abs:BigInt-instance-method","name":"abs","doc":"Returns the absolute value of this number.\n\n```\n123.abs  # => 123\n-123.abs # => 123\n```","summary":"<p>Returns the absolute value of this number.</p>","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":259,"url":null},"def":{"name":"abs","return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz| LibGMP.abs(mpz, self) end"},"external_var":false},{"html_id":"bit(bit:Int):Int32-instance-method","name":"bit","abstract":false,"args":[{"name":"bit","external_name":"bit","restriction":"Int"}],"args_string":"(bit : Int) : Int32","args_html":"(bit : <a href=\"Int.html\">Int</a>) : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/big/big_int.cr","line_number":445,"url":null},"def":{"name":"bit","args":[{"name":"bit","external_name":"bit","restriction":"Int"}],"return_type":"Int32","visibility":"Public","body":"if bit < 0\n  return 0\nend\nif bit > LibGMP::BitcntT::MAX\n  return self < 0 ? 1 : 0\nend\nLibGMP.tstbit(self, LibGMP::BitcntT.new!(bit))\n"},"external_var":false},{"html_id":"bit_length:Int32-instance-method","name":"bit_length","doc":"Returns the number of bits of this int value.\n\n“The number of bits” means that the bit position of the highest bit\nwhich is different to the sign bit.\n(The bit position of the bit 2**n is n+1.)\nIf there is no such bit (zero or minus one), zero is returned.\n\nI.e. This method returns `ceil(log2(self < 0 ? -self : self + 1))`.\n\n```\n0.bit_length # => 0\n1.bit_length # => 1\n2.bit_length # => 2\n3.bit_length # => 2\n4.bit_length # => 3\n5.bit_length # => 3\n\n# The above is the same as\n0b0.bit_length   # => 0\n0b1.bit_length   # => 1\n0b10.bit_length  # => 2\n0b11.bit_length  # => 2\n0b100.bit_length # => 3\n0b101.bit_length # => 3\n```","summary":"<p>Returns the number of bits of this int value.</p>","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":544,"url":null},"def":{"name":"bit_length","return_type":"Int32","visibility":"Public","body":"(LibGMP.sizeinbase(self, 2)).to_i"},"external_var":false},{"html_id":"clone:BigInt-instance-method","name":"clone","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":851,"url":null},"def":{"name":"clone","return_type":"BigInt","visibility":"Public","body":"self"},"external_var":false},{"html_id":"digits(base=10):Array(Int32)-instance-method","name":"digits","doc":"Returns the digits of a number in a given base.\nThe digits are returned as an array with the least significant digit as the first array element.\n\n```\n12345.digits      # => [5, 4, 3, 2, 1]\n12345.digits(7)   # => [4, 6, 6, 0, 5]\n12345.digits(100) # => [45, 23, 1]\n\n-12345.digits(7) # => ArgumentError\n```","summary":"<p>Returns the digits of a number in a given base.</p>","abstract":false,"args":[{"name":"base","default_value":"10","external_name":"base","restriction":""}],"args_string":"(base = 10) : Array(Int32)","args_html":"(base = <span class=\"n\">10</span>) : <a href=\"Array.html\">Array</a>(<a href=\"Int32.html\">Int32</a>)","location":{"filename":"src/big/big_int.cr","line_number":673,"url":null},"def":{"name":"digits","args":[{"name":"base","default_value":"10","external_name":"base","restriction":""}],"return_type":"Array(Int32)","visibility":"Public","body":"if self < 0\n  raise(ArgumentError.new(\"Can't request digits of negative number\"))\nend\n\nary = [] of Int32\n(self.to_s(base)).each_char do |c| ary << (c.to_i(base)) end\nary.reverse!\nary\n"},"external_var":false},{"html_id":"divisible_by?(number:BigInt):Bool-instance-method","name":"divisible_by?","abstract":false,"args":[{"name":"number","external_name":"number","restriction":"BigInt"}],"args_string":"(number : BigInt) : Bool","args_html":"(number : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/big/big_int.cr","line_number":416,"url":null},"def":{"name":"divisible_by?","args":[{"name":"number","external_name":"number","restriction":"BigInt"}],"return_type":"Bool","visibility":"Public","body":"(LibGMP.divisible_p(self, number)) != 0"},"external_var":false},{"html_id":"divisible_by?(number:Int):Bool-instance-method","name":"divisible_by?","abstract":false,"args":[{"name":"number","external_name":"number","restriction":"Int"}],"args_string":"(number : Int) : Bool","args_html":"(number : <a href=\"Int.html\">Int</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/big/big_int.cr","line_number":420,"url":null},"def":{"name":"divisible_by?","args":[{"name":"number","external_name":"number","restriction":"Int"}],"return_type":"Bool","visibility":"Public","body":"Int.primitive_ui_check(number) do |ui, neg_ui, big_i|\n  {\n    ui: (LibGMP.divisible_ui_p(self, {{ ui }})) != 0,\n    neg_ui: (LibGMP.divisible_ui_p(self, {{ neg_ui }})) != 0,\n    big_i: divisible_by?({{ big_i }}),\n  }\nend"},"external_var":false},{"html_id":"divmod(number:Int):Tuple(BigInt,BigInt)-instance-method","name":"divmod","abstract":false,"args":[{"name":"number","external_name":"number","restriction":"Int"}],"args_string":"(number : Int) : Tuple(BigInt, BigInt)","args_html":"(number : <a href=\"Int.html\">Int</a>) : <a href=\"Tuple.html\">Tuple</a>(<a href=\"BigInt.html\">BigInt</a>, <a href=\"BigInt.html\">BigInt</a>)","location":{"filename":"src/big/big_int.cr","line_number":346,"url":null},"def":{"name":"divmod","args":[{"name":"number","external_name":"number","restriction":"Int"}],"return_type":"::Tuple(BigInt, BigInt)","visibility":"Public","body":"check_division_by_zero(number)\n\nunsafe_floored_divmod(number)\n"},"external_var":false},{"html_id":"factorial:BigInt-instance-method","name":"factorial","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":263,"url":null},"def":{"name":"factorial","return_type":"BigInt","visibility":"Public","body":"if self < 0\n  raise(ArgumentError.new(\"Factorial not defined for negative values\"))\nelsif self > LibGMP::UI::MAX\n  raise(ArgumentError.new(\"Factorial not supported for numbers bigger than #{LibGMP::UI::MAX}\"))\nend\nBigInt.new do |mpz| LibGMP.fac_ui(mpz, LibGMP::UI.new!(self)) end\n"},"external_var":false},{"html_id":"gcd(other:BigInt):BigInt-instance-method","name":"gcd","doc":"Returns the greatest common divisor of `self` and *other*.","summary":"<p>Returns the greatest common divisor of <code>self</code> and <em>other</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":507,"url":null},"def":{"name":"gcd","args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz| LibGMP.gcd(mpz, self, other) end"},"external_var":false},{"html_id":"gcd(other:Int):Int-instance-method","name":"gcd","doc":"Returns the greatest common divisor of `self` and *other*.","summary":"<p>Returns the greatest common divisor of <code>self</code> and <em>other</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : Int","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"Int.html\">Int</a>","location":{"filename":"src/big/big_int.cr","line_number":512,"url":null},"def":{"name":"gcd","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"Int","visibility":"Public","body":"Int.primitive_ui_check(other) do |ui, neg_ui, big_i|\n  {\n    ui: begin\n      result = LibGMP.gcd_ui(nil, self, {{ ui }})\n      result == 0 ? self : result\n    end,\n    neg_ui: begin\n      result = LibGMP.gcd_ui(nil, self, {{ neg_ui }})\n      result == 0 ? self : result\n    end,\n    big_i: gcd({{ big_i }}),\n  }\nend"},"external_var":false},{"html_id":"lcm(other:BigInt):BigInt-instance-method","name":"lcm","doc":"Returns the least common multiple of `self` and *other*.","summary":"<p>Returns the least common multiple of <code>self</code> and <em>other</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":529,"url":null},"def":{"name":"lcm","args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz| LibGMP.lcm(mpz, self, other) end"},"external_var":false},{"html_id":"lcm(other:Int):BigInt-instance-method","name":"lcm","doc":"Returns the least common multiple of `self` and *other*.","summary":"<p>Returns the least common multiple of <code>self</code> and <em>other</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":534,"url":null},"def":{"name":"lcm","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigInt","visibility":"Public","body":"Int.primitive_ui_check(other) do |ui, neg_ui, big_i|\n  {\n    ui: BigInt.new do |mpz| LibGMP.lcm_ui(mpz, self, {{ ui }}) end,\n    neg_ui: BigInt.new do |mpz| LibGMP.lcm_ui(mpz, self, {{ neg_ui }}) end,\n    big_i: lcm({{ big_i }}),\n  }\nend"},"external_var":false},{"html_id":"popcount:Int-instance-method","name":"popcount","doc":"Counts `1`-bits in the binary representation of this integer.\n\n```\n5.popcount   # => 2\n-15.popcount # => 29\n```","summary":"<p>Counts <code>1</code>-bits in the binary representation of this integer.</p>","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":684,"url":null},"def":{"name":"popcount","return_type":"Int","visibility":"Public","body":"LibGMP.popcount(self)"},"external_var":false},{"html_id":"remainder(other:Int):BigInt-instance-method","name":"remainder","doc":"Returns `self` remainder *other*.\n\nThis uses truncated division.\n\nSee `Int#tdiv` for more details.","summary":"<p>Returns <code>self</code> remainder <em>other</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":340,"url":null},"def":{"name":"remainder","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigInt","visibility":"Public","body":"check_division_by_zero(other)\n\nunsafe_truncated_mod(other)\n"},"external_var":false},{"html_id":"tdiv(other:Int):BigInt-instance-method","name":"tdiv","doc":"Divides `self` by *other* using truncated division.\n\nIn truncated division, given two integers x and y:\n* `q = x.tdiv(y)` is rounded toward zero\n* `r = x.remainder(y)` has the sign of x\n* `x == q*y + r`\n\nFor example:\n\n```text\n x     y     x / y     x % y\n 5     3       1         2\n-5     3      -1        -2\n 5    -3      -1         2\n-5    -3       1        -2\n```\n\nRaises if *other* is `0`, or if *other* is `-1` and\n`self` is signed and is the minimum value for that\ninteger type.","summary":"<p>Divides <code>self</code> by <em>other</em> using truncated division.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":300,"url":null},"def":{"name":"tdiv","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigInt","visibility":"Public","body":"check_division_by_zero(other)\n\nunsafe_truncated_div(other)\n"},"external_var":false},{"html_id":"to_big_d:BigDecimal-instance-method","name":"to_big_d","doc":"Converts `self` to `BigDecimal`.\n```\nrequire \"big\"\n123456789012345678.to_big_d\n```","summary":"<p>Converts <code>self</code> to <code><a href=\"BigDecimal.html\">BigDecimal</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":843,"url":null},"def":{"name":"to_big_d","return_type":"BigDecimal","visibility":"Public","body":"BigDecimal.new(self)"},"external_var":false},{"html_id":"to_big_f:BigFloat-instance-method","name":"to_big_f","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":839,"url":null},"def":{"name":"to_big_f","return_type":"BigFloat","visibility":"Public","body":"BigFloat.new do |mpf| LibGMP.mpf_set_z(mpf, mpz) end"},"external_var":false},{"html_id":"to_big_i:BigInt-instance-method","name":"to_big_i","doc":"Returns a `BigInt` representing this integer.\n```\nrequire \"big\"\n\n123.to_big_i\n```","summary":"<p>Returns a <code><a href=\"BigInt.html\">BigInt</a></code> representing this integer.</p>","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":835,"url":null},"def":{"name":"to_big_i","return_type":"BigInt","visibility":"Public","body":"self"},"external_var":false},{"html_id":"to_big_r:BigRational-instance-method","name":"to_big_r","doc":"Returns a `BigRational` representing this integer.\n```\nrequire \"big\"\n\n123.to_big_r\n```","summary":"<p>Returns a <code><a href=\"BigRational.html\">BigRational</a></code> representing this integer.</p>","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":847,"url":null},"def":{"name":"to_big_r","return_type":"BigRational","visibility":"Public","body":"BigRational.new(self)"},"external_var":false},{"html_id":"to_f:Float64-instance-method","name":"to_f","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":811,"url":null},"def":{"name":"to_f","return_type":"Float64","visibility":"Public","body":"to_f64"},"external_var":false},{"html_id":"to_f!-instance-method","name":"to_f!","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":823,"url":null},"def":{"name":"to_f!","visibility":"Public","body":"to_f64!"},"external_var":false},{"html_id":"to_f32:Float32-instance-method","name":"to_f32","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":815,"url":null},"def":{"name":"to_f32","return_type":"Float32","visibility":"Public","body":"to_f64.to_f32"},"external_var":false},{"html_id":"to_f32!-instance-method","name":"to_f32!","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":827,"url":null},"def":{"name":"to_f32!","visibility":"Public","body":"(LibGMP.get_d(self)).to_f32!"},"external_var":false},{"html_id":"to_f64:Float64-instance-method","name":"to_f64","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":819,"url":null},"def":{"name":"to_f64","return_type":"Float64","visibility":"Public","body":"LibGMP.get_d(self)"},"external_var":false},{"html_id":"to_f64!-instance-method","name":"to_f64!","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":831,"url":null},"def":{"name":"to_f64!","visibility":"Public","body":"LibGMP.get_d(self)"},"external_var":false},{"html_id":"to_i:Int32-instance-method","name":"to_i","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":700,"url":null},"def":{"name":"to_i","return_type":"Int32","visibility":"Public","body":"to_i32"},"external_var":false},{"html_id":"to_i!:Int32-instance-method","name":"to_i!","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":704,"url":null},"def":{"name":"to_i!","return_type":"Int32","visibility":"Public","body":"to_i32!"},"external_var":false},{"html_id":"to_i128:Int128-instance-method","name":"to_i128","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":716,"url":null},"def":{"name":"to_i128","return_type":"Int128","visibility":"Public","body":"{% if Int128 == LibGMP::SI %}\n        LibGMP.fits_slong_p(self) != 0 ? LibGMP.get_si(self) : raise OverflowError.new\n      {% elsif Int128::MAX.is_a?(NumberLiteral) && Int128::MAX < LibGMP::SI::MAX %}\n        LibGMP::SI.new(self).to_i128\n      {% else %}\n        to_primitive_i(Int128)\n      {% end %}"},"external_var":false},{"html_id":"to_i128!:Int128-instance-method","name":"to_i128!","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":716,"url":null},"def":{"name":"to_i128!","return_type":"Int128","visibility":"Public","body":"to_u128!.to_i128!"},"external_var":false},{"html_id":"to_i16:Int16-instance-method","name":"to_i16","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":716,"url":null},"def":{"name":"to_i16","return_type":"Int16","visibility":"Public","body":"{% if Int16 == LibGMP::SI %}\n        LibGMP.fits_slong_p(self) != 0 ? LibGMP.get_si(self) : raise OverflowError.new\n      {% elsif Int16::MAX.is_a?(NumberLiteral) && Int16::MAX < LibGMP::SI::MAX %}\n        LibGMP::SI.new(self).to_i16\n      {% else %}\n        to_primitive_i(Int16)\n      {% end %}"},"external_var":false},{"html_id":"to_i16!:Int16-instance-method","name":"to_i16!","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":716,"url":null},"def":{"name":"to_i16!","return_type":"Int16","visibility":"Public","body":"to_u16!.to_i16!"},"external_var":false},{"html_id":"to_i32:Int32-instance-method","name":"to_i32","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":716,"url":null},"def":{"name":"to_i32","return_type":"Int32","visibility":"Public","body":"{% if Int32 == LibGMP::SI %}\n        LibGMP.fits_slong_p(self) != 0 ? LibGMP.get_si(self) : raise OverflowError.new\n      {% elsif Int32::MAX.is_a?(NumberLiteral) && Int32::MAX < LibGMP::SI::MAX %}\n        LibGMP::SI.new(self).to_i32\n      {% else %}\n        to_primitive_i(Int32)\n      {% end %}"},"external_var":false},{"html_id":"to_i32!:Int32-instance-method","name":"to_i32!","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":716,"url":null},"def":{"name":"to_i32!","return_type":"Int32","visibility":"Public","body":"to_u32!.to_i32!"},"external_var":false},{"html_id":"to_i64:Int64-instance-method","name":"to_i64","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":716,"url":null},"def":{"name":"to_i64","return_type":"Int64","visibility":"Public","body":"{% if Int64 == LibGMP::SI %}\n        LibGMP.fits_slong_p(self) != 0 ? LibGMP.get_si(self) : raise OverflowError.new\n      {% elsif Int64::MAX.is_a?(NumberLiteral) && Int64::MAX < LibGMP::SI::MAX %}\n        LibGMP::SI.new(self).to_i64\n      {% else %}\n        to_primitive_i(Int64)\n      {% end %}"},"external_var":false},{"html_id":"to_i64!:Int64-instance-method","name":"to_i64!","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":716,"url":null},"def":{"name":"to_i64!","return_type":"Int64","visibility":"Public","body":"to_u64!.to_i64!"},"external_var":false},{"html_id":"to_i8:Int8-instance-method","name":"to_i8","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":716,"url":null},"def":{"name":"to_i8","return_type":"Int8","visibility":"Public","body":"{% if Int8 == LibGMP::SI %}\n        LibGMP.fits_slong_p(self) != 0 ? LibGMP.get_si(self) : raise OverflowError.new\n      {% elsif Int8::MAX.is_a?(NumberLiteral) && Int8::MAX < LibGMP::SI::MAX %}\n        LibGMP::SI.new(self).to_i8\n      {% else %}\n        to_primitive_i(Int8)\n      {% end %}"},"external_var":false},{"html_id":"to_i8!:Int8-instance-method","name":"to_i8!","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":716,"url":null},"def":{"name":"to_i8!","return_type":"Int8","visibility":"Public","body":"to_u8!.to_i8!"},"external_var":false},{"html_id":"to_json(json:JSON::Builder):Nil-instance-method","name":"to_json","abstract":false,"args":[{"name":"json","external_name":"json","restriction":"JSON::Builder"}],"args_string":"(json : JSON::Builder) : Nil","args_html":"(json : <a href=\"JSON/Builder.html\">JSON::Builder</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/big/json.cr","line_number":35,"url":null},"def":{"name":"to_json","args":[{"name":"json","external_name":"json","restriction":"JSON::Builder"}],"return_type":"Nil","visibility":"Public","body":"json.number(self)"},"external_var":false},{"html_id":"to_json_object_key:String-instance-method","name":"to_json_object_key","abstract":false,"location":{"filename":"src/big/json.cr","line_number":31,"url":null},"def":{"name":"to_json_object_key","return_type":"String","visibility":"Public","body":"to_s"},"external_var":false},{"html_id":"to_s(io:IO,base:Int=10,*,precision:Int=1,upcase:Bool=false):Nil-instance-method","name":"to_s","doc":"Appends a string representation of this integer to the given *io*.\n\n*base* specifies the radix of the written string, and must be either 62 or\na number between 2 and 36. By default, digits above 9 are represented by\nASCII lowercase letters (`a` for 10, `b` for 11, etc.), but uppercase\nletters may be used if *upcase* is `true`, unless base 62 is used. In that\ncase, lowercase letters are used for 10 to 35, and uppercase ones for 36 to\n61, and *upcase* must be `false`.\n\n*precision* specifies the minimum number of digits in the written string.\nIf there are fewer digits than this number, the string is left-padded by\nzeros. If `self` and *precision* are both zero, returns an empty string.","summary":"<p>Appends a string representation of this integer to the given <em>io</em>.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"base","default_value":"10","external_name":"base","restriction":"Int"},{"name":"","external_name":"","restriction":""},{"name":"precision","default_value":"1","external_name":"precision","restriction":"Int"},{"name":"upcase","default_value":"false","external_name":"upcase","restriction":"Bool"}],"args_string":"(io : IO, base : Int = 10, *, precision : Int = 1, upcase : Bool = false) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>, base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>, *, precision : <a href=\"Int.html\">Int</a> = <span class=\"n\">1</span>, upcase : <a href=\"Bool.html\">Bool</a> = <span class=\"n\">false</span>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/big/big_int.cr","line_number":624,"url":null},"def":{"name":"to_s","args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"base","default_value":"10","external_name":"base","restriction":"Int"},{"name":"","external_name":"","restriction":""},{"name":"precision","default_value":"1","external_name":"precision","restriction":"Int"},{"name":"upcase","default_value":"false","external_name":"upcase","restriction":"Bool"}],"splat_index":2,"return_type":"Nil","visibility":"Public","body":"if (2 <= base && base <= 36) || (base == 62)\nelse\n  raise(ArgumentError.new(\"Invalid base #{base}\"))\nend\nif upcase && (base == 62)\n  raise(ArgumentError.new(\"upcase must be false for base 62\"))\nend\nif precision >= 0\nelse\n  raise(ArgumentError.new(\"Precision must be non-negative\"))\nend\n\ncase {self, precision}\nwhen {0, 0}\nwhen {0, 1}\n  io << '0'\nwhen {1, 1}\n  io << '1'\nelse\n  count = (LibGMP.sizeinbase(self, base)).to_i\n  ptr = LibGMP.get_str(nil, upcase ? -base : base, self)\n  negative = self < 0\n\n\n  if ptr[count + (negative ? 0 : -1)] == 0\n    count = count - 1\n  end\n\n  if precision <= count\n    buffer = Slice.new(ptr, count + (negative ? 1 : 0))\n  else\n    if negative\n      io << '-'\n      ptr = ptr + 1\n    end\n\n    (precision - count).times do io << '0' end\n    buffer = Slice.new(ptr, count)\n  end\n\n  if base == 62\n    base62_swapcase(buffer)\n  end\n  io.write_string(buffer)\nend\n"},"external_var":false},{"html_id":"to_s(base:Int=10,*,precision:Int=1,upcase:Bool=false):String-instance-method","name":"to_s","doc":"Returns a string representation of this integer.\n\n*base* specifies the radix of the returned string, and must be either 62 or\na number between 2 and 36. By default, digits above 9 are represented by\nASCII lowercase letters (`a` for 10, `b` for 11, etc.), but uppercase\nletters may be used if *upcase* is `true`, unless base 62 is used. In that\ncase, lowercase letters are used for 10 to 35, and uppercase ones for 36 to\n61, and *upcase* must be `false`.\n\n*precision* specifies the minimum number of digits in the returned string.\nIf there are fewer digits than this number, the string is left-padded by\nzeros. If `self` and *precision* are both zero, returns an empty string.\n\n```\n1234.to_s                   # => \"1234\"\n1234.to_s(2)                # => \"10011010010\"\n1234.to_s(16)               # => \"4d2\"\n1234.to_s(16, upcase: true) # => \"4D2\"\n1234.to_s(36)               # => \"ya\"\n1234.to_s(62)               # => \"jU\"\n1234.to_s(precision: 2)     # => \"1234\"\n1234.to_s(precision: 6)     # => \"001234\"\n```","summary":"<p>Returns a string representation of this integer.</p>","abstract":false,"args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"},{"name":"","external_name":"","restriction":""},{"name":"precision","default_value":"1","external_name":"precision","restriction":"Int"},{"name":"upcase","default_value":"false","external_name":"upcase","restriction":"Bool"}],"args_string":"(base : Int = 10, *, precision : Int = 1, upcase : Bool = false) : String","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>, *, precision : <a href=\"Int.html\">Int</a> = <span class=\"n\">1</span>, upcase : <a href=\"Bool.html\">Bool</a> = <span class=\"n\">false</span>) : <a href=\"String.html\">String</a>","location":{"filename":"src/big/big_int.cr","line_number":548,"url":null},"def":{"name":"to_s","args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"},{"name":"","external_name":"","restriction":""},{"name":"precision","default_value":"1","external_name":"precision","restriction":"Int"},{"name":"upcase","default_value":"false","external_name":"upcase","restriction":"Bool"}],"splat_index":1,"return_type":"String","visibility":"Public","body":"if (2 <= base && base <= 36) || (base == 62)\nelse\n  raise(ArgumentError.new(\"Invalid base #{base}\"))\nend\nif upcase && (base == 62)\n  raise(ArgumentError.new(\"upcase must be false for base 62\"))\nend\nif precision >= 0\nelse\n  raise(ArgumentError.new(\"Precision must be non-negative\"))\nend\n\ncase {self, precision}\nwhen {0, 0}\n  \"\"\nwhen {0, 1}\n  \"0\"\nwhen {1, 1}\n  \"1\"\nelse\n  count = (LibGMP.sizeinbase(self, base)).to_i\n  negative = self < 0\n\n  if precision <= count\n    len = count + (negative ? 1 : 0)\n    String.new(len + 1) do |buffer|\n      buffer[len - 1] = 0\n      LibGMP.get_str(buffer, upcase ? -base : base, self)\n\n\n      if buffer[len - 1] == 0\n        if precision == count\n          start = buffer + (negative ? 1 : 0)\n          start.move_to(start + 1, count - 1)\n          start.value = '0'.ord.to_u8\n        else\n          len = len - 1\n        end\n      end\n\n      if base == 62\n        base62_swapcase(Slice.new(buffer, len))\n      end\n      {len, len}\n    end\n  else\n    len = precision + (negative ? 1 : 0)\n    String.new(len + 1) do |buffer|\n\n\n\n      buffer[len - 1] = 0\n      start = (buffer + precision) - count\n      LibGMP.get_str(start, upcase ? -base : base, self)\n\n\n      if buffer[len - 1] == 0\n        count = count - 1\n        if negative\n          start = start + 1\n        end\n        start.move_to(start + 1, count)\n      end\n\n      if base == 62\n        base62_swapcase(Slice.new((buffer + len) - count, count))\n      end\n\n      if negative\n        buffer.value = '-'.ord.to_u8\n        buffer = buffer + 1\n      end\n      (Slice.new(buffer, precision - count)).fill('0'.ord.to_u8)\n\n      {len, len}\n    end\n  end\nend\n"},"external_var":false},{"html_id":"to_u:UInt32-instance-method","name":"to_u","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":708,"url":null},"def":{"name":"to_u","return_type":"UInt32","visibility":"Public","body":"to_u32"},"external_var":false},{"html_id":"to_u!:UInt32-instance-method","name":"to_u!","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":712,"url":null},"def":{"name":"to_u!","return_type":"UInt32","visibility":"Public","body":"to_u32!"},"external_var":false},{"html_id":"to_u128:UInt128-instance-method","name":"to_u128","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":716,"url":null},"def":{"name":"to_u128","return_type":"UInt128","visibility":"Public","body":"{% if UInt128 == LibGMP::UI %}\n        LibGMP.fits_ulong_p(self) != 0 ? LibGMP.get_ui(self) : raise OverflowError.new\n      {% elsif UInt128::MAX.is_a?(NumberLiteral) && UInt128::MAX < LibGMP::UI::MAX %}\n        LibGMP::UI.new(self).to_u128\n      {% else %}\n        to_primitive_u(UInt128)\n      {% end %}"},"external_var":false},{"html_id":"to_u128!:UInt128-instance-method","name":"to_u128!","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":716,"url":null},"def":{"name":"to_u128!","return_type":"UInt128","visibility":"Public","body":"{% if UInt128 == LibGMP::UI %}\n        LibGMP.get_ui(self) &* sign\n      {% elsif UInt128::MAX.is_a?(NumberLiteral) && UInt128::MAX < LibGMP::UI::MAX %}\n        LibGMP::UI.new!(self).to_u128!\n      {% else %}\n        to_primitive_u!(UInt128)\n      {% end %}"},"external_var":false},{"html_id":"to_u16:UInt16-instance-method","name":"to_u16","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":716,"url":null},"def":{"name":"to_u16","return_type":"UInt16","visibility":"Public","body":"{% if UInt16 == LibGMP::UI %}\n        LibGMP.fits_ulong_p(self) != 0 ? LibGMP.get_ui(self) : raise OverflowError.new\n      {% elsif UInt16::MAX.is_a?(NumberLiteral) && UInt16::MAX < LibGMP::UI::MAX %}\n        LibGMP::UI.new(self).to_u16\n      {% else %}\n        to_primitive_u(UInt16)\n      {% end %}"},"external_var":false},{"html_id":"to_u16!:UInt16-instance-method","name":"to_u16!","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":716,"url":null},"def":{"name":"to_u16!","return_type":"UInt16","visibility":"Public","body":"{% if UInt16 == LibGMP::UI %}\n        LibGMP.get_ui(self) &* sign\n      {% elsif UInt16::MAX.is_a?(NumberLiteral) && UInt16::MAX < LibGMP::UI::MAX %}\n        LibGMP::UI.new!(self).to_u16!\n      {% else %}\n        to_primitive_u!(UInt16)\n      {% end %}"},"external_var":false},{"html_id":"to_u32:UInt32-instance-method","name":"to_u32","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":716,"url":null},"def":{"name":"to_u32","return_type":"UInt32","visibility":"Public","body":"{% if UInt32 == LibGMP::UI %}\n        LibGMP.fits_ulong_p(self) != 0 ? LibGMP.get_ui(self) : raise OverflowError.new\n      {% elsif UInt32::MAX.is_a?(NumberLiteral) && UInt32::MAX < LibGMP::UI::MAX %}\n        LibGMP::UI.new(self).to_u32\n      {% else %}\n        to_primitive_u(UInt32)\n      {% end %}"},"external_var":false},{"html_id":"to_u32!:UInt32-instance-method","name":"to_u32!","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":716,"url":null},"def":{"name":"to_u32!","return_type":"UInt32","visibility":"Public","body":"{% if UInt32 == LibGMP::UI %}\n        LibGMP.get_ui(self) &* sign\n      {% elsif UInt32::MAX.is_a?(NumberLiteral) && UInt32::MAX < LibGMP::UI::MAX %}\n        LibGMP::UI.new!(self).to_u32!\n      {% else %}\n        to_primitive_u!(UInt32)\n      {% end %}"},"external_var":false},{"html_id":"to_u64:UInt64-instance-method","name":"to_u64","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":716,"url":null},"def":{"name":"to_u64","return_type":"UInt64","visibility":"Public","body":"{% if UInt64 == LibGMP::UI %}\n        LibGMP.fits_ulong_p(self) != 0 ? LibGMP.get_ui(self) : raise OverflowError.new\n      {% elsif UInt64::MAX.is_a?(NumberLiteral) && UInt64::MAX < LibGMP::UI::MAX %}\n        LibGMP::UI.new(self).to_u64\n      {% else %}\n        to_primitive_u(UInt64)\n      {% end %}"},"external_var":false},{"html_id":"to_u64!:UInt64-instance-method","name":"to_u64!","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":716,"url":null},"def":{"name":"to_u64!","return_type":"UInt64","visibility":"Public","body":"{% if UInt64 == LibGMP::UI %}\n        LibGMP.get_ui(self) &* sign\n      {% elsif UInt64::MAX.is_a?(NumberLiteral) && UInt64::MAX < LibGMP::UI::MAX %}\n        LibGMP::UI.new!(self).to_u64!\n      {% else %}\n        to_primitive_u!(UInt64)\n      {% end %}"},"external_var":false},{"html_id":"to_u8:UInt8-instance-method","name":"to_u8","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":716,"url":null},"def":{"name":"to_u8","return_type":"UInt8","visibility":"Public","body":"{% if UInt8 == LibGMP::UI %}\n        LibGMP.fits_ulong_p(self) != 0 ? LibGMP.get_ui(self) : raise OverflowError.new\n      {% elsif UInt8::MAX.is_a?(NumberLiteral) && UInt8::MAX < LibGMP::UI::MAX %}\n        LibGMP::UI.new(self).to_u8\n      {% else %}\n        to_primitive_u(UInt8)\n      {% end %}"},"external_var":false},{"html_id":"to_u8!:UInt8-instance-method","name":"to_u8!","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":716,"url":null},"def":{"name":"to_u8!","return_type":"UInt8","visibility":"Public","body":"{% if UInt8 == LibGMP::UI %}\n        LibGMP.get_ui(self) &* sign\n      {% elsif UInt8::MAX.is_a?(NumberLiteral) && UInt8::MAX < LibGMP::UI::MAX %}\n        LibGMP::UI.new!(self).to_u8!\n      {% else %}\n        to_primitive_u!(UInt8)\n      {% end %}"},"external_var":false},{"html_id":"to_unsafe:Pointer(LibGMP::MPZ)-instance-method","name":"to_unsafe","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":865,"url":null},"def":{"name":"to_unsafe","return_type":"Pointer(LibGMP::MPZ)","visibility":"Public","body":"mpz"},"external_var":false},{"html_id":"trailing_zeros_count:Int-instance-method","name":"trailing_zeros_count","doc":"Returns the number of trailing `0`-bits.","summary":"<p>Returns the number of trailing <code>0</code>-bits.</p>","abstract":false,"location":{"filename":"src/big/big_int.cr","line_number":688,"url":null},"def":{"name":"trailing_zeros_count","return_type":"Int","visibility":"Public","body":"LibGMP.scan1(self, 0)"},"external_var":false},{"html_id":"unsafe_floored_div(other:BigInt):BigInt-instance-method","name":"unsafe_floored_div","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":306,"url":null},"def":{"name":"unsafe_floored_div","args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz| LibGMP.fdiv_q(mpz, self, other) end"},"external_var":false},{"html_id":"unsafe_floored_div(other:Int):BigInt-instance-method","name":"unsafe_floored_div","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":310,"url":null},"def":{"name":"unsafe_floored_div","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigInt","visibility":"Public","body":"Int.primitive_ui_check(other) do |ui, neg_ui, big_i|\n  {\n    ui: BigInt.new do |mpz| LibGMP.fdiv_q_ui(mpz, self, {{ ui }}) end,\n    neg_ui: BigInt.new do |mpz| LibGMP.fdiv_q_ui(mpz, -self, {{ neg_ui }}) end,\n    big_i: unsafe_floored_div({{ big_i }}),\n  }\nend"},"external_var":false},{"html_id":"unsafe_floored_divmod(number:BigInt):Tuple(BigInt,BigInt)-instance-method","name":"unsafe_floored_divmod","abstract":false,"args":[{"name":"number","external_name":"number","restriction":"BigInt"}],"args_string":"(number : BigInt) : Tuple(BigInt, BigInt)","args_html":"(number : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"Tuple.html\">Tuple</a>(<a href=\"BigInt.html\">BigInt</a>, <a href=\"BigInt.html\">BigInt</a>)","location":{"filename":"src/big/big_int.cr","line_number":380,"url":null},"def":{"name":"unsafe_floored_divmod","args":[{"name":"number","external_name":"number","restriction":"BigInt"}],"return_type":"::Tuple(BigInt, BigInt)","visibility":"Public","body":"the_q = BigInt.new\nthe_r = BigInt.new do |r| LibGMP.fdiv_qr(the_q, r, self, number) end\n{the_q, the_r}\n"},"external_var":false},{"html_id":"unsafe_floored_divmod(number:Int):Tuple(BigInt,BigInt)-instance-method","name":"unsafe_floored_divmod","abstract":false,"args":[{"name":"number","external_name":"number","restriction":"Int"}],"args_string":"(number : Int) : Tuple(BigInt, BigInt)","args_html":"(number : <a href=\"Int.html\">Int</a>) : <a href=\"Tuple.html\">Tuple</a>(<a href=\"BigInt.html\">BigInt</a>, <a href=\"BigInt.html\">BigInt</a>)","location":{"filename":"src/big/big_int.cr","line_number":386,"url":null},"def":{"name":"unsafe_floored_divmod","args":[{"name":"number","external_name":"number","restriction":"Int"}],"return_type":"::Tuple(BigInt, BigInt)","visibility":"Public","body":"the_q = BigInt.new\nthe_r = Int.primitive_ui_check(number) do |ui, neg_ui, big_i|\n  {\n    ui: BigInt.new do |r| LibGMP.fdiv_qr_ui(the_q, r, self, {{ ui }}) end,\n    neg_ui: BigInt.new do |r|     LibGMP.fdiv_qr_ui(the_q, r, -self, {{ neg_ui }})\n    LibGMP.neg(r, r)\n end,\n    big_i: BigInt.new do |r| LibGMP.fdiv_qr(the_q, r, self, {{ big_i }}) end,\n  }\nend\n{the_q, the_r}\n"},"external_var":false},{"html_id":"unsafe_floored_mod(other:BigInt):BigInt-instance-method","name":"unsafe_floored_mod","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":352,"url":null},"def":{"name":"unsafe_floored_mod","args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz| LibGMP.fdiv_r(mpz, self, other) end"},"external_var":false},{"html_id":"unsafe_floored_mod(other:Int):BigInt-instance-method","name":"unsafe_floored_mod","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":356,"url":null},"def":{"name":"unsafe_floored_mod","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigInt","visibility":"Public","body":"Int.primitive_ui_check(other) do |ui, neg_ui, big_i|\n  {\n    ui: BigInt.new do |mpz| LibGMP.fdiv_r_ui(mpz, self, {{ ui }}) end,\n    neg_ui: BigInt.new do |mpz|     LibGMP.fdiv_r_ui(mpz, self, {{ neg_ui }})\n    LibGMP.neg(mpz, mpz)\n end,\n    big_i: unsafe_floored_mod({{ big_i }}),\n  }\nend"},"external_var":false},{"html_id":"unsafe_truncated_div(other:BigInt):BigInt-instance-method","name":"unsafe_truncated_div","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":320,"url":null},"def":{"name":"unsafe_truncated_div","args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz| LibGMP.tdiv_q(mpz, self, other) end"},"external_var":false},{"html_id":"unsafe_truncated_div(other:Int):BigInt-instance-method","name":"unsafe_truncated_div","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":324,"url":null},"def":{"name":"unsafe_truncated_div","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigInt","visibility":"Public","body":"Int.primitive_ui_check(other) do |ui, neg_ui, big_i|\n  {\n    ui: BigInt.new do |mpz| LibGMP.tdiv_q_ui(mpz, self, {{ ui }}) end,\n    neg_ui: BigInt.new do |mpz|     LibGMP.tdiv_q_ui(mpz, self, {{ neg_ui }})\n    LibGMP.neg(mpz, mpz)\n end,\n    big_i: unsafe_truncated_div({{ big_i }}),\n  }\nend"},"external_var":false},{"html_id":"unsafe_truncated_divmod(number:BigInt):Tuple(BigInt,BigInt)-instance-method","name":"unsafe_truncated_divmod","abstract":false,"args":[{"name":"number","external_name":"number","restriction":"BigInt"}],"args_string":"(number : BigInt) : Tuple(BigInt, BigInt)","args_html":"(number : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"Tuple.html\">Tuple</a>(<a href=\"BigInt.html\">BigInt</a>, <a href=\"BigInt.html\">BigInt</a>)","location":{"filename":"src/big/big_int.cr","line_number":398,"url":null},"def":{"name":"unsafe_truncated_divmod","args":[{"name":"number","external_name":"number","restriction":"BigInt"}],"return_type":"Tuple(BigInt, BigInt)","visibility":"Public","body":"the_q = BigInt.new\nthe_r = BigInt.new do |r| LibGMP.tdiv_qr(the_q, r, self, number) end\n{the_q, the_r}\n"},"external_var":false},{"html_id":"unsafe_truncated_divmod(number:Int)-instance-method","name":"unsafe_truncated_divmod","abstract":false,"args":[{"name":"number","external_name":"number","restriction":"Int"}],"args_string":"(number : Int)","args_html":"(number : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/big/big_int.cr","line_number":404,"url":null},"def":{"name":"unsafe_truncated_divmod","args":[{"name":"number","external_name":"number","restriction":"Int"}],"visibility":"Public","body":"the_q = BigInt.new\nthe_r = Int.primitive_ui_check(number) do |ui, neg_ui, big_i|\n  {\n    ui: BigInt.new do |r| LibGMP.tdiv_qr_ui(the_q, r, self, {{ ui }}) end,\n    neg_ui: BigInt.new do |r|     LibGMP.tdiv_qr_ui(the_q, r, self, {{ neg_ui }})\n    LibGMP.neg(the_q, the_q)\n end,\n    big_i: BigInt.new do |r| LibGMP.tdiv_qr(the_q, r, self, {{ big_i }}) end,\n  }\nend\n{the_q, the_r}\n"},"external_var":false},{"html_id":"unsafe_truncated_mod(other:BigInt):BigInt-instance-method","name":"unsafe_truncated_mod","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":366,"url":null},"def":{"name":"unsafe_truncated_mod","args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz| LibGMP.tdiv_r(mpz, self, other) end"},"external_var":false},{"html_id":"unsafe_truncated_mod(other:Int):BigInt-instance-method","name":"unsafe_truncated_mod","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":370,"url":null},"def":{"name":"unsafe_truncated_mod","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigInt","visibility":"Public","body":"Int.primitive_ui_check(other) do |ui, neg_ui, big_i|\n  {\n    ui: BigInt.new do |mpz| LibGMP.tdiv_r_ui(mpz, self, {{ ui }}) end,\n    neg_ui: BigInt.new do |mpz| LibGMP.tdiv_r_ui(mpz, self, {{ neg_ui }}) end,\n    big_i: unsafe_truncated_mod({{ big_i }}),\n  }\nend"},"external_var":false}]},{"html_id":"Crystal/BigRational","path":"BigRational.html","kind":"struct","full_name":"BigRational","name":"BigRational","abstract":false,"superclass":{"html_id":"Crystal/Number","kind":"struct","full_name":"Number","name":"Number"},"ancestors":[{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Number","kind":"struct","full_name":"Number","name":"Number"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Steppable","kind":"module","full_name":"Steppable","name":"Steppable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/big.cr","line_number":8,"url":null},{"filename":"src/big/big_decimal.cr","line_number":837,"url":null},{"filename":"src/big/big_rational.cr","line_number":21,"url":null},{"filename":"src/big/number.cr","line_number":19,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"included_modules":[{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"}],"doc":"Rational numbers are represented as the quotient of arbitrarily large\nnumerators and denominators. Rationals are canonicalized such that the\ndenominator and the numerator have no common factors, and that the\ndenominator is positive. Zero has the unique representation 0/1.\n\nNOTE: To use `BigRational`, you must explicitly import it with `require \"big\"`\n\n```\nrequire \"big\"\n\nr = BigRational.new(7.to_big_i, 3.to_big_i)\nr.to_s # => \"7/3\"\n\nr = BigRational.new(3, -9)\nr.to_s # => \"-1/3\"\n```\n\nIt is implemented under the hood with [GMP](https://gmplib.org/).","summary":"<p>Rational numbers are represented as the quotient of arbitrarily large numerators and denominators.</p>","constructors":[{"html_id":"new(numerator:Int,denominator:Int)-class-method","name":"new","doc":"Creates a new `BigRational`.\n\nIf *denominator* is 0, this will raise an exception.","summary":"<p>Creates a new <code><a href=\"BigRational.html\">BigRational</a></code>.</p>","abstract":false,"args":[{"name":"numerator","external_name":"numerator","restriction":"Int"},{"name":"denominator","external_name":"denominator","restriction":"Int"}],"args_string":"(numerator : Int, denominator : Int)","args_html":"(numerator : <a href=\"Int.html\">Int</a>, denominator : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/big/big_rational.cr","line_number":29,"url":null},"def":{"name":"new","args":[{"name":"numerator","external_name":"numerator","restriction":"Int"},{"name":"denominator","external_name":"denominator","restriction":"Int"}],"visibility":"Public","body":"_ = allocate\n_.initialize(numerator, denominator)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(num:Int)-class-method","name":"new","doc":"Creates a new `BigRational` with *num* as the numerator and 1 for denominator.","summary":"<p>Creates a new <code><a href=\"BigRational.html\">BigRational</a></code> with <em>num</em> as the numerator and 1 for denominator.</p>","abstract":false,"args":[{"name":"num","external_name":"num","restriction":"Int"}],"args_string":"(num : Int)","args_html":"(num : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/big/big_rational.cr","line_number":42,"url":null},"def":{"name":"new","args":[{"name":"num","external_name":"num","restriction":"Int"}],"visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(num:Float::Primitive):self-class-method","name":"new","doc":"Creates an exact representation of float as rational.\n\nRaises `ArgumentError` if *num* is not finite.","summary":"<p>Creates an exact representation of float as rational.</p>","abstract":false,"args":[{"name":"num","external_name":"num","restriction":"Float::Primitive"}],"args_string":"(num : Float::Primitive) : self","args_html":"(num : <a href=\"Float/Primitive.html\">Float::Primitive</a>) : <span class=\"k\">self</span>","location":{"filename":"src/big/big_rational.cr","line_number":49,"url":null},"def":{"name":"new","args":[{"name":"num","external_name":"num","restriction":"Float::Primitive"}],"return_type":"self","visibility":"Public","body":"if num.finite?\nelse\n  raise(ArgumentError.new(\"Can only construct from a finite number\"))\nend\nnew do |mpq| LibGMP.mpq_set_d(mpq, num) end\n"},"external_var":false},{"html_id":"new(num:BigFloat):self-class-method","name":"new","doc":"Creates an exact representation of float as rational.","summary":"<p>Creates an exact representation of float as rational.</p>","abstract":false,"args":[{"name":"num","external_name":"num","restriction":"BigFloat"}],"args_string":"(num : BigFloat) : self","args_html":"(num : <a href=\"BigFloat.html\">BigFloat</a>) : <span class=\"k\">self</span>","location":{"filename":"src/big/big_rational.cr","line_number":55,"url":null},"def":{"name":"new","args":[{"name":"num","external_name":"num","restriction":"BigFloat"}],"return_type":"self","visibility":"Public","body":"new do |mpq| LibGMP.mpq_set_f(mpq, num) end"},"external_var":false},{"html_id":"new(num:BigRational):self-class-method","name":"new","doc":"Creates a `BigRational` from the given *num*.","summary":"<p>Creates a <code><a href=\"BigRational.html\">BigRational</a></code> from the given <em>num</em>.</p>","abstract":false,"args":[{"name":"num","external_name":"num","restriction":"BigRational"}],"args_string":"(num : BigRational) : self","args_html":"(num : <a href=\"BigRational.html\">BigRational</a>) : <span class=\"k\">self</span>","location":{"filename":"src/big/big_rational.cr","line_number":60,"url":null},"def":{"name":"new","args":[{"name":"num","external_name":"num","restriction":"BigRational"}],"return_type":"self","visibility":"Public","body":"num"},"external_var":false},{"html_id":"new(num:BigDecimal):self-class-method","name":"new","doc":"Creates a `BigRational` from the given *num*.","summary":"<p>Creates a <code><a href=\"BigRational.html\">BigRational</a></code> from the given <em>num</em>.</p>","abstract":false,"args":[{"name":"num","external_name":"num","restriction":"BigDecimal"}],"args_string":"(num : BigDecimal) : self","args_html":"(num : <a href=\"BigDecimal.html\">BigDecimal</a>) : <span class=\"k\">self</span>","location":{"filename":"src/big/big_rational.cr","line_number":65,"url":null},"def":{"name":"new","args":[{"name":"num","external_name":"num","restriction":"BigDecimal"}],"return_type":"self","visibility":"Public","body":"num.to_big_r"},"external_var":false}],"instance_methods":[{"html_id":"%(other:BigRational):BigRational-instance-method","name":"%","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational) : BigRational","args_html":"(other : <a href=\"BigRational.html\">BigRational</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_rational.cr","line_number":164,"url":null},"def":{"name":"%","args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"return_type":"BigRational","visibility":"Public","body":"check_division_by_zero(other)\nBigRational.new((numerator * other.denominator) % (denominator * other.numerator), denominator * other.denominator)\n"},"external_var":false},{"html_id":"%(other:Int):BigRational-instance-method","name":"%","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigRational","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_rational.cr","line_number":172,"url":null},"def":{"name":"%","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigRational","visibility":"Public","body":"check_division_by_zero(other)\nBigRational.new(numerator % (denominator * other), denominator)\n"},"external_var":false},{"html_id":"*(other:BigRational):BigRational-instance-method","name":"*","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational) : BigRational","args_html":"(other : <a href=\"BigRational.html\">BigRational</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_rational.cr","line_number":139,"url":null},"def":{"name":"*","args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"return_type":"BigRational","visibility":"Public","body":"BigRational.new do |mpq| LibGMP.mpq_mul(mpq, self, other) end"},"external_var":false},{"html_id":"*(other:Int):BigRational-instance-method","name":"*","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigRational","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_rational.cr","line_number":143,"url":null},"def":{"name":"*","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigRational","visibility":"Public","body":"self * other.to_big_r"},"external_var":false},{"html_id":"**(other:Int):BigRational-instance-method","name":"**","doc":"Raises the rational to the *other*th power\n\nThis will raise `DivisionByZeroError` if rational is 0 and *other* is negative.\n\n```\nrequire \"big\"\n\nBigRational.new(2, 3) ** 2  # => 4/9\nBigRational.new(2, 3) ** -1 # => 3/2\n```","summary":"<p>Raises the rational to the <em>other</em>th power</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigRational","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_rational.cr","line_number":269,"url":null},"def":{"name":"**","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigRational","visibility":"Public","body":"if other < 0\n  return (self ** other.abs).inv\nend\nBigRational.new(numerator ** other, denominator ** other)\n"},"external_var":false},{"html_id":"+(other:BigRational):BigRational-instance-method","name":"+","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational) : BigRational","args_html":"(other : <a href=\"BigRational.html\">BigRational</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_rational.cr","line_number":123,"url":null},"def":{"name":"+","args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"return_type":"BigRational","visibility":"Public","body":"BigRational.new do |mpq| LibGMP.mpq_add(mpq, self, other) end"},"external_var":false},{"html_id":"+(other:Int):BigRational-instance-method","name":"+","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigRational","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_rational.cr","line_number":127,"url":null},"def":{"name":"+","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigRational","visibility":"Public","body":"self + other.to_big_r"},"external_var":false},{"html_id":"-(other:BigRational):BigRational-instance-method","name":"-","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational) : BigRational","args_html":"(other : <a href=\"BigRational.html\">BigRational</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_rational.cr","line_number":131,"url":null},"def":{"name":"-","args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"return_type":"BigRational","visibility":"Public","body":"BigRational.new do |mpq| LibGMP.mpq_sub(mpq, self, other) end"},"external_var":false},{"html_id":"-(other:Int):BigRational-instance-method","name":"-","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigRational","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_rational.cr","line_number":135,"url":null},"def":{"name":"-","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigRational","visibility":"Public","body":"self - other.to_big_r"},"external_var":false},{"html_id":"-:BigRational-instance-method","name":"-","abstract":false,"location":{"filename":"src/big/big_rational.cr","line_number":255,"url":null},"def":{"name":"-","return_type":"BigRational","visibility":"Public","body":"BigRational.new do |mpq| LibGMP.mpq_neg(mpq, self) end"},"external_var":false},{"html_id":"/(other:BigRational):BigRational-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational) : BigRational","args_html":"(other : <a href=\"BigRational.html\">BigRational</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_rational.cr","line_number":147,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"return_type":"BigRational","visibility":"Public","body":"check_division_by_zero(other)\nBigRational.new do |mpq| LibGMP.mpq_div(mpq, self, other) end\n"},"external_var":false},{"html_id":"/(other:BigInt):BigRational-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigRational","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_rational.cr","line_number":152,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"},"external_var":false},{"html_id":"/(other:BigFloat):BigRational-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigFloat"}],"args_string":"(other : BigFloat) : BigRational","args_html":"(other : <a href=\"BigFloat.html\">BigFloat</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_rational.cr","line_number":152,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"BigFloat"}],"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"},"external_var":false},{"html_id":"/(other:BigDecimal):BigRational-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : BigRational","args_html":"(other : <a href=\"BigDecimal.html\">BigDecimal</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_rational.cr","line_number":152,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"BigDecimal"}],"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"},"external_var":false},{"html_id":"/(other:Int8):BigRational-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int8"}],"args_string":"(other : Int8) : BigRational","args_html":"(other : <a href=\"Int8.html\">Int8</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/number.cr","line_number":20,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"Int8"}],"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"},"external_var":false},{"html_id":"/(other:UInt8):BigRational-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"UInt8"}],"args_string":"(other : UInt8) : BigRational","args_html":"(other : <a href=\"UInt8.html\">UInt8</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/number.cr","line_number":20,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"UInt8"}],"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"},"external_var":false},{"html_id":"/(other:Int16):BigRational-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int16"}],"args_string":"(other : Int16) : BigRational","args_html":"(other : <a href=\"Int16.html\">Int16</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/number.cr","line_number":20,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"Int16"}],"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"},"external_var":false},{"html_id":"/(other:UInt16):BigRational-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"UInt16"}],"args_string":"(other : UInt16) : BigRational","args_html":"(other : <a href=\"UInt16.html\">UInt16</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/number.cr","line_number":20,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"UInt16"}],"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"},"external_var":false},{"html_id":"/(other:Int32):BigRational-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int32"}],"args_string":"(other : Int32) : BigRational","args_html":"(other : <a href=\"Int32.html\">Int32</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/number.cr","line_number":20,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"Int32"}],"return_type":"BigRational","visibility":"Public","body":"(BigRational\n  .new(self)) / (BigRational\n  .new(other))"},"external_var":false},{"html_id":"/(other:UInt32):BigRational-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"UInt32"}],"args_string":"(other : UInt32) : BigRational","args_html":"(other : <a href=\"UInt32.html\">UInt32</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/number.cr","line_number":20,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"UInt32"}],"return_type":"BigRational","visibility":"Public","body":"(BigRational\n  .new(self)) / (BigRational\n  .new(other))"},"external_var":false},{"html_id":"/(other:Int64):BigRational-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int64"}],"args_string":"(other : Int64) : BigRational","args_html":"(other : <a href=\"Int64.html\">Int64</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/number.cr","line_number":20,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"Int64"}],"return_type":"BigRational","visibility":"Public","body":"(BigRational\n  .new(self)) / (BigRational\n  .new(other))"},"external_var":false},{"html_id":"/(other:UInt64):BigRational-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"UInt64"}],"args_string":"(other : UInt64) : BigRational","args_html":"(other : <a href=\"UInt64.html\">UInt64</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/number.cr","line_number":20,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"UInt64"}],"return_type":"BigRational","visibility":"Public","body":"(BigRational\n  .new(self)) / (BigRational\n  .new(other))"},"external_var":false},{"html_id":"/(other:Int128):BigRational-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int128"}],"args_string":"(other : Int128) : BigRational","args_html":"(other : <a href=\"Int128.html\">Int128</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/number.cr","line_number":20,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"Int128"}],"return_type":"BigRational","visibility":"Public","body":"(BigRational\n  .new(self)) / (BigRational\n  .new(other))"},"external_var":false},{"html_id":"/(other:UInt128):BigRational-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"UInt128"}],"args_string":"(other : UInt128) : BigRational","args_html":"(other : <a href=\"UInt128.html\">UInt128</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/number.cr","line_number":20,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"UInt128"}],"return_type":"BigRational","visibility":"Public","body":"(BigRational\n  .new(self)) / (BigRational\n  .new(other))"},"external_var":false},{"html_id":"/(other:Float32):BigRational-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Float32"}],"args_string":"(other : Float32) : BigRational","args_html":"(other : <a href=\"Float32.html\">Float32</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/number.cr","line_number":21,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"Float32"}],"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"},"external_var":false},{"html_id":"/(other:Float64):BigRational-instance-method","name":"/","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Float64"}],"args_string":"(other : Float64) : BigRational","args_html":"(other : <a href=\"Float64.html\">Float64</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/number.cr","line_number":21,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"Float64"}],"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"},"external_var":false},{"html_id":"//(other:BigRational):BigRational-instance-method","name":"//","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational) : BigRational","args_html":"(other : <a href=\"BigRational.html\">BigRational</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_rational.cr","line_number":154,"url":null},"def":{"name":"//","args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"return_type":"BigRational","visibility":"Public","body":"check_division_by_zero(other)\nBigRational.new((numerator * other.denominator) // (denominator * other.numerator))\n"},"external_var":false},{"html_id":"//(other:Int):BigRational-instance-method","name":"//","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigRational","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_rational.cr","line_number":159,"url":null},"def":{"name":"//","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigRational","visibility":"Public","body":"check_division_by_zero(other)\nBigRational.new(numerator // (denominator * other))\n"},"external_var":false},{"html_id":"<<(other:Int):BigRational-instance-method","name":"<<","doc":"Multiplies the rational by (2 ** *other*)\n\n```\nrequire \"big\"\n\nBigRational.new(2, 3) << 2 # => 8/3\n```","summary":"<p>Multiplies the rational by (2 ** <em>other</em>)</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigRational","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_rational.cr","line_number":251,"url":null},"def":{"name":"<<","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigRational","visibility":"Public","body":"BigRational.new do |mpq| LibGMP.mpq_mul_2exp(mpq, self, other) end"},"external_var":false},{"html_id":"<=>(other:BigRational):Int32-instance-method","name":"<=>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational) : Int32","args_html":"(other : <a href=\"BigRational.html\">BigRational</a>) : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/big/big_rational.cr","line_number":93,"url":null},"def":{"name":"<=>","args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"return_type":"Int32","visibility":"Public","body":"LibGMP.mpq_cmp(mpq, other)"},"external_var":false},{"html_id":"<=>(other:Float::Primitive):Int32|Nil-instance-method","name":"<=>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Float::Primitive"}],"args_string":"(other : Float::Primitive) : Int32 | Nil","args_html":"(other : <a href=\"Float/Primitive.html\">Float::Primitive</a>) : <a href=\"Int32.html\">Int32</a> | <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/big/big_rational.cr","line_number":97,"url":null},"def":{"name":"<=>","args":[{"name":"other","external_name":"other","restriction":"Float::Primitive"}],"return_type":"Int32 | ::Nil","visibility":"Public","body":"if other.nan?\nelse\n  self <=> (BigRational.new(other))\nend"},"external_var":false},{"html_id":"<=>(other:BigFloat):Int32-instance-method","name":"<=>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigFloat"}],"args_string":"(other : BigFloat) : Int32","args_html":"(other : <a href=\"BigFloat.html\">BigFloat</a>) : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/big/big_rational.cr","line_number":101,"url":null},"def":{"name":"<=>","args":[{"name":"other","external_name":"other","restriction":"BigFloat"}],"return_type":"Int32","visibility":"Public","body":"self <=> other.to_big_r"},"external_var":false},{"html_id":"<=>(other:BigInt):Int32-instance-method","name":"<=>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : Int32","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/big/big_rational.cr","line_number":115,"url":null},"def":{"name":"<=>","args":[{"name":"other","external_name":"other","restriction":"BigInt"}],"return_type":"Int32","visibility":"Public","body":"LibGMP.mpq_cmp_z(self, other)"},"external_var":false},{"html_id":"<=>(other:Int):Int32-instance-method","name":"<=>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : Int32","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/big/big_rational.cr","line_number":105,"url":null},"def":{"name":"<=>","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"Int32","visibility":"Public","body":"Int.primitive_si_ui_check(other) do |si, ui, big_i|\n  {\n    si: LibGMP.mpq_cmp_si(self, {{ si }}, 1),\n    ui: LibGMP.mpq_cmp_ui(self, {{ ui }}, 1),\n    big_i: self <=> ({{ big_i }}),\n  }\nend"},"external_var":false},{"html_id":"<=>(other:BigDecimal)-instance-method","name":"<=>","doc":"The comparison operator. Returns `0` if the two objects are equal,\na negative number if this object is considered less than *other*,\na positive number if this object is considered greater than *other*,\nor `nil` if the two objects are not comparable.\n\nSubclasses define this method to provide class-specific ordering.\n\nThe comparison operator is usually used to sort values:\n\n```\n# Sort in a descending way:\n[3, 1, 2].sort { |x, y| y <=> x } # => [3, 2, 1]\n\n# Sort in an ascending way:\n[3, 1, 2].sort { |x, y| x <=> y } # => [1, 2, 3]\n```","summary":"<p>The comparison operator.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal)","args_html":"(other : <a href=\"BigDecimal.html\">BigDecimal</a>)","location":{"filename":"src/big/big_decimal.cr","line_number":840,"url":null},"def":{"name":"<=>","args":[{"name":"other","external_name":"other","restriction":"BigDecimal"}],"visibility":"Public","body":"-(other <=> self)"},"external_var":false},{"html_id":"==(other:BigRational):Bool-instance-method","name":"==","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational) : Bool","args_html":"(other : <a href=\"BigRational.html\">BigRational</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/big/big_rational.cr","line_number":119,"url":null},"def":{"name":"==","args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"return_type":"Bool","visibility":"Public","body":"(LibGMP.mpq_equal(self, other)) != 0"},"external_var":false},{"html_id":">>(other:Int):BigRational-instance-method","name":">>","doc":"Divides the rational by (2 ** *other*)\n\n```\nrequire \"big\"\n\nBigRational.new(2, 3) >> 2 # => 1/6\n```","summary":"<p>Divides the rational by (2 ** <em>other</em>)</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigRational","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_rational.cr","line_number":240,"url":null},"def":{"name":">>","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigRational","visibility":"Public","body":"BigRational.new do |mpq| LibGMP.mpq_div_2exp(mpq, self, other) end"},"external_var":false},{"html_id":"abs:BigRational-instance-method","name":"abs","doc":"Returns the absolute value of this number.\n\n```\n123.abs  # => 123\n-123.abs # => 123\n```","summary":"<p>Returns the absolute value of this number.</p>","abstract":false,"location":{"filename":"src/big/big_rational.cr","line_number":284,"url":null},"def":{"name":"abs","return_type":"BigRational","visibility":"Public","body":"BigRational.new do |mpq| LibGMP.mpq_abs(mpq, self) end"},"external_var":false},{"html_id":"ceil:BigRational-instance-method","name":"ceil","abstract":false,"location":{"filename":"src/big/big_rational.cr","line_number":200,"url":null},"def":{"name":"ceil","return_type":"BigRational","visibility":"Public","body":"BigRational.new(-((-numerator) // denominator))"},"external_var":false},{"html_id":"clone:BigRational-instance-method","name":"clone","abstract":false,"location":{"filename":"src/big/big_rational.cr","line_number":374,"url":null},"def":{"name":"clone","return_type":"BigRational","visibility":"Public","body":"self"},"external_var":false},{"html_id":"denominator:BigInt-instance-method","name":"denominator","abstract":false,"location":{"filename":"src/big/big_rational.cr","line_number":89,"url":null},"def":{"name":"denominator","return_type":"BigInt","visibility":"Public","body":"BigInt.new(@mpq._mp_den)"},"external_var":false},{"html_id":"floor:BigRational-instance-method","name":"floor","abstract":false,"location":{"filename":"src/big/big_rational.cr","line_number":204,"url":null},"def":{"name":"floor","return_type":"BigRational","visibility":"Public","body":"BigRational.new(numerator // denominator)"},"external_var":false},{"html_id":"format(io:IO,separator='.',delimiter=',',decimal_places:Int|Nil=nil,*,group:Int=3,only_significant:Bool=false):Nil-instance-method","name":"format","doc":"Prints this number as a `String` using a customizable format.\n\n*separator* is used as decimal separator, *delimiter* as thousands\ndelimiter between batches of *group* digits.\n\nIf *decimal_places* is `nil`, all significant decimal places are printed\n(similar to `#to_s`). If the argument has a numeric value, the number of\nvisible decimal places will be fixed to that amount.\n\nTrailing zeros are omitted if *only_significant* is `true`.\n\n```\n123_456.789.format                                            # => \"123,456.789\"\n123_456.789.format(',', '.')                                  # => \"123.456,789\"\n123_456.789.format(decimal_places: 2)                         # => \"123,456.79\"\n123_456.789.format(decimal_places: 6)                         # => \"123,456.789000\"\n123_456.789.format(decimal_places: 6, only_significant: true) # => \"123,456.789\"\n```","summary":"<p>Prints this number as a <code><a href=\"String.html\">String</a></code> using a customizable format.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"separator","default_value":"'.'","external_name":"separator","restriction":""},{"name":"delimiter","default_value":"','","external_name":"delimiter","restriction":""},{"name":"decimal_places","default_value":"nil","external_name":"decimal_places","restriction":"Int | ::Nil"},{"name":"","external_name":"","restriction":""},{"name":"group","default_value":"3","external_name":"group","restriction":"Int"},{"name":"only_significant","default_value":"false","external_name":"only_significant","restriction":"Bool"}],"args_string":"(io : IO, separator = '.', delimiter = ',', decimal_places : Int | Nil = nil, *, group : Int = 3, only_significant : Bool = false) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>, separator = <span class=\"s\">&#39;.&#39;</span>, delimiter = <span class=\"s\">&#39;,&#39;</span>, decimal_places : <a href=\"Int.html\">Int</a> | <a href=\"Nil.html\">Nil</a> = <span class=\"n\">nil</span>, *, group : <a href=\"Int.html\">Int</a> = <span class=\"n\">3</span>, only_significant : <a href=\"Bool.html\">Bool</a> = <span class=\"n\">false</span>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/big/big_rational.cr","line_number":368,"url":null},"def":{"name":"format","args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"separator","default_value":"'.'","external_name":"separator","restriction":""},{"name":"delimiter","default_value":"','","external_name":"delimiter","restriction":""},{"name":"decimal_places","default_value":"nil","external_name":"decimal_places","restriction":"Int | ::Nil"},{"name":"","external_name":"","restriction":""},{"name":"group","default_value":"3","external_name":"group","restriction":"Int"},{"name":"only_significant","default_value":"false","external_name":"only_significant","restriction":"Bool"}],"splat_index":4,"return_type":"Nil","visibility":"Public","body":"numerator.format(io, separator, delimiter, decimal_places, group: group, only_significant: only_significant)\nio << '/'\ndenominator.format(io, separator, delimiter, decimal_places, group: group, only_significant: only_significant)\n"},"external_var":false},{"html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Prints to *io* an unambiguous and information-rich string representation of this\nobject, typically intended for developers.\n\nIt is similar to `#to_s(IO)`, but often provides more information. Ideally, it should\ncontain sufficient information to be able to recreate an object with the same value\n(given an identical environment).\n\nFor types that don't provide a custom implementation of this method,\ndefault implementation delegates to `#to_s(IO)`. This said, it is advisable to\nhave an appropriate `#inspect` implementation on every type. Default\nimplementations are provided by `Struct#inspect` and `Reference#inspect`.\n\n`::p` and `::p!` use this method to print an object in `STDOUT`.","summary":"<p>Prints to <em>io</em> an unambiguous and information-rich string representation of this object, typically intended for developers.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/big/big_rational.cr","line_number":363,"url":null},"def":{"name":"inspect","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"to_s(io)"},"external_var":false},{"html_id":"inspect:String-instance-method","name":"inspect","doc":"Returns an unambiguous and information-rich string representation of this\nobject, typically intended for developers.\n\nThis method should usually **not** be overridden. It delegates to\n`#inspect(IO)` which can be overridden for custom implementations.\n\nAlso see `#to_s`.","summary":"<p>Returns an unambiguous and information-rich string representation of this object, typically intended for developers.</p>","abstract":false,"location":{"filename":"src/big/big_rational.cr","line_number":359,"url":null},"def":{"name":"inspect","return_type":"String","visibility":"Public","body":"to_s"},"external_var":false},{"html_id":"integer?:Bool-instance-method","name":"integer?","doc":"Returns `true` if `self` is an integer.\n\nNon-integer types may return `true` as long as `self` denotes a finite value\nwithout any fractional parts.\n\n```\n1.integer?       # => true\n1.0.integer?     # => true\n1.2.integer?     # => false\n(1 / 0).integer? # => false\n(0 / 0).integer? # => false\n```","summary":"<p>Returns <code>true</code> if <code>self</code> is an integer.</p>","abstract":false,"location":{"filename":"src/big/big_rational.cr","line_number":227,"url":null},"def":{"name":"integer?","return_type":"Bool","visibility":"Public","body":"denominator == 1"},"external_var":false},{"html_id":"inv:BigRational-instance-method","name":"inv","doc":"Returns a new `BigRational` as 1/r.\n\nThis will raise an exception if rational is 0.","summary":"<p>Returns a new <code><a href=\"BigRational.html\">BigRational</a></code> as 1/r.</p>","abstract":false,"location":{"filename":"src/big/big_rational.cr","line_number":279,"url":null},"def":{"name":"inv","return_type":"BigRational","visibility":"Public","body":"check_division_by_zero(self)\nBigRational.new do |mpq| LibGMP.mpq_inv(mpq, self) end\n"},"external_var":false},{"html_id":"numerator:BigInt-instance-method","name":"numerator","abstract":false,"location":{"filename":"src/big/big_rational.cr","line_number":80,"url":null},"def":{"name":"numerator","return_type":"BigInt","visibility":"Public","body":"BigInt.new(@mpq._mp_num)"},"external_var":false},{"html_id":"remainder(other:BigRational):BigRational-instance-method","name":"remainder","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational) : BigRational","args_html":"(other : <a href=\"BigRational.html\">BigRational</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_rational.cr","line_number":187,"url":null},"def":{"name":"remainder","args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"return_type":"BigRational","visibility":"Public","body":"check_division_by_zero(other)\nBigRational.new((numerator * other.denominator).remainder(denominator * other.numerator), denominator * other.denominator)\n"},"external_var":false},{"html_id":"remainder(other:Int):BigRational-instance-method","name":"remainder","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigRational","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_rational.cr","line_number":195,"url":null},"def":{"name":"remainder","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigRational","visibility":"Public","body":"check_division_by_zero(other)\nBigRational.new(numerator.remainder(denominator * other), denominator)\n"},"external_var":false},{"html_id":"round_away:BigRational-instance-method","name":"round_away","abstract":false,"location":{"filename":"src/big/big_rational.cr","line_number":212,"url":null},"def":{"name":"round_away","return_type":"BigRational","visibility":"Public","body":"rem2 = (numerator.remainder(denominator)).abs * 2\nx = BigRational.new(numerator.tdiv(denominator))\nif rem2 >= denominator\n  x = x + sign\nend\nx\n"},"external_var":false},{"html_id":"round_even:BigRational-instance-method","name":"round_even","abstract":false,"location":{"filename":"src/big/big_rational.cr","line_number":219,"url":null},"def":{"name":"round_even","return_type":"BigRational","visibility":"Public","body":"rem2 = (numerator.remainder(denominator)).abs * 2\nx = BigRational.new(numerator.tdiv(denominator))\nif rem2 > denominator || ((rem2 == denominator) && x.numerator.odd?)\n  x = x + sign\nend\nx\n"},"external_var":false},{"html_id":"tdiv(other:BigRational):BigRational-instance-method","name":"tdiv","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational) : BigRational","args_html":"(other : <a href=\"BigRational.html\">BigRational</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_rational.cr","line_number":177,"url":null},"def":{"name":"tdiv","args":[{"name":"other","external_name":"other","restriction":"BigRational"}],"return_type":"BigRational","visibility":"Public","body":"check_division_by_zero(other)\nBigRational.new((numerator * other.denominator).tdiv(denominator * other.numerator))\n"},"external_var":false},{"html_id":"tdiv(other:Int):BigRational-instance-method","name":"tdiv","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigRational","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_rational.cr","line_number":182,"url":null},"def":{"name":"tdiv","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"BigRational","visibility":"Public","body":"check_division_by_zero(other)\nBigRational.new(numerator.tdiv(denominator * other))\n"},"external_var":false},{"html_id":"to_big_d:BigDecimal-instance-method","name":"to_big_d","doc":"Converts `self` to `BigDecimal`.","summary":"<p>Converts <code>self</code> to <code><a href=\"BigDecimal.html\">BigDecimal</a></code>.</p>","abstract":false,"location":{"filename":"src/big/big_decimal.cr","line_number":845,"url":null},"def":{"name":"to_big_d","return_type":"BigDecimal","visibility":"Public","body":"BigDecimal.new(self)"},"external_var":false},{"html_id":"to_big_f:BigFloat-instance-method","name":"to_big_f","abstract":false,"location":{"filename":"src/big/big_rational.cr","line_number":330,"url":null},"def":{"name":"to_big_f","return_type":"BigFloat","visibility":"Public","body":"BigFloat.new do |mpf| LibGMP.mpf_set_q(mpf, mpq) end"},"external_var":false},{"html_id":"to_big_i:BigInt-instance-method","name":"to_big_i","abstract":false,"location":{"filename":"src/big/big_rational.cr","line_number":334,"url":null},"def":{"name":"to_big_i","return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz| LibGMP.set_q(mpz, mpq) end"},"external_var":false},{"html_id":"to_big_r:BigRational-instance-method","name":"to_big_r","doc":"Returns `self`.\n\n```\nrequire \"big\"\n\nBigRational.new(4, 5).to_big_r # => 4/5\n```","summary":"<p>Returns <code>self</code>.</p>","abstract":false,"location":{"filename":"src/big/big_rational.cr","line_number":326,"url":null},"def":{"name":"to_big_r","return_type":"BigRational","visibility":"Public","body":"self"},"external_var":false},{"html_id":"to_f:Float64-instance-method","name":"to_f","doc":"Returns the `Float64` representing this rational.","summary":"<p>Returns the <code><a href=\"Float64.html\">Float64</a></code> representing this rational.</p>","abstract":false,"location":{"filename":"src/big/big_rational.cr","line_number":289,"url":null},"def":{"name":"to_f","return_type":"Float64","visibility":"Public","body":"to_f64"},"external_var":false},{"html_id":"to_f!:Float64-instance-method","name":"to_f!","abstract":false,"location":{"filename":"src/big/big_rational.cr","line_number":309,"url":null},"def":{"name":"to_f!","return_type":"Float64","visibility":"Public","body":"to_f64!"},"external_var":false},{"html_id":"to_f32:Float32-instance-method","name":"to_f32","abstract":false,"location":{"filename":"src/big/big_rational.cr","line_number":293,"url":null},"def":{"name":"to_f32","return_type":"Float32","visibility":"Public","body":"to_f64.to_f32"},"external_var":false},{"html_id":"to_f32!:Float32-instance-method","name":"to_f32!","abstract":false,"location":{"filename":"src/big/big_rational.cr","line_number":301,"url":null},"def":{"name":"to_f32!","return_type":"Float32","visibility":"Public","body":"to_f64.to_f32!"},"external_var":false},{"html_id":"to_f64:Float64-instance-method","name":"to_f64","abstract":false,"location":{"filename":"src/big/big_rational.cr","line_number":297,"url":null},"def":{"name":"to_f64","return_type":"Float64","visibility":"Public","body":"LibGMP.mpq_get_d(mpq)"},"external_var":false},{"html_id":"to_f64!:Float64-instance-method","name":"to_f64!","abstract":false,"location":{"filename":"src/big/big_rational.cr","line_number":305,"url":null},"def":{"name":"to_f64!","return_type":"Float64","visibility":"Public","body":"to_f64"},"external_var":false},{"html_id":"to_i:Int32-instance-method","name":"to_i","abstract":false,"location":{"filename":"src/big/big_rational.cr","line_number":313,"url":null},"def":{"name":"to_i","return_type":"Int32","visibility":"Public","body":"to_i32"},"external_var":false},{"html_id":"to_i16(*args,**options)-instance-method","name":"to_i16","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/big/big_rational.cr","line_number":317,"url":null},"def":{"name":"to_i16","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"visibility":"Public","body":"to_f64.to_i16(*args, **options)"},"external_var":false},{"html_id":"to_i16(*args,**options,&)-instance-method","name":"to_i16","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/big/big_rational.cr","line_number":317,"url":null},"def":{"name":"to_i16","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arity":1,"visibility":"Public","body":"to_f64.to_i16(*args, **options) do |*yield_args|\n  yield *yield_args\nend"},"external_var":false},{"html_id":"to_i32(*args,**options)-instance-method","name":"to_i32","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/big/big_rational.cr","line_number":317,"url":null},"def":{"name":"to_i32","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"visibility":"Public","body":"to_f64.to_i32(*args, **options)"},"external_var":false},{"html_id":"to_i32(*args,**options,&)-instance-method","name":"to_i32","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/big/big_rational.cr","line_number":317,"url":null},"def":{"name":"to_i32","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arity":1,"visibility":"Public","body":"to_f64.to_i32(*args, **options) do |*yield_args|\n  yield *yield_args\nend"},"external_var":false},{"html_id":"to_i64(*args,**options)-instance-method","name":"to_i64","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/big/big_rational.cr","line_number":317,"url":null},"def":{"name":"to_i64","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"visibility":"Public","body":"to_f64.to_i64(*args, **options)"},"external_var":false},{"html_id":"to_i64(*args,**options,&)-instance-method","name":"to_i64","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/big/big_rational.cr","line_number":317,"url":null},"def":{"name":"to_i64","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arity":1,"visibility":"Public","body":"to_f64.to_i64(*args, **options) do |*yield_args|\n  yield *yield_args\nend"},"external_var":false},{"html_id":"to_i8(*args,**options)-instance-method","name":"to_i8","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/big/big_rational.cr","line_number":317,"url":null},"def":{"name":"to_i8","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"visibility":"Public","body":"to_f64.to_i8(*args, **options)"},"external_var":false},{"html_id":"to_i8(*args,**options,&)-instance-method","name":"to_i8","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/big/big_rational.cr","line_number":317,"url":null},"def":{"name":"to_i8","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arity":1,"visibility":"Public","body":"to_f64.to_i8(*args, **options) do |*yield_args|\n  yield *yield_args\nend"},"external_var":false},{"html_id":"to_s(base:Int=10):String-instance-method","name":"to_s","doc":"Returns the string representing this rational.\n\nOptionally takes a radix base (2 through 36).\n\n```\nrequire \"big\"\n\nr = BigRational.new(8243243, 562828882)\nr.to_s     # => \"8243243/562828882\"\nr.to_s(16) # => \"7dc82b/218c1652\"\nr.to_s(36) # => \"4woiz/9b3djm\"\n```","summary":"<p>Returns the string representing this rational.</p>","abstract":false,"args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = 10) : String","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>) : <a href=\"String.html\">String</a>","location":{"filename":"src/big/big_rational.cr","line_number":350,"url":null},"def":{"name":"to_s","args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"return_type":"String","visibility":"Public","body":"String.new(to_cstr(base))"},"external_var":false},{"html_id":"to_s(io:IO,base:Int=10):Nil-instance-method","name":"to_s","doc":"Prints a nicely readable and concise string representation of this object,\ntypically intended for users, to *io*.\n\nThis method is called when an object is interpolated in a string literal:\n```\n\"foo #{bar} baz\" # calls bar.to_io with the builder for this string\n```\n\n`IO#<<` calls this method to append an object to itself:\n```\nio << bar # calls bar.to_s(io)\n```\n\nThus implementations must not interpolate `self` in a string literal or call\n`io << self` which both would lead to an endless loop.\n\nAlso see `#inspect(IO)`.","summary":"<p>Prints a nicely readable and concise string representation of this object, typically intended for users, to <em>io</em>.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(io : IO, base : Int = 10) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>, base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/big/big_rational.cr","line_number":354,"url":null},"def":{"name":"to_s","args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"return_type":"Nil","visibility":"Public","body":"str = to_cstr(base)\nio.write_string(Slice.new(str, LibC.strlen(str)))\n"},"external_var":false},{"html_id":"to_u16(*args,**options)-instance-method","name":"to_u16","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/big/big_rational.cr","line_number":317,"url":null},"def":{"name":"to_u16","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"visibility":"Public","body":"to_f64.to_u16(*args, **options)"},"external_var":false},{"html_id":"to_u16(*args,**options,&)-instance-method","name":"to_u16","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/big/big_rational.cr","line_number":317,"url":null},"def":{"name":"to_u16","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arity":1,"visibility":"Public","body":"to_f64.to_u16(*args, **options) do |*yield_args|\n  yield *yield_args\nend"},"external_var":false},{"html_id":"to_u32(*args,**options)-instance-method","name":"to_u32","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/big/big_rational.cr","line_number":317,"url":null},"def":{"name":"to_u32","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"visibility":"Public","body":"to_f64.to_u32(*args, **options)"},"external_var":false},{"html_id":"to_u32(*args,**options,&)-instance-method","name":"to_u32","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/big/big_rational.cr","line_number":317,"url":null},"def":{"name":"to_u32","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arity":1,"visibility":"Public","body":"to_f64.to_u32(*args, **options) do |*yield_args|\n  yield *yield_args\nend"},"external_var":false},{"html_id":"to_u64(*args,**options)-instance-method","name":"to_u64","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/big/big_rational.cr","line_number":317,"url":null},"def":{"name":"to_u64","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"visibility":"Public","body":"to_f64.to_u64(*args, **options)"},"external_var":false},{"html_id":"to_u64(*args,**options,&)-instance-method","name":"to_u64","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/big/big_rational.cr","line_number":317,"url":null},"def":{"name":"to_u64","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arity":1,"visibility":"Public","body":"to_f64.to_u64(*args, **options) do |*yield_args|\n  yield *yield_args\nend"},"external_var":false},{"html_id":"to_u8(*args,**options)-instance-method","name":"to_u8","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/big/big_rational.cr","line_number":317,"url":null},"def":{"name":"to_u8","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"visibility":"Public","body":"to_f64.to_u8(*args, **options)"},"external_var":false},{"html_id":"to_u8(*args,**options,&)-instance-method","name":"to_u8","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/big/big_rational.cr","line_number":317,"url":null},"def":{"name":"to_u8","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arity":1,"visibility":"Public","body":"to_f64.to_u8(*args, **options) do |*yield_args|\n  yield *yield_args\nend"},"external_var":false},{"html_id":"to_unsafe:Pointer(LibGMP::MPQ)-instance-method","name":"to_unsafe","abstract":false,"location":{"filename":"src/big/big_rational.cr","line_number":382,"url":null},"def":{"name":"to_unsafe","return_type":"Pointer(LibGMP::MPQ)","visibility":"Public","body":"mpq"},"external_var":false},{"html_id":"trunc:BigRational-instance-method","name":"trunc","abstract":false,"location":{"filename":"src/big/big_rational.cr","line_number":208,"url":null},"def":{"name":"trunc","return_type":"BigRational","visibility":"Public","body":"BigRational.new(numerator.tdiv(denominator))"},"external_var":false}]},{"html_id":"Crystal/BitArray","path":"BitArray.html","kind":"struct","full_name":"BitArray","name":"BitArray","abstract":false,"superclass":{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},"ancestors":[{"html_id":"Crystal/Indexable/Mutable","kind":"module","full_name":"Indexable::Mutable","name":"Mutable"},{"html_id":"Crystal/Indexable","kind":"module","full_name":"Indexable","name":"Indexable"},{"html_id":"Crystal/Enumerable","kind":"module","full_name":"Enumerable","name":"Enumerable"},{"html_id":"Crystal/Iterable","kind":"module","full_name":"Iterable","name":"Iterable"},{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/bit_array.cr","line_number":20,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"included_modules":[{"html_id":"Crystal/Indexable/Mutable","kind":"module","full_name":"Indexable::Mutable","name":"Mutable"}],"doc":"`BitArray` is an array data structure that compactly stores bits.\n\nBits externally represented as `Bool`s are stored internally as\n`UInt32`s. The total number of bits stored is set at creation and is\nimmutable.\n\nNOTE: To use `BitArray`, you must explicitly import it with `require \"bit_array\"`\n\n### Example\n\n```\nrequire \"bit_array\"\n\nba = BitArray.new(12) # => \"BitArray[000000000000]\"\nba[2]                 # => false\n0.upto(5) { |i| ba[i * 2] = true }\nba    # => \"BitArray[101010101010]\"\nba[2] # => true\n```","summary":"<p><code><a href=\"BitArray.html\">BitArray</a></code> is an array data structure that compactly stores bits.</p>","constructors":[{"html_id":"new(size:Int,initial:Bool=false)-class-method","name":"new","doc":"Creates a new `BitArray` of *size* bits.\n\n*initial* optionally sets the starting value, `true` or `false`, for all bits\nin the array.","summary":"<p>Creates a new <code><a href=\"BitArray.html\">BitArray</a></code> of <em>size</em> bits.</p>","abstract":false,"args":[{"name":"size","external_name":"size","restriction":"Int"},{"name":"initial","default_value":"false","external_name":"initial","restriction":"Bool"}],"args_string":"(size : Int, initial : Bool = false)","args_html":"(size : <a href=\"Int.html\">Int</a>, initial : <a href=\"Bool.html\">Bool</a> = <span class=\"n\">false</span>)","location":{"filename":"src/bit_array.cr","line_number":30,"url":null},"def":{"name":"new","args":[{"name":"size","external_name":"size","restriction":"Int"},{"name":"initial","default_value":"false","external_name":"initial","restriction":"Bool"}],"visibility":"Public","body":"_ = allocate\n_.initialize(size, initial)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(size:Int,&:Int32->_)-class-method","name":"new","doc":"Creates a new `BitArray` of *size* bits and invokes the given block once\nfor each index of `self`, setting the bit at that index to `true` if the\nblock is truthy.\n\n```\nBitArray.new(5) { |i| i >= 3 }     # => BitArray[00011]\nBitArray.new(6) { |i| i if i < 2 } # => BitArray[110000]\n```","summary":"<p>Creates a new <code><a href=\"BitArray.html\">BitArray</a></code> of <em>size</em> bits and invokes the given block once for each index of <code>self</code>, setting the bit at that index to <code>true</code> if the block is truthy.</p>","abstract":false,"args":[{"name":"size","external_name":"size","restriction":"Int"}],"args_string":"(size : Int, & : Int32 -> _)","args_html":"(size : <a href=\"Int.html\">Int</a>, & : <a href=\"Int32.html\">Int32</a> -> _)","location":{"filename":"src/bit_array.cr","line_number":46,"url":null},"def":{"name":"new","args":[{"name":"size","external_name":"size","restriction":"Int"}],"yields":1,"block_arity":1,"block_arg":{"name":"","external_name":"","restriction":"(Int32 -> _)"},"visibility":"Public","body":"arr = new(size)\nsize.to_i.times do |i|\n  if yield i\n    arr.unsafe_put(i, true)\n  end\nend\narr\n"},"external_var":false}],"instance_methods":[{"html_id":"==(other:BitArray)-instance-method","name":"==","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"BitArray"}],"args_string":"(other : BitArray)","args_html":"(other : <a href=\"BitArray.html\">BitArray</a>)","location":{"filename":"src/bit_array.cr","line_number":54,"url":null},"def":{"name":"==","args":[{"name":"other","external_name":"other","restriction":"BitArray"}],"visibility":"Public","body":"if size != other.size\n  return false\nend\n\n\n\n(LibC.memcmp(@bits, other.@bits, bytesize)) == 0\n"},"external_var":false},{"html_id":"[](start:Int,count:Int):BitArray-instance-method","name":"[]","doc":"Returns count or less (if there aren't enough) elements starting at the\ngiven start index.\n\nNegative indices count backward from the end of the array (-1 is the last\nelement). Additionally, an empty array is returned when the starting index\nfor an element range is at the end of the array.\n\nRaises `IndexError` if the starting index is out of range.\n\n```\nrequire \"bit_array\"\n\nba = BitArray.new(5)\nba[0] = true; ba[2] = true; ba[4] = true\nba # => BitArray[10101]\n\nba[-3, 3] # => BitArray[101]\nba[6, 1]  # raise indexError\nba[1, 2]  # => BitArray[01]\nba[5, 1]  # => BitArray[]\n```","summary":"<p>Returns count or less (if there aren't enough) elements starting at the given start index.</p>","abstract":false,"args":[{"name":"start","external_name":"start","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"}],"args_string":"(start : Int, count : Int) : BitArray","args_html":"(start : <a href=\"Int.html\">Int</a>, count : <a href=\"Int.html\">Int</a>) : <a href=\"BitArray.html\">BitArray</a>","location":{"filename":"src/bit_array.cr","line_number":133,"url":null},"def":{"name":"[]","args":[{"name":"start","external_name":"start","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"}],"return_type":"BitArray","visibility":"Public","body":"start, count = normalize_start_and_count(start, count)\n\nif count == 0\n  return BitArray.new(0)\nend\n\nif size <= 32\n  bits = @bits[0]\n\n  bits = bits >> start\n  bits = bits & (~(UInt32::MAX << count))\n\n  (BitArray.new(count)).tap do |ba| (ba.@bits)[0] = bits end\nelsif size <= 64\n  bits = (@bits.as(::Pointer(UInt64)))[0]\n\n  bits = bits >> start\n  bits = bits & (~(UInt64::MAX << count))\n\n  if count <= 32\n    (BitArray.new(count)).tap do |ba| (ba.@bits)[0] = bits.to_u32! end\n  else\n    (BitArray.new(count)).tap do |ba| ((ba.@bits).as(::Pointer(UInt64)))[0] = bits end\n  end\nelse\n  ba = BitArray.new(count)\n  start_bit_index, start_sub_index = start.divmod(32)\n  end_bit_index = (start + count) // 32\n\n  i = 0\n  bits = @bits[start_bit_index]\n  while (start_bit_index + i) <= end_bit_index\n    low_bits = bits\n    low_bits = low_bits >> start_sub_index\n\n    bits = @bits[(start_bit_index + i) + 1]\n\n    high_bits = bits\n    high_bits = high_bits & (~(UInt32::MAX << start_sub_index))\n    high_bits = high_bits << (32 - start_sub_index)\n\n    (ba.@bits)[i] = low_bits | high_bits\n    i = i + 1\n  end\n\n\n\n  ba.clear_unused_bits\n  ba\nend\n"},"external_var":false},{"html_id":"[](range:Range):BitArray-instance-method","name":"[]","doc":"Returns all elements that are within the given range.\n\nNegative indices count backward from the end of the array (-1 is the last\nelement). Additionally, an empty array is returned when the starting index\nfor an element range is at the end of the array.\n\nRaises `IndexError` if the starting index is out of range.\n\n```\nrequire \"bit_array\"\n\nba = BitArray.new(5)\nba[0] = true; ba[2] = true; ba[4] = true\nba # => BitArray[10101]\n\nba[1..3]    # => BitArray[010]\nba[4..7]    # => BitArray[1]\nba[6..10]   # raise IndexError\nba[5..10]   # => BitArray[]\nba[-2...-1] # => BitArray[0]\n```","summary":"<p>Returns all elements that are within the given range.</p>","abstract":false,"args":[{"name":"range","external_name":"range","restriction":"Range"}],"args_string":"(range : Range) : BitArray","args_html":"(range : <a href=\"Range.html\">Range</a>) : <a href=\"BitArray.html\">BitArray</a>","location":{"filename":"src/bit_array.cr","line_number":108,"url":null},"def":{"name":"[]","args":[{"name":"range","external_name":"range","restriction":"Range"}],"return_type":"BitArray","visibility":"Public","body":"self[*(Indexable.range_to_index_and_count(range, size)) || (raise(IndexError.new))]"},"external_var":false},{"html_id":"[]=(index:Int,value:Bool):Bool-instance-method","name":"[]=","doc":"Sets the given *value* at the given *index*. Returns *value*.\n\nNegative indices can be used to start counting from the end of the\ncontainer. Raises `IndexError` if trying to set an element outside the\ncontainer's range.\n\n```\nary = [1, 2, 3]\nary[0] = 5\nary # => [5, 2, 3]\n\nary[3] = 5 # raises IndexError\n```","summary":"<p>Sets the given <em>value</em> at the given <em>index</em>.</p>","abstract":false,"args":[{"name":"index","external_name":"index","restriction":"Int"},{"name":"value","external_name":"value","restriction":"Bool"}],"args_string":"(index : Int, value : Bool) : Bool","args_html":"(index : <a href=\"Int.html\">Int</a>, value : <a href=\"Bool.html\">Bool</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/bit_array.cr","line_number":77,"url":null},"def":{"name":"[]=","args":[{"name":"index","external_name":"index","restriction":"Int"},{"name":"value","external_name":"value","restriction":"Bool"}],"return_type":"Bool","visibility":"Public","body":"bit_index, sub_index = bit_index_and_sub_index(index)\nif value\n  __temp_87eaed39_5 = bit_index\n  @bits[__temp_87eaed39_5] = @bits[__temp_87eaed39_5] | (1 << sub_index)\nelse\n  __temp_87eaed39_7 = bit_index\n  @bits[__temp_87eaed39_7] = @bits[__temp_87eaed39_7] & (~(1 << sub_index))\nend\nvalue\n"},"external_var":false},{"html_id":"all?:Bool-instance-method","name":"all?","doc":"Returns `true` if all of the elements of the collection are truthy.\n\n```\n[nil, true, 99].all? # => false\n[15].all?            # => true\n```","summary":"<p>Returns <code>true</code> if all of the elements of the collection are truthy.</p>","abstract":false,"location":{"filename":"src/bit_array.cr","line_number":189,"url":null},"def":{"name":"all?","return_type":"Bool","visibility":"Public","body":"bit_index, sub_index = @size.divmod(32)\n\nbit_index.times do |i|\n  if @bits[i] == UInt32::MAX\n  else\n    return false\n  end\nend\n\nif sub_index == 0\n  return true\nend\nmask = ~(UInt32::MAX << sub_index)\n(@bits[bit_index] & mask) == mask\n"},"external_var":false},{"html_id":"any?:Bool-instance-method","name":"any?","doc":"Returns `true` if at least one of the collection's members is truthy.\n\n```\n[nil, true, 99].any? # => true\n[nil, false].any?    # => false\n([] of Int32).any?   # => false\n```\n\n* `#present?` does not consider truthiness of elements.\n* `#any?(&)` and `#any(pattern)` allow custom conditions.\n\nNOTE: `#any?` usually has the same semantics as `#present?`. They only\ndiffer if the element type can be falsey (i.e. `T <= Nil || T <= Pointer || T <= Bool`).\nIt's typically advised to prefer `#present?` unless these specific truthiness\nsemantics are required.","summary":"<p>Returns <code>true</code> if at least one of the collection's members is truthy.</p>","abstract":false,"location":{"filename":"src/bit_array.cr","line_number":202,"url":null},"def":{"name":"any?","return_type":"Bool","visibility":"Public","body":"(Slice.new(@bits, malloc_size)).any? do |bits| bits != 0 end"},"external_var":false},{"html_id":"count(item:Bool):Int32-instance-method","name":"count","doc":"Returns the number of times that *item* is present in the bit array.\n\n```\nba = BitArray.new(12, true)\nba[3] = false\nba[7] = false\nba.count(true)  # => 10\nba.count(false) # => 2\n```","summary":"<p>Returns the number of times that <em>item</em> is present in the bit array.</p>","abstract":false,"args":[{"name":"item","external_name":"item","restriction":"Bool"}],"args_string":"(item : Bool) : Int32","args_html":"(item : <a href=\"Bool.html\">Bool</a>) : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/bit_array.cr","line_number":304,"url":null},"def":{"name":"count","args":[{"name":"item","external_name":"item","restriction":"Bool"}],"return_type":"Int32","visibility":"Public","body":"ones_count = (Slice.new(@bits, malloc_size)).sum(&.popcount)\nitem ? ones_count : @size - ones_count\n"},"external_var":false},{"html_id":"dup-instance-method","name":"dup","doc":"Returns a new `BitArray` with all of the same elements.","summary":"<p>Returns a new <code><a href=\"BitArray.html\">BitArray</a></code> with all of the same elements.</p>","abstract":false,"location":{"filename":"src/bit_array.cr","line_number":638,"url":null},"def":{"name":"dup","visibility":"Public","body":"bit_array = BitArray.new(@size)\n@bits.copy_to(bit_array.@bits, malloc_size)\nbit_array\n"},"external_var":false},{"html_id":"fill(value:Bool,start:Int,count:Int):self-instance-method","name":"fill","doc":"Replaces *count* or less (if there aren't enough) elements starting at the\ngiven *start* index with *value*. Returns `self`.\n\nNegative values of *start* count from the end of the container.\n\nRaises `IndexError` if the *start* index is out of range.\n\nRaises `ArgumentError` if *count* is negative.\n\n```\narray = [1, 2, 3, 4, 5]\narray.fill(9, 2, 2) # => [1, 2, 9, 9, 5]\narray               # => [1, 2, 9, 9, 5]\n```","summary":"<p>Replaces <em>count</em> or less (if there aren't enough) elements starting at the given <em>start</em> index with <em>value</em>.</p>","abstract":false,"args":[{"name":"value","external_name":"value","restriction":"Bool"},{"name":"start","external_name":"start","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"}],"args_string":"(value : Bool, start : Int, count : Int) : self","args_html":"(value : <a href=\"Bool.html\">Bool</a>, start : <a href=\"Int.html\">Int</a>, count : <a href=\"Int.html\">Int</a>) : <span class=\"k\">self</span>","location":{"filename":"src/bit_array.cr","line_number":343,"url":null},"def":{"name":"fill","args":[{"name":"value","external_name":"value","restriction":"Bool"},{"name":"start","external_name":"start","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"}],"return_type":"self","visibility":"Public","body":"start, count = normalize_start_and_count(start, count)\nif count <= 0\n  return self\nend\nbytes = to_slice\n\nstart_bit_index, start_sub_index = start.divmod(8)\nend_bit_index, end_sub_index = ((start + count) - 1).divmod(8)\n\nif start_bit_index == end_bit_index\n  mask = uint8_mask(start_sub_index, end_sub_index)\n  set_bits(bytes, value, start_bit_index, mask)\nelse\n  mask = uint8_mask(start_sub_index, 7)\n  set_bits(bytes, value, start_bit_index, mask)\n\n  bytes[(start_bit_index + 1)..(end_bit_index - 1)].fill(value ? 255_u8 : 0_u8)\n\n  mask = uint8_mask(0, end_sub_index)\n  set_bits(bytes, value, end_bit_index, mask)\nend\n\nself\n"},"external_var":false},{"html_id":"fill(value:Bool):self-instance-method","name":"fill","doc":"Replaces every element in `self` with the given *value*. Returns `self`.\n\n```\narray = [1, 2, 3, 4]\narray.fill(2) # => [2, 2, 2, 2]\narray         # => [2, 2, 2, 2]\n```","summary":"<p>Replaces every element in <code>self</code> with the given <em>value</em>.</p>","abstract":false,"args":[{"name":"value","external_name":"value","restriction":"Bool"}],"args_string":"(value : Bool) : self","args_html":"(value : <a href=\"Bool.html\">Bool</a>) : <span class=\"k\">self</span>","location":{"filename":"src/bit_array.cr","line_number":329,"url":null},"def":{"name":"fill","args":[{"name":"value","external_name":"value","restriction":"Bool"}],"return_type":"self","visibility":"Public","body":"if size == 0\n  return self\nend\n\nif size <= 64\n  (@bits.as(::Pointer(UInt64))).value = value ? ~(UInt64::MAX << size) : 0_u64\nelse\n  to_slice.fill(value ? 255_u8 : 0_u8)\n  if value\n    clear_unused_bits\n  end\nend\n\nself\n"},"external_var":false},{"html_id":"hash(hasher)-instance-method","name":"hash","doc":"See `Object#hash(hasher)`","summary":"<p>See <code><a href=\"Object.html#hash%28hasher%29-instance-method\">Object#hash(hasher)</a></code></p>","abstract":false,"args":[{"name":"hasher","external_name":"hasher","restriction":""}],"args_string":"(hasher)","args_html":"(hasher)","location":{"filename":"src/bit_array.cr","line_number":631,"url":null},"def":{"name":"hash","args":[{"name":"hasher","external_name":"hasher","restriction":""}],"visibility":"Public","body":"hasher = size.hash(hasher)\nhasher = to_slice.hash(hasher)\nhasher\n"},"external_var":false},{"html_id":"includes?(obj:Bool):Bool-instance-method","name":"includes?","doc":"Returns `true` if the collection contains *obj*, `false` otherwise.\n\n```\nba = BitArray.new(8, true)\nba.includes?(true)  # => true\nba.includes?(false) # => false\n```","summary":"<p>Returns <code>true</code> if the collection contains <em>obj</em>, <code>false</code> otherwise.</p>","abstract":false,"args":[{"name":"obj","external_name":"obj","restriction":"Bool"}],"args_string":"(obj : Bool) : Bool","args_html":"(obj : <a href=\"Bool.html\">Bool</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/bit_array.cr","line_number":218,"url":null},"def":{"name":"includes?","args":[{"name":"obj","external_name":"obj","restriction":"Bool"}],"return_type":"Bool","visibility":"Public","body":"obj ? any? : !all?"},"external_var":false},{"html_id":"index(obj:Bool,offset:Int=0):Int32|Nil-instance-method","name":"index","doc":"Returns the index of the first appearance of *obj* in `self`\nstarting from the given *offset*, or `nil` if the value is not in `self`.\n\n```\nba = BitArray.new(16)\nba[5] = ba[11] = true\nba.index(true)             # => 5\nba.index(true, offset: 8)  # => 11\nba.index(true, offset: 12) # => nil\n```","summary":"<p>Returns the index of the first appearance of <em>obj</em> in <code>self</code> starting from the given <em>offset</em>, or <code>nil</code> if the value is not in <code>self</code>.</p>","abstract":false,"args":[{"name":"obj","external_name":"obj","restriction":"Bool"},{"name":"offset","default_value":"0","external_name":"offset","restriction":"Int"}],"args_string":"(obj : Bool, offset : Int = 0) : Int32 | Nil","args_html":"(obj : <a href=\"Bool.html\">Bool</a>, offset : <a href=\"Int.html\">Int</a> = <span class=\"n\">0</span>) : <a href=\"Int32.html\">Int32</a> | <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/bit_array.cr","line_number":242,"url":null},"def":{"name":"index","args":[{"name":"obj","external_name":"obj","restriction":"Bool"},{"name":"offset","default_value":"0","external_name":"offset","restriction":"Int"}],"return_type":"Int32 | ::Nil","visibility":"Public","body":"offset = check_index_out_of_bounds(offset) do return nil end\nstart_bit_index, start_sub_index = offset.divmod(32)\nend_bit_index, end_sub_index = (@size - 1).divmod(32)\n\nif start_bit_index == end_bit_index\n  check_index_in_bits(start_bit_index, start_sub_index, end_sub_index)\nelse\n  check_index_in_bits(start_bit_index, start_sub_index, 31)\n  ((start_bit_index + 1)..(end_bit_index - 1)).each do |i|\n    check_index_in_bits(i, 0, 31)\n  end\n  check_index_in_bits(end_bit_index, 0, end_sub_index)\nend\n"},"external_var":false},{"html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Creates a string representation of `self`.\n\n```\nrequire \"bit_array\"\n\nba = BitArray.new(5)\nba.to_s # => \"BitArray[00000]\"\n```","summary":"<p>Creates a string representation of <code>self</code>.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/bit_array.cr","line_number":616,"url":null},"def":{"name":"inspect","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"to_s(io)"},"external_var":false},{"html_id":"invert:Nil-instance-method","name":"invert","doc":"Inverts all bits in the array. Falses become `true` and vice versa.\n\n```\nrequire \"bit_array\"\n\nba = BitArray.new(5)\nba[2] = true; ba[3] = true\nba # => BitArray[00110]\nba.invert\nba # => BitArray[11001]\n```","summary":"<p>Inverts all bits in the array.</p>","abstract":false,"location":{"filename":"src/bit_array.cr","line_number":477,"url":null},"def":{"name":"invert","return_type":"Nil","visibility":"Public","body":"malloc_size.times do |i|\n  @bits[i] = ~@bits[i]\nend\nclear_unused_bits\n"},"external_var":false},{"html_id":"none?:Bool-instance-method","name":"none?","doc":"Returns `true` if all of the elements of the collection are falsey.\n\n```\n[nil, false].none?       # => true\n[nil, false, true].none? # => false\n```\n\nIt's the opposite of `all?`.","summary":"<p>Returns <code>true</code> if all of the elements of the collection are falsey.</p>","abstract":false,"location":{"filename":"src/bit_array.cr","line_number":207,"url":null},"def":{"name":"none?","return_type":"Bool","visibility":"Public","body":"!any?"},"external_var":false},{"html_id":"one?:Bool-instance-method","name":"one?","doc":"Returns `true` if only one element in this enumerable\nis truthy.\n\n```\n[1, false, false].one? # => true\n[1, false, 3].one?     # => false\n[1].one?               # => true\n[false].one?           # => false\n```","summary":"<p>Returns <code>true</code> if only one element in this enumerable is truthy.</p>","abstract":false,"location":{"filename":"src/bit_array.cr","line_number":223,"url":null},"def":{"name":"one?","return_type":"Bool","visibility":"Public","body":"c = 0\nmalloc_size.times do |i|\n  c = c + @bits[i].popcount\n  if c > 1\n    return false\n  end\nend\nc == 1\n"},"external_var":false},{"html_id":"reverse!:self-instance-method","name":"reverse!","doc":"Reverses in-place all the elements of `self`. Returns `self`.","summary":"<p>Reverses in-place all the elements of <code>self</code>.</p>","abstract":false,"location":{"filename":"src/bit_array.cr","line_number":485,"url":null},"def":{"name":"reverse!","return_type":"self","visibility":"Public","body":"if size <= 1\n  return self\nend\n\nif size <= 32\n  @bits.value = @bits.value.bit_reverse >> (32 - size)\nelsif size <= 64\n  more_bits = @bits.as(::Pointer(UInt64))\n  more_bits.value = more_bits.value.bit_reverse >> (64 - size)\nelse\n  offset = (-size) % 32\n  if offset != 0\n    (malloc_size - 1).downto(1) do |i|\n\n      @bits[i] = (Intrinsics.fshl32(@bits[i], @bits[i - 1], offset)).bit_reverse\n    end\n\n\n\n\n\n    @bits[0] = (@bits[0] << offset).bit_reverse\n  else\n    (Slice.new(@bits, malloc_size)).map!(&.bit_reverse)\n  end\n\n\n\n\n  (Slice.new(@bits, malloc_size)).reverse!\nend\n\nself\n"},"external_var":false},{"html_id":"rindex(obj:Bool,offset:Int=size-1):Int32|Nil-instance-method","name":"rindex","doc":"Returns the index of the last appearance of *obj* in `self`, or\n`nil` if *obj* is not in `self`.\n\nIf *offset* is given, the search starts from that index towards the\nfirst elements in `self`.\n\n```\nba = BitArray.new(16)\nba[5] = ba[11] = true\nba.rindex(true)            # => 11\nba.rindex(true, offset: 8) # => 5\nba.rindex(true, offset: 4) # => nil\n```","summary":"<p>Returns the index of the last appearance of <em>obj</em> in <code>self</code>, or <code>nil</code> if <em>obj</em> is not in <code>self</code>.</p>","abstract":false,"args":[{"name":"obj","external_name":"obj","restriction":"Bool"},{"name":"offset","default_value":"size - 1","external_name":"offset","restriction":"Int"}],"args_string":"(obj : Bool, offset : Int = size - 1) : Int32 | Nil","args_html":"(obj : <a href=\"Bool.html\">Bool</a>, offset : <a href=\"Int.html\">Int</a> = size <span class=\"o\">-</span> <span class=\"n\">1</span>) : <a href=\"Int32.html\">Int32</a> | <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/bit_array.cr","line_number":278,"url":null},"def":{"name":"rindex","args":[{"name":"obj","external_name":"obj","restriction":"Bool"},{"name":"offset","default_value":"size - 1","external_name":"offset","restriction":"Int"}],"return_type":"Int32 | ::Nil","visibility":"Public","body":"offset = check_index_out_of_bounds(offset) do return nil end\nstart_bit_index, start_sub_index = offset.divmod(32)\n\ncheck_rindex_in_bits(start_bit_index, 0, start_sub_index)\n(start_bit_index - 1).downto(0) do |i|\n  check_rindex_in_bits(i, 0, 31)\nend\n"},"external_var":false},{"html_id":"rotate!(n:Int=1):self-instance-method","name":"rotate!","doc":"Shifts all elements of `self` to the left *n* times. Returns `self`.\n\n```\na1 = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]\na2 = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]\na3 = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]\n\na1.rotate!\na2.rotate!(1)\na3.rotate!(3)\n\na1 # => [1, 2, 3, 4, 5, 6, 7, 8, 9, 0]\na2 # => [1, 2, 3, 4, 5, 6, 7, 8, 9, 0]\na3 # => [3, 4, 5, 6, 7, 8, 9, 0, 1, 2]\n```","summary":"<p>Shifts all elements of <code>self</code> to the left <em>n</em> times.</p>","abstract":false,"args":[{"name":"n","default_value":"1","external_name":"n","restriction":"Int"}],"args_string":"(n : Int = 1) : self","args_html":"(n : <a href=\"Int.html\">Int</a> = <span class=\"n\">1</span>) : <span class=\"k\">self</span>","location":{"filename":"src/bit_array.cr","line_number":530,"url":null},"def":{"name":"rotate!","args":[{"name":"n","default_value":"1","external_name":"n","restriction":"Int"}],"return_type":"self","visibility":"Public","body":"if size <= 1\n  return self\nend\nn = n % size\nif n == 0\n  return self\nend\n\nif ((size % 8) == 0) && ((n % 8) == 0)\n  to_slice.rotate!(n // 8)\nelsif size <= 32\n  @bits[0] = (@bits[0] >> n) | (@bits[0] << (size - n))\n  clear_unused_bits\nelsif n <= 32\n  temp = @bits[0]\n  malloc_size = self.malloc_size\n  (malloc_size - 1).times do |i|\n\n    @bits[i] = Intrinsics.fshr32(@bits[i + 1], @bits[i], n)\n  end\n\n  end_sub_index = ((size - 1) % 32) + 1\n  if n <= end_sub_index\n    @bits[malloc_size - 1] = (@bits[malloc_size - 1] >> n) | (temp << (end_sub_index - n))\n  else\n    __temp_87eaed39_21 = malloc_size - 2\n    @bits[__temp_87eaed39_21] = @bits[__temp_87eaed39_21] | (temp << ((32 + end_sub_index) - n))\n    @bits[malloc_size - 1] = temp << (end_sub_index - n)\n  end\n\n  clear_unused_bits\nelsif n >= (size - 32)\n  n = size - n\n  malloc_size = self.malloc_size\n\n  end_sub_index = ((size - 1) % 32) + 1\n  if n <= end_sub_index\n    temp = @bits[malloc_size - 1] >> (end_sub_index - n)\n  else\n    temp = Intrinsics.fshl32(@bits[malloc_size - 1], @bits[malloc_size - 2], n - end_sub_index)\n  end\n\n  (malloc_size - 1).downto(1) do |i|\n    @bits[i] = Intrinsics.fshl32(@bits[i], @bits[i - 1], n)\n  end\n  @bits[0] = (@bits[0] << n) | temp\n\n  clear_unused_bits\nelse\n  super(n)\nend\n\nself\n"},"external_var":false},{"html_id":"size:Int32-instance-method","name":"size","doc":"The number of bits the BitArray stores","summary":"<p>The number of bits the BitArray stores</p>","abstract":false,"location":{"filename":"src/bit_array.cr","line_number":24,"url":null},"def":{"name":"size","return_type":"Int32","visibility":"Public","body":"@size"},"external_var":false},{"html_id":"tally(hash)-instance-method","name":"tally","doc":"Tallies the collection. Accepts a *hash* to count occurrences.\nThe value corresponding to each element must be an integer.\nThe number of occurrences is added to each value in *hash*,\nand *hash* is returned.\n\n```\nhash = {} of Char => Int32\nwords = [\"crystal\", \"ruby\"]\nwords.each { |word| word.chars.tally(hash) }\nhash # => {'c' => 1, 'r' => 2, 'y' => 2, 's' => 1, 't' => 1, 'a' => 1, 'l' => 1, 'u' => 1, 'b' => 1}\n```","summary":"<p>Tallies the collection.</p>","abstract":false,"args":[{"name":"hash","external_name":"hash","restriction":""}],"args_string":"(hash)","args_html":"(hash)","location":{"filename":"src/bit_array.cr","line_number":315,"url":null},"def":{"name":"tally","args":[{"name":"hash","external_name":"hash","restriction":""}],"visibility":"Public","body":"ones_count = count(true)\nif ones_count > 0\n  count = hash.fetch(true) do (typeof(hash[true])).zero end\n  hash[true] = count + ones_count\nend\nif ones_count < @size\n  count = hash.fetch(false) do (typeof(hash[false])).zero end\n  hash[false] = (count + @size) - ones_count\nend\nhash\n"},"external_var":false},{"html_id":"tally:Hash(Bool,Int32)-instance-method","name":"tally","doc":"Tallies the collection.  Returns a hash where the keys are the\nelements and the values are numbers of elements in the collection\nthat correspond to the key.\n\n```\n[\"a\", \"b\", \"c\", \"b\"].tally # => {\"a\"=>1, \"b\"=>2, \"c\"=>1}\n```","summary":"<p>Tallies the collection.</p>","abstract":false,"location":{"filename":"src/bit_array.cr","line_number":310,"url":null},"def":{"name":"tally","return_type":"Hash(Bool, Int32)","visibility":"Public","body":"tally(Hash(Bool, Int32).new)"},"external_var":false},{"html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Creates a string representation of `self`.\n\n```\nrequire \"bit_array\"\n\nba = BitArray.new(5)\nba.to_s # => \"BitArray[00000]\"\n```","summary":"<p>Creates a string representation of <code>self</code>.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/bit_array.cr","line_number":607,"url":null},"def":{"name":"to_s","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"io << \"BitArray[\"\neach do |value|\n  io << (value ? '1' : '0')\nend\nio << ']'\n"},"external_var":false},{"html_id":"to_slice:Bytes-instance-method","name":"to_slice","doc":"Returns a `Bytes` able to read and write bytes from a buffer.\nThe slice will be long enough to hold all the bits groups in bytes despite the `UInt32` internal representation.\nIt's useful for reading and writing a bit array from a byte buffer directly.\n\nWARNING: It is undefined behaviour to set any of the unused bits of a bit array to\n`true` via a slice.","summary":"<p>Returns a <code><a href=\"Bytes.html\">Bytes</a></code> able to read and write bytes from a buffer.</p>","abstract":false,"location":{"filename":"src/bit_array.cr","line_number":626,"url":null},"def":{"name":"to_slice","return_type":"Bytes","visibility":"Public","body":"Slice.new(@bits.as(Pointer(UInt8)), bytesize)"},"external_var":false},{"html_id":"toggle(start:Int,count:Int)-instance-method","name":"toggle","doc":"Toggles *count* or less (if there aren't enough) bits starting at the given\n*start* index. A `false` bit becomes a `true` bit, and vice versa.\n\nNegative indices count backward from the end of the array (-1 is the last\nelement).\n\nRaises `IndexError` if *index* is out of range.\nRaises `ArgumentError` if *count* is a negative number.\n\n```\nrequire \"bit_array\"\n\nba = BitArray.new(5)\nba.to_s # => \"BitArray[00000]\"\nba.toggle(1, 3)\nba.to_s # => \"BitArray[01110]\"\n```","summary":"<p>Toggles <em>count</em> or less (if there aren't enough) bits starting at the given <em>start</em> index.</p>","abstract":false,"args":[{"name":"start","external_name":"start","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"}],"args_string":"(start : Int, count : Int)","args_html":"(start : <a href=\"Int.html\">Int</a>, count : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/bit_array.cr","line_number":441,"url":null},"def":{"name":"toggle","args":[{"name":"start","external_name":"start","restriction":"Int"},{"name":"count","external_name":"count","restriction":"Int"}],"visibility":"Public","body":"start, count = normalize_start_and_count(start, count)\nif count == 0\n  return\nend\n\nstart_bit_index, start_sub_index = start.divmod(32)\nend_bit_index, end_sub_index = ((start + count) - 1).divmod(32)\n\nif start_bit_index == end_bit_index\n  __temp_87eaed39_15 = start_bit_index\n  @bits[__temp_87eaed39_15] = @bits[__temp_87eaed39_15] ^ (uint32_mask(start_sub_index, end_sub_index))\nelse\n  __temp_87eaed39_17 = start_bit_index\n  @bits[__temp_87eaed39_17] = @bits[__temp_87eaed39_17] ^ (uint32_mask(start_sub_index, 31))\n  ((start_bit_index + 1)..(end_bit_index - 1)).each do |i|\n    @bits[i] = ~@bits[i]\n  end\n  __temp_87eaed39_19 = end_bit_index\n  @bits[__temp_87eaed39_19] = @bits[__temp_87eaed39_19] ^ (uint32_mask(0, end_sub_index))\nend\n"},"external_var":false},{"html_id":"toggle(range:Range)-instance-method","name":"toggle","doc":"Toggles all bits that are within the given *range*. A `false` bit becomes a\n`true` bit, and vice versa.\n\nNegative indices count backward from the end of the array (-1 is the last\nelement).\n\nRaises `IndexError` if the starting index is out of range.\n\n```\nrequire \"bit_array\"\n\nba = BitArray.new(5)\nba.to_s # => \"BitArray[00000]\"\nba.toggle(1..-2)\nba.to_s # => \"BitArray[01110]\"\n```","summary":"<p>Toggles all bits that are within the given <em>range</em>.</p>","abstract":false,"args":[{"name":"range","external_name":"range","restriction":"Range"}],"args_string":"(range : Range)","args_html":"(range : <a href=\"Range.html\">Range</a>)","location":{"filename":"src/bit_array.cr","line_number":420,"url":null},"def":{"name":"toggle","args":[{"name":"range","external_name":"range","restriction":"Range"}],"visibility":"Public","body":"toggle(*(Indexable.range_to_index_and_count(range, size)) || (raise(IndexError.new)))"},"external_var":false},{"html_id":"toggle(index):Nil-instance-method","name":"toggle","doc":"Toggles the bit at the given *index*. A `false` bit becomes a `true` bit,\nand vice versa.\n\nNegative indices count backward from the end of the array (-1 is the last\nelement).\n\nRaises `IndexError` if *index* is out of range.\n\n```\nrequire \"bit_array\"\n\nba = BitArray.new(5)\nba[3] # => false\nba.toggle(3)\nba[3] # => true\n```","summary":"<p>Toggles the bit at the given <em>index</em>.</p>","abstract":false,"args":[{"name":"index","external_name":"index","restriction":""}],"args_string":"(index) : Nil","args_html":"(index) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/bit_array.cr","line_number":399,"url":null},"def":{"name":"toggle","args":[{"name":"index","external_name":"index","restriction":""}],"return_type":"Nil","visibility":"Public","body":"bit_index, sub_index = bit_index_and_sub_index(index)\n__temp_87eaed39_13 = bit_index\n@bits[__temp_87eaed39_13] = @bits[__temp_87eaed39_13] ^ (1 << sub_index)\n"},"external_var":false},{"html_id":"unsafe_fetch(index:Int):Bool-instance-method","name":"unsafe_fetch","doc":"Returns the element at the given *index*, without doing any bounds check.\n\n`Indexable` makes sure to invoke this method with *index* in `0...size`,\nso converting negative indices to positive ones is not needed here.\n\nClients never invoke this method directly. Instead, they access\nelements with `#[](index)` and `#[]?(index)`.\n\nThis method should only be directly invoked if you are absolutely\nsure the index is in bounds, to avoid a bounds check for a small boost\nof performance.","summary":"<p>Returns the element at the given <em>index</em>, without doing any bounds check.</p>","abstract":false,"args":[{"name":"index","external_name":"index","restriction":"Int"}],"args_string":"(index : Int) : Bool","args_html":"(index : <a href=\"Int.html\">Int</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/bit_array.cr","line_number":62,"url":null},"def":{"name":"unsafe_fetch","args":[{"name":"index","external_name":"index","restriction":"Int"}],"return_type":"Bool","visibility":"Public","body":"bit_index, sub_index = index.divmod(32)\n(@bits[bit_index] & (1 << sub_index)) > 0\n"},"external_var":false},{"html_id":"unsafe_put(index:Int,value:Bool)-instance-method","name":"unsafe_put","doc":"Sets the element at the given *index* to *value*, without doing any bounds\ncheck.\n\n`Indexable::Mutable` makes sure to invoke this method with *index* in\n`0...size`, so converting negative indices to positive ones is not needed\nhere.\n\nClients never invoke this method directly. Instead, they modify elements\nwith `#[]=(index, value)`.\n\nThis method should only be directly invoked if you are absolutely\nsure the index is in bounds, to avoid a bounds check for a small boost\nof performance.","summary":"<p>Sets the element at the given <em>index</em> to <em>value</em>, without doing any bounds check.</p>","abstract":false,"args":[{"name":"index","external_name":"index","restriction":"Int"},{"name":"value","external_name":"value","restriction":"Bool"}],"args_string":"(index : Int, value : Bool)","args_html":"(index : <a href=\"Int.html\">Int</a>, value : <a href=\"Bool.html\">Bool</a>)","location":{"filename":"src/bit_array.cr","line_number":67,"url":null},"def":{"name":"unsafe_put","args":[{"name":"index","external_name":"index","restriction":"Int"},{"name":"value","external_name":"value","restriction":"Bool"}],"visibility":"Public","body":"bit_index, sub_index = index.divmod(32)\nif value\n  __temp_87eaed39_1 = bit_index\n  @bits[__temp_87eaed39_1] = @bits[__temp_87eaed39_1] | (1 << sub_index)\nelse\n  __temp_87eaed39_3 = bit_index\n  @bits[__temp_87eaed39_3] = @bits[__temp_87eaed39_3] & (~(1 << sub_index))\nend\n"},"external_var":false}]},{"html_id":"Crystal/Bool","path":"Bool.html","kind":"struct","full_name":"Bool","name":"Bool","abstract":false,"superclass":{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},"ancestors":[{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/bool.cr","line_number":9,"url":null},{"filename":"src/json/to_json.cr","line_number":37,"url":null},{"filename":"src/primitives.cr","line_number":161,"url":null},{"filename":"src/uri/params/to_www_form.cr","line_number":1,"url":null},{"filename":"src/yaml/to_yaml.cr","line_number":116,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"doc":"Bool has only two possible values: `true` and `false`. They are constructed using these literals:\n\n```\ntrue  # A Bool that is true\nfalse # A Bool that is false\n```\n\nSee [`Bool` literals](https://crystal-lang.org/reference/syntax_and_semantics/literals/bool.html) in the language reference.","summary":"<p>Bool has only two possible values: <code>true</code> and <code>false</code>.</p>","constructors":[{"html_id":"new(ctx:YAML::ParseContext,node:YAML::Nodes::Node)-class-method","name":"new","abstract":false,"args":[{"name":"ctx","external_name":"ctx","restriction":"YAML::ParseContext"},{"name":"node","external_name":"node","restriction":"YAML::Nodes::Node"}],"args_string":"(ctx : YAML::ParseContext, node : YAML::Nodes::Node)","args_html":"(ctx : <a href=\"YAML/ParseContext.html\">YAML::ParseContext</a>, node : <a href=\"YAML/Nodes/Node.html\">YAML::Nodes::Node</a>)","location":{"filename":"src/yaml/from_yaml.cr","line_number":56,"url":null},"def":{"name":"new","args":[{"name":"ctx","external_name":"ctx","restriction":"YAML::ParseContext"},{"name":"node","external_name":"node","restriction":"YAML::Nodes::Node"}],"visibility":"Public","body":"parse_scalar(ctx, node, self)"},"external_var":false},{"html_id":"new(pull:JSON::PullParser):self-class-method","name":"new","abstract":false,"args":[{"name":"pull","external_name":"pull","restriction":"JSON::PullParser"}],"args_string":"(pull : JSON::PullParser) : self","args_html":"(pull : <a href=\"JSON/PullParser.html\">JSON::PullParser</a>) : <span class=\"k\">self</span>","location":{"filename":"src/json/from_json.cr","line_number":123,"url":null},"def":{"name":"new","args":[{"name":"pull","external_name":"pull","restriction":"JSON::PullParser"}],"return_type":"self","visibility":"Public","body":"pull.read_bool"},"external_var":false}],"instance_methods":[{"html_id":"!=(other:Bool):Bool-instance-method","name":"!=","doc":"Returns `true` if `self` is not equal to *other*.","summary":"<p>Returns <code>true</code> if <code>self</code> is not equal to <em>other</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Bool"}],"args_string":"(other : Bool) : Bool","args_html":"(other : <a href=\"Bool.html\">Bool</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/primitives.cr","line_number":169,"url":null},"def":{"name":"!=","args":[{"name":"other","external_name":"other","restriction":"Bool"}],"return_type":"Bool","visibility":"Public","body":"# primitive: binary"},"external_var":false},{"html_id":"&(other:Bool):Bool-instance-method","name":"&","doc":"Bitwise AND. Returns `true` if this bool and *other* are `true`, otherwise returns `false`.\n\n```\nfalse & false # => false\nfalse & true  # => false\ntrue & false  # => false\ntrue & true   # => true\n```","summary":"<p>Bitwise AND.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Bool"}],"args_string":"(other : Bool) : Bool","args_html":"(other : <a href=\"Bool.html\">Bool</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/bool.cr","line_number":30,"url":null},"def":{"name":"&","args":[{"name":"other","external_name":"other","restriction":"Bool"}],"return_type":"Bool","visibility":"Public","body":"self ? other : false"},"external_var":false},{"html_id":"==(other:Bool):Bool-instance-method","name":"==","doc":"Returns `true` if `self` is equal to *other*.","summary":"<p>Returns <code>true</code> if <code>self</code> is equal to <em>other</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Bool"}],"args_string":"(other : Bool) : Bool","args_html":"(other : <a href=\"Bool.html\">Bool</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/primitives.cr","line_number":164,"url":null},"def":{"name":"==","args":[{"name":"other","external_name":"other","restriction":"Bool"}],"return_type":"Bool","visibility":"Public","body":"# primitive: binary"},"external_var":false},{"html_id":"^(other:Bool):Bool-instance-method","name":"^","doc":"Exclusive OR. Returns `true` if this bool is different from *other*, otherwise returns `false`.\n\n```\nfalse ^ false # => false\nfalse ^ true  # => true\ntrue ^ false  # => true\ntrue ^ true   # => false\n```","summary":"<p>Exclusive OR.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Bool"}],"args_string":"(other : Bool) : Bool","args_html":"(other : <a href=\"Bool.html\">Bool</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/bool.cr","line_number":42,"url":null},"def":{"name":"^","args":[{"name":"other","external_name":"other","restriction":"Bool"}],"return_type":"Bool","visibility":"Public","body":"self != other"},"external_var":false},{"html_id":"|(other:Bool):Bool-instance-method","name":"|","doc":"Bitwise OR. Returns `true` if this bool or *other* is `true`, otherwise returns `false`.\n\n```\nfalse | false # => false\nfalse | true  # => true\ntrue | false  # => true\ntrue | true   # => true\n```","summary":"<p>Bitwise OR.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Bool"}],"args_string":"(other : Bool) : Bool","args_html":"(other : <a href=\"Bool.html\">Bool</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/bool.cr","line_number":18,"url":null},"def":{"name":"|","args":[{"name":"other","external_name":"other","restriction":"Bool"}],"return_type":"Bool","visibility":"Public","body":"self ? true : other"},"external_var":false},{"html_id":"clone:Bool-instance-method","name":"clone","abstract":false,"location":{"filename":"src/bool.cr","line_number":68,"url":null},"def":{"name":"clone","return_type":"Bool","visibility":"Public","body":"self"},"external_var":false},{"html_id":"hash(hasher)-instance-method","name":"hash","doc":"See `Object#hash(hasher)`","summary":"<p>See <code><a href=\"Object.html#hash%28hasher%29-instance-method\">Object#hash(hasher)</a></code></p>","abstract":false,"args":[{"name":"hasher","external_name":"hasher","restriction":""}],"args_string":"(hasher)","args_html":"(hasher)","location":{"filename":"src/bool.cr","line_number":47,"url":null},"def":{"name":"hash","args":[{"name":"hasher","external_name":"hasher","restriction":""}],"visibility":"Public","body":"hasher.bool(self)"},"external_var":false},{"html_id":"to_json(json:JSON::Builder):Nil-instance-method","name":"to_json","abstract":false,"args":[{"name":"json","external_name":"json","restriction":"JSON::Builder"}],"args_string":"(json : JSON::Builder) : Nil","args_html":"(json : <a href=\"JSON/Builder.html\">JSON::Builder</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/json/to_json.cr","line_number":38,"url":null},"def":{"name":"to_json","args":[{"name":"json","external_name":"json","restriction":"JSON::Builder"}],"return_type":"Nil","visibility":"Public","body":"json.bool(self)"},"external_var":false},{"html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Appends `\"true\"` for `true` and `\"false\"` for `false` to the given IO.","summary":"<p>Appends <code>&quot;true&quot;</code> for <code>true</code> and <code>&quot;false&quot;</code> for <code>false</code> to the given IO.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/bool.cr","line_number":64,"url":null},"def":{"name":"to_s","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"io << to_s"},"external_var":false},{"html_id":"to_s:String-instance-method","name":"to_s","doc":"Returns `\"true\"` for `true` and `\"false\"` for `false`.","summary":"<p>Returns <code>&quot;true&quot;</code> for <code>true</code> and <code>&quot;false&quot;</code> for <code>false</code>.</p>","abstract":false,"location":{"filename":"src/bool.cr","line_number":59,"url":null},"def":{"name":"to_s","return_type":"String","visibility":"Public","body":"self ? \"true\" : \"false\""},"external_var":false},{"html_id":"to_unsafe:LibC::Int-instance-method","name":"to_unsafe","doc":"Returns an integer derived from the boolean value, for interoperability with C-style booleans.\n\nThe value is `1` for `true` and `0` for `false`.","summary":"<p>Returns an integer derived from the boolean value, for interoperability with C-style booleans.</p>","abstract":false,"location":{"filename":"src/bool.cr","line_number":54,"url":null},"def":{"name":"to_unsafe","return_type":"LibC::Int","visibility":"Public","body":"LibC::Int.new(self ? 1 : 0)"},"external_var":false},{"html_id":"to_yaml(yaml:YAML::Nodes::Builder):Nil-instance-method","name":"to_yaml","abstract":false,"args":[{"name":"yaml","external_name":"yaml","restriction":"YAML::Nodes::Builder"}],"args_string":"(yaml : YAML::Nodes::Builder) : Nil","args_html":"(yaml : <a href=\"YAML/Nodes/Builder.html\">YAML::Nodes::Builder</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/yaml/to_yaml.cr","line_number":117,"url":null},"def":{"name":"to_yaml","args":[{"name":"yaml","external_name":"yaml","restriction":"YAML::Nodes::Builder"}],"return_type":"Nil","visibility":"Public","body":"yaml.scalar(self)"},"external_var":false}]},{"html_id":"Crystal/Box","path":"Box.html","kind":"class","full_name":"Box(T)","name":"Box","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/box.cr","line_number":7,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"doc":"A Box allows turning any object to a `Void*` and back.\n\nA Box's purpose is passing data to C as a `Void*` and then converting that\nback to the original data type.\n\nFor an example usage, see `Proc`'s explanation about sending Procs to C.","summary":"<p>A Box allows turning any object to a <code>Void*</code> and back.</p>","class_methods":[{"html_id":"box(object:T):Pointer(Void)-class-method","name":"box","doc":"Turns *object* into a `Void*`.\n\nIf `T` is not a reference or pointer type, nor a union between reference\ntypes and `Nil`, this method effectively copies *object* to the dynamic\nheap.\n\nNOTE: The returned pointer might not be a null pointer even when *object* is\n`nil`.","summary":"<p>Turns <em>object</em> into a <code>Void*</code>.</p>","abstract":false,"args":[{"name":"object","external_name":"object","restriction":"T"}],"args_string":"(object : T) : Pointer(Void)","args_html":"(object : T) : <a href=\"Pointer.html\">Pointer</a>(Void)","location":{"filename":"src/box.cr","line_number":29,"url":null},"def":{"name":"box","args":[{"name":"object","external_name":"object","restriction":"T"}],"return_type":"::Pointer(Void)","visibility":"Public","body":"{% if T < Pointer || T.union_types.all? do |t| (t == Nil) || t < Reference end %}\n      object.as(Void*)\n    {% else %}\n      # NOTE: if `T` is explicitly specified and `typeof(object) < T` (e.g.\n      # `Box(Int32?).box(1)`, then `.new` will perform the appropriate upcast\n      new(object).as(Void*)\n    {% end %}"},"external_var":false},{"html_id":"unbox(pointer:Pointer(Void)):T-class-method","name":"unbox","doc":"Unboxes a `Void*` into an object of type `T`. Note that for this you must\nspecify T: `Box(T).unbox(data)`.\n\nRaises `NilAssertionError` if *pointer* is null and `T` is not nilable.\n\nWARNING: It is undefined behavior to box an object in one type and unbox it\nvia a different type; in particular, when boxing a `T` and unboxing it as a\n`T?`, or vice-versa.","summary":"<p>Unboxes a <code>Void*</code> into an object of type <code>T</code>.</p>","abstract":false,"args":[{"name":"pointer","external_name":"pointer","restriction":"::Pointer(Void)"}],"args_string":"(pointer : Pointer(Void)) : T","args_html":"(pointer : <a href=\"Pointer.html\">Pointer</a>(Void)) : T","location":{"filename":"src/box.cr","line_number":47,"url":null},"def":{"name":"unbox","args":[{"name":"pointer","external_name":"pointer","restriction":"::Pointer(Void)"}],"return_type":"T","visibility":"Public","body":"{% if T < Pointer %}\n      pointer.as(T)\n    {% elsif T.union_types.all? do |t| (t == Nil) || t < Reference end %}\n      {% unless T.union_types.any? do |t| t == Nil end %}\n        if pointer.null?\n          raise NilAssertionError.new(\"Unboxing null pointer\")\n        end\n      {% end %}\n      pointer.as(T)\n    {% else %}\n      if pointer.null?\n        raise NilAssertionError.new(\"Unboxing null pointer in mixed union\")\n      end\n\n      pointer.as(self).object\n    {% end %}"},"external_var":false}]},{"html_id":"Crystal/Bytes","path":"Bytes.html","kind":"alias","full_name":"Bytes","name":"Bytes","abstract":false,"locations":[{"filename":"src/slice.cr","line_number":1258,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":true,"aliased":"Slice(UInt8)","aliased_html":"<a href=\"Slice.html\">Slice</a>(<a href=\"UInt8.html\">UInt8</a>)","const":false,"doc":"A convenient alias for the most common slice type,\na slice of bytes, used for example in `IO#read` and `IO#write`.","summary":"<p>A convenient alias for the most common slice type, a slice of bytes, used for example in <code><a href=\"IO.html#read%28slice%3ABytes%29-instance-method\">IO#read</a></code> and <code><a href=\"IO.html#write%28slice%3ABytes%29%3ANil-instance-method\">IO#write</a></code>.</p>"},{"html_id":"Crystal/Channel","path":"Channel.html","kind":"class","full_name":"Channel(T)","name":"Channel","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/channel.cr","line_number":26,"url":null},{"filename":"src/channel/select.cr","line_number":1,"url":null},{"filename":"src/channel/select/select_action.cr","line_number":1,"url":null},{"filename":"src/channel/select/timeout_action.cr","line_number":17,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"doc":"A `Channel` enables concurrent communication between fibers.\n\nThey allow communicating data between fibers without sharing memory and without having to worry about locks, semaphores or other special structures.\n\n```\nchannel = Channel(Int32).new\n\nspawn do\n  channel.send(0)\n  channel.send(1)\nend\n\nchannel.receive # => 0\nchannel.receive # => 1\n```\n\nNOTE: Although a `Channel(Nil)` or any other nilable types like `Channel(Int32?)` are valid\nthey are discouraged since from certain methods or constructs it receiving a `nil` as data\nwill be indistinguishable from a closed channel.\n","summary":"<p>A <code><a href=\"Channel.html\">Channel</a></code> enables concurrent communication between fibers.</p>","class_methods":[{"html_id":"receive_first(channels:Enumerable(Channel))-class-method","name":"receive_first","abstract":false,"args":[{"name":"channels","external_name":"channels","restriction":"Enumerable(Channel)"}],"args_string":"(channels : Enumerable(Channel))","args_html":"(channels : <a href=\"Enumerable.html\">Enumerable</a>(<a href=\"Channel.html\">Channel</a>))","location":{"filename":"src/channel.cr","line_number":301,"url":null},"def":{"name":"receive_first","args":[{"name":"channels","external_name":"channels","restriction":"Enumerable(Channel)"}],"visibility":"Public","body":"_, value = self.select(channels.map(&.receive_select_action))\nvalue\n"},"external_var":false},{"html_id":"receive_first(*channels)-class-method","name":"receive_first","abstract":false,"args":[{"name":"channels","external_name":"channels","restriction":""}],"args_string":"(*channels)","args_html":"(*channels)","location":{"filename":"src/channel.cr","line_number":297,"url":null},"def":{"name":"receive_first","args":[{"name":"channels","external_name":"channels","restriction":""}],"splat_index":0,"visibility":"Public","body":"receive_first(channels)"},"external_var":false},{"html_id":"send_first(value,channels:Enumerable(Channel)):Nil-class-method","name":"send_first","abstract":false,"args":[{"name":"value","external_name":"value","restriction":""},{"name":"channels","external_name":"channels","restriction":"Enumerable(Channel)"}],"args_string":"(value, channels : Enumerable(Channel)) : Nil","args_html":"(value, channels : <a href=\"Enumerable.html\">Enumerable</a>(<a href=\"Channel.html\">Channel</a>)) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/channel.cr","line_number":310,"url":null},"def":{"name":"send_first","args":[{"name":"value","external_name":"value","restriction":""},{"name":"channels","external_name":"channels","restriction":"Enumerable(Channel)"}],"return_type":"Nil","visibility":"Public","body":"self.select(channels.map(&.send_select_action(value)))\nnil\n"},"external_var":false},{"html_id":"send_first(value,*channels):Nil-class-method","name":"send_first","abstract":false,"args":[{"name":"value","external_name":"value","restriction":""},{"name":"channels","external_name":"channels","restriction":""}],"args_string":"(value, *channels) : Nil","args_html":"(value, *channels) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/channel.cr","line_number":306,"url":null},"def":{"name":"send_first","args":[{"name":"value","external_name":"value","restriction":""},{"name":"channels","external_name":"channels","restriction":""}],"splat_index":1,"return_type":"Nil","visibility":"Public","body":"send_first(value, channels)"},"external_var":false}],"constructors":[{"html_id":"new(capacity:Int32=0)-class-method","name":"new","abstract":false,"args":[{"name":"capacity","default_value":"0","external_name":"capacity","restriction":"::Int32"}],"args_string":"(capacity : Int32 = 0)","args_html":"(capacity : <a href=\"Int32.html\">Int32</a> = <span class=\"n\">0</span>)","location":{"filename":"src/channel.cr","line_number":81,"url":null},"def":{"name":"new","args":[{"name":"capacity","default_value":"0","external_name":"capacity","restriction":"::Int32"}],"visibility":"Public","body":"_ = Channel(T).allocate\n_.initialize(capacity)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false}],"instance_methods":[{"html_id":"close:Bool-instance-method","name":"close","doc":"Closes the channel.\nThe method prevents any new value from being sent to the channel.\n\nIf the channel has buffered values, then subsequent calls to `receive` will succeed\nand consume the buffer until it is empty.\n\nAll fibers blocked in `send` or `receive` will be awakened with `Channel::ClosedError`.\nAll subsequent calls to `#send` will consider the channel closed.\nSubsequent calls to `#receive` will consider the channel closed if the buffer is empty.\n\nCalling `#close` on a closed channel does not have any effect.\n\nIt returns `true` when the channel was successfully closed, or `false` if it was already closed.","summary":"<p>Closes the channel.</p>","abstract":false,"location":{"filename":"src/channel.cr","line_number":105,"url":null},"def":{"name":"close","return_type":"Bool","visibility":"Public","body":"sender_list = Crystal::PointerLinkedList(Sender(T)).new\nreceiver_list = Crystal::PointerLinkedList(Receiver(T)).new\n\n@lock.sync do\n  if @closed\n    return false\n  end\n  @closed = true\n\n  @senders, sender_list = sender_list, @senders\n  @receivers, receiver_list = receiver_list, @receivers\nend\n\nsender_list.each() do |__arg0| __arg0.value.close end\nreceiver_list.each() do |__arg1| __arg1.value.close end\ntrue\n"},"external_var":false},{"html_id":"closed?:Bool-instance-method","name":"closed?","abstract":false,"location":{"filename":"src/channel.cr","line_number":122,"url":null},"def":{"name":"closed?","return_type":"Bool","visibility":"Public","body":"@closed"},"external_var":false},{"html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Appends a String representation of this object\nwhich includes its class name, its object address\nand the values of all instance variables.\n\n```\nclass Person\n  def initialize(@name : String, @age : Int32)\n  end\nend\n\nPerson.new(\"John\", 32).inspect # => #<Person:0x10fd31f20 @name=\"John\", @age=32>\n```","summary":"<p>Appends a String representation of this object which includes its class name, its object address and the values of all instance variables.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/channel.cr","line_number":289,"url":null},"def":{"name":"inspect","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"to_s(io)"},"external_var":false},{"html_id":"pretty_print(pp)-instance-method","name":"pretty_print","abstract":false,"args":[{"name":"pp","external_name":"pp","restriction":""}],"args_string":"(pp)","args_html":"(pp)","location":{"filename":"src/channel.cr","line_number":293,"url":null},"def":{"name":"pretty_print","args":[{"name":"pp","external_name":"pp","restriction":""}],"visibility":"Public","body":"pp.text(inspect)"},"external_var":false},{"html_id":"receive:T-instance-method","name":"receive","doc":"Receives a value from the channel.\nIf there is a value waiting, then it is returned immediately. Otherwise, this method blocks until a value is sent to the channel.\n\nRaises `ClosedError` if the channel is closed or closes while waiting for receive.\n\n```\nchannel = Channel(Int32).new\nspawn do\n  channel.send(1)\nend\nchannel.receive # => 1\n```","summary":"<p>Receives a value from the channel.</p>","abstract":false,"location":{"filename":"src/channel.cr","line_number":193,"url":null},"def":{"name":"receive","return_type":"T","visibility":"Public","body":"receive_impl do raise(ClosedError.new) end"},"external_var":false},{"html_id":"receive?:T|Nil-instance-method","name":"receive?","doc":"Receives a value from the channel.\nIf there is a value waiting, it is returned immediately. Otherwise, this method blocks until a value is sent to the channel.\n\nReturns `nil` if the channel is closed or closes while waiting for receive.","summary":"<p>Receives a value from the channel.</p>","abstract":false,"location":{"filename":"src/channel.cr","line_number":201,"url":null},"def":{"name":"receive?","return_type":"T | ::Nil","visibility":"Public","body":"receive_impl do return nil end"},"external_var":false},{"html_id":"send(value:T):self-instance-method","name":"send","doc":"Sends a value to the channel.\nIf the channel has spare capacity, then the method returns immediately.\nOtherwise, this method blocks the calling fiber until another fiber calls `#receive` on the channel.\n\nRaises `ClosedError` if the channel is closed or closes while waiting on a full channel.","summary":"<p>Sends a value to the channel.</p>","abstract":false,"args":[{"name":"value","external_name":"value","restriction":"T"}],"args_string":"(value : T) : self","args_html":"(value : T) : <span class=\"k\">self</span>","location":{"filename":"src/channel.cr","line_number":131,"url":null},"def":{"name":"send","args":[{"name":"value","external_name":"value","restriction":"T"}],"return_type":"self","visibility":"Public","body":"sender = Sender(T).new\n\n@lock.lock\n\ncase send_internal(value)\nin .delivered?\n  @lock.unlock\nin .closed?\n  @lock.unlock\n  raise(ClosedError.new)\nin .none?\n  sender.fiber = Fiber.current\n  sender.data = value\n  @senders.push(pointerof(sender))\n  @lock.unlock\n\n  Fiber.suspend\n\n  case sender.state\n  in .delivered?\n  in .closed?\n    raise(ClosedError.new)\n  in .none?\n    raise(\"BUG: Fiber was awaken without channel delivery state set\")\n  end\nend\n\nself\n"},"external_var":false}],"types":[{"html_id":"Crystal/Channel/ClosedError","path":"Channel/ClosedError.html","kind":"class","full_name":"Channel::ClosedError","name":"ClosedError","abstract":false,"superclass":{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},"ancestors":[{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/channel.cr","line_number":33,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"namespace":{"html_id":"Crystal/Channel","kind":"class","full_name":"Channel(T)","name":"Channel"},"constructors":[{"html_id":"new(msg=\"Channelisclosed\")-class-method","name":"new","abstract":false,"args":[{"name":"msg","default_value":"\"Channel is closed\"","external_name":"msg","restriction":""}],"args_string":"(msg = \"Channel is closed\")","args_html":"(msg = <span class=\"s\">&quot;Channel is closed&quot;</span>)","location":{"filename":"src/channel.cr","line_number":34,"url":null},"def":{"name":"new","args":[{"name":"msg","default_value":"\"Channel is closed\"","external_name":"msg","restriction":""}],"visibility":"Public","body":"_ = allocate\n_.initialize(msg)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false}]}]},{"html_id":"Crystal/Char","path":"Char.html","kind":"struct","full_name":"Char","name":"Char","abstract":false,"superclass":{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},"ancestors":[{"html_id":"Crystal/Steppable","kind":"module","full_name":"Steppable","name":"Steppable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/char.cr","line_number":43,"url":null},{"filename":"src/char/reader.cr","line_number":1,"url":null},{"filename":"src/primitives.cr","line_number":173,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"constants":[{"id":"MAX","name":"MAX","value":"1114111.unsafe_chr","doc":"The maximum character.","summary":"<p>The maximum character.</p>"},{"id":"MAX_CODEPOINT","name":"MAX_CODEPOINT","value":"1114111","doc":"The maximum valid codepoint for a character.","summary":"<p>The maximum valid codepoint for a character.</p>"},{"id":"REPLACEMENT","name":"REPLACEMENT","value":"'�'","doc":"The replacement character, used on invalid UTF-8 byte sequences.","summary":"<p>The replacement character, used on invalid UTF-8 byte sequences.</p>"},{"id":"ZERO","name":"ZERO","value":"'\\0'","doc":"The character representing the end of a C string.","summary":"<p>The character representing the end of a C string.</p>"}],"included_modules":[{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Steppable","kind":"module","full_name":"Steppable","name":"Steppable"}],"doc":"A `Char` represents a [Unicode](http://en.wikipedia.org/wiki/Unicode) [code point](http://en.wikipedia.org/wiki/Code_point).\nIt occupies 32 bits.\n\nIt is created by enclosing an UTF-8 character in single quotes.\n\n```\n'a'\n'z'\n'0'\n'_'\n'あ'\n```\n\nYou can use a backslash to denote some characters:\n\n```\n'\\'' # single quote\n'\\\\' # backslash\n'\\e' # escape\n'\\f' # form feed\n'\\n' # newline\n'\\r' # carriage return\n'\\t' # tab\n'\\v' # vertical tab\n```\n\nYou can use a backslash followed by an *u* and four hexadecimal characters to denote a unicode codepoint written:\n\n```\n'\\u0041' # == 'A'\n```\n\nOr you can use curly braces and specify up to four hexadecimal numbers:\n\n```\n'\\u{41}' # == 'A'\n```\n\nSee [`Char` literals](https://crystal-lang.org/reference/syntax_and_semantics/literals/char.html) in the language reference.","summary":"<p>A <code><a href=\"Char.html\">Char</a></code> represents a <a href=\"http://en.wikipedia.org/wiki/Unicode\">Unicode</a> <a href=\"http://en.wikipedia.org/wiki/Code_point\">code point</a>.</p>","instance_methods":[{"html_id":"!=(other:Char):Bool-instance-method","name":"!=","doc":"Returns `true` if `self`'s codepoint is not equal to *other*'s codepoint.","summary":"<p>Returns <code>true</code> if <code>self</code>'s codepoint is not equal to <em>other</em>'s codepoint.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Char"}],"args_string":"(other : Char) : Bool","args_html":"(other : <a href=\"Char.html\">Char</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/primitives.cr","line_number":193,"url":null},"def":{"name":"!=","args":[{"name":"other","external_name":"other","restriction":"Char"}],"return_type":"Bool","visibility":"Public","body":"# primitive: binary"},"external_var":false},{"html_id":"+(str:String):String-instance-method","name":"+","doc":"Concatenates this char and *string*.\n\n```\n'f' + \"oo\" # => \"foo\"\n```","summary":"<p>Concatenates this char and <em>string</em>.</p>","abstract":false,"args":[{"name":"str","external_name":"str","restriction":"String"}],"args_string":"(str : String) : String","args_html":"(str : <a href=\"String.html\">String</a>) : <a href=\"String.html\">String</a>","location":{"filename":"src/char.cr","line_number":75,"url":null},"def":{"name":"+","args":[{"name":"str","external_name":"str","restriction":"String"}],"return_type":"String","visibility":"Public","body":"bytesize = str.bytesize + self.bytesize\nString.new(bytesize) do |buffer|\n  count = 0\n  each_byte do |byte|\n    buffer[count] = byte\n    count = count + 1\n  end\n\n  (buffer + count).copy_from(str.to_unsafe, str.bytesize)\n\n  {bytesize, str.size + 1}\nend\n"},"external_var":false},{"html_id":"+(other:Int):Char-instance-method","name":"+","doc":"Returns a char that has this char's codepoint plus *other*.\n\n```\n'a' + 1 # => 'b'\n'a' + 2 # => 'c'\n```","summary":"<p>Returns a char that has this char's codepoint plus <em>other</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : Char","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"Char.html\">Char</a>","location":{"filename":"src/char.cr","line_number":96,"url":null},"def":{"name":"+","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"Char","visibility":"Public","body":"(ord + other).chr"},"external_var":false},{"html_id":"-(other:Char):Int32-instance-method","name":"-","doc":"Returns the difference of the codepoint values of this char and *other*.\n\n```\n'a' - 'a' # => 0\n'b' - 'a' # => 1\n'c' - 'a' # => 2\n```","summary":"<p>Returns the difference of the codepoint values of this char and <em>other</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Char"}],"args_string":"(other : Char) : Int32","args_html":"(other : <a href=\"Char.html\">Char</a>) : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/char.cr","line_number":66,"url":null},"def":{"name":"-","args":[{"name":"other","external_name":"other","restriction":"Char"}],"return_type":"Int32","visibility":"Public","body":"ord - other.ord"},"external_var":false},{"html_id":"-(other:Int):Char-instance-method","name":"-","doc":"Returns a char that has this char's codepoint minus *other*.\n\n```\n'c' - 1 # => 'b'\n'c' - 2 # => 'a'\n```","summary":"<p>Returns a char that has this char's codepoint minus <em>other</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : Char","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"Char.html\">Char</a>","location":{"filename":"src/char.cr","line_number":106,"url":null},"def":{"name":"-","args":[{"name":"other","external_name":"other","restriction":"Int"}],"return_type":"Char","visibility":"Public","body":"(ord - other).chr"},"external_var":false},{"html_id":"<(other:Char):Bool-instance-method","name":"<","doc":"Returns `true` if `self`'s codepoint is less than *other*'s codepoint.","summary":"<p>Returns <code>true</code> if <code>self</code>'s codepoint is less than <em>other</em>'s codepoint.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Char"}],"args_string":"(other : Char) : Bool","args_html":"(other : <a href=\"Char.html\">Char</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/primitives.cr","line_number":193,"url":null},"def":{"name":"<","args":[{"name":"other","external_name":"other","restriction":"Char"}],"return_type":"Bool","visibility":"Public","body":"# primitive: binary"},"external_var":false},{"html_id":"<=(other:Char):Bool-instance-method","name":"<=","doc":"Returns `true` if `self`'s codepoint is less than or equal to *other*'s codepoint.","summary":"<p>Returns <code>true</code> if <code>self</code>'s codepoint is less than or equal to <em>other</em>'s codepoint.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Char"}],"args_string":"(other : Char) : Bool","args_html":"(other : <a href=\"Char.html\">Char</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/primitives.cr","line_number":193,"url":null},"def":{"name":"<=","args":[{"name":"other","external_name":"other","restriction":"Char"}],"return_type":"Bool","visibility":"Public","body":"# primitive: binary"},"external_var":false},{"html_id":"<=>(other:Char)-instance-method","name":"<=>","doc":"The comparison operator.\n\nReturns the difference of the codepoint values of `self` and *other*.\nThe result is either negative, `0` or positive based on whether `other`'s codepoint is\nless, equal, or greater than `self`'s codepoint.\n\n```\n'a' <=> 'c' # => -2\n'z' <=> 'z' # => 0\n'c' <=> 'a' # => 2\n```","summary":"<p>The comparison operator.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Char"}],"args_string":"(other : Char)","args_html":"(other : <a href=\"Char.html\">Char</a>)","location":{"filename":"src/char.cr","line_number":121,"url":null},"def":{"name":"<=>","args":[{"name":"other","external_name":"other","restriction":"Char"}],"visibility":"Public","body":"self - other"},"external_var":false},{"html_id":"==(other:Char):Bool-instance-method","name":"==","doc":"Returns `true` if `self`'s codepoint is equal to *other*'s codepoint.","summary":"<p>Returns <code>true</code> if <code>self</code>'s codepoint is equal to <em>other</em>'s codepoint.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Char"}],"args_string":"(other : Char) : Bool","args_html":"(other : <a href=\"Char.html\">Char</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/primitives.cr","line_number":193,"url":null},"def":{"name":"==","args":[{"name":"other","external_name":"other","restriction":"Char"}],"return_type":"Bool","visibility":"Public","body":"# primitive: binary"},"external_var":false},{"html_id":"===(byte:Int)-instance-method","name":"===","doc":"Returns `true` if the codepoint is equal to *byte* ignoring the type.\n\n```\n'c'.ord       # => 99\n'c' === 99_u8 # => true\n'c' === 99    # => true\n'z' === 99    # => false\n```","summary":"<p>Returns <code>true</code> if the codepoint is equal to <em>byte</em> ignoring the type.</p>","abstract":false,"args":[{"name":"byte","external_name":"byte","restriction":"Int"}],"args_string":"(byte : Int)","args_html":"(byte : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/char.cr","line_number":1053,"url":null},"def":{"name":"===","args":[{"name":"byte","external_name":"byte","restriction":"Int"}],"visibility":"Public","body":"ord === byte"},"external_var":false},{"html_id":">(other:Char):Bool-instance-method","name":">","doc":"Returns `true` if `self`'s codepoint is greater than *other*'s codepoint.","summary":"<p>Returns <code>true</code> if <code>self</code>'s codepoint is greater than <em>other</em>'s codepoint.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Char"}],"args_string":"(other : Char) : Bool","args_html":"(other : <a href=\"Char.html\">Char</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/primitives.cr","line_number":193,"url":null},"def":{"name":">","args":[{"name":"other","external_name":"other","restriction":"Char"}],"return_type":"Bool","visibility":"Public","body":"# primitive: binary"},"external_var":false},{"html_id":">=(other:Char):Bool-instance-method","name":">=","doc":"Returns `true` if `self`'s codepoint is greater than or equal to *other*'s codepoint.","summary":"<p>Returns <code>true</code> if <code>self</code>'s codepoint is greater than or equal to <em>other</em>'s codepoint.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Char"}],"args_string":"(other : Char) : Bool","args_html":"(other : <a href=\"Char.html\">Char</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/primitives.cr","line_number":193,"url":null},"def":{"name":">=","args":[{"name":"other","external_name":"other","restriction":"Char"}],"return_type":"Bool","visibility":"Public","body":"# primitive: binary"},"external_var":false},{"html_id":"alphanumeric?:Bool-instance-method","name":"alphanumeric?","doc":"Returns `true` if this char is a letter or a number according to unicode.\n\n```\n'c'.alphanumeric? # => true\n'8'.alphanumeric? # => true\n'.'.alphanumeric? # => false\n```","summary":"<p>Returns <code>true</code> if this char is a letter or a number according to unicode.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":286,"url":null},"def":{"name":"alphanumeric?","return_type":"Bool","visibility":"Public","body":"letter? || number?"},"external_var":false},{"html_id":"ascii?:Bool-instance-method","name":"ascii?","doc":"Returns `true` if this char is an ASCII character\n(codepoint is in (0..127))","summary":"<p>Returns <code>true</code> if this char is an ASCII character (codepoint is in (0..127))</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":154,"url":null},"def":{"name":"ascii?","return_type":"Bool","visibility":"Public","body":"ord < 128"},"external_var":false},{"html_id":"ascii_alphanumeric?:Bool-instance-method","name":"ascii_alphanumeric?","doc":"Returns `true` if this char is an ASCII letter or number ('0' to '9', 'a' to 'z', 'A' to 'Z').\n\n```\n'c'.ascii_alphanumeric? # => true\n'8'.ascii_alphanumeric? # => true\n'.'.ascii_alphanumeric? # => false\n```","summary":"<p>Returns <code>true</code> if this char is an ASCII letter or number ('0' to '9', 'a' to 'z', 'A' to 'Z').</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":275,"url":null},"def":{"name":"ascii_alphanumeric?","return_type":"Bool","visibility":"Public","body":"ascii_letter? || ascii_number?"},"external_var":false},{"html_id":"ascii_control?:Bool-instance-method","name":"ascii_control?","doc":"Returns `true` if this char is an ASCII control character.\n\nThis includes the *C0 control codes* (`U+0000` through `U+001F`) and the\n*Delete* character (`U+007F`).\n\n```\n('\\u0000'..'\\u0019').each do |char|\n  char.control? # => true\nend\n\n('\\u007F'..'\\u009F').each do |char|\n  char.control? # => true\nend\n```","summary":"<p>Returns <code>true</code> if this char is an ASCII control character.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":662,"url":null},"def":{"name":"ascii_control?","return_type":"Bool","visibility":"Public","body":"ord < 32 || (ord == 127)"},"external_var":false},{"html_id":"ascii_letter?:Bool-instance-method","name":"ascii_letter?","doc":"Returns `true` if this char is an ASCII letter ('a' to 'z', 'A' to 'Z').\n\n```\n'c'.ascii_letter? # => true\n'á'.ascii_letter? # => false\n'8'.ascii_letter? # => false\n```","summary":"<p>Returns <code>true</code> if this char is an ASCII letter ('a' to 'z', 'A' to 'Z').</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":250,"url":null},"def":{"name":"ascii_letter?","return_type":"Bool","visibility":"Public","body":"ascii_lowercase? || ascii_uppercase?"},"external_var":false},{"html_id":"ascii_lowercase?:Bool-instance-method","name":"ascii_lowercase?","doc":"Returns `true` if this char is a lowercase ASCII letter.\n\n```\n'c'.ascii_lowercase? # => true\n'ç'.lowercase?       # => true\n'G'.ascii_lowercase? # => false\n'.'.ascii_lowercase? # => false\n```","summary":"<p>Returns <code>true</code> if this char is a lowercase ASCII letter.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":189,"url":null},"def":{"name":"ascii_lowercase?","return_type":"Bool","visibility":"Public","body":"'a' <= self && self <= 'z'"},"external_var":false},{"html_id":"ascii_number?(base:Int=10):Bool-instance-method","name":"ascii_number?","doc":"Returns `true` if this char is an ASCII number in specified base.\n\nBase can be from 2 to 36 with digits from '0' to '9' and 'a' to 'z' or 'A' to 'Z'.\n\n```\n'4'.ascii_number?     # => true\n'z'.ascii_number?     # => false\n'z'.ascii_number?(36) # => true\n```","summary":"<p>Returns <code>true</code> if this char is an ASCII number in specified base.</p>","abstract":false,"args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = 10) : Bool","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/char.cr","line_number":167,"url":null},"def":{"name":"ascii_number?","args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"return_type":"Bool","visibility":"Public","body":"!(!(to_i?(base)))"},"external_var":false},{"html_id":"ascii_uppercase?:Bool-instance-method","name":"ascii_uppercase?","doc":"Returns `true` if this char is an ASCII uppercase letter.\n\n```\n'H'.ascii_uppercase? # => true\n'Á'.ascii_uppercase? # => false\n'c'.ascii_uppercase? # => false\n'.'.ascii_uppercase? # => false\n```","summary":"<p>Returns <code>true</code> if this char is an ASCII uppercase letter.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":214,"url":null},"def":{"name":"ascii_uppercase?","return_type":"Bool","visibility":"Public","body":"'A' <= self && self <= 'Z'"},"external_var":false},{"html_id":"ascii_whitespace?:Bool-instance-method","name":"ascii_whitespace?","doc":"Returns `true` if this char is an ASCII whitespace.\n\n```\n' '.ascii_whitespace?  # => true\n'\\t'.ascii_whitespace? # => true\n'b'.ascii_whitespace?  # => false\n```","summary":"<p>Returns <code>true</code> if this char is an ASCII whitespace.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":297,"url":null},"def":{"name":"ascii_whitespace?","return_type":"Bool","visibility":"Public","body":"(self == ' ') || (9 <= (__temp_41 = ord) && __temp_41 <= 13)"},"external_var":false},{"html_id":"bytes:Array(UInt8)-instance-method","name":"bytes","doc":"Returns this char bytes as encoded by UTF-8, as an `Array(UInt8)`.\n\n```\n'a'.bytes # => [97]\n'あ'.bytes # => [227, 129, 130]\n```","summary":"<p>Returns this char bytes as encoded by UTF-8, as an <code><a href=\"Array.html\">Array</a>(<a href=\"UInt8.html\">UInt8</a>)</code>.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":998,"url":null},"def":{"name":"bytes","return_type":"Array(UInt8)","visibility":"Public","body":"bytes = [] of UInt8\neach_byte do |byte|\n  bytes << byte\nend\nbytes\n"},"external_var":false},{"html_id":"bytesize:Int32-instance-method","name":"bytesize","doc":"Returns the number of UTF-8 bytes in this char.\n\n```\n'a'.bytesize # => 1\n'好'.bytesize # => 3\n```","summary":"<p>Returns the number of UTF-8 bytes in this char.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":973,"url":null},"def":{"name":"bytesize","return_type":"Int32","visibility":"Public","body":"c = ord\nif c < 128\n  1\nelsif c <= 2047\n  2\nelsif c <= 65535\n  3\nelse\n  4\nend\n"},"external_var":false},{"html_id":"clone-instance-method","name":"clone","abstract":false,"location":{"filename":"src/char.cr","line_number":1057,"url":null},"def":{"name":"clone","visibility":"Public","body":"self"},"external_var":false},{"html_id":"control?:Bool-instance-method","name":"control?","doc":"Returns `true` if this char is a control character according to unicode.","summary":"<p>Returns <code>true</code> if this char is a control character according to unicode.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":667,"url":null},"def":{"name":"control?","return_type":"Bool","visibility":"Public","body":"ascii? ? ascii_control? : Unicode.control?(self)"},"external_var":false},{"html_id":"downcase(io:IO,options:Unicode::CaseOptions=:none):Nil-instance-method","name":"downcase","doc":"Writes the downcase equivalent of this char to the given *io*.\n\nThis method takes into account the possibility that an downcase\nversion of a char might result in multiple chars, like for\n'İ', which results in 'i' and a dot mark.\n\n```\n'Z'.downcase(STDOUT)                             # prints \"z\"\n'ς'.downcase(STDOUT, Unicode::CaseOptions::Fold) # prints \"σ\"\n'ẞ'.downcase(STDOUT, Unicode::CaseOptions::Fold) # prints \"ss\"\n'ᾈ'.downcase(STDOUT, Unicode::CaseOptions::Fold) # prints \"ἀι\"\n```","summary":"<p>Writes the downcase equivalent of this char to the given <em>io</em>.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"options","default_value":":none","external_name":"options","restriction":"Unicode::CaseOptions"}],"args_string":"(io : IO, options : Unicode::CaseOptions = :none) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>, options : <a href=\"Unicode/CaseOptions.html\">Unicode::CaseOptions</a> = <span class=\"n\">:none</span>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/char.cr","line_number":471,"url":null},"def":{"name":"downcase","args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"options","default_value":":none","external_name":"options","restriction":"Unicode::CaseOptions"}],"return_type":"Nil","visibility":"Public","body":"downcase(options) do |char| io << char end"},"external_var":false},{"html_id":"downcase(options:Unicode::CaseOptions=:none):Char-instance-method","name":"downcase","doc":"Returns the downcase equivalent of this char.\n\nNote that this only works for characters whose downcase\nequivalent yields a single codepoint. There are a few\ncharacters, like 'İ', than when downcased result in multiple\ncharacters (in this case: 'I' and the dot mark).\n\nFor more correct behavior see the overloads that receive a block or an `IO`.\n\n```\n'Z'.downcase # => 'z'\n'x'.downcase # => 'x'\n'.'.downcase # => '.'\n```\n\nIf `options.fold?` is true, then returns the case-folded equivalent instead.\nNote that this will return `self` if a multiple-character case folding\nexists, even if a separate single-character transformation is also defined\nin Unicode.\n\n```\n'Z'.downcase(Unicode::CaseOptions::Fold) # => 'z'\n'x'.downcase(Unicode::CaseOptions::Fold) # => 'x'\n'ς'.downcase(Unicode::CaseOptions::Fold) # => 'σ'\n'ꭰ'.downcase(Unicode::CaseOptions::Fold) # => 'Ꭰ'\n'ẞ'.downcase(Unicode::CaseOptions::Fold) # => 'ẞ' # not U+00DF 'ß'\n'ᾈ'.downcase(Unicode::CaseOptions::Fold) # => \"ᾈ\" # not U+1F80 'ᾀ'\n```","summary":"<p>Returns the downcase equivalent of this char.</p>","abstract":false,"args":[{"name":"options","default_value":":none","external_name":"options","restriction":"Unicode::CaseOptions"}],"args_string":"(options : Unicode::CaseOptions = :none) : Char","args_html":"(options : <a href=\"Unicode/CaseOptions.html\">Unicode::CaseOptions</a> = <span class=\"n\">:none</span>) : <a href=\"Char.html\">Char</a>","location":{"filename":"src/char.cr","line_number":431,"url":null},"def":{"name":"downcase","args":[{"name":"options","default_value":":none","external_name":"options","restriction":"Unicode::CaseOptions"}],"return_type":"Char","visibility":"Public","body":"if options.fold?\n  Unicode.foldcase(self, options)\nelse\n  Unicode.downcase(self, options)\nend"},"external_var":false},{"html_id":"downcase(options:Unicode::CaseOptions=:none,&)-instance-method","name":"downcase","doc":"Yields each char for the downcase equivalent of this char.\n\nThis method takes into account the possibility that an downcase\nversion of a char might result in multiple chars, like for\n'İ', which results in 'i' and a dot mark.\n\n```\n'Z'.downcase { |v| puts v }                             # prints 'z'\n'ς'.downcase(Unicode::CaseOptions::Fold) { |v| puts v } # prints 'σ'\n'ẞ'.downcase(Unicode::CaseOptions::Fold) { |v| puts v } # prints 's', 's'\n'ᾈ'.downcase(Unicode::CaseOptions::Fold) { |v| puts v } # prints 'ἀ', 'ι'\n```","summary":"<p>Yields each char for the downcase equivalent of this char.</p>","abstract":false,"args":[{"name":"options","default_value":":none","external_name":"options","restriction":"Unicode::CaseOptions"}],"args_string":"(options : Unicode::CaseOptions = :none, &)","args_html":"(options : <a href=\"Unicode/CaseOptions.html\">Unicode::CaseOptions</a> = <span class=\"n\">:none</span>, &)","location":{"filename":"src/char.cr","line_number":451,"url":null},"def":{"name":"downcase","args":[{"name":"options","default_value":":none","external_name":"options","restriction":"Unicode::CaseOptions"}],"yields":1,"block_arity":1,"visibility":"Public","body":"if options.fold?\n  Unicode.foldcase(self, options) do |char| yield char end\nelse\n  Unicode.downcase(self, options) do |char| yield char end\nend"},"external_var":false},{"html_id":"dump(io)-instance-method","name":"dump","doc":"Returns a representation of `self` as an ASCII-compatible Crystal char literal,\nwrapped in single quotes.\n\nNon-printable characters (see `#printable?`) and non-ASCII characters\n(codepoints larger `U+007F`) are escaped.\n\n```\n'a'.dump      # => \"'a'\"\n'\\t'.dump     # => \"'\\\\t'\"\n'あ'.dump      # => \"'\\\\u3042'\"\n'\\u0012'.dump # => \"'\\\\u0012'\"\n'😀'.dump      # => \"'\\\\u{1F600}'\"\n```\n\nSee `#unicode_escape` for the format used to escape characters without a\nspecial escape sequence.\n\n* `#inspect` only escapes non-printable characters.","summary":"<p>Returns a representation of <code>self</code> as an ASCII-compatible Crystal char literal, wrapped in single quotes.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":""}],"args_string":"(io)","args_html":"(io)","location":{"filename":"src/char.cr","line_number":749,"url":null},"def":{"name":"dump","args":[{"name":"io","external_name":"io","restriction":""}],"visibility":"Public","body":"io << dump"},"external_var":false},{"html_id":"dump:String-instance-method","name":"dump","doc":"Returns a representation of `self` as an ASCII-compatible Crystal char literal,\nwrapped in single quotes.\n\nNon-printable characters (see `#printable?`) and non-ASCII characters\n(codepoints larger `U+007F`) are escaped.\n\n```\n'a'.dump      # => \"'a'\"\n'\\t'.dump     # => \"'\\\\t'\"\n'あ'.dump      # => \"'\\\\u3042'\"\n'\\u0012'.dump # => \"'\\\\u0012'\"\n'😀'.dump      # => \"'\\\\u{1F600}'\"\n```\n\nSee `#unicode_escape` for the format used to escape characters without a\nspecial escape sequence.\n\n* `#inspect` only escapes non-printable characters.","summary":"<p>Returns a representation of <code>self</code> as an ASCII-compatible Crystal char literal, wrapped in single quotes.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":738,"url":null},"def":{"name":"dump","return_type":"String","visibility":"Public","body":"dump_or_inspect do |io|\n  if ascii_control? || ord >= 128\n    unicode_escape(io)\n  else\n    to_s(io)\n  end\nend"},"external_var":false},{"html_id":"each_byte(&):Nil-instance-method","name":"each_byte","doc":"Yields each of the bytes of this char as encoded by UTF-8.\n\n```\nputs \"'a'\"\n'a'.each_byte do |byte|\n  puts byte\nend\nputs\n\nputs \"'あ'\"\n'あ'.each_byte do |byte|\n  puts byte\nend\n```\n\nOutput:\n\n```text\n'a'\n97\n\n'あ'\n227\n129\n130\n```","summary":"<p>Yields each of the bytes of this char as encoded by UTF-8.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":942,"url":null},"def":{"name":"each_byte","yields":1,"block_arity":1,"return_type":"Nil","visibility":"Public","body":"c = ord\nif c < 128\n  yield c.to_u8\nelsif c <= 2047\n  yield (192 | (c >> 6)).to_u8\n  yield (128 | (c & 63)).to_u8\nelsif c <= 65535\n  yield (224 | (c >> 12)).to_u8\n  yield (128 | ((c >> 6) & 63)).to_u8\n  yield (128 | (c & 63)).to_u8\nelse\n  yield (240 | (c >> 18)).to_u8\n  yield (128 | ((c >> 12) & 63)).to_u8\n  yield (128 | ((c >> 6) & 63)).to_u8\n  yield (128 | (c & 63)).to_u8\nend\n"},"external_var":false},{"html_id":"hash(hasher)-instance-method","name":"hash","doc":"See `Object#hash(hasher)`","summary":"<p>See <code><a href=\"Object.html#hash%28hasher%29-instance-method\">Object#hash(hasher)</a></code></p>","abstract":false,"args":[{"name":"hasher","external_name":"hasher","restriction":""}],"args_string":"(hasher)","args_html":"(hasher)","location":{"filename":"src/char.cr","line_number":584,"url":null},"def":{"name":"hash","args":[{"name":"hasher","external_name":"hasher","restriction":""}],"visibility":"Public","body":"hasher.char(self)"},"external_var":false},{"html_id":"hex?:Bool-instance-method","name":"hex?","doc":"Returns `true` if this char is an ASCII hex digit ('0' to '9', 'a' to 'f', 'A' to 'F').\n\n```\n'5'.hex? # => true\n'a'.hex? # => true\n'F'.hex? # => true\n'g'.hex? # => false\n```","summary":"<p>Returns <code>true</code> if this char is an ASCII hex digit ('0' to '9', 'a' to 'f', 'A' to 'F').</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":320,"url":null},"def":{"name":"hex?","return_type":"Bool","visibility":"Public","body":"ascii_number?(16)"},"external_var":false},{"html_id":"in_set?(*sets:String):Bool-instance-method","name":"in_set?","doc":"Returns `true` if this char is matched by the given *sets*.\n\nEach parameter defines a set, the character is matched against\nthe intersection of those, in other words it needs to\nmatch all sets.\n\nIf a set starts with a ^, it is negated. The sequence c1-c2\nmeans all characters between and including c1 and c2\nand is known as a range.\n\nThe backslash character \\ can be used to escape ^ or - and\nis otherwise ignored unless it appears at the end of a range\nor set.\n\n```\n'l'.in_set? \"lo\"          # => true\n'l'.in_set? \"lo\", \"o\"     # => false\n'l'.in_set? \"hello\", \"^l\" # => false\n'l'.in_set? \"j-m\"         # => true\n\n'^'.in_set? \"\\\\^aeiou\" # => true\n'-'.in_set? \"a\\\\-eo\"   # => true\n\n'\\\\'.in_set? \"\\\\\"    # => true\n'\\\\'.in_set? \"\\\\A\"   # => false\n'\\\\'.in_set? \"X-\\\\w\" # => true\n```","summary":"<p>Returns <code>true</code> if this char is matched by the given <em>sets</em>.</p>","abstract":false,"args":[{"name":"sets","external_name":"sets","restriction":"String"}],"args_string":"(*sets : String) : Bool","args_html":"(*sets : <a href=\"String.html\">String</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/char.cr","line_number":351,"url":null},"def":{"name":"in_set?","args":[{"name":"sets","external_name":"sets","restriction":"String"}],"splat_index":0,"return_type":"Bool","visibility":"Public","body":"if sets.size > 1\n  return sets.all? do |set| in_set?(set) end\nend\n\nset = sets.first\nnot_negated = true\nrange = false\nprevious = nil\n\nset.each_char do |char|\n  case char\n  when '^'\n    if previous\n    else\n      not_negated = false\n      previous = char\n      next\n    end\n  when '-'\n    if previous && (previous != '\\\\')\n      range = true\n\n      if previous == '^'\n        previous = '^'\n        not_negated = true\n      end\n\n      next\n    elsif self == char\n      return not_negated\n    end\n  end\n\n  if range && previous\n    if previous > char\n      raise(ArgumentError.new(\"Invalid range #{previous}-#{char}\"))\n    end\n\n    if previous <= self && self <= char\n      return not_negated\n    end\n\n    range = false\n  elsif char != '\\\\'\n    if self == char\n      return not_negated\n    end\n  end\n\n  previous = char\nend\n\nif range && (self == '-')\n  return not_negated\nend\nif (previous == '\\\\') && (self == previous)\n  return not_negated\nend\n\n!not_negated\n"},"external_var":false},{"html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Returns a representation of `self` as a Crystal char literal, wrapped in single\nquotes.\n\nNon-printable characters (see `#printable?`) are escaped.\n\n```\n'a'.inspect      # => \"'a'\"\n'\\t'.inspect     # => \"'\\\\t'\"\n'あ'.inspect      # => \"'あ'\"\n'\\u0012'.inspect # => \"'\\\\u0012'\"\n'😀'.inspect      # => \"'\\u{1F600}'\"\n```\n\nSee `#unicode_escape` for the format used to escape characters without a\nspecial escape sequence.\n\n* `#dump` additionally escapes all non-ASCII characters.","summary":"<p>Returns a representation of <code>self</code> as a Crystal char literal, wrapped in single quotes.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/char.cr","line_number":716,"url":null},"def":{"name":"inspect","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"io << inspect"},"external_var":false},{"html_id":"inspect:String-instance-method","name":"inspect","doc":"Returns a representation of `self` as a Crystal char literal, wrapped in single\nquotes.\n\nNon-printable characters (see `#printable?`) are escaped.\n\n```\n'a'.inspect      # => \"'a'\"\n'\\t'.inspect     # => \"'\\\\t'\"\n'あ'.inspect      # => \"'あ'\"\n'\\u0012'.inspect # => \"'\\\\u0012'\"\n'😀'.inspect      # => \"'\\u{1F600}'\"\n```\n\nSee `#unicode_escape` for the format used to escape characters without a\nspecial escape sequence.\n\n* `#dump` additionally escapes all non-ASCII characters.","summary":"<p>Returns a representation of <code>self</code> as a Crystal char literal, wrapped in single quotes.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":705,"url":null},"def":{"name":"inspect","return_type":"String","visibility":"Public","body":"dump_or_inspect do |io|\n  if printable?\n    to_s(io)\n  else\n    unicode_escape(io)\n  end\nend"},"external_var":false},{"html_id":"letter?:Bool-instance-method","name":"letter?","doc":"Returns `true` if this char is a letter.\n\nAll codepoints in the Unicode General Category `L` (Letter) are considered\na letter.\n\n```\n'c'.letter? # => true\n'á'.letter? # => true\n'8'.letter? # => false\n```","summary":"<p>Returns <code>true</code> if this char is a letter.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":264,"url":null},"def":{"name":"letter?","return_type":"Bool","visibility":"Public","body":"ascii? ? ascii_letter? : Unicode.letter?(self)"},"external_var":false},{"html_id":"lowercase?:Bool-instance-method","name":"lowercase?","doc":"Returns `true` if this char is a lowercase letter.\n\n```\n'c'.lowercase? # => true\n'ç'.lowercase? # => true\n'G'.lowercase? # => false\n'.'.lowercase? # => false\n'ǲ'.lowercase? # => false\n```","summary":"<p>Returns <code>true</code> if this char is a lowercase letter.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":202,"url":null},"def":{"name":"lowercase?","return_type":"Bool","visibility":"Public","body":"ascii? ? ascii_lowercase? : Unicode.lowercase?(self)"},"external_var":false},{"html_id":"mark?:Bool-instance-method","name":"mark?","doc":"Returns `true` if this char is a mark character according to unicode.","summary":"<p>Returns <code>true</code> if this char is a mark character according to unicode.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":672,"url":null},"def":{"name":"mark?","return_type":"Bool","visibility":"Public","body":"Unicode.mark?(self)"},"external_var":false},{"html_id":"number?:Bool-instance-method","name":"number?","doc":"Returns `true` if this char is a number according to unicode.\n\n```\n'1'.number? # => true\n'a'.number? # => false\n```","summary":"<p>Returns <code>true</code> if this char is a number according to unicode.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":177,"url":null},"def":{"name":"number?","return_type":"Bool","visibility":"Public","body":"ascii? ? ascii_number? : Unicode.number?(self)"},"external_var":false},{"html_id":"ord:Int32-instance-method","name":"ord","doc":"Returns the codepoint of this char.\n\nThe codepoint is the integer representation.\nThe Universal Coded Character Set (UCS) standard, commonly known as Unicode,\nassigns names and meanings to numbers, these numbers are called codepoints.\n\nFor values below and including 127 this matches the ASCII codes\nand thus its byte representation.\n\n```\n'a'.ord      # => 97\n'\\0'.ord     # => 0\n'\\u007f'.ord # => 127\n'☃'.ord      # => 9731\n```","summary":"<p>Returns the codepoint of this char.</p>","abstract":false,"location":{"filename":"src/primitives.cr","line_number":190,"url":null},"def":{"name":"ord","return_type":"Int32","visibility":"Public","body":"# primitive: convert"},"external_var":false},{"html_id":"pred:Char-instance-method","name":"pred","doc":"Returns the predecessor codepoint before this one.\n\nThis can be used for iterating a range of characters (see `Range#each`).\n\n```\n'b'.pred # => 'a'\n'ぃ'.pred # => 'あ'\n```\n\nThis does not always return `codepoint - 1`. There is a gap in the\nrange of Unicode scalars: The surrogate codepoints `U+D800` through `U+DFFF`.\n\n```\n'\\uE000'.pred # => '\\uD7FF'\n```\n\nRaises `OverflowError` for `Char::ZERO`.\n\n* `#succ` returns the successor codepoint.","summary":"<p>Returns the predecessor codepoint before this one.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":637,"url":null},"def":{"name":"pred","return_type":"Char","visibility":"Public","body":"case self\nwhen '\\uE000'\n  '퟿'\nwhen ZERO\n  raise(OverflowError.new(\"Out of Char range\"))\nelse\n  (ord - 1).unsafe_chr\nend"},"external_var":false},{"html_id":"printable?-instance-method","name":"printable?","doc":"Returns `true` if this char is a printable character.\n\nThere is no universal definition of printable characters in Unicode.\nFor the purpose of this method, all characters with a visible glyph and the\nASCII whitespace (` `) are considered printable.\n\nThis means characters which are `control?` or `whitespace?` (except for ` `)\nare non-printable.","summary":"<p>Returns <code>true</code> if this char is a printable character.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":684,"url":null},"def":{"name":"printable?","visibility":"Public","body":"(!control?) && ((!whitespace?) || (self == ' '))"},"external_var":false},{"html_id":"step(*,tolimit=nil,exclusive:Bool=false,&)-instance-method","name":"step","doc":"Performs a `#step` in the direction of the _limit_. For instance:\n\n```\n'd'.step(to: 'a').to_a # => ['d', 'c', 'b', 'a']\n'a'.step(to: 'd').to_a # => ['a', 'b', 'c', 'd']\n```","summary":"<p>Performs a <code><a href=\"Char.html#step%28%2A%2Ctolimit%3Dnil%2Cexclusive%3ABool%3Dfalse%2C%26%29-instance-method\">#step</a></code> in the direction of the <em>limit</em>.</p>","abstract":false,"args":[{"name":"","external_name":"","restriction":""},{"name":"limit","default_value":"nil","external_name":"to","restriction":""},{"name":"exclusive","default_value":"false","external_name":"exclusive","restriction":"Bool"}],"args_string":"(*, to limit = nil, exclusive : Bool = false, &)","args_html":"(*, to limit = <span class=\"n\">nil</span>, exclusive : <a href=\"Bool.html\">Bool</a> = <span class=\"n\">false</span>, &)","location":{"filename":"src/char.cr","line_number":131,"url":null},"def":{"name":"step","args":[{"name":"","external_name":"","restriction":""},{"name":"limit","default_value":"nil","external_name":"to","restriction":""},{"name":"exclusive","default_value":"false","external_name":"exclusive","restriction":"Bool"}],"splat_index":0,"yields":1,"block_arity":1,"visibility":"Public","body":"if limit\n  direction = limit <=> self\nend\nstep = direction.try(&.sign) || 1\n\nstep(to: limit, by: step, exclusive: exclusive) do |x|\n  yield x\nend\n"},"external_var":false},{"html_id":"step(*,tolimit=nil,exclusive:Bool=false)-instance-method","name":"step","doc":"Performs a `#step` in the direction of the _limit_. For instance:\n\n```\n'd'.step(to: 'a').to_a # => ['d', 'c', 'b', 'a']\n'a'.step(to: 'd').to_a # => ['a', 'b', 'c', 'd']\n```","summary":"<p>Performs a <code><a href=\"Char.html#step%28%2A%2Ctolimit%3Dnil%2Cexclusive%3ABool%3Dfalse%2C%26%29-instance-method\">#step</a></code> in the direction of the <em>limit</em>.</p>","abstract":false,"args":[{"name":"","external_name":"","restriction":""},{"name":"limit","default_value":"nil","external_name":"to","restriction":""},{"name":"exclusive","default_value":"false","external_name":"exclusive","restriction":"Bool"}],"args_string":"(*, to limit = nil, exclusive : Bool = false)","args_html":"(*, to limit = <span class=\"n\">nil</span>, exclusive : <a href=\"Bool.html\">Bool</a> = <span class=\"n\">false</span>)","location":{"filename":"src/char.cr","line_number":143,"url":null},"def":{"name":"step","args":[{"name":"","external_name":"","restriction":""},{"name":"limit","default_value":"nil","external_name":"to","restriction":""},{"name":"exclusive","default_value":"false","external_name":"exclusive","restriction":"Bool"}],"splat_index":0,"visibility":"Public","body":"if limit\n  direction = limit <=> self\nend\nstep = direction.try(&.sign) || 1\n\nstep(to: limit, by: step, exclusive: exclusive)\n"},"external_var":false},{"html_id":"succ:Char-instance-method","name":"succ","doc":"Returns the successor codepoint after this one.\n\nThis can be used for iterating a range of characters (see `Range#each`).\n\n```\n'a'.succ # => 'b'\n'あ'.succ # => 'ぃ'\n```\n\nThis does not always return `codepoint + 1`. There is a gap in the\nrange of Unicode scalars: The surrogate codepoints `U+D800` through `U+DFFF`.\n\n```\n'\\uD7FF'.succ # => '\\uE000'\n```\n\nRaises `OverflowError` for `Char::MAX`.\n\n* `#pred` returns the predecessor codepoint.","summary":"<p>Returns the successor codepoint after this one.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":607,"url":null},"def":{"name":"succ","return_type":"Char","visibility":"Public","body":"case self\nwhen '퟿'\n  '\\uE000'\nwhen MAX\n  raise(OverflowError.new(\"Out of Char range\"))\nelse\n  (ord + 1).unsafe_chr\nend"},"external_var":false},{"html_id":"titlecase(io:IO,options:Unicode::CaseOptions=:none):Nil-instance-method","name":"titlecase","doc":"Writes the titlecase equivalent of this char to the given *io*.\n\nUsually this is equivalent to `#upcase`, but a few precomposed characters\nconsisting of multiple letters may yield a different character sequence\nwhere only the first letter is uppercase and the rest lowercase.\n\nThis method takes into account the possibility that a titlecase\nversion of a char might result in multiple chars, like for\n'ﬄ', which results in 'F', 'f' and 'l'.\n\n```\n'z'.titlecase(STDOUT) # prints \"Z\"\n'Ǳ'.titlecase(STDOUT) # prints \"ǲ\"\n'ﬄ'.titlecase(STDOUT) # prints \"Ffl\"\n```","summary":"<p>Writes the titlecase equivalent of this char to the given <em>io</em>.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"options","default_value":":none","external_name":"options","restriction":"Unicode::CaseOptions"}],"args_string":"(io : IO, options : Unicode::CaseOptions = :none) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>, options : <a href=\"Unicode/CaseOptions.html\">Unicode::CaseOptions</a> = <span class=\"n\">:none</span>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/char.cr","line_number":579,"url":null},"def":{"name":"titlecase","args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"options","default_value":":none","external_name":"options","restriction":"Unicode::CaseOptions"}],"return_type":"Nil","visibility":"Public","body":"titlecase(options) do |char| io << char end"},"external_var":false},{"html_id":"titlecase(options:Unicode::CaseOptions=:none):Char-instance-method","name":"titlecase","doc":"Returns the titlecase equivalent of this char.\n\nUsually this is equivalent to `#upcase`, but a few precomposed characters\nconsisting of multiple letters may return a different character where only\nthe first letter is uppercase and the rest lowercase.\n\nNote that this only works for characters whose titlecase\nequivalent yields a single codepoint. There are a few\ncharacters, like 'ﬄ', than when titlecased result in multiple\ncharacters (in this case: 'F', 'f', 'l').\n\nFor more correct behavior see the overloads that receive a block or an `IO`.\n\n```\n'z'.titlecase # => 'Z'\n'X'.titlecase # => 'X'\n'.'.titlecase # => '.'\n'Ǳ'.titlecase # => 'ǲ'\n'ǳ'.titlecase # => 'ǲ'\n```","summary":"<p>Returns the titlecase equivalent of this char.</p>","abstract":false,"args":[{"name":"options","default_value":":none","external_name":"options","restriction":"Unicode::CaseOptions"}],"args_string":"(options : Unicode::CaseOptions = :none) : Char","args_html":"(options : <a href=\"Unicode/CaseOptions.html\">Unicode::CaseOptions</a> = <span class=\"n\">:none</span>) : <a href=\"Char.html\">Char</a>","location":{"filename":"src/char.cr","line_number":541,"url":null},"def":{"name":"titlecase","args":[{"name":"options","default_value":":none","external_name":"options","restriction":"Unicode::CaseOptions"}],"return_type":"Char","visibility":"Public","body":"Unicode.titlecase(self, options)"},"external_var":false},{"html_id":"titlecase(options:Unicode::CaseOptions=:none,&)-instance-method","name":"titlecase","doc":"Yields each char for the titlecase equivalent of this char.\n\nUsually this is equivalent to `#upcase`, but a few precomposed characters\nconsisting of multiple letters may yield a different character sequence\nwhere only the first letter is uppercase and the rest lowercase.\n\nThis method takes into account the possibility that a titlecase\nversion of a char might result in multiple chars, like for\n'ﬄ', which results in 'F', 'f' and 'l'.\n\n```\n'z'.titlecase { |v| puts v } # prints 'Z'\n'Ǳ'.titlecase { |v| puts v } # prints 'ǲ'\n'ﬄ'.titlecase { |v| puts v } # prints 'F', 'f', 'l'\n```","summary":"<p>Yields each char for the titlecase equivalent of this char.</p>","abstract":false,"args":[{"name":"options","default_value":":none","external_name":"options","restriction":"Unicode::CaseOptions"}],"args_string":"(options : Unicode::CaseOptions = :none, &)","args_html":"(options : <a href=\"Unicode/CaseOptions.html\">Unicode::CaseOptions</a> = <span class=\"n\">:none</span>, &)","location":{"filename":"src/char.cr","line_number":560,"url":null},"def":{"name":"titlecase","args":[{"name":"options","default_value":":none","external_name":"options","restriction":"Unicode::CaseOptions"}],"yields":1,"block_arity":1,"visibility":"Public","body":"Unicode.titlecase(self, options) do |char| yield char end"},"external_var":false},{"html_id":"titlecase?:Bool-instance-method","name":"titlecase?","doc":"Returns `true` if this char is a titlecase character, i.e. a ligature\nconsisting of an uppercase letter followed by lowercase characters.\n\n```\n'ǲ'.titlecase? # => true\n'H'.titlecase? # => false\n'c'.titlecase? # => false\n```","summary":"<p>Returns <code>true</code> if this char is a titlecase character, i.e.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":239,"url":null},"def":{"name":"titlecase?","return_type":"Bool","visibility":"Public","body":"(!ascii?) && (Unicode.titlecase?(self))"},"external_var":false},{"html_id":"to_f:Float64-instance-method","name":"to_f","doc":"Returns the integer value of this char as a float if it's an ASCII char denoting a digit,\nraises otherwise.\n\n```\n'1'.to_f # => 1.0\n'8'.to_f # => 8.0\n'c'.to_f # raises ArgumentError\n```","summary":"<p>Returns the integer value of this char as a float if it's an ASCII char denoting a digit, raises otherwise.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":880,"url":null},"def":{"name":"to_f","return_type":"Float64","visibility":"Public","body":"to_f64"},"external_var":false},{"html_id":"to_f32:Float32-instance-method","name":"to_f32","doc":"See also: `to_f`.","summary":"<p>See also: <code><a href=\"Char.html#to_f%3AFloat64-instance-method\">#to_f</a></code>.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":897,"url":null},"def":{"name":"to_f32","return_type":"Float32","visibility":"Public","body":"to_i.to_f32"},"external_var":false},{"html_id":"to_f32?:Float32|Nil-instance-method","name":"to_f32?","doc":"See also: `to_f?`.","summary":"<p>See also: <code><a href=\"Char.html#to_f%3F%3AFloat64%7CNil-instance-method\">#to_f?</a></code>.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":902,"url":null},"def":{"name":"to_f32?","return_type":"Float32 | ::Nil","visibility":"Public","body":"to_i?.try(&.to_f32)"},"external_var":false},{"html_id":"to_f64:Float64-instance-method","name":"to_f64","doc":"Same as `to_f`.","summary":"<p>Same as <code><a href=\"Char.html#to_f%3AFloat64-instance-method\">#to_f</a></code>.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":907,"url":null},"def":{"name":"to_f64","return_type":"Float64","visibility":"Public","body":"to_i.to_f64"},"external_var":false},{"html_id":"to_f64?:Float64|Nil-instance-method","name":"to_f64?","doc":"Same as `to_f?`.","summary":"<p>Same as <code><a href=\"Char.html#to_f%3F%3AFloat64%7CNil-instance-method\">#to_f?</a></code>.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":912,"url":null},"def":{"name":"to_f64?","return_type":"Float64 | ::Nil","visibility":"Public","body":"to_i?.try(&.to_f64)"},"external_var":false},{"html_id":"to_f?:Float64|Nil-instance-method","name":"to_f?","doc":"Returns the integer value of this char as a float if it's an ASCII char denoting a digit,\n`nil` otherwise.\n\n```\n'1'.to_f? # => 1.0\n'8'.to_f? # => 8.0\n'c'.to_f? # => nil\n```","summary":"<p>Returns the integer value of this char as a float if it's an ASCII char denoting a digit, <code>nil</code> otherwise.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":892,"url":null},"def":{"name":"to_f?","return_type":"Float64 | ::Nil","visibility":"Public","body":"to_f64?"},"external_var":false},{"html_id":"to_i(base:Int=10):Int32-instance-method","name":"to_i","doc":"Returns the integer value of this char if it's an ASCII char denoting a digit\nin *base*, raises otherwise.\n\n```\n'1'.to_i     # => 1\n'8'.to_i     # => 8\n'c'.to_i     # raises ArgumentError\n'1'.to_i(16) # => 1\n'a'.to_i(16) # => 10\n'f'.to_i(16) # => 15\n'z'.to_i(16) # raises ArgumentError\n```","summary":"<p>Returns the integer value of this char if it's an ASCII char denoting a digit in <em>base</em>, raises otherwise.</p>","abstract":false,"args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = 10) : Int32","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>) : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/char.cr","line_number":818,"url":null},"def":{"name":"to_i","args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"return_type":"Int32","visibility":"Public","body":"(to_i?(base)) || (raise(ArgumentError.new(\"Invalid integer: #{self}\")))"},"external_var":false},{"html_id":"to_i128(base:Int=10)-instance-method","name":"to_i128","doc":"See also: `to_i`.","summary":"<p>See also: <code><a href=\"Char.html#to_i%28base%3AInt%3D10%29%3AInt32-instance-method\">#to_i</a></code>.</p>","abstract":false,"args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = 10)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":860,"url":null},"def":{"name":"to_i128","args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"visibility":"Public","body":"(to_i(base)).to_i128"},"external_var":false},{"html_id":"to_i128?(base:Int=10)-instance-method","name":"to_i128?","doc":"See also: `to_i?`.","summary":"<p>See also: <code><a href=\"Char.html#to_i%3F%28base%3AInt%3D10%29%3AInt32%7CNil-instance-method\">#to_i?</a></code>.</p>","abstract":false,"args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = 10)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":860,"url":null},"def":{"name":"to_i128?","args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"visibility":"Public","body":"(to_i?(base)).try(&.to_i128)"},"external_var":false},{"html_id":"to_i16(base:Int=10)-instance-method","name":"to_i16","doc":"See also: `to_i`.","summary":"<p>See also: <code><a href=\"Char.html#to_i%28base%3AInt%3D10%29%3AInt32-instance-method\">#to_i</a></code>.</p>","abstract":false,"args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = 10)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":860,"url":null},"def":{"name":"to_i16","args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"visibility":"Public","body":"(to_i(base)).to_i16"},"external_var":false},{"html_id":"to_i16?(base:Int=10)-instance-method","name":"to_i16?","doc":"See also: `to_i?`.","summary":"<p>See also: <code><a href=\"Char.html#to_i%3F%28base%3AInt%3D10%29%3AInt32%7CNil-instance-method\">#to_i?</a></code>.</p>","abstract":false,"args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = 10)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":860,"url":null},"def":{"name":"to_i16?","args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"visibility":"Public","body":"(to_i?(base)).try(&.to_i16)"},"external_var":false},{"html_id":"to_i32(base:Int=10):Int32-instance-method","name":"to_i32","doc":"Same as `to_i`.","summary":"<p>Same as <code><a href=\"Char.html#to_i%28base%3AInt%3D10%29%3AInt32-instance-method\">#to_i</a></code>.</p>","abstract":false,"args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = 10) : Int32","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>) : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/char.cr","line_number":851,"url":null},"def":{"name":"to_i32","args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"return_type":"Int32","visibility":"Public","body":"to_i(base)"},"external_var":false},{"html_id":"to_i32?(base:Int=10):Int32|Nil-instance-method","name":"to_i32?","doc":"Same as `to_i?`.","summary":"<p>Same as <code><a href=\"Char.html#to_i%3F%28base%3AInt%3D10%29%3AInt32%7CNil-instance-method\">#to_i?</a></code>.</p>","abstract":false,"args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = 10) : Int32 | Nil","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>) : <a href=\"Int32.html\">Int32</a> | <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/char.cr","line_number":856,"url":null},"def":{"name":"to_i32?","args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"return_type":"Int32 | ::Nil","visibility":"Public","body":"to_i?(base)"},"external_var":false},{"html_id":"to_i64(base:Int=10)-instance-method","name":"to_i64","doc":"See also: `to_i`.","summary":"<p>See also: <code><a href=\"Char.html#to_i%28base%3AInt%3D10%29%3AInt32-instance-method\">#to_i</a></code>.</p>","abstract":false,"args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = 10)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":860,"url":null},"def":{"name":"to_i64","args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"visibility":"Public","body":"(to_i(base)).to_i64"},"external_var":false},{"html_id":"to_i64?(base:Int=10)-instance-method","name":"to_i64?","doc":"See also: `to_i?`.","summary":"<p>See also: <code><a href=\"Char.html#to_i%3F%28base%3AInt%3D10%29%3AInt32%7CNil-instance-method\">#to_i?</a></code>.</p>","abstract":false,"args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = 10)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":860,"url":null},"def":{"name":"to_i64?","args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"visibility":"Public","body":"(to_i?(base)).try(&.to_i64)"},"external_var":false},{"html_id":"to_i8(base:Int=10)-instance-method","name":"to_i8","doc":"See also: `to_i`.","summary":"<p>See also: <code><a href=\"Char.html#to_i%28base%3AInt%3D10%29%3AInt32-instance-method\">#to_i</a></code>.</p>","abstract":false,"args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = 10)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":860,"url":null},"def":{"name":"to_i8","args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"visibility":"Public","body":"(to_i(base)).to_i8"},"external_var":false},{"html_id":"to_i8?(base:Int=10)-instance-method","name":"to_i8?","doc":"See also: `to_i?`.","summary":"<p>See also: <code><a href=\"Char.html#to_i%3F%28base%3AInt%3D10%29%3AInt32%7CNil-instance-method\">#to_i?</a></code>.</p>","abstract":false,"args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = 10)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":860,"url":null},"def":{"name":"to_i8?","args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"visibility":"Public","body":"(to_i?(base)).try(&.to_i8)"},"external_var":false},{"html_id":"to_i?(base:Int=10):Int32|Nil-instance-method","name":"to_i?","doc":"Returns the integer value of this char if it's an ASCII char denoting a digit\nin *base*, `nil` otherwise.\n\n```\n'1'.to_i?     # => 1\n'8'.to_i?     # => 8\n'c'.to_i?     # => nil\n'1'.to_i?(16) # => 1\n'a'.to_i?(16) # => 10\n'f'.to_i?(16) # => 15\n'z'.to_i?(16) # => nil\n```","summary":"<p>Returns the integer value of this char if it's an ASCII char denoting a digit in <em>base</em>, <code>nil</code> otherwise.</p>","abstract":false,"args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = 10) : Int32 | Nil","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>) : <a href=\"Int32.html\">Int32</a> | <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/char.cr","line_number":834,"url":null},"def":{"name":"to_i?","args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"return_type":"Int32 | ::Nil","visibility":"Public","body":"if 2 <= base && base <= 36\nelse\n  raise(ArgumentError.new(\"Invalid base #{base}, expected 2 to 36\"))\nend\n\nif base == 10\n  if '0' <= self && self <= '9'\n  else\n    return\n  end\n  self - '0'\nelse\n  ord = ord()\n  if 0 <= ord && ord < 256\n    digit = String::CHAR_TO_DIGIT.to_unsafe[ord]\n    if (digit == -1) || digit >= base\n      return\n    end\n    digit.to_i32\n  end\nend\n"},"external_var":false},{"html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Appends this char to the given `IO`.\n\nThis appends this char's bytes as encoded by UTF-8 to the given `IO`.","summary":"<p>Appends this char to the given <code><a href=\"IO.html\">IO</a></code>.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/char.cr","line_number":1024,"url":null},"def":{"name":"to_s","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"if ascii?\n  byte = ord.to_u8\n\n\n  if io.has_non_utf8_encoding?\n    io.write_string(Slice.new(pointerof(byte), 1))\n  else\n    io.write_byte(byte)\n  end\nelse\n  chars = uninitialized ::StaticArray(UInt8, 4)\n  i = 0\n  each_byte do |byte|\n    chars[i] = byte\n    i = i + 1\n  end\n  io.write_string(chars.to_slice[0, i])\nend"},"external_var":false},{"html_id":"to_s:String-instance-method","name":"to_s","doc":"Returns this char as a string containing this char as a single character.\n\n```\n'a'.to_s # => \"a\"\n'あ'.to_s # => \"あ\"\n```","summary":"<p>Returns this char as a string containing this char as a single character.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":1012,"url":null},"def":{"name":"to_s","return_type":"String","visibility":"Public","body":"bytesize = self.bytesize\nString.new(bytesize) do |buffer|\n  appender = buffer.appender\n  each_byte do |byte| appender << byte end\n  {bytesize, 1}\nend\n"},"external_var":false},{"html_id":"to_u128(base:Int=10)-instance-method","name":"to_u128","doc":"See also: `to_i`.","summary":"<p>See also: <code><a href=\"Char.html#to_i%28base%3AInt%3D10%29%3AInt32-instance-method\">#to_i</a></code>.</p>","abstract":false,"args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = 10)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":860,"url":null},"def":{"name":"to_u128","args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"visibility":"Public","body":"(to_i(base)).to_u128"},"external_var":false},{"html_id":"to_u128?(base:Int=10)-instance-method","name":"to_u128?","doc":"See also: `to_i?`.","summary":"<p>See also: <code><a href=\"Char.html#to_i%3F%28base%3AInt%3D10%29%3AInt32%7CNil-instance-method\">#to_i?</a></code>.</p>","abstract":false,"args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = 10)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":860,"url":null},"def":{"name":"to_u128?","args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"visibility":"Public","body":"(to_i?(base)).try(&.to_u128)"},"external_var":false},{"html_id":"to_u16(base:Int=10)-instance-method","name":"to_u16","doc":"See also: `to_i`.","summary":"<p>See also: <code><a href=\"Char.html#to_i%28base%3AInt%3D10%29%3AInt32-instance-method\">#to_i</a></code>.</p>","abstract":false,"args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = 10)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":860,"url":null},"def":{"name":"to_u16","args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"visibility":"Public","body":"(to_i(base)).to_u16"},"external_var":false},{"html_id":"to_u16?(base:Int=10)-instance-method","name":"to_u16?","doc":"See also: `to_i?`.","summary":"<p>See also: <code><a href=\"Char.html#to_i%3F%28base%3AInt%3D10%29%3AInt32%7CNil-instance-method\">#to_i?</a></code>.</p>","abstract":false,"args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = 10)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":860,"url":null},"def":{"name":"to_u16?","args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"visibility":"Public","body":"(to_i?(base)).try(&.to_u16)"},"external_var":false},{"html_id":"to_u32(base:Int=10)-instance-method","name":"to_u32","doc":"See also: `to_i`.","summary":"<p>See also: <code><a href=\"Char.html#to_i%28base%3AInt%3D10%29%3AInt32-instance-method\">#to_i</a></code>.</p>","abstract":false,"args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = 10)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":860,"url":null},"def":{"name":"to_u32","args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"visibility":"Public","body":"(to_i(base)).to_u32"},"external_var":false},{"html_id":"to_u32?(base:Int=10)-instance-method","name":"to_u32?","doc":"See also: `to_i?`.","summary":"<p>See also: <code><a href=\"Char.html#to_i%3F%28base%3AInt%3D10%29%3AInt32%7CNil-instance-method\">#to_i?</a></code>.</p>","abstract":false,"args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = 10)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":860,"url":null},"def":{"name":"to_u32?","args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"visibility":"Public","body":"(to_i?(base)).try(&.to_u32)"},"external_var":false},{"html_id":"to_u64(base:Int=10)-instance-method","name":"to_u64","doc":"See also: `to_i`.","summary":"<p>See also: <code><a href=\"Char.html#to_i%28base%3AInt%3D10%29%3AInt32-instance-method\">#to_i</a></code>.</p>","abstract":false,"args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = 10)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":860,"url":null},"def":{"name":"to_u64","args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"visibility":"Public","body":"(to_i(base)).to_u64"},"external_var":false},{"html_id":"to_u64?(base:Int=10)-instance-method","name":"to_u64?","doc":"See also: `to_i?`.","summary":"<p>See also: <code><a href=\"Char.html#to_i%3F%28base%3AInt%3D10%29%3AInt32%7CNil-instance-method\">#to_i?</a></code>.</p>","abstract":false,"args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = 10)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":860,"url":null},"def":{"name":"to_u64?","args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"visibility":"Public","body":"(to_i?(base)).try(&.to_u64)"},"external_var":false},{"html_id":"to_u8(base:Int=10)-instance-method","name":"to_u8","doc":"See also: `to_i`.","summary":"<p>See also: <code><a href=\"Char.html#to_i%28base%3AInt%3D10%29%3AInt32-instance-method\">#to_i</a></code>.</p>","abstract":false,"args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = 10)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":860,"url":null},"def":{"name":"to_u8","args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"visibility":"Public","body":"(to_i(base)).to_u8"},"external_var":false},{"html_id":"to_u8?(base:Int=10)-instance-method","name":"to_u8?","doc":"See also: `to_i?`.","summary":"<p>See also: <code><a href=\"Char.html#to_i%3F%28base%3AInt%3D10%29%3AInt32%7CNil-instance-method\">#to_i?</a></code>.</p>","abstract":false,"args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = 10)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":860,"url":null},"def":{"name":"to_u8?","args":[{"name":"base","default_value":"10","external_name":"base","restriction":"Int"}],"visibility":"Public","body":"(to_i?(base)).try(&.to_u8)"},"external_var":false},{"html_id":"unicode_escape(io:IO):Nil-instance-method","name":"unicode_escape","doc":"Returns the Unicode escape sequence representing this character.\n\nThe codepoints are expressed as hexadecimal digits with uppercase letters.\nUnicode escapes always use the four digit style for codepoints `U+FFFF`\nand lower, adding leading zeros when necessary. Higher codepoints have their\ndigits wrapped in curly braces and no leading zeros.\n\n```\n'a'.unicode_escape      # => \"\\\\u0061\"\n'\\t'.unicode_escape     # => \"\\\\u0009\"\n'あ'.unicode_escape      # => \"\\\\u3042\"\n'\\u0012'.unicode_escape # => \"\\\\u0012\"\n'😀'.unicode_escape      # => \"\\\\u{1F600}\"\n```","summary":"<p>Returns the Unicode escape sequence representing this character.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/char.cr","line_number":796,"url":null},"def":{"name":"unicode_escape","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"io << \"\\\\u\"\nif ord > 65535\n  io << '{'\nend\nif ord < 4096\n  io << '0'\nend\nif ord < 256\n  io << '0'\nend\nif ord < 16\n  io << '0'\nend\nord.to_s(io, 16, upcase: true)\nif ord > 65535\n  io << '}'\nend\n"},"external_var":false},{"html_id":"unicode_escape:String-instance-method","name":"unicode_escape","doc":"Returns the Unicode escape sequence representing this character.\n\nThe codepoints are expressed as hexadecimal digits with uppercase letters.\nUnicode escapes always use the four digit style for codepoints `U+FFFF`\nand lower, adding leading zeros when necessary. Higher codepoints have their\ndigits wrapped in curly braces and no leading zeros.\n\n```\n'a'.unicode_escape      # => \"\\\\u0061\"\n'\\t'.unicode_escape     # => \"\\\\u0009\"\n'あ'.unicode_escape      # => \"\\\\u3042\"\n'\\u0012'.unicode_escape # => \"\\\\u0012\"\n'😀'.unicode_escape      # => \"\\\\u{1F600}\"\n```","summary":"<p>Returns the Unicode escape sequence representing this character.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":789,"url":null},"def":{"name":"unicode_escape","return_type":"String","visibility":"Public","body":"String.build do |io|\n  unicode_escape(io)\nend"},"external_var":false},{"html_id":"upcase(io:IO,options:Unicode::CaseOptions=:none):Nil-instance-method","name":"upcase","doc":"Writes the upcase equivalent of this char to the given *io*.\n\nThis method takes into account the possibility that an upcase\nversion of a char might result in multiple chars, like for\n'ﬄ', which results in 'F', 'F' and 'L'.\n\n```\n'z'.upcase(STDOUT) # prints \"Z\"\n'ﬄ'.upcase(STDOUT) # prints \"FFL\"\n```","summary":"<p>Writes the upcase equivalent of this char to the given <em>io</em>.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"options","default_value":":none","external_name":"options","restriction":"Unicode::CaseOptions"}],"args_string":"(io : IO, options : Unicode::CaseOptions = :none) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>, options : <a href=\"Unicode/CaseOptions.html\">Unicode::CaseOptions</a> = <span class=\"n\">:none</span>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/char.cr","line_number":517,"url":null},"def":{"name":"upcase","args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"options","default_value":":none","external_name":"options","restriction":"Unicode::CaseOptions"}],"return_type":"Nil","visibility":"Public","body":"upcase(options) do |char| io << char end"},"external_var":false},{"html_id":"upcase(options:Unicode::CaseOptions=:none):Char-instance-method","name":"upcase","doc":"Returns the upcase equivalent of this char.\n\nNote that this only works for characters whose upcase\nequivalent yields a single codepoint. There are a few\ncharacters, like 'ﬄ', than when upcased result in multiple\ncharacters (in this case: 'F', 'F', 'L').\n\nFor more correct behavior see the overloads that receive a block or an `IO`.\n\n```\n'z'.upcase # => 'Z'\n'X'.upcase # => 'X'\n'.'.upcase # => '.'\n```","summary":"<p>Returns the upcase equivalent of this char.</p>","abstract":false,"args":[{"name":"options","default_value":":none","external_name":"options","restriction":"Unicode::CaseOptions"}],"args_string":"(options : Unicode::CaseOptions = :none) : Char","args_html":"(options : <a href=\"Unicode/CaseOptions.html\">Unicode::CaseOptions</a> = <span class=\"n\">:none</span>) : <a href=\"Char.html\">Char</a>","location":{"filename":"src/char.cr","line_number":489,"url":null},"def":{"name":"upcase","args":[{"name":"options","default_value":":none","external_name":"options","restriction":"Unicode::CaseOptions"}],"return_type":"Char","visibility":"Public","body":"Unicode.upcase(self, options)"},"external_var":false},{"html_id":"upcase(options:Unicode::CaseOptions=:none,&)-instance-method","name":"upcase","doc":"Yields each char for the upcase equivalent of this char.\n\nThis method takes into account the possibility that an upcase\nversion of a char might result in multiple chars, like for\n'ﬄ', which results in 'F', 'F' and 'L'.\n\n```\n'z'.upcase { |v| puts v } # prints 'Z'\n'ﬄ'.upcase { |v| puts v } # prints 'F', 'F', 'L'\n```","summary":"<p>Yields each char for the upcase equivalent of this char.</p>","abstract":false,"args":[{"name":"options","default_value":":none","external_name":"options","restriction":"Unicode::CaseOptions"}],"args_string":"(options : Unicode::CaseOptions = :none, &)","args_html":"(options : <a href=\"Unicode/CaseOptions.html\">Unicode::CaseOptions</a> = <span class=\"n\">:none</span>, &)","location":{"filename":"src/char.cr","line_number":503,"url":null},"def":{"name":"upcase","args":[{"name":"options","default_value":":none","external_name":"options","restriction":"Unicode::CaseOptions"}],"yields":1,"block_arity":1,"visibility":"Public","body":"Unicode.upcase(self, options) do |char| yield char end"},"external_var":false},{"html_id":"uppercase?:Bool-instance-method","name":"uppercase?","doc":"Returns `true` if this char is an uppercase letter.\n\n```\n'H'.uppercase? # => true\n'Á'.uppercase? # => true\n'c'.uppercase? # => false\n'.'.uppercase? # => false\n'ǲ'.uppercase? # => false\n```","summary":"<p>Returns <code>true</code> if this char is an uppercase letter.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":227,"url":null},"def":{"name":"uppercase?","return_type":"Bool","visibility":"Public","body":"ascii? ? ascii_uppercase? : Unicode.uppercase?(self)"},"external_var":false},{"html_id":"whitespace?:Bool-instance-method","name":"whitespace?","doc":"Returns `true` if this char is a whitespace according to unicode.\n\n```\n' '.whitespace?  # => true\n'\\t'.whitespace? # => true\n'b'.whitespace?  # => false\n```","summary":"<p>Returns <code>true</code> if this char is a whitespace according to unicode.</p>","abstract":false,"location":{"filename":"src/char.cr","line_number":308,"url":null},"def":{"name":"whitespace?","return_type":"Bool","visibility":"Public","body":"ascii? ? ascii_whitespace? : Unicode.whitespace?(self)"},"external_var":false}],"types":[{"html_id":"Crystal/Char/Reader","path":"Char/Reader.html","kind":"struct","full_name":"Char::Reader","name":"Reader","abstract":false,"superclass":{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},"ancestors":[{"html_id":"Crystal/Enumerable","kind":"module","full_name":"Enumerable","name":"Enumerable"},{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/char/reader.cr","line_number":36,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"included_modules":[{"html_id":"Crystal/Enumerable","kind":"module","full_name":"Enumerable","name":"Enumerable"}],"namespace":{"html_id":"Crystal/Char","kind":"struct","full_name":"Char","name":"Char"},"doc":"A `Char::Reader` allows iterating a `String` by Chars.\n\nAs soon as you instantiate a `Char::Reader` it will decode the first\nchar in the `String`, which can be accessed by invoking `current_char`.\nAt this point `pos`, the current position in the string, will equal zero.\nSuccessive calls to `next_char` return the next chars in the string,\nadvancing `pos`.\n\nNOTE: The null character `'\\0'` will be returned in `current_char` when\nthe end is reached (as well as when the string is empty). Thus, `has_next?`\nwill return `false` only when `pos` is equal to the string's bytesize, in which\ncase `current_char` will always be `'\\0'`.\n\nNOTE: For performance reasons, `Char::Reader` has value semantics, so care\nmust be taken when a reader is declared as a local variable and passed to\nanother method:\n\n```\ndef lstrip(reader)\n  until reader.current_char.whitespace?\n    reader.next_char\n  end\n  reader\nend\n\n# caller's internal state is untouched\nreader = Char::Reader.new(\"   abc\")\nlstrip(reader)\nreader.current_char # => ' '\n\n# to modify caller's internal state, the method must return a new reader\nreader = lstrip(reader)\nreader.current_char # => 'a'\n```","summary":"<p>A <code><a href=\"../Char/Reader.html\">Char::Reader</a></code> allows iterating a <code><a href=\"../String.html\">String</a></code> by Chars.</p>","constructors":[{"html_id":"new(string:String,pos=0)-class-method","name":"new","doc":"Creates a reader with the specified *string* positioned at\nbyte index *pos*.","summary":"<p>Creates a reader with the specified <em>string</em> positioned at byte index <em>pos</em>.</p>","abstract":false,"args":[{"name":"string","external_name":"string","restriction":"String"},{"name":"pos","default_value":"0","external_name":"pos","restriction":""}],"args_string":"(string : String, pos = 0)","args_html":"(string : <a href=\"../String.html\">String</a>, pos = <span class=\"n\">0</span>)","location":{"filename":"src/char/reader.cr","line_number":83,"url":null},"def":{"name":"new","args":[{"name":"string","external_name":"string","restriction":"String"},{"name":"pos","default_value":"0","external_name":"pos","restriction":""}],"visibility":"Public","body":"_ = allocate\n_.initialize(string, pos)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(*,at_endstring:String)-class-method","name":"new","doc":"Creates a reader that will be positioned at the last char\nof the given string.","summary":"<p>Creates a reader that will be positioned at the last char of the given string.</p>","abstract":false,"args":[{"name":"","external_name":"","restriction":""},{"name":"string","external_name":"at_end","restriction":"String"}],"args_string":"(*, at_end string : String)","args_html":"(*, at_end string : <a href=\"../String.html\">String</a>)","location":{"filename":"src/char/reader.cr","line_number":92,"url":null},"def":{"name":"new","args":[{"name":"","external_name":"","restriction":""},{"name":"string","external_name":"at_end","restriction":"String"}],"splat_index":0,"visibility":"Public","body":"_ = allocate\n_.initialize(at_end: string)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false}],"instance_methods":[{"html_id":"current_char:Char-instance-method","name":"current_char","doc":"Returns the current character, or `'\\0'` if the reader is at the end of\nthe string.\n\n```\nreader = Char::Reader.new(\"ab\")\nreader.current_char # => 'a'\nreader.next_char\nreader.current_char # => 'b'\nreader.next_char\nreader.current_char # => '\\0'\n```","summary":"<p>Returns the current character, or <code>'\\0'</code> if the reader is at the end of the string.</p>","abstract":false,"location":{"filename":"src/char/reader.cr","line_number":53,"url":null},"def":{"name":"current_char","return_type":"Char","visibility":"Public","body":"@current_char"},"external_var":false},{"html_id":"current_char?:Char|Nil-instance-method","name":"current_char?","doc":"Returns the current character.\n\nReturns `nil` if the reader is at the end of the string.","summary":"<p>Returns the current character.</p>","abstract":false,"location":{"filename":"src/char/reader.cr","line_number":102,"url":null},"def":{"name":"current_char?","return_type":"Char | ::Nil","visibility":"Public","body":"if has_next?\n  current_char\nend"},"external_var":false},{"html_id":"current_char_width:Int32-instance-method","name":"current_char_width","doc":"Returns the size of the `#current_char` (in bytes) as if it were encoded in UTF-8.\n\n```\nreader = Char::Reader.new(\"aé\")\nreader.current_char_width # => 1\nreader.next_char\nreader.current_char_width # => 2\n```","summary":"<p>Returns the size of the <code><a href=\"../Char/Reader.html#current_char%3AChar-instance-method\">#current_char</a></code> (in bytes) as if it were encoded in UTF-8.</p>","abstract":false,"location":{"filename":"src/char/reader.cr","line_number":63,"url":null},"def":{"name":"current_char_width","return_type":"Int32","visibility":"Public","body":"@current_char_width"},"external_var":false},{"html_id":"each(&):Nil-instance-method","name":"each","doc":"Yields successive characters from `#string` starting from `#pos`.\n\n```\nreader = Char::Reader.new(\"abc\")\nreader.next_char\nreader.each do |c|\n  puts c.upcase\nend\n```\n\n``` text\nB\nC\n```","summary":"<p>Yields successive characters from <code><a href=\"../Char/Reader.html#string%3AString-instance-method\">#string</a></code> starting from <code><a href=\"../Char/Reader.html#pos%3AInt32-instance-method\">#pos</a></code>.</p>","abstract":false,"location":{"filename":"src/char/reader.cr","line_number":266,"url":null},"def":{"name":"each","yields":1,"block_arity":1,"return_type":"Nil","visibility":"Public","body":"while has_next?\n  yield current_char\n\n  @pos = @pos + @current_char_width\n  decode_current_char\nend"},"external_var":false},{"html_id":"error:UInt8|Nil-instance-method","name":"error","doc":"If there was an error decoding the current char because\nof an invalid UTF-8 byte sequence, returns the byte\nthat produced the invalid encoding. Returns `0` if the char would've been\nout of bounds. Otherwise returns `nil`.","summary":"<p>If there was an error decoding the current char because of an invalid UTF-8 byte sequence, returns the byte that produced the invalid encoding.</p>","abstract":false,"location":{"filename":"src/char/reader.cr","line_number":79,"url":null},"def":{"name":"error","return_type":"UInt8 | ::Nil","visibility":"Public","body":"@error"},"external_var":false},{"html_id":"has_next?:Bool-instance-method","name":"has_next?","doc":"Returns `true` if the reader is not at the end of the string.\n\nNOTE: This only means `#next_char` will successfully increment `#pos`; if\nthe reader is already at the last character, `#next_char` will return the\nterminating null byte because there isn't really a next character.\n\n```\nreader = Char::Reader.new(\"ab\")\nreader.has_next? # => true\nreader.next_char # => 'b'\nreader.has_next? # => true\nreader.next_char # => '\\0'\nreader.has_next? # => false\n```","summary":"<p>Returns <code>true</code> if the reader is not at the end of the string.</p>","abstract":false,"location":{"filename":"src/char/reader.cr","line_number":122,"url":null},"def":{"name":"has_next?","return_type":"Bool","visibility":"Public","body":"@pos < @string.bytesize"},"external_var":false},{"html_id":"has_previous?:Bool-instance-method","name":"has_previous?","doc":"Returns `true` if the reader is not at the beginning of the string.","summary":"<p>Returns <code>true</code> if the reader is not at the beginning of the string.</p>","abstract":false,"location":{"filename":"src/char/reader.cr","line_number":193,"url":null},"def":{"name":"has_previous?","return_type":"Bool","visibility":"Public","body":"@pos > 0"},"external_var":false},{"html_id":"next_char:Char-instance-method","name":"next_char","doc":"Reads the next character in the string.\n\nIf the reader is at the end of the string after incrementing `#pos`,\nreturns `'\\0'`. If the reader is already at the end beforehand, raises\n`IndexError`.\n\n```\nreader = Char::Reader.new(\"abc\")\nreader.next_char # => 'b'\nreader.next_char # => 'c'\nreader.next_char # => '\\0'\nreader.next_char # raise IndexError\n```","summary":"<p>Reads the next character in the string.</p>","abstract":false,"location":{"filename":"src/char/reader.cr","line_number":160,"url":null},"def":{"name":"next_char","return_type":"Char","visibility":"Public","body":"next_pos = @pos + @current_char_width\nif next_pos <= @string.bytesize\n  @pos = next_pos\n  decode_current_char\nelse\n  raise(IndexError.new)\nend\n"},"external_var":false},{"html_id":"next_char?:Char|Nil-instance-method","name":"next_char?","doc":"Tries to read the next character in the string.\n\nIf the reader is at the end of the string before or after incrementing\n`#pos`, returns `nil`.\n\n```\nreader = Char::Reader.new(\"abc\")\nreader.next_char?   # => 'b'\nreader.next_char?   # => 'c'\nreader.next_char?   # => nil\nreader.current_char # => '\\0'\n```","summary":"<p>Tries to read the next character in the string.</p>","abstract":false,"location":{"filename":"src/char/reader.cr","line_number":138,"url":null},"def":{"name":"next_char?","return_type":"Char | ::Nil","visibility":"Public","body":"next_pos = @pos + @current_char_width\nif next_pos <= @string.bytesize\n  @pos = next_pos\n  decode_current_char\n  current_char?\nend\n"},"external_var":false},{"html_id":"peek_next_char:Char-instance-method","name":"peek_next_char","doc":"Returns the next character in the `#string` without incrementing `#pos`.\n\nReturns `'\\0'` if the reader is at the last character of the string.\nRaises `IndexError` if the reader is at the end.\n\n```\nreader = Char::Reader.new(\"ab\")\nreader.peek_next_char # => 'b'\nreader.current_char   # => 'a'\n```","summary":"<p>Returns the next character in the <code><a href=\"../Char/Reader.html#string%3AString-instance-method\">#string</a></code> without incrementing <code><a href=\"../Char/Reader.html#pos%3AInt32-instance-method\">#pos</a></code>.</p>","abstract":false,"location":{"filename":"src/char/reader.cr","line_number":180,"url":null},"def":{"name":"peek_next_char","return_type":"Char","visibility":"Public","body":"next_pos = @pos + @current_char_width\n\nif next_pos > @string.bytesize\n  raise(IndexError.new)\nend\n\ndecode_char_at(next_pos) do |code_point|\n  code_point.unsafe_chr\nend\n"},"external_var":false},{"html_id":"pos:Int32-instance-method","name":"pos","doc":"Returns the byte position of the current character.\n\n```\nreader = Char::Reader.new(\"ab\")\nreader.pos # => 0\nreader.next_char\nreader.pos # => 1\n```","summary":"<p>Returns the byte position of the current character.</p>","abstract":false,"location":{"filename":"src/char/reader.cr","line_number":73,"url":null},"def":{"name":"pos","return_type":"Int32","visibility":"Public","body":"@pos"},"external_var":false},{"html_id":"pos=(pos:Int32)-instance-method","name":"pos=","doc":"Sets `#pos` to *pos*.\n\n```\nreader = Char::Reader.new(\"abc\")\nreader.next_char\nreader.next_char\nreader.pos = 0\nreader.current_char # => 'a'\n```","summary":"<p>Sets <code><a href=\"../Char/Reader.html#pos%3AInt32-instance-method\">#pos</a></code> to <em>pos</em>.</p>","abstract":false,"args":[{"name":"pos","external_name":"pos","restriction":"::Int32"}],"args_string":"(pos : Int32)","args_html":"(pos : <a href=\"../Int32.html\">Int32</a>)","location":{"filename":"src/char/reader.cr","line_number":242,"url":null},"def":{"name":"pos=","args":[{"name":"pos","external_name":"pos","restriction":"::Int32"}],"visibility":"Public","body":"if pos > @string.bytesize\n  raise(IndexError.new)\nend\n\n@pos = pos\ndecode_current_char\npos\n"},"external_var":false},{"html_id":"previous_char:Char-instance-method","name":"previous_char","doc":"Reads the previous character in the string.\n\nRaises `IndexError` if the reader is already at the beginning of the\nstring. Otherwise decrements `#pos`.\n\n```\nreader = Char::Reader.new(at_end: \"abc\")\nreader.previous_char # => 'b'\nreader.previous_char # => 'a'\nreader.previous_char # raises IndexError\n```","summary":"<p>Reads the previous character in the string.</p>","abstract":false,"location":{"filename":"src/char/reader.cr","line_number":225,"url":null},"def":{"name":"previous_char","return_type":"Char","visibility":"Public","body":"if has_previous?\nelse\n  raise(IndexError.new)\nend\n\ndecode_previous_char.as(Char)\n"},"external_var":false},{"html_id":"previous_char?:Char|Nil-instance-method","name":"previous_char?","doc":"Tries to read the previous character in the string.\n\nReturns `nil` if the reader is already at the beginning of the string.\nOtherwise decrements `#pos`.\n\n```\nreader = Char::Reader.new(at_end: \"abc\")\nreader.previous_char? # => 'b'\nreader.previous_char? # => 'a'\nreader.previous_char? # => nil\n```","summary":"<p>Tries to read the previous character in the string.</p>","abstract":false,"location":{"filename":"src/char/reader.cr","line_number":208,"url":null},"def":{"name":"previous_char?","return_type":"Char | ::Nil","visibility":"Public","body":"if has_previous?\n  decode_previous_char\nend"},"external_var":false},{"html_id":"string:String-instance-method","name":"string","doc":"Returns the reader's String.","summary":"<p>Returns the reader's String.</p>","abstract":false,"location":{"filename":"src/char/reader.cr","line_number":40,"url":null},"def":{"name":"string","return_type":"String","visibility":"Public","body":"@string"},"external_var":false}]}]},{"html_id":"Crystal/Class","path":"Class.html","kind":"class","full_name":"Class","name":"Class","abstract":true,"superclass":{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},"ancestors":[{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/class.cr","line_number":1,"url":null},{"filename":"src/primitives.cr","line_number":154,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"class_methods":[{"html_id":"<(other:T.class):BoolforallT-class-method","name":"<","doc":"Returns whether this class inherits or includes *other*.\n\n```\nInt32 < Number  # => true\nInt32 < Value   # => true\nInt32 < Int32   # => false\nInt32 <= String # => false\n```","summary":"<p>Returns whether this class inherits or includes <em>other</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"T.class"}],"args_string":"(other : T.class) : Bool forall T","args_html":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) : <a href=\"Bool.html\">Bool</a> forall T","location":{"filename":"src/class.cr","line_number":29,"url":null},"def":{"name":"<","args":[{"name":"other","external_name":"other","restriction":"T.class"}],"return_type":"Bool","visibility":"Public","body":"{% @type %}\nother._gt(self)\n"},"external_var":false},{"html_id":"<=(other:T.class):BoolforallT-class-method","name":"<=","doc":"Returns whether this class inherits or includes *other*, or\nis equal to *other*.\n\n```\nInt32 < Number  # => true\nInt32 < Value   # => true\nInt32 <= Int32  # => true\nInt32 <= String # => false\n```","summary":"<p>Returns whether this class inherits or includes <em>other</em>, or is equal to <em>other</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"T.class"}],"args_string":"(other : T.class) : Bool forall T","args_html":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) : <a href=\"Bool.html\">Bool</a> forall T","location":{"filename":"src/class.cr","line_number":44,"url":null},"def":{"name":"<=","args":[{"name":"other","external_name":"other","restriction":"T.class"}],"return_type":"Bool","visibility":"Public","body":"{% @type %}\nother._gte(self)\n"},"external_var":false},{"html_id":"==(other:Class):Bool-class-method","name":"==","doc":"Returns whether this class is the same as *other*.\n\n```\nInt32 == Int32  # => true\nInt32 == String # => false\n```","summary":"<p>Returns whether this class is the same as <em>other</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Class"}],"args_string":"(other : Class) : Bool","args_html":"(other : <a href=\"Class.html\">Class</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/class.cr","line_number":17,"url":null},"def":{"name":"==","args":[{"name":"other","external_name":"other","restriction":"Class"}],"return_type":"Bool","visibility":"Public","body":"crystal_type_id == other.crystal_type_id"},"external_var":false},{"html_id":"===(other)-class-method","name":"===","doc":"Case equality.\n\nThe `===` method is used in a `case ... when ... end` expression.\n\nFor example, this code:\n\n```\ncase value\nwhen x\n  # something when x\nwhen y\n  # something when y\nend\n```\n\nIs equivalent to this code:\n\n```\nif x === value\n  # something when x\nelsif y === value\n  # something when y\nend\n```\n\nObject simply implements `===` by invoking `==`, but subclasses\n(notably `Regex`) can override it to provide meaningful case-equality semantics.","summary":"<p>Case equality.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":""}],"args_string":"(other)","args_html":"(other)","location":{"filename":"src/class.cr","line_number":97,"url":null},"def":{"name":"===","args":[{"name":"other","external_name":"other","restriction":""}],"visibility":"Public","body":"{% if @type == Class %}\n      other.is_a?(Class)\n    {% else %}\n      other.is_a?(self)\n    {% end %}"},"external_var":false},{"html_id":">(other:T.class):BoolforallT-class-method","name":">","doc":"Returns whether *other* inherits or includes `self`.\n\n```\nNumber > Int32  # => true\nNumber > Number # => false\nNumber > Object # => false\n```","summary":"<p>Returns whether <em>other</em> inherits or includes <code>self</code>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"T.class"}],"args_string":"(other : T.class) : Bool forall T","args_html":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) : <a href=\"Bool.html\">Bool</a> forall T","location":{"filename":"src/class.cr","line_number":57,"url":null},"def":{"name":">","args":[{"name":"other","external_name":"other","restriction":"T.class"}],"return_type":"Bool","visibility":"Public","body":"{% @type %}\nother._lt(self)\n"},"external_var":false},{"html_id":">=(other:T.class)forallT-class-method","name":">=","doc":"Returns whether *other* inherits or includes `self`, or is equal\nto `self`.\n\n```\nNumber >= Int32  # => true\nNumber >= Number # => true\nNumber >= Object # => false\n```","summary":"<p>Returns whether <em>other</em> inherits or includes <code>self</code>, or is equal to <code>self</code>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"T.class"}],"args_string":"(other : T.class) forall T","args_html":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) forall T","location":{"filename":"src/class.cr","line_number":71,"url":null},"def":{"name":">=","args":[{"name":"other","external_name":"other","restriction":"T.class"}],"visibility":"Public","body":"{% @type %}\nother._lte(self)\n"},"external_var":false},{"html_id":"|(other:U.class)forallU-class-method","name":"|","doc":"Returns the union type of `self` and *other*.\n\n```\nInt32 | Char # => (Int32 | Char)\n```","summary":"<p>Returns the union type of <code>self</code> and <em>other</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"U.class"}],"args_string":"(other : U.class) forall U","args_html":"(other : <span class=\"t\">U</span>.<span class=\"k\">class</span>) forall U","location":{"filename":"src/class.cr","line_number":140,"url":null},"def":{"name":"|","args":[{"name":"other","external_name":"other","restriction":"U.class"}],"visibility":"Public","body":"t = uninitialized self\nu = uninitialized U\ntypeof(t, u)\n"},"external_var":false},{"html_id":"clone-class-method","name":"clone","abstract":false,"location":{"filename":"src/class.cr","line_number":168,"url":null},"def":{"name":"clone","visibility":"Public","body":"self"},"external_var":false},{"html_id":"dup-class-method","name":"dup","doc":"Returns a shallow copy of this object.\n\nBecause `Value` is a value type, this method returns `self`,\nwhich already involves a shallow copy of this object because\nvalue types are passed by value.","summary":"<p>Returns a shallow copy of this object.</p>","abstract":false,"location":{"filename":"src/class.cr","line_number":164,"url":null},"def":{"name":"dup","visibility":"Public","body":"self"},"external_var":false},{"html_id":"hash(hasher)-class-method","name":"hash","doc":"See `Object#hash(hasher)`","summary":"<p>See <code><a href=\"Object.html#hash%28hasher%29-instance-method\">Object#hash(hasher)</a></code></p>","abstract":false,"args":[{"name":"hasher","external_name":"hasher","restriction":""}],"args_string":"(hasher)","args_html":"(hasher)","location":{"filename":"src/class.cr","line_number":7,"url":null},"def":{"name":"hash","args":[{"name":"hasher","external_name":"hasher","restriction":""}],"visibility":"Public","body":"hasher.class(self)"},"external_var":false},{"html_id":"inspect(io:IO):Nil-class-method","name":"inspect","doc":"Prints to *io* an unambiguous and information-rich string representation of this\nobject, typically intended for developers.\n\nIt is similar to `#to_s(IO)`, but often provides more information. Ideally, it should\ncontain sufficient information to be able to recreate an object with the same value\n(given an identical environment).\n\nFor types that don't provide a custom implementation of this method,\ndefault implementation delegates to `#to_s(IO)`. This said, it is advisable to\nhave an appropriate `#inspect` implementation on every type. Default\nimplementations are provided by `Struct#inspect` and `Reference#inspect`.\n\n`::p` and `::p!` use this method to print an object in `STDOUT`.","summary":"<p>Prints to <em>io</em> an unambiguous and information-rich string representation of this object, typically intended for developers.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/class.cr","line_number":2,"url":null},"def":{"name":"inspect","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"to_s(io)"},"external_var":false},{"html_id":"name:String-class-method","name":"name","doc":"Returns the name of this class.\n\n```\nString.name # => \"String\"\n```","summary":"<p>Returns the name of this class.</p>","abstract":false,"location":{"filename":"src/class.cr","line_number":114,"url":null},"def":{"name":"name","return_type":"String","visibility":"Public","body":"{{ @type.name.stringify }}"},"external_var":false},{"html_id":"nilable?:Bool-class-method","name":"nilable?","doc":"Returns `true` if `nil` is an instance of this type.\n\n```\nInt32.nilable?            # => false\nNil.nilable?              # => true\n(Int32 | String).nilable? # => false\n(Int32 | Nil).nilable?    # => true\nNoReturn.nilable?         # => false\nValue.nilable?            # => true\n```","summary":"<p>Returns <code>true</code> if <code>nil</code> is an instance of this type.</p>","abstract":false,"location":{"filename":"src/class.cr","line_number":156,"url":null},"def":{"name":"nilable?","return_type":"Bool","visibility":"Public","body":"{{ @type >= Nil }}"},"external_var":false},{"html_id":"to_s(io:IO):Nil-class-method","name":"to_s","doc":"Prints a nicely readable and concise string representation of this object,\ntypically intended for users, to *io*.\n\nThis method is called when an object is interpolated in a string literal:\n```\n\"foo #{bar} baz\" # calls bar.to_io with the builder for this string\n```\n\n`IO#<<` calls this method to append an object to itself:\n```\nio << bar # calls bar.to_s(io)\n```\n\nThus implementations must not interpolate `self` in a string literal or call\n`io << self` which both would lead to an endless loop.\n\nAlso see `#inspect(IO)`.","summary":"<p>Prints a nicely readable and concise string representation of this object, typically intended for users, to <em>io</em>.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/class.cr","line_number":160,"url":null},"def":{"name":"to_s","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"io << ({{ @type.name.stringify }})"},"external_var":false}],"constructors":[{"html_id":"cast(other):self-class-method","name":"cast","doc":"Casts *other* to this class.\n\nThis is the same as using `as`, but allows the class to be passed around as\nan argument. See the\n[documentation on as](//crystal-lang.org/docs/syntax_and_semantics/as.html)\nfor more information.\n\n```\nklass = Int32\nnumber = [99, \"str\"][0]\ntypeof(number)             # => (String | Int32)\ntypeof(klass.cast(number)) # => Int32\n```","summary":"<p>Casts <em>other</em> to this class.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":""}],"args_string":"(other) : self","args_html":"(other) : <span class=\"k\">self</span>","location":{"filename":"src/class.cr","line_number":131,"url":null},"def":{"name":"cast","args":[{"name":"other","external_name":"other","restriction":""}],"return_type":"self","visibility":"Public","body":"other.as(self)"},"external_var":false}],"instance_methods":[{"html_id":"<(other:T.class):BoolforallT-instance-method","name":"<","doc":"Returns whether this class inherits or includes *other*.\n\n```\nInt32 < Number  # => true\nInt32 < Value   # => true\nInt32 < Int32   # => false\nInt32 <= String # => false\n```","summary":"<p>Returns whether this class inherits or includes <em>other</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"T.class"}],"args_string":"(other : T.class) : Bool forall T","args_html":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) : <a href=\"Bool.html\">Bool</a> forall T","location":{"filename":"src/class.cr","line_number":29,"url":null},"def":{"name":"<","args":[{"name":"other","external_name":"other","restriction":"T.class"}],"return_type":"Bool","visibility":"Public","body":"{% @type %}\nother._gt(self)\n"},"external_var":false},{"html_id":"<=(other:T.class):BoolforallT-instance-method","name":"<=","doc":"Returns whether this class inherits or includes *other*, or\nis equal to *other*.\n\n```\nInt32 < Number  # => true\nInt32 < Value   # => true\nInt32 <= Int32  # => true\nInt32 <= String # => false\n```","summary":"<p>Returns whether this class inherits or includes <em>other</em>, or is equal to <em>other</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"T.class"}],"args_string":"(other : T.class) : Bool forall T","args_html":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) : <a href=\"Bool.html\">Bool</a> forall T","location":{"filename":"src/class.cr","line_number":44,"url":null},"def":{"name":"<=","args":[{"name":"other","external_name":"other","restriction":"T.class"}],"return_type":"Bool","visibility":"Public","body":"{% @type %}\nother._gte(self)\n"},"external_var":false},{"html_id":"==(other:Class):Bool-instance-method","name":"==","doc":"Returns whether this class is the same as *other*.\n\n```\nInt32 == Int32  # => true\nInt32 == String # => false\n```","summary":"<p>Returns whether this class is the same as <em>other</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Class"}],"args_string":"(other : Class) : Bool","args_html":"(other : <a href=\"Class.html\">Class</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/class.cr","line_number":17,"url":null},"def":{"name":"==","args":[{"name":"other","external_name":"other","restriction":"Class"}],"return_type":"Bool","visibility":"Public","body":"crystal_type_id == other.crystal_type_id"},"external_var":false},{"html_id":"===(other)-instance-method","name":"===","doc":"Case equality.\n\nThe `===` method is used in a `case ... when ... end` expression.\n\nFor example, this code:\n\n```\ncase value\nwhen x\n  # something when x\nwhen y\n  # something when y\nend\n```\n\nIs equivalent to this code:\n\n```\nif x === value\n  # something when x\nelsif y === value\n  # something when y\nend\n```\n\nObject simply implements `===` by invoking `==`, but subclasses\n(notably `Regex`) can override it to provide meaningful case-equality semantics.","summary":"<p>Case equality.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":""}],"args_string":"(other)","args_html":"(other)","location":{"filename":"src/class.cr","line_number":97,"url":null},"def":{"name":"===","args":[{"name":"other","external_name":"other","restriction":""}],"visibility":"Public","body":"{% if @type == Class %}\n      other.is_a?(Class)\n    {% else %}\n      other.is_a?(self)\n    {% end %}"},"external_var":false},{"html_id":">(other:T.class):BoolforallT-instance-method","name":">","doc":"Returns whether *other* inherits or includes `self`.\n\n```\nNumber > Int32  # => true\nNumber > Number # => false\nNumber > Object # => false\n```","summary":"<p>Returns whether <em>other</em> inherits or includes <code>self</code>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"T.class"}],"args_string":"(other : T.class) : Bool forall T","args_html":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) : <a href=\"Bool.html\">Bool</a> forall T","location":{"filename":"src/class.cr","line_number":57,"url":null},"def":{"name":">","args":[{"name":"other","external_name":"other","restriction":"T.class"}],"return_type":"Bool","visibility":"Public","body":"{% @type %}\nother._lt(self)\n"},"external_var":false},{"html_id":">=(other:T.class)forallT-instance-method","name":">=","doc":"Returns whether *other* inherits or includes `self`, or is equal\nto `self`.\n\n```\nNumber >= Int32  # => true\nNumber >= Number # => true\nNumber >= Object # => false\n```","summary":"<p>Returns whether <em>other</em> inherits or includes <code>self</code>, or is equal to <code>self</code>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"T.class"}],"args_string":"(other : T.class) forall T","args_html":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) forall T","location":{"filename":"src/class.cr","line_number":71,"url":null},"def":{"name":">=","args":[{"name":"other","external_name":"other","restriction":"T.class"}],"visibility":"Public","body":"{% @type %}\nother._lte(self)\n"},"external_var":false},{"html_id":"|(other:U.class)forallU-instance-method","name":"|","doc":"Returns the union type of `self` and *other*.\n\n```\nInt32 | Char # => (Int32 | Char)\n```","summary":"<p>Returns the union type of <code>self</code> and <em>other</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"U.class"}],"args_string":"(other : U.class) forall U","args_html":"(other : <span class=\"t\">U</span>.<span class=\"k\">class</span>) forall U","location":{"filename":"src/class.cr","line_number":140,"url":null},"def":{"name":"|","args":[{"name":"other","external_name":"other","restriction":"U.class"}],"visibility":"Public","body":"t = uninitialized self\nu = uninitialized U\ntypeof(t, u)\n"},"external_var":false},{"html_id":"cast(other):self-instance-method","name":"cast","doc":"Casts *other* to this class.\n\nThis is the same as using `as`, but allows the class to be passed around as\nan argument. See the\n[documentation on as](//crystal-lang.org/docs/syntax_and_semantics/as.html)\nfor more information.\n\n```\nklass = Int32\nnumber = [99, \"str\"][0]\ntypeof(number)             # => (String | Int32)\ntypeof(klass.cast(number)) # => Int32\n```","summary":"<p>Casts <em>other</em> to this class.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":""}],"args_string":"(other) : self","args_html":"(other) : <span class=\"k\">self</span>","location":{"filename":"src/class.cr","line_number":131,"url":null},"def":{"name":"cast","args":[{"name":"other","external_name":"other","restriction":""}],"return_type":"self","visibility":"Public","body":"other.as(self)"},"external_var":false},{"html_id":"clone-instance-method","name":"clone","abstract":false,"location":{"filename":"src/class.cr","line_number":168,"url":null},"def":{"name":"clone","visibility":"Public","body":"self"},"external_var":false},{"html_id":"dup-instance-method","name":"dup","doc":"Returns a shallow copy of this object.\n\nBecause `Value` is a value type, this method returns `self`,\nwhich already involves a shallow copy of this object because\nvalue types are passed by value.","summary":"<p>Returns a shallow copy of this object.</p>","abstract":false,"location":{"filename":"src/class.cr","line_number":164,"url":null},"def":{"name":"dup","visibility":"Public","body":"self"},"external_var":false},{"html_id":"hash(hasher)-instance-method","name":"hash","doc":"See `Object#hash(hasher)`","summary":"<p>See <code><a href=\"Object.html#hash%28hasher%29-instance-method\">Object#hash(hasher)</a></code></p>","abstract":false,"args":[{"name":"hasher","external_name":"hasher","restriction":""}],"args_string":"(hasher)","args_html":"(hasher)","location":{"filename":"src/class.cr","line_number":7,"url":null},"def":{"name":"hash","args":[{"name":"hasher","external_name":"hasher","restriction":""}],"visibility":"Public","body":"hasher.class(self)"},"external_var":false},{"html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Prints to *io* an unambiguous and information-rich string representation of this\nobject, typically intended for developers.\n\nIt is similar to `#to_s(IO)`, but often provides more information. Ideally, it should\ncontain sufficient information to be able to recreate an object with the same value\n(given an identical environment).\n\nFor types that don't provide a custom implementation of this method,\ndefault implementation delegates to `#to_s(IO)`. This said, it is advisable to\nhave an appropriate `#inspect` implementation on every type. Default\nimplementations are provided by `Struct#inspect` and `Reference#inspect`.\n\n`::p` and `::p!` use this method to print an object in `STDOUT`.","summary":"<p>Prints to <em>io</em> an unambiguous and information-rich string representation of this object, typically intended for developers.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/class.cr","line_number":2,"url":null},"def":{"name":"inspect","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"to_s(io)"},"external_var":false},{"html_id":"name:String-instance-method","name":"name","doc":"Returns the name of this class.\n\n```\nString.name # => \"String\"\n```","summary":"<p>Returns the name of this class.</p>","abstract":false,"location":{"filename":"src/class.cr","line_number":114,"url":null},"def":{"name":"name","return_type":"String","visibility":"Public","body":"{{ @type.name.stringify }}"},"external_var":false},{"html_id":"nilable?:Bool-instance-method","name":"nilable?","doc":"Returns `true` if `nil` is an instance of this type.\n\n```\nInt32.nilable?            # => false\nNil.nilable?              # => true\n(Int32 | String).nilable? # => false\n(Int32 | Nil).nilable?    # => true\nNoReturn.nilable?         # => false\nValue.nilable?            # => true\n```","summary":"<p>Returns <code>true</code> if <code>nil</code> is an instance of this type.</p>","abstract":false,"location":{"filename":"src/class.cr","line_number":156,"url":null},"def":{"name":"nilable?","return_type":"Bool","visibility":"Public","body":"{{ @type >= Nil }}"},"external_var":false},{"html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Prints a nicely readable and concise string representation of this object,\ntypically intended for users, to *io*.\n\nThis method is called when an object is interpolated in a string literal:\n```\n\"foo #{bar} baz\" # calls bar.to_io with the builder for this string\n```\n\n`IO#<<` calls this method to append an object to itself:\n```\nio << bar # calls bar.to_s(io)\n```\n\nThus implementations must not interpolate `self` in a string literal or call\n`io << self` which both would lead to an endless loop.\n\nAlso see `#inspect(IO)`.","summary":"<p>Prints a nicely readable and concise string representation of this object, typically intended for users, to <em>io</em>.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/class.cr","line_number":160,"url":null},"def":{"name":"to_s","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"io << ({{ @type.name.stringify }})"},"external_var":false}]},{"html_id":"Crystal/Colorize","path":"Colorize.html","kind":"module","full_name":"Colorize","name":"Colorize","abstract":false,"locations":[{"filename":"src/colorize.cr","line_number":119,"url":null},{"filename":"src/colorize.cr","line_number":221,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"doc":"With `Colorize` you can change the fore- and background colors and text decorations when rendering text\non terminals supporting ANSI escape codes. It adds the `colorize` method to `Object` and thus all classes\nas its main interface, which calls `to_s` and surrounds it with the necessary escape codes\nwhen it comes to obtaining a string representation of the object.\n\nNOTE: To use `Colorize`, you must explicitly import it with `require \"colorize\"`\n\nIts first argument changes the foreground color:\n\n```\nrequire \"colorize\"\n\n\"foo\".colorize(:green)\n100.colorize(:red)\n[1, 2, 3].colorize(:blue)\n```\n\nThere are alternative ways to change the foreground color:\n\n```\nrequire \"colorize\"\n\n\"foo\".colorize.fore(:green)\n\"foo\".colorize.green\n```\n\nTo change the background color, the following methods are available:\n\n```\nrequire \"colorize\"\n\n\"foo\".colorize.back(:green)\n\"foo\".colorize.on(:green)\n\"foo\".colorize.on_green\n```\n\nYou can also pass an RGB color to `colorize`:\n\n```\nrequire \"colorize\"\n\n\"foo\".colorize(0, 255, 255)      # => \"foo\" in aqua\n\"foo\".colorize.fore(0, 255, 255) # => \"foo\" in aqua\n\n# This is the same as:\n\n\"foo\".colorize(Colorize::ColorRGB.new(0, 255, 255))      # => \"foo\" in aqua\n\"foo\".colorize.fore(Colorize::ColorRGB.new(0, 255, 255)) # => \"foo\" in aqua\n```\n\nOr an 8-bit color:\n\n```\nrequire \"colorize\"\n\n\"foo\".colorize(Colorize::Color256.new(208))      # => \"foo\" in orange\n\"foo\".colorize.fore(Colorize::Color256.new(208)) # => \"foo\" in orange\n```\n\nIt's also possible to change the text decoration:\n\n```\nrequire \"colorize\"\n\n\"foo\".colorize.mode(:underline)\n\"foo\".colorize.underline\n```\n\nThe `colorize` method returns a `Colorize::Object` instance,\nwhich allows chaining methods together:\n\n```\nrequire \"colorize\"\n\n\"foo\".colorize.fore(:yellow).back(:blue).mode(:underline)\n```\n\nWith the `toggle` method you can temporarily disable adding the escape codes.\nSettings of the instance are preserved however and can be turned back on later:\n\n```\nrequire \"colorize\"\n\n\"foo\".colorize(:red).toggle(false)              # => \"foo\" without color\n\"foo\".colorize(:red).toggle(false).toggle(true) # => \"foo\" in red\n```\n\nThe color `:default` leaves the object's representation as it is but the object is a `Colorize::Object` then\nwhich is handy in conditions such as:\n\n```\nrequire \"colorize\"\n\n\"foo\".colorize(Random.next_bool ? :green : :default)\n```\n\nAvailable colors are:\n```\n:default\n:black\n:red\n:green\n:yellow\n:blue\n:magenta\n:cyan\n:light_gray\n:dark_gray\n:light_red\n:light_green\n:light_yellow\n:light_blue\n:light_magenta\n:light_cyan\n:white\n```\n\nSee `Colorize::Mode` for available text decorations.","summary":"<p>With <code><a href=\"Colorize.html\">Colorize</a></code> you can change the fore- and background colors and text decorations when rendering text on terminals supporting ANSI escape codes.</p>","class_methods":[{"html_id":"default_enabled?(stdout:IO,stderr:IO=stdout):Bool-class-method","name":"default_enabled?","doc":"Returns whether colorization should be enabled by default on the given\nstandard output and error streams.\n\nThis is true if both streams are terminals (i.e. `IO#tty?` returns true),\nthe `TERM` environment variable is not equal to `dumb`, and the\n[`NO_COLOR` environment variable](https://no-color.org) is not set to a\nnon-empty string.","summary":"<p>Returns whether colorization should be enabled by default on the given standard output and error streams.</p>","abstract":false,"args":[{"name":"stdout","external_name":"stdout","restriction":"IO"},{"name":"stderr","default_value":"stdout","external_name":"stderr","restriction":"IO"}],"args_string":"(stdout : IO, stderr : IO = stdout) : Bool","args_html":"(stdout : <a href=\"IO.html\">IO</a>, stderr : <a href=\"IO.html\">IO</a> = stdout) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/colorize.cr","line_number":155,"url":null},"def":{"name":"default_enabled?","args":[{"name":"stdout","external_name":"stdout","restriction":"IO"},{"name":"stderr","default_value":"stdout","external_name":"stderr","restriction":"IO"}],"return_type":"Bool","visibility":"Public","body":"(\n  (stdout.tty? && ((stderr == stdout) || stderr.tty?)) &&\n  (ENV[\"TERM\"]? != \"dumb\")\n) && !ENV[\"NO_COLOR\"]?.try() do |__arg0| !__arg0.empty? end"},"external_var":false},{"html_id":"enabled=(enabled:Bool)-class-method","name":"enabled=","doc":"Objects will only be colored if this is `true`, unless overridden by\n`Colorize::Object#toggle`.\n\n```\nrequire \"colorize\"\n\nColorize.enabled = true\n\"hello\".colorize.red.to_s # => \"\\e[31mhello\\e[0m\"\n\nColorize.enabled = false\n\"hello\".colorize.red.to_s # => \"hello\"\n```\n\nNOTE: This is by default enabled if `.default_enabled?` is true for `STDOUT`\nand `STDERR`.","summary":"<p>Objects will only be colored if this is <code>true</code>, unless overridden by <code><a href=\"Colorize/Object.html#toggle%28flag%29-instance-method\">Colorize::Object#toggle</a></code>.</p>","abstract":false,"args":[{"name":"enabled","external_name":"enabled","restriction":"Bool"}],"args_string":"(enabled : Bool)","args_html":"(enabled : <a href=\"Bool.html\">Bool</a>)","location":{"filename":"src/colorize.cr","line_number":135,"url":null},"def":{"name":"enabled=","args":[{"name":"enabled","external_name":"enabled","restriction":"Bool"}],"visibility":"Public","body":"@@enabled = enabled"},"external_var":false},{"html_id":"enabled?:Bool-class-method","name":"enabled?","doc":"Objects will only be colored if this is `true`, unless overridden by\n`Colorize::Object#toggle`.\n\n```\nrequire \"colorize\"\n\nColorize.enabled = true\n\"hello\".colorize.red.to_s # => \"\\e[31mhello\\e[0m\"\n\nColorize.enabled = false\n\"hello\".colorize.red.to_s # => \"hello\"\n```\n\nNOTE: This is by default enabled if `.default_enabled?` is true for `STDOUT`\nand `STDERR`.","summary":"<p>Objects will only be colored if this is <code>true</code>, unless overridden by <code><a href=\"Colorize/Object.html#toggle%28flag%29-instance-method\">Colorize::Object#toggle</a></code>.</p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":135,"url":null},"def":{"name":"enabled?","return_type":"Bool","visibility":"Public","body":"if (__temp_105 = @@enabled).nil?\n  @@enabled = (default_enabled?(STDOUT, STDERR))\nelse\n  __temp_105\nend"},"external_var":false},{"html_id":"on_tty_only!:Bool-class-method","name":"on_tty_only!","doc":"Resets `Colorize.enabled?` to its initial default value, i.e. whether\n`.default_enabled?` is true for `STDOUT` and `STDERR`. Returns this new\nvalue.\n\nThis can be used to revert `Colorize.enabled?` to its initial state after\ncolorization is explicitly enabled or disabled.","summary":"<p>Resets <code><a href=\"Colorize.html#enabled%3F%3ABool-class-method\">Colorize.enabled?</a></code> to its initial default value, i.e.</p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":143,"url":null},"def":{"name":"on_tty_only!","return_type":"Bool","visibility":"Public","body":"@@enabled = nil\nenabled?\n"},"external_var":false},{"html_id":"reset(io=STDOUT)-class-method","name":"reset","doc":"Resets the color and text decoration of the *io*.\n\n```\nio = IO::Memory.new\nColorize.with.green.surround(io) do\n  io << \"green\"\n  Colorize.reset(io)\n  io << \" default\"\nend\n```","summary":"<p>Resets the color and text decoration of the <em>io</em>.</p>","abstract":false,"args":[{"name":"io","default_value":"STDOUT","external_name":"io","restriction":""}],"args_string":"(io = STDOUT)","args_html":"(io = <span class=\"t\">STDOUT</span>)","location":{"filename":"src/colorize.cr","line_number":170,"url":null},"def":{"name":"reset","args":[{"name":"io","default_value":"STDOUT","external_name":"io","restriction":""}],"visibility":"Public","body":"if enabled?\n  io << \"\\e[0m\"\nend"},"external_var":false},{"html_id":"with:Colorize::Object(String)-class-method","name":"with","doc":"Helper method to use colorize with `IO`.\n\n```\nio = IO::Memory.new\nio << \"not-green\"\nColorize.with.green.bold.surround(io) do\n  io << \"green and bold if Colorize.enabled\"\nend\n```","summary":"<p>Helper method to use colorize with <code><a href=\"IO.html\">IO</a></code>.</p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":183,"url":null},"def":{"name":"with","return_type":"Colorize::Object(String)","visibility":"Public","body":"\"\".colorize"},"external_var":false}],"types":[{"html_id":"Crystal/Colorize/Color","path":"Colorize/Color.html","kind":"alias","full_name":"Colorize::Color","name":"Color","abstract":false,"locations":[{"filename":"src/colorize.cr","line_number":222,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":true,"aliased":"(Colorize::Color256 | Colorize::ColorANSI | Colorize::ColorRGB)","aliased_html":"<a href=\"../Colorize/Color256.html\">Colorize::Color256</a> | <a href=\"../Colorize/ColorANSI.html\">Colorize::ColorANSI</a> | <a href=\"../Colorize/ColorRGB.html\">Colorize::ColorRGB</a>","const":false,"namespace":{"html_id":"Crystal/Colorize","kind":"module","full_name":"Colorize","name":"Colorize"}},{"html_id":"Crystal/Colorize/Color256","path":"Colorize/Color256.html","kind":"struct","full_name":"Colorize::Color256","name":"Color256","abstract":false,"superclass":{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},"ancestors":[{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/colorize.cr","line_number":254,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"namespace":{"html_id":"Crystal/Colorize","kind":"module","full_name":"Colorize","name":"Colorize"},"doc":"An 8-bit color.","summary":"<p>An 8-bit color.</p>","constructors":[{"html_id":"new(value:UInt8)-class-method","name":"new","abstract":false,"args":[{"name":"value","external_name":"value","restriction":"UInt8"}],"args_string":"(value : UInt8)","args_html":"(value : <a href=\"../UInt8.html\">UInt8</a>)","location":{"filename":"src/colorize.cr","line_number":254,"url":null},"def":{"name":"new","args":[{"name":"value","external_name":"value","restriction":"UInt8"}],"visibility":"Public","body":"_ = allocate\n_.initialize(value)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false}],"instance_methods":[{"html_id":"back(io:IO):Nil-instance-method","name":"back","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"../IO.html\">IO</a>) : <a href=\"../Nil.html\">Nil</a>","location":{"filename":"src/colorize.cr","line_number":261,"url":null},"def":{"name":"back","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"io << \"48;5;\"\nvalue.to_s(io)\n"},"external_var":false},{"html_id":"clone-instance-method","name":"clone","abstract":false,"location":{"filename":"src/colorize.cr","line_number":254,"url":null},"def":{"name":"clone","visibility":"Public","body":"self.class.new(@value.clone)"},"external_var":false},{"html_id":"copy_with(value_value=@value)-instance-method","name":"copy_with","abstract":false,"args":[{"name":"_value","default_value":"@value","external_name":"value","restriction":""}],"args_string":"(value _value = @value)","args_html":"(value _value = @value)","location":{"filename":"src/colorize.cr","line_number":254,"url":null},"def":{"name":"copy_with","args":[{"name":"_value","default_value":"@value","external_name":"value","restriction":""}],"visibility":"Public","body":"self.class.new(_value)"},"external_var":false},{"html_id":"fore(io:IO):Nil-instance-method","name":"fore","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"../IO.html\">IO</a>) : <a href=\"../Nil.html\">Nil</a>","location":{"filename":"src/colorize.cr","line_number":256,"url":null},"def":{"name":"fore","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"io << \"38;5;\"\nvalue.to_s(io)\n"},"external_var":false},{"html_id":"value:UInt8-instance-method","name":"value","abstract":false,"def":{"name":"value","return_type":"UInt8","visibility":"Public","body":"@value"},"external_var":false}]},{"html_id":"Crystal/Colorize/ColorANSI","path":"Colorize/ColorANSI.html","kind":"enum","full_name":"Colorize::ColorANSI","name":"ColorANSI","abstract":false,"ancestors":[{"html_id":"Crystal/Enum","kind":"struct","full_name":"Enum","name":"Enum"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/colorize.cr","line_number":225,"url":null}],"repository_name":"Crystal","program":false,"enum":true,"alias":false,"const":false,"constants":[{"id":"Default","name":"Default","value":"39"},{"id":"Black","name":"Black","value":"30"},{"id":"Red","name":"Red","value":"31"},{"id":"Green","name":"Green","value":"32"},{"id":"Yellow","name":"Yellow","value":"33"},{"id":"Blue","name":"Blue","value":"34"},{"id":"Magenta","name":"Magenta","value":"35"},{"id":"Cyan","name":"Cyan","value":"36"},{"id":"LightGray","name":"LightGray","value":"37"},{"id":"DarkGray","name":"DarkGray","value":"90"},{"id":"LightRed","name":"LightRed","value":"91"},{"id":"LightGreen","name":"LightGreen","value":"92"},{"id":"LightYellow","name":"LightYellow","value":"93"},{"id":"LightBlue","name":"LightBlue","value":"94"},{"id":"LightMagenta","name":"LightMagenta","value":"95"},{"id":"LightCyan","name":"LightCyan","value":"96"},{"id":"White","name":"White","value":"97"}],"namespace":{"html_id":"Crystal/Colorize","kind":"module","full_name":"Colorize","name":"Colorize"},"doc":"One color of a fixed set of colors.","summary":"<p>One color of a fixed set of colors.</p>","instance_methods":[{"html_id":"back(io:IO):Nil-instance-method","name":"back","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"../IO.html\">IO</a>) : <a href=\"../Nil.html\">Nil</a>","location":{"filename":"src/colorize.cr","line_number":248,"url":null},"def":{"name":"back","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"(to_i + 10).to_s(io)"},"external_var":false},{"html_id":"black?-instance-method","name":"black?","doc":"Returns `true` if this enum value equals `Black`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../Colorize/ColorANSI.html#Black\">Black</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":227,"url":null},"def":{"name":"black?","visibility":"Public","body":"self == Black"},"external_var":false},{"html_id":"blue?-instance-method","name":"blue?","doc":"Returns `true` if this enum value equals `Blue`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../Colorize/ColorANSI.html#Blue\">Blue</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":231,"url":null},"def":{"name":"blue?","visibility":"Public","body":"self == Blue"},"external_var":false},{"html_id":"cyan?-instance-method","name":"cyan?","doc":"Returns `true` if this enum value equals `Cyan`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../Colorize/ColorANSI.html#Cyan\">Cyan</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":233,"url":null},"def":{"name":"cyan?","visibility":"Public","body":"self == Cyan"},"external_var":false},{"html_id":"dark_gray?-instance-method","name":"dark_gray?","doc":"Returns `true` if this enum value equals `DarkGray`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../Colorize/ColorANSI.html#DarkGray\">DarkGray</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":235,"url":null},"def":{"name":"dark_gray?","visibility":"Public","body":"self == DarkGray"},"external_var":false},{"html_id":"default?-instance-method","name":"default?","doc":"Returns `true` if this enum value equals `Default`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../Colorize/ColorANSI.html#Default\">Default</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":226,"url":null},"def":{"name":"default?","visibility":"Public","body":"self == Default"},"external_var":false},{"html_id":"fore(io:IO):Nil-instance-method","name":"fore","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"../IO.html\">IO</a>) : <a href=\"../Nil.html\">Nil</a>","location":{"filename":"src/colorize.cr","line_number":244,"url":null},"def":{"name":"fore","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"to_i.to_s(io)"},"external_var":false},{"html_id":"green?-instance-method","name":"green?","doc":"Returns `true` if this enum value equals `Green`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../Colorize/ColorANSI.html#Green\">Green</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":229,"url":null},"def":{"name":"green?","visibility":"Public","body":"self == Green"},"external_var":false},{"html_id":"light_blue?-instance-method","name":"light_blue?","doc":"Returns `true` if this enum value equals `LightBlue`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../Colorize/ColorANSI.html#LightBlue\">LightBlue</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":239,"url":null},"def":{"name":"light_blue?","visibility":"Public","body":"self == LightBlue"},"external_var":false},{"html_id":"light_cyan?-instance-method","name":"light_cyan?","doc":"Returns `true` if this enum value equals `LightCyan`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../Colorize/ColorANSI.html#LightCyan\">LightCyan</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":241,"url":null},"def":{"name":"light_cyan?","visibility":"Public","body":"self == LightCyan"},"external_var":false},{"html_id":"light_gray?-instance-method","name":"light_gray?","doc":"Returns `true` if this enum value equals `LightGray`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../Colorize/ColorANSI.html#LightGray\">LightGray</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":234,"url":null},"def":{"name":"light_gray?","visibility":"Public","body":"self == LightGray"},"external_var":false},{"html_id":"light_green?-instance-method","name":"light_green?","doc":"Returns `true` if this enum value equals `LightGreen`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../Colorize/ColorANSI.html#LightGreen\">LightGreen</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":237,"url":null},"def":{"name":"light_green?","visibility":"Public","body":"self == LightGreen"},"external_var":false},{"html_id":"light_magenta?-instance-method","name":"light_magenta?","doc":"Returns `true` if this enum value equals `LightMagenta`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../Colorize/ColorANSI.html#LightMagenta\">LightMagenta</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":240,"url":null},"def":{"name":"light_magenta?","visibility":"Public","body":"self == LightMagenta"},"external_var":false},{"html_id":"light_red?-instance-method","name":"light_red?","doc":"Returns `true` if this enum value equals `LightRed`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../Colorize/ColorANSI.html#LightRed\">LightRed</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":236,"url":null},"def":{"name":"light_red?","visibility":"Public","body":"self == LightRed"},"external_var":false},{"html_id":"light_yellow?-instance-method","name":"light_yellow?","doc":"Returns `true` if this enum value equals `LightYellow`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../Colorize/ColorANSI.html#LightYellow\">LightYellow</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":238,"url":null},"def":{"name":"light_yellow?","visibility":"Public","body":"self == LightYellow"},"external_var":false},{"html_id":"magenta?-instance-method","name":"magenta?","doc":"Returns `true` if this enum value equals `Magenta`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../Colorize/ColorANSI.html#Magenta\">Magenta</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":232,"url":null},"def":{"name":"magenta?","visibility":"Public","body":"self == Magenta"},"external_var":false},{"html_id":"red?-instance-method","name":"red?","doc":"Returns `true` if this enum value equals `Red`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../Colorize/ColorANSI.html#Red\">Red</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":228,"url":null},"def":{"name":"red?","visibility":"Public","body":"self == Red"},"external_var":false},{"html_id":"white?-instance-method","name":"white?","doc":"Returns `true` if this enum value equals `White`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../Colorize/ColorANSI.html#White\">White</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":242,"url":null},"def":{"name":"white?","visibility":"Public","body":"self == White"},"external_var":false},{"html_id":"yellow?-instance-method","name":"yellow?","doc":"Returns `true` if this enum value equals `Yellow`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../Colorize/ColorANSI.html#Yellow\">Yellow</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":230,"url":null},"def":{"name":"yellow?","visibility":"Public","body":"self == Yellow"},"external_var":false}]},{"html_id":"Crystal/Colorize/ColorRGB","path":"Colorize/ColorRGB.html","kind":"struct","full_name":"Colorize::ColorRGB","name":"ColorRGB","abstract":false,"superclass":{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},"ancestors":[{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/colorize.cr","line_number":268,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"namespace":{"html_id":"Crystal/Colorize","kind":"module","full_name":"Colorize","name":"Colorize"},"doc":"An RGB color.","summary":"<p>An RGB color.</p>","constructors":[{"html_id":"new(red:UInt8,green:UInt8,blue:UInt8)-class-method","name":"new","abstract":false,"args":[{"name":"red","external_name":"red","restriction":"UInt8"},{"name":"green","external_name":"green","restriction":"UInt8"},{"name":"blue","external_name":"blue","restriction":"UInt8"}],"args_string":"(red : UInt8, green : UInt8, blue : UInt8)","args_html":"(red : <a href=\"../UInt8.html\">UInt8</a>, green : <a href=\"../UInt8.html\">UInt8</a>, blue : <a href=\"../UInt8.html\">UInt8</a>)","location":{"filename":"src/colorize.cr","line_number":268,"url":null},"def":{"name":"new","args":[{"name":"red","external_name":"red","restriction":"UInt8"},{"name":"green","external_name":"green","restriction":"UInt8"},{"name":"blue","external_name":"blue","restriction":"UInt8"}],"visibility":"Public","body":"_ = allocate\n_.initialize(red, green, blue)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false}],"instance_methods":[{"html_id":"back(io:IO):Nil-instance-method","name":"back","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"../IO.html\">IO</a>) : <a href=\"../Nil.html\">Nil</a>","location":{"filename":"src/colorize.cr","line_number":279,"url":null},"def":{"name":"back","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"io << \"48;2;\"\n(io << red) << \";\"\n(io << green) << \";\"\nio << blue\n"},"external_var":false},{"html_id":"blue:UInt8-instance-method","name":"blue","abstract":false,"def":{"name":"blue","return_type":"UInt8","visibility":"Public","body":"@blue"},"external_var":false},{"html_id":"clone-instance-method","name":"clone","abstract":false,"location":{"filename":"src/colorize.cr","line_number":268,"url":null},"def":{"name":"clone","visibility":"Public","body":"self.class.new(@red.clone, @green.clone, @blue.clone)"},"external_var":false},{"html_id":"copy_with(red_red=@red,green_green=@green,blue_blue=@blue)-instance-method","name":"copy_with","abstract":false,"args":[{"name":"_red","default_value":"@red","external_name":"red","restriction":""},{"name":"_green","default_value":"@green","external_name":"green","restriction":""},{"name":"_blue","default_value":"@blue","external_name":"blue","restriction":""}],"args_string":"(red _red = @red, green _green = @green, blue _blue = @blue)","args_html":"(red _red = @red, green _green = @green, blue _blue = @blue)","location":{"filename":"src/colorize.cr","line_number":268,"url":null},"def":{"name":"copy_with","args":[{"name":"_red","default_value":"@red","external_name":"red","restriction":""},{"name":"_green","default_value":"@green","external_name":"green","restriction":""},{"name":"_blue","default_value":"@blue","external_name":"blue","restriction":""}],"visibility":"Public","body":"self.class.new(_red, _green, _blue)"},"external_var":false},{"html_id":"fore(io:IO):Nil-instance-method","name":"fore","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"../IO.html\">IO</a>) : <a href=\"../Nil.html\">Nil</a>","location":{"filename":"src/colorize.cr","line_number":272,"url":null},"def":{"name":"fore","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"io << \"38;2;\"\n(io << red) << \";\"\n(io << green) << \";\"\nio << blue\n"},"external_var":false},{"html_id":"green:UInt8-instance-method","name":"green","abstract":false,"def":{"name":"green","return_type":"UInt8","visibility":"Public","body":"@green"},"external_var":false},{"html_id":"red:UInt8-instance-method","name":"red","abstract":false,"def":{"name":"red","return_type":"UInt8","visibility":"Public","body":"@red"},"external_var":false}]},{"html_id":"Crystal/Colorize/Mode","path":"Colorize/Mode.html","kind":"enum","full_name":"Colorize::Mode","name":"Mode","abstract":false,"ancestors":[{"html_id":"Crystal/Enum","kind":"struct","full_name":"Enum","name":"Enum"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/colorize.cr","line_number":292,"url":null}],"repository_name":"Crystal","program":false,"enum":true,"alias":false,"const":false,"constants":[{"id":"Bold","name":"Bold","value":"1","doc":"Makes the text bold.\n\nSame as `Bright`.","summary":"<p>Makes the text bold.</p>"},{"id":"Bright","name":"Bright","value":"1","doc":"Makes the text color bright.\n\nSame as `Bold`.","summary":"<p>Makes the text color bright.</p>"},{"id":"Dim","name":"Dim","value":"2","doc":"Dims the text color.","summary":"<p>Dims the text color.</p>"},{"id":"Underline","name":"Underline","value":"4","doc":"Draws a line below the text.","summary":"<p>Draws a line below the text.</p>"},{"id":"Blink","name":"Blink","value":"8","doc":"Makes the text blink slowly.","summary":"<p>Makes the text blink slowly.</p>"},{"id":"Reverse","name":"Reverse","value":"16","doc":"Swaps the foreground and background colors of the text.","summary":"<p>Swaps the foreground and background colors of the text.</p>"},{"id":"Hidden","name":"Hidden","value":"32","doc":"Makes the text invisible.","summary":"<p>Makes the text invisible.</p>"},{"id":"Italic","name":"Italic","value":"64","doc":"Italicizes the text.","summary":"<p>Italicizes the text.</p>"},{"id":"BlinkFast","name":"BlinkFast","value":"128","doc":"Makes the text blink quickly.","summary":"<p>Makes the text blink quickly.</p>"},{"id":"Strikethrough","name":"Strikethrough","value":"256","doc":"Crosses out the text.","summary":"<p>Crosses out the text.</p>"},{"id":"DoubleUnderline","name":"DoubleUnderline","value":"512","doc":"Draws two lines below the text.","summary":"<p>Draws two lines below the text.</p>"},{"id":"Overline","name":"Overline","value":"1024","doc":"Draws a line above the text.","summary":"<p>Draws a line above the text.</p>"},{"id":"None","name":"None","value":"0"},{"id":"All","name":"All","value":"2047"}],"namespace":{"html_id":"Crystal/Colorize","kind":"module","full_name":"Colorize","name":"Colorize"},"doc":"A text decoration.\n\nNote that not all text decorations are supported in all terminals.\nWhen a text decoration is not supported, it will leave the text unaffected.","summary":"<p>A text decoration.</p>","instance_methods":[{"html_id":"blink?-instance-method","name":"blink?","doc":"Returns `true` if this enum value contains `Blink`","summary":"<p>Returns <code>true</code> if this enum value contains <code><a href=\"../Colorize/Mode.html#Blink\">Blink</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":306,"url":null},"def":{"name":"blink?","visibility":"Public","body":"self.includes?(Blink)"},"external_var":false},{"html_id":"blink_fast?-instance-method","name":"blink_fast?","doc":"Returns `true` if this enum value contains `BlinkFast`","summary":"<p>Returns <code>true</code> if this enum value contains <code><a href=\"../Colorize/Mode.html#BlinkFast\">BlinkFast</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":314,"url":null},"def":{"name":"blink_fast?","visibility":"Public","body":"self.includes?(BlinkFast)"},"external_var":false},{"html_id":"bold?-instance-method","name":"bold?","doc":"Returns `true` if this enum value contains `Bold`","summary":"<p>Returns <code>true</code> if this enum value contains <code><a href=\"../Colorize/Mode.html#Bold\">Bold</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":296,"url":null},"def":{"name":"bold?","visibility":"Public","body":"self.includes?(Bold)"},"external_var":false},{"html_id":"bright?-instance-method","name":"bright?","doc":"Returns `true` if this enum value contains `Bright`","summary":"<p>Returns <code>true</code> if this enum value contains <code><a href=\"../Colorize/Mode.html#Bright\">Bright</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":300,"url":null},"def":{"name":"bright?","visibility":"Public","body":"self.includes?(Bright)"},"external_var":false},{"html_id":"dim?-instance-method","name":"dim?","doc":"Returns `true` if this enum value contains `Dim`","summary":"<p>Returns <code>true</code> if this enum value contains <code><a href=\"../Colorize/Mode.html#Dim\">Dim</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":302,"url":null},"def":{"name":"dim?","visibility":"Public","body":"self.includes?(Dim)"},"external_var":false},{"html_id":"double_underline?-instance-method","name":"double_underline?","doc":"Returns `true` if this enum value contains `DoubleUnderline`","summary":"<p>Returns <code>true</code> if this enum value contains <code><a href=\"../Colorize/Mode.html#DoubleUnderline\">DoubleUnderline</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":318,"url":null},"def":{"name":"double_underline?","visibility":"Public","body":"self.includes?(DoubleUnderline)"},"external_var":false},{"html_id":"hidden?-instance-method","name":"hidden?","doc":"Returns `true` if this enum value contains `Hidden`","summary":"<p>Returns <code>true</code> if this enum value contains <code><a href=\"../Colorize/Mode.html#Hidden\">Hidden</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":310,"url":null},"def":{"name":"hidden?","visibility":"Public","body":"self.includes?(Hidden)"},"external_var":false},{"html_id":"italic?-instance-method","name":"italic?","doc":"Returns `true` if this enum value contains `Italic`","summary":"<p>Returns <code>true</code> if this enum value contains <code><a href=\"../Colorize/Mode.html#Italic\">Italic</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":312,"url":null},"def":{"name":"italic?","visibility":"Public","body":"self.includes?(Italic)"},"external_var":false},{"html_id":"none?-instance-method","name":"none?","abstract":false,"location":{"filename":"src/colorize.cr","line_number":292,"url":null},"def":{"name":"none?","visibility":"Public","body":"value == 0"},"external_var":false},{"html_id":"overline?-instance-method","name":"overline?","doc":"Returns `true` if this enum value contains `Overline`","summary":"<p>Returns <code>true</code> if this enum value contains <code><a href=\"../Colorize/Mode.html#Overline\">Overline</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":320,"url":null},"def":{"name":"overline?","visibility":"Public","body":"self.includes?(Overline)"},"external_var":false},{"html_id":"reverse?-instance-method","name":"reverse?","doc":"Returns `true` if this enum value contains `Reverse`","summary":"<p>Returns <code>true</code> if this enum value contains <code><a href=\"../Colorize/Mode.html#Reverse\">Reverse</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":308,"url":null},"def":{"name":"reverse?","visibility":"Public","body":"self.includes?(Reverse)"},"external_var":false},{"html_id":"strikethrough?-instance-method","name":"strikethrough?","doc":"Returns `true` if this enum value contains `Strikethrough`","summary":"<p>Returns <code>true</code> if this enum value contains <code><a href=\"../Colorize/Mode.html#Strikethrough\">Strikethrough</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":316,"url":null},"def":{"name":"strikethrough?","visibility":"Public","body":"self.includes?(Strikethrough)"},"external_var":false},{"html_id":"underline?-instance-method","name":"underline?","doc":"Returns `true` if this enum value contains `Underline`","summary":"<p>Returns <code>true</code> if this enum value contains <code><a href=\"../Colorize/Mode.html#Underline\">Underline</a></code></p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":304,"url":null},"def":{"name":"underline?","visibility":"Public","body":"self.includes?(Underline)"},"external_var":false}]},{"html_id":"Crystal/Colorize/Object","path":"Colorize/Object.html","kind":"struct","full_name":"Colorize::Object(T)","name":"Object","abstract":false,"superclass":{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},"ancestors":[{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/colorize.cr","line_number":353,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"namespace":{"html_id":"Crystal/Colorize","kind":"module","full_name":"Colorize","name":"Colorize"},"doc":"A colorized object. Colors and text decorations can be modified.","summary":"<p>A colorized object.</p>","constructors":[{"html_id":"new(object:T)-class-method","name":"new","abstract":false,"args":[{"name":"object","external_name":"object","restriction":"T"}],"args_string":"(object : T)","args_html":"(object : T)","location":{"filename":"src/colorize.cr","line_number":359,"url":null},"def":{"name":"new","args":[{"name":"object","external_name":"object","restriction":"T"}],"visibility":"Public","body":"_ = Object(T).allocate\n_.initialize(object)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false}],"instance_methods":[{"html_id":"ansi_escape(io:IO):Nil-instance-method","name":"ansi_escape","doc":"Same as `ansi_escape` but writes to a given *io*.","summary":"<p>Same as <code><a href=\"../Colorize/Object.html#ansi_escape%3AString-instance-method\">#ansi_escape</a></code> but writes to a given <em>io</em>.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"../IO.html\">IO</a>) : <a href=\"../Nil.html\">Nil</a>","location":{"filename":"src/colorize.cr","line_number":509,"url":null},"def":{"name":"ansi_escape","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"self.class.ansi_escape(io, to_named_tuple)"},"external_var":false},{"html_id":"ansi_escape:String-instance-method","name":"ansi_escape","doc":"Prints the ANSI escape codes for an object. Note that this has no effect on a `Colorize::Object` with content,\nonly the escape codes.\n\n```\nrequire \"colorize\"\n\nColorize.with.red.ansi_escape        # => \"\\e[31m\"\n\"hello world\".green.bold.ansi_escape # => \"\\e[32;1m\"\n```","summary":"<p>Prints the ANSI escape codes for an object.</p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":502,"url":null},"def":{"name":"ansi_escape","return_type":"String","visibility":"Public","body":"String.build do |io|\n  ansi_escape(io)\nend"},"external_var":false},{"html_id":"back(r:UInt8,g:UInt8,b:UInt8)-instance-method","name":"back","abstract":false,"args":[{"name":"r","external_name":"r","restriction":"UInt8"},{"name":"g","external_name":"g","restriction":"UInt8"},{"name":"b","external_name":"b","restriction":"UInt8"}],"args_string":"(r : UInt8, g : UInt8, b : UInt8)","args_html":"(r : <a href=\"../UInt8.html\">UInt8</a>, g : <a href=\"../UInt8.html\">UInt8</a>, b : <a href=\"../UInt8.html\">UInt8</a>)","location":{"filename":"src/colorize.cr","line_number":430,"url":null},"def":{"name":"back","args":[{"name":"r","external_name":"r","restriction":"UInt8"},{"name":"g","external_name":"g","restriction":"UInt8"},{"name":"b","external_name":"b","restriction":"UInt8"}],"visibility":"Public","body":"@back = ColorRGB.new(r, g, b)\nself\n"},"external_var":false},{"html_id":"back(color:Symbol):self-instance-method","name":"back","abstract":false,"args":[{"name":"color","external_name":"color","restriction":"Symbol"}],"args_string":"(color : Symbol) : self","args_html":"(color : <a href=\"../Symbol.html\">Symbol</a>) : <span class=\"k\">self</span>","location":{"filename":"src/colorize.cr","line_number":410,"url":null},"def":{"name":"back","args":[{"name":"color","external_name":"color","restriction":"Symbol"}],"return_type":"self","visibility":"Public","body":"{% for name in COLORS %}\n      if color == :{{ name.id }}\n        @back = ColorANSI::{{ name.camelcase.id }}\n        return self\n      end\n    {% end %}\n\nraise(ArgumentError.new(\"Unknown color: #{color}\"))\n"},"external_var":false},{"html_id":"back(back:Color):self-instance-method","name":"back","abstract":false,"args":[{"name":"back","external_name":"back","restriction":"Color"}],"args_string":"(back : Color) : self","args_html":"(back : <a href=\"../Colorize/Color.html\">Color</a>) : <span class=\"k\">self</span>","location":{"filename":"src/colorize.cr","line_number":421,"url":null},"def":{"name":"back","args":[{"name":"back","external_name":"back","restriction":"Color"}],"return_type":"self","visibility":"Public","body":"@back = back\nself\n"},"external_var":false},{"html_id":"back(back:UInt8)-instance-method","name":"back","abstract":false,"args":[{"name":"back","external_name":"back","restriction":"UInt8"}],"args_string":"(back : UInt8)","args_html":"(back : <a href=\"../UInt8.html\">UInt8</a>)","location":{"filename":"src/colorize.cr","line_number":425,"url":null},"def":{"name":"back","args":[{"name":"back","external_name":"back","restriction":"UInt8"}],"visibility":"Public","body":"@back = Color256.new(back)\nself\n"},"external_var":false},{"html_id":"black-instance-method","name":"black","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"black","visibility":"Public","body":"@fore = ColorANSI::Black\nself\n"},"external_var":false},{"html_id":"blink-instance-method","name":"blink","doc":"Apply text decoration `Mode::Blink`.","summary":"<p>Apply text decoration <code><a href=\"../Colorize/Mode.html#Blink\">Mode::Blink</a></code>.</p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":378,"url":null},"def":{"name":"blink","visibility":"Public","body":"mode(Mode::Blink)"},"external_var":false},{"html_id":"blink_fast-instance-method","name":"blink_fast","doc":"Apply text decoration `Mode::BlinkFast`.","summary":"<p>Apply text decoration <code><a href=\"../Colorize/Mode.html#BlinkFast\">Mode::BlinkFast</a></code>.</p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":378,"url":null},"def":{"name":"blink_fast","visibility":"Public","body":"mode(Mode::BlinkFast)"},"external_var":false},{"html_id":"blue-instance-method","name":"blue","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"blue","visibility":"Public","body":"@fore = ColorANSI::Blue\nself\n"},"external_var":false},{"html_id":"bold-instance-method","name":"bold","doc":"Apply text decoration `Mode::Bold`.","summary":"<p>Apply text decoration <code><a href=\"../Colorize/Mode.html#Bold\">Mode::Bold</a></code>.</p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":378,"url":null},"def":{"name":"bold","visibility":"Public","body":"mode(Mode::Bold)"},"external_var":false},{"html_id":"bright-instance-method","name":"bright","doc":"Apply text decoration `Mode::Bright`.","summary":"<p>Apply text decoration <code><a href=\"../Colorize/Mode.html#Bright\">Mode::Bright</a></code>.</p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":378,"url":null},"def":{"name":"bright","visibility":"Public","body":"mode(Mode::Bright)"},"external_var":false},{"html_id":"cyan-instance-method","name":"cyan","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"cyan","visibility":"Public","body":"@fore = ColorANSI::Cyan\nself\n"},"external_var":false},{"html_id":"dark_gray-instance-method","name":"dark_gray","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"dark_gray","visibility":"Public","body":"@fore = ColorANSI::DarkGray\nself\n"},"external_var":false},{"html_id":"default-instance-method","name":"default","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"default","visibility":"Public","body":"@fore = ColorANSI::Default\nself\n"},"external_var":false},{"html_id":"dim-instance-method","name":"dim","doc":"Apply text decoration `Mode::Dim`.","summary":"<p>Apply text decoration <code><a href=\"../Colorize/Mode.html#Dim\">Mode::Dim</a></code>.</p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":378,"url":null},"def":{"name":"dim","visibility":"Public","body":"mode(Mode::Dim)"},"external_var":false},{"html_id":"double_underline-instance-method","name":"double_underline","doc":"Apply text decoration `Mode::DoubleUnderline`.","summary":"<p>Apply text decoration <code><a href=\"../Colorize/Mode.html#DoubleUnderline\">Mode::DoubleUnderline</a></code>.</p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":378,"url":null},"def":{"name":"double_underline","visibility":"Public","body":"mode(Mode::DoubleUnderline)"},"external_var":false},{"html_id":"fore(r:UInt8,g:UInt8,b:UInt8)-instance-method","name":"fore","abstract":false,"args":[{"name":"r","external_name":"r","restriction":"UInt8"},{"name":"g","external_name":"g","restriction":"UInt8"},{"name":"b","external_name":"b","restriction":"UInt8"}],"args_string":"(r : UInt8, g : UInt8, b : UInt8)","args_html":"(r : <a href=\"../UInt8.html\">UInt8</a>, g : <a href=\"../UInt8.html\">UInt8</a>, b : <a href=\"../UInt8.html\">UInt8</a>)","location":{"filename":"src/colorize.cr","line_number":405,"url":null},"def":{"name":"fore","args":[{"name":"r","external_name":"r","restriction":"UInt8"},{"name":"g","external_name":"g","restriction":"UInt8"},{"name":"b","external_name":"b","restriction":"UInt8"}],"visibility":"Public","body":"@fore = ColorRGB.new(r, g, b)\nself\n"},"external_var":false},{"html_id":"fore(color:Symbol):self-instance-method","name":"fore","abstract":false,"args":[{"name":"color","external_name":"color","restriction":"Symbol"}],"args_string":"(color : Symbol) : self","args_html":"(color : <a href=\"../Symbol.html\">Symbol</a>) : <span class=\"k\">self</span>","location":{"filename":"src/colorize.cr","line_number":385,"url":null},"def":{"name":"fore","args":[{"name":"color","external_name":"color","restriction":"Symbol"}],"return_type":"self","visibility":"Public","body":"{% for name in COLORS %}\n      if color == :{{ name.id }}\n        @fore = ColorANSI::{{ name.camelcase.id }}\n        return self\n      end\n    {% end %}\n\nraise(ArgumentError.new(\"Unknown color: #{color}\"))\n"},"external_var":false},{"html_id":"fore(fore:Color):self-instance-method","name":"fore","abstract":false,"args":[{"name":"fore","external_name":"fore","restriction":"Color"}],"args_string":"(fore : Color) : self","args_html":"(fore : <a href=\"../Colorize/Color.html\">Color</a>) : <span class=\"k\">self</span>","location":{"filename":"src/colorize.cr","line_number":396,"url":null},"def":{"name":"fore","args":[{"name":"fore","external_name":"fore","restriction":"Color"}],"return_type":"self","visibility":"Public","body":"@fore = fore\nself\n"},"external_var":false},{"html_id":"fore(fore:UInt8)-instance-method","name":"fore","abstract":false,"args":[{"name":"fore","external_name":"fore","restriction":"UInt8"}],"args_string":"(fore : UInt8)","args_html":"(fore : <a href=\"../UInt8.html\">UInt8</a>)","location":{"filename":"src/colorize.cr","line_number":400,"url":null},"def":{"name":"fore","args":[{"name":"fore","external_name":"fore","restriction":"UInt8"}],"visibility":"Public","body":"@fore = Color256.new(fore)\nself\n"},"external_var":false},{"html_id":"green-instance-method","name":"green","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"green","visibility":"Public","body":"@fore = ColorANSI::Green\nself\n"},"external_var":false},{"html_id":"hidden-instance-method","name":"hidden","doc":"Apply text decoration `Mode::Hidden`.","summary":"<p>Apply text decoration <code><a href=\"../Colorize/Mode.html#Hidden\">Mode::Hidden</a></code>.</p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":378,"url":null},"def":{"name":"hidden","visibility":"Public","body":"mode(Mode::Hidden)"},"external_var":false},{"html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Inspects this object and makes the ANSI escape codes visible.","summary":"<p>Inspects this object and makes the ANSI escape codes visible.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"../IO.html\">IO</a>) : <a href=\"../Nil.html\">Nil</a>","location":{"filename":"src/colorize.cr","line_number":459,"url":null},"def":{"name":"inspect","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"surround(io) do\n  @object.inspect(io)\nend"},"external_var":false},{"html_id":"italic-instance-method","name":"italic","doc":"Apply text decoration `Mode::Italic`.","summary":"<p>Apply text decoration <code><a href=\"../Colorize/Mode.html#Italic\">Mode::Italic</a></code>.</p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":378,"url":null},"def":{"name":"italic","visibility":"Public","body":"mode(Mode::Italic)"},"external_var":false},{"html_id":"light_blue-instance-method","name":"light_blue","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"light_blue","visibility":"Public","body":"@fore = ColorANSI::LightBlue\nself\n"},"external_var":false},{"html_id":"light_cyan-instance-method","name":"light_cyan","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"light_cyan","visibility":"Public","body":"@fore = ColorANSI::LightCyan\nself\n"},"external_var":false},{"html_id":"light_gray-instance-method","name":"light_gray","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"light_gray","visibility":"Public","body":"@fore = ColorANSI::LightGray\nself\n"},"external_var":false},{"html_id":"light_green-instance-method","name":"light_green","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"light_green","visibility":"Public","body":"@fore = ColorANSI::LightGreen\nself\n"},"external_var":false},{"html_id":"light_magenta-instance-method","name":"light_magenta","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"light_magenta","visibility":"Public","body":"@fore = ColorANSI::LightMagenta\nself\n"},"external_var":false},{"html_id":"light_red-instance-method","name":"light_red","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"light_red","visibility":"Public","body":"@fore = ColorANSI::LightRed\nself\n"},"external_var":false},{"html_id":"light_yellow-instance-method","name":"light_yellow","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"light_yellow","visibility":"Public","body":"@fore = ColorANSI::LightYellow\nself\n"},"external_var":false},{"html_id":"magenta-instance-method","name":"magenta","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"magenta","visibility":"Public","body":"@fore = ColorANSI::Magenta\nself\n"},"external_var":false},{"html_id":"mode(mode:Mode):self-instance-method","name":"mode","doc":"Adds *mode* to the text's decorations.","summary":"<p>Adds <em>mode</em> to the text's decorations.</p>","abstract":false,"args":[{"name":"mode","external_name":"mode","restriction":"Mode"}],"args_string":"(mode : Mode) : self","args_html":"(mode : <a href=\"../Colorize/Mode.html\">Mode</a>) : <span class=\"k\">self</span>","location":{"filename":"src/colorize.cr","line_number":436,"url":null},"def":{"name":"mode","args":[{"name":"mode","external_name":"mode","restriction":"Mode"}],"return_type":"self","visibility":"Public","body":"@mode = @mode | mode\nself\n"},"external_var":false},{"html_id":"on(color:Symbol)-instance-method","name":"on","abstract":false,"args":[{"name":"color","external_name":"color","restriction":"Symbol"}],"args_string":"(color : Symbol)","args_html":"(color : <a href=\"../Symbol.html\">Symbol</a>)","location":{"filename":"src/colorize.cr","line_number":441,"url":null},"def":{"name":"on","args":[{"name":"color","external_name":"color","restriction":"Symbol"}],"visibility":"Public","body":"back(color)"},"external_var":false},{"html_id":"on_black-instance-method","name":"on_black","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"on_black","visibility":"Public","body":"@back = ColorANSI::Black\nself\n"},"external_var":false},{"html_id":"on_blue-instance-method","name":"on_blue","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"on_blue","visibility":"Public","body":"@back = ColorANSI::Blue\nself\n"},"external_var":false},{"html_id":"on_cyan-instance-method","name":"on_cyan","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"on_cyan","visibility":"Public","body":"@back = ColorANSI::Cyan\nself\n"},"external_var":false},{"html_id":"on_dark_gray-instance-method","name":"on_dark_gray","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"on_dark_gray","visibility":"Public","body":"@back = ColorANSI::DarkGray\nself\n"},"external_var":false},{"html_id":"on_default-instance-method","name":"on_default","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"on_default","visibility":"Public","body":"@back = ColorANSI::Default\nself\n"},"external_var":false},{"html_id":"on_green-instance-method","name":"on_green","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"on_green","visibility":"Public","body":"@back = ColorANSI::Green\nself\n"},"external_var":false},{"html_id":"on_light_blue-instance-method","name":"on_light_blue","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"on_light_blue","visibility":"Public","body":"@back = ColorANSI::LightBlue\nself\n"},"external_var":false},{"html_id":"on_light_cyan-instance-method","name":"on_light_cyan","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"on_light_cyan","visibility":"Public","body":"@back = ColorANSI::LightCyan\nself\n"},"external_var":false},{"html_id":"on_light_gray-instance-method","name":"on_light_gray","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"on_light_gray","visibility":"Public","body":"@back = ColorANSI::LightGray\nself\n"},"external_var":false},{"html_id":"on_light_green-instance-method","name":"on_light_green","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"on_light_green","visibility":"Public","body":"@back = ColorANSI::LightGreen\nself\n"},"external_var":false},{"html_id":"on_light_magenta-instance-method","name":"on_light_magenta","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"on_light_magenta","visibility":"Public","body":"@back = ColorANSI::LightMagenta\nself\n"},"external_var":false},{"html_id":"on_light_red-instance-method","name":"on_light_red","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"on_light_red","visibility":"Public","body":"@back = ColorANSI::LightRed\nself\n"},"external_var":false},{"html_id":"on_light_yellow-instance-method","name":"on_light_yellow","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"on_light_yellow","visibility":"Public","body":"@back = ColorANSI::LightYellow\nself\n"},"external_var":false},{"html_id":"on_magenta-instance-method","name":"on_magenta","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"on_magenta","visibility":"Public","body":"@back = ColorANSI::Magenta\nself\n"},"external_var":false},{"html_id":"on_red-instance-method","name":"on_red","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"on_red","visibility":"Public","body":"@back = ColorANSI::Red\nself\n"},"external_var":false},{"html_id":"on_white-instance-method","name":"on_white","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"on_white","visibility":"Public","body":"@back = ColorANSI::White\nself\n"},"external_var":false},{"html_id":"on_yellow-instance-method","name":"on_yellow","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"on_yellow","visibility":"Public","body":"@back = ColorANSI::Yellow\nself\n"},"external_var":false},{"html_id":"overline-instance-method","name":"overline","doc":"Apply text decoration `Mode::Overline`.","summary":"<p>Apply text decoration <code><a href=\"../Colorize/Mode.html#Overline\">Mode::Overline</a></code>.</p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":378,"url":null},"def":{"name":"overline","visibility":"Public","body":"mode(Mode::Overline)"},"external_var":false},{"html_id":"red-instance-method","name":"red","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"red","visibility":"Public","body":"@fore = ColorANSI::Red\nself\n"},"external_var":false},{"html_id":"reverse-instance-method","name":"reverse","doc":"Apply text decoration `Mode::Reverse`.","summary":"<p>Apply text decoration <code><a href=\"../Colorize/Mode.html#Reverse\">Mode::Reverse</a></code>.</p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":378,"url":null},"def":{"name":"reverse","visibility":"Public","body":"mode(Mode::Reverse)"},"external_var":false},{"html_id":"strikethrough-instance-method","name":"strikethrough","doc":"Apply text decoration `Mode::Strikethrough`.","summary":"<p>Apply text decoration <code><a href=\"../Colorize/Mode.html#Strikethrough\">Mode::Strikethrough</a></code>.</p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":378,"url":null},"def":{"name":"strikethrough","visibility":"Public","body":"mode(Mode::Strikethrough)"},"external_var":false},{"html_id":"surround(io=STDOUT,&)-instance-method","name":"surround","doc":"Surrounds *io* by the ANSI escape codes and lets you build colored strings:\n\n```\nrequire \"colorize\"\n\nio = IO::Memory.new\n\nColorize.with.red.surround(io) do\n  io << \"colorful\"\n  Colorize.with.green.bold.surround(io) do\n    io << \" hello \"\n  end\n  Colorize.with.blue.surround(io) do\n    io << \"world\"\n  end\n  io << \" string\"\nend\n\nio.to_s # returns a colorful string where \"colorful\" is red, \"hello\" green, \"world\" blue and \" string\" red again\n```","summary":"<p>Surrounds <em>io</em> by the ANSI escape codes and lets you build colored strings:</p>","abstract":false,"args":[{"name":"io","default_value":"STDOUT","external_name":"io","restriction":""}],"args_string":"(io = STDOUT, &)","args_html":"(io = <span class=\"t\">STDOUT</span>, &)","location":{"filename":"src/colorize.cr","line_number":485,"url":null},"def":{"name":"surround","args":[{"name":"io","default_value":"STDOUT","external_name":"io","restriction":""}],"yields":1,"block_arity":1,"visibility":"Public","body":"if @enabled\nelse\n  return yield io\nend\n\nObject.surround(io, to_named_tuple) do |io|\n  yield io\nend\n"},"external_var":false},{"html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Appends this object colored and with text decoration to *io*.","summary":"<p>Appends this object colored and with text decoration to <em>io</em>.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"../IO.html\">IO</a>) : <a href=\"../Nil.html\">Nil</a>","location":{"filename":"src/colorize.cr","line_number":452,"url":null},"def":{"name":"to_s","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"surround(io) do\n  io << @object\nend"},"external_var":false},{"html_id":"toggle(flag)-instance-method","name":"toggle","doc":"Enables or disables colors and text decoration on this object.","summary":"<p>Enables or disables colors and text decoration on this object.</p>","abstract":false,"args":[{"name":"flag","external_name":"flag","restriction":""}],"args_string":"(flag)","args_html":"(flag)","location":{"filename":"src/colorize.cr","line_number":446,"url":null},"def":{"name":"toggle","args":[{"name":"flag","external_name":"flag","restriction":""}],"visibility":"Public","body":"@enabled = !(!flag)\nself\n"},"external_var":false},{"html_id":"underline-instance-method","name":"underline","doc":"Apply text decoration `Mode::Underline`.","summary":"<p>Apply text decoration <code><a href=\"../Colorize/Mode.html#Underline\">Mode::Underline</a></code>.</p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":378,"url":null},"def":{"name":"underline","visibility":"Public","body":"mode(Mode::Underline)"},"external_var":false},{"html_id":"white-instance-method","name":"white","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"white","visibility":"Public","body":"@fore = ColorANSI::White\nself\n"},"external_var":false},{"html_id":"yellow-instance-method","name":"yellow","abstract":false,"location":{"filename":"src/colorize.cr","line_number":366,"url":null},"def":{"name":"yellow","visibility":"Public","body":"@fore = ColorANSI::Yellow\nself\n"},"external_var":false}]},{"html_id":"Crystal/Colorize/ObjectExtensions","path":"Colorize/ObjectExtensions.html","kind":"module","full_name":"Colorize::ObjectExtensions","name":"ObjectExtensions","abstract":false,"locations":[{"filename":"src/colorize.cr","line_number":188,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"including_types":[{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"namespace":{"html_id":"Crystal/Colorize","kind":"module","full_name":"Colorize","name":"Colorize"},"instance_methods":[{"html_id":"colorize(r:UInt8,g:UInt8,b:UInt8)-instance-method","name":"colorize","doc":"Wraps `self` in a `Colorize::Object` and colors it with the given `ColorRGB` made\nup from the given *r*ed, *g*reen and *b*lue values.","summary":"<p>Wraps <code>self</code> in a <code><a href=\"../Colorize/Object.html\">Colorize::Object</a></code> and colors it with the given <code><a href=\"../Colorize/ColorRGB.html\">ColorRGB</a></code> made up from the given <em>r</em>ed, <em>g</em>reen and <em>b</em>lue values.</p>","abstract":false,"args":[{"name":"r","external_name":"r","restriction":"UInt8"},{"name":"g","external_name":"g","restriction":"UInt8"},{"name":"b","external_name":"b","restriction":"UInt8"}],"args_string":"(r : UInt8, g : UInt8, b : UInt8)","args_html":"(r : <a href=\"../UInt8.html\">UInt8</a>, g : <a href=\"../UInt8.html\">UInt8</a>, b : <a href=\"../UInt8.html\">UInt8</a>)","location":{"filename":"src/colorize.cr","line_number":202,"url":null},"def":{"name":"colorize","args":[{"name":"r","external_name":"r","restriction":"UInt8"},{"name":"g","external_name":"g","restriction":"UInt8"},{"name":"b","external_name":"b","restriction":"UInt8"}],"visibility":"Public","body":"(Colorize::Object.new(self)).fore(r, g, b)"},"external_var":false},{"html_id":"colorize(fore:UInt8)-instance-method","name":"colorize","doc":"Wraps `self` in a `Colorize::Object` and colors it with the given `Color256`\nmade up from the single *fore* byte.","summary":"<p>Wraps <code>self</code> in a <code><a href=\"../Colorize/Object.html\">Colorize::Object</a></code> and colors it with the given <code><a href=\"../Colorize/Color256.html\">Color256</a></code> made up from the single <em>fore</em> byte.</p>","abstract":false,"args":[{"name":"fore","external_name":"fore","restriction":"UInt8"}],"args_string":"(fore : UInt8)","args_html":"(fore : <a href=\"../UInt8.html\">UInt8</a>)","location":{"filename":"src/colorize.cr","line_number":196,"url":null},"def":{"name":"colorize","args":[{"name":"fore","external_name":"fore","restriction":"UInt8"}],"visibility":"Public","body":"(Colorize::Object.new(self)).fore(fore)"},"external_var":false},{"html_id":"colorize(fore:Symbol)-instance-method","name":"colorize","doc":"Wraps `self` in a `Colorize::Object` and colors it with the given *fore* color.","summary":"<p>Wraps <code>self</code> in a <code><a href=\"../Colorize/Object.html\">Colorize::Object</a></code> and colors it with the given <em>fore</em> color.</p>","abstract":false,"args":[{"name":"fore","external_name":"fore","restriction":"Symbol"}],"args_string":"(fore : Symbol)","args_html":"(fore : <a href=\"../Symbol.html\">Symbol</a>)","location":{"filename":"src/colorize.cr","line_number":212,"url":null},"def":{"name":"colorize","args":[{"name":"fore","external_name":"fore","restriction":"Symbol"}],"visibility":"Public","body":"(Colorize::Object.new(self)).fore(fore)"},"external_var":false},{"html_id":"colorize(fore:Color)-instance-method","name":"colorize","doc":"Wraps `self` in a `Colorize::Object` and colors it with the given *fore* `Color`.","summary":"<p>Wraps <code>self</code> in a <code><a href=\"../Colorize/Object.html\">Colorize::Object</a></code> and colors it with the given <em>fore</em> <code><a href=\"../Colorize/Color.html\">Color</a></code>.</p>","abstract":false,"args":[{"name":"fore","external_name":"fore","restriction":"Color"}],"args_string":"(fore : Color)","args_html":"(fore : <a href=\"../Colorize/Color.html\">Color</a>)","location":{"filename":"src/colorize.cr","line_number":207,"url":null},"def":{"name":"colorize","args":[{"name":"fore","external_name":"fore","restriction":"Color"}],"visibility":"Public","body":"(Colorize::Object.new(self)).fore(fore)"},"external_var":false},{"html_id":"colorize:Colorize::Object-instance-method","name":"colorize","doc":"Turns `self` into a `Colorize::Object`.","summary":"<p>Turns <code>self</code> into a <code><a href=\"../Colorize/Object.html\">Colorize::Object</a></code>.</p>","abstract":false,"location":{"filename":"src/colorize.cr","line_number":190,"url":null},"def":{"name":"colorize","return_type":"Colorize::Object","visibility":"Public","body":"Colorize::Object.new(self)"},"external_var":false}]}]},{"html_id":"Crystal/Comparable","path":"Comparable.html","kind":"module","full_name":"Comparable(T)","name":"Comparable","abstract":false,"locations":[{"filename":"src/comparable.cr","line_number":21,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"including_types":[{"html_id":"Crystal/Array","kind":"class","full_name":"Array(T)","name":"Array"},{"html_id":"Crystal/BigDecimal","kind":"struct","full_name":"BigDecimal","name":"BigDecimal"},{"html_id":"Crystal/BigFloat","kind":"struct","full_name":"BigFloat","name":"BigFloat"},{"html_id":"Crystal/BigInt","kind":"struct","full_name":"BigInt","name":"BigInt"},{"html_id":"Crystal/BigRational","kind":"struct","full_name":"BigRational","name":"BigRational"},{"html_id":"Crystal/Char","kind":"struct","full_name":"Char","name":"Char"},{"html_id":"Crystal/Enum","kind":"struct","full_name":"Enum","name":"Enum"},{"html_id":"Crystal/Float","kind":"struct","full_name":"Float","name":"Float"},{"html_id":"Crystal/Int","kind":"struct","full_name":"Int","name":"Int"},{"html_id":"Crystal/Number","kind":"struct","full_name":"Number","name":"Number"},{"html_id":"Crystal/Path","kind":"struct","full_name":"Path","name":"Path"},{"html_id":"Crystal/Pointer","kind":"struct","full_name":"Pointer(T)","name":"Pointer"},{"html_id":"Crystal/SemanticVersion","kind":"struct","full_name":"SemanticVersion","name":"SemanticVersion"},{"html_id":"Crystal/SemanticVersion/Prerelease","kind":"struct","full_name":"SemanticVersion::Prerelease","name":"Prerelease"},{"html_id":"Crystal/Slice","kind":"struct","full_name":"Slice(T)","name":"Slice"},{"html_id":"Crystal/StaticArray","kind":"struct","full_name":"StaticArray(T, N)","name":"StaticArray"},{"html_id":"Crystal/String","kind":"class","full_name":"String","name":"String"},{"html_id":"Crystal/Symbol","kind":"struct","full_name":"Symbol","name":"Symbol"},{"html_id":"Crystal/Time","kind":"struct","full_name":"Time","name":"Time"},{"html_id":"Crystal/Time/Instant","kind":"struct","full_name":"Time::Instant","name":"Instant"},{"html_id":"Crystal/Time/Span","kind":"struct","full_name":"Time::Span","name":"Span"},{"html_id":"Crystal/Tuple","kind":"struct","full_name":"Tuple(*T)","name":"Tuple"},{"html_id":"Crystal/UUID","kind":"struct","full_name":"UUID","name":"UUID"}],"doc":"The `Comparable` mixin is used by classes whose objects may be ordered.\n\nIncluding types must provide an `<=>` method, which compares the receiver against\nanother object, returning:\n- a negative number if `self` is less than the other object\n- a positive number if `self` is greater than the other object\n- `0` if `self` is equal to the other object\n- `nil` if `self` and the other object are not comparable\n\n`Comparable` uses `<=>` to implement the conventional comparison operators\n(`<`, `<=`, `==`, `>=`, and `>`). All of these return `false` when `<=>`\nreturns `nil`.\n\nNote that returning `nil` is only useful when defining a partial comparable\nrelationship. One such example is float values: they are generally comparable,\nexcept for `NaN`. If none of the values of a type are comparable between each\nother, `Comparable` shouldn't be included.\n\nNOTE: When `nil` is returned from `<=>`, `Array#sort` and related sorting\nmethods will perform slightly slower.","summary":"<p>The <code><a href=\"Comparable.html\">Comparable</a></code> mixin is used by classes whose objects may be ordered.</p>","instance_methods":[{"html_id":"<(other:T):Bool-instance-method","name":"<","doc":"Compares this object to *other* based on the receiver’s `<=>` method,\nreturning `true` if it returns a negative number.","summary":"<p>Compares this object to <em>other</em> based on the receiver’s <code>&lt;=&gt;</code> method, returning <code>true</code> if it returns a negative number.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"T"}],"args_string":"(other : T) : Bool","args_html":"(other : T) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/comparable.cr","line_number":24,"url":null},"def":{"name":"<","args":[{"name":"other","external_name":"other","restriction":"T"}],"return_type":"Bool","visibility":"Public","body":"cmp = self <=> other\ncmp ? cmp < 0 : false\n"},"external_var":false},{"html_id":"<=(other:T)-instance-method","name":"<=","doc":"Compares this object to *other* based on the receiver’s `<=>` method,\nreturning `true` if it returns a value equal or less then `0`.","summary":"<p>Compares this object to <em>other</em> based on the receiver’s <code>&lt;=&gt;</code> method, returning <code>true</code> if it returns a value equal or less then <code>0</code>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"T"}],"args_string":"(other : T)","args_html":"(other : T)","location":{"filename":"src/comparable.cr","line_number":31,"url":null},"def":{"name":"<=","args":[{"name":"other","external_name":"other","restriction":"T"}],"visibility":"Public","body":"cmp = self <=> other\ncmp ? cmp <= 0 : false\n"},"external_var":false},{"html_id":"<=>(other:T)-instance-method","name":"<=>","doc":"The comparison operator. Returns `0` if the two objects are equal,\na negative number if this object is considered less than *other*,\na positive number if this object is considered greater than *other*,\nor `nil` if the two objects are not comparable.\n\nSubclasses define this method to provide class-specific ordering.\n\nThe comparison operator is usually used to sort values:\n\n```\n# Sort in a descending way:\n[3, 1, 2].sort { |x, y| y <=> x } # => [3, 2, 1]\n\n# Sort in an ascending way:\n[3, 1, 2].sort { |x, y| x <=> y } # => [1, 2, 3]\n```","summary":"<p>The comparison operator.</p>","abstract":true,"args":[{"name":"other","external_name":"other","restriction":"T"}],"args_string":"(other : T)","args_html":"(other : T)","location":{"filename":"src/comparable.cr","line_number":83,"url":null},"def":{"name":"<=>","args":[{"name":"other","external_name":"other","restriction":"T"}],"visibility":"Public","body":""},"external_var":false},{"html_id":"==(other:T)-instance-method","name":"==","doc":"Compares this object to *other* based on the receiver’s `<=>` method,\nreturning `true` if it returns `0`.\n\nAlso returns `true` if this and *other* are the same object.","summary":"<p>Compares this object to <em>other</em> based on the receiver’s <code>&lt;=&gt;</code> method, returning <code>true</code> if it returns <code>0</code>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"T"}],"args_string":"(other : T)","args_html":"(other : T)","location":{"filename":"src/comparable.cr","line_number":40,"url":null},"def":{"name":"==","args":[{"name":"other","external_name":"other","restriction":"T"}],"visibility":"Public","body":"if self.is_a?(Reference)\n  if other.is_a?(Reference) && (self.same?(other))\n    return true\n  end\n  if other.nil? && (self.same?(other))\n    return true\n  end\nend\n\ncmp = self <=> other\ncmp ? cmp == 0 : false\n"},"external_var":false},{"html_id":">(other:T):Bool-instance-method","name":">","doc":"Compares this object to *other* based on the receiver’s `<=>` method,\nreturning `true` if it returns a value greater then `0`.","summary":"<p>Compares this object to <em>other</em> based on the receiver’s <code>&lt;=&gt;</code> method, returning <code>true</code> if it returns a value greater then <code>0</code>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"T"}],"args_string":"(other : T) : Bool","args_html":"(other : T) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/comparable.cr","line_number":55,"url":null},"def":{"name":">","args":[{"name":"other","external_name":"other","restriction":"T"}],"return_type":"Bool","visibility":"Public","body":"cmp = self <=> other\ncmp ? cmp > 0 : false\n"},"external_var":false},{"html_id":">=(other:T)-instance-method","name":">=","doc":"Compares this object to *other* based on the receiver’s `<=>` method,\nreturning `true` if it returns a value equal or greater than `0`.","summary":"<p>Compares this object to <em>other</em> based on the receiver’s <code>&lt;=&gt;</code> method, returning <code>true</code> if it returns a value equal or greater than <code>0</code>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"T"}],"args_string":"(other : T)","args_html":"(other : T)","location":{"filename":"src/comparable.cr","line_number":62,"url":null},"def":{"name":">=","args":[{"name":"other","external_name":"other","restriction":"T"}],"visibility":"Public","body":"cmp = self <=> other\ncmp ? cmp >= 0 : false\n"},"external_var":false},{"html_id":"clamp(min,max)-instance-method","name":"clamp","doc":"Clamps a value between *min* and *max*.\n\n```\n5.clamp(10, 100)   # => 10\n50.clamp(10, 100)  # => 50\n500.clamp(10, 100) # => 100\n\n5.clamp(10, nil)  # => 10\n50.clamp(10, nil) # => 50\n\n5.clamp(nil, 10)  # => 5\n50.clamp(nil, 10) # => 10\n```","summary":"<p>Clamps a value between <em>min</em> and <em>max</em>.</p>","abstract":false,"args":[{"name":"min","external_name":"min","restriction":""},{"name":"max","external_name":"max","restriction":""}],"args_string":"(min, max)","args_html":"(min, max)","location":{"filename":"src/comparable.cr","line_number":116,"url":null},"def":{"name":"clamp","args":[{"name":"min","external_name":"min","restriction":""},{"name":"max","external_name":"max","restriction":""}],"visibility":"Public","body":"if (!max.nil?) && self > max\n  return max\nend\nif (!min.nil?) && self < min\n  return min\nend\nself\n"},"external_var":false},{"html_id":"clamp(range:Range)-instance-method","name":"clamp","doc":"Clamps a value within *range*.\n\n```\n5.clamp(10..100)   # => 10\n50.clamp(10..100)  # => 50\n500.clamp(10..100) # => 100\n\n5.clamp(10..)  # => 10\n50.clamp(10..) # => 50\n\n5.clamp(..10)  # => 5\n50.clamp(..10) # => 10\n```","summary":"<p>Clamps a value within <em>range</em>.</p>","abstract":false,"args":[{"name":"range","external_name":"range","restriction":"Range"}],"args_string":"(range : Range)","args_html":"(range : <a href=\"Range.html\">Range</a>)","location":{"filename":"src/comparable.cr","line_number":98,"url":null},"def":{"name":"clamp","args":[{"name":"range","external_name":"range","restriction":"Range"}],"visibility":"Public","body":"if (!range.end.nil?) && range.exclusive?\n  raise(ArgumentError.new(\"Can't clamp an exclusive range\"))\nend\nclamp(range.begin, range.end)\n"},"external_var":false}]},{"html_id":"Crystal/Complex","path":"Complex.html","kind":"struct","full_name":"Complex","name":"Complex","abstract":false,"superclass":{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},"ancestors":[{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/complex.cr","line_number":17,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"doc":"A complex number is a number represented in the form a + bi. In this form,\na and b are real numbers, and i is an imaginary number such as i² = -1.\nThe a is the real part of the number, and the b is the imaginary part of\nthe number.\n\nNOTE: To use `Complex`, you must explicitly import it with `require \"complex\"`\n\n```\nrequire \"complex\"\n\nComplex.new(1, 0)   # => 1.0 + 0.0.i\nComplex.new(5, -12) # => 5.0 - 12.0.i\n\n1.to_c # => 1.0 + 0.0.i\n1.i    # => 0.0 + 1.0.i\n```","summary":"<p>A complex number is a number represented in the form a + bi.</p>","constructors":[{"html_id":"additive_identity:self-class-method","name":"additive_identity","abstract":false,"location":{"filename":"src/complex.cr","line_number":300,"url":null},"def":{"name":"additive_identity","return_type":"self","visibility":"Public","body":"zero"},"external_var":false},{"html_id":"multiplicative_identity:self-class-method","name":"multiplicative_identity","abstract":false,"location":{"filename":"src/complex.cr","line_number":304,"url":null},"def":{"name":"multiplicative_identity","return_type":"self","visibility":"Public","body":"new(1, 0)"},"external_var":false},{"html_id":"new(real:Number,imag:Number=0)-class-method","name":"new","abstract":false,"args":[{"name":"real","external_name":"real","restriction":"Number"},{"name":"imag","default_value":"0","external_name":"imag","restriction":"Number"}],"args_string":"(real : Number, imag : Number = 0)","args_html":"(real : <a href=\"Number.html\">Number</a>, imag : <a href=\"Number.html\">Number</a> = <span class=\"n\">0</span>)","location":{"filename":"src/complex.cr","line_number":24,"url":null},"def":{"name":"new","args":[{"name":"real","external_name":"real","restriction":"Number"},{"name":"imag","default_value":"0","external_name":"imag","restriction":"Number"}],"visibility":"Public","body":"_ = allocate\n_.initialize(real, imag)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(c:Complex)-class-method","name":"new","abstract":false,"args":[{"name":"c","external_name":"c","restriction":"Complex"}],"args_string":"(c : Complex)","args_html":"(c : <a href=\"Complex.html\">Complex</a>)","location":{"filename":"src/complex.cr","line_number":29,"url":null},"def":{"name":"new","args":[{"name":"c","external_name":"c","restriction":"Complex"}],"visibility":"Public","body":"c"},"external_var":false},{"html_id":"zero:Complex-class-method","name":"zero","doc":"Returns the number `0` in complex form.","summary":"<p>Returns the number <code>0</code> in complex form.</p>","abstract":false,"location":{"filename":"src/complex.cr","line_number":282,"url":null},"def":{"name":"zero","return_type":"Complex","visibility":"Public","body":"new(0, 0)"},"external_var":false}],"instance_methods":[{"html_id":"*(other:Complex):Complex-instance-method","name":"*","doc":"Multiplies `self` by *other*.","summary":"<p>Multiplies <code>self</code> by <em>other</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Complex"}],"args_string":"(other : Complex) : Complex","args_html":"(other : <a href=\"Complex.html\">Complex</a>) : <a href=\"Complex.html\">Complex</a>","location":{"filename":"src/complex.cr","line_number":229,"url":null},"def":{"name":"*","args":[{"name":"other","external_name":"other","restriction":"Complex"}],"return_type":"Complex","visibility":"Public","body":"Complex.new((@real * other.real) - (@imag * other.imag), (@real * other.imag) + (@imag * other.real))"},"external_var":false},{"html_id":"*(other:Number):Complex-instance-method","name":"*","doc":"Multiplies `self` by *other*.","summary":"<p>Multiplies <code>self</code> by <em>other</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Number"}],"args_string":"(other : Number) : Complex","args_html":"(other : <a href=\"Number.html\">Number</a>) : <a href=\"Complex.html\">Complex</a>","location":{"filename":"src/complex.cr","line_number":234,"url":null},"def":{"name":"*","args":[{"name":"other","external_name":"other","restriction":"Number"}],"return_type":"Complex","visibility":"Public","body":"Complex.new(@real * other, @imag * other)"},"external_var":false},{"html_id":"+(other:Complex):Complex-instance-method","name":"+","doc":"Adds the value of `self` to *other*.","summary":"<p>Adds the value of <code>self</code> to <em>other</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Complex"}],"args_string":"(other : Complex) : Complex","args_html":"(other : <a href=\"Complex.html\">Complex</a>) : <a href=\"Complex.html\">Complex</a>","location":{"filename":"src/complex.cr","line_number":204,"url":null},"def":{"name":"+","args":[{"name":"other","external_name":"other","restriction":"Complex"}],"return_type":"Complex","visibility":"Public","body":"Complex.new(@real + other.real, @imag + other.imag)"},"external_var":false},{"html_id":"+(other:Number):Complex-instance-method","name":"+","doc":"Adds the value of `self` to *other*.","summary":"<p>Adds the value of <code>self</code> to <em>other</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Number"}],"args_string":"(other : Number) : Complex","args_html":"(other : <a href=\"Number.html\">Number</a>) : <a href=\"Complex.html\">Complex</a>","location":{"filename":"src/complex.cr","line_number":209,"url":null},"def":{"name":"+","args":[{"name":"other","external_name":"other","restriction":"Number"}],"return_type":"Complex","visibility":"Public","body":"Complex.new(@real + other, @imag)"},"external_var":false},{"html_id":"+:Complex-instance-method","name":"+","doc":"Returns `self`.","summary":"<p>Returns <code>self</code>.</p>","abstract":false,"location":{"filename":"src/complex.cr","line_number":199,"url":null},"def":{"name":"+","return_type":"Complex","visibility":"Public","body":"self"},"external_var":false},{"html_id":"-(other:Complex):Complex-instance-method","name":"-","doc":"Removes the value of *other* from `self`.","summary":"<p>Removes the value of <em>other</em> from <code>self</code>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Complex"}],"args_string":"(other : Complex) : Complex","args_html":"(other : <a href=\"Complex.html\">Complex</a>) : <a href=\"Complex.html\">Complex</a>","location":{"filename":"src/complex.cr","line_number":219,"url":null},"def":{"name":"-","args":[{"name":"other","external_name":"other","restriction":"Complex"}],"return_type":"Complex","visibility":"Public","body":"Complex.new(@real - other.real, @imag - other.imag)"},"external_var":false},{"html_id":"-(other:Number):Complex-instance-method","name":"-","doc":"Removes the value of *other* from `self`.","summary":"<p>Removes the value of <em>other</em> from <code>self</code>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Number"}],"args_string":"(other : Number) : Complex","args_html":"(other : <a href=\"Number.html\">Number</a>) : <a href=\"Complex.html\">Complex</a>","location":{"filename":"src/complex.cr","line_number":224,"url":null},"def":{"name":"-","args":[{"name":"other","external_name":"other","restriction":"Number"}],"return_type":"Complex","visibility":"Public","body":"Complex.new(@real - other, @imag)"},"external_var":false},{"html_id":"-:Complex-instance-method","name":"-","doc":"Returns the opposite of `self`.","summary":"<p>Returns the opposite of <code>self</code>.</p>","abstract":false,"location":{"filename":"src/complex.cr","line_number":214,"url":null},"def":{"name":"-","return_type":"Complex","visibility":"Public","body":"Complex.new(-@real, -@imag)"},"external_var":false},{"html_id":"/(other:Complex):Complex-instance-method","name":"/","doc":"Divides `self` by *other*.","summary":"<p>Divides <code>self</code> by <em>other</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Complex"}],"args_string":"(other : Complex) : Complex","args_html":"(other : <a href=\"Complex.html\">Complex</a>) : <a href=\"Complex.html\">Complex</a>","location":{"filename":"src/complex.cr","line_number":239,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"Complex"}],"return_type":"Complex","visibility":"Public","body":"if other.real.nan? || other.imag.nan?\n  Complex.new(Float64::NAN, Float64::NAN)\nelsif other.imag.abs < other.real.abs\n  r = other.imag / other.real\n  d = other.real + (r * other.imag)\n\n  if d.nan? || (d == 0)\n    Complex.new(Float64::NAN, Float64::NAN)\n  else\n    Complex.new((@real + (@imag * r)) / d, (@imag - (@real * r)) / d)\n  end\nelsif other.imag == 0\n  Complex.new(@real / other.real, @imag / other.real)\nelse\n  r = other.real / other.imag\n  d = other.imag + (r * other.real)\n\n  if d.nan? || (d == 0)\n    Complex.new(Float64::NAN, Float64::NAN)\n  else\n    Complex.new(((@real * r) + @imag) / d, ((@imag * r) - @real) / d)\n  end\nend"},"external_var":false},{"html_id":"/(other:Number):Complex-instance-method","name":"/","doc":"Divides `self` by *other*.","summary":"<p>Divides <code>self</code> by <em>other</em>.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Number"}],"args_string":"(other : Number) : Complex","args_html":"(other : <a href=\"Number.html\">Number</a>) : <a href=\"Complex.html\">Complex</a>","location":{"filename":"src/complex.cr","line_number":266,"url":null},"def":{"name":"/","args":[{"name":"other","external_name":"other","restriction":"Number"}],"return_type":"Complex","visibility":"Public","body":"Complex.new(@real / other, @imag / other)"},"external_var":false},{"html_id":"==(other:Complex)-instance-method","name":"==","doc":"Determines whether `self` equals *other* or not.","summary":"<p>Determines whether <code>self</code> equals <em>other</em> or not.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Complex"}],"args_string":"(other : Complex)","args_html":"(other : <a href=\"Complex.html\">Complex</a>)","location":{"filename":"src/complex.cr","line_number":34,"url":null},"def":{"name":"==","args":[{"name":"other","external_name":"other","restriction":"Complex"}],"visibility":"Public","body":"(@real == other.real) && (@imag == other.imag)"},"external_var":false},{"html_id":"==(other:Number)-instance-method","name":"==","doc":"Determines whether `self` equals *other* or not.","summary":"<p>Determines whether <code>self</code> equals <em>other</em> or not.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":"Number"}],"args_string":"(other : Number)","args_html":"(other : <a href=\"Number.html\">Number</a>)","location":{"filename":"src/complex.cr","line_number":39,"url":null},"def":{"name":"==","args":[{"name":"other","external_name":"other","restriction":"Number"}],"visibility":"Public","body":"(@real == other) && @imag.zero?"},"external_var":false},{"html_id":"==(other)-instance-method","name":"==","doc":"Determines whether `self` equals *other* or not.","summary":"<p>Determines whether <code>self</code> equals <em>other</em> or not.</p>","abstract":false,"args":[{"name":"other","external_name":"other","restriction":""}],"args_string":"(other)","args_html":"(other)","location":{"filename":"src/complex.cr","line_number":44,"url":null},"def":{"name":"==","args":[{"name":"other","external_name":"other","restriction":""}],"visibility":"Public","body":"false"},"external_var":false},{"html_id":"abs:Float64-instance-method","name":"abs","doc":"Returns the absolute value of this complex number in a\nnumber form, using the Pythagorean theorem.\n\n```\nrequire \"complex\"\n\nComplex.new(42, 2).abs  # => 42.04759208325728\nComplex.new(-42, 2).abs # => 42.04759208325728\n```","summary":"<p>Returns the absolute value of this complex number in a number form, using the Pythagorean theorem.</p>","abstract":false,"location":{"filename":"src/complex.cr","line_number":112,"url":null},"def":{"name":"abs","return_type":"Float64","visibility":"Public","body":"Math.hypot(@real, @imag)"},"external_var":false},{"html_id":"abs2:Float64-instance-method","name":"abs2","doc":"Returns the square of absolute value in a number form.\n\n```\nrequire \"complex\"\n\nComplex.new(42, 2).abs2 # => 1768\n```","summary":"<p>Returns the square of absolute value in a number form.</p>","abstract":false,"location":{"filename":"src/complex.cr","line_number":123,"url":null},"def":{"name":"abs2","return_type":"Float64","visibility":"Public","body":"(@real * @real) + (@imag * @imag)"},"external_var":false},{"html_id":"clone-instance-method","name":"clone","abstract":false,"location":{"filename":"src/complex.cr","line_number":270,"url":null},"def":{"name":"clone","visibility":"Public","body":"self"},"external_var":false},{"html_id":"conj:Complex-instance-method","name":"conj","doc":"Returns the conjugate of `self`.\n\n```\nrequire \"complex\"\n\nComplex.new(42, 2).conj  # => 42.0 - 2.0.i\nComplex.new(42, -2).conj # => 42.0 + 2.0.i\n```","summary":"<p>Returns the conjugate of <code>self</code>.</p>","abstract":false,"location":{"filename":"src/complex.cr","line_number":189,"url":null},"def":{"name":"conj","return_type":"Complex","visibility":"Public","body":"Complex.new(@real, -@imag)"},"external_var":false},{"html_id":"hash(hasher)-instance-method","name":"hash","doc":"See `Object#hash(hasher)`","summary":"<p>See <code><a href=\"Object.html#hash%28hasher%29-instance-method\">Object#hash(hasher)</a></code></p>","abstract":false,"args":[{"name":"hasher","external_name":"hasher","restriction":""}],"args_string":"(hasher)","args_html":"(hasher)","location":{"filename":"src/complex.cr","line_number":275,"url":null},"def":{"name":"hash","args":[{"name":"hasher","external_name":"hasher","restriction":""}],"visibility":"Public","body":"hasher = real.hash(hasher)\nif imag.zero?\nelse\n  hasher = imag.hash(hasher)\nend\nhasher\n"},"external_var":false},{"html_id":"imag:Float64-instance-method","name":"imag","doc":"Returns the imaginary part.","summary":"<p>Returns the imaginary part.</p>","abstract":false,"location":{"filename":"src/complex.cr","line_number":22,"url":null},"def":{"name":"imag","return_type":"Float64","visibility":"Public","body":"@imag"},"external_var":false},{"html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Writes this complex object to an *io*, surrounded by parentheses.\n\n```\nrequire \"complex\"\n\nComplex.new(42, 2).inspect # => \"(42.0 + 2.0i)\"\n```","summary":"<p>Writes this complex object to an <em>io</em>, surrounded by parentheses.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/complex.cr","line_number":97,"url":null},"def":{"name":"inspect","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"io << '('\nto_s(io)\nio << ')'\n"},"external_var":false},{"html_id":"inv:Complex-instance-method","name":"inv","doc":"Returns the inverse of `self`.","summary":"<p>Returns the inverse of <code>self</code>.</p>","abstract":false,"location":{"filename":"src/complex.cr","line_number":194,"url":null},"def":{"name":"inv","return_type":"Complex","visibility":"Public","body":"conj / abs2"},"external_var":false},{"html_id":"phase:Float64-instance-method","name":"phase","doc":"Returns the phase of `self`.","summary":"<p>Returns the phase of <code>self</code>.</p>","abstract":false,"location":{"filename":"src/complex.cr","line_number":166,"url":null},"def":{"name":"phase","return_type":"Float64","visibility":"Public","body":"Math.atan2(@imag, @real)"},"external_var":false},{"html_id":"polar:Tuple(Float64,Float64)-instance-method","name":"polar","doc":"Returns a `Tuple` with the `abs` value and the `phase`.\n\n```\nrequire \"complex\"\n\nComplex.new(42, 2).polar # => {42.047592083257278, 0.047583103276983396}\n```","summary":"<p>Returns a <code><a href=\"Tuple.html\">Tuple</a></code> with the <code><a href=\"Complex.html#abs%3AFloat64-instance-method\">#abs</a></code> value and the <code><a href=\"Complex.html#phase%3AFloat64-instance-method\">#phase</a></code>.</p>","abstract":false,"location":{"filename":"src/complex.cr","line_number":177,"url":null},"def":{"name":"polar","return_type":"::Tuple(Float64, Float64)","visibility":"Public","body":"{abs, phase}"},"external_var":false},{"html_id":"real:Float64-instance-method","name":"real","doc":"Returns the real part.","summary":"<p>Returns the real part.</p>","abstract":false,"location":{"filename":"src/complex.cr","line_number":19,"url":null},"def":{"name":"real","return_type":"Float64","visibility":"Public","body":"@real"},"external_var":false},{"html_id":"round(digits=0):Complex-instance-method","name":"round","doc":"Rounds to the nearest *digits*.","summary":"<p>Rounds to the nearest <em>digits</em>.</p>","abstract":false,"args":[{"name":"digits","default_value":"0","external_name":"digits","restriction":""}],"args_string":"(digits = 0) : Complex","args_html":"(digits = <span class=\"n\">0</span>) : <a href=\"Complex.html\">Complex</a>","location":{"filename":"src/complex.cr","line_number":309,"url":null},"def":{"name":"round","args":[{"name":"digits","default_value":"0","external_name":"digits","restriction":""}],"return_type":"Complex","visibility":"Public","body":"Complex.new(@real.round(digits), @imag.round(digits))"},"external_var":false},{"html_id":"sign:Complex-instance-method","name":"sign","doc":"Returns the complex sign of `self`.\n\nIf `self` is non-zero, the returned value has the same phase as `self` and\nabsolute value `1.0`. If `self` is zero, returns `self`.\n\nThe returned value's real and imaginary components always have the same\nsigns as the respective components of `self`.\n\n```\nrequire \"complex\"\n\nComplex.new(7, -24).sign        # => (0.28 - 0.96.i)\nComplex.new(1.0 / 0.0, 24).sign # => (1.0 + 0.0.i)\nComplex.new(-0.0, +0.0).sign    # => (-0.0 + 0.0.i)\n```","summary":"<p>Returns the complex sign of <code>self</code>.</p>","abstract":false,"location":{"filename":"src/complex.cr","line_number":142,"url":null},"def":{"name":"sign","return_type":"Complex","visibility":"Public","body":"if zero?\n  return self\nend\n\nif @real.nan? || @imag.nan?\n  return Complex.new(Float64::NAN, Float64::NAN)\nend\n\nif (@real != 0) && (@imag == 0)\n  return Complex.new(@real.sign, @imag)\nend\nif (@real == 0) && (@imag != 0)\n  return Complex.new(@real, @imag.sign)\nend\n\ncase {real_inf_sign = @real.infinite?, imag_inf_sign = @imag.infinite?}\nin {Nil, Nil}\n  phase.cis\nin {Nil, Int32}\n  Complex.new(Math.copysign(0.0, @real), imag_inf_sign)\nin {Int32, Nil}\n  Complex.new(real_inf_sign, Math.copysign(0.0, @imag))\nin {Int32, Int32}\n  sqrt = Math.sqrt(0.5)\n  Complex.new(sqrt * real_inf_sign, sqrt * imag_inf_sign)\nend\n"},"external_var":false},{"html_id":"to_c-instance-method","name":"to_c","doc":"Returns `self`.","summary":"<p>Returns <code>self</code>.</p>","abstract":false,"location":{"filename":"src/complex.cr","line_number":49,"url":null},"def":{"name":"to_c","visibility":"Public","body":"self"},"external_var":false},{"html_id":"to_f-instance-method","name":"to_f","doc":"See `#to_f64`.","summary":"<p>See <code><a href=\"Complex.html#to_f64%3AFloat64-instance-method\">#to_f64</a></code>.</p>","abstract":false,"location":{"filename":"src/complex.cr","line_number":63,"url":null},"def":{"name":"to_f","visibility":"Public","body":"to_f64"},"external_var":false},{"html_id":"to_f32(*args,**options)-instance-method","name":"to_f32","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/complex.cr","line_number":69,"url":null},"def":{"name":"to_f32","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"visibility":"Public","body":"to_f64.to_f32(*args, **options)"},"external_var":false},{"html_id":"to_f32(*args,**options,&)-instance-method","name":"to_f32","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/complex.cr","line_number":69,"url":null},"def":{"name":"to_f32","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arity":1,"visibility":"Public","body":"to_f64.to_f32(*args, **options) do |*yield_args|\n  yield *yield_args\nend"},"external_var":false},{"html_id":"to_f64:Float64-instance-method","name":"to_f64","doc":"Returns the value as a `Float64` if possible (the imaginary part should be exactly zero),\nraises otherwise.","summary":"<p>Returns the value as a <code><a href=\"Float64.html\">Float64</a></code> if possible (the imaginary part should be exactly zero), raises otherwise.</p>","abstract":false,"location":{"filename":"src/complex.cr","line_number":55,"url":null},"def":{"name":"to_f64","return_type":"Float64","visibility":"Public","body":"if @imag.zero?\nelse\n  raise(Exception.new(\"Complex number with non-zero imaginary part can't be converted to real number\"))\nend\n@real\n"},"external_var":false},{"html_id":"to_i-instance-method","name":"to_i","doc":"See `#to_i32`.","summary":"<p>See <code><a href=\"Complex.html#to_i32%28%2Aargs%2C%2A%2Aoptions%29-instance-method\">#to_i32</a></code>.</p>","abstract":false,"location":{"filename":"src/complex.cr","line_number":72,"url":null},"def":{"name":"to_i","visibility":"Public","body":"to_i32"},"external_var":false},{"html_id":"to_i128(*args,**options)-instance-method","name":"to_i128","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/complex.cr","line_number":67,"url":null},"def":{"name":"to_i128","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"visibility":"Public","body":"to_f64.to_i128(*args, **options)"},"external_var":false},{"html_id":"to_i128(*args,**options,&)-instance-method","name":"to_i128","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/complex.cr","line_number":67,"url":null},"def":{"name":"to_i128","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arity":1,"visibility":"Public","body":"to_f64.to_i128(*args, **options) do |*yield_args|\n  yield *yield_args\nend"},"external_var":false},{"html_id":"to_i16(*args,**options)-instance-method","name":"to_i16","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/complex.cr","line_number":67,"url":null},"def":{"name":"to_i16","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"visibility":"Public","body":"to_f64.to_i16(*args, **options)"},"external_var":false},{"html_id":"to_i16(*args,**options,&)-instance-method","name":"to_i16","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/complex.cr","line_number":67,"url":null},"def":{"name":"to_i16","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arity":1,"visibility":"Public","body":"to_f64.to_i16(*args, **options) do |*yield_args|\n  yield *yield_args\nend"},"external_var":false},{"html_id":"to_i32(*args,**options)-instance-method","name":"to_i32","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/complex.cr","line_number":67,"url":null},"def":{"name":"to_i32","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"visibility":"Public","body":"to_f64.to_i32(*args, **options)"},"external_var":false},{"html_id":"to_i32(*args,**options,&)-instance-method","name":"to_i32","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/complex.cr","line_number":67,"url":null},"def":{"name":"to_i32","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arity":1,"visibility":"Public","body":"to_f64.to_i32(*args, **options) do |*yield_args|\n  yield *yield_args\nend"},"external_var":false},{"html_id":"to_i64(*args,**options)-instance-method","name":"to_i64","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/complex.cr","line_number":67,"url":null},"def":{"name":"to_i64","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"visibility":"Public","body":"to_f64.to_i64(*args, **options)"},"external_var":false},{"html_id":"to_i64(*args,**options,&)-instance-method","name":"to_i64","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/complex.cr","line_number":67,"url":null},"def":{"name":"to_i64","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arity":1,"visibility":"Public","body":"to_f64.to_i64(*args, **options) do |*yield_args|\n  yield *yield_args\nend"},"external_var":false},{"html_id":"to_i8(*args,**options)-instance-method","name":"to_i8","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/complex.cr","line_number":67,"url":null},"def":{"name":"to_i8","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"visibility":"Public","body":"to_f64.to_i8(*args, **options)"},"external_var":false},{"html_id":"to_i8(*args,**options,&)-instance-method","name":"to_i8","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/complex.cr","line_number":67,"url":null},"def":{"name":"to_i8","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arity":1,"visibility":"Public","body":"to_f64.to_i8(*args, **options) do |*yield_args|\n  yield *yield_args\nend"},"external_var":false},{"html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Writes this complex object to an *io*.\n\n```\nrequire \"complex\"\n\nComplex.new(42, 2).to_s # => \"42.0 + 2.0i\"\n```","summary":"<p>Writes this complex object to an <em>io</em>.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/complex.cr","line_number":83,"url":null},"def":{"name":"to_s","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"io << @real\nio << (@imag.nan? || @imag.sign_bit > 0 ? \" + \" : \" - \")\nio << (Math.copysign(@imag, 1.0))\nio << 'i'\n"},"external_var":false},{"html_id":"to_u128(*args,**options)-instance-method","name":"to_u128","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/complex.cr","line_number":68,"url":null},"def":{"name":"to_u128","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"visibility":"Public","body":"to_f64.to_u128(*args, **options)"},"external_var":false},{"html_id":"to_u128(*args,**options,&)-instance-method","name":"to_u128","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/complex.cr","line_number":68,"url":null},"def":{"name":"to_u128","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arity":1,"visibility":"Public","body":"to_f64.to_u128(*args, **options) do |*yield_args|\n  yield *yield_args\nend"},"external_var":false},{"html_id":"to_u16(*args,**options)-instance-method","name":"to_u16","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/complex.cr","line_number":68,"url":null},"def":{"name":"to_u16","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"visibility":"Public","body":"to_f64.to_u16(*args, **options)"},"external_var":false},{"html_id":"to_u16(*args,**options,&)-instance-method","name":"to_u16","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/complex.cr","line_number":68,"url":null},"def":{"name":"to_u16","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arity":1,"visibility":"Public","body":"to_f64.to_u16(*args, **options) do |*yield_args|\n  yield *yield_args\nend"},"external_var":false},{"html_id":"to_u32(*args,**options)-instance-method","name":"to_u32","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/complex.cr","line_number":68,"url":null},"def":{"name":"to_u32","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"visibility":"Public","body":"to_f64.to_u32(*args, **options)"},"external_var":false},{"html_id":"to_u32(*args,**options,&)-instance-method","name":"to_u32","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/complex.cr","line_number":68,"url":null},"def":{"name":"to_u32","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arity":1,"visibility":"Public","body":"to_f64.to_u32(*args, **options) do |*yield_args|\n  yield *yield_args\nend"},"external_var":false},{"html_id":"to_u64(*args,**options)-instance-method","name":"to_u64","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/complex.cr","line_number":68,"url":null},"def":{"name":"to_u64","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"visibility":"Public","body":"to_f64.to_u64(*args, **options)"},"external_var":false},{"html_id":"to_u64(*args,**options,&)-instance-method","name":"to_u64","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/complex.cr","line_number":68,"url":null},"def":{"name":"to_u64","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arity":1,"visibility":"Public","body":"to_f64.to_u64(*args, **options) do |*yield_args|\n  yield *yield_args\nend"},"external_var":false},{"html_id":"to_u8(*args,**options)-instance-method","name":"to_u8","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/complex.cr","line_number":68,"url":null},"def":{"name":"to_u8","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"visibility":"Public","body":"to_f64.to_u8(*args, **options)"},"external_var":false},{"html_id":"to_u8(*args,**options,&)-instance-method","name":"to_u8","abstract":false,"args":[{"name":"args","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/complex.cr","line_number":68,"url":null},"def":{"name":"to_u8","args":[{"name":"args","external_name":"args","restriction":""}],"double_splat":{"name":"options","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arity":1,"visibility":"Public","body":"to_f64.to_u8(*args, **options) do |*yield_args|\n  yield *yield_args\nend"},"external_var":false},{"html_id":"zero?:Bool-instance-method","name":"zero?","doc":"Returns `true` if the complex number is zero.\nThis means the real and imaginary are both zero.\n\n```\nrequire \"complex\"\n\nComplex.new(0, 0).zero? # => true\nComplex.new(1, 0).zero? # => false\nComplex.new(0, 1).zero? # => false\n````","summary":"<p>Returns <code>true</code> if the complex number is zero.</p>","abstract":false,"location":{"filename":"src/complex.cr","line_number":296,"url":null},"def":{"name":"zero?","return_type":"Bool","visibility":"Public","body":"(@real == 0) && (@imag == 0)"},"external_var":false}]},{"html_id":"Crystal/Compress","path":"Compress.html","kind":"module","full_name":"Compress","name":"Compress","abstract":false,"locations":[{"filename":"src/compress/deflate/reader.cr","line_number":6,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"types":[{"html_id":"Crystal/Compress/Deflate","path":"Compress/Deflate.html","kind":"module","full_name":"Compress::Deflate","name":"Deflate","abstract":false,"locations":[{"filename":"src/compress/deflate/deflate.cr","line_number":11,"url":null},{"filename":"src/compress/deflate/reader.cr","line_number":6,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"constants":[{"id":"BEST_COMPRESSION","name":"BEST_COMPRESSION","value":"9"},{"id":"BEST_SPEED","name":"BEST_SPEED","value":"1"},{"id":"DEFAULT_COMPRESSION","name":"DEFAULT_COMPRESSION","value":"-1"},{"id":"NO_COMPRESSION","name":"NO_COMPRESSION","value":"0"}],"namespace":{"html_id":"Crystal/Compress","kind":"module","full_name":"Compress","name":"Compress"},"doc":"The Deflate module contains readers and writers of DEFLATE format compressed\ndata, as specified in [RFC 1951](https://www.ietf.org/rfc/rfc1951.txt).\n\nSee `Gzip`, `Zip` and `Zlib` for modules that provide access\nto DEFLATE-based file formats.\n\nNOTE: To use `Deflate` or its children, you must explicitly import it with `require \"compress/deflate\"`","summary":"<p>The Deflate module contains readers and writers of DEFLATE format compressed data, as specified in <a href=\"https://www.ietf.org/rfc/rfc1951.txt\">RFC 1951</a>.</p>","types":[{"html_id":"Crystal/Compress/Deflate/Error","path":"Compress/Deflate/Error.html","kind":"class","full_name":"Compress::Deflate::Error","name":"Error","abstract":false,"superclass":{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},"ancestors":[{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/compress/deflate/deflate.cr","line_number":25,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"namespace":{"html_id":"Crystal/Compress/Deflate","kind":"module","full_name":"Compress::Deflate","name":"Deflate"},"constructors":[{"html_id":"new(ret,stream)-class-method","name":"new","abstract":false,"args":[{"name":"ret","external_name":"ret","restriction":""},{"name":"stream","external_name":"stream","restriction":""}],"args_string":"(ret, stream)","args_html":"(ret, stream)","location":{"filename":"src/compress/deflate/deflate.cr","line_number":26,"url":null},"def":{"name":"new","args":[{"name":"ret","external_name":"ret","restriction":""},{"name":"stream","external_name":"stream","restriction":""}],"visibility":"Public","body":"_ = allocate\n_.initialize(ret, stream)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false}]},{"html_id":"Crystal/Compress/Deflate/Reader","path":"Compress/Deflate/Reader.html","kind":"class","full_name":"Compress::Deflate::Reader","name":"Reader","abstract":false,"superclass":{"html_id":"Crystal/IO","kind":"class","full_name":"IO","name":"IO"},"ancestors":[{"html_id":"Crystal/IO/Buffered","kind":"module","full_name":"IO::Buffered","name":"Buffered"},{"html_id":"Crystal/IO","kind":"class","full_name":"IO","name":"IO"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/compress/deflate/reader.cr","line_number":6,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"included_modules":[{"html_id":"Crystal/IO/Buffered","kind":"module","full_name":"IO::Buffered","name":"Buffered"}],"namespace":{"html_id":"Crystal/Compress/Deflate","kind":"module","full_name":"Compress::Deflate","name":"Deflate"},"doc":"A read-only `IO` object to decompress data in the DEFLATE format.\n\nInstances of this class wrap another IO object. When you read from this instance\ninstance, it reads data from the underlying IO, decompresses it, and returns\nit to the caller.","summary":"<p>A read-only <code><a href=\"../../IO.html\">IO</a></code> object to decompress data in the DEFLATE format.</p>","class_methods":[{"html_id":"gzip(input,sync_close:Bool=false,&)-class-method","name":"gzip","doc":"Creates an instance of Flate::Reader for the gzip format, yields it to the given block, and closes\nit at its end.","summary":"<p>Creates an instance of Flate::Reader for the gzip format, yields it to the given block, and closes it at its end.</p>","abstract":false,"args":[{"name":"input","external_name":"input","restriction":""},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":"Bool"}],"args_string":"(input, sync_close : Bool = false, &)","args_html":"(input, sync_close : <a href=\"../../Bool.html\">Bool</a> = <span class=\"n\">false</span>, &)","location":{"filename":"src/compress/deflate/reader.cr","line_number":49,"url":null},"def":{"name":"gzip","args":[{"name":"input","external_name":"input","restriction":""},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":"Bool"}],"yields":1,"block_arity":1,"visibility":"Public","body":"reader = gzip(input, sync_close: sync_close)\nbegin\n  yield reader\nensure\n  reader.close\nend\n"},"external_var":false},{"html_id":"open(io:IO,sync_close:Bool=false,dict:Bytes|Nil=nil,&)-class-method","name":"open","doc":"Creates a new reader from the given *io*, yields it to the given block,\nand closes it at its end.","summary":"<p>Creates a new reader from the given <em>io</em>, yields it to the given block, and closes it at its end.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":"Bool"},{"name":"dict","default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"args_string":"(io : IO, sync_close : Bool = false, dict : Bytes | Nil = nil, &)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, sync_close : <a href=\"../../Bool.html\">Bool</a> = <span class=\"n\">false</span>, dict : <a href=\"../../Bytes.html\">Bytes</a> | <a href=\"../../Nil.html\">Nil</a> = <span class=\"n\">nil</span>, &)","location":{"filename":"src/compress/deflate/reader.cr","line_number":36,"url":null},"def":{"name":"open","args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":"Bool"},{"name":"dict","default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"yields":1,"block_arity":1,"visibility":"Public","body":"reader = new(io, sync_close: sync_close, dict: dict)\nbegin\n  yield reader\nensure\n  reader.close\nend\n"},"external_var":false}],"constructors":[{"html_id":"gzip(input,sync_close:Bool=false):self-class-method","name":"gzip","doc":"Creates an instance of Flate::Reader for the gzip format.\nhas written.","summary":"<p>Creates an instance of Flate::Reader for the gzip format.</p>","abstract":false,"args":[{"name":"input","external_name":"input","restriction":""},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":"Bool"}],"args_string":"(input, sync_close : Bool = false) : self","args_html":"(input, sync_close : <a href=\"../../Bool.html\">Bool</a> = <span class=\"n\">false</span>) : <span class=\"k\">self</span>","location":{"filename":"src/compress/deflate/reader.cr","line_number":43,"url":null},"def":{"name":"gzip","args":[{"name":"input","external_name":"input","restriction":""},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":"Bool"}],"return_type":"self","visibility":"Public","body":"new(input, wbits: GZIP, sync_close: sync_close)"},"external_var":false},{"html_id":"new(io:IO,sync_close:Bool=false,dict:Bytes|Nil=nil)-class-method","name":"new","doc":"Creates an instance of Flate::Reader.","summary":"<p>Creates an instance of Flate::Reader.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":"Bool"},{"name":"dict","default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"args_string":"(io : IO, sync_close : Bool = false, dict : Bytes | Nil = nil)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, sync_close : <a href=\"../../Bool.html\">Bool</a> = <span class=\"n\">false</span>, dict : <a href=\"../../Bytes.html\">Bytes</a> | <a href=\"../../Nil.html\">Nil</a> = <span class=\"n\">nil</span>)","location":{"filename":"src/compress/deflate/reader.cr","line_number":22,"url":null},"def":{"name":"new","args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":"Bool"},{"name":"dict","default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"visibility":"Public","body":"_ = allocate\n_.initialize(io, sync_close, dict)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false}],"instance_methods":[{"html_id":"closed?:Bool-instance-method","name":"closed?","doc":"Returns `true` if this reader is closed.","summary":"<p>Returns <code>true</code> if this reader is closed.</p>","abstract":false,"location":{"filename":"src/compress/deflate/reader.cr","line_number":13,"url":null},"def":{"name":"closed?","visibility":"Public","body":"@closed"},"external_var":false},{"html_id":"dict:Bytes|Nil-instance-method","name":"dict","doc":"Dictionary passed in the constructor","summary":"<p>Dictionary passed in the constructor</p>","abstract":false,"location":{"filename":"src/compress/deflate/reader.cr","line_number":16,"url":null},"def":{"name":"dict","return_type":"Bytes | ::Nil","visibility":"Public","body":"@dict"},"external_var":false},{"html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Appends a String representation of this object\nwhich includes its class name, its object address\nand the values of all instance variables.\n\n```\nclass Person\n  def initialize(@name : String, @age : Int32)\n  end\nend\n\nPerson.new(\"John\", 32).inspect # => #<Person:0x10fd31f20 @name=\"John\", @age=32>\n```","summary":"<p>Appends a String representation of this object which includes its class name, its object address and the values of all instance variables.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"../../IO.html\">IO</a>) : <a href=\"../../Nil.html\">Nil</a>","location":{"filename":"src/compress/deflate/reader.cr","line_number":151,"url":null},"def":{"name":"inspect","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"to_s(io)"},"external_var":false},{"html_id":"sync_close=(sync_close:Bool)-instance-method","name":"sync_close=","doc":"If `#sync_close?` is `true`, closing this IO will close the underlying IO.","summary":"<p>If <code><a href=\"../../Compress/Deflate/Reader.html#sync_close%3F%3ABool-instance-method\">#sync_close?</a></code> is <code>true</code>, closing this IO will close the underlying IO.</p>","abstract":false,"args":[{"name":"sync_close","external_name":"sync_close","restriction":"Bool"}],"args_string":"(sync_close : Bool)","args_html":"(sync_close : <a href=\"../../Bool.html\">Bool</a>)","location":{"filename":"src/compress/deflate/reader.cr","line_number":10,"url":null},"def":{"name":"sync_close=","args":[{"name":"sync_close","external_name":"sync_close","restriction":"Bool"}],"visibility":"Public","body":"@sync_close = sync_close"},"external_var":false},{"html_id":"sync_close?:Bool-instance-method","name":"sync_close?","doc":"If `#sync_close?` is `true`, closing this IO will close the underlying IO.","summary":"<p>If <code><a href=\"../../Compress/Deflate/Reader.html#sync_close%3F%3ABool-instance-method\">#sync_close?</a></code> is <code>true</code>, closing this IO will close the underlying IO.</p>","abstract":false,"location":{"filename":"src/compress/deflate/reader.cr","line_number":10,"url":null},"def":{"name":"sync_close?","return_type":"Bool","visibility":"Public","body":"@sync_close"},"external_var":false},{"html_id":"unbuffered_close:Nil-instance-method","name":"unbuffered_close","doc":"Closes this reader.","summary":"<p>Closes this reader.</p>","abstract":false,"location":{"filename":"src/compress/deflate/reader.cr","line_number":133,"url":null},"def":{"name":"unbuffered_close","return_type":"Nil","visibility":"Public","body":"if @closed\n  return\nend\n@closed = true\n\nret = LibZ.inflateEnd(pointerof(@stream))\nif ret.ok?\nelse\n  raise(Compress::Deflate::Error.new(ret, @stream))\nend\n\nif @sync_close\n  @io.close\nend\n"},"external_var":false},{"html_id":"unbuffered_flush:NoReturn-instance-method","name":"unbuffered_flush","doc":"Flushes the wrapped `IO`.\n\nTODO: Add return type restriction `Nil`","summary":"<p>Flushes the wrapped <code><a href=\"../../IO.html\">IO</a></code>.</p>","abstract":false,"location":{"filename":"src/compress/deflate/reader.cr","line_number":128,"url":null},"def":{"name":"unbuffered_flush","return_type":"NoReturn","visibility":"Public","body":"raise(IO::Error.new(\"Can't flush Compress::Deflate::Reader\"))"},"external_var":false},{"html_id":"unbuffered_read(slice:Bytes):Int32-instance-method","name":"unbuffered_read","doc":"See `IO#read`.","summary":"<p>See <code><a href=\"../../IO.html#read%28slice%3ABytes%29-instance-method\">IO#read</a></code>.</p>","abstract":false,"args":[{"name":"slice","external_name":"slice","restriction":"Bytes"}],"args_string":"(slice : Bytes) : Int32","args_html":"(slice : <a href=\"../../Bytes.html\">Bytes</a>) : <a href=\"../../Int32.html\">Int32</a>","location":{"filename":"src/compress/deflate/reader.cr","line_number":60,"url":null},"def":{"name":"unbuffered_read","args":[{"name":"slice","external_name":"slice","restriction":"Bytes"}],"return_type":"Int32","visibility":"Public","body":"check_open\n\nif slice.empty?\n  return 0\nend\nif @end\n  return 0\nend\n\nwhile true\n  if @stream.avail_in == 0\n    @peek = @io.peek\n    if peek = @peek\n      @stream.next_in = peek\n      @stream.avail_in = peek.size\n    else\n      @stream.next_in = @buf.to_unsafe\n      @stream.avail_in = (@io.read(@buf.to_slice)).to_u32\n    end\n  end\n\n  old_avail_in = @stream.avail_in\n\n  @stream.avail_out = slice.size.to_u32\n  @stream.next_out = slice.to_unsafe\n\n  ret = LibZ.inflate(pointerof(@stream), LibZ::Flush::NO_FLUSH)\n  read_bytes = slice.size - @stream.avail_out\n\n\n  avail_in_diff = old_avail_in - @stream.avail_in\n  if @peek && avail_in_diff > 0\n    @io.skip(avail_in_diff)\n  end\n\n  case ret\n  when .need_dict?\n    if dict = @dict\n      ret = LibZ.inflateSetDictionary(pointerof(@stream), dict, dict.size)\n      if ret.ok?\n        next\n      end\n    end\n\n    raise(Compress::Deflate::Error.new(ret, @stream))\n  when .errno?, .data_error?, .mem_error?, .buf_error?, .version_error?\n    raise(Compress::Deflate::Error.new(ret, @stream))\n  when .stream_end?\n    @end = true\n    return read_bytes\n  else\n    if read_bytes == 0\n      next\n    else\n      return read_bytes\n    end\n  end\nend\n"},"external_var":false},{"html_id":"unbuffered_rewind:Nil-instance-method","name":"unbuffered_rewind","doc":"Rewinds the wrapped `IO`.\n\nTODO: Add return type restriction `Nil`","summary":"<p>Rewinds the wrapped <code><a href=\"../../IO.html\">IO</a></code>.</p>","abstract":false,"location":{"filename":"src/compress/deflate/reader.cr","line_number":143,"url":null},"def":{"name":"unbuffered_rewind","return_type":"Nil","visibility":"Public","body":"check_open\n\n@io.rewind\n\ninitialize(@io, @sync_close, @dict)\n"},"external_var":false},{"html_id":"unbuffered_write(slice:Bytes):NoReturn-instance-method","name":"unbuffered_write","doc":"Always raises `IO::Error` because this is a read-only `IO`.","summary":"<p>Always raises <code><a href=\"../../IO/Error.html\">IO::Error</a></code> because this is a read-only <code><a href=\"../../IO.html\">IO</a></code>.</p>","abstract":false,"args":[{"name":"slice","external_name":"slice","restriction":"Bytes"}],"args_string":"(slice : Bytes) : NoReturn","args_html":"(slice : <a href=\"../../Bytes.html\">Bytes</a>) : NoReturn","location":{"filename":"src/compress/deflate/reader.cr","line_number":55,"url":null},"def":{"name":"unbuffered_write","args":[{"name":"slice","external_name":"slice","restriction":"Bytes"}],"return_type":"NoReturn","visibility":"Public","body":"raise(IO::Error.new(\"Can't write to Compress::Deflate::Reader\"))"},"external_var":false}]},{"html_id":"Crystal/Compress/Deflate/Strategy","path":"Compress/Deflate/Strategy.html","kind":"enum","full_name":"Compress::Deflate::Strategy","name":"Strategy","abstract":false,"ancestors":[{"html_id":"Crystal/Enum","kind":"struct","full_name":"Enum","name":"Enum"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/compress/deflate/deflate.cr","line_number":17,"url":null}],"repository_name":"Crystal","program":false,"enum":true,"alias":false,"const":false,"constants":[{"id":"FILTERED","name":"FILTERED","value":"1"},{"id":"HUFFMAN_ONLY","name":"HUFFMAN_ONLY","value":"2"},{"id":"RLE","name":"RLE","value":"3"},{"id":"FIXED","name":"FIXED","value":"4"},{"id":"DEFAULT","name":"DEFAULT","value":"0"}],"namespace":{"html_id":"Crystal/Compress/Deflate","kind":"module","full_name":"Compress::Deflate","name":"Deflate"},"instance_methods":[{"html_id":"default?-instance-method","name":"default?","doc":"Returns `true` if this enum value equals `DEFAULT`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../../Compress/Deflate/Strategy.html#DEFAULT\">DEFAULT</a></code></p>","abstract":false,"location":{"filename":"src/compress/deflate/deflate.cr","line_number":22,"url":null},"def":{"name":"default?","visibility":"Public","body":"self == DEFAULT"},"external_var":false},{"html_id":"filtered?-instance-method","name":"filtered?","doc":"Returns `true` if this enum value equals `FILTERED`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../../Compress/Deflate/Strategy.html#FILTERED\">FILTERED</a></code></p>","abstract":false,"location":{"filename":"src/compress/deflate/deflate.cr","line_number":18,"url":null},"def":{"name":"filtered?","visibility":"Public","body":"self == FILTERED"},"external_var":false},{"html_id":"fixed?-instance-method","name":"fixed?","doc":"Returns `true` if this enum value equals `FIXED`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../../Compress/Deflate/Strategy.html#FIXED\">FIXED</a></code></p>","abstract":false,"location":{"filename":"src/compress/deflate/deflate.cr","line_number":21,"url":null},"def":{"name":"fixed?","visibility":"Public","body":"self == FIXED"},"external_var":false},{"html_id":"huffman_only?-instance-method","name":"huffman_only?","doc":"Returns `true` if this enum value equals `HUFFMAN_ONLY`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../../Compress/Deflate/Strategy.html#HUFFMAN_ONLY\">HUFFMAN_ONLY</a></code></p>","abstract":false,"location":{"filename":"src/compress/deflate/deflate.cr","line_number":19,"url":null},"def":{"name":"huffman_only?","visibility":"Public","body":"self == HUFFMAN_ONLY"},"external_var":false},{"html_id":"rle?-instance-method","name":"rle?","doc":"Returns `true` if this enum value equals `RLE`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../../Compress/Deflate/Strategy.html#RLE\">RLE</a></code></p>","abstract":false,"location":{"filename":"src/compress/deflate/deflate.cr","line_number":20,"url":null},"def":{"name":"rle?","visibility":"Public","body":"self == RLE"},"external_var":false}]},{"html_id":"Crystal/Compress/Deflate/Writer","path":"Compress/Deflate/Writer.html","kind":"class","full_name":"Compress::Deflate::Writer","name":"Writer","abstract":false,"superclass":{"html_id":"Crystal/IO","kind":"class","full_name":"IO","name":"IO"},"ancestors":[{"html_id":"Crystal/IO","kind":"class","full_name":"IO","name":"IO"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/compress/deflate/writer.cr","line_number":8,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"namespace":{"html_id":"Crystal/Compress/Deflate","kind":"module","full_name":"Compress::Deflate","name":"Deflate"},"doc":"A write-only `IO` object to compress data in the DEFLATE format.\n\nInstances of this class wrap another IO object. When you write to this\ninstance, it compresses the data and writes it to the underlying IO.\n\nNOTE: unless created with a block, `close` must be invoked after all\ndata has been written to a Flate::Writer instance.","summary":"<p>A write-only <code><a href=\"../../IO.html\">IO</a></code> object to compress data in the DEFLATE format.</p>","class_methods":[{"html_id":"open(io:IO,level:Int32=Compress::Deflate::DEFAULT_COMPRESSION,strategy:Compress::Deflate::Strategy=Compress::Deflate::Strategy::DEFAULT,sync_close:Bool=false,dict:Bytes|Nil=nil,&)-class-method","name":"open","doc":"Creates a new writer for the given *io*, yields it to the given block,\nand closes it at its end.","summary":"<p>Creates a new writer for the given <em>io</em>, yields it to the given block, and closes it at its end.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"level","default_value":"Compress::Deflate::DEFAULT_COMPRESSION","external_name":"level","restriction":"Int32"},{"name":"strategy","default_value":"Compress::Deflate::Strategy::DEFAULT","external_name":"strategy","restriction":"Compress::Deflate::Strategy"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":"Bool"},{"name":"dict","default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"args_string":"(io : IO, level : Int32 = Compress::Deflate::DEFAULT_COMPRESSION, strategy : Compress::Deflate::Strategy = Compress::Deflate::Strategy::DEFAULT, sync_close : Bool = false, dict : Bytes | Nil = nil, &)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, level : <a href=\"../../Int32.html\">Int32</a> = <span class=\"t\">Compress</span><span class=\"t\">::</span><span class=\"t\">Deflate</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>, strategy : <a href=\"../../Compress/Deflate/Strategy.html\">Compress::Deflate::Strategy</a> = <span class=\"t\">Compress</span><span class=\"t\">::</span><span class=\"t\">Deflate</span><span class=\"t\">::</span><span class=\"t\">Strategy</span><span class=\"t\">::</span><span class=\"t\">DEFAULT</span>, sync_close : <a href=\"../../Bool.html\">Bool</a> = <span class=\"n\">false</span>, dict : <a href=\"../../Bytes.html\">Bytes</a> | <a href=\"../../Nil.html\">Nil</a> = <span class=\"n\">nil</span>, &)","location":{"filename":"src/compress/deflate/writer.cr","line_number":33,"url":null},"def":{"name":"open","args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"level","default_value":"Compress::Deflate::DEFAULT_COMPRESSION","external_name":"level","restriction":"Int32"},{"name":"strategy","default_value":"Compress::Deflate::Strategy::DEFAULT","external_name":"strategy","restriction":"Compress::Deflate::Strategy"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":"Bool"},{"name":"dict","default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"yields":1,"block_arity":1,"visibility":"Public","body":"writer = new(io, level: level, strategy: strategy, sync_close: sync_close, dict: dict)\nbegin\n  yield writer\nensure\n  writer.close\nend\n"},"external_var":false}],"constructors":[{"html_id":"new(output:IO,level:Int32=Compress::Deflate::DEFAULT_COMPRESSION,strategy:Compress::Deflate::Strategy=Compress::Deflate::Strategy::DEFAULT,sync_close:Bool=false,dict:Bytes|Nil=nil)-class-method","name":"new","doc":"Creates an instance of Flate::Writer. `close` must be invoked after all data\nhas written.","summary":"<p>Creates an instance of Flate::Writer.</p>","abstract":false,"args":[{"name":"output","external_name":"output","restriction":"IO"},{"name":"level","default_value":"Compress::Deflate::DEFAULT_COMPRESSION","external_name":"level","restriction":"Int32"},{"name":"strategy","default_value":"Compress::Deflate::Strategy::DEFAULT","external_name":"strategy","restriction":"Compress::Deflate::Strategy"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":"Bool"},{"name":"dict","default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"args_string":"(output : IO, level : Int32 = Compress::Deflate::DEFAULT_COMPRESSION, strategy : Compress::Deflate::Strategy = Compress::Deflate::Strategy::DEFAULT, sync_close : Bool = false, dict : Bytes | Nil = nil)","args_html":"(output : <a href=\"../../IO.html\">IO</a>, level : <a href=\"../../Int32.html\">Int32</a> = <span class=\"t\">Compress</span><span class=\"t\">::</span><span class=\"t\">Deflate</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>, strategy : <a href=\"../../Compress/Deflate/Strategy.html\">Compress::Deflate::Strategy</a> = <span class=\"t\">Compress</span><span class=\"t\">::</span><span class=\"t\">Deflate</span><span class=\"t\">::</span><span class=\"t\">Strategy</span><span class=\"t\">::</span><span class=\"t\">DEFAULT</span>, sync_close : <a href=\"../../Bool.html\">Bool</a> = <span class=\"n\">false</span>, dict : <a href=\"../../Bytes.html\">Bytes</a> | <a href=\"../../Nil.html\">Nil</a> = <span class=\"n\">nil</span>)","location":{"filename":"src/compress/deflate/writer.cr","line_number":14,"url":null},"def":{"name":"new","args":[{"name":"output","external_name":"output","restriction":"IO"},{"name":"level","default_value":"Compress::Deflate::DEFAULT_COMPRESSION","external_name":"level","restriction":"Int32"},{"name":"strategy","default_value":"Compress::Deflate::Strategy::DEFAULT","external_name":"strategy","restriction":"Compress::Deflate::Strategy"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":"Bool"},{"name":"dict","default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"visibility":"Public","body":"_ = allocate\n_.initialize(output, level, strategy, sync_close, dict)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false}],"instance_methods":[{"html_id":"close:Nil-instance-method","name":"close","doc":"Closes this writer. Must be invoked after all data has been written.","summary":"<p>Closes this writer.</p>","abstract":false,"location":{"filename":"src/compress/deflate/writer.cr","line_number":65,"url":null},"def":{"name":"close","return_type":"Nil","visibility":"Public","body":"if @closed\n  return\nend\n@closed = true\n\n@stream.avail_in = 0\n@stream.next_in = Pointer(UInt8).null\nconsume_output(LibZ::Flush::FINISH)\n\nret = LibZ.deflateEnd(pointerof(@stream))\nif ret.ok?\nelse\n  raise(Compress::Deflate::Error.new(ret, @stream))\nend\n\nif @sync_close\n  @output.close\nend\n"},"external_var":false},{"html_id":"closed?:Bool-instance-method","name":"closed?","doc":"Returns `true` if this IO is closed.","summary":"<p>Returns <code>true</code> if this IO is closed.</p>","abstract":false,"location":{"filename":"src/compress/deflate/writer.cr","line_number":80,"url":null},"def":{"name":"closed?","return_type":"Bool","visibility":"Public","body":"@closed"},"external_var":false},{"html_id":"flush:Nil-instance-method","name":"flush","doc":"See `IO#flush`.","summary":"<p>See <code><a href=\"../../IO.html#flush-instance-method\">IO#flush</a></code>.</p>","abstract":false,"location":{"filename":"src/compress/deflate/writer.cr","line_number":57,"url":null},"def":{"name":"flush","return_type":"Nil","visibility":"Public","body":"if @closed\n  return\nend\n\nconsume_output(LibZ::Flush::SYNC_FLUSH)\n@output.flush\n"},"external_var":false},{"html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Appends a String representation of this object\nwhich includes its class name, its object address\nand the values of all instance variables.\n\n```\nclass Person\n  def initialize(@name : String, @age : Int32)\n  end\nend\n\nPerson.new(\"John\", 32).inspect # => #<Person:0x10fd31f20 @name=\"John\", @age=32>\n```","summary":"<p>Appends a String representation of this object which includes its class name, its object address and the values of all instance variables.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"../../IO.html\">IO</a>) : <a href=\"../../Nil.html\">Nil</a>","location":{"filename":"src/compress/deflate/writer.cr","line_number":84,"url":null},"def":{"name":"inspect","args":[{"name":"io","external_name":"io","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"to_s(io)"},"external_var":false},{"html_id":"read(slice:Bytes):NoReturn-instance-method","name":"read","doc":"Always raises `IO::Error` because this is a write-only `IO`.","summary":"<p>Always raises <code><a href=\"../../IO/Error.html\">IO::Error</a></code> because this is a write-only <code><a href=\"../../IO.html\">IO</a></code>.</p>","abstract":false,"args":[{"name":"slice","external_name":"slice","restriction":"Bytes"}],"args_string":"(slice : Bytes) : NoReturn","args_html":"(slice : <a href=\"../../Bytes.html\">Bytes</a>) : NoReturn","location":{"filename":"src/compress/deflate/writer.cr","line_number":41,"url":null},"def":{"name":"read","args":[{"name":"slice","external_name":"slice","restriction":"Bytes"}],"return_type":"NoReturn","visibility":"Public","body":"raise(\"Can't read from Flate::Writer\")"},"external_var":false},{"html_id":"sync_close=(sync_close:Bool)-instance-method","name":"sync_close=","doc":"If `#sync_close?` is `true`, closing this IO will close the underlying IO.","summary":"<p>If <code><a href=\"../../Compress/Deflate/Writer.html#sync_close%3F%3ABool-instance-method\">#sync_close?</a></code> is <code>true</code>, closing this IO will close the underlying IO.</p>","abstract":false,"args":[{"name":"sync_close","external_name":"sync_close","restriction":"Bool"}],"args_string":"(sync_close : Bool)","args_html":"(sync_close : <a href=\"../../Bool.html\">Bool</a>)","location":{"filename":"src/compress/deflate/writer.cr","line_number":10,"url":null},"def":{"name":"sync_close=","args":[{"name":"sync_close","external_name":"sync_close","restriction":"Bool"}],"visibility":"Public","body":"@sync_close = sync_close"},"external_var":false},{"html_id":"sync_close?:Bool-instance-method","name":"sync_close?","doc":"If `#sync_close?` is `true`, closing this IO will close the underlying IO.","summary":"<p>If <code><a href=\"../../Compress/Deflate/Writer.html#sync_close%3F%3ABool-instance-method\">#sync_close?</a></code> is <code>true</code>, closing this IO will close the underlying IO.</p>","abstract":false,"location":{"filename":"src/compress/deflate/writer.cr","line_number":10,"url":null},"def":{"name":"sync_close?","return_type":"Bool","visibility":"Public","body":"@sync_close"},"external_var":false},{"html_id":"write(slice:Bytes):Nil-instance-method","name":"write","doc":"See `IO#write`.","summary":"<p>See <code><a href=\"../../IO.html#write%28slice%3ABytes%29%3ANil-instance-method\">IO#write</a></code>.</p>","abstract":false,"args":[{"name":"slice","external_name":"slice","restriction":"Bytes"}],"args_string":"(slice : Bytes) : Nil","args_html":"(slice : <a href=\"../../Bytes.html\">Bytes</a>) : <a href=\"../../Nil.html\">Nil</a>","location":{"filename":"src/compress/deflate/writer.cr","line_number":46,"url":null},"def":{"name":"write","args":[{"name":"slice","external_name":"slice","restriction":"Bytes"}],"return_type":"Nil","visibility":"Public","body":"check_open\n\nif slice.empty?\n  return\nend\n\n@stream.avail_in = slice.size\n@stream.next_in = slice\nconsume_output(LibZ::Flush::NO_FLUSH)\n"},"external_var":false}]}]},{"html_id":"Crystal/Compress/Gzip","path":"Compress/Gzip.html","kind":"module","full_name":"Compress::Gzip","name":"Gzip","abstract":false,"locations":[{"filename":"src/compress/gzip/gzip.cr","line_number":8,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"constants":[{"id":"BEST_COMPRESSION","name":"BEST_COMPRESSION","value":"Compress::Deflate::BEST_COMPRESSION"},{"id":"BEST_SPEED","name":"BEST_SPEED","value":"Compress::Deflate::BEST_SPEED"},{"id":"DEFAULT_COMPRESSION","name":"DEFAULT_COMPRESSION","value":"Compress::Deflate::DEFAULT_COMPRESSION"},{"id":"NO_COMPRESSION","name":"NO_COMPRESSION","value":"Compress::Deflate::NO_COMPRESSION"}],"namespace":{"html_id":"Crystal/Compress","kind":"module","full_name":"Compress","name":"Compress"},"doc":"The Gzip module contains readers and writers of gzip format compressed\ndata, as specified in [RFC 1952](https://www.ietf.org/rfc/rfc1952.txt).\n\nNOTE: To use `Gzip` or its children, you must explicitly import it with `require \"compress/gzip\"`","summary":"<p>The Gzip module contains readers and writers of gzip format compressed data, as specified in <a href=\"https://www.ietf.org/rfc/rfc1952.txt\">RFC 1952</a>.</p>","types":[{"html_id":"Crystal/Compress/Gzip/Error","path":"Compress/Gzip/Error.html","kind":"class","full_name":"Compress::Gzip::Error","name":"Error","abstract":false,"superclass":{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},"ancestors":[{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/compress/gzip/gzip.cr","line_number":18,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"namespace":{"html_id":"Crystal/Compress/Gzip","kind":"module","full_name":"Compress::Gzip","name":"Gzip"}},{"html_id":"Crystal/Compress/Gzip/Header","path":"Compress/Gzip/Header.html","kind":"class","full_name":"Compress::Gzip::Header","name":"Header","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/compress/gzip/header.cr","line_number":2,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"namespace":{"html_id":"Crystal/Compress/Gzip","kind":"module","full_name":"Compress::Gzip","name":"Gzip"},"doc":"A header in a gzip stream.","summary":"<p>A header in a gzip stream.</p>","instance_methods":[{"html_id":"comment:String|Nil-instance-method","name":"comment","abstract":false,"location":{"filename":"src/compress/gzip/header.cr","line_number":7,"url":null},"def":{"name":"comment","return_type":"String | ::Nil","visibility":"Public","body":"@comment"},"external_var":false},{"html_id":"comment=(comment:String|Nil)-instance-method","name":"comment=","abstract":false,"args":[{"name":"comment","external_name":"comment","restriction":"String | ::Nil"}],"args_string":"(comment : String | Nil)","args_html":"(comment : <a href=\"../../String.html\">String</a> | <a href=\"../../Nil.html\">Nil</a>)","location":{"filename":"src/compress/gzip/header.cr","line_number":7,"url":null},"def":{"name":"comment=","args":[{"name":"comment","external_name":"comment","restriction":"String | ::Nil"}],"visibility":"Public","body":"@comment = comment"},"external_var":false},{"html_id":"extra:Slice(UInt8)-instance-method","name":"extra","abstract":false,"location":{"filename":"src/compress/gzip/header.cr","line_number":5,"url":null},"def":{"name":"extra","visibility":"Public","body":"@extra"},"external_var":false},{"html_id":"extra=(extra:Slice(UInt8))-instance-method","name":"extra=","abstract":false,"args":[{"name":"extra","external_name":"extra","restriction":"::Slice(::UInt8)"}],"args_string":"(extra : Slice(UInt8))","args_html":"(extra : <a href=\"../../Slice.html\">Slice</a>(<a href=\"../../UInt8.html\">UInt8</a>))","location":{"filename":"src/compress/gzip/header.cr","line_number":5,"url":null},"def":{"name":"extra=","args":[{"name":"extra","external_name":"extra","restriction":"::Slice(::UInt8)"}],"visibility":"Public","body":"@extra = extra"},"external_var":false},{"html_id":"modification_time:Time-instance-method","name":"modification_time","abstract":false,"location":{"filename":"src/compress/gzip/header.cr","line_number":3,"url":null},"def":{"name":"modification_time","return_type":"Time","visibility":"Public","body":"@modification_time"},"external_var":false},{"html_id":"modification_time=(modification_time:Time)-instance-method","name":"modification_time=","abstract":false,"args":[{"name":"modification_time","external_name":"modification_time","restriction":"Time"}],"args_string":"(modification_time : Time)","args_html":"(modification_time : <a href=\"../../Time.html\">Time</a>)","location":{"filename":"src/compress/gzip/header.cr","line_number":3,"url":null},"def":{"name":"modification_time=","args":[{"name":"modification_time","external_name":"modification_time","restriction":"Time"}],"visibility":"Public","body":"@modification_time = modification_time"},"external_var":false},{"html_id":"name:String|Nil-instance-method","name":"name","abstract":false,"location":{"filename":"src/compress/gzip/header.cr","line_number":6,"url":null},"def":{"name":"name","return_type":"String | ::Nil","visibility":"Public","body":"@name"},"external_var":false},{"html_id":"name=(name:String|Nil)-instance-method","name":"name=","abstract":false,"args":[{"name":"name","external_name":"name","restriction":"String | ::Nil"}],"args_string":"(name : String | Nil)","args_html":"(name : <a href=\"../../String.html\">String</a> | <a href=\"../../Nil.html\">Nil</a>)","location":{"filename":"src/compress/gzip/header.cr","line_number":6,"url":null},"def":{"name":"name=","args":[{"name":"name","external_name":"name","restriction":"String | ::Nil"}],"visibility":"Public","body":"@name = name"},"external_var":false},{"html_id":"os:UInt8-instance-method","name":"os","abstract":false,"location":{"filename":"src/compress/gzip/header.cr","line_number":4,"url":null},"def":{"name":"os","return_type":"UInt8","visibility":"Public","body":"@os"},"external_var":false},{"html_id":"os=(os:UInt8)-instance-method","name":"os=","abstract":false,"args":[{"name":"os","external_name":"os","restriction":"UInt8"}],"args_string":"(os : UInt8)","args_html":"(os : <a href=\"../../UInt8.html\">UInt8</a>)","location":{"filename":"src/compress/gzip/header.cr","line_number":4,"url":null},"def":{"name":"os=","args":[{"name":"os","external_name":"os","restriction":"UInt8"}],"visibility":"Public","body":"@os = os"},"external_var":false}]},{"html_id":"Crystal/Compress/Gzip/Reader","path":"Compress/Gzip/Reader.html","kind":"class","full_name":"Compress::Gzip::Reader","name":"Reader","abstract":false,"superclass":{"html_id":"Crystal/IO","kind":"class","full_name":"IO","name":"IO"},"ancestors":[{"html_id":"Crystal/IO/Buffered","kind":"module","full_name":"IO::Buffered","name":"Buffered"},{"html_id":"Crystal/IO","kind":"class","full_name":"IO","name":"IO"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/compress/gzip/reader.cr","line_number":29,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"included_modules":[{"html_id":"Crystal/IO/Buffered","kind":"module","full_name":"IO::Buffered","name":"Buffered"}],"namespace":{"html_id":"Crystal/Compress/Gzip","kind":"module","full_name":"Compress::Gzip","name":"Gzip"},"doc":"A read-only `IO` object to decompress data in the gzip format.\n\nInstances of this class wrap another IO object. When you read from this instance\ninstance, it reads data from the underlying IO, decompresses it, and returns\nit to the caller.\n\nNOTE: A gzip stream can contain zero or more members. If it contains\nno members, `header` will be `nil`. If it contains one or more\nmembers, only the first header will be recorded here. This is\nbecause gzipping multiple members is not common as one usually\ncombines gzip with tar. If, however, multiple members are present\nthen reading from this reader will return the concatenation of\nall the members.\n\n### Example: decompress a gzip file\n\n```\nrequire \"compress/gzip\"\n\nFile.write(\"file.gzip\", Bytes[31, 139, 8, 0, 0, 0, 0, 0, 0, 3, 75, 76, 74, 6, 0, 194, 65, 36, 53, 3, 0, 0, 0])\n\nstring = File.open(\"file.gzip\") do |file|\n  Compress::Gzip::Reader.open(file) do |gzip|\n    gzip.gets_to_end\n  end\nend\nstring # => \"abc\"\n```","summary":"<p>A read-only <code><a href=\"../../IO.html\">IO</a></code> object to decompress data in the gzip format.</p>","class_methods":[{"html_id":"open(io:IO,sync_close=false,&)-class-method","name":"open","doc":"Creates a new reader from the given *io*, yields it to the given block,\nand closes it at the end.","summary":"<p>Creates a new reader from the given <em>io</em>, yields it to the given block, and closes it at the end.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":""}],"args_string":"(io : IO, sync_close = false, &)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, sync_close = <span class=\"n\">false</span>, &)","location":{"filename":"src/compress/gzip/reader.cr","line_number":68,"url":null},"def":{"name":"open","args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":""}],"yields":1,"block_arity":1,"visibility":"Public","body":"reader = new(io, sync_close: sync_close)\nbegin\n  yield reader\nensure\n  reader.close\nend\n"},"external_var":false},{"html_id":"open(filename:String,&)-class-method","name":"open","doc":"Creates a new reader from the given *filename*, yields it to the given block,\nand closes it at the end.","summary":"<p>Creates a new reader from the given <em>filename</em>, yields it to the given block, and closes it at the end.</p>","abstract":false,"args":[{"name":"filename","external_name":"filename","restriction":"String"}],"args_string":"(filename : String, &)","args_html":"(filename : <a href=\"../../String.html\">String</a>, &)","location":{"filename":"src/compress/gzip/reader.cr","line_number":75,"url":null},"def":{"name":"open","args":[{"name":"filename","external_name":"filename","restriction":"String"}],"yields":1,"block_arity":1,"visibility":"Public","body":"reader = new(filename)\nbegin\n  yield reader\nensure\n  reader.close\nend\n"},"external_var":false}],"constructors":[{"html_id":"new(io:IO,sync_close:Bool=false)-class-method","name":"new","doc":"Creates a new reader from the given *io*.","summary":"<p>Creates a new reader from the given <em>io</em>.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":"::Bool"}],"args_string":"(io : IO, sync_close : Bool = false)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, sync_close : <a href=\"../../Bool.html\">Bool</a> = <span class=\"n\">false</span>)","location":{"filename":"src/compress/gzip/reader.cr","line_number":44,"url":null},"def":{"name":"new","args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":"::Bool"}],"visibility":"Public","body":"_ = allocate\n_.initialize(io, sync_close)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(filename:String)-class-method","name":"new","doc":"Creates a new reader from the given *filename*.","summary":"<p>Creates a new reader from the given <em>filename</em>.</p>","abstract":false,"args":[{"name":"filename","external_name":"filename","restriction":"String"}],"args_string":"(filename : String)","args_html":"(filename : <a href=\"../../String.html\">String</a>)","location":{"filename":"src/compress/gzip/reader.cr","line_number":62,"url":null},"def":{"name":"new","args":[{"name":"filename","external_name":"filename","restriction":"String"}],"visibility":"Public","body":"new(::File.new(filename), sync_close: true)"},"external_var":false}],"instance_methods":[{"html_id":"closed?:Bool-instance-method","name":"closed?","doc":"Returns `true` if this reader is closed.","summary":"<p>Returns <code>true</code> if this reader is closed.</p>","abstract":false,"location":{"filename":"src/compress/gzip/reader.cr","line_number":36,"url":null},"def":{"name":"closed?","visibility":"Public","body":"@closed"},"external_var":false},{"html_id":"header:Header|Nil-instance-method","name":"header","doc":"Returns the first header in the gzip stream, if any.","summary":"<p>Returns the first header in the gzip stream, if any.</p>","abstract":false,"location":{"filename":"src/compress/gzip/reader.cr","line_number":39,"url":null},"def":{"name":"header","return_type":"Header | ::Nil","visibility":"Public","body":"@header"},"external_var":false},{"html_id":"sync_close=(sync_close:Bool)-instance-method","name":"sync_close=","doc":"Whether to close the enclosed `IO` when closing this reader.","summary":"<p>Whether to close the enclosed <code><a href=\"../../IO.html\">IO</a></code> when closing this reader.</p>","abstract":false,"args":[{"name":"sync_close","external_name":"sync_close","restriction":"::Bool"}],"args_string":"(sync_close : Bool)","args_html":"(sync_close : <a href=\"../../Bool.html\">Bool</a>)","location":{"filename":"src/compress/gzip/reader.cr","line_number":33,"url":null},"def":{"name":"sync_close=","args":[{"name":"sync_close","external_name":"sync_close","restriction":"::Bool"}],"visibility":"Public","body":"@sync_close = sync_close"},"external_var":false},{"html_id":"sync_close?:Bool-instance-method","name":"sync_close?","doc":"Whether to close the enclosed `IO` when closing this reader.","summary":"<p>Whether to close the enclosed <code><a href=\"../../IO.html\">IO</a></code> when closing this reader.</p>","abstract":false,"location":{"filename":"src/compress/gzip/reader.cr","line_number":33,"url":null},"def":{"name":"sync_close?","visibility":"Public","body":"@sync_close"},"external_var":false},{"html_id":"unbuffered_close:Nil-instance-method","name":"unbuffered_close","doc":"Closes this reader.","summary":"<p>Closes this reader.</p>","abstract":false,"location":{"filename":"src/compress/gzip/reader.cr","line_number":141,"url":null},"def":{"name":"unbuffered_close","return_type":"Nil","visibility":"Public","body":"if @closed\n  return\nend\n@closed = true\n\n@flate_io.try(&.close)\nif @sync_close\n  @io.close\nend\n"},"external_var":false},{"html_id":"unbuffered_flush:NoReturn-instance-method","name":"unbuffered_flush","doc":"Flushes the wrapped `IO`.\n\nTODO: Add return type restriction `Nil`","summary":"<p>Flushes the wrapped <code><a href=\"../../IO.html\">IO</a></code>.</p>","abstract":false,"location":{"filename":"src/compress/gzip/reader.cr","line_number":136,"url":null},"def":{"name":"unbuffered_flush","return_type":"NoReturn","visibility":"Public","body":"raise(IO::Error.new(\"Can't flush Compress::Gzip::Reader\"))"},"external_var":false},{"html_id":"unbuffered_read(slice:Bytes):Int32-instance-method","name":"unbuffered_read","doc":"See `IO#read`.","summary":"<p>See <code><a href=\"../../IO.html#read%28slice%3ABytes%29-instance-method\">IO#read</a></code>.</p>","abstract":false,"args":[{"name":"slice","external_name":"slice","restriction":"Bytes"}],"args_string":"(slice : Bytes) : Int32","args_html":"(slice : <a href=\"../../Bytes.html\">Bytes</a>) : <a href=\"../../Int32.html\">Int32</a>","location":{"filename":"src/compress/gzip/reader.cr","line_number":81,"url":null},"def":{"name":"unbuffered_read","args":[{"name":"slice","external_name":"slice","restriction":"Bytes"}],"return_type":"Int32","visibility":"Public","body":"check_open\n\nif slice.empty?\n  return 0\nend\n\nwhile true\n  flate_io = @flate_io\n  if flate_io\n  else\n    return 0\n  end\n\n  read_bytes = flate_io.read(slice)\n  if read_bytes == 0\n    crc32 = @io.read_bytes(UInt32, IO::ByteFormat::LittleEndian)\n    isize = @io.read_bytes(UInt32, IO::ByteFormat::LittleEndian)\n\n    if crc32 != @crc32\n      raise(Compress::Gzip::Error.new(\"CRC32 checksum mismatch\"))\n    end\n\n    if isize != @isize\n      raise(Compress::Gzip::Error.new(\"isize mismatch\"))\n    end\n\n\n    @crc32 = ::Digest::CRC32.initial\n    @isize = 0_u32\n\n\n    first_byte = @io.read_byte\n    if first_byte\n      Header.new(first_byte, @io)\n      @flate_io = Compress::Deflate::Reader.new(@io)\n    else\n      @flate_io = nil\n      break\n    end\n  else\n    @crc32 = ::Digest::CRC32.update(slice[0, read_bytes], @crc32)\n\n\n\n    @isize = @isize &+ read_bytes\n\n    break\n  end\nend\n\nread_bytes\n"},"external_var":false},{"html_id":"unbuffered_rewind:Nil-instance-method","name":"unbuffered_rewind","doc":"Rewinds the wrapped `IO`.\n\nTODO: Add return type restriction `Nil`","summary":"<p>Rewinds the wrapped <code><a href=\"../../IO.html\">IO</a></code>.</p>","abstract":false,"location":{"filename":"src/compress/gzip/reader.cr","line_number":149,"url":null},"def":{"name":"unbuffered_rewind","return_type":"Nil","visibility":"Public","body":"check_open\n\n@io.rewind\n\n@header = nil\n@flate_io = nil\n\ninitialize(@io, @sync_close)\n"},"external_var":false},{"html_id":"unbuffered_write(slice:Bytes):NoReturn-instance-method","name":"unbuffered_write","doc":"Always raises `IO::Error` because this is a read-only `IO`.","summary":"<p>Always raises <code><a href=\"../../IO/Error.html\">IO::Error</a></code> because this is a read-only <code><a href=\"../../IO.html\">IO</a></code>.</p>","abstract":false,"args":[{"name":"slice","external_name":"slice","restriction":"Bytes"}],"args_string":"(slice : Bytes) : NoReturn","args_html":"(slice : <a href=\"../../Bytes.html\">Bytes</a>) : NoReturn","location":{"filename":"src/compress/gzip/reader.cr","line_number":132,"url":null},"def":{"name":"unbuffered_write","args":[{"name":"slice","external_name":"slice","restriction":"Bytes"}],"return_type":"NoReturn","visibility":"Public","body":"raise(IO::Error.new(\"Can't write to Compress::Gzip::Reader\"))"},"external_var":false}]},{"html_id":"Crystal/Compress/Gzip/Writer","path":"Compress/Gzip/Writer.html","kind":"class","full_name":"Compress::Gzip::Writer","name":"Writer","abstract":false,"superclass":{"html_id":"Crystal/IO","kind":"class","full_name":"IO","name":"IO"},"ancestors":[{"html_id":"Crystal/IO","kind":"class","full_name":"IO","name":"IO"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/compress/gzip/writer.cr","line_number":24,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"namespace":{"html_id":"Crystal/Compress/Gzip","kind":"module","full_name":"Compress::Gzip","name":"Gzip"},"doc":"A write-only `IO` object to compress data in the gzip format.\n\nInstances of this class wrap another `IO` object. When you write to this\ninstance, it compresses the data and writes it to the underlying `IO`.\n\nNOTE: unless created with a block, `close` must be invoked after all\ndata has been written to a `Gzip::Writer` instance.\n\n### Example: compress a file\n\n```\nrequire \"compress/gzip\"\n\nFile.write(\"file.txt\", \"abc\")\n\nFile.open(\"./file.txt\", \"r\") do |input_file|\n  File.open(\"./file.gzip\", \"w\") do |output_file|\n    Compress::Gzip::Writer.open(output_file) do |gzip|\n      IO.copy(input_file, gzip)\n    end\n  end\nend\n```","summary":"<p>A write-only <code><a href=\"../../IO.html\">IO</a></code> object to compress data in the gzip format.</p>","class_methods":[{"html_id":"open(io:IO,level=Compress::Gzip::DEFAULT_COMPRESSION,sync_close=false,&)-class-method","name":"open","doc":"Creates a new writer to the given *io*, yields it to the given block,\nand closes it at the end.","summary":"<p>Creates a new writer to the given <em>io</em>, yields it to the given block, and closes it at the end.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"level","default_value":"Compress::Gzip::DEFAULT_COMPRESSION","external_name":"level","restriction":""},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":""}],"args_string":"(io : IO, level = Compress::Gzip::DEFAULT_COMPRESSION, sync_close = false, &)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, level = <span class=\"t\">Compress</span><span class=\"t\">::</span><span class=\"t\">Gzip</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>, sync_close = <span class=\"n\">false</span>, &)","location":{"filename":"src/compress/gzip/writer.cr","line_number":53,"url":null},"def":{"name":"open","args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"level","default_value":"Compress::Gzip::DEFAULT_COMPRESSION","external_name":"level","restriction":""},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":""}],"yields":1,"block_arity":1,"visibility":"Public","body":"writer = new(io, level: level, sync_close: sync_close)\nbegin\n  yield writer\nensure\n  writer.close\nend\n"},"external_var":false},{"html_id":"open(filename:String,level=Compress::Gzip::DEFAULT_COMPRESSION,&)-class-method","name":"open","doc":"Creates a new writer to the given *filename*, yields it to the given block,\nand closes it at the end.","summary":"<p>Creates a new writer to the given <em>filename</em>, yields it to the given block, and closes it at the end.</p>","abstract":false,"args":[{"name":"filename","external_name":"filename","restriction":"String"},{"name":"level","default_value":"Compress::Gzip::DEFAULT_COMPRESSION","external_name":"level","restriction":""}],"args_string":"(filename : String, level = Compress::Gzip::DEFAULT_COMPRESSION, &)","args_html":"(filename : <a href=\"../../String.html\">String</a>, level = <span class=\"t\">Compress</span><span class=\"t\">::</span><span class=\"t\">Gzip</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>, &)","location":{"filename":"src/compress/gzip/writer.cr","line_number":60,"url":null},"def":{"name":"open","args":[{"name":"filename","external_name":"filename","restriction":"String"},{"name":"level","default_value":"Compress::Gzip::DEFAULT_COMPRESSION","external_name":"level","restriction":""}],"yields":1,"block_arity":1,"visibility":"Public","body":"writer = new(filename, level: level)\nbegin\n  yield writer\nensure\n  writer.close\nend\n"},"external_var":false}],"constructors":[{"html_id":"new(io:IO,level:Int32=Compress::Gzip::DEFAULT_COMPRESSION,sync_close:Bool=false)-class-method","name":"new","doc":"Creates a new writer to the given *io*.","summary":"<p>Creates a new writer to the given <em>io</em>.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"level","default_value":"Compress::Gzip::DEFAULT_COMPRESSION","external_name":"level","restriction":"::Int32"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":"::Bool"}],"args_string":"(io : IO, level : Int32 = Compress::Gzip::DEFAULT_COMPRESSION, sync_close : Bool = false)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, level : <a href=\"../../Int32.html\">Int32</a> = <span class=\"t\">Compress</span><span class=\"t\">::</span><span class=\"t\">Gzip</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>, sync_close : <a href=\"../../Bool.html\">Bool</a> = <span class=\"n\">false</span>)","location":{"filename":"src/compress/gzip/writer.cr","line_number":38,"url":null},"def":{"name":"new","args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"level","default_value":"Compress::Gzip::DEFAULT_COMPRESSION","external_name":"level","restriction":"::Int32"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":"::Bool"}],"visibility":"Public","body":"_ = allocate\n_.initialize(io, level, sync_close)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(filename:String,level=Compress::Gzip::DEFAULT_COMPRESSION)-class-method","name":"new","doc":"Creates a new writer to the given *filename*.","summary":"<p>Creates a new writer to the given <em>filename</em>.</p>","abstract":false,"args":[{"name":"filename","external_name":"filename","restriction":"String"},{"name":"level","default_value":"Compress::Gzip::DEFAULT_COMPRESSION","external_name":"level","restriction":""}],"args_string":"(filename : String, level = Compress::Gzip::DEFAULT_COMPRESSION)","args_html":"(filename : <a href=\"../../String.html\">String</a>, level = <span class=\"t\">Compress</span><span class=\"t\">::</span><span class=\"t\">Gzip</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>)","location":{"filename":"src/compress/gzip/writer.cr","line_number":47,"url":null},"def":{"name":"new","args":[{"name":"filename","external_name":"filename","restriction":"String"},{"name":"level","default_value":"Compress::Gzip::DEFAULT_COMPRESSION","external_name":"level","restriction":""}],"visibility":"Public","body":"new(::File.new(filename, \"w\"), level: level, sync_close: true)"},"external_var":false}],"instance_methods":[{"html_id":"close:Nil-instance-method","name":"close","doc":"Closes this writer. Must be invoked after all data has been written.","summary":"<p>Closes this writer.</p>","abstract":false,"location":{"filename":"src/compress/gzip/writer.cr","line_number":99,"url":null},"def":{"name":"close","return_type":"Nil","visibility":"Public","body":"if @closed\n  return\nend\n@closed = true\n\nflate_io = write_header\nflate_io.close\n\n@io.write_bytes(@crc32, IO::ByteFormat::LittleEndian)\n@io.write_bytes(@isize, IO::ByteFormat::LittleEndian)\n\nif @sync_close\n  @io.close\nend\n"},"external_var":false},{"html_id":"closed?:Bool-instance-method","name":"closed?","doc":"Returns `true` if this writer is closed.","summary":"<p>Returns <code>true</code> if this writer is closed.</p>","abstract":false,"location":{"filename":"src/compress/gzip/writer.cr","line_number":29,"url":null},"def":{"name":"closed?","visibility":"Public","body":"@closed"},"external_var":false},{"html_id":"flush:Nil-instance-method","name":"flush","doc":"Flushes data, forcing writing the gzip header if no\ndata has been written yet.\n\nSee `IO#flush`.","summary":"<p>Flushes data, forcing writing the gzip header if no data has been written yet.</p>","abstract":false,"location":{"filename":"src/compress/gzip/writer.cr","line_number":91,"url":null},"def":{"name":"flush","return_type":"Nil","visibility":"Public","body":"check_open\n\nflate_io = write_header\nflate_io.flush\n"},"external_var":false},{"html_id":"header:Compress::Gzip::Header-instance-method","name":"header","doc":"The header to write to the gzip stream. It will be\nwritten just before the first write to this writer.\nChanges to the header after the first write are\nignored.","summary":"<p>The header to write to the gzip stream.</p>","abstract":false,"location":{"filename":"src/compress/gzip/writer.cr","line_number":35,"url":null},"def":{"name":"header","visibility":"Public","body":"@header"},"external_var":false},{"html_id":"read(slice:Bytes):NoReturn-instance-method","name":"read","doc":"Always raises `IO::Error` because this is a write-only `IO`.","summary":"<p>Always raises <code><a href=\"../../IO/Error.html\">IO::Error</a></code> because this is a write-only <code><a href=\"../../IO.html\">IO</a></code>.</p>","abstract":false,"args":[{"name":"slice","external_name":"slice","restriction":"Bytes"}],"args_string":"(slice : Bytes) : NoReturn","args_html":"(slice : <a href=\"../../Bytes.html\">Bytes</a>) : NoReturn","location":{"filename":"src/compress/gzip/writer.cr","line_number":66,"url":null},"def":{"name":"read","args":[{"name":"slice","external_name":"slice","restriction":"Bytes"}],"return_type":"NoReturn","visibility":"Public","body":"raise(IO::Error.new(\"Can't read from Gzip::Writer\"))"},"external_var":false},{"html_id":"sync_close=(sync_close:Bool)-instance-method","name":"sync_close=","doc":"Whether to close the enclosed `IO` when closing this writer.","summary":"<p>Whether to close the enclosed <code><a href=\"../../IO.html\">IO</a></code> when closing this writer.</p>","abstract":false,"args":[{"name":"sync_close","external_name":"sync_close","restriction":"::Bool"}],"args_string":"(sync_close : Bool)","args_html":"(sync_close : <a href=\"../../Bool.html\">Bool</a>)","location":{"filename":"src/compress/gzip/writer.cr","line_number":26,"url":null},"def":{"name":"sync_close=","args":[{"name":"sync_close","external_name":"sync_close","restriction":"::Bool"}],"visibility":"Public","body":"@sync_close = sync_close"},"external_var":false},{"html_id":"sync_close?:Bool-instance-method","name":"sync_close?","doc":"Whether to close the enclosed `IO` when closing this writer.","summary":"<p>Whether to close the enclosed <code><a href=\"../../IO.html\">IO</a></code> when closing this writer.</p>","abstract":false,"location":{"filename":"src/compress/gzip/writer.cr","line_number":26,"url":null},"def":{"name":"sync_close?","visibility":"Public","body":"@sync_close"},"external_var":false},{"html_id":"write(slice:Bytes):Nil-instance-method","name":"write","doc":"See `IO#write`.","summary":"<p>See <code><a href=\"../../IO.html#write%28slice%3ABytes%29%3ANil-instance-method\">IO#write</a></code>.</p>","abstract":false,"args":[{"name":"slice","external_name":"slice","restriction":"Bytes"}],"args_string":"(slice : Bytes) : Nil","args_html":"(slice : <a href=\"../../Bytes.html\">Bytes</a>) : <a href=\"../../Nil.html\">Nil</a>","location":{"filename":"src/compress/gzip/writer.cr","line_number":71,"url":null},"def":{"name":"write","args":[{"name":"slice","external_name":"slice","restriction":"Bytes"}],"return_type":"Nil","visibility":"Public","body":"check_open\n\nif slice.empty?\n  return\nend\n\nflate_io = write_header\nflate_io.write(slice)\n\n\n@crc32 = ::Digest::CRC32.update(slice, @crc32)\n\n\n\n@isize = @isize &+ slice.size\n"},"external_var":false}]}]},{"html_id":"Crystal/Compress/Zip","path":"Compress/Zip.html","kind":"module","full_name":"Compress::Zip","name":"Zip","abstract":false,"locations":[{"filename":"src/compress/zip/checksum_reader.cr","line_number":1,"url":null},{"filename":"src/compress/zip/checksum_writer.cr","line_number":1,"url":null},{"filename":"src/compress/zip/zip.cr","line_number":31,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"constants":[{"id":"CENTRAL_DIRECTORY_HEADER_SIGNATURE","name":"CENTRAL_DIRECTORY_HEADER_SIGNATURE","value":"33639248"},{"id":"END_OF_CENTRAL_DIRECTORY_HEADER_SIGNATURE","name":"END_OF_CENTRAL_DIRECTORY_HEADER_SIGNATURE","value":"101010256"},{"id":"VERSION","name":"VERSION","value":"20_u16"}],"namespace":{"html_id":"Crystal/Compress","kind":"module","full_name":"Compress","name":"Compress"},"doc":"The Compress::Zip module contains readers and writers of the zip\nfile format, described at [PKWARE's site](https://pkware.cachefly.net/webdocs/APPNOTE/APPNOTE-6.3.3.TXT).\n\nNOTE: To use `Zip` or its children, you must explicitly import it with `require \"compress/zip\"`\n\n### Reading zip files\n\nTwo types are provided to read from zip files:\n* `Compress::Zip::File`: can read zip entries from a `File` or from an `IO::Memory`\nand provides random read access to its entries.\n* `Compress::Zip::Reader`: can only read zip entries sequentially from any `IO`.\n\n`Compress::Zip::File` is the preferred method to read zip files if you\ncan provide a `File`, because it's a bit more flexible and provides\nmore complete information for zip entries (such as comments).\n\nWhen reading zip files, CRC32 checksum values are automatically\nverified when finishing reading an entry, and `Compress::Zip::Error` will\nbe raised if the computed CRC32 checksum does not match.\n\n### Writer zip files\n\nUse `Compress::Zip::Writer`, which writes zip entries sequentially to\nany `IO`.\n\nNOTE: only compression methods 0 (STORED) and 8 (DEFLATED) are\nsupported. Additionally, ZIP64 is not yet supported.","summary":"<p>The Compress::Zip module contains readers and writers of the zip file format, described at <a href=\"https://pkware.cachefly.net/webdocs/APPNOTE/APPNOTE-6.3.3.TXT\">PKWARE's site</a>.</p>","types":[{"html_id":"Crystal/Compress/Zip/CompressionMethod","path":"Compress/Zip/CompressionMethod.html","kind":"enum","full_name":"Compress::Zip::CompressionMethod","name":"CompressionMethod","abstract":false,"ancestors":[{"html_id":"Crystal/Enum","kind":"struct","full_name":"Enum","name":"Enum"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/compress/zip/compression_method.cr","line_number":2,"url":null}],"repository_name":"Crystal","program":false,"enum":true,"alias":false,"const":false,"constants":[{"id":"STORED","name":"STORED","value":"0_u16"},{"id":"DEFLATED","name":"DEFLATED","value":"8_u16"}],"namespace":{"html_id":"Crystal/Compress/Zip","kind":"module","full_name":"Compress::Zip","name":"Zip"},"doc":"Supported compression methods in the current implementation.","summary":"<p>Supported compression methods in the current implementation.</p>","instance_methods":[{"html_id":"deflated?-instance-method","name":"deflated?","doc":"Returns `true` if this enum value equals `DEFLATED`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../../Compress/Zip/CompressionMethod.html#DEFLATED\">DEFLATED</a></code></p>","abstract":false,"location":{"filename":"src/compress/zip/compression_method.cr","line_number":4,"url":null},"def":{"name":"deflated?","visibility":"Public","body":"self == DEFLATED"},"external_var":false},{"html_id":"stored?-instance-method","name":"stored?","doc":"Returns `true` if this enum value equals `STORED`","summary":"<p>Returns <code>true</code> if this enum value equals <code><a href=\"../../Compress/Zip/CompressionMethod.html#STORED\">STORED</a></code></p>","abstract":false,"location":{"filename":"src/compress/zip/compression_method.cr","line_number":3,"url":null},"def":{"name":"stored?","visibility":"Public","body":"self == STORED"},"external_var":false}]},{"html_id":"Crystal/Compress/Zip/Error","path":"Compress/Zip/Error.html","kind":"class","full_name":"Compress::Zip::Error","name":"Error","abstract":false,"superclass":{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},"ancestors":[{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/compress/zip/zip.cr","line_number":36,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"namespace":{"html_id":"Crystal/Compress/Zip","kind":"module","full_name":"Compress::Zip","name":"Zip"}},{"html_id":"Crystal/Compress/Zip/File","path":"Compress/Zip/File.html","kind":"class","full_name":"Compress::Zip::File","name":"File","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/compress/zip/file.cr","line_number":27,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"namespace":{"html_id":"Crystal/Compress/Zip","kind":"module","full_name":"Compress::Zip","name":"Zip"},"doc":"Provides random read access to zip file entries stores inside\na `File` or an `IO::Memory`.\n\n### Example\n\n```\nrequire \"compress/zip\"\n\nCompress::Zip::File.open(\"./file.zip\") do |file|\n  # Iterate through all entries printing their filename and contents\n  file.entries.each do |entry|\n    p entry.filename\n    entry.open do |io|\n      p io.gets_to_end\n    end\n  end\n\n  # Random access to entries by filename is also provided\n  entry = file[\"some_file.txt\"]\n  entry.open do |io|\n    p io.gets_to_end\n  end\nend\n```","summary":"<p>Provides random read access to zip file entries stores inside a <code><a href=\"../../Compress/Zip/File.html\">File</a></code> or an <code><a href=\"../../IO/Memory.html\">IO::Memory</a></code>.</p>","class_methods":[{"html_id":"open(io:IO,sync_close=false,&)-class-method","name":"open","doc":"Opens a `Zip::File` for reading from the given *io*, yields\nit to the given block, and closes it at the end.","summary":"<p>Opens a <code><a href=\"../../Compress/Zip/File.html\">Zip::File</a></code> for reading from the given <em>io</em>, yields it to the given block, and closes it at the end.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":""}],"args_string":"(io : IO, sync_close = false, &)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, sync_close = <span class=\"n\">false</span>, &)","location":{"filename":"src/compress/zip/file.cr","line_number":53,"url":null},"def":{"name":"open","args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":""}],"yields":1,"block_arity":1,"visibility":"Public","body":"zip = new(io, sync_close)\nbegin\n  yield zip\nensure\n  zip.close\nend\n"},"external_var":false},{"html_id":"open(filename:Path|String,&)-class-method","name":"open","doc":"Opens a `Zip::File` for reading from the given *filename*, yields\nit to the given block, and closes it at the end.","summary":"<p>Opens a <code><a href=\"../../Compress/Zip/File.html\">Zip::File</a></code> for reading from the given <em>filename</em>, yields it to the given block, and closes it at the end.</p>","abstract":false,"args":[{"name":"filename","external_name":"filename","restriction":"Path | String"}],"args_string":"(filename : Path | String, &)","args_html":"(filename : <a href=\"../../Path.html\">Path</a> | <a href=\"../../String.html\">String</a>, &)","location":{"filename":"src/compress/zip/file.cr","line_number":60,"url":null},"def":{"name":"open","args":[{"name":"filename","external_name":"filename","restriction":"Path | String"}],"yields":1,"block_arity":1,"visibility":"Public","body":"zip = new(filename)\nbegin\n  yield zip\nensure\n  zip.close\nend\n"},"external_var":false}],"constructors":[{"html_id":"new(io:IO,sync_close:Bool=false)-class-method","name":"new","doc":"Opens a `Zip::File` for reading from the given *io*.","summary":"<p>Opens a <code><a href=\"../../Compress/Zip/File.html\">Zip::File</a></code> for reading from the given <em>io</em>.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":"::Bool"}],"args_string":"(io : IO, sync_close : Bool = false)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, sync_close : <a href=\"../../Bool.html\">Bool</a> = <span class=\"n\">false</span>)","location":{"filename":"src/compress/zip/file.cr","line_number":38,"url":null},"def":{"name":"new","args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":"::Bool"}],"visibility":"Public","body":"_ = allocate\n_.initialize(io, sync_close)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(filename:Path|String)-class-method","name":"new","doc":"Opens a `Zip::File` for reading from the given *filename*.","summary":"<p>Opens a <code><a href=\"../../Compress/Zip/File.html\">Zip::File</a></code> for reading from the given <em>filename</em>.</p>","abstract":false,"args":[{"name":"filename","external_name":"filename","restriction":"Path | String"}],"args_string":"(filename : Path | String)","args_html":"(filename : <a href=\"../../Path.html\">Path</a> | <a href=\"../../String.html\">String</a>)","location":{"filename":"src/compress/zip/file.cr","line_number":47,"url":null},"def":{"name":"new","args":[{"name":"filename","external_name":"filename","restriction":"Path | String"}],"visibility":"Public","body":"new(::File.new(filename), sync_close: true)"},"external_var":false}],"instance_methods":[{"html_id":"[](filename:Path|String):Entry-instance-method","name":"[]","doc":"Returns the entry that has the given filename, or\nraises `KeyError` if no such entry exists.","summary":"<p>Returns the entry that has the given filename, or raises <code><a href=\"../../KeyError.html\">KeyError</a></code> if no such entry exists.</p>","abstract":false,"args":[{"name":"filename","external_name":"filename","restriction":"Path | String"}],"args_string":"(filename : Path | String) : Entry","args_html":"(filename : <a href=\"../../Path.html\">Path</a> | <a href=\"../../String.html\">String</a>) : <a href=\"../../Compress/Zip/File/Entry.html\">Entry</a>","location":{"filename":"src/compress/zip/file.cr","line_number":67,"url":null},"def":{"name":"[]","args":[{"name":"filename","external_name":"filename","restriction":"Path | String"}],"return_type":"Entry","visibility":"Public","body":"self[filename]? || (raise(KeyError.new(\"Missing zip entry: #{filename}\")))"},"external_var":false},{"html_id":"[]?(filename:Path|String):Entry|Nil-instance-method","name":"[]?","doc":"Returns the entry that has the given filename, or\n`nil` if no such entry exists.","summary":"<p>Returns the entry that has the given filename, or <code>nil</code> if no such entry exists.</p>","abstract":false,"args":[{"name":"filename","external_name":"filename","restriction":"Path | String"}],"args_string":"(filename : Path | String) : Entry | Nil","args_html":"(filename : <a href=\"../../Path.html\">Path</a> | <a href=\"../../String.html\">String</a>) : <a href=\"../../Compress/Zip/File/Entry.html\">Entry</a> | <a href=\"../../Nil.html\">Nil</a>","location":{"filename":"src/compress/zip/file.cr","line_number":73,"url":null},"def":{"name":"[]?","args":[{"name":"filename","external_name":"filename","restriction":"Path | String"}],"return_type":"Entry | ::Nil","visibility":"Public","body":"@entries_by_filename[filename.to_s]?"},"external_var":false},{"html_id":"close:Nil-instance-method","name":"close","doc":"Closes this zip file.","summary":"<p>Closes this zip file.</p>","abstract":false,"location":{"filename":"src/compress/zip/file.cr","line_number":78,"url":null},"def":{"name":"close","return_type":"Nil","visibility":"Public","body":"if @closed\n  return\nend\n@closed = true\nif @sync_close\n  @io.close\nend\n"},"external_var":false},{"html_id":"closed?:Bool-instance-method","name":"closed?","doc":"Returns `true` if this zip file is closed.","summary":"<p>Returns <code>true</code> if this zip file is closed.</p>","abstract":false,"location":{"filename":"src/compress/zip/file.cr","line_number":32,"url":null},"def":{"name":"closed?","visibility":"Public","body":"@closed"},"external_var":false},{"html_id":"comment:String-instance-method","name":"comment","doc":"Returns the zip file comment.","summary":"<p>Returns the zip file comment.</p>","abstract":false,"location":{"filename":"src/compress/zip/file.cr","line_number":35,"url":null},"def":{"name":"comment","visibility":"Public","body":"@comment"},"external_var":false},{"html_id":"entries:Array(Entry)-instance-method","name":"entries","doc":"Returns all entries inside this zip file.","summary":"<p>Returns all entries inside this zip file.</p>","abstract":false,"location":{"filename":"src/compress/zip/file.cr","line_number":29,"url":null},"def":{"name":"entries","return_type":"Array(Entry)","visibility":"Public","body":"@entries"},"external_var":false}],"types":[{"html_id":"Crystal/Compress/Zip/File/Entry","path":"Compress/Zip/File/Entry.html","kind":"class","full_name":"Compress::Zip::File::Entry","name":"Entry","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Compress/Zip/FileInfo","kind":"module","full_name":"Compress::Zip::FileInfo","name":"FileInfo"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/compress/zip/file.cr","line_number":159,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"included_modules":[{"html_id":"Crystal/Compress/Zip/FileInfo","kind":"module","full_name":"Compress::Zip::FileInfo","name":"FileInfo"}],"namespace":{"html_id":"Crystal/Compress/Zip/File","kind":"class","full_name":"Compress::Zip::File","name":"File"},"doc":"An entry inside a `Zip::File`.\n\nUse the `open` method to read from it.","summary":"<p>An entry inside a <code><a href=\"../../../Compress/Zip/File.html\">Zip::File</a></code>.</p>","instance_methods":[{"html_id":"open(&)-instance-method","name":"open","doc":"Yields an `IO` to read this entry's contents.\nMultiple entries can be opened and read concurrently.","summary":"<p>Yields an <code><a href=\"../../../IO.html\">IO</a></code> to read this entry's contents.</p>","abstract":false,"location":{"filename":"src/compress/zip/file.cr","line_number":169,"url":null},"def":{"name":"open","yields":1,"block_arity":1,"visibility":"Public","body":"@io.read_at(data_offset.to_i32, compressed_size.to_i32) do |io|\n  io = decompressor_for(io, is_sized: true)\n  checksum_reader = ChecksumReader.new(io, filename, verify: crc32)\n  yield checksum_reader\nend"},"external_var":false}]}]},{"html_id":"Crystal/Compress/Zip/FileInfo","path":"Compress/Zip/FileInfo.html","kind":"module","full_name":"Compress::Zip::FileInfo","name":"FileInfo","abstract":false,"locations":[{"filename":"src/compress/zip/file_info.cr","line_number":2,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"constants":[{"id":"DATA_DESCRIPTOR_SIGNATURE","name":"DATA_DESCRIPTOR_SIGNATURE","value":"134695760"},{"id":"DEFLATE_END_SIGNATURE","name":"DEFLATE_END_SIGNATURE","value":"Bytes[80, 75, 7, 8, read_only: true]"},{"id":"SIGNATURE","name":"SIGNATURE","value":"67324752"}],"including_types":[{"html_id":"Crystal/Compress/Zip/File/Entry","kind":"class","full_name":"Compress::Zip::File::Entry","name":"Entry"},{"html_id":"Crystal/Compress/Zip/Reader/Entry","kind":"class","full_name":"Compress::Zip::Reader::Entry","name":"Entry"},{"html_id":"Crystal/Compress/Zip/Writer/Entry","kind":"class","full_name":"Compress::Zip::Writer::Entry","name":"Entry"}],"namespace":{"html_id":"Crystal/Compress/Zip","kind":"module","full_name":"Compress::Zip","name":"Zip"},"doc":"Base type for file information related to zip entries.","summary":"<p>Base type for file information related to zip entries.</p>","constructors":[{"html_id":"new(filename:String,time=Time.utc,comment=\"\",extra=Bytes.empty)-class-method","name":"new","abstract":false,"args":[{"name":"filename","external_name":"filename","restriction":"String"},{"name":"time","default_value":"Time.utc","external_name":"time","restriction":""},{"name":"comment","default_value":"\"\"","external_name":"comment","restriction":""},{"name":"extra","default_value":"Bytes.empty","external_name":"extra","restriction":""}],"args_string":"(filename : String, time = Time.utc, comment = \"\", extra = Bytes.empty)","args_html":"(filename : <a href=\"../../String.html\">String</a>, time = <span class=\"t\">Time</span>.utc, comment = <span class=\"s\">&quot;&quot;</span>, extra = <span class=\"t\">Bytes</span>.empty)","location":{"filename":"src/compress/zip/file_info.cr","line_number":68,"url":null},"def":{"name":"new","args":[{"name":"filename","external_name":"filename","restriction":"String"},{"name":"time","default_value":"Time.utc","external_name":"time","restriction":""},{"name":"comment","default_value":"\"\"","external_name":"comment","restriction":""},{"name":"extra","default_value":"Bytes.empty","external_name":"extra","restriction":""}],"visibility":"Public","body":"_ = allocate\n_.initialize(filename, time, comment, extra)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false}],"instance_methods":[{"html_id":"comment-instance-method","name":"comment","abstract":false,"location":{"filename":"src/compress/zip/file_info.cr","line_number":17,"url":null},"def":{"name":"comment","visibility":"Public","body":"@comment"},"external_var":false},{"html_id":"comment=(comment)-instance-method","name":"comment=","abstract":false,"args":[{"name":"comment","external_name":"comment","restriction":""}],"args_string":"(comment)","args_html":"(comment)","location":{"filename":"src/compress/zip/file_info.cr","line_number":17,"url":null},"def":{"name":"comment=","args":[{"name":"comment","external_name":"comment","restriction":""}],"visibility":"Public","body":"@comment = comment"},"external_var":false},{"html_id":"compressed_size-instance-method","name":"compressed_size","abstract":false,"location":{"filename":"src/compress/zip/file_info.cr","line_number":13,"url":null},"def":{"name":"compressed_size","visibility":"Public","body":"@compressed_size"},"external_var":false},{"html_id":"compressed_size=(compressed_size)-instance-method","name":"compressed_size=","abstract":false,"args":[{"name":"compressed_size","external_name":"compressed_size","restriction":""}],"args_string":"(compressed_size)","args_html":"(compressed_size)","location":{"filename":"src/compress/zip/file_info.cr","line_number":13,"url":null},"def":{"name":"compressed_size=","args":[{"name":"compressed_size","external_name":"compressed_size","restriction":""}],"visibility":"Public","body":"@compressed_size = compressed_size"},"external_var":false},{"html_id":"compression_method-instance-method","name":"compression_method","abstract":false,"location":{"filename":"src/compress/zip/file_info.cr","line_number":10,"url":null},"def":{"name":"compression_method","visibility":"Public","body":"@compression_method"},"external_var":false},{"html_id":"compression_method=(compression_method)-instance-method","name":"compression_method=","abstract":false,"args":[{"name":"compression_method","external_name":"compression_method","restriction":""}],"args_string":"(compression_method)","args_html":"(compression_method)","location":{"filename":"src/compress/zip/file_info.cr","line_number":10,"url":null},"def":{"name":"compression_method=","args":[{"name":"compression_method","external_name":"compression_method","restriction":""}],"visibility":"Public","body":"@compression_method = compression_method"},"external_var":false},{"html_id":"crc32-instance-method","name":"crc32","abstract":false,"location":{"filename":"src/compress/zip/file_info.cr","line_number":12,"url":null},"def":{"name":"crc32","visibility":"Public","body":"@crc32"},"external_var":false},{"html_id":"crc32=(crc32)-instance-method","name":"crc32=","abstract":false,"args":[{"name":"crc32","external_name":"crc32","restriction":""}],"args_string":"(crc32)","args_html":"(crc32)","location":{"filename":"src/compress/zip/file_info.cr","line_number":12,"url":null},"def":{"name":"crc32=","args":[{"name":"crc32","external_name":"crc32","restriction":""}],"visibility":"Public","body":"@crc32 = crc32"},"external_var":false},{"html_id":"dir?:Bool-instance-method","name":"dir?","doc":"Returns `true` if this entry is a directory.","summary":"<p>Returns <code>true</code> if this entry is a directory.</p>","abstract":false,"location":{"filename":"src/compress/zip/file_info.cr","line_number":72,"url":null},"def":{"name":"dir?","return_type":"Bool","visibility":"Public","body":"filename.ends_with?('/')"},"external_var":false},{"html_id":"extra-instance-method","name":"extra","abstract":false,"location":{"filename":"src/compress/zip/file_info.cr","line_number":16,"url":null},"def":{"name":"extra","visibility":"Public","body":"@extra"},"external_var":false},{"html_id":"extra=(extra)-instance-method","name":"extra=","abstract":false,"args":[{"name":"extra","external_name":"extra","restriction":""}],"args_string":"(extra)","args_html":"(extra)","location":{"filename":"src/compress/zip/file_info.cr","line_number":16,"url":null},"def":{"name":"extra=","args":[{"name":"extra","external_name":"extra","restriction":""}],"visibility":"Public","body":"@extra = extra"},"external_var":false},{"html_id":"file?:Bool-instance-method","name":"file?","doc":"Returns `true` if this entry is a file.","summary":"<p>Returns <code>true</code> if this entry is a file.</p>","abstract":false,"location":{"filename":"src/compress/zip/file_info.cr","line_number":77,"url":null},"def":{"name":"file?","return_type":"Bool","visibility":"Public","body":"!dir?"},"external_var":false},{"html_id":"filename-instance-method","name":"filename","abstract":false,"location":{"filename":"src/compress/zip/file_info.cr","line_number":15,"url":null},"def":{"name":"filename","visibility":"Public","body":"@filename"},"external_var":false},{"html_id":"filename=(filename)-instance-method","name":"filename=","abstract":false,"args":[{"name":"filename","external_name":"filename","restriction":""}],"args_string":"(filename)","args_html":"(filename)","location":{"filename":"src/compress/zip/file_info.cr","line_number":15,"url":null},"def":{"name":"filename=","args":[{"name":"filename","external_name":"filename","restriction":""}],"visibility":"Public","body":"@filename = filename"},"external_var":false},{"html_id":"general_purpose_bit_flag-instance-method","name":"general_purpose_bit_flag","abstract":false,"location":{"filename":"src/compress/zip/file_info.cr","line_number":9,"url":null},"def":{"name":"general_purpose_bit_flag","visibility":"Public","body":"@general_purpose_bit_flag"},"external_var":false},{"html_id":"general_purpose_bit_flag=(general_purpose_bit_flag)-instance-method","name":"general_purpose_bit_flag=","abstract":false,"args":[{"name":"general_purpose_bit_flag","external_name":"general_purpose_bit_flag","restriction":""}],"args_string":"(general_purpose_bit_flag)","args_html":"(general_purpose_bit_flag)","location":{"filename":"src/compress/zip/file_info.cr","line_number":9,"url":null},"def":{"name":"general_purpose_bit_flag=","args":[{"name":"general_purpose_bit_flag","external_name":"general_purpose_bit_flag","restriction":""}],"visibility":"Public","body":"@general_purpose_bit_flag = general_purpose_bit_flag"},"external_var":false},{"html_id":"offset-instance-method","name":"offset","abstract":false,"location":{"filename":"src/compress/zip/file_info.cr","line_number":18,"url":null},"def":{"name":"offset","visibility":"Public","body":"@offset"},"external_var":false},{"html_id":"offset=(offset)-instance-method","name":"offset=","abstract":false,"args":[{"name":"offset","external_name":"offset","restriction":""}],"args_string":"(offset)","args_html":"(offset)","location":{"filename":"src/compress/zip/file_info.cr","line_number":18,"url":null},"def":{"name":"offset=","args":[{"name":"offset","external_name":"offset","restriction":""}],"visibility":"Public","body":"@offset = offset"},"external_var":false},{"html_id":"time:Time-instance-method","name":"time","abstract":false,"location":{"filename":"src/compress/zip/file_info.cr","line_number":11,"url":null},"def":{"name":"time","return_type":"Time","visibility":"Public","body":"@time"},"external_var":false},{"html_id":"time=(time:Time)-instance-method","name":"time=","abstract":false,"args":[{"name":"time","external_name":"time","restriction":"Time"}],"args_string":"(time : Time)","args_html":"(time : <a href=\"../../Time.html\">Time</a>)","location":{"filename":"src/compress/zip/file_info.cr","line_number":11,"url":null},"def":{"name":"time=","args":[{"name":"time","external_name":"time","restriction":"Time"}],"visibility":"Public","body":"@time = time"},"external_var":false},{"html_id":"uncompressed_size-instance-method","name":"uncompressed_size","abstract":false,"location":{"filename":"src/compress/zip/file_info.cr","line_number":14,"url":null},"def":{"name":"uncompressed_size","visibility":"Public","body":"@uncompressed_size"},"external_var":false},{"html_id":"uncompressed_size=(uncompressed_size)-instance-method","name":"uncompressed_size=","abstract":false,"args":[{"name":"uncompressed_size","external_name":"uncompressed_size","restriction":""}],"args_string":"(uncompressed_size)","args_html":"(uncompressed_size)","location":{"filename":"src/compress/zip/file_info.cr","line_number":14,"url":null},"def":{"name":"uncompressed_size=","args":[{"name":"uncompressed_size","external_name":"uncompressed_size","restriction":""}],"visibility":"Public","body":"@uncompressed_size = uncompressed_size"},"external_var":false},{"html_id":"version:UInt16-instance-method","name":"version","abstract":false,"location":{"filename":"src/compress/zip/file_info.cr","line_number":8,"url":null},"def":{"name":"version","return_type":"UInt16","visibility":"Public","body":"@version"},"external_var":false},{"html_id":"version=(version:UInt16)-instance-method","name":"version=","abstract":false,"args":[{"name":"version","external_name":"version","restriction":"UInt16"}],"args_string":"(version : UInt16)","args_html":"(version : <a href=\"../../UInt16.html\">UInt16</a>)","location":{"filename":"src/compress/zip/file_info.cr","line_number":8,"url":null},"def":{"name":"version=","args":[{"name":"version","external_name":"version","restriction":"UInt16"}],"visibility":"Public","body":"@version = version"},"external_var":false}]},{"html_id":"Crystal/Compress/Zip/Reader","path":"Compress/Zip/Reader.html","kind":"class","full_name":"Compress::Zip::Reader","name":"Reader","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/compress/zip/reader.cr","line_number":25,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"namespace":{"html_id":"Crystal/Compress/Zip","kind":"module","full_name":"Compress::Zip","name":"Zip"},"doc":"Reads zip file entries sequentially from an `IO`.\n\nNOTE: Entries might not have correct values\nfor crc32, compressed_size, uncompressed_size and comment,\nbecause when reading a zip file directly from a stream this\ninformation might be stored later in the zip stream.\nIf you need this information, consider using `Zip::File`.\n\n### Example\n\n```\nrequire \"compress/zip\"\n\nCompress::Zip::Reader.open(\"./file.zip\") do |zip|\n  zip.each_entry do |entry|\n    p entry.filename\n    p entry.file?\n    p entry.dir?\n    p entry.io.gets_to_end\n  end\nend\n```","summary":"<p>Reads zip file entries sequentially from an <code><a href=\"../../IO.html\">IO</a></code>.</p>","class_methods":[{"html_id":"open(io:IO,sync_close=false,&)-class-method","name":"open","doc":"Creates a new reader from the given *io*, yields it to the given block,\nand closes it at the end.","summary":"<p>Creates a new reader from the given <em>io</em>, yields it to the given block, and closes it at the end.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":""}],"args_string":"(io : IO, sync_close = false, &)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, sync_close = <span class=\"n\">false</span>, &)","location":{"filename":"src/compress/zip/reader.cr","line_number":45,"url":null},"def":{"name":"open","args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":""}],"yields":1,"block_arity":1,"visibility":"Public","body":"reader = new(io, sync_close: sync_close)\nbegin\n  yield reader\nensure\n  reader.close\nend\n"},"external_var":false},{"html_id":"open(filename:Path|String,&)-class-method","name":"open","doc":"Creates a new reader from the given *filename*, yields it to the given block,\nand closes it at the end.","summary":"<p>Creates a new reader from the given <em>filename</em>, yields it to the given block, and closes it at the end.</p>","abstract":false,"args":[{"name":"filename","external_name":"filename","restriction":"Path | String"}],"args_string":"(filename : Path | String, &)","args_html":"(filename : <a href=\"../../Path.html\">Path</a> | <a href=\"../../String.html\">String</a>, &)","location":{"filename":"src/compress/zip/reader.cr","line_number":52,"url":null},"def":{"name":"open","args":[{"name":"filename","external_name":"filename","restriction":"Path | String"}],"yields":1,"block_arity":1,"visibility":"Public","body":"reader = new(filename)\nbegin\n  yield reader\nensure\n  reader.close\nend\n"},"external_var":false}],"constructors":[{"html_id":"new(io:IO,sync_close:Bool=false)-class-method","name":"new","doc":"Creates a new reader from the given *io*.","summary":"<p>Creates a new reader from the given <em>io</em>.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":"::Bool"}],"args_string":"(io : IO, sync_close : Bool = false)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, sync_close : <a href=\"../../Bool.html\">Bool</a> = <span class=\"n\">false</span>)","location":{"filename":"src/compress/zip/reader.cr","line_number":33,"url":null},"def":{"name":"new","args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":"::Bool"}],"visibility":"Public","body":"_ = allocate\n_.initialize(io, sync_close)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(filename:Path|String)-class-method","name":"new","doc":"Creates a new reader from the given *filename*.","summary":"<p>Creates a new reader from the given <em>filename</em>.</p>","abstract":false,"args":[{"name":"filename","external_name":"filename","restriction":"Path | String"}],"args_string":"(filename : Path | String)","args_html":"(filename : <a href=\"../../Path.html\">Path</a> | <a href=\"../../String.html\">String</a>)","location":{"filename":"src/compress/zip/reader.cr","line_number":39,"url":null},"def":{"name":"new","args":[{"name":"filename","external_name":"filename","restriction":"Path | String"}],"visibility":"Public","body":"new(::File.new(filename), sync_close: true)"},"external_var":false}],"instance_methods":[{"html_id":"close:Nil-instance-method","name":"close","doc":"Closes this zip reader.","summary":"<p>Closes this zip reader.</p>","abstract":false,"location":{"filename":"src/compress/zip/reader.cr","line_number":104,"url":null},"def":{"name":"close","return_type":"Nil","visibility":"Public","body":"if @closed\n  return\nend\n@closed = true\nif @sync_close\n  @io.close\nend\n"},"external_var":false},{"html_id":"closed?:Bool-instance-method","name":"closed?","doc":"Returns `true` if this reader is closed.","summary":"<p>Returns <code>true</code> if this reader is closed.</p>","abstract":false,"location":{"filename":"src/compress/zip/reader.cr","line_number":30,"url":null},"def":{"name":"closed?","visibility":"Public","body":"@closed"},"external_var":false},{"html_id":"each_entry(&)-instance-method","name":"each_entry","doc":"Yields each entry in the zip to the given block.","summary":"<p>Yields each entry in the zip to the given block.</p>","abstract":false,"location":{"filename":"src/compress/zip/reader.cr","line_number":97,"url":null},"def":{"name":"each_entry","yields":1,"block_arity":1,"visibility":"Public","body":"while entry = next_entry\n  yield entry\nend"},"external_var":false},{"html_id":"next_entry:Entry|Nil-instance-method","name":"next_entry","doc":"Reads the next entry in the zip, or `nil` if there\nare no more entries.\n\nAfter reading a next entry, previous entries can no\nlonger be read (their `IO` will be closed.)","summary":"<p>Reads the next entry in the zip, or <code>nil</code> if there are no more entries.</p>","abstract":false,"location":{"filename":"src/compress/zip/reader.cr","line_number":62,"url":null},"def":{"name":"next_entry","return_type":"Entry | ::Nil","visibility":"Public","body":"if @reached_end\n  return nil\nend\n\nif last_entry = @last_entry\n  last_entry.close\n  skip_data_descriptor(last_entry)\nend\n\nwhile true\n  signature = read(UInt32)\n\n  case signature\n  when FileInfo::SIGNATURE\n    break\n  when FileInfo::DATA_DESCRIPTOR_SIGNATURE\n    if last_entry && (!@read_data_descriptor)\n      read_data_descriptor(last_entry)\n      next\n    else\n      raise(Error.new(\"Unexpected data descriptor when reading zip\"))\n    end\n  else\n    @reached_end = true\n    return nil\n  end\nend\n\n@last_entry = Entry.new(@io)\n"},"external_var":false},{"html_id":"sync_close=(sync_close:Bool)-instance-method","name":"sync_close=","doc":"Whether to close the enclosed `IO` when closing this reader.","summary":"<p>Whether to close the enclosed <code><a href=\"../../IO.html\">IO</a></code> when closing this reader.</p>","abstract":false,"args":[{"name":"sync_close","external_name":"sync_close","restriction":"::Bool"}],"args_string":"(sync_close : Bool)","args_html":"(sync_close : <a href=\"../../Bool.html\">Bool</a>)","location":{"filename":"src/compress/zip/reader.cr","line_number":27,"url":null},"def":{"name":"sync_close=","args":[{"name":"sync_close","external_name":"sync_close","restriction":"::Bool"}],"visibility":"Public","body":"@sync_close = sync_close"},"external_var":false},{"html_id":"sync_close?:Bool-instance-method","name":"sync_close?","doc":"Whether to close the enclosed `IO` when closing this reader.","summary":"<p>Whether to close the enclosed <code><a href=\"../../IO.html\">IO</a></code> when closing this reader.</p>","abstract":false,"location":{"filename":"src/compress/zip/reader.cr","line_number":27,"url":null},"def":{"name":"sync_close?","visibility":"Public","body":"@sync_close"},"external_var":false}],"types":[{"html_id":"Crystal/Compress/Zip/Reader/Entry","path":"Compress/Zip/Reader/Entry.html","kind":"class","full_name":"Compress::Zip::Reader::Entry","name":"Entry","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Compress/Zip/FileInfo","kind":"module","full_name":"Compress::Zip::FileInfo","name":"FileInfo"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/compress/zip/reader.cr","line_number":148,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"included_modules":[{"html_id":"Crystal/Compress/Zip/FileInfo","kind":"module","full_name":"Compress::Zip::FileInfo","name":"FileInfo"}],"namespace":{"html_id":"Crystal/Compress/Zip/Reader","kind":"class","full_name":"Compress::Zip::Reader","name":"Reader"},"doc":"A entry inside a `Zip::Reader`.\n\nUse the `io` method to read from it.","summary":"<p>A entry inside a <code><a href=\"../../../Compress/Zip/Reader.html\">Zip::Reader</a></code>.</p>","instance_methods":[{"html_id":"io:IO-instance-method","name":"io","doc":"Returns an `IO` to the entry's data.","summary":"<p>Returns an <code><a href=\"../../../IO.html\">IO</a></code> to the entry's data.</p>","abstract":false,"location":{"filename":"src/compress/zip/reader.cr","line_number":159,"url":null},"def":{"name":"io","return_type":"IO","visibility":"Public","body":"@io"},"external_var":false}]}]},{"html_id":"Crystal/Compress/Zip/Writer","path":"Compress/Zip/Writer.html","kind":"class","full_name":"Compress::Zip::Writer","name":"Writer","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/compress/zip/writer.cr","line_number":26,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"namespace":{"html_id":"Crystal/Compress/Zip","kind":"module","full_name":"Compress::Zip","name":"Zip"},"doc":"Writes (streams) zip entries to an `IO`.\n\n### Example\n\n```\nrequire \"compress/zip\"\n\nFile.open(\"./file.zip\", \"w\") do |file|\n  Compress::Zip::Writer.open(file) do |zip|\n    # Add a file with a String content\n    zip.add \"foo.txt\", \"contents of foo\"\n\n    # Add a file and write data to it through an IO\n    zip.add(\"bar.txt\") do |io|\n      io << \"contents of bar\"\n    end\n\n    # Add a file by referencing a file in the filesystem\n    # (the file is automatically closed after this call)\n    zip.add(\"baz.txt\", File.open(\"./some_file.txt\"))\n  end\nend\n```","summary":"<p>Writes (streams) zip entries to an <code><a href=\"../../IO.html\">IO</a></code>.</p>","class_methods":[{"html_id":"open(io:IO,sync_close=false,&)-class-method","name":"open","doc":"Creates a new writer to the given *io*, yields it to the given block,\nand closes it at the end.","summary":"<p>Creates a new writer to the given <em>io</em>, yields it to the given block, and closes it at the end.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":""}],"args_string":"(io : IO, sync_close = false, &)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, sync_close = <span class=\"n\">false</span>, &)","location":{"filename":"src/compress/zip/writer.cr","line_number":54,"url":null},"def":{"name":"open","args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":""}],"yields":1,"block_arity":1,"visibility":"Public","body":"writer = new(io, sync_close: sync_close)\nbegin\n  yield writer\nensure\n  writer.close\nend\n"},"external_var":false},{"html_id":"open(filename:Path|String,&)-class-method","name":"open","doc":"Creates a new writer to the given *filename*, yields it to the given block,\nand closes it at the end.","summary":"<p>Creates a new writer to the given <em>filename</em>, yields it to the given block, and closes it at the end.</p>","abstract":false,"args":[{"name":"filename","external_name":"filename","restriction":"Path | String"}],"args_string":"(filename : Path | String, &)","args_html":"(filename : <a href=\"../../Path.html\">Path</a> | <a href=\"../../String.html\">String</a>, &)","location":{"filename":"src/compress/zip/writer.cr","line_number":61,"url":null},"def":{"name":"open","args":[{"name":"filename","external_name":"filename","restriction":"Path | String"}],"yields":1,"block_arity":1,"visibility":"Public","body":"writer = new(filename)\nbegin\n  yield writer\nensure\n  writer.close\nend\n"},"external_var":false}],"constructors":[{"html_id":"new(io:IO,sync_close:Bool=false)-class-method","name":"new","doc":"Creates a new writer to the given *io*.","summary":"<p>Creates a new writer to the given <em>io</em>.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":"::Bool"}],"args_string":"(io : IO, sync_close : Bool = false)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, sync_close : <a href=\"../../Bool.html\">Bool</a> = <span class=\"n\">false</span>)","location":{"filename":"src/compress/zip/writer.cr","line_number":37,"url":null},"def":{"name":"new","args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":"::Bool"}],"visibility":"Public","body":"_ = allocate\n_.initialize(io, sync_close)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(filename:Path|String)-class-method","name":"new","doc":"Creates a new writer to the given *filename*.","summary":"<p>Creates a new writer to the given <em>filename</em>.</p>","abstract":false,"args":[{"name":"filename","external_name":"filename","restriction":"Path | String"}],"args_string":"(filename : Path | String)","args_html":"(filename : <a href=\"../../Path.html\">Path</a> | <a href=\"../../String.html\">String</a>)","location":{"filename":"src/compress/zip/writer.cr","line_number":48,"url":null},"def":{"name":"new","args":[{"name":"filename","external_name":"filename","restriction":"Path | String"}],"visibility":"Public","body":"new(::File.new(filename, \"w\"), sync_close: true)"},"external_var":false}],"instance_methods":[{"html_id":"add(filename:Path|String,&)-instance-method","name":"add","doc":"Adds an entry that will have the given *filename* and current\ntime (`Time.utc`) and yields an `IO` to write that entry's\ncontents.","summary":"<p>Adds an entry that will have the given <em>filename</em> and current time (<code><a href=\"../../Time.html#utc%3ATime-class-method\">Time.utc</a></code>) and yields an <code><a href=\"../../IO.html\">IO</a></code> to write that entry's contents.</p>","abstract":false,"args":[{"name":"filename","external_name":"filename","restriction":"Path | String"}],"args_string":"(filename : Path | String, &)","args_html":"(filename : <a href=\"../../Path.html\">Path</a> | <a href=\"../../String.html\">String</a>, &)","location":{"filename":"src/compress/zip/writer.cr","line_number":69,"url":null},"def":{"name":"add","args":[{"name":"filename","external_name":"filename","restriction":"Path | String"}],"yields":1,"block_arity":1,"visibility":"Public","body":"add(Entry.new(filename.to_s)) do |io|\n  yield io\nend"},"external_var":false},{"html_id":"add(entry:Entry,&)-instance-method","name":"add","doc":"Adds an entry and yields `IO` to write that entry's contents.\n\nYou can choose the Entry's compression method before adding it.\n\n* If the STORED compression method is used, its crc32, compressed\nsize and uncompressed size **must** be set and be correct with\nrespect to the data that will be written to the yielded `IO`.\n* If the DEFLATED compression method is used, crc32, compressed\nsize and uncompressed size will be computed from the data\nwritten to the yielded IO.\n\nYou can also set the Entry's time (which is `Time.utc` by default)\n and extra data before adding it to the zip stream.","summary":"<p>Adds an entry and yields <code><a href=\"../../IO.html\">IO</a></code> to write that entry's contents.</p>","abstract":false,"args":[{"name":"entry","external_name":"entry","restriction":"Entry"}],"args_string":"(entry : Entry, &)","args_html":"(entry : <a href=\"../../Compress/Zip/Writer/Entry.html\">Entry</a>, &)","location":{"filename":"src/compress/zip/writer.cr","line_number":88,"url":null},"def":{"name":"add","args":[{"name":"entry","external_name":"entry","restriction":"Entry"}],"yields":1,"block_arity":1,"visibility":"Public","body":"entry.general_purpose_bit_flag = entry.general_purpose_bit_flag | (1 << 3)\n\nentry.general_purpose_bit_flag = entry.general_purpose_bit_flag | (1 << 11)\nentry.offset = @written\n\n@written = @written + (entry.to_io(@io))\n\ncase entry.compression_method\nwhen .stored?\n  if entry.compressed_size != entry.uncompressed_size\n    raise(Error.new(\"Entry compressed size (#{entry.compressed_size}) is not equal to its uncompressed size (#{entry.uncompressed_size})\"))\n  end\n\n  @uncompressed_size_counter.io = @io\n  yield @uncompressed_size_counter\nwhen .deflated?\n  @compressed_size_counter.io = @io\n  io = Compress::Deflate::Writer.new(@compressed_size_counter)\n  @uncompressed_size_counter.io = io\n  yield @uncompressed_size_counter\n  io.close\nelse\n  raise(\"Unsupported compression method: #{entry.compression_method}\")\nend\n\nif entry.compression_method.stored?\n  @written = @written + @uncompressed_size_counter.count\nelse\n  @written = @written + @compressed_size_counter.count\nend\n\ncrc32 = @uncompressed_size_counter.crc32.to_u32\nuncompressed_size = @uncompressed_size_counter.count\n\nif entry.compression_method.stored?\n  compressed_size = uncompressed_size\nelse\n  compressed_size = @compressed_size_counter.count\nend\n\nif entry.compression_method.stored?\n  if entry.crc32 != crc32\n    raise(Error.new(\"Entry CRC32 mismatch (#{entry.crc32} given but was #{crc32})\"))\n  end\n\n  if entry.uncompressed_size != uncompressed_size\n    raise(Error.new(\"Entry uncompressed size mismatch (#{entry.uncompressed_size} given but was #{uncompressed_size})\"))\n  end\nelse\n  entry.crc32 = crc32\n  entry.compressed_size = compressed_size\n  entry.uncompressed_size = uncompressed_size\nend\n\n\n\nif entry.compression_method.stored?\nelse\n  @written = @written + (entry.write_data_descriptor(@io))\nend\n\n@entries << entry\n"},"external_var":false},{"html_id":"add(filename_or_entry:Path|String|Entry,string:String):Nil-instance-method","name":"add","doc":"Adds an entry that will have *string* as its contents.","summary":"<p>Adds an entry that will have <em>string</em> as its contents.</p>","abstract":false,"args":[{"name":"filename_or_entry","external_name":"filename_or_entry","restriction":"Path | String | Entry"},{"name":"string","external_name":"string","restriction":"String"}],"args_string":"(filename_or_entry : Path | String | Entry, string : String) : Nil","args_html":"(filename_or_entry : <a href=\"../../Path.html\">Path</a> | <a href=\"../../String.html\">String</a> | <a href=\"../../Compress/Zip/Writer/Entry.html\">Entry</a>, string : <a href=\"../../String.html\">String</a>) : <a href=\"../../Nil.html\">Nil</a>","location":{"filename":"src/compress/zip/writer.cr","line_number":154,"url":null},"def":{"name":"add","args":[{"name":"filename_or_entry","external_name":"filename_or_entry","restriction":"Path | String | Entry"},{"name":"string","external_name":"string","restriction":"String"}],"return_type":"Nil","visibility":"Public","body":"add(filename_or_entry) do |io|\n  io << string\nend"},"external_var":false},{"html_id":"add(filename_or_entry:Path|String|Entry,bytes:Bytes):Nil-instance-method","name":"add","doc":"Adds an entry that will have *bytes* as its contents.","summary":"<p>Adds an entry that will have <em>bytes</em> as its contents.</p>","abstract":false,"args":[{"name":"filename_or_entry","external_name":"filename_or_entry","restriction":"Path | String | Entry"},{"name":"bytes","external_name":"bytes","restriction":"Bytes"}],"args_string":"(filename_or_entry : Path | String | Entry, bytes : Bytes) : Nil","args_html":"(filename_or_entry : <a href=\"../../Path.html\">Path</a> | <a href=\"../../String.html\">String</a> | <a href=\"../../Compress/Zip/Writer/Entry.html\">Entry</a>, bytes : <a href=\"../../Bytes.html\">Bytes</a>) : <a href=\"../../Nil.html\">Nil</a>","location":{"filename":"src/compress/zip/writer.cr","line_number":161,"url":null},"def":{"name":"add","args":[{"name":"filename_or_entry","external_name":"filename_or_entry","restriction":"Path | String | Entry"},{"name":"bytes","external_name":"bytes","restriction":"Bytes"}],"return_type":"Nil","visibility":"Public","body":"add(filename_or_entry) do |io|\n  io.write(bytes)\nend"},"external_var":false},{"html_id":"add(filename_or_entry:Path|String|Entry,data:IO):Nil-instance-method","name":"add","doc":"Adds an entry that will have its data copied from the given *data*.\nIf the given *data* is a `::File`, it is automatically closed\nafter data is copied from it.","summary":"<p>Adds an entry that will have its data copied from the given <em>data</em>.</p>","abstract":false,"args":[{"name":"filename_or_entry","external_name":"filename_or_entry","restriction":"Path | String | Entry"},{"name":"data","external_name":"data","restriction":"IO"}],"args_string":"(filename_or_entry : Path | String | Entry, data : IO) : Nil","args_html":"(filename_or_entry : <a href=\"../../Path.html\">Path</a> | <a href=\"../../String.html\">String</a> | <a href=\"../../Compress/Zip/Writer/Entry.html\">Entry</a>, data : <a href=\"../../IO.html\">IO</a>) : <a href=\"../../Nil.html\">Nil</a>","location":{"filename":"src/compress/zip/writer.cr","line_number":170,"url":null},"def":{"name":"add","args":[{"name":"filename_or_entry","external_name":"filename_or_entry","restriction":"Path | String | Entry"},{"name":"data","external_name":"data","restriction":"IO"}],"return_type":"Nil","visibility":"Public","body":"add(filename_or_entry) do |io|\n  IO.copy(data, io)\n  if data.is_a?(::File)\n    data.close\n  end\nend"},"external_var":false},{"html_id":"add_dir(name):Nil-instance-method","name":"add_dir","doc":"Adds a directory entry that will have the given *name*.","summary":"<p>Adds a directory entry that will have the given <em>name</em>.</p>","abstract":false,"args":[{"name":"name","external_name":"name","restriction":""}],"args_string":"(name) : Nil","args_html":"(name) : <a href=\"../../Nil.html\">Nil</a>","location":{"filename":"src/compress/zip/writer.cr","line_number":178,"url":null},"def":{"name":"add_dir","args":[{"name":"name","external_name":"name","restriction":""}],"return_type":"Nil","visibility":"Public","body":"if name.ends_with?('/')\nelse\n  name = name + '/'\nend\nadd(Entry.new(name)) do\nend\n"},"external_var":false},{"html_id":"close:Nil-instance-method","name":"close","doc":"Closes this zip writer.","summary":"<p>Closes this zip writer.</p>","abstract":false,"location":{"filename":"src/compress/zip/writer.cr","line_number":184,"url":null},"def":{"name":"close","return_type":"Nil","visibility":"Public","body":"if @closed\n  return\nend\n@closed = true\n\nstart_offset = @written\nwrite_central_directory\n\nwrite_end_of_central_directory(start_offset, @written - start_offset)\nif @sync_close\n  @io.close\nend\n"},"external_var":false},{"html_id":"closed?:Bool-instance-method","name":"closed?","doc":"Returns `true` if this writer is closed.","summary":"<p>Returns <code>true</code> if this writer is closed.</p>","abstract":false,"location":{"filename":"src/compress/zip/writer.cr","line_number":31,"url":null},"def":{"name":"closed?","visibility":"Public","body":"@closed"},"external_var":false},{"html_id":"comment=(comment:String)-instance-method","name":"comment=","doc":"Sets the zip file comment","summary":"<p>Sets the zip file comment</p>","abstract":false,"args":[{"name":"comment","external_name":"comment","restriction":"::String"}],"args_string":"(comment : String)","args_html":"(comment : <a href=\"../../String.html\">String</a>)","location":{"filename":"src/compress/zip/writer.cr","line_number":34,"url":null},"def":{"name":"comment=","args":[{"name":"comment","external_name":"comment","restriction":"::String"}],"visibility":"Public","body":"@comment = comment"},"external_var":false},{"html_id":"sync_close=(sync_close:Bool)-instance-method","name":"sync_close=","doc":"Whether to close the enclosed `IO` when closing this writer.","summary":"<p>Whether to close the enclosed <code><a href=\"../../IO.html\">IO</a></code> when closing this writer.</p>","abstract":false,"args":[{"name":"sync_close","external_name":"sync_close","restriction":"::Bool"}],"args_string":"(sync_close : Bool)","args_html":"(sync_close : <a href=\"../../Bool.html\">Bool</a>)","location":{"filename":"src/compress/zip/writer.cr","line_number":28,"url":null},"def":{"name":"sync_close=","args":[{"name":"sync_close","external_name":"sync_close","restriction":"::Bool"}],"visibility":"Public","body":"@sync_close = sync_close"},"external_var":false},{"html_id":"sync_close?:Bool-instance-method","name":"sync_close?","doc":"Whether to close the enclosed `IO` when closing this writer.","summary":"<p>Whether to close the enclosed <code><a href=\"../../IO.html\">IO</a></code> when closing this writer.</p>","abstract":false,"location":{"filename":"src/compress/zip/writer.cr","line_number":28,"url":null},"def":{"name":"sync_close?","visibility":"Public","body":"@sync_close"},"external_var":false}],"types":[{"html_id":"Crystal/Compress/Zip/Writer/Entry","path":"Compress/Zip/Writer/Entry.html","kind":"class","full_name":"Compress::Zip::Writer::Entry","name":"Entry","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Compress/Zip/FileInfo","kind":"module","full_name":"Compress::Zip::FileInfo","name":"FileInfo"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/compress/zip/writer.cr","line_number":239,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"included_modules":[{"html_id":"Crystal/Compress/Zip/FileInfo","kind":"module","full_name":"Compress::Zip::FileInfo","name":"FileInfo"}],"namespace":{"html_id":"Crystal/Compress/Zip/Writer","kind":"class","full_name":"Compress::Zip::Writer","name":"Writer"},"doc":"An entry to write into a `Zip::Writer`.","summary":"<p>An entry to write into a <code><a href=\"../../../Compress/Zip/Writer.html\">Zip::Writer</a></code>.</p>"}]}]},{"html_id":"Crystal/Compress/Zlib","path":"Compress/Zlib.html","kind":"module","full_name":"Compress::Zlib","name":"Zlib","abstract":false,"locations":[{"filename":"src/compress/zlib/reader.cr","line_number":6,"url":null},{"filename":"src/compress/zlib/zlib.cr","line_number":8,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"constants":[{"id":"BEST_COMPRESSION","name":"BEST_COMPRESSION","value":"Compress::Deflate::BEST_COMPRESSION"},{"id":"BEST_SPEED","name":"BEST_SPEED","value":"Compress::Deflate::BEST_SPEED"},{"id":"DEFAULT_COMPRESSION","name":"DEFAULT_COMPRESSION","value":"Compress::Deflate::DEFAULT_COMPRESSION"},{"id":"NO_COMPRESSION","name":"NO_COMPRESSION","value":"Compress::Deflate::NO_COMPRESSION"}],"namespace":{"html_id":"Crystal/Compress","kind":"module","full_name":"Compress","name":"Compress"},"doc":"The Compress::Zlib module contains readers and writers of zlib format compressed\ndata, as specified in [RFC 1950](https://www.ietf.org/rfc/rfc1950.txt).\n\nNOTE: To use `Zlib` or its children, you must explicitly import it with `require \"compress/zlib\"`","summary":"<p>The Compress::Zlib module contains readers and writers of zlib format compressed data, as specified in <a href=\"https://www.ietf.org/rfc/rfc1950.txt\">RFC 1950</a>.</p>","types":[{"html_id":"Crystal/Compress/Zlib/Error","path":"Compress/Zlib/Error.html","kind":"class","full_name":"Compress::Zlib::Error","name":"Error","abstract":false,"superclass":{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},"ancestors":[{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/compress/zlib/zlib.cr","line_number":14,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"namespace":{"html_id":"Crystal/Compress/Zlib","kind":"module","full_name":"Compress::Zlib","name":"Zlib"}},{"html_id":"Crystal/Compress/Zlib/Reader","path":"Compress/Zlib/Reader.html","kind":"class","full_name":"Compress::Zlib::Reader","name":"Reader","abstract":false,"superclass":{"html_id":"Crystal/IO","kind":"class","full_name":"IO","name":"IO"},"ancestors":[{"html_id":"Crystal/IO/Buffered","kind":"module","full_name":"IO::Buffered","name":"Buffered"},{"html_id":"Crystal/IO","kind":"class","full_name":"IO","name":"IO"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/compress/zlib/reader.cr","line_number":6,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"included_modules":[{"html_id":"Crystal/IO/Buffered","kind":"module","full_name":"IO::Buffered","name":"Buffered"}],"namespace":{"html_id":"Crystal/Compress/Zlib","kind":"module","full_name":"Compress::Zlib","name":"Zlib"},"doc":"A read-only `IO` object to decompress data in the zlib format.\n\nInstances of this class wrap another IO object. When you read from this instance\ninstance, it reads data from the underlying IO, decompresses it, and returns\nit to the caller.","summary":"<p>A read-only <code><a href=\"../../IO.html\">IO</a></code> object to decompress data in the zlib format.</p>","class_methods":[{"html_id":"open(io:IO,sync_close=false,dict:Bytes|Nil=nil,&)-class-method","name":"open","doc":"Creates a new reader from the given *io*, yields it to the given block,\nand closes it at the end.","summary":"<p>Creates a new reader from the given <em>io</em>, yields it to the given block, and closes it at the end.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":""},{"name":"dict","default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"args_string":"(io : IO, sync_close = false, dict : Bytes | Nil = nil, &)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, sync_close = <span class=\"n\">false</span>, dict : <a href=\"../../Bytes.html\">Bytes</a> | <a href=\"../../Nil.html\">Nil</a> = <span class=\"n\">nil</span>, &)","location":{"filename":"src/compress/zlib/reader.cr","line_number":25,"url":null},"def":{"name":"open","args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":""},{"name":"dict","default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"yields":1,"block_arity":1,"visibility":"Public","body":"reader = new(io, sync_close: sync_close, dict: dict)\nbegin\n  yield reader\nensure\n  reader.close\nend\n"},"external_var":false}],"constructors":[{"html_id":"new(io:IO,sync_close:Bool=false,dict:Bytes|Nil=nil)-class-method","name":"new","doc":"Creates a new reader from the given *io*.","summary":"<p>Creates a new reader from the given <em>io</em>.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":"::Bool"},{"name":"dict","default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"args_string":"(io : IO, sync_close : Bool = false, dict : Bytes | Nil = nil)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, sync_close : <a href=\"../../Bool.html\">Bool</a> = <span class=\"n\">false</span>, dict : <a href=\"../../Bytes.html\">Bytes</a> | <a href=\"../../Nil.html\">Nil</a> = <span class=\"n\">nil</span>)","location":{"filename":"src/compress/zlib/reader.cr","line_number":16,"url":null},"def":{"name":"new","args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":"::Bool"},{"name":"dict","default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"visibility":"Public","body":"_ = allocate\n_.initialize(io, sync_close, dict)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false}],"instance_methods":[{"html_id":"closed?:Bool-instance-method","name":"closed?","doc":"Returns `true` if this reader is closed.","summary":"<p>Returns <code>true</code> if this reader is closed.</p>","abstract":false,"location":{"filename":"src/compress/zlib/reader.cr","line_number":13,"url":null},"def":{"name":"closed?","visibility":"Public","body":"@closed"},"external_var":false},{"html_id":"sync_close=(sync_close:Bool)-instance-method","name":"sync_close=","doc":"Whether to close the enclosed `IO` when closing this reader.","summary":"<p>Whether to close the enclosed <code><a href=\"../../IO.html\">IO</a></code> when closing this reader.</p>","abstract":false,"args":[{"name":"sync_close","external_name":"sync_close","restriction":"::Bool"}],"args_string":"(sync_close : Bool)","args_html":"(sync_close : <a href=\"../../Bool.html\">Bool</a>)","location":{"filename":"src/compress/zlib/reader.cr","line_number":10,"url":null},"def":{"name":"sync_close=","args":[{"name":"sync_close","external_name":"sync_close","restriction":"::Bool"}],"visibility":"Public","body":"@sync_close = sync_close"},"external_var":false},{"html_id":"sync_close?:Bool-instance-method","name":"sync_close?","doc":"Whether to close the enclosed `IO` when closing this reader.","summary":"<p>Whether to close the enclosed <code><a href=\"../../IO.html\">IO</a></code> when closing this reader.</p>","abstract":false,"location":{"filename":"src/compress/zlib/reader.cr","line_number":10,"url":null},"def":{"name":"sync_close?","visibility":"Public","body":"@sync_close"},"external_var":false},{"html_id":"unbuffered_close:Nil-instance-method","name":"unbuffered_close","doc":"Closes the wrapped `IO`.\n\nTODO: Add return type restriction `Nil`","summary":"<p>Closes the wrapped <code><a href=\"../../IO.html\">IO</a></code>.</p>","abstract":false,"location":{"filename":"src/compress/zlib/reader.cr","line_number":92,"url":null},"def":{"name":"unbuffered_close","return_type":"Nil","visibility":"Public","body":"if @closed\n  return\nend\n@closed = true\n\n@flate_io.close\nif @sync_close\n  @io.close\nend\n"},"external_var":false},{"html_id":"unbuffered_flush:NoReturn-instance-method","name":"unbuffered_flush","doc":"Flushes the wrapped `IO`.\n\nTODO: Add return type restriction `Nil`","summary":"<p>Flushes the wrapped <code><a href=\"../../IO.html\">IO</a></code>.</p>","abstract":false,"location":{"filename":"src/compress/zlib/reader.cr","line_number":88,"url":null},"def":{"name":"unbuffered_flush","return_type":"NoReturn","visibility":"Public","body":"raise(IO::Error.new(\"Can't flush Compress::Zlib::Reader\"))"},"external_var":false},{"html_id":"unbuffered_read(slice:Bytes):Int32-instance-method","name":"unbuffered_read","doc":"See `IO#read`.","summary":"<p>See <code><a href=\"../../IO.html#read%28slice%3ABytes%29-instance-method\">IO#read</a></code>.</p>","abstract":false,"args":[{"name":"slice","external_name":"slice","restriction":"Bytes"}],"args_string":"(slice : Bytes) : Int32","args_html":"(slice : <a href=\"../../Bytes.html\">Bytes</a>) : <a href=\"../../Int32.html\">Int32</a>","location":{"filename":"src/compress/zlib/reader.cr","line_number":61,"url":null},"def":{"name":"unbuffered_read","args":[{"name":"slice","external_name":"slice","restriction":"Bytes"}],"return_type":"Int32","visibility":"Public","body":"check_open\n\nif slice.empty?\n  return 0\nend\nif @end\n  return 0\nend\n\nread_bytes = @flate_io.read(slice)\nif read_bytes == 0\n  @end = true\n  @flate_io.close\n  adler32 = @io.read_bytes(UInt32, IO::ByteFormat::BigEndian)\n  if adler32 != @adler32\n    raise(Compress::Zlib::Error.new(\"ADLER-32 checksum mismatch\"))\n  end\nelse\n  @adler32 = ::Digest::Adler32.update(slice[0, read_bytes], @adler32)\nend\nread_bytes\n"},"external_var":false},{"html_id":"unbuffered_rewind:Nil-instance-method","name":"unbuffered_rewind","doc":"Rewinds the wrapped `IO`.\n\nTODO: Add return type restriction `Nil`","summary":"<p>Rewinds the wrapped <code><a href=\"../../IO.html\">IO</a></code>.</p>","abstract":false,"location":{"filename":"src/compress/zlib/reader.cr","line_number":100,"url":null},"def":{"name":"unbuffered_rewind","return_type":"Nil","visibility":"Public","body":"check_open\n\n@io.rewind\n\ninitialize(@io, @sync_close, @flate_io.dict)\n"},"external_var":false},{"html_id":"unbuffered_write(slice:Bytes):NoReturn-instance-method","name":"unbuffered_write","doc":"Always raises `IO::Error` because this is a read-only `IO`.","summary":"<p>Always raises <code><a href=\"../../IO/Error.html\">IO::Error</a></code> because this is a read-only <code><a href=\"../../IO.html\">IO</a></code>.</p>","abstract":false,"args":[{"name":"slice","external_name":"slice","restriction":"Bytes"}],"args_string":"(slice : Bytes) : NoReturn","args_html":"(slice : <a href=\"../../Bytes.html\">Bytes</a>) : NoReturn","location":{"filename":"src/compress/zlib/reader.cr","line_number":84,"url":null},"def":{"name":"unbuffered_write","args":[{"name":"slice","external_name":"slice","restriction":"Bytes"}],"return_type":"NoReturn","visibility":"Public","body":"raise(IO::Error.new(\"Can't write to Compress::Zlib::Reader\"))"},"external_var":false}]},{"html_id":"Crystal/Compress/Zlib/Writer","path":"Compress/Zlib/Writer.html","kind":"class","full_name":"Compress::Zlib::Writer","name":"Writer","abstract":false,"superclass":{"html_id":"Crystal/IO","kind":"class","full_name":"IO","name":"IO"},"ancestors":[{"html_id":"Crystal/IO","kind":"class","full_name":"IO","name":"IO"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/compress/zlib/writer.cr","line_number":8,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"namespace":{"html_id":"Crystal/Compress/Zlib","kind":"module","full_name":"Compress::Zlib","name":"Zlib"},"doc":"A write-only `IO` object to compress data in the zlib format.\n\nInstances of this class wrap another IO object. When you write to this\ninstance, it compresses the data and writes it to the underlying IO.\n\nNOTE: unless created with a block, `close` must be invoked after all\ndata has been written to a Zlib::Writer instance.","summary":"<p>A write-only <code><a href=\"../../IO.html\">IO</a></code> object to compress data in the zlib format.</p>","class_methods":[{"html_id":"open(io:IO,level=Zlib::DEFAULT_COMPRESSION,sync_close=false,dict:Bytes|Nil=nil,&)-class-method","name":"open","doc":"Creates a new writer to the given *io*, yields it to the given block,\nand closes it at the end.","summary":"<p>Creates a new writer to the given <em>io</em>, yields it to the given block, and closes it at the end.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"level","default_value":"Zlib::DEFAULT_COMPRESSION","external_name":"level","restriction":""},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":""},{"name":"dict","default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"args_string":"(io : IO, level = Zlib::DEFAULT_COMPRESSION, sync_close = false, dict : Bytes | Nil = nil, &)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, level = <span class=\"t\">Zlib</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>, sync_close = <span class=\"n\">false</span>, dict : <a href=\"../../Bytes.html\">Bytes</a> | <a href=\"../../Nil.html\">Nil</a> = <span class=\"n\">nil</span>, &)","location":{"filename":"src/compress/zlib/writer.cr","line_number":29,"url":null},"def":{"name":"open","args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"level","default_value":"Zlib::DEFAULT_COMPRESSION","external_name":"level","restriction":""},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":""},{"name":"dict","default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"yields":1,"block_arity":1,"visibility":"Public","body":"writer = new(io, level: level, sync_close: sync_close, dict: dict)\nbegin\n  yield writer\nensure\n  writer.close\nend\n"},"external_var":false},{"html_id":"open(filename:String,level=Zlib::DEFAULT_COMPRESSION,dict:Bytes|Nil=nil,&)-class-method","name":"open","doc":"Creates a new writer to the given *filename*, yields it to the given block,\nand closes it at the end.","summary":"<p>Creates a new writer to the given <em>filename</em>, yields it to the given block, and closes it at the end.</p>","abstract":false,"args":[{"name":"filename","external_name":"filename","restriction":"String"},{"name":"level","default_value":"Zlib::DEFAULT_COMPRESSION","external_name":"level","restriction":""},{"name":"dict","default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"args_string":"(filename : String, level = Zlib::DEFAULT_COMPRESSION, dict : Bytes | Nil = nil, &)","args_html":"(filename : <a href=\"../../String.html\">String</a>, level = <span class=\"t\">Zlib</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>, dict : <a href=\"../../Bytes.html\">Bytes</a> | <a href=\"../../Nil.html\">Nil</a> = <span class=\"n\">nil</span>, &)","location":{"filename":"src/compress/zlib/writer.cr","line_number":36,"url":null},"def":{"name":"open","args":[{"name":"filename","external_name":"filename","restriction":"String"},{"name":"level","default_value":"Zlib::DEFAULT_COMPRESSION","external_name":"level","restriction":""},{"name":"dict","default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"yields":1,"block_arity":1,"visibility":"Public","body":"writer = new(filename, level: level, dict: dict)\nbegin\n  yield writer\nensure\n  writer.close\nend\n"},"external_var":false}],"constructors":[{"html_id":"new(io:IO,level:Int32=Zlib::DEFAULT_COMPRESSION,sync_close:Bool=false,dict:Bytes|Nil=nil)-class-method","name":"new","doc":"Creates a new writer to the given *io*.","summary":"<p>Creates a new writer to the given <em>io</em>.</p>","abstract":false,"args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"level","default_value":"Zlib::DEFAULT_COMPRESSION","external_name":"level","restriction":"::Int32"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":"::Bool"},{"name":"dict","default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"args_string":"(io : IO, level : Int32 = Zlib::DEFAULT_COMPRESSION, sync_close : Bool = false, dict : Bytes | Nil = nil)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, level : <a href=\"../../Int32.html\">Int32</a> = <span class=\"t\">Zlib</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>, sync_close : <a href=\"../../Bool.html\">Bool</a> = <span class=\"n\">false</span>, dict : <a href=\"../../Bytes.html\">Bytes</a> | <a href=\"../../Nil.html\">Nil</a> = <span class=\"n\">nil</span>)","location":{"filename":"src/compress/zlib/writer.cr","line_number":16,"url":null},"def":{"name":"new","args":[{"name":"io","external_name":"io","restriction":"IO"},{"name":"level","default_value":"Zlib::DEFAULT_COMPRESSION","external_name":"level","restriction":"::Int32"},{"name":"sync_close","default_value":"false","external_name":"sync_close","restriction":"::Bool"},{"name":"dict","default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"visibility":"Public","body":"_ = allocate\n_.initialize(io, level, sync_close, dict)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"},"external_var":false},{"html_id":"new(filename:String,level=Zlib::DEFAULT_COMPRESSION,dict:Bytes|Nil=nil)-class-method","name":"new","doc":"Creates a new writer to the given *filename*.","summary":"<p>Creates a new writer to the given <em>filename</em>.</p>","abstract":false,"args":[{"name":"filename","external_name":"filename","restriction":"String"},{"name":"level","default_value":"Zlib::DEFAULT_COMPRESSION","external_name":"level","restriction":""},{"name":"dict","default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"args_string":"(filename : String, level = Zlib::DEFAULT_COMPRESSION, dict : Bytes | Nil = nil)","args_html":"(filename : <a href=\"../../String.html\">String</a>, level = <span class=\"t\">Zlib</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>, dict : <a href=\"../../Bytes.html\">Bytes</a> | <a href=\"../../Nil.html\">Nil</a> = <span class=\"n\">nil</span>)","location":{"filename":"src/compress/zlib/writer.cr","line_number":23,"url":null},"def":{"name":"new","args":[{"name":"filename","external_name":"filename","restriction":"String"},{"name":"level","default_value":"Zlib::DEFAULT_COMPRESSION","external_name":"level","restriction":""},{"name":"dict","default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"visibility":"Public","body":"new(::File.new(filename, \"w\"), level: level, sync_close: true, dict: dict)"},"external_var":false}],"instance_methods":[{"html_id":"close:Nil-instance-method","name":"close","doc":"Closes this writer. Must be invoked after all data has been written.","summary":"<p>Closes this writer.</p>","abstract":false,"location":{"filename":"src/compress/zlib/writer.cr","line_number":70,"url":null},"def":{"name":"close","return_type":"Nil","visibility":"Public","body":"if @closed\n  return\nend\n@closed = true\n\nif @wrote_header\nelse\n  write_header\nend\n\n@flate_io.close\n\n@io.write_bytes(@adler32, IO::ByteFormat::BigEndian)\n\nif @sync_close\n  @io.close\nend\n"},"external_var":false},{"html_id":"closed?:Bool-instance-method","name":"closed?","doc":"Returns `true` if this writer is closed.","summary":"<p>Returns <code>true</code> if this writer is closed.</p>","abstract":false,"location":{"filename":"src/compress/zlib/writer.cr","line_number":13,"url":null},"def":{"name":"closed?","visibility":"Public","body":"@closed"},"external_var":false},{"html_id":"flush:Nil-instance-method","name":"flush","doc":"Flushes data, forcing writing the zlib header if no\ndata has been written yet.\n\nSee `IO#flush`.","summary":"<p>Flushes data, forcing writing the zlib header if no data has been written yet.</p>","abstract":false,"location":{"filename":"src/compress/zlib/writer.cr","line_number":62,"url":null},"def":{"name":"flush","return_type":"Nil","visibility":"Public","body":"check_open\n\nif @wrote_header\nelse\n  write_header\nend\n@flate_io.flush\n"},"external_var":false},{"html_id":"read(slice:Bytes):NoReturn-instance-method","name":"read","doc":"Always raises `IO::Error` because this is a write-only `IO`.","summary":"<p>Always raises <code><a href=\"../../IO/Error.html\">IO::Error</a></code> because this is a write-only <code><a href=\"../../IO.html\">IO</a></code>.</p>","abstract":false,"args":[{"name":"slice","external_name":"slice","restriction":"Bytes"}],"args_string":"(slice : Bytes) : NoReturn","args_html":"(slice : <a href=\"../../Bytes.html\">Bytes</a>) : NoReturn","location":{"filename":"src/compress/zlib/writer.cr","line_number":42,"url":null},"def":{"name":"read","args":[{"name":"slice","external_name":"slice","restriction":"Bytes"}],"return_type":"NoReturn","visibility":"Public","body":"raise(IO::Error.new(\"Can't read from Gzip::Writer\"))"},"external_var":false},{"html_id":"sync_close=(sync_close:Bool)-instance-method","name":"sync_close=","doc":"Whether to close the enclosed `IO` when closing this writer.","summary":"<p>Whether to close the enclosed <code><a href=\"../../IO.html\">IO</a></code> when closing this writer.</p>","abstract":false,"args":[{"name":"sync_close","external_name":"sync_close","restriction":"::Bool"}],"args_string":"(sync_close : Bool)","args_html":"(sync_close : <a href=\"../../Bool.html\">Bool</a>)","location":{"filename":"src/compress/zlib/writer.cr","line_number":10,"url":null},"def":{"name":"sync_close=","args":[{"name":"sync_close","external_name":"sync_close","restriction":"::Bool"}],"visibility":"Public","body":"@sync_close = sync_close"},"external_var":false},{"html_id":"sync_close?:Bool-instance-method","name":"sync_close?","doc":"Whether to close the enclosed `IO` when closing this writer.","summary":"<p>Whether to close the enclosed <code><a href=\"../../IO.html\">IO</a></code> when closing this writer.</p>","abstract":false,"location":{"filename":"src/compress/zlib/writer.cr","line_number":10,"url":null},"def":{"name":"sync_close?","visibility":"Public","body":"@sync_close"},"external_var":false},{"html_id":"write(slice:Bytes):Nil-instance-method","name":"write","doc":"See `IO#write`.","summary":"<p>See <code><a href=\"../../IO.html#write%28slice%3ABytes%29%3ANil-instance-method\">IO#write</a></code>.</p>","abstract":false,"args":[{"name":"slice","external_name":"slice","restriction":"Bytes"}],"args_string":"(slice : Bytes) : Nil","args_html":"(slice : <a href=\"../../Bytes.html\">Bytes</a>) : <a href=\"../../Nil.html\">Nil</a>","location":{"filename":"src/compress/zlib/writer.cr","line_number":47,"url":null},"def":{"name":"write","args":[{"name":"slice","external_name":"slice","restriction":"Bytes"}],"return_type":"Nil","visibility":"Public","body":"check_open\n\nif slice.empty?\n  return\nend\n\nif @wrote_header\nelse\n  write_header\nend\n\n@flate_io.write(slice)\n@adler32 = ::Digest::Adler32.update(slice, @adler32)\n"},"external_var":false}]}]}]},{"html_id":"Crystal/Crypto","path":"Crypto.html","kind":"module","full_name":"Crypto","name":"Crypto","abstract":false,"locations":[{"filename":"src/crypto/subtle.cr","line_number":1,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"types":[{"html_id":"Crystal/Crypto/Bcrypt","path":"Crypto/Bcrypt.html","kind":"class","full_name":"Crypto::Bcrypt","name":"Bcrypt","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[{"filename":"src/crypto/bcrypt.cr","line_number":29,"url":null}],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"const":false,"constants":[{"id":"COST_RANGE","name":"COST_RANGE","value":"4..31"},{"id":"DEFAULT_COST","name":"DEFAULT_COST","value":"11"},{"id":"PASSWORD_RANGE","name":"PASSWORD_RANGE","value":"1..72"},{"id":"SALT_SIZE","name":"SALT_SIZE","value":"16"}],"namespace":{"html_id":"Crystal/Crypto","kind":"module","full_name":"Crypto","name":"Crypto"},"doc":"Pure Crystal implementation of the Bcrypt algorithm by Niels Provos and David\nMazières, as [presented at USENIX in\n1999](https://www.usenix.org/legacy/events/usenix99/provos/provos_html/index.html).\n\nThe algorithm has a maximum password length limit of 71 characters (see\n[this comment](https://security.stackexchange.com/questions/39849/does-bcrypt-have-a-maximum-password-length#answer-39851)\non stackoverflow).\n\nRefer to `Crypto::Bcrypt::Password` for a higher level interface.\n\nAbout the Cost\n\nBcrypt, like the PBKDF2 or scrypt ciphers, are designed to be slow, so\ngenerating rainbow tables or cracking passwords is nearly impossible. Yet,\ncomputers are always getting faster and faster, so the actual cost must be\nincremented every once in a while.\nAlways use the maximum cost that is tolerable, performance wise, for your\napplication. Be sure to test and select this based on your server, not your\nhome computer.\n\nLast but not least: beware of denial of services! Always protect your\napplication using an external strategy (eg: rate limiting), otherwise\nendpoints that verifies bcrypt hashes will be an easy target.\n\nNOTE: To use `Bcrypt`, you must explicitly import it with `require \"crypto/bcrypt\"`","summary":"<p>Pure Crystal implementation of the Bcrypt algorithm by Niels Provos and David Mazières, as <a href=\"https://www.usenix.org/legacy/events/usenix99/provos/provos_html/index.html\">presented at USENIX in 1999</a>.</p>","class_methods":[{"html_id":"hash_secret(password:String,cost:Int32=DEFAULT_COST):String-class-method","name":"hash_secret","doc":"Hashes the *password* using bcrypt algorithm using salt obtained via `Random::Secure.random_bytes(SALT_SIZE)`.\n\n```\nrequire \"crypto/bcrypt\"\n\nCrypto::Bcrypt.hash_secret \"secret\"\n```","summary":"<p>Hashes the <em>password</em> using bcrypt algorithm using salt obtained via <code><a href=\"../Random/Secure.html#random_bytes%28buf%3ABytes%29%3ANil-instance-method\">Random::Secure.random_bytes(SALT_SIZE)</a></code>.</p>","abstract":false,"args":[{"name":"password","external_name":"password","restriction":"String"},{"name":"cost","default_value":"DEFAULT_COST","external_name":"cost","restriction":"Int32"}],"args_string":"(password : String, cost : Int32 = DEFAULT_COST) : String","args_html":"(password : <a href=\"../String.html\">String</a>, cost : <a href=\"../Int32.html\">Int32</a> = <span class=\"t\">DEFAULT_COST</span>) : <a href=\"../String.html\">String</a>","location":{"filename":"src/crypto/bcrypt.cr","line_number":61,"url":null},"def":{"name":"hash_secret","args":[{"name":"password","external_name":"password","restriction":"String"},{"name":"cost","default_value":"DEFAULT_COST","external_name":"cost","restriction":"Int32"}],"return_type":"String","visibility":"Public","body":"passwordb = (password.to_unsafe.to_slice(password.bytesize + 1)).clone\nsaltb = Random::Secure.random_bytes(SALT_SIZE)\n(new(passwordb, saltb, cost)).to_s\n"},"external_var":false}],"constructors":[{"html_id":"new(password:String,salt:String,cost:Int32=DEFAULT_COST):self-class-method","name":"new","doc":"Creates a new `Crypto::Bcrypt` object from the given *password* with *salt* and *cost*.\n\n*salt* must be a base64 encoded string of 16 bytes (128 bits).\n\n```\nrequire \"crypto/bcrypt\"\n\npassword = Crypto::Bcrypt.new \"secret\", \"CJjskaIgXR32DJYjVyNPdA==\"\npassword.to_s # => \"$2a$11$CJjskaIgXR32DJYjVyNPd./ajV3Yj6GiP0IAI6rR.fMnjRgozqqqG\"\n```","summary":"<p>Creates a new <code><a href=\"../Crypto/Bcrypt.html\">Crypto::Bcrypt</a></code> object from the given <em>password</em> with <em>salt</em> and <em>cost</em>.</p>","abstract":false,"args":[{"name":"password","external_name":"password","restriction":"String"},{"name":"salt","external_name":"salt","restriction":"String"},{"name":"cost","default_value":"DEFAULT_COST","external_name":"cost","restriction":"Int32"}],"args_string":"(password : String, salt : String, cost : Int32 = DEFAULT_COST) : self","args_html":"(passwo