/*
 * Decompiled with CFR 0.152.
 */
package vrml;

import java.util.Hashtable;
import vrml.PendingObject;

public class CacheObject
extends Hashtable {
    boolean debug = false;
    public Hashtable cachePending = new Hashtable();

    public void clearCaches() {
        this.clear();
        this.cachePending.clear();
    }

    public synchronized void putCache(String string, Class clazz) {
        PendingObject pendingObject;
        this.put(string, clazz);
        if (this.debug) {
            System.out.println("Put the class " + string + " on thread " + Thread.currentThread());
        }
        if ((pendingObject = (PendingObject)this.cachePending.get(string)) != null) {
            if (this.debug) {
                System.out.println("Calling notify on " + string + " on object " + pendingObject + " on thread " + Thread.currentThread());
            }
            try {
                pendingObject.doNotify();
                this.cachePending.remove(string);
                return;
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                if (this.debug) {
                    System.out.println("IllegalMonitorStateException when calling notify on " + string + " on object " + pendingObject + " on thread " + Thread.currentThread() + " exception = " + illegalMonitorStateException);
                    return;
                }
            }
        } else if (this.debug) {
            System.out.println("Something is really wrong, we put class but there was no pending object for " + string + " on thread " + Thread.currentThread());
        }
    }

    public synchronized Class getCache(String string) {
        Class clazz;
        if (this.debug) {
            System.out.println("get cache for " + string + " on thread " + Thread.currentThread());
        }
        if ((clazz = (Class)this.get(string)) != null) {
            if (this.debug) {
                System.out.println("Got the class " + string + " on thread " + Thread.currentThread());
            }
            return clazz;
        }
        return null;
    }

    public synchronized PendingObject checkPendingCache(String string) {
        PendingObject pendingObject = null;
        pendingObject = (PendingObject)this.cachePending.get(string);
        if (pendingObject != null) {
            if (this.debug) {
                System.out.println("Waiting on " + string + " on thread " + Thread.currentThread());
            }
            return pendingObject;
        }
        if (this.debug) {
            System.out.println("Inserting pending object for " + string + " on thread " + Thread.currentThread());
        }
        PendingObject pendingObject2 = new PendingObject();
        this.cachePending.put(string, pendingObject2);
        return null;
    }
}

