#!/bin/sh

bindir=/opt/local/bin
exdir=/opt/local/share/examples/cicada

exec $bindir/cicada \
      --input $exdir/scfg/input.txt \
      --grammar $exdir/scfg/grammar.bin \
      --grammar "glue:straight=true,inverted=false,non-terminal=[x],goal=[s]" \
      --grammar "insertion:non-terminal=[x]" \
      --feature-function "ngram:file=$exdir/scfg/ngram.bin" \
      --feature-function word-penalty \
      --feature-function rule-penalty \
      --operation compose-cky \
      --operation apply:prune=true,size=100,weights=$exdir/scfg/weights \
      --operation output:file=-,kbest=10,weights=$exdir/scfg/weights
