#!/bin/sh

bindir=/opt/local/bin
exdir=/opt/local/share/examples/cicada

##
##
##    gramamr:
##      tree-grammar at $cicada/samples/s2t/grammar.bin
##      insertion grammar using [x] as non-terminal
##      The target side goal symbol is [ROOT]
##    features:
##      ngram language model
##      # of words
##      # of rules
##      # of glue penalty which penalize the # of SCFG rule to be included in the forest
##    operations:
##      tree-cky-composition
##      apply features
##      output kbests 

exec $bindir/cicada \
      --input $exdir/scfg/input.txt \
      --goal '[ROOT]' \
      --tree-grammar $exdir/s2t/grammar.bin:max-span=10 \
      --tree-grammar "glue:goal-source=[ROOT],goal-target=[ROOT],non-terminal-source=[x],non-terminal-target=[x],straight=true,invert=false" \
      --grammar "insertion:non-terminal=[x]" \
      --feature-function "ngram:file=$exdir/scfg/ngram.bin" \
      --feature-function word-penalty \
      --feature-function rule-penalty \
      --feature-function glue-tree-penalty \
      --operation compose-tree-cky \
      --operation apply:prune=true,size=100,weights=$exdir/s2t/weights \
      --operation output:file=-,kbest=10,weights=$exdir/s2t/weights
