#!/bin/sh

bindir=/opt/local/bin
weights=../tune/learn.10.weights

### generate config file

$bindir/cicada_filter_config \
  --input ../tune/cicada.config \
  --output cicada.config \
  --weights "weights=$weights" \
  --kbest 1 \
  --file "file=-"

### perform translation
$bindir/cicada --config cicada.config --threads 4 --debug --input ../../t2s/data/dev.forest.ja.gz > dev.ja-en

### evaluation
$bindir/cicada_eval --tstset dev.ja-en --refset ../../data/dev.en.ref


