##############################################################################
# Copyright (c) 2016-24, Lawrence Livermore National Security, LLC and CHAI
# project contributors. See the COPYRIGHT file for details.
#
# SPDX-License-Identifier: BSD-3-Clause
##############################################################################


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was chai-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

# cache the prefix dir (could be overriden by find_dependency)
set(CHAI_PACKAGE_PREFIX_DIR ${PACKAGE_PREFIX_DIR})

include(CMakeFindDependencyMacro)

include("${CMAKE_CURRENT_LIST_DIR}/BLTSetupTargets.cmake")

if (NOT TARGET umpire)
  find_dependency(umpire CONFIG NO_DEFAULT_PATH PATHS
    ${umpire_DIR}
    
    ${CHAI_PACKAGE_PREFIX_DIR})
endif ()

if (ON AND NOT TARGET RAJA)
  find_dependency(raja CONFIG NO_DEFAULT_PATH PATHS
    ${raja_DIR}
    /opt/local/lib/cmake/raja
    ${CHAI_PACKAGE_PREFIX_DIR})
endif ()

include("${CMAKE_CURRENT_LIST_DIR}/chai-targets.cmake")

check_required_components(chai)
