/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.gvt;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import org.apache.batik.gvt.Selectable;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.gvt.event.GraphicsNodeMouseEvent;
import org.apache.batik.gvt.event.GraphicsNodeMouseListener;
import org.apache.batik.gvt.event.SelectionEvent;
import org.apache.batik.gvt.event.SelectionListener;
import org.apache.batik.gvt.text.ConcreteTextSelector;
import org.apache.batik.gvt.text.Mark;
import org.apache.batik.swing.gvt.AbstractJGVTComponent;
import org.apache.batik.swing.gvt.Overlay;

public class TextSelectionManager {
    public static final Cursor TEXT_CURSOR = new Cursor(2);
    protected ConcreteTextSelector textSelector;
    protected AbstractJGVTComponent component;
    protected Overlay selectionOverlay = new SelectionOverlay();
    protected MouseListener mouseListener;
    protected Cursor previousCursor;
    protected Shape selectionHighlight;
    protected SelectionListener textSelectionListener;
    protected Color selectionOverlayColor = new Color(100, 100, 255, 100);
    protected Color selectionOverlayStrokeColor = Color.white;
    protected boolean xorMode = false;
    Object selection = null;

    public TextSelectionManager(AbstractJGVTComponent abstractJGVTComponent, EventDispatcher eventDispatcher) {
        this.textSelector = new ConcreteTextSelector();
        this.textSelectionListener = new TextSelectionListener();
        this.textSelector.addSelectionListener(this.textSelectionListener);
        this.mouseListener = new MouseListener();
        this.component = abstractJGVTComponent;
        this.component.getOverlays().add(this.selectionOverlay);
        eventDispatcher.addGraphicsNodeMouseListener((GraphicsNodeMouseListener)this.mouseListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.textSelector.addSelectionListener(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.textSelector.removeSelectionListener(selectionListener);
    }

    public void setSelectionOverlayColor(Color color) {
        this.selectionOverlayColor = color;
    }

    public Color getSelectionOverlayColor() {
        return this.selectionOverlayColor;
    }

    public void setSelectionOverlayStrokeColor(Color color) {
        this.selectionOverlayStrokeColor = color;
    }

    public Color getSelectionOverlayStrokeColor() {
        return this.selectionOverlayStrokeColor;
    }

    public void setSelectionOverlayXORMode(boolean bl) {
        this.xorMode = bl;
    }

    public boolean isSelectionOverlayXORMode() {
        return this.xorMode;
    }

    public Overlay getSelectionOverlay() {
        return this.selectionOverlay;
    }

    public Object getSelection() {
        return this.selection;
    }

    public void setSelection(Mark mark, Mark mark2) {
        this.textSelector.setSelection(mark, mark2);
    }

    public void clearSelection() {
        this.textSelector.clearSelection();
    }

    protected Rectangle outset(Rectangle rectangle, int n) {
        rectangle.x -= n;
        rectangle.y -= n;
        rectangle.width += 2 * n;
        rectangle.height += 2 * n;
        return rectangle;
    }

    protected Rectangle getHighlightBounds() {
        AffineTransform affineTransform = this.component.getRenderingTransform();
        Shape shape = affineTransform.createTransformedShape(this.selectionHighlight);
        return this.outset(shape.getBounds(), 1);
    }

    protected class SelectionOverlay
    implements Overlay {
        protected SelectionOverlay() {
        }

        @Override
        public void paint(Graphics graphics) {
            if (TextSelectionManager.this.selectionHighlight != null) {
                AffineTransform affineTransform = TextSelectionManager.this.component.getRenderingTransform();
                Shape shape = affineTransform.createTransformedShape(TextSelectionManager.this.selectionHighlight);
                Graphics2D graphics2D = (Graphics2D)graphics;
                if (TextSelectionManager.this.xorMode) {
                    graphics2D.setColor(Color.black);
                    graphics2D.setXORMode(Color.white);
                    graphics2D.fill(shape);
                } else {
                    graphics2D.setColor(TextSelectionManager.this.selectionOverlayColor);
                    graphics2D.fill(shape);
                    if (TextSelectionManager.this.selectionOverlayStrokeColor != null) {
                        graphics2D.setStroke(new BasicStroke(1.0f));
                        graphics2D.setColor(TextSelectionManager.this.selectionOverlayStrokeColor);
                        graphics2D.draw(shape);
                    }
                }
            }
        }
    }

    protected class TextSelectionListener
    implements SelectionListener {
        protected TextSelectionListener() {
        }

        public void selectionDone(SelectionEvent selectionEvent) {
            this.selectionChanged(selectionEvent);
            TextSelectionManager.this.selection = selectionEvent.getSelection();
        }

        public void selectionCleared(SelectionEvent selectionEvent) {
            this.selectionStarted(selectionEvent);
        }

        public void selectionStarted(SelectionEvent selectionEvent) {
            if (TextSelectionManager.this.selectionHighlight != null) {
                Rectangle rectangle = TextSelectionManager.this.getHighlightBounds();
                TextSelectionManager.this.selectionHighlight = null;
                TextSelectionManager.this.component.repaint(rectangle);
            }
            TextSelectionManager.this.selection = null;
        }

        public void selectionChanged(SelectionEvent selectionEvent) {
            Rectangle rectangle = null;
            AffineTransform affineTransform = TextSelectionManager.this.component.getRenderingTransform();
            if (TextSelectionManager.this.selectionHighlight != null) {
                rectangle = affineTransform.createTransformedShape(TextSelectionManager.this.selectionHighlight).getBounds();
                TextSelectionManager.this.outset(rectangle, 1);
            }
            TextSelectionManager.this.selectionHighlight = selectionEvent.getHighlightShape();
            if (TextSelectionManager.this.selectionHighlight != null) {
                if (rectangle != null) {
                    Rectangle rectangle2 = TextSelectionManager.this.getHighlightBounds();
                    rectangle2.add(rectangle);
                    TextSelectionManager.this.component.repaint(rectangle2);
                } else {
                    TextSelectionManager.this.component.repaint(TextSelectionManager.this.getHighlightBounds());
                }
            } else if (rectangle != null) {
                TextSelectionManager.this.component.repaint(rectangle);
            }
        }
    }

    protected class MouseListener
    implements GraphicsNodeMouseListener {
        protected MouseListener() {
        }

        public void mouseClicked(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            if (graphicsNodeMouseEvent.getSource() instanceof Selectable) {
                TextSelectionManager.this.textSelector.mouseClicked(graphicsNodeMouseEvent);
            }
        }

        public void mousePressed(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            if (graphicsNodeMouseEvent.getSource() instanceof Selectable) {
                TextSelectionManager.this.textSelector.mousePressed(graphicsNodeMouseEvent);
            } else if (TextSelectionManager.this.selectionHighlight != null) {
                TextSelectionManager.this.textSelector.clearSelection();
            }
        }

        public void mouseReleased(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            TextSelectionManager.this.textSelector.mouseReleased(graphicsNodeMouseEvent);
        }

        public void mouseEntered(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            if (graphicsNodeMouseEvent.getSource() instanceof Selectable) {
                TextSelectionManager.this.textSelector.mouseEntered(graphicsNodeMouseEvent);
                TextSelectionManager.this.previousCursor = TextSelectionManager.this.component.getCursor();
                if (TextSelectionManager.this.previousCursor.getType() == 0) {
                    TextSelectionManager.this.component.setCursor(TEXT_CURSOR);
                }
            }
        }

        public void mouseExited(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            if (graphicsNodeMouseEvent.getSource() instanceof Selectable) {
                TextSelectionManager.this.textSelector.mouseExited(graphicsNodeMouseEvent);
                if (TextSelectionManager.this.component.getCursor() == TEXT_CURSOR) {
                    TextSelectionManager.this.component.setCursor(TextSelectionManager.this.previousCursor);
                }
            }
        }

        public void mouseDragged(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            if (graphicsNodeMouseEvent.getSource() instanceof Selectable) {
                TextSelectionManager.this.textSelector.mouseDragged(graphicsNodeMouseEvent);
            }
        }

        public void mouseMoved(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
        }
    }
}

