/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.AbstractSVGAnimatedLength;
import org.apache.batik.dom.svg.SVGOMAnimatedBoolean;
import org.apache.batik.dom.svg.SVGOMAnimatedEnumeration;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGStylableElement;
import org.apache.batik.dom.svg.SVGTestsSupport;
import org.apache.batik.dom.svg.SVGTextContentSupport;
import org.apache.batik.dom.svg.TraitInformation;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.util.DoublyIndexedTable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedBoolean;
import org.w3c.dom.svg.SVGAnimatedEnumeration;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGStringList;

public abstract class SVGOMTextContentElement
extends SVGStylableElement {
    protected static DoublyIndexedTable xmlTraitInformation;
    protected static final String[] LENGTH_ADJUST_VALUES;
    protected SVGOMAnimatedBoolean externalResourcesRequired;
    protected AbstractSVGAnimatedLength textLength;
    protected SVGOMAnimatedEnumeration lengthAdjust;

    protected SVGOMTextContentElement() {
    }

    protected SVGOMTextContentElement(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
        this.initializeLiveAttributes();
    }

    @Override
    protected void initializeAllLiveAttributes() {
        super.initializeAllLiveAttributes();
        this.initializeLiveAttributes();
    }

    private void initializeLiveAttributes() {
        this.externalResourcesRequired = this.createLiveAnimatedBoolean(null, "externalResourcesRequired", false);
        this.lengthAdjust = this.createLiveAnimatedEnumeration(null, "lengthAdjust", LENGTH_ADJUST_VALUES, (short)1);
        this.textLength = new AbstractSVGAnimatedLength(this, null, "textLength", 2, true){
            boolean usedDefault;

            @Override
            protected String getDefaultValue() {
                this.usedDefault = true;
                return String.valueOf(SVGOMTextContentElement.this.getComputedTextLength());
            }

            @Override
            public SVGLength getBaseVal() {
                if (this.baseVal == null) {
                    this.baseVal = new SVGTextLength(this.direction);
                }
                return this.baseVal;
            }

            class SVGTextLength
            extends AbstractSVGAnimatedLength.BaseSVGLength {
                public SVGTextLength(short s) {
                    super(s);
                }

                @Override
                protected void revalidate() {
                    usedDefault = false;
                    super.revalidate();
                    if (usedDefault) {
                        this.valid = false;
                    }
                }
            }
        };
        this.liveAttributeValues.put(null, (Object)"textLength", (Object)this.textLength);
        this.textLength.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
    }

    public SVGAnimatedLength getTextLength() {
        return this.textLength;
    }

    public SVGAnimatedEnumeration getLengthAdjust() {
        return this.lengthAdjust;
    }

    public int getNumberOfChars() {
        return SVGTextContentSupport.getNumberOfChars((Element)((Object)this));
    }

    public float getComputedTextLength() {
        return SVGTextContentSupport.getComputedTextLength((Element)((Object)this));
    }

    public float getSubStringLength(int n, int n2) throws DOMException {
        return SVGTextContentSupport.getSubStringLength((Element)((Object)this), n, n2);
    }

    public SVGPoint getStartPositionOfChar(int n) throws DOMException {
        return SVGTextContentSupport.getStartPositionOfChar((Element)((Object)this), n);
    }

    public SVGPoint getEndPositionOfChar(int n) throws DOMException {
        return SVGTextContentSupport.getEndPositionOfChar((Element)((Object)this), n);
    }

    public SVGRect getExtentOfChar(int n) throws DOMException {
        return SVGTextContentSupport.getExtentOfChar((Element)((Object)this), n);
    }

    public float getRotationOfChar(int n) throws DOMException {
        return SVGTextContentSupport.getRotationOfChar((Element)((Object)this), n);
    }

    public int getCharNumAtPosition(SVGPoint sVGPoint) {
        return SVGTextContentSupport.getCharNumAtPosition((Element)((Object)this), sVGPoint.getX(), sVGPoint.getY());
    }

    public void selectSubString(int n, int n2) throws DOMException {
        SVGTextContentSupport.selectSubString((Element)((Object)this), n, n2);
    }

    public SVGAnimatedBoolean getExternalResourcesRequired() {
        return this.externalResourcesRequired;
    }

    public String getXMLlang() {
        return XMLSupport.getXMLLang((Element)((Object)this));
    }

    public void setXMLlang(String string) {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", string);
    }

    public String getXMLspace() {
        return XMLSupport.getXMLSpace((Element)((Object)this));
    }

    public void setXMLspace(String string) {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", string);
    }

    public SVGStringList getRequiredFeatures() {
        return SVGTestsSupport.getRequiredFeatures((Element)((Object)this));
    }

    public SVGStringList getRequiredExtensions() {
        return SVGTestsSupport.getRequiredExtensions((Element)((Object)this));
    }

    public SVGStringList getSystemLanguage() {
        return SVGTestsSupport.getSystemLanguage((Element)((Object)this));
    }

    public boolean hasExtension(String string) {
        return SVGTestsSupport.hasExtension((Element)((Object)this), string);
    }

    @Override
    protected DoublyIndexedTable getTraitInformationTable() {
        return xmlTraitInformation;
    }

    static {
        DoublyIndexedTable doublyIndexedTable = new DoublyIndexedTable(SVGStylableElement.xmlTraitInformation);
        doublyIndexedTable.put(null, (Object)"textLength", (Object)new TraitInformation(true, 3, 3));
        doublyIndexedTable.put(null, (Object)"lengthAdjust", (Object)new TraitInformation(true, 15));
        doublyIndexedTable.put(null, (Object)"externalResourcesRequired", (Object)new TraitInformation(true, 49));
        xmlTraitInformation = doublyIndexedTable;
        LENGTH_ADJUST_VALUES = new String[]{"", "spacing", "spacingAndGlyphs"};
    }
}

