/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import org.basex.query.CompileContext;
import org.basex.query.QueryException;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.expr.gflwor.Clause;
import org.basex.query.expr.path.Path;
import org.basex.query.func.fn.FnError;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarUsage;
import org.basex.util.hash.IntObjectMap;

public final class InlineContext {
    public final CompileContext cc;
    public final Var var;
    public final Expr expr;
    private VarUsage uses = VarUsage.MORE_THAN_ONCE;

    public InlineContext(Var var, Expr expr, CompileContext cc) {
        this.cc = cc;
        this.var = var;
        this.expr = expr;
    }

    public boolean inlineable(Expr ... targets) {
        long[] minMax = new long[]{1L, 1L};
        this.uses = VarUsage.NEVER;
        for (Expr target : targets) {
            this.uses = this.uses.plus(target.count(this.var).times(minMax[1]));
            if (!(target instanceof Clause)) continue;
            Clause clause = (Clause)target;
            clause.calcSize(minMax);
        }
        if (this.uses == VarUsage.NEVER) {
            return true;
        }
        if (!(this.uses != VarUsage.MORE_THAN_ONCE || this.expr instanceof Value || this.expr instanceof VarRef || this.expr instanceof ContextValue || this.expr instanceof Path && this.expr.size() == 1L && !this.expr.has(Flag.CNS))) {
            return false;
        }
        for (Expr target : targets) {
            if (this.var != null && !target.uses(this.var) || target.inlineable(this)) continue;
            return false;
        }
        return true;
    }

    public Expr inline(Expr target) throws QueryException {
        Expr inlined = this.inlineOrNull(target);
        return inlined != null ? inlined : target;
    }

    public Expr inlineOrNull(Expr target) throws QueryException {
        return this.uses == VarUsage.NEVER ? null : target.inline(this);
    }

    public boolean inline(Expr[] exprs) throws QueryException {
        return this.inline(exprs, false);
    }

    public boolean inline(Expr[] exprs, boolean error) throws QueryException {
        boolean changed = false;
        int el = exprs.length;
        for (int e = 0; e < el; ++e) {
            Expr inlined;
            try {
                inlined = exprs[e].inline(this);
            }
            catch (QueryException ex) {
                if (!error) {
                    throw ex;
                }
                inlined = FnError.get(ex, exprs[e]);
            }
            if (inlined == null) continue;
            exprs[e] = inlined;
            changed = true;
        }
        return changed;
    }

    public Expr copy() throws QueryException {
        return this.expr instanceof Value ? this.expr : this.expr.copy(this.cc, new IntObjectMap<Var>()).optimize(this.cc);
    }
}

