/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.basex.core.MainOptions;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.util.InputInfo;
import org.basex.util.options.Option;
import org.basex.util.options.Options;

public final class DBOptions {
    private final HashMap<Option<?>, Object> map = new HashMap();

    public DBOptions(HashMap<String, String> qopts, Option<?>[] supported, InputInfo info) throws QueryException {
        HashMap options = new HashMap();
        for (Option<?> option : supported) {
            options.put(option.name().toLowerCase(Locale.ENGLISH), option);
        }
        for (Map.Entry entry : qopts.entrySet()) {
            String name = (String)entry.getKey();
            Option option = (Option)options.get(name);
            if (option == null) {
                throw QueryError.BASEX_OPTIONS_X.get(info, Options.similar(name, options));
            }
            String error = Options.assign(option, (String)entry.getValue(), -1, v -> this.map.put(option, v), null);
            if (error == null) continue;
            throw QueryError.BASEX_OPTIONS_X.get(info, error);
        }
    }

    public Object get(Option<?> option) {
        return this.map.get(option);
    }

    public void assignIfAbsent(Option<?> option, Object value) {
        this.map.putIfAbsent(option, value);
    }

    public MainOptions assignTo(MainOptions opts) {
        this.map.forEach(opts::put);
        return opts;
    }
}

