/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.regex.Matcher;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.func.fn.RegExFn;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class FnAnalyzeString
extends RegExFn {
    private static final QNm Q_ANALYZE_STRING_RESULT = new QNm("analyze-string-result", QueryText.FN_URI);
    private static final QNm Q_MATCH = new QNm("match", QueryText.FN_URI);
    private static final QNm Q_NON_MATCH = new QNm("non-match", QueryText.FN_URI);
    private static final QNm Q_MGROUP = new QNm("group", QueryText.FN_URI);
    private static final QNm Q_LGROUP = new QNm("lookahead-group", QueryText.FN_URI);
    private static final QNm Q_NR = new QNm("nr");
    private static final QNm Q_VALUE = new QNm("value");
    private static final QNm Q_POSITION = new QNm("position");

    @Override
    public FNode item(QueryContext qc, InputInfo ii) throws QueryException {
        String value = Token.string(this.toZeroToken(this.arg(0), qc));
        byte[] pattern = this.toToken(this.arg(1), qc);
        byte[] flags = this.toZeroToken(this.arg(2), qc);
        RegExFn.RegExpr regExpr = this.regExpr(pattern, flags);
        Matcher matcher = regExpr.pattern.matcher(value);
        FBuilder root = FElem.build(Q_ANALYZE_STRING_RESULT).declareNS();
        int start = 0;
        while (matcher.find()) {
            if (start != matcher.start()) {
                FnAnalyzeString.nonmatch(value.substring(start, matcher.start()), root);
            }
            FnAnalyzeString.match(matcher, value, root, 0, regExpr);
            start = matcher.end();
        }
        if (start != value.length()) {
            FnAnalyzeString.nonmatch(value.substring(start), root);
        }
        return root.finish();
    }

    private static int[] match(Matcher matcher, String string, FBuilder parent, int group, RegExFn.RegExpr regExpr) {
        FBuilder node = FElem.build(group == 0 ? Q_MATCH : Q_MGROUP);
        if (group > 0) {
            node.add(Q_NR, group);
        }
        int start = matcher.start(group);
        int end = matcher.end(group);
        int gc = matcher.groupCount();
        int[] pos = new int[]{group + 1, start};
        while (pos[0] <= gc && matcher.end(pos[0]) <= end && (matcher.start(pos[0]) < end || regExpr.getParentGroups()[pos[0] - 1] == group)) {
            int st = matcher.start(pos[0]);
            if (st >= 0 && !regExpr.getAssertionFlags()[pos[0] - 1]) {
                if (pos[1] < st) {
                    node.add(string.substring(pos[1], st));
                }
                pos = FnAnalyzeString.match(matcher, string, node, pos[0], regExpr);
                continue;
            }
            pos[0] = pos[0] + 1;
        }
        if (pos[1] < end) {
            node.add(string.substring(pos[1], end));
            pos[1] = end;
        }
        if (group == 0) {
            boolean[] assertionFlags = regExpr.getAssertionFlags();
            for (int g = 1; g <= assertionFlags.length; ++g) {
                if (!assertionFlags[g - 1] || matcher.start(g) < 0) continue;
                FBuilder lg = FElem.build(Q_LGROUP);
                lg.add(Q_NR, g);
                lg.add(Q_VALUE, string.substring(matcher.start(g), matcher.end(g)));
                lg.add(Q_POSITION, matcher.start(g) + 1);
                node.add(lg);
            }
        }
        parent.add(node);
        return pos;
    }

    private static void nonmatch(String text, FBuilder parent) {
        parent.add(FElem.build(Q_NON_MATCH).add(text));
    }
}

