/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import org.basex.core.Context;
import org.basex.core.Databases;
import org.basex.core.cmd.ShowBackups;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.db.DbAccessFn;
import org.basex.query.iter.BasicIter;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.util.DateTime;
import org.basex.util.list.StringList;

public final class DbBackups
extends StandardFunc {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        String name = this.defined(0) ? this.toName(this.arg(0), true, QueryError.DB_NAME_X, qc) : null;
        final Context ctx = qc.context;
        final StringList backups = name == null ? ctx.databases.backups() : ctx.databases.backups(name);
        return new BasicIter<FNode>((long)backups.size()){
            final IOFile dbPath;
            {
                super(size);
                this.dbPath = ctx.soptions.dbPath();
            }

            @Override
            public FNode get(long i) {
                String backup = (String)backups.get((int)i);
                String db = Databases.name(backup);
                FBuilder elem = FElem.build(DbAccessFn.Q_BACKUP).add(backup);
                if (!db.isEmpty()) {
                    elem.add(DbAccessFn.Q_DATABASE, db);
                }
                elem.add(DbAccessFn.Q_DATE, Dtm.get(DateTime.parse(Databases.date(backup)).getTime()).string(DbBackups.this.info));
                elem.add(DbAccessFn.Q_SIZE, new IOFile(this.dbPath, backup + ".zip").length());
                String comment = ShowBackups.comment(backup, ctx);
                if (!comment.isEmpty()) {
                    elem.add(DbAccessFn.Q_COMMENT, comment);
                }
                return elem.finish();
            }
        };
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return (this.defined(0) ? this.dataLock(this.arg(0), true, visitor) : visitor.lock((String)null)) && super.accept(visitor);
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.iter(qc).value(qc, this);
    }
}

