/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.array;

import java.util.Iterator;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.array.ArrayFn;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.Type;

public final class ArraySplit
extends ArrayFn {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        final XQArray array = this.toArray(this.arg(0), qc);
        return new Iter(){
            final Iterator<Value> values;
            {
                this.values = array.iterable().iterator();
            }

            @Override
            public XQArray next() {
                return this.values.hasNext() ? XQArray.get(this.values.next()) : null;
            }

            @Override
            public Item get(long i) {
                return XQArray.get(array.memberAt(i));
            }

            @Override
            public long size() {
                return array.structSize();
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        XQArray array = this.toArray(this.arg(0), qc);
        ValueBuilder vb = new ValueBuilder(qc, this.structSize());
        for (Value member : array.iterable()) {
            vb.add(XQArray.get(member));
        }
        return vb.value();
    }

    @Override
    protected Expr opt(CompileContext cc) {
        Expr array = this.arg(0);
        if (array == XQArray.empty()) {
            return Empty.VALUE;
        }
        Type ft = array.seqType().type;
        if (ft instanceof ArrayType) {
            this.exprType.assign(ft.seqType(Occ.ZERO_OR_MORE));
        }
        return this;
    }
}

