/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.csv;

import org.basex.build.csv.CsvParserOptions;
import org.basex.io.parse.csv.CsvConverter;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.seq.StrSeq;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.list.TokenList;

public class CsvXQueryConverter
extends CsvConverter {
    private static final ArrayType STRING_ARRAY = ArrayType.get(SeqType.STRING_O);
    public static final Str NAMES = Str.get("names");
    public static final Str RECORDS = Str.get("records");
    private final ItemList rows = new ItemList();
    private TokenList row;

    CsvXQueryConverter(CsvParserOptions opts) {
        super(opts);
    }

    @Override
    protected final void header(byte[] string) {
        this.headers.add(this.shared.token(string));
    }

    @Override
    protected final void record() {
        if (this.row != null) {
            this.rows.add(XQArray.items(StrSeq.get((byte[][])this.row.next())));
        } else {
            this.row = new TokenList();
        }
    }

    @Override
    protected final void entry(byte[] value) {
        this.row.add(this.shared.token(value));
    }

    @Override
    protected final void init(String uri) {
    }

    @Override
    protected Value finish(InputInfo ii, QueryContext qc) throws QueryException {
        if (this.row != null) {
            this.rows.add(XQArray.items(StrSeq.get((byte[][])this.row.next())));
        }
        MapBuilder mb = new MapBuilder();
        if (!this.headers.isEmpty()) {
            mb.put((Item)NAMES, (Value)XQArray.items(StrSeq.get(this.headers)));
        }
        return mb.put((Item)RECORDS, this.rows.value(STRING_ARRAY)).map();
    }
}

