/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.appbundler;

import com.oracle.appbundler.IconContainer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;

public class BundleDocument
implements IconContainer {
    private String name = null;
    private String role = "Editor";
    private String icon = null;
    private String handlerRank = null;
    private List<String> extensions;
    private List<String> contentTypes;
    private List<String> exportableTypes;
    private boolean isPackage = false;

    private String capitalizeFirst(String string) {
        char[] stringArray = string.toCharArray();
        stringArray[0] = Character.toUpperCase(stringArray[0]);
        return new String(stringArray);
    }

    public void setExtensions(String extensionsString) {
        this.extensions = BundleDocument.getListFromCommaSeparatedString(extensionsString, "Extensions", true);
    }

    public void setContentTypes(String contentTypesString) {
        this.contentTypes = BundleDocument.getListFromCommaSeparatedString(contentTypesString, "Content Types");
    }

    public void setExportableTypes(String exportableTypesString) {
        this.exportableTypes = BundleDocument.getListFromCommaSeparatedString(exportableTypesString, "Exportable Types");
    }

    public static List<String> getListFromCommaSeparatedString(String listAsString, String attributeName) {
        return BundleDocument.getListFromCommaSeparatedString(listAsString, attributeName, false);
    }

    public static List<String> getListFromCommaSeparatedString(String listAsString, String attributeName, boolean lowercase) {
        if (listAsString == null) {
            throw new BuildException(attributeName + " can't be null");
        }
        String[] splittedListAsString = listAsString.split(",");
        ArrayList<String> stringList = new ArrayList<String>();
        for (String extension : splittedListAsString) {
            String cleanExtension = extension.trim();
            if (lowercase) {
                cleanExtension = cleanExtension.toLowerCase();
            }
            if (cleanExtension.length() <= 0) continue;
            stringList.add(cleanExtension);
        }
        if (stringList.size() == 0) {
            throw new BuildException(attributeName + " list must not be empty");
        }
        return stringList;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRole(String role) {
        this.role = this.capitalizeFirst(role);
    }

    public void setHandlerRank(String handlerRank) {
        this.handlerRank = this.capitalizeFirst(handlerRank);
    }

    public void setIsPackage(String isPackageString) {
        this.isPackage = isPackageString.trim().equalsIgnoreCase("true");
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    public String getName() {
        return this.name;
    }

    public String getRole() {
        return this.role;
    }

    public String getHandlerRank() {
        return this.handlerRank;
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public List<String> getContentTypes() {
        return this.contentTypes;
    }

    public List<String> getExportableTypes() {
        return this.exportableTypes;
    }

    @Override
    public File getIconFile() {
        if (this.icon == null) {
            return null;
        }
        File ifile = new File(this.icon);
        if (!ifile.exists() || ifile.isDirectory()) {
            return null;
        }
        return ifile;
    }

    @Override
    public boolean hasIcon() {
        return this.icon != null;
    }

    public boolean isPackage() {
        return this.isPackage;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.getName());
        s.append(" ").append(this.getRole()).append(" ").append(this.getIcon()).append(" ").append(this.getHandlerRank()).append(" ");
        if (this.contentTypes != null) {
            for (String contentType : this.contentTypes) {
                s.append(contentType).append(" ");
            }
        }
        if (this.extensions != null) {
            for (String extension : this.extensions) {
                s.append(extension).append(" ");
            }
        }
        if (this.exportableTypes != null) {
            for (String exportableType : this.exportableTypes) {
                s.append(exportableType).append(" ");
            }
        }
        return s.toString();
    }
}

