/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.util;

import com.android.tools.smali.util.AbstractIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public final class IteratorUtils {
    public static <T> T getLast(Iterator<T> iterator) {
        T current;
        do {
            current = iterator.next();
        } while (iterator.hasNext());
        return current;
    }

    public static <T> AbstractIterator<T> filter(Iterable<T> unfiltered, Predicate<? super T> retainIfTrue) {
        return IteratorUtils.filter(unfiltered.iterator(), retainIfTrue);
    }

    public static <T> AbstractIterator<T> filter(final Iterator<T> unfiltered, final Predicate<? super T> retainIfTrue) {
        return new AbstractIterator<T>(){

            @Override
            protected T computeNext() {
                while (unfiltered.hasNext()) {
                    Object next = unfiltered.next();
                    if (!retainIfTrue.test(next)) continue;
                    return next;
                }
                return this.endOfData();
            }
        };
    }

    public static <T> List<T> toList(Iterable<T> iterable) {
        return IteratorUtils.toList(iterable.iterator());
    }

    public static <T> List<T> toList(Iterator<T> iterator) {
        ArrayList<T> list = new ArrayList<T>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static <T> void addAll(Collection<T> collection, Iterator<T> iterator) {
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
    }

    public static boolean elementsEqual(Iterator<?> iterator1, Iterator<?> iterator2) {
        while (iterator1.hasNext()) {
            Object o2;
            if (!iterator2.hasNext()) {
                return false;
            }
            Object o1 = iterator1.next();
            if (Objects.equals(o1, o2 = iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    public static int size(Iterable<?> iterable) {
        Iterator<?> iterator = iterable.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            ++count;
            iterator.next();
        }
        return count;
    }
}

