/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked.raw;

import com.android.tools.smali.dexlib2.dexbacked.DexBuffer;
import com.android.tools.smali.dexlib2.dexbacked.DexReader;
import com.android.tools.smali.dexlib2.dexbacked.raw.MapItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.SectionAnnotator;
import com.android.tools.smali.dexlib2.dexbacked.raw.util.DexAnnotator;
import com.android.tools.smali.dexlib2.util.AnnotatedBytes;
import com.android.tools.smali.util.StringUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StringDataItem {
    @Nonnull
    public static SectionAnnotator makeAnnotator(@Nonnull DexAnnotator annotator, @Nonnull MapItem mapItem) {
        return new SectionAnnotator(annotator, mapItem){

            @Override
            @Nonnull
            public String getItemName() {
                return "string_data_item";
            }

            @Override
            protected void annotateItem(@Nonnull AnnotatedBytes out, int itemIndex, @Nullable String itemIdentity) {
                DexReader<? extends DexBuffer> reader = this.dexFile.getBuffer().readerAt(out.getCursor());
                int utf16Length = reader.readSmallUleb128();
                out.annotateTo(reader.getOffset(), "utf16_size = %d", utf16Length);
                String value = reader.readString(utf16Length);
                out.annotateTo(reader.getOffset() + 1, "data = \"%s\"", StringUtils.escapeString(value));
            }
        };
    }
}

