/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.CantFind9PatchChunkException;
import brut.androlib.exceptions.RawXmlEncounteredException;
import brut.androlib.meta.ApkInfo;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.value.ResBoolValue;
import brut.androlib.res.data.value.ResFileValue;
import brut.androlib.res.decoder.ResStreamDecoderContainer;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.util.BrutIO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResFileDecoder {
    private static final Logger LOGGER = Logger.getLogger(ResFileDecoder.class.getName());
    private static final String[] RAW_IMAGE_EXTENSIONS = new String[]{"m4a", "qmg"};
    private static final String[] RAW_9PATCH_IMAGE_EXTENSIONS = new String[]{"qmg", "spi"};
    private final ResStreamDecoderContainer mDecoders;

    public ResFileDecoder(ResStreamDecoderContainer decoders) {
        this.mDecoders = decoders;
    }

    public void decode(ResResource res, Directory inDir, Directory outDir, Map<String, String> resFileMapping) throws AndrolibException {
        String outFileName;
        String inFilePath = ((ResFileValue)res.getValue()).toString();
        String inFileName = this.stripResFilePath(inFilePath);
        String typeName = res.getResSpec().getType().getName();
        String outResName = res.getFilePath();
        if (BrutIO.detectPossibleDirectoryTraversal(outResName)) {
            outResName = inFileName;
            LOGGER.warning(String.format("Potentially malicious file path: %s, using instead %s", res.getFilePath(), outResName));
        }
        String ext = null;
        int extPos = inFileName.lastIndexOf(".");
        if (extPos == -1) {
            outFileName = outResName;
        } else {
            ext = inFileName.substring(extPos).toLowerCase();
            outFileName = outResName + ext;
        }
        String outFilePath = "res/" + outFileName;
        if (!inFilePath.equals(outFilePath)) {
            resFileMapping.put(inFilePath, outFilePath);
        }
        LOGGER.fine("Decoding file " + inFilePath + " to " + outFilePath);
        try {
            if (typeName.equals("raw")) {
                this.decode(inDir, inFilePath, outDir, outFileName, "raw");
                return;
            }
            if (typeName.equals("font") && !".xml".equals(ext)) {
                this.decode(inDir, inFilePath, outDir, outFileName, "raw");
                return;
            }
            if (typeName.equals("drawable") || typeName.equals("mipmap")) {
                if (inFileName.toLowerCase().endsWith(".9" + ext)) {
                    outFileName = outResName + ".9" + ext;
                    if (inFileName.toLowerCase().endsWith(".r.9" + ext)) {
                        outFileName = outResName + ".r.9" + ext;
                    }
                    for (String extension : RAW_9PATCH_IMAGE_EXTENSIONS) {
                        if (!inFileName.toLowerCase().endsWith("." + extension)) continue;
                        this.decode(inDir, inFilePath, outDir, outFileName, "raw");
                        return;
                    }
                    if (inFileName.toLowerCase().endsWith(".xml")) {
                        this.decode(inDir, inFilePath, outDir, outFileName, "xml");
                        return;
                    }
                    try {
                        this.decode(inDir, inFilePath, outDir, outFileName, "9patch");
                        return;
                    }
                    catch (CantFind9PatchChunkException ex) {
                        LOGGER.log(Level.WARNING, String.format("Could not find 9patch chunk in file: \"%s\". Renaming it to *.png.", inFileName), ex);
                        outDir.removeFile(outFileName);
                        outFileName = outResName + ext;
                    }
                }
                for (String extension : RAW_IMAGE_EXTENSIONS) {
                    if (!inFileName.toLowerCase().endsWith("." + extension)) continue;
                    this.decode(inDir, inFilePath, outDir, outFileName, "raw");
                    return;
                }
                if (!".xml".equals(ext)) {
                    this.decode(inDir, inFilePath, outDir, outFileName, "raw");
                    return;
                }
            }
            this.decode(inDir, inFilePath, outDir, outFileName, "xml");
        }
        catch (RawXmlEncounteredException ex) {
            this.decode(inDir, inFilePath, outDir, outFileName, "raw");
        }
        catch (AndrolibException ex) {
            LOGGER.log(Level.SEVERE, String.format("Could not decode file, replacing by FALSE value: %s", inFileName), ex);
            res.replace(new ResBoolValue(false, 0, null));
        }
    }

    public void decode(Directory inDir, String inFileName, Directory outDir, String outFileName, String decoder) throws AndrolibException {
        try (InputStream in = inDir.getFileInput(inFileName);
             OutputStream out = outDir.getFileOutput(outFileName);){
            this.mDecoders.decode(in, out, decoder);
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException(ex);
        }
    }

    private String stripResFilePath(String path) throws AndrolibException {
        for (String dirName : ApkInfo.RESOURCES_DIRNAMES) {
            String prefix = dirName + "/";
            if (!path.startsWith(prefix)) continue;
            return path.substring(prefix.length());
        }
        throw new AndrolibException("File path does not start with \"res/\": " + path);
    }
}

