/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.axml;

public final class NamespaceStack {
    private int[] mData = new int[32];
    private int mDataLength;
    private int mDepth;

    public void reset() {
        this.mDataLength = 0;
        this.mDepth = 0;
    }

    public int getCurrentCount() {
        if (this.mDataLength == 0) {
            return 0;
        }
        int offset = this.mDataLength - 1;
        return this.mData[offset];
    }

    public int getAccumulatedCount(int depth) {
        if (this.mDataLength == 0 || depth < 0) {
            return 0;
        }
        if (depth > this.mDepth) {
            depth = this.mDepth;
        }
        int accumulatedCount = 0;
        int offset = 0;
        while (depth != 0) {
            int count = this.mData[offset];
            accumulatedCount += count;
            offset += 2 + count * 2;
            --depth;
        }
        return accumulatedCount;
    }

    public void push(int prefix, int uri) {
        if (this.mDepth == 0) {
            this.increaseDepth();
        }
        this.ensureDataCapacity(2);
        int offset = this.mDataLength - 1;
        int count = this.mData[offset];
        this.mData[offset - 1 - count * 2] = count + 1;
        this.mData[offset] = prefix;
        this.mData[offset + 1] = uri;
        this.mData[offset + 2] = count + 1;
        this.mDataLength += 2;
    }

    public boolean pop() {
        if (this.mDataLength == 0) {
            return false;
        }
        int offset = this.mDataLength - 1;
        int count = this.mData[offset];
        if (count == 0) {
            return false;
        }
        this.mData[offset -= 2] = --count;
        this.mData[offset -= 1 + count * 2] = count;
        this.mDataLength -= 2;
        return true;
    }

    public int getPrefix(int index) {
        return this.get(index, true);
    }

    public int getUri(int index) {
        return this.get(index, false);
    }

    public int findPrefix(int uri) {
        return this.find(uri, false);
    }

    public int getDepth() {
        return this.mDepth;
    }

    public void increaseDepth() {
        this.ensureDataCapacity(2);
        int offset = this.mDataLength;
        this.mData[offset] = 0;
        this.mData[offset + 1] = 0;
        this.mDataLength += 2;
        ++this.mDepth;
    }

    public void decreaseDepth() {
        if (this.mDataLength == 0) {
            return;
        }
        int offset = this.mDataLength - 1;
        int count = this.mData[offset];
        if (offset - 1 - count * 2 == 0) {
            return;
        }
        this.mDataLength -= 2 + count * 2;
        --this.mDepth;
    }

    private void ensureDataCapacity(int capacity) {
        int available = this.mData.length - this.mDataLength;
        if (available > capacity) {
            return;
        }
        int newLength = (this.mData.length + available) * 2;
        int[] newData = new int[newLength];
        System.arraycopy(this.mData, 0, newData, 0, this.mDataLength);
        this.mData = newData;
    }

    private int find(int prefixOrUri, boolean prefix) {
        if (this.mDataLength == 0) {
            return -1;
        }
        int offset = this.mDataLength - 1;
        for (int i = this.mDepth; i != 0; --i) {
            int count = this.mData[offset];
            offset -= 2;
            while (count != 0) {
                if (prefix) {
                    if (this.mData[offset] == prefixOrUri) {
                        return this.mData[offset + 1];
                    }
                } else if (this.mData[offset + 1] == prefixOrUri) {
                    return this.mData[offset];
                }
                offset -= 2;
                --count;
            }
        }
        return -1;
    }

    private int get(int index, boolean prefix) {
        if (this.mDataLength == 0 || index < 0) {
            return -1;
        }
        int offset = 0;
        for (int i = this.mDepth; i != 0; --i) {
            int count = this.mData[offset];
            if (index >= count) {
                index -= count;
                offset += 2 + count * 2;
                continue;
            }
            offset += 1 + index * 2;
            if (!prefix) {
                ++offset;
            }
            return this.mData[offset];
        }
        return -1;
    }
}

