/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.arsc;

import brut.util.ExtDataInput;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.logging.Logger;

public class ARSCHeader {
    private static final Logger LOGGER = Logger.getLogger(ARSCHeader.class.getName());
    public static final int RES_NONE_TYPE = -1;
    public static final int RES_NULL_TYPE = 0;
    public static final int RES_STRING_POOL_TYPE = 1;
    public static final int RES_TABLE_TYPE = 2;
    public static final int RES_XML_TYPE = 3;
    public static final int RES_XML_FIRST_CHUNK_TYPE = 256;
    public static final int RES_XML_START_NAMESPACE_TYPE = 256;
    public static final int RES_XML_END_NAMESPACE_TYPE = 257;
    public static final int RES_XML_START_ELEMENT_TYPE = 258;
    public static final int RES_XML_END_ELEMENT_TYPE = 259;
    public static final int RES_XML_CDATA_TYPE = 260;
    public static final int RES_XML_LAST_CHUNK_TYPE = 383;
    public static final int RES_XML_RESOURCE_MAP_TYPE = 384;
    public static final int RES_TABLE_PACKAGE_TYPE = 512;
    public static final int RES_TABLE_TYPE_TYPE = 513;
    public static final int RES_TABLE_TYPE_SPEC_TYPE = 514;
    public static final int RES_TABLE_LIBRARY_TYPE = 515;
    public static final int RES_TABLE_OVERLAYABLE_TYPE = 516;
    public static final int RES_TABLE_OVERLAYABLE_POLICY_TYPE = 517;
    public static final int RES_TABLE_STAGED_ALIAS_TYPE = 518;
    public final int type;
    public final int headerSize;
    public final int chunkSize;
    public final long startPosition;
    public final long endPosition;

    public ARSCHeader(int type, int headerSize, int chunkSize, long headerStart) {
        this.type = type;
        this.headerSize = headerSize;
        this.chunkSize = chunkSize;
        this.startPosition = headerStart;
        this.endPosition = headerStart + (long)chunkSize;
    }

    public static ARSCHeader read(ExtDataInput in) throws IOException {
        int type;
        long start = in.position();
        try {
            type = in.readUnsignedShort();
        }
        catch (EOFException ex) {
            return new ARSCHeader(-1, 0, 0, in.position());
        }
        return new ARSCHeader(type, in.readUnsignedShort(), in.readInt(), start);
    }

    public void checkForUnreadHeader(ExtDataInput in) throws IOException {
        int actualHeaderSize = (int)(in.position() - this.startPosition);
        int exceedingSize = this.headerSize - actualHeaderSize;
        if (exceedingSize > 0) {
            byte[] buf = in.readBytes(exceedingSize);
            BigInteger exceedingBI = new BigInteger(1, buf);
            if (exceedingBI.equals(BigInteger.ZERO)) {
                LOGGER.fine(String.format("Chunk header size (%d), read (%d), but exceeding bytes are all zero.", this.headerSize, actualHeaderSize));
            } else {
                LOGGER.warning(String.format("Chunk header size (%d), read (%d). Exceeding bytes: 0x%X.", this.headerSize, actualHeaderSize, exceedingBI));
            }
        }
    }
}

