/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.Config;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.meta.ApkInfo;
import brut.androlib.meta.UsesFramework;
import brut.androlib.res.Framework;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.value.ResValue;
import brut.androlib.res.decoder.ARSCDecoder;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class ResTable {
    private static final Logger LOGGER = Logger.getLogger(ResTable.class.getName());
    private final ApkInfo mApkInfo;
    private final Config mConfig;
    private final Map<Integer, ResPackage> mPackagesById;
    private final Map<String, ResPackage> mPackagesByName;
    private ResPackage mMainPackage;
    private final Set<ResPackage> mLibPackages;
    private final Set<ResPackage> mFramePackages;
    private final Map<Integer, String> mDynamicRefTable;

    public ResTable(ApkInfo apkInfo, Config config) {
        this.mApkInfo = apkInfo;
        this.mConfig = config;
        this.mPackagesById = new HashMap<Integer, ResPackage>();
        this.mPackagesByName = new HashMap<String, ResPackage>();
        this.mLibPackages = new HashSet<ResPackage>();
        this.mFramePackages = new HashSet<ResPackage>();
        this.mDynamicRefTable = new LinkedHashMap<Integer, String>();
    }

    public ApkInfo getApkInfo() {
        return this.mApkInfo;
    }

    public Config getConfig() {
        return this.mConfig;
    }

    public boolean isMainPackageLoaded() {
        return this.mMainPackage != null;
    }

    public ResPackage getMainPackage() throws AndrolibException {
        if (this.mMainPackage == null) {
            throw new AndrolibException("Main package has not been loaded");
        }
        return this.mMainPackage;
    }

    public void loadMainPackage() throws AndrolibException {
        ResPackage pkg;
        LOGGER.info("Loading resource table...");
        ExtFile apkFile = this.mApkInfo.getApkFile();
        ResPackage[] pkgs = this.loadResPackagesFromApk(apkFile, this.mConfig.isKeepBrokenResources());
        switch (pkgs.length) {
            case 0: {
                pkg = new ResPackage(this, 0, null);
                break;
            }
            case 1: {
                pkg = pkgs[0];
                break;
            }
            case 2: {
                LOGGER.warning("Skipping package group: " + pkgs[0].getName());
                pkg = pkgs[1];
                break;
            }
            default: {
                pkg = this.selectPackageWithMostResSpecs(pkgs);
            }
        }
        this.registerPackage(pkg);
        this.mMainPackage = pkg;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ResPackage[] loadResPackagesFromApk(File apkFile, boolean keepBrokenResources) throws AndrolibException {
        try (ExtFile inFile = new ExtFile(apkFile);){
            ResPackage[] resPackageArray;
            try (BufferedInputStream in = new BufferedInputStream(inFile.getDirectory().getFileInput("resources.arsc"));){
                ARSCDecoder decoder = new ARSCDecoder(in, this, false, keepBrokenResources);
                resPackageArray = decoder.decode().getPackages();
            }
            return resPackageArray;
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException("Could not load resources.arsc from file: " + apkFile, ex);
        }
    }

    private ResPackage selectPackageWithMostResSpecs(ResPackage[] pkgs) {
        int count = 0;
        int index = 0;
        for (int i = 0; i < pkgs.length; ++i) {
            ResPackage pkg = pkgs[i];
            if (pkg.getResSpecCount() <= count || pkg.getName().equals("android")) continue;
            count = pkg.getResSpecCount();
            index = i;
        }
        return pkgs[index];
    }

    private void registerPackage(ResPackage pkg) throws AndrolibException {
        Integer id = pkg.getId();
        if (this.mPackagesById.containsKey(id)) {
            throw new AndrolibException("Multiple packages: id=" + id);
        }
        String name = pkg.getName();
        if (this.mPackagesByName.containsKey(name)) {
            throw new AndrolibException("Multiple packages: name=" + name);
        }
        this.mPackagesById.put(id, pkg);
        this.mPackagesByName.put(name, pkg);
    }

    public ResPackage getCurrentPackage() throws AndrolibException {
        if (this.mMainPackage == null) {
            return this.getPackage(1);
        }
        return this.mMainPackage;
    }

    public ResPackage getPackage(String name) throws AndrolibException {
        ResPackage pkg = this.mPackagesByName.get(name);
        if (pkg == null) {
            throw new UndefinedResObjectException("package: name=" + name);
        }
        return pkg;
    }

    public ResPackage getPackage(int id) throws AndrolibException {
        ResPackage pkg = this.mPackagesById.get(id);
        if (pkg == null && (pkg = this.loadLibraryPackage(id)) == null) {
            pkg = this.loadFrameworkPackage(id);
        }
        return pkg;
    }

    private ResPackage loadLibraryPackage(int id) throws AndrolibException {
        String name = this.mDynamicRefTable.get(id);
        String[] libFiles = this.mConfig.getLibraryFiles();
        File apkFile = null;
        if (name != null && libFiles != null) {
            for (String libEntry : libFiles) {
                String[] parts = libEntry.split(":", 2);
                if (parts.length != 2 || !name.equals(parts[0])) continue;
                apkFile = new File(parts[1]);
                break;
            }
        }
        if (apkFile == null) {
            return null;
        }
        ResPackage pkg = this.loadResPackageFromApk(apkFile, true);
        if (id != pkg.getId()) {
            throw new AndrolibException("Expected pkg of id: " + id + ", got: " + pkg.getId());
        }
        if (!name.equals(pkg.getName())) {
            throw new AndrolibException("Expected pkg of name: " + name + ", got: " + pkg.getName());
        }
        this.registerPackage(pkg);
        this.mLibPackages.add(pkg);
        return pkg;
    }

    private ResPackage loadFrameworkPackage(int id) throws AndrolibException {
        Framework framework = new Framework(this.mConfig);
        File apkFile = framework.getApkFile(id, this.mConfig.getFrameworkTag());
        ResPackage pkg = this.loadResPackageFromApk(apkFile, true);
        if (id != pkg.getId()) {
            throw new AndrolibException("Expected pkg of id: " + id + ", got: " + pkg.getId());
        }
        this.registerPackage(pkg);
        this.mFramePackages.add(pkg);
        return pkg;
    }

    private ResPackage loadResPackageFromApk(File apkFile, boolean keepBrokenResources) throws AndrolibException {
        ResPackage pkg;
        LOGGER.info("Loading resource table from file: " + apkFile);
        ResPackage[] pkgs = this.loadResPackagesFromApk(apkFile, keepBrokenResources);
        switch (pkgs.length) {
            case 0: {
                throw new AndrolibException("Arsc file with zero packages");
            }
            case 1: {
                pkg = pkgs[0];
                break;
            }
            default: {
                pkg = this.selectPackageWithMostResSpecs(pkgs);
            }
        }
        return pkg;
    }

    public ResResSpec getResSpec(int resId) throws AndrolibException {
        if (resId >> 24 == 0) {
            resId = resId & 0xFFFFFF | this.mMainPackage.getId() << 24;
        }
        return this.getResSpec(new ResID(resId));
    }

    public ResResSpec getResSpec(ResID resId) throws AndrolibException {
        return this.getPackage(resId.getPackageId()).getResSpec(resId);
    }

    public ResValue getValue(String pkg, String type, String name) throws AndrolibException {
        return this.getPackage(pkg).getType(type).getResSpec(name).getDefaultResource().getValue();
    }

    public void addDynamicRefPackage(int pkgId, String pkgName) {
        this.mDynamicRefTable.put(pkgId, pkgName);
    }

    public int getDynamicRefPackageId(String pkgName) {
        for (Map.Entry<Integer, String> entry : this.mDynamicRefTable.entrySet()) {
            if (!pkgName.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return 0;
    }

    public void updateApkInfo() {
        if (this.mMainPackage != null) {
            this.mApkInfo.getPackageInfo().setForcedPackageId(Integer.toString(this.mMainPackage.getId()));
        }
        if (!this.mFramePackages.isEmpty()) {
            UsesFramework usesFramework = this.mApkInfo.getUsesFramework();
            List<Integer> frameworkIds = usesFramework.getIds();
            int[] ids = new int[this.mFramePackages.size()];
            int i = 0;
            for (ResPackage pkg : this.mFramePackages) {
                ids[i++] = pkg.getId();
            }
            Arrays.sort(ids);
            Object object = ids;
            int n = ((Object)object).length;
            for (int j = 0; j < n; ++j) {
                Object id = object[j];
                frameworkIds.add((int)id);
            }
            usesFramework.setTag(this.mConfig.getFrameworkTag());
        }
        if (!this.mLibPackages.isEmpty()) {
            List<String> usesLibrary = this.mApkInfo.getUsesLibrary();
            int[] ids = new int[this.mLibPackages.size()];
            int i = 0;
            for (ResPackage pkg : this.mLibPackages) {
                ids[i++] = pkg.getId();
            }
            Arrays.sort(ids);
            for (Object id : (Object)ids) {
                usesLibrary.add(this.mDynamicRefTable.get((int)id));
            }
        }
    }
}

