/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.baksmali.Adaptors.Debug;

import com.android.tools.smali.baksmali.Adaptors.ClassDefinition;
import com.android.tools.smali.baksmali.Adaptors.Debug.DebugMethodItem;
import com.android.tools.smali.baksmali.Adaptors.Debug.LocalFormatter;
import com.android.tools.smali.baksmali.Adaptors.RegisterFormatter;
import com.android.tools.smali.baksmali.formatter.BaksmaliWriter;
import com.android.tools.smali.dexlib2.iface.debug.RestartLocal;
import java.io.IOException;
import javax.annotation.Nonnull;

public class RestartLocalMethodItem
extends DebugMethodItem {
    @Nonnull
    private final ClassDefinition classDef;
    @Nonnull
    private final RestartLocal restartLocal;
    @Nonnull
    private final RegisterFormatter registerFormatter;

    public RestartLocalMethodItem(@Nonnull ClassDefinition classDef, int codeAddress, int sortOrder, @Nonnull RegisterFormatter registerFormatter, @Nonnull RestartLocal restartLocal) {
        super(codeAddress, sortOrder);
        this.classDef = classDef;
        this.restartLocal = restartLocal;
        this.registerFormatter = registerFormatter;
    }

    @Override
    public boolean writeTo(BaksmaliWriter writer) throws IOException {
        writer.write(".restart local ");
        this.registerFormatter.writeTo(writer, this.restartLocal.getRegister());
        String name = this.restartLocal.getName();
        String type = this.restartLocal.getType();
        String signature = this.restartLocal.getSignature();
        if (name != null || type != null || signature != null) {
            writer.write("    # ");
            LocalFormatter.writeLocal(writer, name, type, signature);
        }
        return true;
    }
}

