/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.search.Sort;
import org.apache.lucene.util.InfoStream;
import org.apache.solr.common.ConfigNode;
import org.apache.solr.common.MapSerializable;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.XmlConfigFile;
import org.apache.solr.index.DefaultMergePolicyFactory;
import org.apache.solr.index.MergePolicyFactory;
import org.apache.solr.index.MergePolicyFactoryArgs;
import org.apache.solr.index.SortingMergePolicy;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.update.LoggingInfoStream;
import org.apache.solr.util.SolrPluginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrIndexConfig
implements MapSerializable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String[] NO_SUB_PACKAGES = new String[0];
    private static final String DEFAULT_MERGE_POLICY_FACTORY_CLASSNAME = DefaultMergePolicyFactory.class.getName();
    public static final String DEFAULT_MERGE_SCHEDULER_CLASSNAME = ConcurrentMergeScheduler.class.getName();
    public final boolean useCompoundFile;
    public final int maxBufferedDocs;
    public final double ramBufferSizeMB;
    public final int ramPerThreadHardLimitMB;
    public final int maxCommitMergeWaitMillis;
    public final int writeLockTimeout;
    public final String lockType;
    public final PluginInfo mergePolicyFactoryInfo;
    public final PluginInfo mergeSchedulerInfo;
    public final PluginInfo metricsInfo;
    public final PluginInfo mergedSegmentWarmerInfo;
    public InfoStream infoStream = InfoStream.NO_OUTPUT;
    private ConfigNode node;

    private SolrIndexConfig() {
        this.useCompoundFile = false;
        this.maxBufferedDocs = -1;
        this.ramBufferSizeMB = 100.0;
        this.ramPerThreadHardLimitMB = -1;
        this.maxCommitMergeWaitMillis = -1;
        this.writeLockTimeout = -1;
        this.lockType = "native";
        this.mergePolicyFactoryInfo = null;
        this.mergeSchedulerInfo = null;
        this.mergedSegmentWarmerInfo = null;
        this.metricsInfo = new PluginInfo("metrics", Collections.emptyMap(), null, null);
    }

    private ConfigNode get(String s) {
        return this.node.get(s);
    }

    public SolrIndexConfig(SolrConfig cfg, SolrIndexConfig def) {
        this(cfg.get("indexConfig"), def);
    }

    public SolrIndexConfig(ConfigNode cfg, SolrIndexConfig def) {
        this.node = cfg;
        if (def == null) {
            def = new SolrIndexConfig();
        }
        XmlConfigFile.assertWarnOrFail("The <mergeScheduler>myclass</mergeScheduler> syntax is no longer supported in solrconfig.xml. Please use syntax <mergeScheduler class=\"myclass\"/> instead.", this.get("mergeScheduler").isNull() || this.get("mergeScheduler").attr("class") != null, true);
        XmlConfigFile.assertWarnOrFail("Beginning with Solr 7.0, <mergePolicy>myclass</mergePolicy> is no longer supported, use <mergePolicyFactory> instead.", this.get("mergePolicy").isNull() || this.get("mergePolicy").attr("class") != null, true);
        XmlConfigFile.assertWarnOrFail("The <luceneAutoCommit>true|false</luceneAutoCommit> parameter is no longer valid in solrconfig.xml.", this.get("luceneAutoCommit").isNull(), true);
        this.useCompoundFile = this.get("useCompoundFile").boolVal(def.useCompoundFile);
        this.maxBufferedDocs = this.get("maxBufferedDocs").intVal(def.maxBufferedDocs);
        this.ramBufferSizeMB = this.get("ramBufferSizeMB").doubleVal(def.ramBufferSizeMB);
        this.maxCommitMergeWaitMillis = this.get("maxCommitMergeWaitTime").intVal(def.maxCommitMergeWaitMillis);
        this.ramPerThreadHardLimitMB = this.get("ramPerThreadHardLimitMB").intVal(def.ramPerThreadHardLimitMB);
        this.writeLockTimeout = this.get("writeLockTimeout").intVal(def.writeLockTimeout);
        this.lockType = this.get("lockType").txt(def.lockType);
        this.metricsInfo = this.getPluginInfo(this.get("metrics"), def.metricsInfo);
        this.mergeSchedulerInfo = this.getPluginInfo(this.get("mergeScheduler"), def.mergeSchedulerInfo);
        this.mergePolicyFactoryInfo = this.getPluginInfo(this.get("mergePolicyFactory"), def.mergePolicyFactoryInfo);
        XmlConfigFile.assertWarnOrFail("Beginning with Solr 7.0, <mergePolicy> is no longer supported, use <mergePolicyFactory> instead.", this.get("mergePolicy").isNull(), true);
        XmlConfigFile.assertWarnOrFail("Beginning with Solr 7.0, <maxMergeDocs> is no longer supported, configure it on the relevant <mergePolicyFactory> instead.", this.get("maxMergeDocs").isNull(), true);
        XmlConfigFile.assertWarnOrFail("Beginning with Solr 7.0, <mergeFactor> is no longer supported, configure it on the relevant <mergePolicyFactory> instead.", this.get("maxMergeFactor").isNull(), true);
        if (this.get("termIndexInterval").exists()) {
            throw new IllegalArgumentException("Illegal parameter 'termIndexInterval'");
        }
        if (this.get("infoStream").boolVal(false)) {
            if (this.get("infoStream").attr("file") == null) {
                log.info("IndexWriter infoStream solr logging is enabled");
                this.infoStream = new LoggingInfoStream();
            } else {
                throw new IllegalArgumentException("Remove @file from <infoStream> to output messages to solr's logfile");
            }
        }
        this.mergedSegmentWarmerInfo = this.getPluginInfo(this.get("mergedSegmentWarmer"), def.mergedSegmentWarmerInfo);
        XmlConfigFile.assertWarnOrFail("Beginning with Solr 5.0, <checkIntegrityAtMerge> option is no longer supported and should be removed from solrconfig.xml (these integrity checks are now automatic)", this.get("checkIntegrityAtMerge").isNull(), true);
    }

    public Map<String, Object> toMap(Map<String, Object> map) {
        Map m = Utils.makeMap((Object[])new Object[]{"useCompoundFile", this.useCompoundFile, "maxBufferedDocs", this.maxBufferedDocs, "ramBufferSizeMB", this.ramBufferSizeMB, "ramPerThreadHardLimitMB", this.ramPerThreadHardLimitMB, "maxCommitMergeWaitTime", this.maxCommitMergeWaitMillis, "writeLockTimeout", this.writeLockTimeout, "lockType", this.lockType, "infoStreamEnabled", this.infoStream != InfoStream.NO_OUTPUT});
        if (this.mergeSchedulerInfo != null) {
            m.put("mergeScheduler", this.mergeSchedulerInfo);
        }
        if (this.metricsInfo != null) {
            m.put("metrics", this.metricsInfo);
        }
        if (this.mergePolicyFactoryInfo != null) {
            m.put("mergePolicyFactory", this.mergePolicyFactoryInfo);
        }
        if (this.mergedSegmentWarmerInfo != null) {
            m.put("mergedSegmentWarmer", this.mergedSegmentWarmerInfo);
        }
        return m;
    }

    private PluginInfo getPluginInfo(ConfigNode node, PluginInfo def) {
        return node != null && node.exists() ? new PluginInfo(node, "[solrconfig.xml] " + node.name(), false, false) : def;
    }

    public IndexWriterConfig toIndexWriterConfig(SolrCore core) throws IOException {
        IndexSchema schema = core.getLatestSchema();
        IndexWriterConfig iwc = new IndexWriterConfig((Analyzer)new DelayedSchemaAnalyzer(core));
        if (this.maxBufferedDocs != -1) {
            iwc.setMaxBufferedDocs(this.maxBufferedDocs);
        }
        if (this.ramBufferSizeMB != -1.0) {
            iwc.setRAMBufferSizeMB(this.ramBufferSizeMB);
        }
        if (this.ramPerThreadHardLimitMB != -1) {
            iwc.setRAMPerThreadHardLimitMB(this.ramPerThreadHardLimitMB);
        }
        if (this.maxCommitMergeWaitMillis > 0) {
            iwc.setMaxFullFlushMergeWaitMillis((long)this.maxCommitMergeWaitMillis);
        }
        iwc.setSimilarity(schema.getSimilarity());
        MergePolicy mergePolicy = this.buildMergePolicy(core.getResourceLoader(), schema);
        iwc.setMergePolicy(mergePolicy);
        MergeScheduler mergeScheduler = this.buildMergeScheduler(core.getResourceLoader());
        iwc.setMergeScheduler(mergeScheduler);
        iwc.setInfoStream(this.infoStream);
        if (mergePolicy instanceof SortingMergePolicy) {
            Sort indexSort = ((SortingMergePolicy)mergePolicy).getSort();
            iwc.setIndexSort(indexSort);
        }
        iwc.setUseCompoundFile(this.useCompoundFile);
        if (this.mergedSegmentWarmerInfo != null) {
            IndexWriter.IndexReaderWarmer warmer = core.getResourceLoader().newInstance(this.mergedSegmentWarmerInfo.className, IndexWriter.IndexReaderWarmer.class, null, new Class[]{InfoStream.class}, new Object[]{iwc.getInfoStream()});
            iwc.setMergedSegmentWarmer(warmer);
        }
        return iwc;
    }

    private MergePolicy buildMergePolicy(SolrResourceLoader resourceLoader, IndexSchema schema) {
        MergePolicyFactoryArgs mpfArgs;
        String mpfClassName;
        if (this.mergePolicyFactoryInfo == null) {
            mpfClassName = DEFAULT_MERGE_POLICY_FACTORY_CLASSNAME;
            mpfArgs = new MergePolicyFactoryArgs();
        } else {
            mpfClassName = this.mergePolicyFactoryInfo.className;
            mpfArgs = new MergePolicyFactoryArgs((Iterable<Map.Entry<String, Object>>)this.mergePolicyFactoryInfo.initArgs);
        }
        MergePolicyFactory mpf = resourceLoader.newInstance(mpfClassName, MergePolicyFactory.class, NO_SUB_PACKAGES, new Class[]{SolrResourceLoader.class, MergePolicyFactoryArgs.class, IndexSchema.class}, new Object[]{resourceLoader, mpfArgs, schema});
        return mpf.getMergePolicy();
    }

    private MergeScheduler buildMergeScheduler(SolrResourceLoader resourceLoader) {
        String msClassName = this.mergeSchedulerInfo == null ? DEFAULT_MERGE_SCHEDULER_CLASSNAME : this.mergeSchedulerInfo.className;
        MergeScheduler scheduler = resourceLoader.newInstance(msClassName, MergeScheduler.class);
        if (this.mergeSchedulerInfo != null) {
            if (scheduler instanceof ConcurrentMergeScheduler) {
                Integer maxThreadCount;
                NamedList args = this.mergeSchedulerInfo.initArgs.clone();
                Integer maxMergeCount = (Integer)args.remove("maxMergeCount");
                if (maxMergeCount == null) {
                    maxMergeCount = ((ConcurrentMergeScheduler)scheduler).getMaxMergeCount();
                }
                if ((maxThreadCount = (Integer)args.remove("maxThreadCount")) == null) {
                    maxThreadCount = ((ConcurrentMergeScheduler)scheduler).getMaxThreadCount();
                }
                ((ConcurrentMergeScheduler)scheduler).setMaxMergesAndThreads(maxMergeCount.intValue(), maxThreadCount.intValue());
                Boolean ioThrottle = (Boolean)args.remove("ioThrottle");
                if (ioThrottle != null && !ioThrottle.booleanValue()) {
                    ((ConcurrentMergeScheduler)scheduler).disableAutoIOThrottle();
                }
                SolrPluginUtils.invokeSetters(scheduler, (Iterable<Map.Entry<String, Object>>)args);
            } else {
                SolrPluginUtils.invokeSetters(scheduler, (Iterable<Map.Entry<String, Object>>)this.mergeSchedulerInfo.initArgs);
            }
        }
        return scheduler;
    }

    private static class DelayedSchemaAnalyzer
    extends DelegatingAnalyzerWrapper {
        private final SolrCore core;

        public DelayedSchemaAnalyzer(SolrCore core) {
            super(PER_FIELD_REUSE_STRATEGY);
            this.core = core;
        }

        protected Analyzer getWrappedAnalyzer(String fieldName) {
            return this.core.getLatestSchema().getIndexAnalyzer();
        }
    }
}

